/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.activity.candsetsal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.activity.ActivityBaseDynHelper;
import kd.swc.hcdm.business.activity.ActivityDealHelper;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActDynHelper;
import kd.swc.hcdm.business.activity.dealer.AbstractActivityDealer;
import kd.swc.hcdm.common.enums.ActivityErrorEnum;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class CandSetSalActHelper {
    private static Log LOGGER = LogFactory.getLog(AbstractActivityDealer.class);

    public static Set<Long> updateActStatus(List<DynamicObject> candidateSetSalActs, List<Map<String, Object>> applyResults) {
        if (CollectionUtils.isEmpty(candidateSetSalActs)) {
            return null;
        }
        if (CollectionUtils.isEmpty(applyResults)) {
            LOGGER.info("CandSetSalActService updateActStatus applyResults is null...{}", candidateSetSalActs);
            applyResults = Lists.newArrayListWithCapacity((int)0);
        }
        Map<Long, Map> onbrdIdToApplyMap = applyResults.stream().collect(Collectors.toMap(obj -> (Long)obj.get("onbrdinfoid"), obj -> obj));
        HashSet applyIds = Sets.newHashSetWithExpectedSize((int)applyResults.size());
        HashMap needQueryActBaseDynMap = Maps.newHashMapWithExpectedSize((int)candidateSetSalActs.size());
        for (DynamicObject candidateSetSalAct : candidateSetSalActs) {
            long onbrdInfoId = candidateSetSalAct.getLong("onbrdinfoid");
            DynamicObject actBaseDyn = candidateSetSalAct.getDynamicObject("activitybase");
            Map applyResult = onbrdIdToApplyMap.get(onbrdInfoId);
            if (CollectionUtils.isEmpty((Map)applyResult)) {
                LOGGER.info("CandSetSalActService updateActStatus applyResult is null: {}", (Object)candidateSetSalAct);
                ActivityDealHelper.logErrorInfo(actBaseDyn, false, ActivityErrorEnum.CREATEAPPLY, "applyResult is null");
                continue;
            }
            boolean isSuccess = (Boolean)applyResult.get("success");
            if (!isSuccess) {
                String msg = (String)applyResult.get("message");
                LOGGER.info("createApply onbrdInfoId = {} error: {}", (Object)onbrdInfoId, (Object)msg);
                ActivityDealHelper.logErrorInfo(actBaseDyn, false, ActivityErrorEnum.CREATEAPPLY, msg);
                continue;
            }
            Long applyId = (Long)applyResult.get("candsetsalapplid");
            candidateSetSalAct.set("candsetsalapplid", (Object)applyId);
            candidateSetSalAct.set("candsetsalapplnum", applyResult.get("candsetsalapplnum"));
            String billStatus = MapUtils.getString((Map)applyResult, (Object)"billstatus");
            String actStatus = actBaseDyn.getString("activitystatus");
            if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A") || StringUtils.equals((CharSequence)billStatus, (CharSequence)"B") || StringUtils.equals((CharSequence)billStatus, (CharSequence)"G") || StringUtils.equals((CharSequence)billStatus, (CharSequence)"D")) {
                actBaseDyn.set("activitystatus", (Object)"10");
            } else if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"C") && !StringUtils.equals((CharSequence)actStatus, (CharSequence)"30") && !StringUtils.equals((CharSequence)actStatus, (CharSequence)"20")) {
                needQueryActBaseDynMap.put(actBaseDyn.getLong("id"), actBaseDyn);
            }
            ActivityDealHelper.logErrorInfo(actBaseDyn, true, null, null);
            applyIds.add(applyId);
        }
        if (!CollectionUtils.isEmpty((Map)needQueryActBaseDynMap)) {
            CandSetSalActHelper.queryNewActBaseInfo(needQueryActBaseDynMap);
        }
        return applyIds;
    }

    private static void queryNewActBaseInfo(Map<Long, DynamicObject> needQueryActBaseDynMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_activitybase");
        DynamicObject[] newActBaseDyns = serviceHelper.query("id,activitystatus", new QFilter[]{new QFilter("id", "in", needQueryActBaseDynMap.keySet())});
        if (newActBaseDyns == null) {
            return;
        }
        for (DynamicObject newActBaseDyn : newActBaseDyns) {
            long id = newActBaseDyn.getLong("id");
            DynamicObject oldActBaseDyn = needQueryActBaseDynMap.get(id);
            if (oldActBaseDyn == null) continue;
            oldActBaseDyn.set("activitystatus", newActBaseDyn.get("activitystatus"));
        }
    }

    public static void saveAct(List<DynamicObject> candidateSetSalActs) {
        if (CollectionUtils.isEmpty(candidateSetSalActs)) {
            return;
        }
        Set<DynamicObject> actBaseDyns = candidateSetSalActs.stream().map(obj -> obj.getDynamicObject("activitybase")).collect(Collectors.toSet());
        ActivityBaseDynHelper.save(candidateSetSalActs.toArray(new DynamicObject[candidateSetSalActs.size()]));
        CandSetSalActDynHelper.save(actBaseDyns.toArray(new DynamicObject[actBaseDyns.size()]));
    }

    public static boolean isBeforeEntryPushCandSetSalBill() {
        Long paramCfgId = 1944179397447685120L;
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)paramCfgId);
        if (paramMap == null || paramMap.size() == 0) {
            return false;
        }
        return StringUtils.equals((CharSequence)MapUtils.getString((Map)paramMap, (Object)"pushcandsetsaltime"), (CharSequence)"beforeentry");
    }
}

