/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.activity.dealer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.activity.ActInstanceHelper;
import kd.swc.hcdm.business.activity.ActivityBaseDynHelper;
import kd.swc.hcdm.business.activity.ActivityDealHelper;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActDynHelper;
import kd.swc.hcdm.business.activity.dealer.ActivityDealer;
import kd.swc.hcdm.business.activity.msg.ActivityMsgHelper;
import kd.swc.hcdm.common.enums.ActivityErrorEnum;
import kd.swc.hcdm.common.enums.ActivityMsgSceneEnum;

public abstract class AbstractActivityDealer
implements ActivityDealer {
    private static Log LOGGER = LogFactory.getLog(AbstractActivityDealer.class);

    @Override
    public DynamicObject generateActivity(String bindBizKey, String bizBillKey, Long bizBillId, Long instanceId) {
        DynamicObject activityBase = this.createActivityBase(instanceId);
        DynamicObject bizActivity = this.createBizActivity(activityBase, bizBillKey, bizBillId);
        if (this.isExistsAct(instanceId)) {
            LOGGER.info("AbstractActivityDealer generateActivity activityins already exist act: {}", (Object)instanceId);
            return null;
        }
        this.saveAct(activityBase, bizActivity);
        this.afterCreateAndSaveAct(activityBase, bizActivity);
        try {
            ActivityMsgHelper.sendMsgByInstanceId(instanceId, ActivityMsgSceneEnum.CANDSETSALACT_START);
        }
        catch (Exception e) {
            LOGGER.error("AbstractActivityDealer generateActivity sendMsgByInstanceId error:", (Throwable)e);
        }
        return bizActivity;
    }

    protected void saveAct(DynamicObject activityBase, DynamicObject bizActivity) {
        try (TXHandle txHandle = TX.requiresNew();){
            ActivityBaseDynHelper.saveOne(activityBase);
            this.saveBizActivity(bizActivity);
        }
    }

    protected void afterCreateAndSaveAct(DynamicObject activityBase, DynamicObject bizActivity) {
    }

    protected boolean isExistsAct(Long instanceId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_activitybase");
        QFilter filter = new QFilter("activityins", "=", (Object)instanceId);
        filter.and("activitystatus", "!=", (Object)"40");
        return serviceHelper.isExists(filter);
    }

    protected abstract void saveBizActivity(DynamicObject var1);

    @Override
    public DynamicObject createBizActivity(DynamicObject activityBase, String bizBillKey, Long bizBillId) {
        this.fillActBaseFields(activityBase);
        DynamicObject businessAct = this.doCreateBusinessAct(activityBase, bizBillKey, bizBillId);
        return businessAct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchConsentActivity(DynamicObject[] bizActDyns) {
        if (bizActDyns == null || bizActDyns.length == 0) {
            return;
        }
        List<DynamicObject> actBaseDynList = this.consentActivityBase(bizActDyns);
        List<DynamicObject> bizActDynList = this.consentBizActivity(bizActDyns);
        try (TXHandle txHandle = TX.required();){
            ActivityBaseDynHelper.save(actBaseDynList.toArray(new DynamicObject[actBaseDynList.size()]));
            CandSetSalActDynHelper.save(bizActDynList.toArray(new DynamicObject[bizActDynList.size()]));
        }
    }

    protected abstract List<DynamicObject> consentBizActivity(DynamicObject[] var1);

    protected List<DynamicObject> consentActivityBase(DynamicObject[] bizActDyns) {
        Set<Long> alreadyConsentInsId;
        ArrayList actBaseDynList = Lists.newArrayListWithExpectedSize((int)bizActDyns.length);
        ArrayList actInsIds = Lists.newArrayListWithExpectedSize((int)actBaseDynList.size());
        for (DynamicObject bizActDyn : bizActDyns) {
            DynamicObject actBaseDyn = bizActDyn.getDynamicObject("activitybase");
            if (actBaseDyn == null) continue;
            actBaseDynList.add(actBaseDyn);
            long actInsId = actBaseDyn.getLong("activityins.id");
            actInsIds.add(actInsId);
        }
        if (CollectionUtils.isEmpty((Collection)actBaseDynList)) {
            return actBaseDynList;
        }
        OperationResult result = null;
        try {
            result = ActInstanceHelper.batchConsentTask(actInsIds);
        }
        catch (Exception e) {
            LOGGER.info("AbstractActivityDealer consentActivityBase batchConsentTask error:", (Object)e);
            actBaseDynList.forEach(obj -> ActivityDealHelper.logErrorInfo(obj, false, ActivityErrorEnum.STOPACTIVITY, e.toString()));
            return actBaseDynList;
        }
        Map<Long, String> errorMap = ActivityDealHelper.getErrorMap(result);
        if (!CollectionUtils.isEmpty(errorMap) && !CollectionUtils.isEmpty(alreadyConsentInsId = ActInstanceHelper.getAlreadyConsentInsId(actInsIds))) {
            alreadyConsentInsId.forEach(obj -> {
                String cfr_ignored_0 = (String)errorMap.remove(obj);
            });
        }
        long userId = RequestContext.get().getCurrUserId();
        Date nowDate = new Date();
        for (DynamicObject actBaseDyn : actBaseDynList) {
            long actInsId = actBaseDyn.getLong("activityins.id");
            String errorMsg = errorMap.get(actInsId);
            if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                ActivityDealHelper.logErrorInfo(actBaseDyn, false, ActivityErrorEnum.STOPACTIVITY, errorMsg);
            } else {
                actBaseDyn.set("activitystatus", (Object)"30");
                ActivityDealHelper.logErrorInfo(actBaseDyn, true, null, null);
            }
            actBaseDyn.set("modifier", (Object)userId);
            actBaseDyn.set("modifytime", (Object)nowDate);
        }
        return actBaseDynList;
    }

    @Override
    public void batchCancelActivity(DynamicObject[] bizActDyns, String cancelOp) {
        if (bizActDyns == null || bizActDyns.length == 0) {
            return;
        }
        ArrayList allActBaseDyns = Lists.newArrayListWithCapacity((int)bizActDyns.length);
        ArrayList cancelBizActDyns = Lists.newArrayListWithCapacity((int)bizActDyns.length);
        ArrayList cancelActBaseDyns = Lists.newArrayListWithCapacity((int)bizActDyns.length);
        HashMap applyAndActBaseMap = Maps.newHashMapWithExpectedSize((int)bizActDyns.length);
        HashMap actInsAndActBaseMap = Maps.newHashMapWithExpectedSize((int)bizActDyns.length);
        for (DynamicObject bizActDyn : bizActDyns) {
            String actStatus = bizActDyn.getString("activitybase.activitystatus");
            String errorType = bizActDyn.getString("activitybase.errortype");
            long actInsId = bizActDyn.getLong("activitybase.activityins.id");
            long applyId = bizActDyn.getLong("candsetsalapplid");
            DynamicObject actBase = bizActDyn.getDynamicObject("activitybase");
            allActBaseDyns.add(actBase);
            if (!StringUtils.equals((CharSequence)actStatus, (CharSequence)"40")) {
                cancelBizActDyns.add(bizActDyn);
                cancelActBaseDyns.add(actBase);
                if (applyId != 0L) {
                    applyAndActBaseMap.put(applyId, actBase);
                }
                actInsAndActBaseMap.put(actInsId, actBase);
                continue;
            }
            if (StringUtils.equals((CharSequence)ActivityErrorEnum.APPLYANDACTINS.getCode(), (CharSequence)errorType)) {
                if (applyId != 0L) {
                    applyAndActBaseMap.put(applyId, actBase);
                }
                actInsAndActBaseMap.put(actInsId, actBase);
                continue;
            }
            if (StringUtils.equals((CharSequence)ActivityErrorEnum.CANCELAPPLYWORKFLOW.getCode(), (CharSequence)errorType)) {
                if (applyId == 0L) continue;
                applyAndActBaseMap.put(applyId, actBase);
                continue;
            }
            if (!StringUtils.equals((CharSequence)ActivityErrorEnum.TERMINATEACTIVITY.getCode(), (CharSequence)errorType)) continue;
            actInsAndActBaseMap.put(actInsId, actBase);
        }
        if (!CollectionUtils.isEmpty((Collection)cancelBizActDyns)) {
            this.doBatchCancelActivity(cancelBizActDyns, cancelActBaseDyns);
        }
        String msg = "";
        if (!CollectionUtils.isEmpty((Map)applyAndActBaseMap)) {
            msg = msg + this.cancelWorkFlow(applyAndActBaseMap);
        }
        if ("2".equals(cancelOp) && !CollectionUtils.isEmpty((Map)actInsAndActBaseMap)) {
            msg = msg + this.cancelActIns(actInsAndActBaseMap);
        }
        List<Object> logActBaseDyns = new ArrayList<DynamicObject>(0);
        if (!CollectionUtils.isEmpty((Collection)allActBaseDyns)) {
            logActBaseDyns = allActBaseDyns.stream().filter(obj -> !obj.getBoolean("isactright")).collect(Collectors.toList());
        }
        if (StringUtils.isEmpty((CharSequence)msg)) {
            if (!CollectionUtils.isEmpty(logActBaseDyns)) {
                ActivityDealHelper.saveErrorInfo(logActBaseDyns, true, null, null);
            }
        } else {
            if (!CollectionUtils.isEmpty(logActBaseDyns)) {
                ActivityBaseDynHelper.save(logActBaseDyns.toArray(new DynamicObject[logActBaseDyns.size()]));
            }
            throw new KDBizException("batchCancelActivity error: " + msg);
        }
    }

    protected abstract String cancelWorkFlow(Map<Long, DynamicObject> var1);

    protected void doBatchCancelActivity(List<DynamicObject> cancelBizActDyns, List<DynamicObject> cancelActBaseDyns) {
        try (TXHandle txHandle = TX.requiresNew();){
            this.cancelBizActivity(cancelBizActDyns);
            this.cancelActivityBase(cancelActBaseDyns);
        }
    }

    protected abstract void cancelBizActivity(List<DynamicObject> var1);

    protected abstract void fillActBaseFields(DynamicObject var1);

    protected abstract DynamicObject doCreateBusinessAct(DynamicObject var1, String var2, Long var3);

    protected DynamicObject createActivityBase(Long instanceId) {
        DynamicObject activityBaseDyn = ActivityBaseDynHelper.createActBaseByInsId(instanceId);
        activityBaseDyn.set("id", (Object)ORM.create().genLongId("hcdm_activitybase"));
        return activityBaseDyn;
    }

    protected void cancelActivityBase(List<DynamicObject> actBaseDyns) {
        long userId = RequestContext.get().getCurrUserId();
        Date nowDate = new Date();
        for (DynamicObject actBaseDyn : actBaseDyns) {
            actBaseDyn.set("activitystatus", (Object)"40");
            actBaseDyn.set("modifier", (Object)userId);
            actBaseDyn.set("modifytime", (Object)nowDate);
        }
        ActivityBaseDynHelper.save(actBaseDyns.toArray(new DynamicObject[actBaseDyns.size()]));
    }

    public String cancelActIns(Map<Long, DynamicObject> actInsAndActBaseMap) {
        String msg = "";
        try {
            ActInstanceHelper.batchTerminateTask(Lists.newArrayList(actInsAndActBaseMap.keySet()));
        }
        catch (Exception e) {
            msg = "cancelActIns error" + e;
            LOGGER.error("AbstractActivityDealer cancelActIns error:", (Throwable)e);
            actInsAndActBaseMap.values().stream().forEach(obj -> ActivityDealHelper.logErrorInfo(obj, false, ActivityErrorEnum.TERMINATEACTIVITY, e.toString()));
        }
        return msg;
    }
}

