/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.activity.dealer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.activity.ActivityDealHelper;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActDynHelper;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActHelper;
import kd.swc.hcdm.business.activity.dealer.AbstractActivityDealer;
import kd.swc.hcdm.business.candidatesetsalaryappl.OnBrdInfoPushToCandSetSalApplService;
import kd.swc.hcdm.business.candidatesetsalaryappl.OnbrdBillHelper;
import kd.swc.hcdm.common.enums.ActivityErrorEnum;
import org.apache.commons.lang3.StringUtils;

public class CandSetSalActDealer
extends AbstractActivityDealer {
    private static Log LOGGER = LogFactory.getLog(AbstractActivityDealer.class);

    @Override
    protected void fillActBaseFields(DynamicObject activityBaseDyn) {
        activityBaseDyn.set("activitysource", (Object)"0");
    }

    @Override
    protected DynamicObject doCreateBusinessAct(DynamicObject activityBase, String bizBillKey, Long bizBillId) {
        DynamicObject onbrdBillDyn = OnbrdBillHelper.getOnbrdBillById(bizBillId);
        if (onbrdBillDyn == null) {
            LOGGER.info("CandSetSalActGenerater createBusinessAct return null, bizBillId is not exist: {}", (Object)bizBillId);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5165\u804c\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"CandSetSalActGenerater_0", (String)"swc-hcdm-business", (Object[])new Object[0]), bizBillId));
        }
        DynamicObject candidateSetSalAct = CandSetSalActDynHelper.createCanSetSalActDyn(activityBase, onbrdBillDyn);
        candidateSetSalAct.set("id", (Object)ORM.create().genLongId("hcdm_candsetsalact"));
        return candidateSetSalAct;
    }

    @Override
    protected void afterCreateAndSaveAct(DynamicObject activityBase, DynamicObject candidateSetSalAct) {
        try {
            if (CandSetSalActHelper.isBeforeEntryPushCandSetSalBill()) {
                LOGGER.info("CandSetSalActGenerater createApply start...");
                List<Map<String, Object>> result = this.createApply(candidateSetSalAct);
                CandSetSalActHelper.updateActStatus(Lists.newArrayList((Object[])new DynamicObject[]{candidateSetSalAct}), result);
            }
        }
        catch (Exception e) {
            LOGGER.info("CandSetSalActGenerater createBusinessAct error:", (Object)e);
            ActivityDealHelper.logErrorInfo(activityBase, false, ActivityErrorEnum.CREATEAPPLY, e.toString());
        }
        try {
            this.saveAct(activityBase, candidateSetSalAct);
        }
        catch (Exception e) {
            LOGGER.info("CandSetSalActGenerater afterCreateAndSaveAct saveAct error:", (Object)e);
        }
    }

    private List<Map<String, Object>> createApply(DynamicObject candidateSetSalAct) {
        HashMap onBrdInfoIdToActIdMap = Maps.newHashMapWithExpectedSize((int)1);
        onBrdInfoIdToActIdMap.put(candidateSetSalAct.getLong("onbrdinfoid"), candidateSetSalAct.getLong("id"));
        return OnBrdInfoPushToCandSetSalApplService.pushToCandSetSalAppl(onBrdInfoIdToActIdMap);
    }

    @Override
    protected void saveBizActivity(DynamicObject bizActivity) {
        CandSetSalActDynHelper.saveOne(bizActivity);
    }

    @Override
    protected List<DynamicObject> consentBizActivity(DynamicObject[] bizActDyns) {
        ArrayList candSetSalActDyns = Lists.newArrayListWithCapacity((int)bizActDyns.length);
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject candSetSalActDyn : bizActDyns) {
            DynamicObject actBaseDyn = candSetSalActDyn.getDynamicObject("activitybase");
            if (actBaseDyn == null) continue;
            long applyId = candSetSalActDyn.getLong("candsetsalapplid");
            if (applyId == 0L) {
                candSetSalActDyn.set("iscandsetsal", (Object)"0");
                candSetSalActDyn.set("modifier", (Object)currUserId);
                candSetSalActDyn.set("modifytime", (Object)currDate);
            }
            candSetSalActDyns.add(candSetSalActDyn);
        }
        return candSetSalActDyns;
    }

    @Override
    protected void cancelBizActivity(List<DynamicObject> bizActDyns) {
        if (CollectionUtils.isEmpty(bizActDyns)) {
            return;
        }
        Set<Long> candSetSalApplIds = bizActDyns.stream().map(obj -> obj.getLong("candsetsalapplid")).collect(Collectors.toSet());
        Map<Long, DynamicObject> candSetSalApplMap = this.queryCandSetSalAppl(candSetSalApplIds);
        HashSet candSetSalApplDeleteIds = Sets.newHashSetWithExpectedSize((int)candSetSalApplMap.size());
        ArrayList invaildCandSetSalAppls = Lists.newArrayListWithCapacity((int)candSetSalApplMap.size());
        ArrayList bizActUpdateDyns = Lists.newArrayListWithCapacity((int)bizActDyns.size());
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject bizActDyn : bizActDyns) {
            long candSetSalApplId = bizActDyn.getLong("candsetsalapplid");
            DynamicObject candSetSalApplDyn = candSetSalApplMap.get(candSetSalApplId);
            if (candSetSalApplDyn == null) continue;
            String applsStatus = candSetSalApplDyn.getString("billstatus");
            if (StringUtils.equals((CharSequence)applsStatus, (CharSequence)"A")) {
                candSetSalApplDeleteIds.add(candSetSalApplId);
                bizActDyn.set("candsetsalapplid", null);
                bizActDyn.set("candsetsalapplnum", null);
                bizActDyn.set("modifier", (Object)currUserId);
                bizActDyn.set("modifytime", (Object)currDate);
                bizActUpdateDyns.add(bizActDyn);
                continue;
            }
            candSetSalApplDyn.set("billstatus", (Object)"F");
            candSetSalApplDyn.set("modifier", (Object)currUserId);
            candSetSalApplDyn.set("modifytime", (Object)currDate);
            invaildCandSetSalAppls.add(candSetSalApplDyn);
        }
        if (!CollectionUtils.isEmpty((Collection)bizActUpdateDyns)) {
            CandSetSalActDynHelper.save(bizActUpdateDyns.toArray(new DynamicObject[bizActUpdateDyns.size()]));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        if (!CollectionUtils.isEmpty((Collection)candSetSalApplDeleteIds)) {
            serviceHelper.delete((Object[])candSetSalApplDeleteIds.toArray(new Long[candSetSalApplDeleteIds.size()]));
        }
        if (!CollectionUtils.isEmpty((Collection)invaildCandSetSalAppls)) {
            serviceHelper.update(invaildCandSetSalAppls.toArray(new DynamicObject[invaildCandSetSalAppls.size()]));
        }
    }

    private Map<Long, DynamicObject> queryCandSetSalAppl(Set<Long> candSetSalApplIds) {
        Map<Object, Object> candSetSalApplMap = Maps.newHashMapWithExpectedSize((int)0);
        if (!CollectionUtils.isEmpty(candSetSalApplIds)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
            QFilter filter = new QFilter("id", "in", candSetSalApplIds);
            filter.and("billstatus", "!=", (Object)"F");
            DynamicObject[] candSetSalApplDyns = serviceHelper.query("id,billstatus,modifier,modifytime", new QFilter[]{filter});
            candSetSalApplMap = Arrays.stream(candSetSalApplDyns).filter(obj -> obj.getLong("id") != 0L).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        }
        return candSetSalApplMap;
    }

    @Override
    public String cancelWorkFlow(Map<Long, DynamicObject> applyAndActBaseMap) {
        String msg = "";
        for (Map.Entry<Long, DynamicObject> applyIdEntry : applyAndActBaseMap.entrySet()) {
            DynamicObject actBaseDyn = applyIdEntry.getValue();
            try {
                Long applyId = applyIdEntry.getKey();
                String businessKey = String.valueOf(applyId);
                if (!WorkflowServiceHelper.inProcess((String)businessKey)) continue;
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
            }
            catch (Exception e) {
                msg = "cancelWorkFlow error" + e;
                LOGGER.error("AbstractActivityDealer cancelWorkFlow error:", (Throwable)e);
                ActivityDealHelper.logErrorInfo(actBaseDyn, false, ActivityErrorEnum.CANCELAPPLYWORKFLOW, e.toString());
            }
        }
        return msg;
    }
}

