/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.activity.msg;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hcdm.business.activity.ActInstanceHelper;
import kd.swc.hcdm.business.activity.dealer.AbstractActivityDealer;
import kd.swc.hcdm.common.enums.ActivityMsgSceneEnum;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class ActivityMsgHelper {
    private static Log LOGGER = LogFactory.getLog(AbstractActivityDealer.class);

    public static void sendMessage(ActivityMsgSceneEnum actMsgSceneEnum, long bizBillId, List<Long> userIds) {
        LOGGER.info("ActivityMsgHelper sendMessage start...");
        MessageInfo message = new MessageInfo();
        message.setTitle(actMsgSceneEnum.getDefaultTitle());
        message.setContent(actMsgSceneEnum.getDefaultContent());
        message.setEntityNumber(actMsgSceneEnum.getEntityNumber());
        message.setBizDataId(Long.valueOf(bizBillId));
        message.setType(actMsgSceneEnum.getType());
        message.setTplScene(actMsgSceneEnum.getSceneCode());
        message.setUserIds(userIds);
        String url = actMsgSceneEnum.getUrl();
        if (HRStringUtils.isNotEmpty((String)url)) {
            message.setContentUrl(url);
        }
        message.setSendTime(new Date(System.currentTimeMillis()));
        message.setTag(ResManager.loadKDString((String)"\u901a\u77e5", (String)"ActivityMsgHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        LOGGER.info("ActivityMsgHelper sendMessage message: {}", (Object)message);
        long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        if (ActivityMsgSceneEnum.GENERATE_NUMBER_ERROR == actMsgSceneEnum && msgId > 0L) {
            String cacheKey = actMsgSceneEnum.getSceneCode() + "_" + bizBillId;
            ISWCAppCache appCache = SWCAppCache.get((String)cacheKey);
            Integer sendCount = (Integer)appCache.get("sendCount", Integer.class);
            if (sendCount == null) {
                sendCount = 0;
            }
            Integer n = sendCount;
            Integer n2 = sendCount = Integer.valueOf(sendCount + 1);
            appCache.put("sendCount", (Object)sendCount);
        }
    }

    public static void sendMsgByInstanceId(Long instanceId, ActivityMsgSceneEnum actMsgSceneEnum) {
        DynamicObject instanceDyn = ActInstanceHelper.getActivityInsById("bizbillid,bizkey,handlers", instanceId);
        if (instanceDyn == null) {
            LOGGER.info("ActivityMsgHelper sendMsgByInstanceId error instanceId is not exist : {}", (Object)instanceId);
            return;
        }
        long bizBillId = instanceDyn.getLong("bizbillid");
        DynamicObjectCollection handlers = instanceDyn.getDynamicObjectCollection("handlers");
        if (CollectionUtils.isEmpty((Collection)handlers)) {
            LOGGER.info("ActivityMsgHelper sendMsgByInstanceId error handlers is null, instanceId: {}", (Object)instanceId);
            return;
        }
        List<Long> userIds = handlers.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
        ActivityMsgHelper.sendMessage(actMsgSceneEnum, bizBillId, userIds);
    }
}

