/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmConfirmType;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmFeedbackStatus;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmSendStatus;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@HrDomainEntity
public class AdjConfirmPersonService {
    public static final String ENTITY_NUMBER = "hcdm_adjconfirmperson";
    private SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjconfirmperson");
    private static final String ATTACHMENT_KEY = "attachmentpanel";

    public DynamicObject[] queryAllPerson(long adjApprovalBillId, String keyword) {
        return this.queryPersonByCondition(adjApprovalBillId, null, null, null, keyword, "id asc");
    }

    public Map<Long, Long> queryAdjApprovalBillIds(List<Long> adjConfirmPersonIds) {
        String selectProperties = "id, adjapprovalbill";
        DynamicObject[] dataObjs = this.serviceHelper.query(selectProperties, new QFilter[]{new QFilter("id", "in", adjConfirmPersonIds)});
        return Arrays.stream(dataObjs).collect(Collectors.toMap(object -> object.getLong("id"), object -> object.getLong("adjapprovalbill")));
    }

    public Map<Long, Long> queryAdjFileId(List<Long> adjConfirmPersonIds) {
        DynamicObject[] dataObjs = this.serviceHelper.query("id,adjfile", new QFilter[]{new QFilter("id", "in", adjConfirmPersonIds)});
        return Arrays.stream(dataObjs).collect(Collectors.toMap(object -> object.getLong("id"), object -> object.getLong("adjfile.id")));
    }

    public void insertAdjConfirmPerson(DynamicObject[] adjConfirmPersonObjs) {
        this.serviceHelper.save(adjConfirmPersonObjs);
    }

    public Map<Long, Map<String, Integer>> countPersonWithAllStatus(List<Long> adjApprovalBillIds, String keyword) {
        Map<Long, Map<Long, Map<String, Object>>> billData = this.getPersonStatusByConditionWhere(adjApprovalBillIds, keyword);
        HashMap billStatusCountMap = Maps.newHashMapWithExpectedSize((int)billData.size());
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> billDataEntry : billData.entrySet()) {
            Map<Long, Map<String, Object>> personDataSet = billDataEntry.getValue();
            int total = 0;
            int unConfirmed = 0;
            int confirmed = 0;
            int refused = 0;
            int notSent = 0;
            int hasSent = 0;
            int offlineConfirmed = 0;
            for (Map.Entry<Long, Map<String, Object>> onePersonStatusEntry : personDataSet.entrySet()) {
                Map<String, Object> onePersonStatusValue = onePersonStatusEntry.getValue();
                String confirmStatus = (String)onePersonStatusValue.get("confirmStatus");
                String isSend = (String)onePersonStatusValue.get("isSend");
                String confirmType = (String)onePersonStatusValue.get("confirmType");
                ++total;
                if (StringUtils.equals((String)AdjConfirmFeedbackStatus.NOT_CONFIRM.getCode(), (String)confirmStatus)) {
                    ++unConfirmed;
                }
                if (StringUtils.equals((String)AdjConfirmFeedbackStatus.CONFIRMED.getCode(), (String)confirmStatus)) {
                    ++confirmed;
                }
                if (StringUtils.equals((String)AdjConfirmFeedbackStatus.REFUSED.getCode(), (String)confirmStatus)) {
                    ++refused;
                }
                if (StringUtils.equals((String)AdjConfirmFeedbackStatus.NOT_CONFIRM.getCode(), (String)confirmStatus) && StringUtils.equals((String)AdjConfirmSendStatus.NOT_SENT.getCode(), (String)isSend)) {
                    ++notSent;
                }
                if (!StringUtils.equals((String)AdjConfirmConfirmType.OFF_LINE.getCode(), (String)confirmType) && StringUtils.equals((String)AdjConfirmSendStatus.HAS_SENT.getCode(), (String)isSend)) {
                    ++hasSent;
                }
                if (!StringUtils.equals((String)AdjConfirmFeedbackStatus.CONFIRMED.getCode(), (String)confirmStatus) || !StringUtils.equals((String)AdjConfirmConfirmType.OFF_LINE.getCode(), (String)confirmType)) continue;
                ++offlineConfirmed;
            }
            HashMap oneBillStatus = Maps.newHashMapWithExpectedSize((int)16);
            oneBillStatus.put("total", total);
            oneBillStatus.put("unconfirmed", unConfirmed);
            oneBillStatus.put("confirmed", confirmed);
            oneBillStatus.put("refused", refused);
            oneBillStatus.put("notsent", notSent);
            oneBillStatus.put("hassent", hasSent);
            oneBillStatus.put("offlineconfirmed", offlineConfirmed);
            billStatusCountMap.put(billDataEntry.getKey(), oneBillStatus);
        }
        return billStatusCountMap;
    }

    private Map<Long, Map<Long, Map<String, Object>>> getPersonStatusByConditionWhere(List<Long> adjApprovalBillIds, String keyword) {
        if (CollectionUtils.isEmpty(adjApprovalBillIds)) {
            return Collections.emptyMap();
        }
        DynamicObject[] dynamicObjects = this.serviceHelper.query("id,adjapprovalbill,employee,confirmstatus,confirmtype,issend,confirmtime,lastsendtime,attachmentnum", new QFilter[]{new QFilter("adjapprovalbill", "in", adjApprovalBillIds)});
        if (StringUtils.isNotEmpty((String)keyword)) {
            Set employeeIds = Arrays.stream(dynamicObjects).map(object -> object.getLong("employee.id")).collect(Collectors.toSet());
            SWCDataServiceHelper employeeService = new SWCDataServiceHelper("hrpi_employee");
            DynamicObject[] personObj = employeeService.query("id,empnumber,person", new QFilter[]{new QFilter("empnumber", "like", (Object)keyword).or(new QFilter("person.name", "like", (Object)keyword)), new QFilter("id", "in", employeeIds)});
            Set matchedEmployeeIds = Arrays.stream(personObj).map(object -> object.getLong("id")).collect(Collectors.toSet());
            dynamicObjects = (DynamicObject[])Arrays.stream(dynamicObjects).filter(object -> matchedEmployeeIds.contains(object.getLong("employee.id"))).toArray(DynamicObject[]::new);
        }
        HashMap map = Maps.newHashMap();
        for (DynamicObject row : dynamicObjects) {
            Long billId = row.getLong("adjapprovalbill");
            Map billData = map.computeIfAbsent(billId, value -> Maps.newHashMapWithExpectedSize((int)16));
            Long confirmPersonId = row.getLong("id");
            Map personData = billData.computeIfAbsent(confirmPersonId, value -> Maps.newHashMapWithExpectedSize((int)16));
            String confirmStatus = row.getString("confirmstatus");
            String isSend = row.getString("issend");
            String confirmType = row.getString("confirmtype");
            personData.put("fid", confirmPersonId);
            personData.put("confirmStatus", confirmStatus);
            personData.put("isSend", isSend);
            personData.put("confirmType", confirmType);
        }
        return map;
    }

    public DynamicObject[] queryPersonOfNotSent(long adjApprovalBillId, String keyword) {
        return this.queryPersonByCondition(adjApprovalBillId, null, AdjConfirmFeedbackStatus.NOT_CONFIRM, AdjConfirmSendStatus.NOT_SENT, keyword, null);
    }

    public DynamicObject[] queryPersonOfHasSent(long adjApprovalBillId, String keyword) {
        QFilter isSend = QFilter.of((String)"issend=?", (Object[])new Object[]{AdjConfirmSendStatus.HAS_SENT.getCode()});
        QFilter confirmType = new QFilter("confirmtype", "!=", (Object)AdjConfirmConfirmType.OFF_LINE.getCode());
        return this.queryPersonByFilter(adjApprovalBillId, Lists.newArrayList((Object[])new QFilter[]{isSend, confirmType}), keyword, null);
    }

    public DynamicObject[] queryPersonOfOffLineConfirmed(long adjApprovalBillId, String keyword) {
        return this.queryPersonByCondition(adjApprovalBillId, AdjConfirmConfirmType.OFF_LINE, AdjConfirmFeedbackStatus.CONFIRMED, null, keyword, null);
    }

    private DynamicObject[] queryPersonByCondition(long adjApprovalBillId, AdjConfirmConfirmType confirmType, AdjConfirmFeedbackStatus feedbackStatus, AdjConfirmSendStatus sendStatus, String keyword, String orderBy) {
        ArrayList qFilters = Lists.newArrayList();
        if (confirmType != null) {
            qFilters.add(QFilter.of((String)"confirmtype = ?", (Object[])new Object[]{confirmType.getCode()}));
        }
        if (feedbackStatus != null) {
            qFilters.add(QFilter.of((String)"confirmstatus = ?", (Object[])new Object[]{feedbackStatus.getCode()}));
        }
        if (sendStatus != null) {
            qFilters.add(QFilter.of((String)"issend = ?", (Object[])new Object[]{sendStatus.getCode()}));
        }
        if (!StringUtils.isEmpty((String)keyword)) {
            qFilters.add(QFilter.like((String)"person.name", (String)keyword).or(QFilter.like((String)"person.number", (String)keyword)));
        }
        return this.queryPersonByFilter(adjApprovalBillId, qFilters, keyword, orderBy);
    }

    private DynamicObject[] queryPersonByFilter(long adjAFpprovalBillId, List<QFilter> qFilters, String keyword, String orderBy) {
        qFilters.add(QFilter.of((String)"adjapprovalbill = ? ", (Object[])new Object[]{adjAFpprovalBillId}));
        if (!StringUtils.isEmpty((String)keyword)) {
            qFilters.add(QFilter.like((String)"person.name", (String)keyword).or(QFilter.like((String)"person.number", (String)keyword)));
        }
        return this.serviceHelper.query("adjapprovalbill,person,adjfile,confirmstatus,confirmtype,issend,confirmtime,lastsendtime,attachmentnum", qFilters.toArray(new QFilter[0]), orderBy);
    }

    public Map<Long, List<Map<String, Object>>> queryAttachmentFile(List<Long> adjConfirmPersonIds) {
        HashMap resultMap = Maps.newHashMap();
        for (Long confirmPersonId : adjConfirmPersonIds) {
            List attachmentList = AttachmentServiceHelper.getAttachments((String)ENTITY_NUMBER, (Object)confirmPersonId, (String)ATTACHMENT_KEY, (boolean)false);
            List allFiles = resultMap.computeIfAbsent(confirmPersonId, value -> Lists.newArrayList());
            allFiles.addAll(attachmentList);
        }
        return resultMap;
    }

    public Map<Long, AdjConfirmFeedbackStatus> queryFeedbackStatus(List<Long> adjConfirmPersonIds) {
        DynamicObject[] objects = this.queryPersonById("id,confirmstatus", adjConfirmPersonIds);
        return Arrays.stream(objects).collect(Collectors.toMap(object -> object.getLong("id"), object -> AdjConfirmFeedbackStatus.getByCode(object.getString("confirmstatus"))));
    }

    public Map<Long, AdjConfirmSendStatus> querySendStatus(List<Long> adjConfirmPersonIds) {
        DynamicObject[] objects = this.queryPersonById("id,issend", adjConfirmPersonIds);
        return Arrays.stream(objects).collect(Collectors.toMap(object -> object.getLong("id"), object -> AdjConfirmSendStatus.getByCode(object.getString("issend"))));
    }

    public void updateSendStatus(List<Long> adjConfirmPersonIds, AdjConfirmSendStatus sendStatus, Map<Long, Date> personExpiryDateMap, boolean isFromRepeatSend) {
        DynamicObject[] dbObjs = this.queryPersonById("id,issend,lastsendtime,sendnum,expirytime", adjConfirmPersonIds);
        Date now = TimeServiceHelper.now();
        for (DynamicObject dbObj : dbObjs) {
            dbObj.set("issend", (Object)sendStatus.getCode());
            dbObj.set("lastsendtime", (Object)now);
            if (isFromRepeatSend) {
                dbObj.set("sendnum", (Object)(dbObj.getInt("sendnum") + 1));
            }
            dbObj.set("expirytime", (Object)personExpiryDateMap.get(dbObj.getLong("id")));
        }
        this.serviceHelper.update(dbObjs);
    }

    public void updateAdjConfirmAttachment(Map<Long, List<Map<String, Object>>> personAttachments) {
        for (Map.Entry<Long, List<Map<String, Object>>> entry : personAttachments.entrySet()) {
            List<Map<String, Object>> files = entry.getValue();
            for (Map map : files) {
                String url = (String)map.get("url");
                if (url.contains("tempfile/")) {
                    if (map.get("newurl") != null) continue;
                    String uuid = AttachmentServiceHelper.saveTempToFileService((String)((String)map.get("url")), (String)"hcdm", (String)ENTITY_NUMBER, (Object)entry.getKey(), (String)((String)map.get("name")), (boolean)true);
                    String realPath = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(uuid);
                    map.put("newurl", realPath);
                    continue;
                }
                map.put("newurl", url);
            }
        }
        ArrayList dtos = Lists.newArrayList();
        long currUserId = RequestContext.get().getCurrUserId();
        for (Map.Entry entry : personAttachments.entrySet()) {
            Long adjConfirmPersonId = (Long)entry.getKey();
            List files = (List)entry.getValue();
            for (Map file : files) {
                String url = (String)file.get("url");
                if (!url.contains("tempfile/")) continue;
                AttDto attDto = new AttDto();
                attDto.setAttKey(ATTACHMENT_KEY);
                attDto.setCreateUserId(currUserId + "");
                attDto.setEntityNumber(ENTITY_NUMBER);
                attDto.setFileName((String)file.get("name"));
                attDto.setPath((String)file.get("newurl"));
                attDto.setSize(Long.valueOf(((Integer)file.get("size")).intValue()));
                attDto.setEntryPkId(adjConfirmPersonId + "");
                dtos.add(attDto);
            }
            if (dtos.isEmpty()) continue;
            try {
                Map attachmentMap = AttachmentServiceHelper.genBindingParam((String)ENTITY_NUMBER, (String)(adjConfirmPersonId + ""), (List)dtos);
                AttachmentServiceHelper.bindingAttachment((Map)attachmentMap);
            }
            catch (Exception ignored) {
                throw new KDException((Throwable)ignored, BosErrorCode.paramError, new Object[]{ignored.getMessage()});
            }
        }
        this.updateAttachmentNum(personAttachments);
    }

    private void updateAttachmentNum(Map<Long, List<Map<String, Object>>> personAttachments) {
        DynamicObject[] dbObjs;
        for (DynamicObject dbObj : dbObjs = this.queryPersonById("id,attachmentnum", personAttachments.keySet())) {
            long id = dbObj.getLong("id");
            dbObj.set("attachmentnum", (Object)personAttachments.get(id).size());
        }
        this.serviceHelper.update(dbObjs);
    }

    public void updateFeedbackStatus(List<Long> adjConfirmPersonIds, AdjConfirmFeedbackStatus feedbackStatus, AdjConfirmConfirmType confirmType) {
        DynamicObject[] personObjs;
        for (DynamicObject personObj : personObjs = this.queryPersonById("id,confirmstatus,confirmtype", adjConfirmPersonIds)) {
            personObj.set("confirmstatus", (Object)feedbackStatus.getCode());
            personObj.set("confirmtype", (Object)confirmType.getCode());
        }
        this.serviceHelper.update(personObjs);
    }

    public DynamicObject[] queryPersonByHrAndBill(List<Long> hrPersonIds, long adjApprovalBillId) {
        return null;
    }

    public void userConfirm(long adjConfirmPersonId) {
        DynamicObject[] personObjs;
        for (DynamicObject personObj : personObjs = this.serviceHelper.query(new Object[]{adjConfirmPersonId})) {
            personObj.set("confirmstatus", (Object)AdjConfirmFeedbackStatus.CONFIRMED.getCode());
        }
        this.serviceHelper.update(personObjs);
    }

    public void userConfirmRefuse(long adjConfirmPersonId) {
        DynamicObject[] personObjs;
        for (DynamicObject personObj : personObjs = this.serviceHelper.query(new Object[]{adjConfirmPersonId})) {
            personObj.set("confirmstatus", (Object)AdjConfirmFeedbackStatus.REFUSED.getCode());
        }
        this.serviceHelper.update(personObjs);
    }

    public Map<Long, Long> queryHrPersonId(List<Long> adjConfirmPersonIds) {
        DynamicObject[] dataObjs = this.queryPersonById("id,person.id", adjConfirmPersonIds);
        return Arrays.stream(dataObjs).collect(Collectors.toMap(object -> object.getLong("id"), object -> object.getLong("person.id")));
    }

    public DynamicObject[] queryPersonById(String selectProperties, Collection<Long> adjConfirmPersonIds) {
        if (CollectionUtils.isEmpty(adjConfirmPersonIds)) {
            return new DynamicObject[0];
        }
        if (StringUtils.isEmpty((String)selectProperties)) {
            return this.serviceHelper.query(this.getSelectProperties(), new QFilter[]{new QFilter("id", "in", adjConfirmPersonIds)});
        }
        return this.serviceHelper.query(selectProperties, new QFilter[]{new QFilter("id", "in", adjConfirmPersonIds)});
    }

    public DynamicObject queryAdjConfirmPersonById(long adjConfirmPersonId) {
        return this.serviceHelper.queryOne((Object)adjConfirmPersonId);
    }

    public String getSelectProperties() {
        return SWCHisBaseDataHelper.getSelectProperties((String)ENTITY_NUMBER);
    }
}

