/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.util.PasswordEncryptUtil;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

@HrDomainEntity
public class AdjConfirmQueryAccountService {
    private static final String ENTITY_NUMBER = "hcdm_adjconfirmaccount";
    private SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjconfirmaccount");

    public String queryAccountPassword(long hrPersonId) {
        DynamicObject adjConfirmAccountDyObj = this.serviceHelper.queryOne("password", new QFilter[]{new QFilter("personid", "=", (Object)hrPersonId)});
        return adjConfirmAccountDyObj == null ? null : adjConfirmAccountDyObj.getString("password");
    }

    public ValidateResult updateNewPassword(long hrPersonId, String password) {
        String salt = LoginUtils.getCorrectUserIDSalt((String)String.valueOf(hrPersonId));
        password = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)password, (String)salt);
        boolean exists = this.serviceHelper.isExists(new QFilter[]{new QFilter("password", "=", (Object)password), new QFilter("personid", "=", (Object)hrPersonId)});
        if (exists) {
            ValidateResult validateResult = new ValidateResult(ErrorLevel.Error);
            validateResult.failed();
            return validateResult;
        }
        DynamicObject adjConfirmAccount = this.serviceHelper.queryOne("id,password,lastupdatetime", new QFilter[]{new QFilter("personid", "=", (Object)hrPersonId)});
        adjConfirmAccount.set("lastupdatetime", (Object)new Date());
        adjConfirmAccount.set("password", (Object)password);
        this.serviceHelper.updateOne(adjConfirmAccount);
        return new ValidateResult(ErrorLevel.Info);
    }

    public void insertLoginRecord(long hrPersonId) {
        DynamicObject adjConfirmAccountDyObj = this.serviceHelper.queryOne("id,personid,lastupdatetime", new QFilter[]{new QFilter("personid", "=", (Object)hrPersonId)});
        adjConfirmAccountDyObj.set("lastupdatetime", (Object)new Date());
        this.serviceHelper.updateOne(adjConfirmAccountDyObj);
    }

    public Map<Long, DynamicObject> queryAdjConfirmAccount(List<Long> hrPersonIds) {
        DynamicObject[] dynamicObjects = this.serviceHelper.query("id,personid,password", new QFilter[]{new QFilter("personid", "in", hrPersonIds)});
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(object -> object.getLong("personid"), object -> object));
    }

    public void saveAdjConfirmAccount(DynamicObject adjConfirmAccountDyObj) {
        adjConfirmAccountDyObj.set("lastupdatetime", (Object)new Date());
        this.serviceHelper.saveOne(adjConfirmAccountDyObj);
    }
}

