/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapplication.domain.adjapproval.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.PasswordEncryptUtil;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice.AdjConfirmPersonService;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice.AdjConfirmPrintTemplateService;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice.AdjConfirmQueryAccountService;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice.AdjConfirmTemplateService;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice.AdjSchemeService;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmConfirmType;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmFeedbackStatus;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmSendStatus;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

@HrDomainEntity
public class AdjApprovalDomainService {
    private Log log = LogFactory.getLog(AdjApprovalDomainService.class);
    private static final Pattern pattern = Pattern.compile("\\{(.*?)\\}");
    private static final String MAIN_ENTITY = "hcdm_adjapprbill";
    private SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
    private AdjConfirmPersonService adjConfirmPersonService;
    private AdjConfirmPrintTemplateService adjConfirmPrintTemplateService;
    private AdjConfirmQueryAccountService adjConfirmQueryAccountService;
    private AdjConfirmTemplateService adjConfirmTemplateService;
    private AdjSchemeService adjSchemeService;

    public AdjConfirmPersonService getAdjConfirmPersonService() {
        return this.adjConfirmPersonService;
    }

    public void setAdjConfirmPersonService(AdjConfirmPersonService adjConfirmPersonService) {
        this.adjConfirmPersonService = adjConfirmPersonService;
    }

    public AdjConfirmPrintTemplateService getAdjConfirmPrintTemplateService() {
        return this.adjConfirmPrintTemplateService;
    }

    public void setAdjConfirmPrintTemplateService(AdjConfirmPrintTemplateService adjConfirmPrintTemplateService) {
        this.adjConfirmPrintTemplateService = adjConfirmPrintTemplateService;
    }

    public AdjConfirmQueryAccountService getAdjConfirmQueryAccountService() {
        return this.adjConfirmQueryAccountService;
    }

    public void setAdjConfirmQueryAccountService(AdjConfirmQueryAccountService adjConfirmQueryAccountService) {
        this.adjConfirmQueryAccountService = adjConfirmQueryAccountService;
    }

    public AdjConfirmTemplateService getAdjConfirmTemplateService() {
        return this.adjConfirmTemplateService;
    }

    public void setAdjConfirmTemplateService(AdjConfirmTemplateService adjConfirmTemplateService) {
        this.adjConfirmTemplateService = adjConfirmTemplateService;
    }

    public AdjSchemeService getAdjSchemeService() {
        return this.adjSchemeService;
    }

    public void setAdjSchemeService(AdjSchemeService adjSchemeService) {
        this.adjSchemeService = adjSchemeService;
    }

    public Map<Long, List<Long>> queryAdjApprovalPersonFileId(List<Long> adjApprBillIds) {
        DynamicObject[] personObjs = new DynamicObject[]{};
        if (CollectionUtils.isNotEmpty(adjApprBillIds)) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
            personObjs = serviceHelper.query("id,adjfile,adjapprbill", new QFilter[]{new QFilter("adjapprbill", "in", adjApprBillIds)});
        }
        HashMap result = Maps.newHashMap();
        for (DynamicObject personObj : personObjs) {
            long billId = personObj.getLong("adjapprbill");
            long fileId = personObj.getLong("adjfile.id");
            List values = result.computeIfAbsent(billId, val -> Lists.newArrayList());
            values.add(fileId);
        }
        return result;
    }

    public Map<Long, Long> queryTemplateIdByAdjApprovalBillIds(Set<Long> adjApprovalBillIds) {
        HashSet adjScmIds = Sets.newHashSet();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)adjApprovalBillIds.size());
        Map<Long, DynamicObject> billObjMap = this.queryAdjBillObjs("id,salaryadjscm", Lists.newArrayList(adjApprovalBillIds));
        billObjMap.forEach((key, value) -> adjScmIds.add(value.getLong("salaryadjscm.id")));
        Map<Long, DynamicObject> adjScmObjMap = this.queryAdjSchema("id,adjconfirmtpl", adjScmIds);
        for (Long adjApprovalBillId : adjApprovalBillIds) {
            DynamicObject billObj = billObjMap.get(adjApprovalBillId);
            Long tplId = adjScmObjMap.get(billObj.getLong("salaryadjscm.id")).getLong("adjconfirmtpl.id");
            resultMap.put(adjApprovalBillId, tplId);
        }
        return resultMap;
    }

    public Map<Long, Map<String, Integer>> countAdjConfirmStatistic(List<Long> adjApprovalBillIds, String keyword) {
        return this.adjConfirmPersonService.countPersonWithAllStatus(adjApprovalBillIds, keyword);
    }

    public Map<Long, List<Map<String, Object>>> getAdjConfirmAttachment(List<Long> adjConfirmPersonIds) {
        Map<Long, List<Map<String, Object>>> listMap = this.adjConfirmPersonService.queryAttachmentFile(adjConfirmPersonIds);
        return listMap;
    }

    public PrtAttach doGenerateAdjConfirmPDF(List<Long> adjConfirmPersonIds) {
        PrintWork work = new PrintWork();
        work.setPrintLang(RequestContext.get().getLang().toString());
        work.setExpType("1");
        PrintTask task = new PrintTask();
        work.add(task);
        task.setFormId("hcdm_adjconfirmperson");
        task.setTplId(this.adjConfirmPrintTemplateService.getTemplateId("hcdm_adjconfirmperson"));
        task.setPrintType("billForm");
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)adjConfirmPersonIds.size());
        objects.addAll(adjConfirmPersonIds);
        task.setPkIds((List)objects);
        return BosPrintServiceHelper.execPrint((PrintWork)work);
    }

    public PrtAttach doGenerateAdjConfirmPDFForOnePage(Map<String, Object> parameterMap) {
        PrintWork work = this.setTaskInfo(parameterMap);
        return BosPrintServiceHelper.execPrint((PrintWork)work);
    }

    private PrintWork setTaskInfo(Map<String, Object> parameterMap) {
        String printTemplateId = (String)parameterMap.get("printTemplateId");
        PrintWork work = new PrintWork();
        work.setPrintLang(RequestContext.get().getLang().toString());
        work.setExpType("1");
        PrintTask task = new PrintTask();
        work.add(task);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(1);
        map.put("parameterMap", parameterMap);
        work.setExtParam(map);
        if (SWCStringUtils.isEmpty((String)printTemplateId)) {
            printTemplateId = this.adjConfirmPrintTemplateService.getTemplateId("hcdm_adjconfirmperson");
        }
        task.setTplId(printTemplateId);
        task.setPrintType("billForm");
        Object adjConfirmTplAndPersonMapObj = parameterMap.get("adjConfirmTplAndPersonMap");
        ArrayList adjConfirmPersonIds = new ArrayList(16);
        if (adjConfirmTplAndPersonMapObj != null) {
            Map adjConfirmTplAndPersonMap = (Map)adjConfirmTplAndPersonMapObj;
            for (Map.Entry entry : adjConfirmTplAndPersonMap.entrySet()) {
                adjConfirmPersonIds.addAll((Collection)entry.getValue());
            }
        }
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)adjConfirmPersonIds.size());
        objects.addAll(adjConfirmPersonIds);
        task.setPkIds((List)objects);
        return work;
    }

    public void printAdjConfirmPDF(List<Long> adjConfirmPersonIds, String printerId) {
        PrintWork work = new PrintWork();
        work.setPrintLang(RequestContext.get().getLang().toString());
        work.setExpType("1");
        PrintTask task = new PrintTask();
        work.add(task);
        task.setFormId("hcdm_adjconfirmperson");
        task.setTplId(this.adjConfirmPrintTemplateService.getTemplateId("hcdm_adjconfirmperson"));
        task.setPrintType("billForm");
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)adjConfirmPersonIds.size());
        objects.addAll(adjConfirmPersonIds);
        task.setPkIds((List)objects);
        BosPrintServiceHelper.doPrintDirect((String)printerId, (PrintWork)work);
    }

    public void printAdjConfirmPDFForOnePage(Map<String, Object> parameterMap) {
        PrintWork work = this.setTaskInfo(parameterMap);
        String printerId = (String)parameterMap.get("printerId");
        BosPrintServiceHelper.doPrintDirect((String)printerId, (PrintWork)work);
    }

    public Map<Long, List<String>> queryAdjConfirmTemplateParamNames(List<Long> adjConfirmPersonIds) {
        Map<Long, DynamicObject> adjConfirmTemplateDyObjMap = this.queryAdjConfirmTemplate(adjConfirmPersonIds);
        LinkedHashMap templateParamNames = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, DynamicObject> entry : adjConfirmTemplateDyObjMap.entrySet()) {
            DynamicObject adjConfirmTemplateDyObj = entry.getValue();
            String content = adjConfirmTemplateDyObj == null ? "" : adjConfirmTemplateDyObj.getString("content");
            templateParamNames.put(entry.getKey(), this.collectAdjConfirmTemplateParamNames(content));
        }
        return templateParamNames;
    }

    public Map<Long, List<String>> queryAdjConfirmTemplateContentById(Set<Long> adjConfirmTplIdSet) {
        Map<Long, DynamicObject> adjConfirmTemplateDyObjMap = this.queryAdjConfirmTemplateById(adjConfirmTplIdSet);
        LinkedHashMap templateParamNames = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, DynamicObject> entry : adjConfirmTemplateDyObjMap.entrySet()) {
            DynamicObject adjConfirmTemplateDyObj = entry.getValue();
            String content = adjConfirmTemplateDyObj == null ? "" : adjConfirmTemplateDyObj.getString("content");
            templateParamNames.put(entry.getKey(), this.collectAdjConfirmTemplateParamNames(content));
        }
        return templateParamNames;
    }

    private Map<Long, DynamicObject> queryAdjConfirmTemplateById(Set<Long> adjConfirmTplIdSet) {
        return this.adjConfirmTemplateService.queryAdjConfirmTemplate(adjConfirmTplIdSet);
    }

    private List<String> collectAdjConfirmTemplateParamNames(String content) {
        ArrayList paramNames = Lists.newArrayList();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            paramNames.add(matcher.group(1));
        }
        return paramNames;
    }

    public Map<Long, String> generateAdjConfirmTextWithParam(Map<Long, List<List<Map<String, String>>>> templateParamValue) {
        Set<Long> adjConfirmPersonIdSet = templateParamValue.keySet();
        Map<Long, DynamicObject> adjConfirmTemplateDyObjMap = this.queryAdjConfirmTemplate(new ArrayList<Long>(adjConfirmPersonIdSet));
        HashMap adjConfirmContent = Maps.newHashMapWithExpectedSize((int)adjConfirmTemplateDyObjMap.size());
        for (Map.Entry<Long, DynamicObject> entry : adjConfirmTemplateDyObjMap.entrySet()) {
            Long adjPersonId = entry.getKey();
            DynamicObject adjConfirmTemplateDyObj = entry.getValue();
            String templateContent = adjConfirmTemplateDyObj == null ? "" : adjConfirmTemplateDyObj.getString("content");
            adjConfirmContent.put(adjPersonId, this.generateAdjConfirmText(templateContent, templateParamValue.get(adjPersonId)));
        }
        return adjConfirmContent;
    }

    public Map<Long, String> generateAdjConfirmTextWithParamByTpl(Map<Long, List<List<Map<String, String>>>> templateParamValue, Map<Long, List<Long>> adjConfirmTplAndPersonMap) {
        Map<Long, DynamicObject> adjConfirmTemplateDyObjMap = this.queryAdjConfirmTemplateById(adjConfirmTplAndPersonMap.keySet());
        HashMap adjConfirmContent = Maps.newHashMapWithExpectedSize((int)adjConfirmTemplateDyObjMap.size());
        for (Map.Entry<Long, List<Long>> entry : adjConfirmTplAndPersonMap.entrySet()) {
            List<Long> adjConfirmPersonIdList = entry.getValue();
            if (adjConfirmPersonIdList == null) continue;
            Long adjConfirmTplId = entry.getKey();
            for (Long adjConfirmPersonId : adjConfirmPersonIdList) {
                DynamicObject adjConfirmTplDy = adjConfirmTemplateDyObjMap.get(adjConfirmTplId);
                String templateContent = adjConfirmTplDy == null ? "" : adjConfirmTplDy.getString("content");
                adjConfirmContent.put(adjConfirmPersonId, this.generateAdjConfirmText(templateContent, templateParamValue.get(adjConfirmPersonId)));
            }
        }
        return adjConfirmContent;
    }

    private String generateAdjConfirmText(String templateContent, List<List<Map<String, String>>> params) {
        if (CollectionUtils.isNotEmpty(params)) {
            this.log.info("\u6a21\u677f\u53c2\u6570\u53d8\u91cf\u503c:{}", (Object)JSONObject.toJSONString(params));
            Map<String, String> fparams = this.splitLoopParam(templateContent, params);
            for (Map.Entry<String, String> fparam : fparams.entrySet()) {
                String paramKey = fparam.getKey();
                String paramValue = fparam.getValue();
                templateContent = templateContent.replace("[" + paramKey + "]", paramValue);
            }
            List<Map<String, String>> paramEnt = params.get(0);
            for (Map<String, String> paramMap : paramEnt) {
                for (Map.Entry<String, String> param : paramMap.entrySet()) {
                    String paramKey = param.getKey();
                    String paramValue = param.getValue();
                    templateContent = templateContent.replace("{" + paramKey + "}", StringUtils.isBlank((CharSequence)paramValue) ? "" : paramValue);
                }
            }
        }
        return templateContent;
    }

    private Map<String, String> splitLoopParam(String templateContent, List<List<Map<String, String>>> params) {
        HashMap templateValueList = Maps.newHashMapWithExpectedSize((int)16);
        while (templateContent.indexOf(91) >= 0) {
            if ((templateContent = templateContent.substring(templateContent.indexOf(91) + 1)).indexOf(93) <= 0) continue;
            String sx = templateContent.substring(0, templateContent.indexOf(93));
            StringBuilder temp = new StringBuilder();
            for (List<Map<String, String>> paramEnt : params) {
                for (Map<String, String> paramMap : paramEnt) {
                    String wayTemp = sx;
                    for (Map.Entry<String, String> param : paramMap.entrySet()) {
                        String paramKey = param.getKey();
                        String paramValue = param.getValue();
                        wayTemp = wayTemp.replace("{" + paramKey + "}", paramValue);
                    }
                    temp.append(wayTemp).append("<br/>");
                }
            }
            templateValueList.put(sx, temp.toString());
        }
        return templateValueList;
    }

    public DynamicObject[] queryAdjConfirmTemplateParamValue(List<String> properties, Set<Long> adjApprovalBillIdSet, Set<Long> personIdSet) {
        String selectProperties = String.join((CharSequence)",", properties);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        return serviceHelper.query("adjapprbill, adjfile.id, adjfile.empposorgrel.id,djfile.depemp.id, entryentity.calctype,entryentity.pregrade, entryentity.prerank, entryentity.grade, entryentity.rank, entryentity.salargrel, entryentity.salarystd,entryentity.currency, entryentity.suggestminrange, entryentity.suggestmaxrange, entryentity.suggestminamount, entryentity.standarditem,entryentity.suggestmaxamount, entryentity.precurrency,entryentity.standarditem,entryentity.pregrade,entryentity.salarypercent,entryentity.salaryseeprate,entryentity.reason,entryentity.reason,adjfile.empposorgrel,adjfile.empposorgrel.adminorg," + selectProperties, new QFilter[]{new QFilter("adjapprbill", "in", adjApprovalBillIdSet), new QFilter("person.id", "in", personIdSet)});
    }

    public String generateNotifyMsg(long adjConfirmPersonId) {
        return null;
    }

    public void markAsSendConfirm(List<Long> adjConfirmPersonIds, Map<Long, Date> personExpiryDateMap, boolean isFromRepeatSend) {
        this.adjConfirmPersonService.updateSendStatus(adjConfirmPersonIds, AdjConfirmSendStatus.HAS_SENT, personExpiryDateMap, isFromRepeatSend);
    }

    public void updateAdjConfirmAttachment(Map<Long, List<Map<String, Object>>> attachments) {
        Map<Long, List<Map<String, Object>>> oldAttachment = this.adjConfirmPersonService.queryAttachmentFile(Lists.newArrayList(attachments.keySet()));
        for (Map.Entry<Long, List<Map<String, Object>>> entry : attachments.entrySet()) {
            entry.getValue().addAll((Collection<Map<String, Object>>)oldAttachment.get(entry.getKey()));
        }
        this.adjConfirmPersonService.updateAdjConfirmAttachment(attachments);
    }

    public void markAsOffLineConfirm(List<Long> adjConfirmPersonIds) {
        this.adjConfirmPersonService.updateFeedbackStatus(adjConfirmPersonIds, AdjConfirmFeedbackStatus.CONFIRMED, AdjConfirmConfirmType.OFF_LINE);
    }

    public boolean checkDockingPayslip() {
        return false;
    }

    public boolean verifyPassword(String password, long hrPersonId) {
        String passwordByDb = this.adjConfirmQueryAccountService.queryAccountPassword(hrPersonId);
        String salt = LoginUtils.getCorrectUserIDSalt((String)String.valueOf(hrPersonId));
        String encryptePassword = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)password, (String)salt);
        if (passwordByDb != null && passwordByDb.equals(encryptePassword)) {
            this.adjConfirmQueryAccountService.insertLoginRecord(hrPersonId);
            return true;
        }
        return false;
    }

    public Map<Long, DynamicObject> queryAdjConfirmAccount(List<Long> hrPersonIds) {
        return this.adjConfirmQueryAccountService.queryAdjConfirmAccount(hrPersonIds);
    }

    public ValidateResult resetPassword(String password, long hrPersonId) {
        return this.adjConfirmQueryAccountService.updateNewPassword(hrPersonId, password);
    }

    public void saveAdjConfirmAccount(String password, long hrPersonId) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"hcdm_adjconfirmaccount");
        String salt = LoginUtils.getCorrectUserIDSalt((String)String.valueOf(hrPersonId));
        String encryptePassword = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)password, (String)salt);
        DynamicObject adjConfirmAccount = new DynamicObject((DynamicObjectType)entityType);
        adjConfirmAccount.set("personid", (Object)hrPersonId);
        adjConfirmAccount.set("password", (Object)encryptePassword);
        this.adjConfirmQueryAccountService.saveAdjConfirmAccount(adjConfirmAccount);
    }

    public void onLineConfirmAgree(long adjConfirmPersonId) {
        this.adjConfirmPersonService.userConfirm(adjConfirmPersonId);
    }

    public void onLineConfirmRefuse(long adjConfirmPersonId) {
        this.adjConfirmPersonService.userConfirmRefuse(adjConfirmPersonId);
    }

    public Map<Long, Long> queryAdjFileByConfirmPerson(List<Long> adjConfirmPersonIds) {
        return this.adjConfirmPersonService.queryAdjFileId(adjConfirmPersonIds);
    }

    public Map<Long, AdjConfirmFeedbackStatus> queryAdjConfirmFeedbackStatus(List<Long> adjConfirmPersonIds) {
        return this.adjConfirmPersonService.queryFeedbackStatus(adjConfirmPersonIds);
    }

    public Map<Long, AdjConfirmSendStatus> queryAdjConfirmSendStatus(List<Long> adjConfirmPersonIds) {
        return this.adjConfirmPersonService.querySendStatus(adjConfirmPersonIds);
    }

    public List<Long> queryNeedSendConfirmPerson(List<Long> adjConfirmPersonIds) {
        Map<Long, AdjConfirmSendStatus> sendStatus = this.adjConfirmPersonService.querySendStatus(adjConfirmPersonIds);
        Map<Long, AdjConfirmFeedbackStatus> feedbackStatusMap = this.adjConfirmPersonService.queryFeedbackStatus(adjConfirmPersonIds);
        return adjConfirmPersonIds.stream().filter(aLong -> feedbackStatusMap.get(aLong) == AdjConfirmFeedbackStatus.NOT_CONFIRM && sendStatus.get(aLong) == AdjConfirmSendStatus.NOT_SENT).collect(Collectors.toList());
    }

    public Map<Long, Long> queryAdjApprovalBillIds(List<Long> adjConfirmPersonIds) {
        return this.adjConfirmPersonService.queryAdjApprovalBillIds(adjConfirmPersonIds);
    }

    public Map<Long, DynamicObject> queryAdjConfirmPersonData(List<Long> adjConfirmPersonIds) {
        String selectProperties = "id, adjapprovalbill, person.id, adjfile.id";
        DynamicObject[] datas = this.adjConfirmPersonService.queryPersonById(selectProperties, adjConfirmPersonIds);
        return Arrays.stream(datas).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
    }

    public Map<Long, String> queryMsgTemplateNumbers(Collection<Long> adjConfirmTemplateIds) {
        return this.adjConfirmTemplateService.queryMsgTemplateNumber(adjConfirmTemplateIds);
    }

    public void updateAdjConfirmPersonAttachment(Map<Long, List<Map<String, Object>>> personAttachments) {
        this.adjConfirmPersonService.updateAdjConfirmAttachment(personAttachments);
    }

    public Map<Long, DynamicObject> queryAdjConfirmTemplate(List<Long> adjConfirmPersonIds) {
        Map<Long, Long> adjApprovalBills = this.queryAdjApprovalBillIds(adjConfirmPersonIds);
        HashSet adjApprovalBillIds = Sets.newHashSet();
        HashSet adjScmIds = Sets.newHashSet();
        HashSet templateIdSet = Sets.newHashSet();
        adjApprovalBills.forEach((key, value) -> adjApprovalBillIds.add(value));
        Map<Long, DynamicObject> billObjMap = this.queryAdjBillObjs("id,salaryadjscm", Lists.newArrayList((Iterable)adjApprovalBillIds));
        billObjMap.forEach((key, value) -> adjScmIds.add(value.getLong("salaryadjscm.id")));
        Map<Long, DynamicObject> adjTplObjMap = this.queryAdjSchema("id,adjconfirmtpl", adjScmIds);
        adjTplObjMap.values().forEach(object -> templateIdSet.add(object.getLong("adjconfirmtpl.id")));
        Map<Long, DynamicObject> adjConfirmTemplateDyObjs = this.adjConfirmTemplateService.queryAdjConfirmTemplate(templateIdSet);
        HashMap adjConfirmTemplates = Maps.newHashMapWithExpectedSize((int)adjApprovalBills.size());
        for (Map.Entry<Long, Long> adjApprovalBill : adjApprovalBills.entrySet()) {
            Long adjConfirmPersonId = adjApprovalBill.getKey();
            Long billId = adjApprovalBills.get(adjConfirmPersonId);
            long scmId = billObjMap.get(billId).getLong("salaryadjscm.id");
            DynamicObject scmObj = adjTplObjMap.get(scmId);
            DynamicObject tplObj = adjConfirmTemplateDyObjs.get(scmObj.getLong("adjconfirmtpl.id"));
            adjConfirmTemplates.put(adjConfirmPersonId, tplObj);
        }
        return adjConfirmTemplates;
    }

    public Map<String, String> getVarParamMap() {
        return this.adjConfirmTemplateService.createVarParamMap();
    }

    public void insertAdjConfirmPerson(DynamicObject[] adjConfirmPersonObjs) {
        this.adjConfirmPersonService.insertAdjConfirmPerson(adjConfirmPersonObjs);
    }

    public Map<Long, Long> queryHrPersonId(List<Long> adjConfirmPersonIds) {
        return this.adjConfirmPersonService.queryHrPersonId(adjConfirmPersonIds);
    }

    public DynamicObject[] queryAdjConfirmPersonOfTotal(long adjApprovalBillId, String keyword) {
        return this.adjConfirmPersonService.queryAllPerson(adjApprovalBillId, keyword);
    }

    public DynamicObject[] queryAdjConfirmPersonOfNotSent(long adjApprovalBillId, String keyword) {
        return this.adjConfirmPersonService.queryPersonOfNotSent(adjApprovalBillId, keyword);
    }

    public DynamicObject[] queryAdjConfirmPersonOfOfflineConfirm(long adjApprovalBillId, String keyword) {
        return this.adjConfirmPersonService.queryPersonOfOffLineConfirmed(adjApprovalBillId, keyword);
    }

    public DynamicObject[] queryAdjConfirmPersonOfHasSent(long adjApprovalBillId, String keyword) {
        return this.adjConfirmPersonService.queryPersonOfHasSent(adjApprovalBillId, keyword);
    }

    public DynamicObject[] queryConfirmPerson(List<Long> adjConfirmPersonIds) {
        return this.adjConfirmPersonService.queryPersonById(null, adjConfirmPersonIds);
    }

    public Map<Long, DynamicObject> queryAdjBillObjs(String selectProperties, List<Long> adjBillIds) {
        if (CollectionUtils.isEmpty(adjBillIds)) {
            return Collections.emptyMap();
        }
        DynamicObject[] result = StringUtils.isEmpty((CharSequence)selectProperties) ? this.serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", adjBillIds)}) : this.serviceHelper.query(selectProperties, new QFilter[]{new QFilter("id", "in", adjBillIds)});
        return Arrays.stream(result).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
    }

    @Deprecated
    public List<DynamicObject> calcAndSaveApprovalBillForRate(Collection<DynamicObject> billEntities) {
        ArrayList hasChangedSet = Lists.newArrayList();
        for (DynamicObject billEntity : billEntities) {
            Collection changedEntry = null;
            if (CollectionUtils.isEmpty(changedEntry)) continue;
            hasChangedSet.add(billEntity);
        }
        if (CollectionUtils.isNotEmpty((Collection)hasChangedSet)) {
            new SWCDataServiceHelper(MAIN_ENTITY).update(hasChangedSet.toArray(new DynamicObject[0]));
        }
        return hasChangedSet;
    }

    public DynamicObject queryAdjConfirmPersonById(long adjConfirmPersonId) {
        return this.adjConfirmPersonService.queryAdjConfirmPersonById(adjConfirmPersonId);
    }

    public Map<Long, DynamicObject> queryAdjSchema(String selectProperties, Collection<Long> schemaIds) {
        DynamicObject[] dynamicObjects = this.adjSchemeService.queryAdjSchemaByIds(selectProperties, schemaIds);
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
    }

    public List<Long> getEnableConfirmBill(List<Long> adjApprovalBillIds) {
        if (CollectionUtils.isEmpty(adjApprovalBillIds)) {
            return Collections.emptyList();
        }
        Map<Long, DynamicObject> billObjMap = this.queryAdjBillObjs("id,salaryadjscm", adjApprovalBillIds);
        Iterator<Map.Entry<Long, DynamicObject>> it = billObjMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, DynamicObject> next = it.next();
            DynamicObject value = next.getValue();
            if (value.getLong("salaryadjscm.id") != 0L && value.getBoolean("salaryadjscm.enableconfirm")) continue;
            it.remove();
        }
        return Lists.newArrayList(billObjMap.keySet());
    }

    public DynamicObject[] getAdjFieldCfgWithPerm(Long createOrgId, String attributionType) {
        return this.adjSchemeService.getAdjFieldCfgWithPerm(createOrgId, attributionType);
    }

    public DynamicObject getAdjFieldCfgById(Long pkId) {
        return this.adjSchemeService.getAdjFieldCfgById(pkId);
    }

    public Boolean isExistAdjApprBill(Set<Long> adjApprovalBillIds) {
        if (null == adjApprovalBillIds || adjApprovalBillIds.isEmpty()) {
            return Boolean.FALSE;
        }
        QFilter qFilter = new QFilter("id", "in", adjApprovalBillIds);
        List<String> billStatus = Arrays.asList("A", "B", "G", "D");
        qFilter.and("billstatus", "in", billStatus);
        return this.serviceHelper.isExists((Object)qFilter);
    }

    public DynamicObject[] getAdjDetailFields(String attributionType) {
        return this.adjSchemeService.queryAdjDetailField(attributionType);
    }
}

