/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapplication.domain.adjfile.entityservice;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

@HrDomainEntity
public class DecideAdjSalaryService {
    private static final String ENTITY_NUMBER = "hcdm_salaryadjrecord";
    private final SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
    private static Log logger = LogFactory.getLog(DecideAdjSalaryService.class);

    private static String getSelectProperties() {
        return SWCHisBaseDataHelper.getSelectProperties((String)ENTITY_NUMBER);
    }

    public DynamicObject[] querySelectPropertyByFile(String selectFields, Collection<Long> fileIds, boolean withCurrentVersion) {
        QFilter qFilter = new QFilter("salaryadjfile", "in", fileIds);
        if (withCurrentVersion) {
            BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter initstatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"2", " "});
        return this.helper.query(selectFields, new QFilter[]{qFilter, initstatusFilter, statusFilter});
    }

    public DynamicObject[] queryAllPropertyByFile(Collection<Long> fileIds, boolean withCurrentVersion) {
        QFilter qFilter = new QFilter("salaryadjfile", "in", fileIds);
        if (withCurrentVersion) {
            BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter initstatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"2", " "});
        return this.helper.loadDynamicObjectArray(ENTITY_NUMBER, new QFilter[]{qFilter, initstatusFilter, statusFilter});
    }

    public DynamicObject generateEmptyEntity() {
        return this.helper.generateEmptyDynamicObject();
    }

    public OperationResult saveByOperate(List<DynamicObject> saveItemList, Long eventId) {
        if (CollectionUtils.isNotEmpty(saveItemList)) {
            DynamicObject[] dyArray = new DynamicObject[saveItemList.size()];
            dyArray = saveItemList.toArray(dyArray);
            OperateOption option = OperateOption.create();
            option.setVariableValue("status", "C");
            option.setVariableValue("eventId", String.valueOf(eventId));
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("skipCheckDataPermission", "true");
            option.setVariableValue("skipCheckSpecialDataPermission", "true");
            return OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_NUMBER, (DynamicObject[])dyArray, (OperateOption)option);
        }
        return null;
    }

    public DynamicObject[] queryCurDateItemVersion(Collection<Long> fileIds, Object isHistoryPage, Long itemId) {
        QFilter bsedfilter;
        Date curDate = SWCDateTimeUtils.getTodayDateWithoutTime();
        QFilter fileFilter = null;
        if (ObjectUtils.isNotEmpty((Object)isHistoryPage)) {
            if (SWCObjectUtils.isEmpty((Object)itemId)) {
                fileFilter = new QFilter("salaryadjfilevid", "in", fileIds);
                bsedfilter = new QFilter("bsed", "<=", (Object)curDate);
                bsedfilter.and(new QFilter("bsled", ">=", (Object)curDate));
                fileFilter.and(bsedfilter);
            } else {
                fileFilter = new QFilter("salaryadjfile", "in", fileIds);
                fileFilter.and("standarditem.id", "=", (Object)itemId);
            }
        } else {
            fileFilter = new QFilter("salaryadjfile", "in", fileIds);
            if (SWCObjectUtils.isEmpty((Object)itemId)) {
                bsedfilter = new QFilter("bsed", "<=", (Object)curDate);
                bsedfilter.and(new QFilter("bsled", ">=", (Object)curDate));
                fileFilter.and(bsedfilter);
            } else {
                fileFilter.and("standarditem.id", "=", (Object)itemId);
            }
        }
        BaseDataHisHelper.addHisVerFilter((QFilter)fileFilter);
        QFilter statusfilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        QFilter enablefilter = new QFilter("enable", "=", (Object)"1");
        QFilter initstatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"2", " "});
        logger.info("queryCurDateItemVersion statusfilter ={}, enablefilter={}, initstatusFilter={}, fileFilter={}", new Object[]{statusfilter, enablefilter, initstatusFilter, fileFilter});
        return this.helper.query(DecideAdjSalaryService.getSelectProperties(), new QFilter[]{fileFilter, statusfilter, enablefilter, initstatusFilter});
    }

    public DynamicObject[] queryAllHisVerision(Long fileId, boolean isShowLogicdelete, Object isHistoryPage) {
        if (ObjectUtils.isNotEmpty((Object)isHistoryPage)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
            DynamicObject adjFileVersionDy = helper.queryOne((Object)fileId);
            fileId = adjFileVersionDy.getLong("boid");
        }
        QFilter idFilter = new QFilter("salaryadjfile.id", "=", (Object)fileId);
        BaseDataHisHelper.addHisVerFilter((QFilter)idFilter);
        HashSet datastatusSet = Sets.newHashSet((Object[])new String[]{"0", "1", "2"});
        if (isShowLogicdelete) {
            datastatusSet.add("-2");
        }
        QFilter statusfilter = new QFilter("datastatus", "in", (Object)datastatusSet);
        QFilter initstatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"2", " "});
        QFilter enablefilter = new QFilter("enable", "=", (Object)"1");
        return this.helper.query(DecideAdjSalaryService.getSelectProperties(), new QFilter[]{idFilter, statusfilter, enablefilter, initstatusFilter});
    }

    public DynamicObject[] queryRecordByFileAndItem(Collection<Long> fileIds, Collection<Long> itemIds) {
        return this.queryRecordByFileAndItem(DecideAdjSalaryService.getSelectProperties(), fileIds, itemIds);
    }

    public DynamicObject[] queryRecordByFileAndItem(String props, Collection<Long> fileIds, Collection<Long> itemIds) {
        QFilter fileIdFilter = new QFilter("salaryadjfile.id", "in", fileIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)fileIdFilter);
        QFilter itemFilter = new QFilter("standarditem.id", "in", itemIds);
        QFilter initstatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"2", " "});
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return this.helper.query(props, new QFilter[]{fileIdFilter, itemFilter, initstatusFilter, statusFilter});
    }

    public DynamicObject[] queryRecordsByFileAndItem(Collection<Long> fileIds, Collection<Long> itemIds) {
        QFilter fileIdFilter = new QFilter("salaryadjfile.id", "in", fileIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)fileIdFilter);
        QFilter itemFilter = new QFilter("standarditem.id", "in", itemIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "2", "1"});
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return this.helper.query(DecideAdjSalaryService.getSelectProperties(), new QFilter[]{fileIdFilter, itemFilter, dataStatusFilter, statusFilter, enableFilter});
    }

    public DynamicObject[] queryAllVersionDecideAdjSalaryObjsByFileBoId(Set<Long> BoIdSet) {
        QFilter boIdFilter = new QFilter("salaryadjfile.id", "in", BoIdSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter initstatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"2", " "});
        return this.helper.loadDynamicObjectArray(new QFilter[]{boIdFilter, versionFilter, statusFilter, initstatusFilter});
    }

    public DynamicObject[] queryDataByFilter(String selectFields, QFilter[] qFilters) {
        return this.helper.query(selectFields, qFilters);
    }

    public long[] genEventPkId(int size) {
        return DB.genLongIds((String)ENTITY_NUMBER, (int)size);
    }

    public void deleteInitDataByFilter(QFilter[] filters) {
        this.helper.deleteByFilter(filters);
    }

    public DynamicObject[] queryDecAdjReocrdByFileBOIds(Collection<Long> fileIds, boolean withCurrentVersion) {
        QFilter qFilter = new QFilter("salaryadjfile", "in", fileIds);
        if (withCurrentVersion) {
            BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter initstatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"2", " "});
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "2", "1"});
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.helper.loadDynamicObjectArray(ENTITY_NUMBER, new QFilter[]{qFilter, initstatusFilter, statusFilter, dataStatusFilter, enableFilter});
    }
}

