/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapplication.domain.adjfile.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.sdk.swc.hcdm.common.Pair;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.entityservice.DecideAdjSalEventService;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.entityservice.DecideAdjSalaryService;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.entityservice.RelPersonService;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalGridHelper;
import kd.swc.hcdm.business.his.BdHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

@HrDomainEntity
public class AdjFileDomainService {
    public static final String MAIN_ENTITY_NUMBER = "hcdm_adjfileinfo";
    private static final String DELIMITER = "_";
    private static final Log logger = LogFactory.getLog(AdjFileDomainService.class);
    private SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
    private DecideAdjSalaryService decideAdjSalaryService;
    private RelPersonService relPersonService;
    private DecideAdjSalEventService eventService;

    public DecideAdjSalEventService getEventService() {
        return this.eventService;
    }

    public void setEventService(DecideAdjSalEventService eventService) {
        this.eventService = eventService;
    }

    public RelPersonService getRelPersonService() {
        return this.relPersonService;
    }

    public void setRelPersonService(RelPersonService relPersonService) {
        this.relPersonService = relPersonService;
    }

    public DecideAdjSalaryService getDecideAdjSalaryService() {
        return this.decideAdjSalaryService;
    }

    public void setDecideAdjSalaryService(DecideAdjSalaryService decideAdjSalaryService) {
        this.decideAdjSalaryService = decideAdjSalaryService;
    }

    public Map<Long, Long> queryHrPersonId(List<Long> adjFileIds) {
        DynamicObject[] fileObjs = this.serviceHelper.query("id,person.id", new QFilter[]{new QFilter("id", "in", adjFileIds)});
        return Arrays.stream(fileObjs).collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1.getLong("person.id")));
    }

    public Map<Long, Long> queryEmployeeId(List<Long> adjFileIds) {
        DynamicObject[] fileObjs = this.serviceHelper.query("id,employee.id", new QFilter[]{new QFilter("id", "in", adjFileIds)});
        return Arrays.stream(fileObjs).collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1.getLong("employee.id")));
    }

    public Map<Long, Long> queryEmpposorgrelId(List<Long> adjFileIds) {
        DynamicObject[] fileObjs = this.serviceHelper.query("id,empposorgrel.id", new QFilter[]{new QFilter("id", "in", adjFileIds)});
        return Arrays.stream(fileObjs).collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1.getLong("empposorgrel.id")));
    }

    public Map<Long, DynamicObject> queryPersonContactInfo(List<Long> hrPersonIds, String fields) {
        SWCDataServiceHelper contactServiceHelper = new SWCDataServiceHelper("hrpi_percontact");
        String personField = "person.id";
        if (!fields.contains(personField)) {
            fields = personField + "," + fields;
        }
        QFilter filter = new QFilter(personField, "in", hrPersonIds);
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] objects = contactServiceHelper.query(fields, new QFilter[]{filter, qFilter});
        return Arrays.stream(objects).collect(Collectors.toMap(o1 -> o1.getLong(personField), Function.identity()));
    }

    public Map<Long, DynamicObject> queryPersonPernontsprop(List<Long> hrPersonIds, String fields) {
        SWCDataServiceHelper contactServiceHelper = new SWCDataServiceHelper("hrpi_pernontsprop");
        String personField = "person.id";
        if (!fields.contains(personField)) {
            fields = personField + "," + fields;
        }
        QFilter filter = new QFilter(personField, "in", hrPersonIds);
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] objects = contactServiceHelper.query(fields, new QFilter[]{filter, qFilter});
        return Arrays.stream(objects).collect(Collectors.toMap(o1 -> o1.getLong(personField), Function.identity()));
    }

    public Map<Long, Long> queryEmployeePersonId(List<Long> adjFileIds) {
        DynamicObject[] fileObjs = this.serviceHelper.query("id,depemp.employee.id", new QFilter[]{new QFilter("id", "in", adjFileIds)});
        return Arrays.stream(fileObjs).collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1.getLong("depemp.employee.id")));
    }

    public Map<Long, DynamicObject> queryFileBizInfo(Collection<Long> adjFileIds, String fields) {
        DynamicObject[] fileObjs = this.serviceHelper.query(fields, new QFilter[]{new QFilter("id", "in", adjFileIds)});
        return Arrays.stream(fileObjs).collect(Collectors.toMap(o1 -> o1.getLong("id"), Function.identity()));
    }

    public Map<Long, DynamicObject> queryJobLevel(List<Long> employeePersonIds, String fields) {
        return AdjApprovalGridHelper.queryEmpJobRel(new HashSet<Long>(employeePersonIds));
    }

    public DynamicObject[] queryDecideAdjSalaryObj(Collection<Long> fileKeySet, boolean withCurrentVersion) {
        return this.decideAdjSalaryService.queryAllPropertyByFile(fileKeySet, withCurrentVersion);
    }

    public DynamicObject[] queryDecideAdjSalaryObj(String selectFields, Collection<Long> fileKeySet, boolean withCurrentVersion) {
        return this.decideAdjSalaryService.querySelectPropertyByFile(selectFields, fileKeySet, withCurrentVersion);
    }

    public DynamicObject[] queryDecAdjReocrdByFileBOIds(Collection<Long> fileKeySet, boolean withCurrentVersion) {
        return this.decideAdjSalaryService.queryDecAdjReocrdByFileBOIds(fileKeySet, withCurrentVersion);
    }

    public DynamicObject[] queryAllVersionDecideAdjSalaryObjsByFileBoId(Set<Long> BoIdSet) {
        return this.decideAdjSalaryService.queryAllVersionDecideAdjSalaryObjsByFileBoId(BoIdSet);
    }

    public DynamicObject generateEmptyDecideAdjSalary() {
        return this.decideAdjSalaryService.generateEmptyEntity();
    }

    public Map<Long, DynamicObject> getEmpposorgrelData(Set<Long> empIds) {
        if (empIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_empposorgrel");
        DynamicObject[] objects = service.query("id, datastatus,company, adminorg, position, job,workplace", new QFilter[]{new QFilter("id", "in", empIds)});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("id"), object);
        }
        return data;
    }

    public Map<Long, DynamicObject> getAdjFileInfoData(Set<Long> adjFileIds) {
        if (adjFileIds.isEmpty()) {
            return Collections.emptyMap();
        }
        DynamicObject[] objects = this.serviceHelper.query("id, org.name, country.name, depcytype.name, adminorg.name, employee.empnumber,empposorgrel", new QFilter[]{new QFilter("id", "in", adjFileIds)});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("id"), object);
        }
        return data;
    }

    public Map<Long, Long> queryBosUserIdByHrPersonId(List<Long> hrPersonIds) {
        Map<String, List<Long>> idMaps = Collections.singletonMap("person", hrPersonIds);
        Map result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (!((Boolean)result.get("success")).booleanValue()) {
            return Collections.emptyMap();
        }
        Map hrToBosUserMap = (Map)result.get("data");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)hrPersonIds.size());
        for (Map.Entry entry : hrToBosUserMap.entrySet()) {
            resultMap.put(entry.getKey(), ((Map)entry.getValue()).get("user"));
        }
        return resultMap;
    }

    private Comparator<DynamicObject> getBsedComparator() {
        return new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date o1Date = o1.getDate("bsed");
                Date o2Date = o2.getDate("bsed");
                return o1Date.compareTo(o2Date);
            }
        };
    }

    public Map<Long, Long> getWorkplaceByFile(Set<Long> fileIds) {
        ArrayList<Long> fileIdList = new ArrayList<Long>(fileIds);
        Map<Long, Long> empposorgrelIds = this.queryEmpposorgrelId(fileIdList);
        Map<Long, DynamicObject> empposorgrelMap = this.getEmpposorgrelData(new HashSet<Long>(empposorgrelIds.values()));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        for (Long fileId : fileIds) {
            Long empposorgrelId = empposorgrelIds.get(fileId);
            DynamicObject empposorgrelObj = empposorgrelMap.get(empposorgrelId);
            if (empposorgrelObj == null) continue;
            resultMap.put(fileId, empposorgrelObj.getLong("workplace.id"));
        }
        return resultMap;
    }

    public Map<Long, DynamicObject> getEmpposorgrelObjByFileId(Collection<Long> fileIds) {
        ArrayList<Long> fileIdList = new ArrayList<Long>(fileIds);
        Map<Long, Long> empposorgrelIds = this.queryEmpposorgrelId(fileIdList);
        Map<Long, DynamicObject> empposorgrelMap = this.getEmpposorgrelData(new HashSet<Long>(empposorgrelIds.values()));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        for (Long fileId : fileIds) {
            Long empposorgrelId = empposorgrelIds.get(fileId);
            DynamicObject empposorgrelObj = empposorgrelMap.get(empposorgrelId);
            if (empposorgrelObj == null) continue;
            resultMap.put(fileId, empposorgrelObj);
        }
        return resultMap;
    }

    public Map<Long, Long> getDepartmentByFile(Set<Long> fileIds) {
        ArrayList<Long> fileIdList = new ArrayList<Long>(fileIds);
        Map<Long, Long> empposorgrelIds = this.queryEmpposorgrelId(fileIdList);
        Map<Long, DynamicObject> empposorgrelMap = this.getEmpposorgrelData(new HashSet<Long>(empposorgrelIds.values()));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        for (Long fileId : fileIds) {
            Long empposorgrelId = empposorgrelIds.get(fileId);
            DynamicObject empposorgrelObj = empposorgrelMap.get(empposorgrelId);
            if (empposorgrelObj == null) continue;
            resultMap.put(fileId, empposorgrelObj.getLong("adminorg.id"));
        }
        return resultMap;
    }

    public Map<Long, Long> getWorkplaceByDepEmp(Set<Long> depempIds) {
        Map<Long, DynamicObject> depEmpToEmpPosOrgRelMap = this.queryLatestEmpPosOrgRelByDepEmpId(depempIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)depempIds.size());
        for (Long depempId : depempIds) {
            DynamicObject empposorgrelObj = depEmpToEmpPosOrgRelMap.get(depempId);
            if (empposorgrelObj == null) continue;
            resultMap.put(depempId, empposorgrelObj.getLong("workplace.id"));
        }
        return resultMap;
    }

    public Map<Long, Long> getDepartmentByDepEmp(Set<Long> depempIds) {
        Map<Long, DynamicObject> depEmpToEmpPosOrgRelMap = this.queryLatestEmpPosOrgRelByDepEmpId(depempIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)depempIds.size());
        for (Long depempId : depempIds) {
            DynamicObject empposorgrelObj = depEmpToEmpPosOrgRelMap.get(depempId);
            if (empposorgrelObj == null) continue;
            resultMap.put(depempId, empposorgrelObj.getLong("adminorg.id"));
        }
        return resultMap;
    }

    public List<DynamicObject> getSortedBsedByAsc(DynamicObjectCollection dynamicObjectCollection) {
        Comparator<DynamicObject> bsedSortCompare = this.getBsedComparator();
        return dynamicObjectCollection.stream().sorted(bsedSortCompare).collect(Collectors.toList());
    }

    public List<DynamicObject> getSortedBsedByAsc(DynamicObject[] dynamicObjectArray) {
        Comparator<DynamicObject> bsedSortCompare = this.getBsedComparator();
        return Arrays.stream(dynamicObjectArray).sorted(bsedSortCompare).collect(Collectors.toList());
    }

    public void saveRelPerson(List<DynamicObject> saveList) {
        this.relPersonService.save(saveList);
    }

    public OperationResult saveItemDataByOperate(List<DynamicObject> saveItemList, Long eventId) {
        return this.decideAdjSalaryService.saveByOperate(saveItemList, eventId);
    }

    public long[] genRelPersonPkId(int size) {
        return this.relPersonService.genRelPersonPkId(size);
    }

    public long[] genEventPkId(int size) {
        return this.eventService.genEventPkId(size);
    }

    public DynamicObject queryByEvent(String event) {
        return this.eventService.queryByEvent(event);
    }

    public void saveDecAdjEvent(List<DynamicObject> saveList) {
        this.eventService.save(saveList);
    }

    public DynamicObject generateEmptyDecideAdjEvent() {
        return this.eventService.generateEmptyEntity();
    }

    public String beginEvent(String type) {
        return type + "&" + UUID.randomUUID();
    }

    public void endEvent(Collection<String> event) {
        this.eventService.updateStatusDone(event);
    }

    public Map<Long, Map<Long, DynamicObject>> getLatestDecAdjSalary(Map<Long, Set<Long>> fileItemIdMap, boolean isQueryLatest) {
        return this.getLatestDecAdjSalary(SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_salaryadjrecord"), fileItemIdMap, isQueryLatest);
    }

    public Map<Long, Map<Long, DynamicObject>> getLatestDecAdjSalary(String selProps, Map<Long, Set<Long>> fileItemIdMap, boolean isQueryLatest) {
        HashSet<Long> fileIds = new HashSet<Long>(16);
        HashSet<Long> itemParamIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> entry : fileItemIdMap.entrySet()) {
            fileIds.add(entry.getKey());
            itemParamIds.addAll((Collection<Long>)entry.getValue());
        }
        DynamicObject[] decideAdjSalaryObj = this.decideAdjSalaryService.queryRecordByFileAndItem(selProps, fileIds, itemParamIds);
        Comparator<DynamicObject> bsedSortCompare = this.getBsedComparator();
        Map<Long, List<DynamicObject>> decideAdjSalaryObjAfterSort = Arrays.stream(decideAdjSalaryObj).sorted(bsedSortCompare.reversed()).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfile.id")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileItemIdMap.size());
        for (Map.Entry<Long, Set<Long>> entry : fileItemIdMap.entrySet()) {
            Long fileId = entry.getKey();
            Set<Long> itemIds = entry.getValue();
            Map subMapOfCurFile = resultMap.computeIfAbsent(fileId, obj -> Maps.newHashMap());
            List<DynamicObject> salaryObjOfCurFiles = decideAdjSalaryObjAfterSort.get(fileId);
            if (salaryObjOfCurFiles == null) continue;
            block2: for (Long itemId : itemIds) {
                if (itemId == 0L) continue;
                for (DynamicObject salaryObjVersion : salaryObjOfCurFiles) {
                    if (isQueryLatest) {
                        if (itemId.longValue() != salaryObjVersion.getLong("standarditem.id") || !BdHisHelper.checkAvailableVersion(salaryObjVersion)) continue;
                        subMapOfCurFile.put(itemId, salaryObjVersion);
                        continue block2;
                    }
                    if (itemId.longValue() != salaryObjVersion.getLong("standarditem.id") || !BdHisHelper.checkEffectingVersion(salaryObjVersion)) continue;
                    subMapOfCurFile.put(itemId, salaryObjVersion);
                    continue block2;
                }
            }
        }
        return resultMap;
    }

    public Map<Long, Map<Long, DynamicObject>> getLatestDecAdjSalaryByBsed(Map<Long, Map<Long, Pair<Long, Date>>> fileItemRecordIdBsedMap, String type) {
        if (MapUtils.isEmpty(fileItemRecordIdBsedMap)) {
            return ImmutableMap.of();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileItemRecordIdBsedMap.size());
        HashMap loggerMap = Maps.newHashMapWithExpectedSize((int)fileItemRecordIdBsedMap.size());
        logger.info("getLatestDecAdjSalaryByBsed params is [{}] ,type is [{}]", (Object)JSON.toJSONString(fileItemRecordIdBsedMap), (Object)type);
        HashSet fileBoIdSet = Sets.newHashSetWithExpectedSize((int)fileItemRecordIdBsedMap.size());
        HashSet itemIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<Long, Map<Long, Pair<Long, Date>>> entry : fileItemRecordIdBsedMap.entrySet()) {
            fileBoIdSet.add(entry.getKey());
            itemIdSet.addAll(entry.getValue().keySet());
        }
        DynamicObject[] decideAdjSalaryObjArray = this.decideAdjSalaryService.queryRecordsByFileAndItem(fileBoIdSet, itemIdSet);
        Comparator<DynamicObject> bsedSortCompare = this.getBsedComparator();
        Map<Long, List<DynamicObject>> decideAdjSalaryObjAfterSort = Arrays.stream(decideAdjSalaryObjArray).sorted(bsedSortCompare.reversed()).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfile.id")));
        logger.info("getLatestDecAdjSalaryByBsed decideAdjSalaryObjAfterSort is {}", decideAdjSalaryObjAfterSort);
        for (Map.Entry<Long, Map<Long, Pair<Long, Date>>> entry : fileItemRecordIdBsedMap.entrySet()) {
            Long fileBoId = entry.getKey();
            Map<Long, Pair<Long, Date>> itemIdToRecordIdDateMap = entry.getValue();
            Set<Long> itemIds = entry.getValue().keySet();
            Map subMapOfCurFile = resultMap.computeIfAbsent(fileBoId, obj -> Maps.newHashMap());
            Map subMapOfLoggerMap = loggerMap.computeIfAbsent(fileBoId, obj -> Maps.newHashMap());
            List<DynamicObject> salaryObjOfCurFiles = decideAdjSalaryObjAfterSort.get(fileBoId);
            if (salaryObjOfCurFiles == null) continue;
            block2: for (Long itemId : itemIds) {
                Date bsled;
                Date bsed;
                if (itemId == 0L || CollectionUtils.isEmpty(salaryObjOfCurFiles)) continue;
                ArrayList tempDyLists = Lists.newArrayList();
                Date date = (Date)itemIdToRecordIdDateMap.get(itemId).getValue();
                if (Objects.isNull(date)) continue;
                for (DynamicObject decAdjRecordDy : salaryObjOfCurFiles) {
                    bsed = decAdjRecordDy.getDate("bsed");
                    bsled = decAdjRecordDy.getDate("bsled");
                    if (bsed.compareTo(date) <= 0 && bsled.compareTo(date) >= 0 || itemId.longValue() != decAdjRecordDy.getLong("standarditem.id")) continue;
                    tempDyLists.add(decAdjRecordDy);
                }
                for (DynamicObject decAdjRecordDy : tempDyLists) {
                    bsed = decAdjRecordDy.getDate("bsed");
                    bsled = decAdjRecordDy.getDate("bsled");
                    subMapOfCurFile.put(itemId, null);
                    subMapOfLoggerMap.put(itemId, null);
                    if (bsed.compareTo(date) > 0 && (bsed.compareTo(date) > 0 || bsled.compareTo(date) < 0)) continue;
                    subMapOfCurFile.put(itemId, decAdjRecordDy);
                    subMapOfLoggerMap.put(itemId, decAdjRecordDy.getLong("id"));
                    continue block2;
                }
            }
        }
        logger.info("getLatestDecAdjSalaryByBsed loggerMap is [{}]", (Object)JSON.toJSONString((Object)loggerMap));
        return resultMap;
    }

    public Map<Long, Map<Long, List<DynamicObject>>> getSortedAdjFileBoIdToItemIdToRecordList(Set<Long> salaryAdjFileBoidSet, Set<Long> itemIdSet) {
        DynamicObject[] recordDys = this.decideAdjSalaryService.queryRecordsByFileAndItem(salaryAdjFileBoidSet, itemIdSet);
        logger.info("getSortedAdjFileBoIdToItemIdToRecordList recordDys id is {}", Arrays.stream(recordDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        return Arrays.stream(recordDys).sorted(Comparator.comparing(o -> o.getDate("bsed"))).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfile.id"), Collectors.groupingBy(o1 -> o1.getLong("standarditem.id"))));
    }

    public Map<String, List<DynamicObject>> getInfluencedHisDataByFileBoidAndItemId(List<DynamicObject> dynamicObjects) {
        Set<Long> salaryAdjFileBoidSet = dynamicObjects.stream().flatMap(dy -> dy.getDynamicObjectCollection("revisionentry").stream()).map(dy -> dy.getLong("salaryadjfile_r.boid")).collect(Collectors.toSet());
        Set<Long> itemIdSet = dynamicObjects.stream().flatMap(dy -> dy.getDynamicObjectCollection("revisionentry").stream()).map(dy -> dy.getLong("standarditem_r.id")).collect(Collectors.toSet());
        Map<Long, Map<Long, List<DynamicObject>>> decideAdjSalaryObjAfterSort = this.getSortedAdjFileBoIdToItemIdToRecordList(salaryAdjFileBoidSet, itemIdSet);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryDys = dynamicObject.getDynamicObjectCollection("revisionentry");
            for (DynamicObject entryDy : entryDys) {
                long itemId;
                List<DynamicObject> recordList;
                long fileBoid = entryDy.getLong("salaryadjfile_r.boid");
                Map<Long, List<DynamicObject>> itemIdToRecordsMap = decideAdjSalaryObjAfterSort.get(fileBoid);
                if (CollectionUtils.isEmpty(itemIdToRecordsMap) || CollectionUtils.isEmpty(recordList = itemIdToRecordsMap.get(itemId = entryDy.getLong("standarditem_r.id")))) continue;
                Date mBsed = entryDy.getDate("bsed_r");
                Date mBsled = entryDy.getDate("bsled_r");
                String key = String.valueOf(fileBoid) + String.valueOf(itemId);
                List influencedRecordList = result.computeIfAbsent(key, obj -> Lists.newArrayList());
                for (DynamicObject recordDy : recordList) {
                    Date bsed = recordDy.getDate("bsed");
                    Date bsled = recordDy.getDate("bsled");
                    if (bsled.compareTo(mBsed) < 0 || mBsled.compareTo(bsed) < 0) continue;
                    influencedRecordList.add(recordDy);
                }
            }
        }
        return result;
    }

    public Map<Long, List<DynamicObject>> getCurDateItemVersion(Collection<Long> fileIds, Object isHistoryPage, Long itemId) {
        DynamicObject[] curDateItemVersions = this.decideAdjSalaryService.queryCurDateItemVersion(fileIds, isHistoryPage, itemId);
        if (ObjectUtils.isNotEmpty((Object)isHistoryPage)) {
            if (SWCObjectUtils.isEmpty((Object)itemId)) {
                return Arrays.stream(curDateItemVersions).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfilevid.id")));
            }
            return Arrays.stream(curDateItemVersions).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfile.id")));
        }
        return Arrays.stream(curDateItemVersions).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfile.id")));
    }

    public Map<Long, Date> getMaxBsedOfFile(Collection<Long> fileIds) {
        DynamicObject[] decideAdjSalaryObjs = this.decideAdjSalaryService.querySelectPropertyByFile("id,datastatus,enable,bsed,salaryadjfile.id", fileIds, false);
        Comparator<DynamicObject> bsedSortCompare = this.getBsedComparator();
        Map<Long, List<DynamicObject>> decideAdjSalaryObjAfterSort = Arrays.stream(decideAdjSalaryObjs).sorted(bsedSortCompare.reversed()).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfile.id")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        block0: for (Long fileId : fileIds) {
            List<DynamicObject> salaryObjOfCurFile = decideAdjSalaryObjAfterSort.get(fileId);
            resultMap.put(fileId, SWCBaseUtils.getMinEffectDate());
            if (salaryObjOfCurFile == null) continue;
            for (DynamicObject itemObj : salaryObjOfCurFile) {
                if (SWCStringUtils.equals((String)"-2", (String)itemObj.getString("datastatus")) || !SWCStringUtils.equals((String)"1", (String)itemObj.getString("enable")) || SWCStringUtils.equals((String)"-4", (String)itemObj.getString("datastatus"))) continue;
                resultMap.put(fileId, itemObj.getDate("bsed"));
                continue block0;
            }
        }
        return resultMap;
    }

    public List<Map<Date, List<DynamicObject>>> getAllDateVersion(Long filId, boolean isShowLogicdelete, Object isHistoryPage) {
        DynamicObject[] recordDyns = this.decideAdjSalaryService.queryAllHisVerision(filId, isShowLogicdelete, isHistoryPage);
        Comparator<DynamicObject> bsedSortCompare = this.getBsedComparator();
        List sortedVersions = Arrays.stream(recordDyns).sorted(bsedSortCompare.reversed()).collect(Collectors.toList());
        ArrayList allDateList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject sortedVersion : sortedVersions) {
            Date date = sortedVersion.getDate("bsed");
            if (allDateList.contains(date)) continue;
            allDateList.add(date);
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)allDateList.size());
        for (Date date : allDateList) {
            HashMap dateVersionMap = Maps.newHashMapWithExpectedSize((int)1);
            List itemDyns = dateVersionMap.computeIfAbsent(date, obj -> Lists.newArrayList());
            for (DynamicObject sortedVersion : sortedVersions) {
                Date bsed = sortedVersion.getDate("bsed");
                Date bsled = sortedVersion.getDate("bsled");
                if (!SWCDateTimeUtils.dayBefore((Date)bsed, (Date)date) && !SWCDateTimeUtils.dayEquals((Date)bsed, (Date)date) || !SWCDateTimeUtils.dayAfter((Date)bsled, (Date)date) && !SWCDateTimeUtils.dayEquals((Date)bsled, (Date)date)) continue;
                itemDyns.add(sortedVersion);
            }
            resultList.add(dateVersionMap);
        }
        return resultList;
    }

    public DynamicObject queryAdjFileByPersonId(String selectProperties, Long personId) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and(new QFilter("enable", "=", (Object)"1"));
        statusFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObjectCollection col = this.serviceHelper.queryOriginalCollection(selectProperties, new QFilter[]{statusFilter, new QFilter("person", "=", (Object)personId)});
        if (col.isEmpty()) {
            return null;
        }
        if (col.size() == 1) {
            return (DynamicObject)col.get(0);
        }
        Map data = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPrimaryEmpposorgrel", (Object[])new Object[]{personId});
        Long depempId = (Long)data.get("depemp_id");
        col = this.serviceHelper.queryOriginalCollection(selectProperties, new QFilter[]{statusFilter, new QFilter("depemp", "=", (Object)depempId)});
        if (col.size() == 1) {
            return (DynamicObject)col.get(0);
        }
        return null;
    }

    public DynamicObjectCollection queryAdjFileColByEmployeeId(String selectFields, Long employeeId) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and(new QFilter("enable", "=", (Object)"1"));
        statusFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObjectCollection col = this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{statusFilter, new QFilter("employee", "=", (Object)employeeId)});
        return col;
    }

    public DynamicObject[] queryDecAdjRecordByInitbatchId(String selectProperties, QFilter qFilter) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"A");
        QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)"-2");
        QFilter[] qFilters = new QFilter[]{qFilter, statusFilter, dataStatusFilter};
        return this.decideAdjSalaryService.queryDataByFilter(selectProperties, qFilters);
    }

    public DynamicObject[] queryRelPersonDyObjs(String selectProperties, Collection<Long> pkIds) {
        return this.relPersonService.queryRelPersonDyObjs(selectProperties, pkIds);
    }

    public long[] getDecAdjPkId(int size) {
        return this.decideAdjSalaryService.genEventPkId(size);
    }

    public Table<Long, Long, List<DynamicObject>> getAllDecAdjSalaryEffectVersion(Map<Long, Set<Long>> fileItemIdMap) {
        HashSet<Long> fileIds = new HashSet<Long>(16);
        HashSet<Long> itemParamIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> entry : fileItemIdMap.entrySet()) {
            fileIds.add(entry.getKey());
            itemParamIds.addAll((Collection<Long>)entry.getValue());
        }
        DynamicObject[] decideAdjSalaryObj = this.decideAdjSalaryService.queryRecordsByFileAndItem(fileIds, itemParamIds);
        Comparator<DynamicObject> bsedSortCompare = this.getBsedComparator();
        Map<Long, List<DynamicObject>> decideAdjSalaryObjAfterSort = Arrays.stream(decideAdjSalaryObj).sorted(bsedSortCompare).collect(Collectors.groupingBy(o1 -> o1.getLong("salaryadjfile.id")));
        HashBasedTable resultTable = HashBasedTable.create();
        for (Map.Entry<Long, Set<Long>> entry : fileItemIdMap.entrySet()) {
            Long fileId = entry.getKey();
            Set<Long> itemIds = entry.getValue();
            List<DynamicObject> salaryObjOfCurFiles = decideAdjSalaryObjAfterSort.get(fileId);
            if (salaryObjOfCurFiles == null) continue;
            for (Long itemId : itemIds) {
                if (itemId == null || itemId == 0L) continue;
                for (DynamicObject salaryObjVersion : salaryObjOfCurFiles) {
                    if (itemId.longValue() != salaryObjVersion.getLong("standarditem.id")) continue;
                    ArrayList<DynamicObject> dynamicObjects = (ArrayList<DynamicObject>)resultTable.get((Object)fileId, (Object)itemId);
                    if (dynamicObjects == null) {
                        dynamicObjects = new ArrayList<DynamicObject>(10);
                    }
                    dynamicObjects.add(salaryObjVersion);
                    resultTable.put((Object)fileId, (Object)itemId, dynamicObjects);
                }
            }
        }
        return resultTable;
    }

    public Map<String, List<DynamicObject>> getAllDecAdjSalaryEffectVersion(Set<String> empNumbers, Set<Long> orgIds, Set<Long> countryIds, Set<Long> stdScmVids, Set<Long> itemIds, Map<Long, Long> stdScmVidToBOMap) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select e.fid as id, e.fstandarditemid as itemid, t.fempnumber as fempnumber, t.forgid as forgid, t.fcountryid as fcountryid, t.fstdscmvid as fstdscmvid ");
        querySql.append("from t_hcdm_salaryadjrecord e left join t_hcdm_decadjrelperson t on e.frelpersonid = t.fid ");
        querySql.append("where ");
        querySql.append("t.fempnumber in (").append(AdjFileDomainService.getParamsByData(empNumbers));
        querySql.append(") and t.forgid in ").append(this.getSqlInParamsFormLong(orgIds));
        querySql.append(" and t.fcountryid in ").append(this.getSqlInParamsFormLong(countryIds));
        querySql.append(" and t.fstdscmvid in ").append(this.getSqlInParamsFormLong(stdScmVids));
        querySql.append(" and e.fstandarditemid in ").append(this.getSqlInParamsFormLong(itemIds));
        querySql.append(" and e.fenable = '1'").append(" and e.fstatus = 'C'").append(" and e.fdatastatus in ('0','1','2')");
        querySql.append(" and e.fiscurrentversion = '0'");
        Object[] params = new Object[empNumbers.size()];
        empNumbers.toArray(params);
        HashMap keyAndRecordIds = Maps.newHashMapWithExpectedSize((int)empNumbers.size());
        try (DataSet queryDataSet = HCDMDbHelper.queryDataSet(querySql.toString(), params);){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                Long pkid = row.getLong("id");
                Long standardItemId = row.getLong("itemid");
                String empNumber = row.getString("fempnumber");
                Long orgId = row.getLong("forgid");
                Long countryId = row.getLong("fcountryid");
                Long stdscmvid = row.getLong("fstdscmvid");
                Long stdScmBOId = stdScmVidToBOMap.get(stdscmvid);
                String combinesKey = this.generateKey(empNumber, String.valueOf(orgId), String.valueOf(countryId), String.valueOf(stdScmBOId), String.valueOf(standardItemId));
                Set itemMap = keyAndRecordIds.computeIfAbsent(combinesKey, v1 -> Sets.newHashSet());
                itemMap.add(pkid);
            }
        }
        catch (Exception exc) {
            logger.error("error in queryDataSet ", (Throwable)exc);
        }
        SWCMultithreadedQueryService service = SWCMultithreadedQueryService.getInstance();
        HashSet recordIds = Sets.newHashSetWithExpectedSize((int)16);
        keyAndRecordIds.values().forEach(recordIds::addAll);
        QFilter pkidFilter = new QFilter("id", "in", (Object)recordIds);
        DynamicObject[] noFileBatchDyObjs = null;
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(16);
        try {
            noFileBatchDyObjs = service.getData("hcdm_salaryadjrecord", this.getRecordSelectProperties(), new QFilter[]{pkidFilter}, "", 500);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Thread interrupt Error in AdjFileDomainService#getAllDecAdjSalaryEffectVersion {}", (Object)e.getMessage());
        }
        if (noFileBatchDyObjs != null) {
            block14: for (DynamicObject noFileBatchDyObj : noFileBatchDyObjs) {
                long id = noFileBatchDyObj.getLong("id");
                for (Map.Entry entry : keyAndRecordIds.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!((Set)entry.getValue()).contains(id)) continue;
                    List recordDys = result.computeIfAbsent(key, v1 -> Lists.newArrayList());
                    recordDys.add(noFileBatchDyObj);
                    continue block14;
                }
            }
        }
        return result;
    }

    public String generateKey(String ... keyElements) {
        StringJoiner sj = new StringJoiner(DELIMITER);
        for (String keyElement : keyElements) {
            sj.add(keyElement);
        }
        return sj.toString();
    }

    public String getRecordSelectProperties() {
        return SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_salaryadjrecord");
    }

    private static String getParamsByData(Set<String> params) {
        StringBuilder param = new StringBuilder();
        if (params.isEmpty()) {
            return param.append(' ').toString();
        }
        params.forEach(key -> param.append('?').append(','));
        return param.substring(0, param.length() - 1);
    }

    public String getSqlInParamsFormLong(Set<Long> params) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Long param : params) {
            sb.append(param);
            sb.append(',');
        }
        if (!params.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    public void deleteDecAdjInitDataByFilter(QFilter[] filters) {
        this.decideAdjSalaryService.deleteInitDataByFilter(filters);
    }

    public Map<Long, DynamicObject> queryLatestAdjFileByDepempId(String selectFields, Collection<Long> depEmpIds) {
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"A", "C", "D"});
        statusFilter.and(new QFilter("enable", "=", (Object)"1"));
        statusFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] col = this.serviceHelper.query(selectFields, new QFilter[]{statusFilter, new QFilter("depemp.id", "in", depEmpIds)});
        Map<Long, DynamicObject> collect = Arrays.stream(col).collect(Collectors.toMap(o1 -> o1.getLong("depemp.id"), Function.identity(), (o1, o2) -> o2));
        return collect;
    }

    public Map<Long, DynamicObject> queryLatestEmpPosOrgRelByDepEmpId(Set<Long> depEmpIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter personFilter = new QFilter("depemp.id", "in", depEmpIdSet);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter datastatus = new QFilter("datastatus", "!=", (Object)"-1");
        QFilter[] filters = new QFilter[]{personFilter, isCurrentVersionFilter, datastatus};
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(filters);
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("depemp.id"), value -> value, (o1, o2) -> o2));
    }

    public Map<Long, DynamicObject> queryAdjFileVersionsByWaiteffectAndDisable(Collection<Long> fileBoIds) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and(new QFilter("enable", "=", (Object)"0"));
        statusFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        statusFilter.and(new QFilter("boid", "in", fileBoIds));
        statusFilter.and(new QFilter("datastatus", "=", (Object)"0"));
        DynamicObject[] fileVersions = this.serviceHelper.query("id,boid,bsed,bsled", new QFilter[]{statusFilter});
        return Arrays.stream(fileVersions).collect(Collectors.toMap(key -> key.getLong("boid"), value -> value, (o1, o2) -> o2));
    }

    public Map<Long, List<DynamicObject>> queryAdjFileDisableVersions(Collection<Long> fileBoIds) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and(new QFilter("enable", "=", (Object)"0"));
        statusFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        statusFilter.and(new QFilter("boid", "in", fileBoIds));
        statusFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        DynamicObject[] fileDisableVersions = this.serviceHelper.query("id,boid,bsed,bsled", new QFilter[]{statusFilter}, "bsed asc");
        return Arrays.stream(fileDisableVersions).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    public Map<Long, List<DynamicObject>> queryAllAdjFileVersions(String selectStringFields, Collection<Long> fileBoIds) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        statusFilter.and(new QFilter("boid", "in", fileBoIds));
        statusFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        String selectField = null == selectStringFields ? SWCHisBaseDataHelper.getSelectProperties((String)MAIN_ENTITY_NUMBER) : selectStringFields;
        DynamicObject[] fileDisableVersions = this.serviceHelper.query(selectField, new QFilter[]{statusFilter}, "bsed asc");
        return Arrays.stream(fileDisableVersions).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    public DynamicObject[] queryUsableDataStatusVersionDisabledInBsed(Date bsed, Date bsled) {
        QFilter versionQfilter = new QFilter("iscurrentversion", "=", (Object)"0");
        versionQfilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        versionQfilter.and(new QFilter("bsed", "<=", (Object)bsled));
        versionQfilter.and(new QFilter("bsled", ">=", (Object)bsed));
        versionQfilter.and(new QFilter("enable", "=", (Object)"0"));
        return this.serviceHelper.query("id,boid,bsed,bsled", new QFilter[]{versionQfilter});
    }
}

