/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapplication.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.web.dto.SafeUrlDTO;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.MessageTemplateCalculate;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRStreamUtils;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.DefaultDecAdjApprSupportPlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IAdjConfirmPrintExtService;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.event.AdjConfirmPrintEvent;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.event.OnGetAdjConfirmSmsSendNumEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropForCandExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.CandContrastPropLoadEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.ContrastPropLoadEvent;
import kd.sdk.swc.hcdm.common.adj.PersonQueryParam;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.SimpleMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SimpleStdRangeMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SimpleStdRangeMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.StdMatchParamWithDepEmp;
import kd.sdk.swc.hcdm.common.stdtab.StdSimpleMatchResult;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.entityservice.AdjConfirmPrintExtService;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmConfirmType;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmFeedbackStatus;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmPasswordType;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmSendStatus;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.service.AdjApprovalDomainService;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.service.AdjFileDomainService;
import kd.swc.hcdm.business.adjapplication.interfaces.dto.VerifyCodeDto;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprBillSynService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.GradeAndRankNameHelper;
import kd.swc.hcdm.business.adjapprbill.adjconfirm.LoginVerifyCodeHelper;
import kd.swc.hcdm.business.adjapprbill.entity.AdjApprPerQueryParam;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.matchprop.HcdmContrastPropPlugin;
import kd.swc.hcdm.business.matchprop.HcdmContrastPropPluginByDepEmp;
import kd.swc.hcdm.business.matchprop.HcdmContrastPropPluginForCand;
import kd.swc.hcdm.business.matchprop.SalaryStdMatchManager;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableForCandidateParam;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.entity.adjapprbill.GradeAndRankNameEntity;
import kd.swc.hcdm.common.enums.ConfirmStatusEnum;
import kd.swc.hcdm.common.enums.DecAdjSynStatusEnum;
import kd.swc.hcdm.common.enums.SynOperationEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Pair;

@HrDomainEntity
public class AdjApprovalApplicationService {
    private static final Log logger = LogFactory.getLog(AdjApprovalApplicationService.class);
    private static final int SAVESCALE = 2;
    public static final Pattern HTML_PATTERN = Pattern.compile("<([^>]*)>");
    private AdjApprovalDomainService adjApprovalDomainService;
    private AdjFileApplicationService adjFileApplicationService;
    private AdjFileDomainService adjFileDomainService;
    private static final int SMS_SENDNUM_LIMIT = 100;

    private String getAdjApprPerProperties() {
        return SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjapprperson");
    }

    public AdjFileApplicationService getAdjFileApplicationService() {
        return this.adjFileApplicationService;
    }

    public void setAdjFileApplicationService(AdjFileApplicationService adjFileApplicationService) {
        this.adjFileApplicationService = adjFileApplicationService;
    }

    public AdjApprovalDomainService getAdjApprovalDomainService() {
        return this.adjApprovalDomainService;
    }

    public void setAdjApprovalDomainService(AdjApprovalDomainService adjApprovalDomainService) {
        this.adjApprovalDomainService = adjApprovalDomainService;
    }

    public AdjFileDomainService getAdjFileDomainService() {
        return this.adjFileDomainService;
    }

    public void setAdjFileDomainService(AdjFileDomainService adjFileDomainService) {
        this.adjFileDomainService = adjFileDomainService;
    }

    public void createAdjConfirmPerson(List<Long> adjApprovalBillIds) {
        Map<Long, Map<String, Integer>> feedbackStatistic = this.adjApprovalDomainService.countAdjConfirmStatistic(adjApprovalBillIds, null);
        adjApprovalBillIds = adjApprovalBillIds.stream().filter(aLong -> !feedbackStatistic.containsKey(aLong)).collect(Collectors.toList());
        if ((adjApprovalBillIds = this.adjApprovalDomainService.getEnableConfirmBill(adjApprovalBillIds)).isEmpty()) {
            return;
        }
        Map<Long, List<Long>> approvalPersonFileIds = this.adjApprovalDomainService.queryAdjApprovalPersonFileId(adjApprovalBillIds);
        for (Map.Entry<Long, List<Long>> entry : approvalPersonFileIds.entrySet()) {
            Long billId = entry.getKey();
            List partition = Lists.partition(entry.getValue(), (int)500);
            for (List fileIds : partition) {
                List<DynamicObject> insertObjs = this.createAdjConfirmPersonObj(billId, fileIds);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(insertObjs)) continue;
                this.adjApprovalDomainService.insertAdjConfirmPerson(insertObjs.toArray(new DynamicObject[0]));
            }
        }
    }

    public void createAdjConfirmPersonByFileId(Long billId, List<Long> approvalPersonFileIds) {
        List<DynamicObject> insertObjs = this.createAdjConfirmPersonObj(billId, approvalPersonFileIds);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(insertObjs)) {
            this.adjApprovalDomainService.insertAdjConfirmPerson(insertObjs.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> createAdjConfirmPersonObj(Long billId, List<Long> approvalPersonFileIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(approvalPersonFileIds)) {
            return Collections.emptyList();
        }
        Map<Long, Long> filePersonIdMap = this.adjFileDomainService.queryHrPersonId(Lists.newArrayList(approvalPersonFileIds));
        Map<Long, Long> fileEmployeeIdMap = this.adjFileDomainService.queryEmployeeId(Lists.newArrayList(approvalPersonFileIds));
        ArrayList insertObjs = Lists.newArrayListWithExpectedSize((int)approvalPersonFileIds.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hcdm_adjconfirmperson");
        for (Long fileId : approvalPersonFileIds) {
            DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
            object.set("adjapprovalbill", (Object)billId);
            object.set("adjfile", (Object)fileId);
            object.set("person", (Object)filePersonIdMap.get(fileId));
            object.set("employee", (Object)fileEmployeeIdMap.get(fileId));
            object.set("confirmstatus", (Object)AdjConfirmFeedbackStatus.NOT_CONFIRM.getCode());
            object.set("confirmtype", (Object)AdjConfirmConfirmType.ON_LINE.getCode());
            object.set("issend", (Object)AdjConfirmSendStatus.NOT_SENT.getCode());
            insertObjs.add(object);
        }
        return insertObjs;
    }

    public Map<Long, Map<String, Integer>> countAdjConfirmStatistic(List<Long> adjApprovalBillIds, String keyword) {
        return this.adjApprovalDomainService.countAdjConfirmStatistic(adjApprovalBillIds, keyword);
    }

    public DynamicObject[] queryAllConfirmPerson(long adjApprovalBillId, String keyword) {
        return this.adjApprovalDomainService.queryAdjConfirmPersonOfTotal(adjApprovalBillId, keyword);
    }

    public DynamicObject[] queryWaitSendConfirmPerson(long adjApprovalBillId, String keyword) {
        return this.adjApprovalDomainService.queryAdjConfirmPersonOfNotSent(adjApprovalBillId, keyword);
    }

    public DynamicObject[] queryHasSentConfirmPerson(long adjApprovalBillId, String keyword) {
        return this.adjApprovalDomainService.queryAdjConfirmPersonOfHasSent(adjApprovalBillId, keyword);
    }

    public DynamicObject[] queryOfflineConfirmPerson(long adjApprovalBillId, String keyword) {
        return this.adjApprovalDomainService.queryAdjConfirmPersonOfOfflineConfirm(adjApprovalBillId, keyword);
    }

    public Map<Long, DynamicObject> queryConfirmPerson(List<Long> adjConfirmPersonIds) {
        DynamicObject[] result = this.adjApprovalDomainService.queryConfirmPerson(adjConfirmPersonIds);
        return Arrays.stream(result).collect(Collectors.toMap(key -> key.getLong("id"), Function.identity()));
    }

    public Map<Long, List<Map<String, Object>>> getConfirmPersonAttachment(List<Long> adjConfirmPersonIds, boolean toZip) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(adjConfirmPersonIds)) {
            return Collections.emptyMap();
        }
        Map<Long, List<Map<String, Object>>> adjConfirmAttachment = this.adjApprovalDomainService.getAdjConfirmAttachment(adjConfirmPersonIds);
        if (!toZip) {
            return adjConfirmAttachment;
        }
        Map<Long, Long> personToBillMap = this.adjApprovalDomainService.queryAdjApprovalBillIds(adjConfirmPersonIds);
        Map<Long, DynamicObject> billObjMap = this.adjApprovalDomainService.queryAdjBillObjs(null, Lists.newArrayList(personToBillMap.values()));
        DynamicObject billObj = billObjMap.get(personToBillMap.get(adjConfirmPersonIds.get(0)));
        FileService service = FileServiceFactory.getAttachmentFileService();
        HashMap fileNumMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList subFileList = Lists.newArrayListWithExpectedSize((int)10);
        for (List<Map<String, Object>> maps : adjConfirmAttachment.values()) {
            for (Map<String, Object> file : maps) {
                String path = (String)file.get("url");
                path = path.substring(path.lastIndexOf("path=") + 5);
                String name = (String)file.get("name");
                String type = (String)file.get("type");
                Integer existNum = fileNumMap.getOrDefault(name, 0);
                if (existNum == 0) {
                    fileNumMap.put(name, 1);
                } else {
                    fileNumMap.put(name, existNum + 1);
                    String nameWithoutType = name.substring(0, name.lastIndexOf(46));
                    name = nameWithoutType + "(" + existNum + ")." + type;
                }
                try {
                    InputStream inputStream = service.getInputStream(path);
                    Throwable throwable = null;
                    try {
                        byte[] bytes = HRStreamUtils.readInputStream((InputStream)inputStream);
                        subFileList.add(Pair.create((Object)name, (Object)bytes));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    logger.error("\u8c03\u85aa\u786e\u8ba4\u4eba\u5458\u9644\u4ef6\u538b\u7f29\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (subFileList.isEmpty()) {
            return Collections.emptyMap();
        }
        byte[] zipFileBytes = this.zipFiles(subFileList);
        String msg = ResManager.loadKDString((String)"\u8c03\u85aa\u786e\u8ba4", (String)"AdjApprovalApplicationService_10", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String zipName = MessageFormat.format("{0}_{1}_{2}.{3}", billObj.getString("org.name"), msg, SWCInteDateTimeUtil.formateDate((Date)new Date()), "zip");
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName, zipFileBytes, 5000);
        Map<String, String> map = Collections.singletonMap("url", UrlService.getDomainContextUrl() + "/" + url);
        return Collections.singletonMap(adjConfirmPersonIds.get(0), Collections.singletonList(map));
    }

    /*
     * Exception decompiling
     */
    private byte[] zipFiles(List<Pair<String, byte[]>> subFileList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> previewAdjConfirmPDF(List<Long> adjConfirmPersonIds) {
        PrtAttach prtAttach = this.adjApprovalDomainService.doGenerateAdjConfirmPDF(adjConfirmPersonIds);
        String openUrlTpl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
        ArrayList urls = Lists.newArrayListWithCapacity((int)adjConfirmPersonIds.size());
        for (PrtAttach.AttachDetail attachDetail : prtAttach.getAttachDetail()) {
            String openUrl = String.format(openUrlTpl, prtAttach.getTaskId(), attachDetail.getAttachId());
            urls.add(openUrl);
        }
        return urls;
    }

    public List<String> downloadAdjConfirmPDF(List<Long> adjConfirmPersonIds) {
        PrtAttach prtAttach = this.adjApprovalDomainService.doGenerateAdjConfirmPDF(adjConfirmPersonIds);
        Map<Long, Long> fileIdMap = this.adjApprovalDomainService.queryAdjFileByConfirmPerson(adjConfirmPersonIds);
        Map<Long, DynamicObject> personObjs = this.adjFileDomainService.queryFileBizInfo(Lists.newArrayList(fileIdMap.values()), "person.name,employee.empnumber");
        ArrayList urls = Lists.newArrayListWithCapacity((int)adjConfirmPersonIds.size());
        String fileName = ResManager.loadKDString((String)"\u8c03\u85aa\u786e\u8ba4\u901a\u77e5_{0}({1}).{2}", (String)"AdjApprovalApplicationService_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
        if (personObjs.size() == prtAttach.getAttachDetail().size()) {
            for (int i = 0; i < prtAttach.getAttachDetail().size(); ++i) {
                PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(i);
                String url = String.format(Locale.ROOT, UrlService.getDomainContextUrl() + "/tempfile/download.do?%s", attachDetail.getFilePath());
                urls.add(url);
            }
        }
        return urls;
    }

    public String downloadAdjConfirmPDFOnePage(Map<String, Object> parameterMap) {
        PrtAttach prtAttach = this.adjApprovalDomainService.doGenerateAdjConfirmPDFForOnePage(parameterMap);
        ArrayList urls = Lists.newArrayListWithCapacity((int)10);
        String fileName = ResManager.loadKDString((String)"\u8c03\u85aa\u786e\u8ba4_{0}\u5e74{1}\u6708{2}\u65e5.{3}", (String)"AdjApprovalApplicationService_14", (String)"swc-hcdm-business", (Object[])new Object[0]);
        Date date = new Date();
        int year = SWCDateTimeUtils.getYear((Date)date);
        int month = SWCDateTimeUtils.getMonth((Date)date);
        int day = SWCDateTimeUtils.getDay((Date)date);
        for (int i = 0; i < prtAttach.getAttachDetail().size(); ++i) {
            PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(i);
            String uploadFileUrl = UrlService.getAttachmentFullUrl((String)attachDetail.getFilePath());
            String formatName = MessageFormat.format(fileName, String.valueOf(year), month, day, attachDetail.getFileType());
            String filename = this.getDownLoadFileName(parameterMap);
            if (SWCStringUtils.isNotEmpty((String)filename)) {
                formatName = filename;
            }
            uploadFileUrl = uploadFileUrl + "&fileName=" + formatName;
            urls.add(uploadFileUrl);
        }
        return urls.isEmpty() ? "" : (String)urls.get(0);
    }

    public void doPrintAdjConfirmPDF(List<Long> adjConfirmPersonIds, String printerId) {
        this.adjApprovalDomainService.printAdjConfirmPDF(adjConfirmPersonIds, printerId);
    }

    public void doPrintAdjConfirmPDFForOnePage(Map<String, Object> parameterMap) {
        this.adjApprovalDomainService.printAdjConfirmPDFForOnePage(parameterMap);
    }

    public Map<Long, Map<String, Object>> queryAdjConfirmPreviewParam(List<Long> adjConfirmPersonIds) {
        return this.queryAdjConfirmPreviewParam(adjConfirmPersonIds, null);
    }

    public Map<Long, Map<String, Object>> queryAdjConfirmPreviewParam(List<Long> adjConfirmPersonIds, Map<String, Object> parameterMap) {
        Map<Long, String> textMap;
        Map<Long, Long> adjFileIdsMap = this.adjApprovalDomainService.queryAdjFileByConfirmPerson(adjConfirmPersonIds);
        ArrayList adjFileIds = Lists.newArrayList(adjFileIdsMap.values());
        Map<Long, Long> hrPersonIdMap = this.adjApprovalDomainService.queryHrPersonId(adjConfirmPersonIds);
        Map<Long, Long> employeePersonIdMap = this.adjFileDomainService.queryEmployeePersonId(Lists.newArrayList((Iterable)adjFileIds));
        ArrayList hrPersonIds = Lists.newArrayList(hrPersonIdMap.values());
        Map<Long, DynamicObject> adjFileObjs = this.adjFileDomainService.queryFileBizInfo(adjFileIds, "person.name,employee.empnumber,person.headsculpture,empposorgrel.company.name,depemp.adminorg.name, job.name");
        Map<Long, DynamicObject> hrContactObjs = this.adjFileDomainService.queryPersonContactInfo(hrPersonIds, "phone,peremail");
        Map<Long, DynamicObject> personPernontspropObjs = this.adjFileDomainService.queryPersonPernontsprop(hrPersonIds, "gender.name");
        Map<Long, DynamicObject> jobLevelObjs = this.adjFileDomainService.queryJobLevel(Lists.newArrayList(employeePersonIdMap.values()), "joblevel.name,jobgrade.name");
        Map<Long, AdjConfirmFeedbackStatus> feedbackStatusMap = this.adjApprovalDomainService.queryAdjConfirmFeedbackStatus(adjConfirmPersonIds);
        if (CollectionUtils.isEmpty(parameterMap)) {
            Map<Long, List<String>> confirmTemplateParams = this.adjApprovalDomainService.queryAdjConfirmTemplateParamNames(adjConfirmPersonIds);
            HashSet paramNames = Sets.newHashSet();
            confirmTemplateParams.forEach((key, value) -> paramNames.addAll(value));
            Map<Long, List<List<Map<String, String>>>> paramValues = this.queryAdjConfirmTemplateParamValue(adjConfirmPersonIds, paramNames);
            textMap = this.adjApprovalDomainService.generateAdjConfirmTextWithParam(paramValues);
        } else {
            Object adjConfirmTplAndPersonMapObj = parameterMap.get("adjConfirmTplAndPersonMap");
            Map<Long, List<Long>> adjConfirmTplAndPersonMap = new HashMap(16);
            if (adjConfirmTplAndPersonMapObj != null) {
                adjConfirmTplAndPersonMap = (Map)adjConfirmTplAndPersonMapObj;
            }
            Map<Long, List<String>> confirmTemplateParams = this.adjApprovalDomainService.queryAdjConfirmTemplateContentById(adjConfirmTplAndPersonMap.keySet());
            HashSet paramNames = Sets.newHashSet();
            confirmTemplateParams.forEach((key, value) -> paramNames.addAll(value));
            Map<Long, List<List<Map<String, String>>>> paramValues = this.queryAdjConfirmTemplateParamValueByMap(adjConfirmTplAndPersonMap, paramNames, parameterMap);
            textMap = this.adjApprovalDomainService.generateAdjConfirmTextWithParamByTpl(paramValues, adjConfirmTplAndPersonMap);
            parameterMap.put("adjConfirmPersonTextMap", textMap);
        }
        Map<Long, String> textContentMap = this.getPrintContent(parameterMap);
        if (textContentMap != null && !textContentMap.isEmpty()) {
            textMap = textContentMap;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, Long> personFile : adjFileIdsMap.entrySet()) {
            DynamicObject pernontspropDyObj;
            DynamicObject jobLevelObj;
            Long confirmPersonId = personFile.getKey();
            Long fileId = personFile.getValue();
            Long hrPersonId = hrPersonIdMap.get(confirmPersonId);
            HashMap map = Maps.newHashMap();
            DynamicObject fileObj = adjFileObjs.get(fileId);
            map.put("personname", fileObj.getString("person.name"));
            map.put("personnumber", fileObj.getString("employee.empnumber"));
            map.put("headsculpture", fileObj.getString("person.headsculpture"));
            map.put("company", fileObj.getString("empposorgrel.company.name"));
            map.put("depempadminorg", fileObj.getString("depemp.adminorg.name"));
            map.put("job", fileObj.getString("job.name"));
            DynamicObject hrContactObj = hrContactObjs.get(hrPersonId);
            if (hrContactObj != null) {
                map.put("phone", hrContactObj.getString("phone"));
                map.put("peremail", hrContactObj.getString("peremail"));
            }
            if ((jobLevelObj = jobLevelObjs.get(employeePersonIdMap.get(fileId))) != null) {
                map.put("joblevel", jobLevelObj.getString("joblevel.name"));
                map.put("jobgrade", jobLevelObj.getString("jobgrade.name"));
            }
            if ((pernontspropDyObj = personPernontspropObjs.get(fileId)) != null) {
                map.put("gender", pernontspropDyObj.getString("gender.name"));
            }
            AdjConfirmFeedbackStatus adjConfirmFeedbackStatus = feedbackStatusMap.get(confirmPersonId);
            map.put("feedbackstatus", adjConfirmFeedbackStatus.getCode());
            map.put("confirmtext", textMap.get(confirmPersonId));
            resultMap.put(confirmPersonId, map);
        }
        return resultMap;
    }

    private Map<Long, List<List<Map<String, String>>>> queryAdjConfirmTemplateParamValueByMap(Map<Long, List<Long>> adjConfirmTplAndPersonMap, Set<String> paramNames, Map<String, Object> parameterMap) {
        HashMap<Long, Map<String, Object>> dataRowMainMap = (HashMap<Long, Map<String, Object>>)parameterMap.get("dataRowMainMap");
        HashMap<Long, List<Map<String, Object>>> dataRowItemMap = (HashMap<Long, List<Map<String, Object>>>)parameterMap.get("dataRowItemMap");
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (dataRowMainMap == null && dataRowItemMap == null) {
            return result;
        }
        if (dataRowMainMap == null) {
            dataRowMainMap = new HashMap<Long, Map<String, Object>>();
        }
        if (dataRowItemMap == null) {
            dataRowItemMap = new HashMap<Long, List<Map<String, Object>>>();
        }
        if (adjConfirmTplAndPersonMap == null) {
            return result;
        }
        ArrayList<Long> adjConfirmPersonIds = new ArrayList<Long>(16);
        for (Map.Entry<Long, List<Long>> entry : adjConfirmTplAndPersonMap.entrySet()) {
            adjConfirmPersonIds.addAll((Collection)entry.getValue());
        }
        ArrayList<String> properties = new ArrayList<String>(paramNames);
        Map<Long, List<List<Map<String, String>>>> tplParamValueMap = this.getTplParamValueMap(dataRowMainMap, dataRowItemMap, adjConfirmPersonIds, properties);
        for (Long adjConfirmPersonId : adjConfirmPersonIds) {
            List<List<Map<String, String>>> getAdjConfirmPersonAllParamList = tplParamValueMap.get(adjConfirmPersonId);
            result.put(adjConfirmPersonId, getAdjConfirmPersonAllParamList);
        }
        return result;
    }

    private Map<Long, List<List<Map<String, String>>>> getTplParamValueMap(Map<Long, Map<String, Object>> dataRowMainMap, Map<Long, List<Map<String, Object>>> dataRowItemMap, List<Long> adjConfirmPersonIds, List<String> properties) {
        HashMap<Long, List<List<Map<String, String>>>> tplParamValueMap = new HashMap<Long, List<List<Map<String, String>>>>(16);
        for (Long adjConfirmPersonId : adjConfirmPersonIds) {
            ArrayList adjFileAllParamList = Lists.newArrayListWithExpectedSize((int)10);
            List<Map<String, Object>> list = dataRowItemMap.get(adjConfirmPersonId);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
                Map<String, String> paramMap = this.setPropertyParamValue(dataRowMainMap, properties, adjConfirmPersonId);
                this.addParamList(adjFileAllParamList, paramMap);
            } else {
                for (Map<String, Object> map : list) {
                    Map<String, String> paramMap = this.setPropertyParamValue(dataRowMainMap, properties, adjConfirmPersonId);
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        String key = entry.getKey();
                        Object valueObj = entry.getValue();
                        paramMap.put(key, valueObj == null ? "" : String.valueOf(valueObj));
                    }
                    this.addParamList(adjFileAllParamList, paramMap);
                }
            }
            tplParamValueMap.put(adjConfirmPersonId, adjFileAllParamList);
        }
        return tplParamValueMap;
    }

    private void addParamList(List<List<Map<String, String>>> adjFileAllParamList, Map<String, String> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return;
        }
        ArrayList paramMapList = Lists.newArrayListWithExpectedSize((int)1);
        paramMapList.add(paramMap);
        adjFileAllParamList.add(paramMapList);
    }

    private Map<String, String> setPropertyParamValue(Map<Long, Map<String, Object>> dataRowMainMap, List<String> properties, Long id) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)properties.size());
        for (String property : properties) {
            Map<String, Object> mainValueMap;
            if (HTML_PATTERN.matcher(property).find() || (mainValueMap = dataRowMainMap.get(id)) == null) continue;
            Object valueObj = mainValueMap.get(property);
            paramMap.put(property, valueObj == null ? "" : String.valueOf(valueObj));
        }
        return paramMap;
    }

    private String getDownLoadFileName(Map<String, Object> parameterMap) {
        AdjConfirmPrintEvent event = new AdjConfirmPrintEvent((Object)this);
        event.setParameterMap(parameterMap);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new AdjConfirmPrintExtService(), IAdjConfirmPrintExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IAdjConfirmPrintExtService#setDownLoadFileName", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            plugin.setDownLoadFileName(event);
            return null;
        });
        return event.getFileName();
    }

    private Map<Long, String> getPrintContent(Map<String, Object> parameterMap) {
        AdjConfirmPrintEvent event = new AdjConfirmPrintEvent((Object)this);
        event.setParameterMap(parameterMap);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new AdjConfirmPrintExtService(), IAdjConfirmPrintExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IAdjConfirmPrintExtService#getLastPrintContent", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            plugin.getLastPrintContent(event);
            return null;
        });
        return event.getTextContentMap();
    }

    private Map<Long, List<List<Map<String, String>>>> queryAdjConfirmTemplateParamValue(List<Long> adjConfirmPersonIds, Set<String> paramNames) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)adjConfirmPersonIds.size());
        Map<Long, DynamicObject> adjConfirmPersonDatas = this.adjApprovalDomainService.queryAdjConfirmPersonData(adjConfirmPersonIds);
        HashSet adjApprovalBillIdSet = Sets.newHashSet();
        adjConfirmPersonDatas.forEach((key, value) -> adjApprovalBillIdSet.add(value.getLong("adjapprovalbill")));
        HashSet personIdSet = Sets.newHashSet();
        adjConfirmPersonDatas.forEach((key, value) -> personIdSet.add(value.getLong("person.id")));
        HashSet adjFileIdSet = Sets.newHashSet();
        adjConfirmPersonDatas.forEach((key, value) -> adjFileIdSet.add(value.getLong("adjfile.id")));
        ArrayList<String> properties = new ArrayList<String>(paramNames);
        DynamicObject[] dataObjs = this.adjApprovalDomainService.queryAdjConfirmTemplateParamValue(properties, adjApprovalBillIdSet, personIdSet);
        if (dataObjs.length == 0) {
            return result;
        }
        DataEntityPropertyCollection propertySet = dataObjs[0].getDataEntityType().getProperties();
        DataEntityPropertyCollection entryPropertySet = null;
        EntryProp entryProp = (EntryProp)propertySet.get((Object)"entryentity");
        if (entryProp != null) {
            entryPropertySet = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        }
        List<DynamicObject> dataList = Arrays.asList(dataObjs);
        Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjApprGridHelper.getItemUseRankFlagDb(dataList);
        HashMap dataMaps = new HashMap();
        dataList.forEach(object -> Optional.ofNullable(dataMaps.putIfAbsent(object.getLong("adjapprbill"), new ArrayList<DynamicObject>(Collections.singletonList(object)))).ifPresent(list -> list.add(object)));
        Set<Long> empIds = dataList.stream().map(data -> data.getLong("adjfile.empposorgrel.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> empposorgrelData = this.adjFileDomainService.getEmpposorgrelData(empIds);
        HashMap tplParamValueMap = Maps.newHashMapWithExpectedSize((int)dataObjs.length);
        for (Map.Entry entry : dataMaps.entrySet()) {
            Long adjApprovalBillId = (Long)entry.getKey();
            List adjApprovalBillValues = (List)entry.getValue();
            HashMap dataMapByAdjFileIds = Maps.newHashMapWithExpectedSize((int)adjApprovalBillValues.size());
            adjApprovalBillValues.forEach(object -> Optional.ofNullable(dataMapByAdjFileIds.putIfAbsent(object.getLong("adjfile.id"), new ArrayList<DynamicObject>(Collections.singletonList(object)))).ifPresent(list -> list.add(object)));
            HashMap adjFileParamMap = Maps.newHashMapWithExpectedSize((int)adjFileIdSet.size());
            for (Long adjFile : adjFileIdSet) {
                List dataMapDyObjs = (List)dataMapByAdjFileIds.get(adjFile);
                ArrayList adjFileAllParamList = Lists.newArrayListWithExpectedSize((int)adjApprovalBillValues.size());
                for (DynamicObject dataMapDyObj : dataMapDyObjs) {
                    DynamicObjectCollection entryEntity = dataMapDyObj.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryentity : entryEntity) {
                        if (SWCObjectUtils.isEmpty((Object)entryentity)) continue;
                        ArrayList paramMapList = Lists.newArrayListWithExpectedSize((int)adjApprovalBillValues.size());
                        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)properties.size());
                        for (String property : properties) {
                            if (HTML_PATTERN.matcher(property).find()) continue;
                            if (property.equals("adjfile.empposorgrel.adminorg")) {
                                DynamicObject empposorgrel = empposorgrelData.get(dataMapDyObj.getLong("adjfile.empposorgrel.id"));
                                if (SWCObjectUtils.isEmpty((Object)empposorgrel) || !empposorgrel.containsProperty("adminorg")) continue;
                                paramMap.put(property, SWCStringUtils.isEmpty((String)empposorgrel.getString("adminorg.name")) ? " " : empposorgrel.getString("adminorg.name"));
                                continue;
                            }
                            Object propertyObj = "";
                            try {
                                propertyObj = dataMapDyObj.get(property);
                            }
                            catch (Exception e) {
                                logger.error("\u9875\u9762\u65e0\u6cd5\u8bc6\u522b\u7684\u5b57\u6bb5 \u8df3\u8fc7\uff1a{}", (Object)e.getMessage());
                            }
                            if (property.startsWith("entryentity.")) {
                                propertyObj = entryentity.get(property.replaceAll("entryentity.", ""));
                            }
                            if (property.equals("entryentity.calctype")) {
                                ComboProp property1;
                                if (SWCObjectUtils.isEmpty((Object)propertyObj) || entryPropertySet == null || (property1 = (ComboProp)entryPropertySet.get((Object)"calctype")) == null) continue;
                                String itemName = property1.getItemByName(propertyObj.toString());
                                paramMap.put(property, itemName);
                                continue;
                            }
                            if (propertyObj instanceof DynamicObject) {
                                if (!SWCObjectUtils.isEmpty((Object)dataMapDyObj.get(property))) {
                                    DynamicObject dy = (DynamicObject)dataMapDyObj.get(property);
                                    paramMap.put(property, SWCStringUtils.isEmpty((String)dy.getString("name")) ? " " : dy.getString("name"));
                                    continue;
                                }
                                paramMap.put(property, " ");
                                continue;
                            }
                            if (propertyObj instanceof BigDecimal) {
                                HashSet percents = Sets.newHashSet((Object[])new String[]{"entryentity.presalarypercent", "entryentity.presalaryseeprate", "entryentity.suggestminrange", "entryentity.suggestmaxrange", "entryentity.actualrange", "entryentity.salarypercent", "entryentity.salaryseeprate"});
                                if (percents.contains(property)) {
                                    if (SWCObjectUtils.isEmpty((Object)propertyObj)) continue;
                                    BigDecimal propertyObjData = (BigDecimal)propertyObj;
                                    BigDecimal multiplyResult = null;
                                    multiplyResult = "entryentity.actualrange".equals(property) || "entryentity.suggestminrange".equals(property) || "entryentity.suggestmaxrange".equals(property) ? propertyObjData : propertyObjData.multiply(new BigDecimal(100));
                                    BigDecimal bigDecimal = multiplyResult.setScale(2, 5);
                                    paramMap.put(property, bigDecimal.toString() + "%");
                                    continue;
                                }
                                DynamicObject currency = (DynamicObject)entryentity.get("currency");
                                paramMap.put(property, AdjApprovalGridHelper.formatAmountValue((BigDecimal)propertyObj, currency));
                                continue;
                            }
                            if (propertyObj instanceof Date) {
                                paramMap.put(property, SWCDateTimeUtils.format((Date)((Date)propertyObj), (String)"yyyy-MM-dd"));
                                continue;
                            }
                            HashSet amountStdRangeSet = Sets.newHashSet((Object[])new String[]{"entryentity.amountstdrange"});
                            if (amountStdRangeSet.contains(property)) {
                                if (propertyObj == null) continue;
                                String calcType = entryentity.getString("calctype");
                                String personRange = entryentity.getString("salargrel");
                                if (CalcType.GRADE_RANK.getCode().equals(calcType)) {
                                    GradeAndRankNameEntity gradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromMatchGradeRankRel(Lists.newArrayList((Object[])new String[]{personRange}));
                                    Boolean isUseRank = DecAdjApprGridHelper.checkItemUseRankDb(entryentity, itemUseRankFlag);
                                    AmountStdRangeEntity amountStdRangeEntity = GradeAndRankNameHelper.convertMatchGradeRankRelToAmountStdRange(personRange, isUseRank, gradeAndRankNameEntity);
                                    String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName(JSON.toJSONString((Object)amountStdRangeEntity), gradeAndRankNameEntity);
                                    amountStdRangeName = amountStdRangeName == null ? " " : amountStdRangeName;
                                    paramMap.put(property, amountStdRangeName);
                                    continue;
                                }
                                AmountStdRangeEntity amountStdRangeEntity = (AmountStdRangeEntity)JSON.parseObject((String)propertyObj.toString(), AmountStdRangeEntity.class, (Feature[])new Feature[]{Feature.OrderedField});
                                String amountStdRangeDisplayName = null;
                                if (amountStdRangeEntity != null) {
                                    Map amountStdRangeMap = amountStdRangeEntity.getPositionInfo();
                                    List positionInfoOfNotUseRank = amountStdRangeEntity.getPositionInfoOfNotUseRank();
                                    GradeAndRankNameEntity gradeAndRankNameEntity = DecAdjApprGridHelper.getMatchGradeAndRankNameEntity(amountStdRangeMap, positionInfoOfNotUseRank);
                                    if (MapUtils.isNotEmpty((Map)amountStdRangeMap)) {
                                        amountStdRangeDisplayName = DecAdjApprGridHelper.buildMatchGradeAndRankRangeDisplayName(amountStdRangeMap, gradeAndRankNameEntity);
                                    } else if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRank)) {
                                        amountStdRangeDisplayName = DecAdjApprGridHelper.buildAllMatchGradeRangeName(positionInfoOfNotUseRank, gradeAndRankNameEntity);
                                    }
                                }
                                amountStdRangeDisplayName = amountStdRangeDisplayName == null ? " " : amountStdRangeDisplayName;
                                paramMap.put(property, SWCObjectUtils.isEmpty((Object)propertyObj) ? " " : amountStdRangeDisplayName);
                                continue;
                            }
                            paramMap.put(property, SWCObjectUtils.isEmpty((Object)propertyObj) ? " " : String.valueOf(propertyObj));
                        }
                        paramMapList.add(paramMap);
                        adjFileAllParamList.add(paramMapList);
                        adjFileParamMap.put(adjFile, adjFileAllParamList);
                    }
                }
            }
            tplParamValueMap.put(adjApprovalBillId, adjFileParamMap);
        }
        for (Map.Entry<Object, Object> entry : adjConfirmPersonDatas.entrySet()) {
            Long adjapprovalbillId = ((DynamicObject)entry.getValue()).getLong("adjapprovalbill");
            Long adjfileId = ((DynamicObject)entry.getValue()).getLong("adjfile.id");
            Map adjfileDatas = (Map)tplParamValueMap.get(adjapprovalbillId);
            if (adjfileDatas == null) continue;
            result.put(entry.getKey(), adjfileDatas.get(adjfileId));
        }
        return result;
    }

    public Map<Long, Map<String, Object>> queryAdjConfirmNotify(long adjConfirmPersonId) {
        LinkedHashMap adjConfirmNotify = Maps.newLinkedHashMapWithExpectedSize((int)1);
        LinkedHashMap contentMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        ArrayList adjConfirmPersonIds = Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId});
        Map<Long, DynamicObject> adjConfirmTemplates = this.adjApprovalDomainService.queryAdjConfirmTemplate(adjConfirmPersonIds);
        DynamicObject adjConfirmTemplate = adjConfirmTemplates.get(adjConfirmPersonId);
        contentMap.put("adjConfirmTemplate", adjConfirmTemplate);
        Map<Long, List<String>> confirmTemplateParams = this.adjApprovalDomainService.queryAdjConfirmTemplateParamNames(adjConfirmPersonIds);
        HashSet paramNames = Sets.newHashSet();
        confirmTemplateParams.forEach((key, value) -> paramNames.addAll(value));
        Map<Long, List<List<Map<String, String>>>> paramValues = this.queryAdjConfirmTemplateParamValue(adjConfirmPersonIds, paramNames);
        Map<Long, String> textMap = this.adjApprovalDomainService.generateAdjConfirmTextWithParam(paramValues);
        contentMap.put("htmlText", textMap.get(adjConfirmPersonId));
        DynamicObject adjConfirmPerson = this.adjApprovalDomainService.queryAdjConfirmPersonById(adjConfirmPersonId);
        contentMap.put("confirmstatus", adjConfirmPerson.getString("confirmstatus"));
        adjConfirmNotify.put(adjConfirmPersonId, contentMap);
        return adjConfirmNotify;
    }

    public Map<String, Object> repeatSendAdjConfirm(List<Long> adjConfirmPersonIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        ArrayList errorMsgList = Lists.newArrayListWithCapacity((int)adjConfirmPersonIds.size());
        resultMap.put("successPk", Collections.emptyList());
        resultMap.put("errorMsgList", errorMsgList);
        Map<Long, AdjConfirmFeedbackStatus> feedbackStatusMap = this.adjApprovalDomainService.queryAdjConfirmFeedbackStatus(adjConfirmPersonIds);
        Map<Long, AdjConfirmSendStatus> sendStatusMap = this.adjApprovalDomainService.queryAdjConfirmSendStatus(adjConfirmPersonIds);
        List<Long> needRepeatSend = adjConfirmPersonIds.stream().filter(aLong -> feedbackStatusMap.get(aLong) == AdjConfirmFeedbackStatus.NOT_CONFIRM && sendStatusMap.get(aLong) == AdjConfirmSendStatus.HAS_SENT).collect(Collectors.toList());
        if (adjConfirmPersonIds.size() > needRepeatSend.size()) {
            List unNormalPk = ListUtils.removeAll(adjConfirmPersonIds, needRepeatSend);
            Map<Long, Long> adjFileMap = this.adjApprovalDomainService.queryAdjFileByConfirmPerson(unNormalPk);
            Map<Long, DynamicObject> adjFileObjMap = this.adjFileDomainService.queryFileBizInfo(new ArrayList<Long>(adjFileMap.values()), "number,person.name,employee.empnumber");
            String sendMsgTpl = ResManager.loadKDString((String)"{0}\uff1a{1}\uff08{2}\uff09\u8c03\u85aa\u786e\u8ba4\u53d1\u9001\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e\u3002", (String)"AdjApprovalApplicationService_11", (String)"swc-hcdm-business", (Object[])new Object[0]);
            String confirmMsgTpl = ResManager.loadKDString((String)"{0}\uff1a{1}\uff08{2}\uff09\u8c03\u85aa\u786e\u8ba4\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e\u3002", (String)"AdjApprovalApplicationService_12", (String)"swc-hcdm-business", (Object[])new Object[0]);
            for (Object adjConfirmPersonId : unNormalPk) {
                AdjConfirmSendStatus adjConfirmSendStatus = sendStatusMap.get(adjConfirmPersonId);
                AdjConfirmFeedbackStatus adjConfirmFeedbackStatus = feedbackStatusMap.get(adjConfirmPersonId);
                Long fileId = adjFileMap.get(adjConfirmPersonId);
                DynamicObject fileObj = adjFileObjMap.get(fileId);
                String number = fileObj.getString("number");
                String personName = fileObj.getString("person.name");
                String personNumber = fileObj.getString("employee.empnumber");
                if (adjConfirmFeedbackStatus != AdjConfirmFeedbackStatus.NOT_CONFIRM) {
                    errorMsgList.add(MessageFormat.format(confirmMsgTpl, number, personName, personNumber, adjConfirmFeedbackStatus.getNameParam().loadKDString()));
                    continue;
                }
                if (adjConfirmSendStatus == AdjConfirmSendStatus.HAS_SENT) continue;
                errorMsgList.add(MessageFormat.format(sendMsgTpl, number, personName, personNumber, adjConfirmSendStatus.getNameParam().loadKDString()));
            }
        }
        if (needRepeatSend.isEmpty()) {
            return resultMap;
        }
        this.checkSmsNumLimit(errorMsgList, needRepeatSend);
        Map<Long, Date> personExpiryDateMap = this.sendAdjConfirmMsg(needRepeatSend);
        this.adjApprovalDomainService.markAsSendConfirm(needRepeatSend, personExpiryDateMap, true);
        resultMap.put("successPk", needRepeatSend);
        return resultMap;
    }

    private void checkSmsNumLimit(List<String> errorMsgList, List<Long> needRepeatSend) {
        int smsSendnumLimit;
        Map<Long, Long> adjBillIdMap = this.adjApprovalDomainService.queryAdjApprovalBillIds(needRepeatSend);
        HashSet adjBillIds = Sets.newHashSet(adjBillIdMap.values());
        Map<Long, Long> adjConfirmTemplateIdMap = this.adjApprovalDomainService.queryTemplateIdByAdjApprovalBillIds(adjBillIds);
        HashSet adjConfirmTemplateIds = Sets.newHashSet(adjConfirmTemplateIdMap.values());
        Map<Long, String> msgTemplateNumberMap = this.adjApprovalDomainService.queryMsgTemplateNumbers(adjConfirmTemplateIds);
        SWCDataServiceHelper templateService = new SWCDataServiceHelper("msg_template");
        DynamicObject[] templateObjs = templateService.query("id,msgchannel", new QFilter[]{new QFilter("number", "in", msgTemplateNumberMap.values())});
        Map msgTplMap = Arrays.stream(templateObjs).collect(Collectors.toMap(object -> object.getString("number"), Function.identity()));
        Long adjBillId = adjBillIdMap.get(needRepeatSend.get(0));
        Long confirmTemplateId = adjConfirmTemplateIdMap.get(adjBillId);
        String msgTemplateNumber = msgTemplateNumberMap.get(confirmTemplateId);
        DynamicObject msgTplObj = (DynamicObject)msgTplMap.get(msgTemplateNumber);
        String msgChannel = msgTplObj.getString("msgchannel");
        int smsSendnumLimitExt = this.getSmsSendnumLimitExt();
        logger.info("smsSendnumLimitExt is {}", (Object)smsSendnumLimitExt);
        int n = smsSendnumLimit = smsSendnumLimitExt > 100 ? 100 : smsSendnumLimitExt;
        if (StringUtils.equals((CharSequence)msgChannel, (CharSequence)MessageChannels.SMS.getNumber())) {
            Map<Long, DynamicObject> adjConfirmPersonMap = this.queryConfirmPerson(needRepeatSend);
            Iterator<Long> iterator = needRepeatSend.iterator();
            while (iterator.hasNext()) {
                Long adjConfirmPersonId = iterator.next();
                DynamicObject adjConfirmPersonDyObj = adjConfirmPersonMap.get(adjConfirmPersonId);
                int sendNumDB = adjConfirmPersonDyObj.getInt("sendnum");
                if (sendNumDB < smsSendnumLimit) continue;
                errorMsgList.add(ResManager.loadKDString((String)"\u77ed\u4fe1\u50ac\u529e\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u50ac\u529e\u3002", (String)"AdjApprovalApplicationService_16", (String)"swc-hcdm-business", (Object[])new Object[]{smsSendnumLimitExt}));
                iterator.remove();
            }
        }
    }

    public List<Long> sendAdjConfirm(List<Long> adjConfirmPersonIds) {
        List<Long> needSendPersonIds = this.adjApprovalDomainService.queryNeedSendConfirmPerson(adjConfirmPersonIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(needSendPersonIds)) {
            return needSendPersonIds;
        }
        Map<Long, Date> personExpiryDateMap = this.sendAdjConfirmMsg(needSendPersonIds);
        this.adjApprovalDomainService.markAsSendConfirm(needSendPersonIds, personExpiryDateMap, false);
        return needSendPersonIds;
    }

    public Map<Long, AdjConfirmFeedbackStatus> getAdjConfirmFeedbackStatus(List<Long> adjConfirmPersonIds) {
        return this.adjApprovalDomainService.queryAdjConfirmFeedbackStatus(adjConfirmPersonIds);
    }

    public List<Long> submitOfflineConfirm(List<Long> adjConfirmPersonIds, List<Map<String, Object>> attachments) {
        Map<Long, AdjConfirmFeedbackStatus> feedbackStatusMap = this.adjApprovalDomainService.queryAdjConfirmFeedbackStatus(adjConfirmPersonIds);
        ArrayList adjConfirmPersonNotConfirmed = Lists.newArrayListWithCapacity((int)adjConfirmPersonIds.size());
        for (Map.Entry<Long, AdjConfirmFeedbackStatus> entry : feedbackStatusMap.entrySet()) {
            if (entry.getValue() != AdjConfirmFeedbackStatus.NOT_CONFIRM) continue;
            adjConfirmPersonNotConfirmed.add(entry.getKey());
        }
        this.updateAttachment(adjConfirmPersonNotConfirmed, attachments);
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            this.adjApprovalDomainService.markAsOffLineConfirm(adjConfirmPersonIds);
            this.syncAdjApprovalDetailToAdjFile(adjConfirmPersonNotConfirmed, AdjConfirmFeedbackStatus.CONFIRMED);
            List<Long> list = adjConfirmPersonIds;
            return list;
        }
        catch (Throwable e) {
            try {
                txHandle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public List<Long> updateAttachment(List<Long> adjConfirmPersonIds, List<Map<String, Object>> attachments) {
        Map<Long, Long> fileIdMap = this.adjApprovalDomainService.queryAdjFileByConfirmPerson(adjConfirmPersonIds);
        logger.info("\u8c03\u85aa\u786e\u8ba4\u4eba\u5458\u7f16\u7801fileIdMap\uff1a{}", (Object)JSON.toJSONString(fileIdMap));
        Map<Long, DynamicObject> personObjs = this.adjFileDomainService.queryFileBizInfo(Lists.newArrayList(fileIdMap.values()), "person.name,employee.empnumber");
        try {
            logger.info("\u4eba\u5458\u6570\u636epersonObjs\uff1a{}", (Object)JSONUtils.toString(personObjs));
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        logger.info("\u4e0a\u4f20\u9644\u4ef6\u96c6\u5408attachments\uff1a{}", (Object)JSON.toJSONString(attachments));
        Map<Long, List<Map<String, Object>>> fileAttachmentMap = this.mapFileToPerson(personObjs, attachments);
        logger.info("\u8f6c\u6362\u540e\u7684\u9644\u4ef6\u96c6\u5408fileAttachmentMap\uff1a{} ", (Object)JSON.toJSONString(fileAttachmentMap));
        HashMap personAttachmentMap = Maps.newHashMapWithExpectedSize((int)fileAttachmentMap.size());
        ArrayList correctPerson = Lists.newArrayList();
        for (Map.Entry<Long, Long> entry : fileIdMap.entrySet()) {
            List<Map<String, Object>> attachment = fileAttachmentMap.getOrDefault(entry.getValue(), Lists.newArrayList());
            personAttachmentMap.put(entry.getKey(), attachment);
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(attachment)) continue;
            correctPerson.add(entry.getKey());
        }
        logger.info("\u4eba\u5458\u9644\u4ef6\u96c6\u5408personAttachmentMap\uff1a {}", (Object)JSON.toJSONString((Object)personAttachmentMap));
        this.adjApprovalDomainService.updateAdjConfirmAttachment(personAttachmentMap);
        return correctPerson;
    }

    public List<Object> matchFailAttachmentIds(DynamicObjectCollection selectPersonColl, Object[] urls) {
        ArrayList pkIdList = Lists.newArrayListWithExpectedSize((int)selectPersonColl.size());
        ArrayList psersonAliasList = Lists.newArrayListWithExpectedSize((int)selectPersonColl.size());
        for (DynamicObject selectPerson : selectPersonColl) {
            DynamicObject hrPerson = selectPerson.getDynamicObject("fbasedataid");
            String number = hrPerson.getString("employee.empnumber");
            String name = hrPerson.getString("person.name");
            String standardFileName = name + "_" + number;
            psersonAliasList.add(standardFileName);
        }
        logger.info("matchFailAttachmentIds psersonAliasList is {}", (Object)StringUtils.join((Iterable)psersonAliasList, (String)";"));
        for (Object url : urls) {
            String attachmentName;
            String nameWithoutSuffix;
            if (!(url instanceof Map) || psersonAliasList.contains(nameWithoutSuffix = (attachmentName = (String)((Map)url).get("name")).substring(0, attachmentName.lastIndexOf(46)))) continue;
            pkIdList.add(((Map)url).get("uid"));
            logger.info("matchFailAttachmentIds not match file {}", (Object)attachmentName);
        }
        return pkIdList;
    }

    private Map<Long, List<Map<String, Object>>> mapFileToPerson(Map<Long, DynamicObject> personObjs, List<Map<String, Object>> attachmentFiles) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personObjs.size());
        HashMap fileNameMap = Maps.newHashMap();
        for (Map<String, Object> map : attachmentFiles) {
            Object nameObj = map.get("name");
            String name = nameObj == null ? "" : nameObj.toString();
            String nameWithoutSuffix = name.substring(0, name.lastIndexOf(46));
            List maps = fileNameMap.computeIfAbsent(nameWithoutSuffix, value -> Lists.newArrayList());
            maps.add(map);
        }
        for (Map.Entry entry : personObjs.entrySet()) {
            Long confirmPersonId = (Long)entry.getKey();
            String number = ((DynamicObject)entry.getValue()).getString("employee.empnumber");
            String name = ((DynamicObject)entry.getValue()).getString("person.name");
            String standardFileName = name + "_" + number;
            List currentFiles = fileNameMap.getOrDefault(standardFileName, Lists.newArrayList());
            List subFiles = resultMap.computeIfAbsent(confirmPersonId, val -> Lists.newArrayList());
            subFiles.addAll(currentFiles);
        }
        return resultMap;
    }

    public boolean checkDockingPayslip() {
        return false;
    }

    public boolean payslipLogin(String password, long adjConfirmPersonId) {
        Map<Long, Long> hrPersonIdMap = this.adjApprovalDomainService.queryHrPersonId(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        long hrPersonId = hrPersonIdMap.get(adjConfirmPersonId);
        Map<String, Object> payslipPassword = this.queryPayslipPassword(hrPersonId, password);
        if (MapUtils.isNotEmpty(payslipPassword) && payslipPassword.get("isExist") != null && !((Boolean)payslipPassword.get("isExist")).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u5bc6\u7801\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u5de5\u8d44\u6761\u5bc6\u7801\u518d\u767b\u5f55\u3002", (String)"AdjApprovalApplicationService_8", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        return (Boolean)payslipPassword.get("authenticate");
    }

    public ValidateResult validateUserPhone(String phone, String imageCode, String smsCode, long adjConfirmPersonId) {
        VerifyCodeDto smsVerifyCodeDto = this.queryLastSMS();
        String randCodeSms = smsVerifyCodeDto == null ? "" : smsVerifyCodeDto.getCode();
        VerifyCodeDto imgVerifyCodeDto = this.queryLastImageCode();
        String randCodeImg = imgVerifyCodeDto == null ? "" : imgVerifyCodeDto.getCode();
        ValidateResult result = new ValidateResult(ErrorLevel.Info);
        ArrayList errorList = Lists.newArrayListWithExpectedSize((int)3);
        if (StringUtils.isBlank((CharSequence)phone) || !this.isUserPhoneLegal(phone, adjConfirmPersonId)) {
            errorList.add(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u624b\u673a\u53f7\u4e0d\u5339\u914d\u3002", (String)"AdjApprovalApplicationService_3", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)randCodeImg) || !imageCode.equals(randCodeImg)) {
            errorList.add(ResManager.loadKDString((String)"\u968f\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\u3002", (String)"AdjApprovalApplicationService_4", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)smsCode) || !randCodeSms.equals(smsCode)) {
            errorList.add(ResManager.loadKDString((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\u3002", (String)"AdjApprovalApplicationService_5", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        if (errorList.size() != 0) {
            ArrayList errorMsgList = Lists.newArrayListWithExpectedSize((int)4);
            for (int i = 0; i < errorList.size(); ++i) {
                String error = (String)errorList.get(i);
                error = i == errorList.size() - 1 ? error + '\uff0c' : error + '\u3001';
                errorMsgList.add(error);
            }
            errorMsgList.add(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"AdjApprovalApplicationService_9", (String)"swc-hcdm-business", (Object[])new Object[0]));
            StringBuilder sb = new StringBuilder();
            for (String errorMsg : errorMsgList) {
                sb.append(errorMsg);
            }
            result.setErrorList(Lists.newArrayList((Object[])new String[]{sb.toString()}));
            result.failed();
        }
        return result;
    }

    public boolean isUserPhoneLegal(String phone, long adjConfirmPersonId) {
        Map<Long, Long> hrPersonIdMap = this.adjApprovalDomainService.queryHrPersonId(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        ArrayList hrPersonIds = Lists.newArrayList(hrPersonIdMap.values());
        Map<Long, DynamicObject> hrContactObjs = this.adjFileDomainService.queryPersonContactInfo(hrPersonIds, "phone");
        HashMap adjConfirmPersonContactObjs = Maps.newHashMapWithExpectedSize((int)hrPersonIdMap.size());
        for (Map.Entry<Long, Long> entry : hrPersonIdMap.entrySet()) {
            adjConfirmPersonContactObjs.put(entry.getKey(), hrContactObjs.get(entry.getValue()));
        }
        DynamicObject contactObj = (DynamicObject)adjConfirmPersonContactObjs.get(adjConfirmPersonId);
        String hrPhone = contactObj == null ? "" : contactObj.getString("phone");
        hrPhone = hrPhone.replace("-", "");
        phone = phone.replace("-", "");
        return StringUtils.equals((CharSequence)hrPhone, (CharSequence)phone);
    }

    public Long querySysUserId(long adjConfirmPersonId) {
        Map<Long, Long> hrPersonToBosUserMap;
        Map<Long, Long> hrPersonIdMap = this.adjApprovalDomainService.queryHrPersonId(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        if (hrPersonIdMap != null && !hrPersonIdMap.isEmpty() && (hrPersonToBosUserMap = this.adjFileDomainService.queryBosUserIdByHrPersonId(Lists.newArrayList(hrPersonIdMap.values()))) != null && !hrPersonToBosUserMap.isEmpty()) {
            Long hrPersonId = hrPersonIdMap.get(adjConfirmPersonId);
            return hrPersonToBosUserMap.get(hrPersonId);
        }
        return 0L;
    }

    public ValidateResult resetPayslipPassword(String password, long hrPersonId) {
        return null;
    }

    public ValidateResult resetPassword(String password, long adjConfirmPersonId) {
        Map<Long, Long> hrPersonIdMap = this.adjApprovalDomainService.queryHrPersonId(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        long hrPersonId = hrPersonIdMap.get(adjConfirmPersonId);
        return this.adjApprovalDomainService.resetPassword(password, hrPersonId);
    }

    public void saveAdjConfirmAccount(String password, long hrPersonId) {
        this.adjApprovalDomainService.saveAdjConfirmAccount(password, hrPersonId);
    }

    public boolean adjConfirmQueryCountLogin(String password, long adjConfirmPersonId) {
        Map<Long, Long> hrPersonIdMap = this.adjApprovalDomainService.queryHrPersonId(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        long hrPersonId = hrPersonIdMap.get(adjConfirmPersonId);
        return this.adjApprovalDomainService.verifyPassword(password, hrPersonId);
    }

    public boolean isAdjConfirmAccount(long adjConfirmPersonId) {
        Map<Long, Long> hrPersonIdMap = this.adjApprovalDomainService.queryHrPersonId(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        ArrayList hrPersonIds = Lists.newArrayList(hrPersonIdMap.values());
        Map<Long, DynamicObject> adjConfirmAccounts = this.adjApprovalDomainService.queryAdjConfirmAccount(hrPersonIds);
        HashMap adjConfirmAccountObjs = Maps.newHashMapWithExpectedSize((int)hrPersonIdMap.size());
        for (Map.Entry<Long, Long> entry : hrPersonIdMap.entrySet()) {
            adjConfirmAccountObjs.put(entry.getKey(), adjConfirmAccounts.get(entry.getValue()));
        }
        DynamicObject adjConfirmAccount = (DynamicObject)adjConfirmAccountObjs.get(adjConfirmPersonId);
        return adjConfirmAccount != null;
    }

    public Map<Long, DynamicObject> queryAdjFileInfo(long adjConfirmPersonId) {
        Map<Long, Long> adjFileIdsMap = this.adjApprovalDomainService.queryAdjFileByConfirmPerson(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        ArrayList adjFileIds = Lists.newArrayList(adjFileIdsMap.values());
        Map<Long, DynamicObject> adjFileObjs = this.adjFileDomainService.queryFileBizInfo(adjFileIds, "person.id,person.name");
        HashMap personAdjFileInfo = Maps.newHashMapWithExpectedSize((int)adjFileIdsMap.size());
        for (Map.Entry<Long, Long> adjFileIdMap : adjFileIdsMap.entrySet()) {
            personAdjFileInfo.put(adjFileIdMap.getKey(), adjFileObjs.get(adjFileIdMap.getValue()));
        }
        return personAdjFileInfo;
    }

    public Map<String, Object> queryLogUserInfo(long adjConfirmPersonId) {
        Map<Long, Long> adjFileIdsMap = this.adjApprovalDomainService.queryAdjFileByConfirmPerson(Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        ArrayList adjFileIds = Lists.newArrayList(adjFileIdsMap.values());
        Map<Long, DynamicObject> adjFileObjs = this.adjFileDomainService.queryFileBizInfo(adjFileIds, "person.id, person.name, org.id, org.name");
        HashMap adjFileInfo = Maps.newHashMapWithExpectedSize((int)adjFileIdsMap.size());
        for (Map.Entry<Long, Long> adjFileIdMap : adjFileIdsMap.entrySet()) {
            adjFileInfo.put(adjFileIdMap.getKey(), adjFileObjs.get(adjFileIdMap.getValue()));
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        if (MapUtils.isNotEmpty((Map)adjFileInfo)) {
            DynamicObject adjFileInfoDyObj = (DynamicObject)adjFileInfo.get(adjConfirmPersonId);
            Long personId = adjFileInfoDyObj.getLong("person.id");
            Map<Long, Long> hrPersonToBosUserMap = this.adjFileDomainService.queryBosUserIdByHrPersonId(Lists.newArrayList((Object[])new Long[]{personId}));
            Long bosUserId = hrPersonToBosUserMap.get(personId);
            Long orgId = adjFileInfoDyObj.getLong("org.id");
            map.put("userId", bosUserId);
            map.put("orgId", orgId);
        }
        return map;
    }

    private void syncAdjApprovalDetailToAdjFile(List<Long> adjConfirmPersonIds, AdjConfirmFeedbackStatus feedbackStatus) {
        DynamicObject[] queryConfirmPerson = this.adjApprovalDomainService.queryConfirmPerson(adjConfirmPersonIds);
        Map<Long, Long> fileToBillIdMap = Arrays.stream(queryConfirmPerson).collect(Collectors.toMap(object -> object.getLong("adjfile.id"), object -> object.getLong("adjapprovalbill")));
        Map<Long, DynamicObject> billEntityMap = this.adjApprovalDomainService.queryAdjBillObjs(null, Lists.newArrayList(fileToBillIdMap.values()));
        List<Long> scmIds = billEntityMap.values().stream().map(object -> object.getLong("salaryadjscm.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> scmObjMap = this.adjApprovalDomainService.queryAdjSchema("id,enableconfirm,transcondition", scmIds);
        ArrayList<DynamicObject> fileIdBillObjList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, Long> entry : fileToBillIdMap.entrySet()) {
            Long billId = entry.getValue();
            DynamicObject billOj = billEntityMap.get(billId);
            long scmId = billOj.getLong("salaryadjscm.id");
            DynamicObject scmObj = scmObjMap.get(scmId);
            if (scmObj == null || !scmObj.getBoolean("enableconfirm") || !scmObj.getString("transcondition").contains(feedbackStatus.getCode())) continue;
            fileIdBillObjList.add(billEntityMap.get(billId));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileIdBillObjList)) {
            List<Long> adjApprBillIdList = fileIdBillObjList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            List<Long> adjConfirmPersonIdList = Arrays.stream(queryConfirmPerson).map(dynamicObject -> dynamicObject.getLong("person.id")).collect(Collectors.toList());
            this.updateAdjApprPerStatus(ConfirmStatusEnum.HAS_CONFIRM, DecAdjSynStatusEnum.TO_SYNC, adjApprBillIdList, adjConfirmPersonIdList);
            DecAdjApprBillSynService decAdjApprBillSynService = new DecAdjApprBillSynService();
            decAdjApprBillSynService.asynDecAdjApprBillPersonDatas(fileIdBillObjList.toArray(new DynamicObject[fileIdBillObjList.size()]), SynOperationEnum.ADJ_CONFIRM.getCode());
        }
    }

    public void onLineConfirmAgree(long adjConfirmPersonId) {
        this.adjApprovalDomainService.onLineConfirmAgree(adjConfirmPersonId);
        this.syncAdjApprovalDetailToAdjFile(Collections.singletonList(adjConfirmPersonId), AdjConfirmFeedbackStatus.CONFIRMED);
    }

    public void onLineConfirmRefuse(long adjConfirmPersonId) {
        this.adjApprovalDomainService.onLineConfirmRefuse(adjConfirmPersonId);
        this.syncAdjApprovalDetailToAdjFile(Collections.singletonList(adjConfirmPersonId), AdjConfirmFeedbackStatus.REFUSED);
    }

    public Map<Long, Date> sendAdjConfirmMsg(List<Long> adjConfirmPersonIds) {
        Map<Long, Long> adjFileIdMap = this.adjApprovalDomainService.queryAdjFileByConfirmPerson(adjConfirmPersonIds);
        Map<Long, Long> hrPersonMap = this.adjFileDomainService.queryHrPersonId(Lists.newArrayList(adjFileIdMap.values()));
        Map<Long, DynamicObject> contactMap = this.adjFileDomainService.queryPersonContactInfo(Lists.newArrayList(hrPersonMap.values()), "phone,peremail");
        Map<Long, Long> hrPersonToBosUserMap = this.adjFileDomainService.queryBosUserIdByHrPersonId(Lists.newArrayList(hrPersonMap.values()));
        Map<Long, Long> adjBillIdMap = this.adjApprovalDomainService.queryAdjApprovalBillIds(adjConfirmPersonIds);
        HashSet adjBillIds = Sets.newHashSet(adjBillIdMap.values());
        Map<Long, Long> adjConfirmTemplateIdMap = this.adjApprovalDomainService.queryTemplateIdByAdjApprovalBillIds(adjBillIds);
        HashSet adjConfirmTemplateIds = Sets.newHashSet(adjConfirmTemplateIdMap.values());
        Map<Long, String> msgTemplateNumberMap = this.adjApprovalDomainService.queryMsgTemplateNumbers(adjConfirmTemplateIds);
        SWCDataServiceHelper templateService = new SWCDataServiceHelper("msg_template");
        DynamicObject[] templateObjs = templateService.query("id,msgchannel", new QFilter[]{new QFilter("number", "in", msgTemplateNumberMap.values())});
        Map msgTplMap = Arrays.stream(templateObjs).collect(Collectors.toMap(object -> object.getString("number"), Function.identity()));
        RequestContext context = RequestContext.get();
        String accountId = context.getAccountId();
        String guestUserId = "Guest";
        String appNumber = "hcdm";
        String webFormId = "hcdm_pcadjlogin";
        String h5FormId = "hcdm_h5adjlogin";
        String webUrlPrefix = UrlService.getDomainContextUrl() + "/index.html?userId={0}&appNumber={1}&formId={2}&accountId={3}&pkId={4}";
        String mobileUrlPrefix = UrlService.getMobileDomainContextUrl() + "/mobile.html?userId={0}&appNumber={1}&form={2}&accountId={3}&pkId={4}";
        ArrayList phoneList = Lists.newArrayListWithCapacity((int)10);
        ArrayList emailList = Lists.newArrayListWithCapacity((int)10);
        ArrayList userIdList = Lists.newArrayListWithCapacity((int)10);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)adjConfirmPersonIds.size());
        for (Long adjConfirmPersonId : adjConfirmPersonIds) {
            Long adjBillId = adjBillIdMap.get(adjConfirmPersonId);
            Long confirmTemplateId = adjConfirmTemplateIdMap.get(adjBillId);
            String msgTemplateNumber = msgTemplateNumberMap.get(confirmTemplateId);
            DynamicObject msgTplObj = (DynamicObject)msgTplMap.get(msgTemplateNumber);
            Long hrPersonId = hrPersonMap.get(adjFileIdMap.get(adjConfirmPersonId));
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setTemplateNumber(msgTemplateNumber);
            messageInfo.setEntityNumber("hcdm_adjconfirmperson");
            messageInfo.setBizDataId(adjConfirmPersonId);
            String webUrl = MessageFormat.format(webUrlPrefix, guestUserId, appNumber, webFormId, accountId, adjConfirmPersonId.toString());
            String mobileUrl = MessageFormat.format(mobileUrlPrefix, guestUserId, appNumber, h5FormId, accountId, adjConfirmPersonId.toString());
            SafeUrlDTO webUrlDTO = (SafeUrlDTO)SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"longToShortByConfig", (Object[])new Object[]{webUrl, "1060_S", "hcdm_adjconfirmperson"});
            SafeUrlDTO mobileUrlDTO = (SafeUrlDTO)SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"longToShortByConfig", (Object[])new Object[]{mobileUrl, "1060_S", "hcdm_adjconfirmperson"});
            messageInfo.setContentUrl(webUrlDTO.getSafeUrl());
            messageInfo.setMobContentUrl(mobileUrlDTO.getSafeUrl());
            String msgChannel = msgTplObj.getString("msgchannel");
            messageInfo.setNotifyType(msgChannel);
            HashMap<String, Object> bizParam = new HashMap<String, Object>();
            messageInfo.setParams(bizParam);
            resultMap.put(adjConfirmPersonId, mobileUrlDTO.getExpiryTime());
            if (StringUtils.equals((CharSequence)msgChannel, (CharSequence)MessageChannels.SMS.getNumber()) || StringUtils.equals((CharSequence)msgChannel, (CharSequence)MessageChannels.EMAIL.getNumber())) {
                DynamicObject contactInfo;
                if (StringUtils.equals((CharSequence)msgChannel, (CharSequence)MessageChannels.SMS.getNumber())) {
                    MessageTemplateCalculate.updateToDoMsgContent(null, (MessageInfo)messageInfo, null);
                    if (messageInfo.getMessageContent() != null) {
                        messageInfo.setContent(messageInfo.getMessageContent().getLocaleValue());
                    }
                    if ((contactInfo = contactMap.get(hrPersonId)) != null) {
                        phoneList.add(contactInfo.getString("phone"));
                    }
                    bizParam.put("phone", phoneList);
                    bizParam.put("bizDescprtion", "bizUseOldImpl");
                }
                if (StringUtils.equals((CharSequence)msgChannel, (CharSequence)MessageChannels.EMAIL.getNumber())) {
                    contactInfo = contactMap.get(hrPersonId);
                    if (contactInfo != null) {
                        emailList.add(contactInfo.getString("peremail"));
                    }
                    bizParam.put("email", emailList);
                }
            } else {
                Long bosUserId = hrPersonToBosUserMap.get(hrPersonId);
                userIdList.add(bosUserId);
                messageInfo.setUserIds((List)userIdList);
            }
            long message = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            userIdList.clear();
            phoneList.clear();
            emailList.clear();
            if (message > 0L) continue;
            throw new RuntimeException(ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25", (String)"AdjApprovalApplicationService_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public AdjConfirmPasswordType getPasswordType(Long adjConfirmPersonId) {
        Map<Long, Long> billIdMap = this.adjApprovalDomainService.queryAdjApprovalBillIds(Collections.singletonList(adjConfirmPersonId));
        Long billId = billIdMap.get(adjConfirmPersonId);
        if (billIdMap.isEmpty() || billId == null || billId == 0L) {
            return null;
        }
        Map<Long, DynamicObject> longDynamicObjectMap = this.adjApprovalDomainService.queryAdjBillObjs("id,salaryadjscm", Collections.singletonList(billId));
        DynamicObject billObj = longDynamicObjectMap.get(billId);
        if (billObj == null) {
            return null;
        }
        long scmId = billObj.getLong("salaryadjscm.id");
        Map<Long, DynamicObject> scmObjMap = this.adjApprovalDomainService.queryAdjSchema("id,passwordtype", Collections.singletonList(scmId));
        return AdjConfirmPasswordType.getByCode(scmObjMap.get(scmId).getString("passwordtype"));
    }

    public String encryptPassword(String password) {
        return null;
    }

    public VerifyCodeDto generateRandomImageCode() {
        return LoginVerifyCodeHelper.getVerifyCodeImageUrl();
    }

    public boolean sendSMSVerifyCodeByTpl(String phone, Long adjConfirmPersonId) {
        Long sysUserId = this.querySysUserId(adjConfirmPersonId);
        if (sysUserId == null || sysUserId == 0L) {
            return false;
        }
        boolean sendFlag = true;
        try {
            VerifyCodeDto verifyCodeSms = LoginVerifyCodeHelper.getVerifyCodeSms(adjConfirmPersonId, phone);
            DynamicObjectCollection msgInfoCol = this.getMsgInfoCol();
            ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
            String tag = ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801", (String)"AdjApprovalApplicationService_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
            String title = ResManager.loadKDString((String)"\u8c03\u85aa\u786e\u8ba4\u9a8c\u8bc1\u7801", (String)"AdjApprovalApplicationService_2", (String)"swc-hcdm-business", (Object[])new Object[0]);
            for (DynamicObject msg : msgInfoCol) {
                MessageInfo info = new MessageInfo();
                info.setNestBillno("hcdm_adjcfmverify");
                info.setTag(tag);
                info.setTitle(title);
                info.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
                info.setUserIds((List)Lists.newArrayList((Object[])new Long[]{sysUserId}));
                info.setType("message");
                info.setEntityNumber("hcdm_adjcfmverify");
                info.setBizDataId(verifyCodeSms.getId());
                info.setTplScene(msg.getString("msgscene"));
                info.setNotifyType(msg.getString("msgchannel"));
                info.setContent(verifyCodeSms.getMessage());
                messageInfos.add(info);
            }
            MessageCenterServiceHelper.batchSendMessages(messageInfos);
        }
        catch (Exception exc) {
            sendFlag = false;
        }
        return sendFlag;
    }

    private DynamicObjectCollection getMsgInfoCol() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("msg_template");
        QFilter filter = new QFilter("msgentity", "in", (Object)"hcdm_adjcfmverify");
        return helper.queryOriginalCollection("msgchannel,msgscene", new QFilter[]{filter});
    }

    @Deprecated
    public boolean sendSMSVerifyCode(String phone) {
        return false;
    }

    public Map<String, Object> queryPayslipPassword(long hrPersonId, String password) {
        return (Map)SWCMServiceUtils.invokeSWCService((String)"hspp", (String)"IHSPPService", (String)"authenticatePwdByPersonId", (Object[])new Object[]{hrPersonId, password});
    }

    public VerifyCodeDto queryLastSMS() {
        return LoginVerifyCodeHelper.getCacheRandCode(false);
    }

    public VerifyCodeDto queryLastImageCode() {
        return LoginVerifyCodeHelper.getCacheRandCode(true);
    }

    public Map<String, String> getVarParamMap() {
        return this.adjApprovalDomainService.getVarParamMap();
    }

    private String trimToZero(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "0";
        }
        return value;
    }

    public DynamicObject getFirstAdjFieldCfgWithPerm(Long createOrgId, String attributionType) {
        Object[] dynamicObjects = this.adjApprovalDomainService.getAdjFieldCfgWithPerm(createOrgId, attributionType);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        return dynamicObjects[0];
    }

    public DynamicObject getAdjFieldCfgById(Long pkId) {
        DynamicObject dynamicObject = this.adjApprovalDomainService.getAdjFieldCfgById(pkId);
        return dynamicObject;
    }

    public List<DynamicObject> getAdjDetailField(List<String> targetFields, String attributionType) {
        DynamicObject[] fields = this.adjApprovalDomainService.getAdjDetailFields(attributionType);
        return Arrays.stream(fields).filter(field -> targetFields.contains(field.getString("fieldnumber"))).collect(Collectors.toList());
    }

    public Set<String> getAdjFdOfImportMustInput(Long pkId) {
        DynamicObject configObj = this.getAdjFieldCfgById(pkId);
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)16);
        if (configObj == null) {
            return resultSet;
        }
        DynamicObjectCollection adjFieldCfgWithPermDetail = configObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldCfg : adjFieldCfgWithPermDetail) {
            String propertyName = fieldCfg.getString("adjdetailfield.fieldnumber");
            boolean importMustInput = StringUtils.equals((CharSequence)fieldCfg.getString("adjdetailfield.importmustinput"), (CharSequence)"1");
            if (!importMustInput) continue;
            resultSet.add(propertyName);
        }
        return resultSet;
    }

    public Map<Long, Map<Long, Object>> getContrastPropValue(List<ContrastPropConfigEntity> propCfg, List<Long> fileIds, boolean isVersion) {
        ContrastPropLoadEvent contrastPropLoadEvent = new ContrastPropLoadEvent((Object)this);
        contrastPropLoadEvent.setPropCfgList(propCfg);
        contrastPropLoadEvent.setAdjFileIdList(fileIds);
        contrastPropLoadEvent.setVersion(isVersion);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new HcdmContrastPropPlugin(), IHcdmContrastPropExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin#loadContrastPropValue", null);
        pluginProxy.callAfter(plugin -> {
            plugin.loadContrastPropValue(contrastPropLoadEvent);
            return null;
        });
        return contrastPropLoadEvent.getPropValues();
    }

    public Map<Long, Map<Long, Object>> getContrastPropValueByDepEmp(List<ContrastPropConfigEntity> propCfg, List<Long> depEmpIds, boolean isVersion) {
        ContrastPropLoadEvent contrastPropLoadEvent = new ContrastPropLoadEvent((Object)this);
        contrastPropLoadEvent.setPropCfgList(propCfg);
        List personParams = depEmpIds.stream().map(aLong -> {
            PersonQueryParam param = new PersonQueryParam();
            param.setDepEmpId(aLong);
            param.setPersonType("2");
            return param;
        }).collect(Collectors.toList());
        contrastPropLoadEvent.setPersonQueryParams(personParams);
        contrastPropLoadEvent.setVersion(isVersion);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new HcdmContrastPropPluginByDepEmp(), IHcdmContrastPropExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin#loadContrastPropValue", null);
        pluginProxy.callAfter(plugin -> {
            plugin.loadContrastPropValue(contrastPropLoadEvent);
            return null;
        });
        return contrastPropLoadEvent.getPropValues();
    }

    public Map<Long, Map<Long, Object>> getContrastPropValueOfCandidate(List<ContrastPropConfigEntity> propCfg, Map<Long, DynamicObject> candidateToDysMap, boolean isVersion) {
        CandContrastPropLoadEvent candContrastPropLoadEvent = new CandContrastPropLoadEvent((Object)this);
        candContrastPropLoadEvent.setPropCfg(propCfg);
        candContrastPropLoadEvent.setCandidateToDysMap(candidateToDysMap);
        candContrastPropLoadEvent.setVersion(isVersion);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new HcdmContrastPropPluginForCand(), IHcdmContrastPropForCandExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropForCandExtPlugin#loadContrastPropValueForCand", null);
        pluginProxy.callAfter(plugin -> {
            plugin.loadContrastPropValueForCand(candContrastPropLoadEvent);
            return null;
        });
        return candContrastPropLoadEvent.getPropValues();
    }

    public Map<Long, Map<Long, SalaryStdMatchResultNew>> batchMatchStdTable(List<MatchStdTableWithAdjFileParam> paramList) {
        SalaryStdMatchManager matchManager = new SalaryStdMatchManager();
        return matchManager.batchMatchStdTableWithAdjFile(paramList);
    }

    public Map<Long, Map<Long, SalaryStdMatchResultNew>> batchMatchStdTableForCandidate(List<MatchStdTableForCandidateParam> paramList) {
        SalaryStdMatchManager matchManager = new SalaryStdMatchManager();
        return matchManager.batchMatchStdTableForCandidate(paramList);
    }

    public Map<Long, List<ContrastPropResult>> getContrastProp(List<Long> stdTableIdList) {
        SalaryStdApplicationService stdAppService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        return stdAppService.getContrastProp(stdTableIdList);
    }

    public Map<String, StdSimpleMatchResult> matchTableRange(List<SimpleMatchParam> params) {
        SalaryStdApplicationService stdAppService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        return stdAppService.matchTableRange(params);
    }

    public void updateAdjApprPerStatus(ConfirmStatusEnum confirmStatus, DecAdjSynStatusEnum decAdjSynStatus, List<Long> adjApprBillIdList, List<Long> adjConfirmPersonIds) {
        AdjApprPerQueryParam adjApprPerQueryParam = new AdjApprPerQueryParam();
        adjApprPerQueryParam.setAdjApprBillIds(adjApprBillIdList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(adjConfirmPersonIds)) {
            adjApprPerQueryParam.setPersonIds(new HashSet<Long>(adjConfirmPersonIds));
        }
        DynamicObject[] adjApprPersonArray = DecAdjApprGridHelper.getAdjApprPersonData("id", adjApprPerQueryParam);
        String updateSql = "update t_hcdm_adjapprper set fconfirmstatus= ? ,fsynstatus= ? where fid in %s";
        List idList = Arrays.stream(adjApprPersonArray).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Lists.partition(idList, (int)900).forEach(batchIds -> {
            String sqlStr = String.format(updateSql, HCDMDbHelper.getFidHolder(batchIds.size()));
            ArrayList params = Lists.newArrayListWithExpectedSize((int)(batchIds.size() + 2));
            params.add(confirmStatus.getCode());
            params.add(decAdjSynStatus.getCode());
            params.addAll(batchIds);
            DB.execute((DBRoute)DBRoute.of((String)"hcdm"), (String)sqlStr, (Object[])params.toArray());
        });
    }

    public List<SalaryStdMatchResultNew> batchMatchStdTableWithDepEmp(List<StdMatchParamWithDepEmp> params) {
        SalaryStdMatchManager matchManager = new SalaryStdMatchManager();
        return matchManager.batchMatchStdTableWithDepEmp(params);
    }

    public Map<String, SimpleStdRangeMatchResult> matchRangeWithStdTableId(List<SimpleStdRangeMatchParam> params) {
        SalaryStdMatchManager matchManager = new SalaryStdMatchManager();
        return matchManager.matchRangeWithStdTableId(params);
    }

    private int getSmsSendnumLimitExt() {
        OnGetAdjConfirmSmsSendNumEvent event = new OnGetAdjConfirmSmsSendNumEvent((Object)this);
        event.setSmsSendNum(10);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new DefaultDecAdjApprSupportPlugin(), IDecAdjApprExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprExtPlugin#onGetAdjConfirmSmsSendNum", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            plugin.onGetAdjConfirmSmsSendNum(event);
            return null;
        });
        return event.getSmsSendNum();
    }
}

