/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapplication.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.DecAdjSalaryEntity;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.SalaryAdjRecordRelPersonDynEntity;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.adjfile.AdjFileMatchParam;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileMatchResult;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileNotFoundErrorEnum;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.service.AdjFileDomainService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncFacade;
import kd.swc.hcdm.common.entity.adjfile.AdjFileMaxDateEntity;
import kd.swc.hcdm.common.entity.adjfile.DecAdjSalaryEvent;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

@HrDomainEntity
public class AdjFileApplicationService {
    private static final Log logger = LogFactory.getLog(AdjFileApplicationService.class);
    private AdjFileDomainService adjFileDomainService;
    private static final CloneUtils cloneUtils = new CloneUtils(false, true);
    private final int batchSize = 1000;

    public AdjFileDomainService getAdjFileDomainService() {
        return this.adjFileDomainService;
    }

    public void setAdjFileDomainService(AdjFileDomainService adjFileDomainService) {
        this.adjFileDomainService = adjFileDomainService;
    }

    private static Date getDefaultMaxDate() {
        Date defaultMaxDate = null;
        try {
            defaultMaxDate = SWCDateTimeUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException e) {
            logger.error("parse date error\uff1a{}", (Object)e.getMessage());
        }
        return defaultMaxDate;
    }

    public Map<Long, DynamicObject> getMaxDisableDate(String entity, Collection<Long> boIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entity);
        DynamicObject[] dynamicObjects = serviceHelper.query("id,boid,datastatus,enable,bsed,bsled", new QFilter[]{new QFilter("boid", "in", boIds), new QFilter("iscurrentversion", "!=", (Object)"1")}, "bsed asc");
        Map<Long, List<DynamicObject>> dynamicObjectMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(object -> object.getLong("boid")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)boIds.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : dynamicObjectMap.entrySet()) {
            Long boId = entry.getKey();
            List<DynamicObject> versionObjs = entry.getValue();
            int effectingIndex = versionObjs.size() + 1;
            DynamicObject maxDisableDyObj = null;
            for (int i = 0; i < versionObjs.size(); ++i) {
                DynamicObject dynamicObject = versionObjs.get(i);
                String dataStatus = dynamicObject.getString("datastatus");
                String enableStatus = dynamicObject.getString("enable");
                if ("1".equals(dataStatus)) {
                    effectingIndex = i;
                }
                if (i > effectingIndex || !"0".equals(enableStatus) || "-2".equals(dataStatus) || "-1".equals(dataStatus)) continue;
                maxDisableDyObj = dynamicObject;
            }
            if (maxDisableDyObj == null) continue;
            resultMap.put(boId, maxDisableDyObj);
        }
        return resultMap;
    }

    public DynamicObject queryAdjFileByPersonId(String selectProperties, Long personId) {
        return this.adjFileDomainService.queryAdjFileByPersonId(selectProperties, personId);
    }

    public Map<Long, Long> getWorkplaceByFile(Set<Long> fileIds) {
        return this.adjFileDomainService.getWorkplaceByFile(fileIds);
    }

    public Map<Long, Long> getDepartmentByFile(Set<Long> fileIds) {
        return this.adjFileDomainService.getDepartmentByFile(fileIds);
    }

    public Map<Long, Long> getWorkplaceByDepEmp(Set<Long> depempIds) {
        return this.adjFileDomainService.getWorkplaceByDepEmp(depempIds);
    }

    public Map<Long, Long> getDepartmentByDepEmp(Set<Long> depempIds) {
        return this.adjFileDomainService.getDepartmentByDepEmp(depempIds);
    }

    public Map<String, String> saveTimeVersionForBill(List<DecAdjSalaryEntity> paramsList, DecAdjSalaryEvent decAdjSalaryEvent) {
        if (paramsList == null || paramsList.isEmpty()) {
            return Collections.emptyMap();
        }
        long start1 = System.currentTimeMillis();
        this.completeFixeditem(paramsList);
        long end1 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#completeFixeditem spend time is\uff1a{}", (Object)(end1 - start1));
        long start2 = System.currentTimeMillis();
        this.completeFieldBo(paramsList);
        long end2 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#completeFieldBo spend time is\uff1a{}", (Object)(end2 - start2));
        if (!SWCStringUtils.equals((String)EventTypeEnum.SALARYADJRECORD_IMPORT.getCode(), (String)paramsList.get(0).getDatasource())) {
            Map<String, String> adjfileMatchResultMap = this.matchAdjFileVersion(paramsList);
            logger.info("saveTimeVersionForBill#matchAdjFileVersion spend time is\uff1a{}", (Object)(System.currentTimeMillis() - end2));
            if (!adjfileMatchResultMap.isEmpty()) {
                return adjfileMatchResultMap;
            }
        }
        long end3 = System.currentTimeMillis();
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        Set<Long> adjfileIdSets = paramsList.stream().filter(entity -> null != entity.getSalaryadjfileId()).map(DecAdjSalaryEntity::getSalaryadjfileId).collect(Collectors.toSet());
        DynamicObject[] decideAdjSalaryObjs = this.adjFileDomainService.queryDecideAdjSalaryObj("id,amount,currency,frequency,salaryadjrsn,bussinessid,bsed,bsled,datasource,boid,salaryadjfilevid,salaryadjfile.id,standarditem.id", adjfileIdSets, true);
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        long end4 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#queryDecideAdjSalaryObj spend time is\uff1a{}", (Object)(end4 - end3));
        Map<AdjAttributionType, List<DecAdjSalaryEntity>> groupByType = paramsList.stream().collect(Collectors.groupingBy(DecAdjSalaryEntity::getBillType));
        HashBasedTable oldDataTable = HashBasedTable.create();
        DynamicObject decAdjDyn = null;
        for (DynamicObject fileObject : decideAdjSalaryObjs) {
            Long standarditemId;
            Long salaryAdjFileId = fileObject.getLong("salaryadjfile.id");
            decAdjDyn = (DynamicObject)oldDataTable.get((Object)salaryAdjFileId, (Object)(standarditemId = Long.valueOf(fileObject.getLong("standarditem.id"))));
            if (decAdjDyn == null) {
                decAdjDyn = fileObject;
            }
            oldDataTable.put((Object)salaryAdjFileId, (Object)standarditemId, (Object)decAdjDyn);
        }
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needNewHisList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> relPersonDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
        String event = decAdjSalaryEvent.getEvent();
        DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(event);
        Long eventPkId = 0L;
        eventPkId = null == eventDyn ? this.genEventDyn(event, eventDynList, null, decAdjSalaryEvent.getNeedRepush()) : Long.valueOf(eventDyn.getLong("id"));
        String dataSource = null;
        if (oldDataTable.isEmpty()) {
            int relPersonPkIdSize = this.getRelPersonPkIdSize(paramsList);
            long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(relPersonPkIdSize);
            --relPersonPkIdSize;
            for (int i = 0; i < paramsList.size(); ++i) {
                DecAdjSalaryEntity entity2 = paramsList.get(i);
                List salaryAdjRecordRelPersonDynEntities = entity2.getSalaryAdjRecordRelPersonDynEntities();
                if (salaryAdjRecordRelPersonDynEntities == null) continue;
                for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                    DynamicObject relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                    DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                    Long personPkId = relPersonIds[relPersonPkIdSize--];
                    if (relpersonDyn != null) {
                        relpersonDyn.set("id", (Object)personPkId);
                        relPersonDys.add(relpersonDyn);
                    }
                    Long bussinessId = entity2.getBussinessId();
                    DynamicObject decAdjSalDyn = this.adjFileDomainService.generateEmptyDecideAdjSalary();
                    SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)salaryAdjRecord, (DynamicObject)decAdjSalDyn, null, null);
                    decAdjSalDyn.set("relpersonid", (Object)personPkId);
                    decAdjSalDyn.set("bussinessid", (Object)bussinessId);
                    AdjFileApplicationService.completeHisVersion(needSaveList, needNewHisList, decAdjSalDyn);
                    if (dataSource != null) continue;
                    dataSource = salaryAdjRecord.getString("datasource");
                }
            }
        } else {
            List<DecAdjSalaryEntity> adjList;
            Long personPkId;
            List<DecAdjSalaryEntity> decideList = groupByType.get(AdjAttributionType.DECATTRTYPE);
            if (CollectionUtils.isNotEmpty(decideList)) {
                int relPersonPkIdSize = this.getRelPersonPkIdSize(decideList);
                long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(relPersonPkIdSize);
                --relPersonPkIdSize;
                for (int i = 0; i < decideList.size(); ++i) {
                    DecAdjSalaryEntity decEntity = decideList.get(i);
                    Long salaryadjfileId = decEntity.getSalaryadjfileId();
                    Long bussinessId = decEntity.getBussinessId();
                    List salaryAdjRecordRelPersonDynEntities = decEntity.getSalaryAdjRecordRelPersonDynEntities();
                    if (!oldDataTable.containsRow((Object)salaryadjfileId)) {
                        if (salaryAdjRecordRelPersonDynEntities == null) continue;
                        for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                            DynamicObject relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                            DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                            personPkId = relPersonIds[relPersonPkIdSize--];
                            if (relpersonDyn != null) {
                                relpersonDyn.set("id", (Object)personPkId);
                                relPersonDys.add(relpersonDyn);
                            }
                            if (null == salaryadjfileId) continue;
                            salaryAdjRecord.set("bussinessid", (Object)bussinessId);
                            salaryAdjRecord.set("relpersonid", (Object)personPkId);
                            AdjFileApplicationService.completeHisVersion(needSaveList, needNewHisList, salaryAdjRecord);
                            if (dataSource != null) continue;
                            dataSource = salaryAdjRecord.getString("datasource");
                        }
                        continue;
                    }
                    Map oldItemMap = oldDataTable.row((Object)salaryadjfileId);
                    Iterator<DynamicObject> salaryAdjRecords = new ArrayList(10);
                    for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                        DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                        salaryAdjRecords.add(salaryAdjRecord);
                        salaryAdjRecord.set("bussinessid", (Object)bussinessId);
                        DynamicObject relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                        if (relpersonDyn == null) continue;
                        Long personPkId2 = relPersonIds[relPersonPkIdSize--];
                        relpersonDyn.set("id", (Object)personPkId2);
                        salaryAdjRecord.set("relpersonid", (Object)personPkId2);
                        relPersonDys.add(relpersonDyn);
                    }
                    List<DynamicObject> curItemDyByAsc = this.adjFileDomainService.getSortedBsedByAsc(salaryAdjRecords.toArray(new DynamicObject[0]));
                    dataSource = this.dealDecideVersion(curItemDyByAsc, oldItemMap, needSaveList, needNewHisList, dataSource, null);
                }
            }
            if (CollectionUtils.isNotEmpty(adjList = groupByType.get(AdjAttributionType.ADJATTRTYPE))) {
                int relPersonPkIdSize = this.getRelPersonPkIdSize(adjList);
                long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(relPersonPkIdSize);
                --relPersonPkIdSize;
                for (int i = 0; i < adjList.size(); ++i) {
                    DecAdjSalaryEntity adjSalaryEntity = adjList.get(i);
                    Long salaryadjfileId = adjSalaryEntity.getSalaryadjfileId();
                    Long bussinessId = adjSalaryEntity.getBussinessId();
                    List salaryAdjRecordRelPersonDynEntities = adjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
                    if (salaryAdjRecordRelPersonDynEntities == null) continue;
                    for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                        DynamicObject relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                        personPkId = relPersonIds[relPersonPkIdSize--];
                        if (relpersonDyn != null) {
                            relpersonDyn.set("id", (Object)personPkId);
                            relPersonDys.add(relpersonDyn);
                        }
                        DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                        salaryAdjRecord.set("status", (Object)"C");
                        salaryAdjRecord.set("enable", (Object)"1");
                        salaryAdjRecord.set("bussinessid", (Object)bussinessId);
                        salaryAdjRecord.set("relpersonid", (Object)personPkId);
                        Long standarditemId = salaryAdjRecord.getLong("standarditem.id");
                        DynamicObject oldItemDyn = (DynamicObject)oldDataTable.get((Object)salaryadjfileId, (Object)standarditemId);
                        if (null == oldItemDyn) {
                            AdjFileApplicationService.completeHisVersion(needSaveList, needNewHisList, salaryAdjRecord);
                        } else {
                            salaryAdjRecord.set("boid", (Object)oldItemDyn.getLong("boid"));
                            needNewHisList.add(salaryAdjRecord);
                        }
                        if (dataSource != null) continue;
                        dataSource = salaryAdjRecord.getString("datasource");
                    }
                }
            }
        }
        long end5 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#dealParamsList spend time is\uff1a{}", (Object)(end5 - end4));
        if (CollectionUtils.isNotEmpty(eventDynList)) {
            ((DynamicObject)eventDynList.get(0)).set("eventtype", dataSource);
            this.adjFileDomainService.saveDecAdjEvent(eventDynList);
        }
        this.adjFileDomainService.saveRelPerson(relPersonDys);
        long end6 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#saveDecAdjEvent#saveRelPerson spend time is\uff1a{}", (Object)(end6 - end5));
        if (CollectionUtils.isNotEmpty(needSaveList)) {
            OperationResult operationResult = this.adjFileDomainService.saveItemDataByOperate(needSaveList, eventPkId);
            boolean success = operationResult.isSuccess();
            logger.info("saveTimeVersionForBill saveop isSuccess:{}", (Object)success);
            if (!success) {
                String msg = operationResult.getMessage();
                logger.info("saveTimeVersionForBill saveop false msg is {}", (Object)msg);
                List operateInfos = operationResult.getAllErrorOrValidateInfo();
                HashSet<String> errMsg = new HashSet<String>(16);
                for (IOperateInfo operateInfo : operateInfos) {
                    errMsg.add(operateInfo.getMessage());
                }
                logger.info("saveTimeVersionForBill saveop getAllErrorOrValidateInfo msg is {}", (Object)SerializationUtils.toJsonString(errMsg));
            }
        }
        long end7 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#saveop spend time is\uff1a{}", (Object)(end7 - end6));
        if (!needNewHisList.isEmpty()) {
            for (int i = 0; i < needNewHisList.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)needNewHisList.get(i);
                logger.info("needNewHisList param: size is {}, needNewHisList{}: bsed is{}, bsled is {}, enable is {},fileid is {}", new Object[]{needNewHisList.size(), i, dynamicObject.getDate("bsed"), dynamicObject.getDate("bsled"), dynamicObject.get("enable"), dynamicObject.get("salaryadjfile.id")});
            }
            BaseDataHisHelper.saveTimeVersion((DynamicObject[])needNewHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
        }
        logger.info("begain generateSyncDataFromRec");
        long end8 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#saveTimeVersion spend time is\uff1a{}", (Object)(end8 - end7));
        ArrayList record = Lists.newArrayListWithExpectedSize((int)(needSaveList.size() + needNewHisList.size()));
        record.addAll(needSaveList);
        record.addAll(needNewHisList);
        SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, record, relPersonDys);
        long end9 = System.currentTimeMillis();
        logger.info("saveTimeVersionForBill#generateSyncDataFromRec spend time is\uff1a{}", (Object)(end9 - end8));
        return Collections.emptyMap();
    }

    private Map<String, String> matchAdjFileVersion(List<DecAdjSalaryEntity> paramsList) {
        ArrayList<AdjFileMatchParam> matchFileParams = new ArrayList<AdjFileMatchParam>(10);
        for (DecAdjSalaryEntity decAdjSalaryEntity : paramsList) {
            List entities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
            Long adjFielBOId = decAdjSalaryEntity.getSalaryadjfileId();
            for (SalaryAdjRecordRelPersonDynEntity entity : entities) {
                DynamicObject salaryAdjRecord = entity.getSalaryAdjRecord();
                AdjFileMatchParam fileMatchParam = new AdjFileMatchParam();
                fileMatchParam.setAdjFileBoId(adjFielBOId);
                fileMatchParam.setBsed(salaryAdjRecord.getDate("bsed"));
                Date bsled = salaryAdjRecord.getDate("bsled") == null ? SWCDateTimeUtils.getMaxBsled() : salaryAdjRecord.getDate("bsled");
                fileMatchParam.setBsled(bsled);
                String unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(adjFielBOId), salaryAdjRecord.getString("standarditem.id"), SWCDateTimeUtils.format((Date)salaryAdjRecord.getDate("bsed"), (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
                fileMatchParam.setUnionId(unionId);
                matchFileParams.add(fileMatchParam);
            }
        }
        Map<String, AdjfileMatchResult> adjfileMatchResultMap = this.batchMatchEffectiveAdjfileVersion(matchFileParams);
        HashMap<String, String> matchFileErrorMap = new HashMap<String, String>(16);
        for (DecAdjSalaryEntity decAdjSalaryEntity : paramsList) {
            List entities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
            Long adjFielBOId = decAdjSalaryEntity.getSalaryadjfileId();
            for (SalaryAdjRecordRelPersonDynEntity entity : entities) {
                Date bsled;
                DynamicObject salaryAdjRecord = entity.getSalaryAdjRecord();
                Date date = bsled = salaryAdjRecord.getDate("bsled") == null ? SWCDateTimeUtils.getMaxBsled() : salaryAdjRecord.getDate("bsled");
                String unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(adjFielBOId), salaryAdjRecord.getString("standarditem.id"), SWCDateTimeUtils.format((Date)salaryAdjRecord.getDate("bsed"), (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
                AdjfileMatchResult adjfileMatchResult = adjfileMatchResultMap.get(unionId);
                if (null == adjfileMatchResult) continue;
                if (null != adjfileMatchResult.getAdjfileVersion()) {
                    salaryAdjRecord.set("salaryadjfilevid", (Object)adjfileMatchResult.getAdjfileVersion());
                    continue;
                }
                matchFileErrorMap.put(unionId, adjfileMatchResult.getAdjfileNotFoundErrorEnum().getLocaleName().loadKDString());
            }
        }
        return matchFileErrorMap;
    }

    private void completeFieldBo(List<DecAdjSalaryEntity> paramsList) {
        HashSet adminorgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet stdpositionIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet projectteamIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DecAdjSalaryEntity decAdjSalaryEntity : paramsList) {
            List entities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
            for (SalaryAdjRecordRelPersonDynEntity entity : entities) {
                DynamicObject relpersonDyn = entity.getRelpersonDyn();
                adminorgIds.add(relpersonDyn.getLong("company.id"));
                adminorgIds.add(relpersonDyn.getLong("adminorg.id"));
                adminorgIds.add(relpersonDyn.getLong("assoadminorg.id"));
                positionIds.add(relpersonDyn.getLong("position.id"));
                stdpositionIds.add(relpersonDyn.getLong("stdposition.id"));
                projectteamIds.add(relpersonDyn.getLong("projectteam.id"));
            }
        }
        Map adminorgBoMap = BaseDataHisHelper.getCurrentOfVersion((String)"haos_adminorghr", (Collection)adminorgIds);
        this.setBo(paramsList, adminorgBoMap, "haos_adminorghr", "company", "companybo");
        this.setBo(paramsList, adminorgBoMap, "haos_adminorghr", "adminorg", "adminorgbo");
        this.setBo(paramsList, adminorgBoMap, "haos_adminorghr", "assoadminorg", "assoadminorgbo");
        this.setBo(paramsList, BaseDataHisHelper.getCurrentOfVersion((String)"hbpm_positionhr", (Collection)positionIds), "hbpm_positionhr", "position", "positionbo");
        this.setBo(paramsList, BaseDataHisHelper.getCurrentOfVersion((String)"hbpm_stposition", (Collection)stdpositionIds), "hbpm_stposition", "stdposition", "stdpositionbo");
        this.setBo(paramsList, BaseDataHisHelper.getCurrentOfVersion((String)"haos_projectteamhr", (Collection)projectteamIds), "haos_projectteamhr", "projectteam", "projectteambo");
    }

    private void setBo(List<DecAdjSalaryEntity> paramsList, Map<Long, Long> boIdMap, String entityNumber, String vidField, String boField) {
        if (MapUtils.isEmpty(boIdMap)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        for (DecAdjSalaryEntity decAdjSalaryEntity : paramsList) {
            List entities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
            for (SalaryAdjRecordRelPersonDynEntity entity : entities) {
                DynamicObject personDyn = entity.getRelpersonDyn();
                Long companyId = personDyn.getLong(vidField + ".id");
                if (companyId <= 0L || boIdMap.get(companyId) <= 0L) continue;
                DynamicObject dy = serviceHelper.generateEmptyDynamicObject();
                dy.set("id", (Object)boIdMap.get(companyId));
                personDyn.set(boField, (Object)dy);
            }
        }
    }

    private void completeFixeditem(List<DecAdjSalaryEntity> paramsList) {
        HashSet<Long> itemIdSet = new HashSet<Long>(16);
        for (DecAdjSalaryEntity decAdjSalaryEntity : paramsList) {
            List entities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
            for (SalaryAdjRecordRelPersonDynEntity entity : entities) {
                DynamicObject salaryAdjRecord = entity.getSalaryAdjRecord();
                itemIdSet.add(salaryAdjRecord.getLong("standarditem.id"));
            }
        }
        Map<Long, DynamicObject> standardItemMap = SalaryAdjFileServiceHelper.getStandardItemMap("id,fixeditem", itemIdSet);
        for (DecAdjSalaryEntity decAdjSalaryEntity : paramsList) {
            List entities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
            for (SalaryAdjRecordRelPersonDynEntity entity : entities) {
                DynamicObject itemDy;
                DynamicObject salaryAdjRecord = entity.getSalaryAdjRecord();
                String fixeditem = salaryAdjRecord.getString("fixeditem");
                if (!StringUtils.isEmpty((CharSequence)fixeditem) || (itemDy = standardItemMap.get(salaryAdjRecord.getLong("standarditem.id"))) == null) continue;
                salaryAdjRecord.set("fixeditem", (Object)itemDy.getString("fixeditem"));
            }
        }
    }

    public void saveTimeVersionForRevisionAddNew(List<DecAdjSalaryEntity> paramsList, DecAdjSalaryEvent decAdjSalaryEvent) {
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        this.completeFixeditem(paramsList);
        this.completeFieldBo(paramsList);
        this.matchAdjFileVersion(paramsList);
        Set<Long> adjFileBoIdSets = paramsList.stream().map(DecAdjSalaryEntity::getSalaryadjfileId).collect(Collectors.toSet());
        DynamicObject[] decideAdjSalaryObjs = this.adjFileDomainService.queryDecideAdjSalaryObj(adjFileBoIdSets, true);
        Map<String, DynamicObject> minBsedDyMap = this.getMinBsedDyMap(adjFileBoIdSets);
        Map<AdjAttributionType, List<DecAdjSalaryEntity>> groupByType = paramsList.stream().collect(Collectors.groupingBy(DecAdjSalaryEntity::getBillType));
        HashBasedTable oldDataTable = HashBasedTable.create();
        DynamicObject decAdjDyn = null;
        for (DynamicObject fileObject : decideAdjSalaryObjs) {
            Long standarditemId;
            Long salaryAdjFileId = fileObject.getLong("salaryadjfile.id");
            decAdjDyn = (DynamicObject)oldDataTable.get((Object)salaryAdjFileId, (Object)(standarditemId = Long.valueOf(fileObject.getLong("standarditem.id"))));
            if (decAdjDyn == null) {
                decAdjDyn = fileObject;
            }
            oldDataTable.put((Object)salaryAdjFileId, (Object)standarditemId, (Object)decAdjDyn);
        }
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needNewHisList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> relPersonDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
        String event = decAdjSalaryEvent.getEvent();
        DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(event);
        Long eventPkId = 0L;
        eventPkId = null == eventDyn ? this.genEventDyn(event, eventDynList, null, decAdjSalaryEvent.getNeedRepush()) : Long.valueOf(eventDyn.getLong("id"));
        String dataSource = null;
        if (oldDataTable.isEmpty()) {
            int relPersonPkIdSize = this.getRelPersonPkIdSize(paramsList);
            long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(relPersonPkIdSize);
            --relPersonPkIdSize;
            for (int i = 0; i < paramsList.size(); ++i) {
                DecAdjSalaryEntity entity = paramsList.get(i);
                List salaryAdjRecordRelPersonDynEntities = entity.getSalaryAdjRecordRelPersonDynEntities();
                if (salaryAdjRecordRelPersonDynEntities == null) continue;
                for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                    DynamicObject relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                    DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                    Long personPkId = relPersonIds[relPersonPkIdSize--];
                    if (relpersonDyn != null) {
                        relpersonDyn.set("id", (Object)personPkId);
                        relPersonDys.add(relpersonDyn);
                    }
                    DynamicObject decAdjSalDyn = this.adjFileDomainService.generateEmptyDecideAdjSalary();
                    SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)salaryAdjRecord, (DynamicObject)decAdjSalDyn, null, null);
                    decAdjSalDyn.set("relpersonid", (Object)personPkId);
                    AdjFileApplicationService.completeHisVersion(needSaveList, needNewHisList, decAdjSalDyn);
                    if (dataSource != null) continue;
                    dataSource = salaryAdjRecord.getString("datasource");
                }
            }
        } else {
            List<DecAdjSalaryEntity> adjList;
            DynamicObject salaryAdjRecord;
            DynamicObject relpersonDyn;
            List salaryAdjRecordRelPersonDynEntities;
            List<DecAdjSalaryEntity> decideList = groupByType.get(AdjAttributionType.DECATTRTYPE);
            if (CollectionUtils.isNotEmpty(decideList)) {
                int relPersonPkIdSize = this.getRelPersonPkIdSize(decideList);
                long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(relPersonPkIdSize);
                --relPersonPkIdSize;
                for (int i = 0; i < decideList.size(); ++i) {
                    DecAdjSalaryEntity decEntity = decideList.get(i);
                    Long salaryadjfileId = decEntity.getSalaryadjfileId();
                    Long bussinessId = decEntity.getBussinessId();
                    salaryAdjRecordRelPersonDynEntities = decEntity.getSalaryAdjRecordRelPersonDynEntities();
                    if (!oldDataTable.containsRow((Object)salaryadjfileId)) {
                        if (salaryAdjRecordRelPersonDynEntities == null) continue;
                        for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                            relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                            DynamicObject salaryAdjRecord2 = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                            Long personPkId = relPersonIds[relPersonPkIdSize--];
                            if (relpersonDyn != null) {
                                relpersonDyn.set("id", (Object)personPkId);
                                relPersonDys.add(relpersonDyn);
                            }
                            if (null == salaryadjfileId) continue;
                            salaryAdjRecord2.set("relpersonid", (Object)personPkId);
                            AdjFileApplicationService.completeHisVersion(needSaveList, needNewHisList, salaryAdjRecord2);
                            if (dataSource != null) continue;
                            dataSource = salaryAdjRecord2.getString("datasource");
                        }
                        continue;
                    }
                    Map oldItemMap = oldDataTable.row((Object)salaryadjfileId);
                    ArrayList<DynamicObject> salaryAdjRecords = new ArrayList<DynamicObject>(10);
                    for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                        salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                        salaryAdjRecords.add(salaryAdjRecord);
                        salaryAdjRecord.set("bussinessid", (Object)bussinessId);
                        DynamicObject relpersonDyn2 = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                        if (relpersonDyn2 == null) continue;
                        Long personPkId = relPersonIds[relPersonPkIdSize--];
                        relpersonDyn2.set("id", (Object)personPkId);
                        salaryAdjRecord.set("relpersonid", (Object)personPkId);
                        relPersonDys.add(relpersonDyn2);
                    }
                    List<DynamicObject> curItemDyByAsc = this.adjFileDomainService.getSortedBsedByAsc(salaryAdjRecords.toArray(new DynamicObject[0]));
                    dataSource = this.dealDecideVersion(curItemDyByAsc, oldItemMap, needSaveList, needNewHisList, dataSource, minBsedDyMap);
                }
            }
            if (CollectionUtils.isNotEmpty(adjList = groupByType.get(AdjAttributionType.ADJATTRTYPE))) {
                int relPersonPkIdSize = this.getRelPersonPkIdSize(adjList);
                long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(relPersonPkIdSize);
                --relPersonPkIdSize;
                for (int i = 0; i < adjList.size(); ++i) {
                    DecAdjSalaryEntity adjSalaryEntity = adjList.get(i);
                    Long salaryadjfileId = adjSalaryEntity.getSalaryadjfileId();
                    salaryAdjRecordRelPersonDynEntities = adjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
                    if (salaryAdjRecordRelPersonDynEntities == null) continue;
                    for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                        relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                        Long personPkId = relPersonIds[relPersonPkIdSize--];
                        if (relpersonDyn != null) {
                            relpersonDyn.set("id", (Object)personPkId);
                            relPersonDys.add(relpersonDyn);
                        }
                        salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                        salaryAdjRecord.set("status", (Object)"C");
                        salaryAdjRecord.set("enable", (Object)"1");
                        salaryAdjRecord.set("relpersonid", (Object)personPkId);
                        Long standarditemId = salaryAdjRecord.getLong("standarditem.id");
                        DynamicObject oldItemDyn = (DynamicObject)oldDataTable.get((Object)salaryadjfileId, (Object)standarditemId);
                        if (null == oldItemDyn) {
                            AdjFileApplicationService.completeHisVersion(needSaveList, needNewHisList, salaryAdjRecord);
                        } else {
                            salaryAdjRecord.set("boid", (Object)oldItemDyn.getLong("boid"));
                            needNewHisList.add(salaryAdjRecord);
                            this.completeVersionWhenRevisionAddNew(needNewHisList, minBsedDyMap, salaryAdjRecord, oldItemDyn);
                        }
                        if (dataSource != null) continue;
                        dataSource = salaryAdjRecord.getString("datasource");
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(eventDynList)) {
            ((DynamicObject)eventDynList.get(0)).set("eventtype", dataSource);
            this.adjFileDomainService.saveDecAdjEvent(eventDynList);
        }
        this.adjFileDomainService.saveRelPerson(relPersonDys);
        if (CollectionUtils.isNotEmpty(needSaveList)) {
            logger.info("saveTimeVersionForRevisionAddNew needSaveList size is {}", (Object)needSaveList.size());
            OperationResult operationResult = this.adjFileDomainService.saveItemDataByOperate(needSaveList, eventPkId);
            boolean success = operationResult.isSuccess();
            logger.info("saveTimeVersionForRevisionAddNew saveop isSuccess:{}", (Object)success);
            if (!success) {
                String msg = operationResult.getMessage();
                logger.info("saveTimeVersionForRevisionAddNew saveop false msg is {}", (Object)msg);
                List operateInfos = operationResult.getAllErrorOrValidateInfo();
                HashSet<String> errMsg = new HashSet<String>(16);
                for (IOperateInfo operateInfo : operateInfos) {
                    errMsg.add(operateInfo.getMessage());
                }
                logger.info("saveTimeVersionForRevisionAddNew saveop getAllErrorOrValidateInfo msg is {}", (Object)SerializationUtils.toJsonString(errMsg));
            }
        }
        if (!needNewHisList.isEmpty()) {
            for (int i = 0; i < needNewHisList.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)needNewHisList.get(i);
                logger.info("saveTimeVersionForRevisionAddNew needNewHisList param: size is {}, needNewHisList{}: bsed is{}, bsled is {}, enable is {},fileid is {}", new Object[]{needNewHisList.size(), i, dynamicObject.getDate("bsed"), dynamicObject.getDate("bsled"), dynamicObject.get("enable"), dynamicObject.get("salaryadjfile.id")});
            }
            BaseDataHisHelper.saveTimeVersion((DynamicObject[])needNewHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
        }
        logger.info("saveTimeVersionForRevisionAddNew begain generateSyncDataFromRec");
        ArrayList record = Lists.newArrayListWithExpectedSize((int)(needSaveList.size() + needNewHisList.size()));
        record.addAll(needSaveList);
        record.addAll(needNewHisList);
        SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, record, relPersonDys);
    }

    private Map<String, DynamicObject> getMinBsedDyMap(Set<Long> adjFileBoIdSets) {
        DynamicObject[] allRecordDys = this.adjFileDomainService.queryAllVersionDecideAdjSalaryObjsByFileBoId(adjFileBoIdSets);
        Map<Long, Map<Long, List<DynamicObject>>> sortedMap = Arrays.stream(allRecordDys).sorted(Comparator.comparing(dy -> dy.getDate("bsed"))).collect(Collectors.groupingBy(dy -> dy.getLong("salaryadjfile.id"), Collectors.groupingBy(dy -> dy.getLong("standarditem.id"))));
        HashMap minBsedDyMap = Maps.newHashMapWithExpectedSize((int)allRecordDys.length);
        for (Map.Entry<Long, Map<Long, List<DynamicObject>>> outerEntry : sortedMap.entrySet()) {
            Long salaryAdjFileId = outerEntry.getKey();
            Map<Long, List<DynamicObject>> itemIdToRecordDyMap = outerEntry.getValue();
            for (Map.Entry<Long, List<DynamicObject>> innerEntry : itemIdToRecordDyMap.entrySet()) {
                Long standardItemId = innerEntry.getKey();
                List<DynamicObject> sortedRecordDyList = innerEntry.getValue();
                boolean hasEnableVersion = true;
                for (DynamicObject dynamicObject : sortedRecordDyList) {
                    String enable = dynamicObject.getString("enable");
                    String dataStatus = dynamicObject.getString("datastatus");
                    if ("0".equals(enable) || "1".equals(enable) && "-4".equals(dataStatus)) {
                        hasEnableVersion = false;
                        continue;
                    }
                    if (!"1".equals(enable) || !"2".equals(dataStatus) && !"1".equals(dataStatus) && !"0".equals(dataStatus)) continue;
                    hasEnableVersion = true;
                    break;
                }
                if (hasEnableVersion) continue;
                String combineKey = String.valueOf(salaryAdjFileId) + "-" + String.valueOf(standardItemId);
                minBsedDyMap.put(combineKey, sortedRecordDyList.get(0));
            }
        }
        return minBsedDyMap;
    }

    private static void completeHisVersion(List<DynamicObject> needSaveList, List<DynamicObject> needNewHisList, DynamicObject decAdjSalDyn) {
        Date bsled = decAdjSalDyn.getDate("bsled");
        if (bsled != null && bsled.compareTo(SWCDateTimeUtils.getMaxBsled()) < 0) {
            long newBoid = DB.genLongId((String)"T_HCDM_SALARYADJRECORD");
            DynamicObject addNewRecordData = (DynamicObject)cloneUtils.clone((IDataEntityBase)decAdjSalDyn);
            addNewRecordData.set("bsled", (Object)SWCDateTimeUtils.getMaxBsled());
            addNewRecordData.set("boid", (Object)newBoid);
            addNewRecordData.set("id", (Object)newBoid);
            needSaveList.add(addNewRecordData);
            decAdjSalDyn.set("bsed", (Object)SWCDateTimeUtils.addDay((Date)bsled, (long)1L));
            decAdjSalDyn.set("bsled", (Object)SWCDateTimeUtils.getMaxBsled());
            decAdjSalDyn.set("enable", (Object)"0");
            decAdjSalDyn.set("boid", (Object)newBoid);
            needNewHisList.add(decAdjSalDyn);
        } else if (bsled == null || bsled.compareTo(SWCDateTimeUtils.getMaxBsled()) == 0) {
            needSaveList.add(decAdjSalDyn);
        }
    }

    private int getRelPersonPkIdSize(List<DecAdjSalaryEntity> paramsList) {
        int relPersonPkIdSize = 0;
        for (DecAdjSalaryEntity decAdjSalaryEntity : paramsList) {
            List salaryAdjRecordRelPersonDynEntities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
            if (salaryAdjRecordRelPersonDynEntities == null) continue;
            for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                DynamicObject relpersonDyn = salaryAdjRecordRelPersonDynEntity.getRelpersonDyn();
                if (relpersonDyn == null) continue;
                ++relPersonPkIdSize;
            }
        }
        return relPersonPkIdSize;
    }

    public String beginEvent(String type) {
        return this.adjFileDomainService.beginEvent(type);
    }

    public void endEvent(Collection<String> event) {
        this.adjFileDomainService.endEvent(event);
        SWCThreadPoolFactory.getAsyncPushThreadpool().execute(() -> {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_salaryadjevent");
            QFilter[] filters = new QFilter[]{new QFilter("event", "in", (Object)event)};
            for (int i = 0; i < 100; ++i) {
                DynamicObject matchobj;
                Object[] eventDys = serviceHelper.query("eventstatus", filters);
                if (ArrayUtils.isNotEmpty((Object[])eventDys) && (matchobj = (DynamicObject)Arrays.stream(eventDys).filter(obj -> !"1".equals(obj.getString("eventstatus"))).findFirst().orElse(null)) == null) {
                    SalaryAdjSyncFacade.triggerPushSyncData(event);
                    return;
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            logger.warn("SalaryAdjSyncFacade.triggerPushSyncData skiped for data not ready");
        });
    }

    public Long genEventDyn(String event, List<DynamicObject> eventDynList, String eventType, String needRepush) {
        DynamicObject decideAdjEvent = this.adjFileDomainService.generateEmptyDecideAdjEvent();
        long[] eventPkIds = this.adjFileDomainService.genEventPkId(1);
        Long eventPkId = eventPkIds[0];
        decideAdjEvent.set("id", (Object)eventPkId);
        decideAdjEvent.set("event", (Object)event);
        decideAdjEvent.set("eventtype", (Object)eventType);
        decideAdjEvent.set("eventdate", (Object)new Date());
        decideAdjEvent.set("eventstatus", (Object)"0");
        decideAdjEvent.set("needrepush", (Object)(needRepush == null ? "0" : needRepush));
        eventDynList.add(decideAdjEvent);
        return eventPkId;
    }

    private String dealDecideVersion(List<DynamicObject> curItemDyByAsc, Map<Long, DynamicObject> oldItemMap, List<DynamicObject> needSaveList, List<DynamicObject> newHisList, String dataSource, Map<String, DynamicObject> minBesdDyMap) {
        Date minBsed = curItemDyByAsc.get(0).getDate("bsed");
        for (int i = 0; i < curItemDyByAsc.size(); ++i) {
            DynamicObject curItemObj = curItemDyByAsc.get(i);
            Date bsed = curItemObj.getDate("bsed");
            Long itemId = curItemObj.getLong("standarditem.id");
            DynamicObject oldItemDyObj = oldItemMap.get(itemId);
            if (dataSource == null) {
                dataSource = curItemObj.getString("datasource");
            }
            if (null == oldItemDyObj) {
                AdjFileApplicationService.completeHisVersion(needSaveList, newHisList, curItemObj);
                continue;
            }
            if (SWCDateTimeUtils.getDayDate((Date)minBsed).compareTo(SWCDateTimeUtils.getDayDate((Date)bsed)) == 0) {
                DynamicObject hisDyn = this.genEnableVersion(oldItemDyObj, curItemObj);
                newHisList.add(hisDyn);
                this.completeVersionWhenRevisionAddNew(newHisList, minBesdDyMap, curItemObj, oldItemDyObj);
                continue;
            }
            DynamicObject disableHisDyn = this.genDisableVersion(minBsed, SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)bsed, (long)-1L)), oldItemDyObj);
            DynamicObject hisDyn = this.genEnableVersion(oldItemDyObj, curItemObj);
            newHisList.add(disableHisDyn);
            newHisList.add(hisDyn);
        }
        Set curItemIdSet = curItemDyByAsc.stream().map(object -> object.getLong("standarditem.id")).collect(Collectors.toSet());
        Collection<DynamicObject> oldItemDys = oldItemMap.values();
        ArrayList<DynamicObject> oldWithOutCurItemDys = new ArrayList<DynamicObject>(10);
        for (DynamicObject oldItem : oldItemDys) {
            Long oldItemId = oldItem.getLong("standarditem.id");
            if (curItemIdSet.contains(oldItemId)) continue;
            oldWithOutCurItemDys.add(oldItem);
        }
        if (CollectionUtils.isNotEmpty(oldWithOutCurItemDys)) {
            Date defaultMaxDate = AdjFileApplicationService.getDefaultMaxDate();
            for (DynamicObject oldItemDyObj : oldWithOutCurItemDys) {
                DynamicObject newHisDyn = this.genDisableVersion(minBsed, defaultMaxDate, oldItemDyObj);
                newHisList.add(newHisDyn);
            }
        }
        return dataSource;
    }

    private void completeVersionWhenRevisionAddNew(List<DynamicObject> newHisList, Map<String, DynamicObject> minBsedDyMap, DynamicObject curItemObj, DynamicObject oldItemDyObj) {
        String combineKey;
        DynamicObject minDisAbleRecordDy;
        long salaryAdjFileBoId = curItemObj.getLong("salaryadjfile.id");
        long standardItemId = curItemObj.getLong("standarditem.id");
        if (minBsedDyMap != null && (minDisAbleRecordDy = minBsedDyMap.get(combineKey = String.valueOf(salaryAdjFileBoId) + "-" + String.valueOf(standardItemId))) != null) {
            Date currentBsled = curItemObj.getDate("bsled");
            Date recordMinBsed = minDisAbleRecordDy.getDate("bsed");
            if (currentBsled != null && currentBsled.compareTo(SWCDateTimeUtils.addDay((Date)recordMinBsed, (long)-1L)) < 0) {
                DynamicObject disableHisDyn = this.genDisableVersion(SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)currentBsled, (long)1L)), SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)recordMinBsed, (long)-1L)), oldItemDyObj);
                newHisList.add(disableHisDyn);
            }
        }
    }

    private DynamicObject genDisableVersion(Date minBsed, Date bsled, DynamicObject oldItemDyObj) {
        DynamicObject disableHisDyn = this.adjFileDomainService.generateEmptyDecideAdjSalary();
        HashSet<String> ignoreField = new HashSet<String>(16);
        ignoreField.add("iscurrentversion");
        ignoreField.add("id");
        SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)oldItemDyObj, (DynamicObject)disableHisDyn, ignoreField, null);
        disableHisDyn.set("bsed", (Object)minBsed);
        disableHisDyn.set("bsled", (Object)bsled);
        disableHisDyn.set("enable", (Object)"0");
        disableHisDyn.set("boid", (Object)oldItemDyObj.getLong("boid"));
        return disableHisDyn;
    }

    private DynamicObject genEnableVersion(DynamicObject curItemDyObj) {
        DynamicObject hisDyn = this.adjFileDomainService.generateEmptyDecideAdjSalary();
        HashSet<String> ignoreField = new HashSet<String>(16);
        ignoreField.add("id");
        ignoreField.add("iscurrentversion");
        SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)curItemDyObj, (DynamicObject)hisDyn, ignoreField, null);
        hisDyn.set("status", (Object)"C");
        hisDyn.set("enable", (Object)"1");
        return hisDyn;
    }

    private DynamicObject genEnableVersion(DynamicObject oldItemDyObj, DynamicObject curItemDyObj) {
        DynamicObject hisDyn = this.adjFileDomainService.generateEmptyDecideAdjSalary();
        HashSet<String> ignoreField = new HashSet<String>(16);
        ignoreField.add("id");
        ignoreField.add("iscurrentversion");
        SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)oldItemDyObj, (DynamicObject)hisDyn, ignoreField, null);
        SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)curItemDyObj, (DynamicObject)hisDyn, ignoreField, null);
        hisDyn.set("status", (Object)"C");
        hisDyn.set("enable", (Object)"1");
        hisDyn.set("boid", (Object)oldItemDyObj.getLong("boid"));
        return hisDyn;
    }

    public Map<Long, Map<Long, DynamicObject>> getLatestDecAdjSalary(Map<Long, Set<Long>> fileItemIdMap) {
        return this.adjFileDomainService.getLatestDecAdjSalary(fileItemIdMap, true);
    }

    public Map<Long, Map<Long, DynamicObject>> getLatestDecAdjSalary(String selProps, Map<Long, Set<Long>> fileItemIdMap) {
        return this.adjFileDomainService.getLatestDecAdjSalary(selProps, fileItemIdMap, true);
    }

    public Map<Long, Map<Long, DynamicObject>> getLatestDecAdjSalaryByBsed(Map<Long, Map<Long, Pair<Long, Date>>> fileItemRecordIdBsedMap, String type) {
        return this.adjFileDomainService.getLatestDecAdjSalaryByBsed(fileItemRecordIdBsedMap, type);
    }

    public Map<String, List<DynamicObject>> getInfluencedHisDataByFileBoidAndItemId(List<DynamicObject> dynamicObjects) {
        return this.adjFileDomainService.getInfluencedHisDataByFileBoidAndItemId(dynamicObjects);
    }

    @Deprecated
    public Map<Long, AdjFileMaxDateEntity> getMaxBsedOfFileForDecBill(Collection<Long> fileBOIds) {
        Map<Long, DynamicObject> fileMap = this.queryFileBizInfo("id,bsed,bsled,datastatus,enable", fileBOIds);
        Map<Long, DynamicObject> maxDisableDy = this.getMaxDisableDate("hcdm_adjfileinfo", fileBOIds);
        Map<Long, Date> maxBsedOfFileMap = this.adjFileDomainService.getMaxBsedOfFile(fileBOIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileBOIds.size());
        for (Long fileBOId : fileBOIds) {
            DynamicObject maxDisableDyn = maxDisableDy.get(fileBOId);
            Date date = maxBsedOfFileMap.get(fileBOId);
            if (null == maxDisableDyn) {
                AdjFileMaxDateEntity entity = new AdjFileMaxDateEntity(date, SalaryAdjFilePartEnum.salaryadjrecord);
                resultMap.put(fileBOId, entity);
                continue;
            }
            Date maxDisableBsled = maxDisableDyn.getDate("bsled");
            if (!SWCDateTimeUtils.dayEquals((Date)SWCBaseUtils.getMaxLoseEffectDate(), (Date)maxDisableBsled)) {
                Date fileEnableBsed = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)maxDisableBsled, (long)1L));
                AdjFileMaxDateEntity entity = null;
                entity = SWCDateTimeUtils.dayAfter((Date)date, (Date)fileEnableBsed) ? new AdjFileMaxDateEntity(date, SalaryAdjFilePartEnum.salaryadjrecord) : new AdjFileMaxDateEntity(fileEnableBsed, SalaryAdjFilePartEnum.baseInfo);
                resultMap.put(fileBOId, entity);
                continue;
            }
            DynamicObject fileBODyn = fileMap.get(fileBOId);
            Date bsed = fileBODyn.getDate("bsed");
            String dataStatus = fileBODyn.getString("datastatus");
            if (!SWCStringUtils.equals((String)"0", (String)dataStatus)) continue;
            AdjFileMaxDateEntity entity = null;
            entity = SWCDateTimeUtils.dayAfter((Date)date, (Date)bsed) ? new AdjFileMaxDateEntity(date, SalaryAdjFilePartEnum.salaryadjrecord) : new AdjFileMaxDateEntity(bsed, SalaryAdjFilePartEnum.baseInfo);
            resultMap.put(fileBOId, entity);
        }
        return resultMap;
    }

    public Map<Long, List<DynamicObject>> getCurDateItemVersion(Collection<Long> fileIds, Object isHistoryPage, Long itemId) {
        return this.adjFileDomainService.getCurDateItemVersion(fileIds, isHistoryPage, itemId);
    }

    public List<Map<Date, List<DynamicObject>>> getAllDateVersion(Long filId, boolean isShowLogicdelete, Object isHistoryPage) {
        return this.adjFileDomainService.getAllDateVersion(filId, isShowLogicdelete, isHistoryPage);
    }

    public Map<Long, DynamicObject> queryFileBizInfo(String fields, Collection<Long> adjFileIds) {
        return this.adjFileDomainService.queryFileBizInfo(adjFileIds, fields);
    }

    public Map<Long, List<DynamicObject>> getDecideAdjSalaryObj(Collection<Long> fileKeySet, boolean withCurrentVersion) {
        DynamicObject[] decideAdjSalaryObj = this.adjFileDomainService.queryDecAdjReocrdByFileBOIds(fileKeySet, withCurrentVersion);
        return Arrays.stream(decideAdjSalaryObj).collect(Collectors.groupingBy(object -> object.getLong("salaryadjfile.id")));
    }

    public Set<Long> getAllItemBOId(Collection<Long> fileIds) {
        DynamicObject[] decideAdjSalaryObjs = this.adjFileDomainService.queryDecideAdjSalaryObj(fileIds, true);
        HashSet<Long> itemBOIds = new HashSet<Long>(16);
        if (null != decideAdjSalaryObjs && decideAdjSalaryObjs.length > 0) {
            for (DynamicObject itemObj : decideAdjSalaryObjs) {
                itemBOIds.add(itemObj.getLong("boid"));
            }
        }
        return itemBOIds;
    }

    public DynamicObjectCollection queryDecideSalaryByEmployeeId(Long employeeId, Long itemId) {
        DynamicObjectCollection adjFileCol = this.adjFileDomainService.queryAdjFileColByEmployeeId("boid", employeeId);
        if (adjFileCol.isEmpty()) {
            return new DynamicObjectCollection();
        }
        HashMap fileItemIdMap = Maps.newHashMapWithExpectedSize((int)adjFileCol.size());
        adjFileCol.forEach(file -> {
            Set cfr_ignored_0 = fileItemIdMap.put(file.getLong("boid"), Sets.newHashSet((Object[])new Long[]{itemId}));
        });
        Map<Long, Map<Long, DynamicObject>> map = this.adjFileDomainService.getLatestDecAdjSalary(fileItemIdMap, false);
        DynamicObjectCollection itemCol = new DynamicObjectCollection();
        map.forEach((fileId, itemMap) -> itemMap.forEach((item, data) -> itemCol.add(data)));
        return itemCol;
    }

    public Set<Long> getSalaryStdVidByFileId(Long fileId) {
        DynamicObject[] decAdjSalaryObjs = this.adjFileDomainService.queryDecideAdjSalaryObj(Sets.newHashSet((Object[])new Long[]{fileId}), true);
        if (null == decAdjSalaryObjs || decAdjSalaryObjs.length <= 0) {
            return new HashSet<Long>();
        }
        return Arrays.stream(decAdjSalaryObjs).map(object -> object.getLong("salarystd.id")).collect(Collectors.toSet());
    }

    @Deprecated
    public Map<Long, Map<Long, AdjFileMaxDateEntity>> getMaxBsedOfFileForAdjBill(Map<Long, Set<Long>> fileItemIdMap) {
        Set<Long> fileBOIds = fileItemIdMap.keySet();
        Map<Long, DynamicObject> fileMap = this.queryFileBizInfo("id,bsed,bsled,datastatus,enable", fileBOIds);
        Map<Long, DynamicObject> maxDisableDy = this.getMaxDisableDate("hcdm_adjfileinfo", fileBOIds);
        Map<Long, Map<Long, DynamicObject>> latestDecAdjSalaryMap = this.adjFileDomainService.getLatestDecAdjSalary("id,standarditem.id,datastatus,enable,bsed,salaryadjfile.id", fileItemIdMap, true);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileBOIds.size());
        for (Map.Entry<Long, Set<Long>> entry : fileItemIdMap.entrySet()) {
            Long fileBOId = entry.getKey();
            Map<Long, DynamicObject> itemDyObjMap = latestDecAdjSalaryMap.get(fileBOId);
            Map subMapOfCurMap = resultMap.computeIfAbsent(fileBOId, aLong -> Maps.newHashMap());
            if (null == itemDyObjMap) continue;
            DynamicObject maxDisableDyn = maxDisableDy.get(fileBOId);
            Set<Long> itemIds = entry.getValue();
            for (Long itemId : itemIds) {
                DynamicObject itemDyn = itemDyObjMap.get(itemId);
                if (null == maxDisableDyn) {
                    if (null == itemDyn) {
                        subMapOfCurMap.put(itemId, new AdjFileMaxDateEntity(SWCBaseUtils.getMinEffectDate(), SalaryAdjFilePartEnum.salaryadjrecord));
                        continue;
                    }
                    subMapOfCurMap.put(itemId, new AdjFileMaxDateEntity(itemDyn.getDate("bsed"), SalaryAdjFilePartEnum.salaryadjrecord));
                    continue;
                }
                Date maxDisableBsled = maxDisableDyn.getDate("bsled");
                if (!SWCDateTimeUtils.dayEquals((Date)SWCBaseUtils.getMaxLoseEffectDate(), (Date)maxDisableBsled)) {
                    Date fileEnableBsed = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)maxDisableBsled, (long)1L));
                    if (null == itemDyn) {
                        subMapOfCurMap.put(itemId, new AdjFileMaxDateEntity(fileEnableBsed, SalaryAdjFilePartEnum.baseInfo));
                        continue;
                    }
                    AdjFileMaxDateEntity entity = null;
                    Date itemBsedDate = itemDyn.getDate("bsed");
                    entity = SWCDateTimeUtils.dayAfter((Date)itemBsedDate, (Date)fileEnableBsed) ? new AdjFileMaxDateEntity(itemBsedDate, SalaryAdjFilePartEnum.salaryadjrecord) : new AdjFileMaxDateEntity(fileEnableBsed, SalaryAdjFilePartEnum.baseInfo);
                    subMapOfCurMap.put(itemId, entity);
                    continue;
                }
                DynamicObject fileBODyn = fileMap.get(fileBOId);
                Date fileBsed = fileBODyn.getDate("bsed");
                String dataStatus = fileBODyn.getString("datastatus");
                if (!SWCStringUtils.equals((String)"0", (String)dataStatus)) continue;
                if (null == itemDyn) {
                    subMapOfCurMap.put(itemId, new AdjFileMaxDateEntity(fileBsed, SalaryAdjFilePartEnum.baseInfo));
                    continue;
                }
                AdjFileMaxDateEntity entity = null;
                Date itemBsedDate = itemDyn.getDate("bsed");
                entity = SWCDateTimeUtils.dayAfter((Date)itemBsedDate, (Date)fileBsed) ? new AdjFileMaxDateEntity(itemBsedDate, SalaryAdjFilePartEnum.salaryadjrecord) : new AdjFileMaxDateEntity(fileBsed, SalaryAdjFilePartEnum.baseInfo);
                subMapOfCurMap.put(itemId, entity);
            }
        }
        return resultMap;
    }

    public String saveTimeVersionForInit(Long initbatchId) throws InterruptedException {
        QFilter qFilter = new QFilter("initbatch", "=", (Object)initbatchId);
        qFilter.and(new QFilter("salaryadjfile.id", "!=", (Object)0));
        qFilter.and("status", "=", (Object)"A");
        qFilter.and("datastatus", "in", (Object)CommonHcdmBizHelper.VALIDATE_DATA_STATUS);
        DynamicObject[] hasAdjFileRecordDatas = this.adjFileDomainService.queryDecAdjRecordByInitbatchId("id,salaryadjfile.id", qFilter);
        logger.info("hasAdjFileRecordDatas size is:{}", (Object)hasAdjFileRecordDatas.length);
        List<Set<Long>> hasAdjFileBatchList = this.getBatchLists(hasAdjFileRecordDatas, "salaryadjfile.id");
        List<List<Long>> idBatchList = this.getBatchLists2(hasAdjFileRecordDatas);
        logger.info("hasAdjFileBatchList is {}", (Object)SerializationUtils.toJsonString(hasAdjFileBatchList));
        String sql1 = "select e.fid as id, e.fstandarditemid as itemid, e.fsalaryadjfileid as fileid, t.fempnumber as fempnumber, t.forgid as forgid, t.fcountryid as fcountryid, t.fstdscmvid as fstdscmvid, s.fboid as fstdscmid from t_hcdm_salaryadjrecord e left join t_hcdm_decadjrelperson t on e.frelpersonid = t.fid left join t_hcdm_stdscm s on t.fstdscmvid = s.fid where e.fsalaryadjfileid = ? and e.finitbatchid = ? and e.fstatus= ? and e.fdatastatus in (?,?,?,?,?)";
        ArrayList sqlParams = Lists.newArrayList((Object[])new Object[]{0, initbatchId, "A", "-3", "0", "1", "2", " "});
        HashMap stdScmVidToBOMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList noAdjFileBatchList = Lists.newArrayListWithExpectedSize((int)1000);
        Set batchSet = null;
        HashMap keyStringRecordPkIdsMap = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet queryDataSet = HCDMDbHelper.queryDataSet(sql1, sqlParams.toArray());){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                Long pkid = row.getLong("id");
                Long itemid = row.getLong("itemid");
                String empnumber = row.getString("fempnumber");
                Long orgid = row.getLong("forgid");
                Long countryid = row.getLong("fcountryid");
                Long stdscmVId = row.getLong("fstdscmvid");
                Long stdscmBoId = row.getLong("fstdscmid");
                stdScmVidToBOMap.put(stdscmVId, stdscmBoId);
                String combinesKey = this.adjFileDomainService.generateKey(String.valueOf(itemid), empnumber, String.valueOf(orgid), String.valueOf(countryid), String.valueOf(stdscmBoId));
                Set recordPkIdSet = keyStringRecordPkIdsMap.computeIfAbsent(combinesKey, val -> Sets.newHashSet());
                recordPkIdSet.add(pkid);
                if (batchSet == null) {
                    batchSet = Sets.newHashSetWithExpectedSize((int)1000);
                }
                batchSet.add(combinesKey);
                if (batchSet.size() != 1000) continue;
                noAdjFileBatchList.add(batchSet);
                batchSet = Sets.newHashSetWithExpectedSize((int)1000);
            }
            if (batchSet != null && batchSet.size() > 0) {
                noAdjFileBatchList.add(batchSet);
            }
        }
        catch (Exception exc) {
            logger.error("error in query ", (Throwable)exc);
        }
        String event = String.valueOf(initbatchId);
        DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(event);
        Long eventPkId = 0L;
        ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
        eventPkId = null == eventDyn ? this.genEventDyn(event, eventDynList, EventTypeEnum.INIT.getCode(), null) : Long.valueOf(eventDyn.getLong("id"));
        if (CollectionUtils.isNotEmpty(eventDynList)) {
            try (TXHandle required = TX.requiresNew();){
                this.adjFileDomainService.saveDecAdjEvent(eventDynList);
                required.commit();
            }
        }
        SWCMultithreadedQueryService service = SWCMultithreadedQueryService.getInstance();
        for (List<Long> recordIds : idBatchList) {
            QFilter fileIdFilter = new QFilter("id", "in", recordIds);
            DynamicObject[] allFieldRecordDyObjsWithFileId = service.getData("hcdm_salaryadjrecord", this.adjFileDomainService.getRecordSelectProperties(), new QFilter[]{fileIdFilter}, "", 1000);
            logger.info("allFieldRecordDyObjsWithFileId size is:{}", (Object)allFieldRecordDyObjsWithFileId.length);
            this.handleHasAdjFileBatchData(eventPkId, recordIds, allFieldRecordDyObjsWithFileId);
        }
        for (Set keyStringSet : noAdjFileBatchList) {
            HashSet recordPkIdSet = Sets.newHashSetWithExpectedSize((int)keyStringSet.size());
            for (String keyString : keyStringSet) {
                recordPkIdSet.addAll((Collection)keyStringRecordPkIdsMap.get(keyString));
            }
            logger.info("recordPkIdSet size is{}, params is {}", (Object)recordPkIdSet.size(), (Object)SerializationUtils.toJsonString((Object)recordPkIdSet));
            QFilter pkidFilter = new QFilter("id", "in", (Object)recordPkIdSet);
            DynamicObject[] noFileBatchDyObjs = service.getData("hcdm_salaryadjrecord", this.adjFileDomainService.getRecordSelectProperties(), new QFilter[]{pkidFilter}, "", 1000);
            logger.info("noFileBatchDyObjs size is:{}", (Object)noFileBatchDyObjs.length);
            this.handleNoAdjFileOneBatch(eventPkId, recordPkIdSet, noFileBatchDyObjs, stdScmVidToBOMap);
        }
        return event;
    }

    private void handleNoAdjFileOneBatch(Long eventPkId, Set<Long> recordPkIdSet, DynamicObject[] noFileBatchDyObjs, Map<Long, Long> stdScmVidToBOMap) {
        Set<Long> relpersonIds = Arrays.stream(noFileBatchDyObjs).filter(dynamicObject -> dynamicObject.getLong("relpersonid") != 0L).map(object -> object.getLong("relpersonid")).collect(Collectors.toSet());
        DynamicObject[] relPersonDyObjs = this.adjFileDomainService.queryRelPersonDyObjs("id,country.id,org.id,stdscm.id,empnumber", relpersonIds);
        Map relPersonDyObjMap = Arrays.stream(relPersonDyObjs).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
        HashMap<String, Map> keyFiledToItemMap = new HashMap<String, Map>(16);
        List<DynamicObject> curItemDyByAsc = this.adjFileDomainService.getSortedBsedByAsc(noFileBatchDyObjs);
        HashSet empNumbers = Sets.newHashSetWithExpectedSize((int)10);
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)10);
        HashSet countryIds = Sets.newHashSetWithExpectedSize((int)10);
        HashSet stdScmVids = Sets.newHashSetWithExpectedSize((int)10);
        HashSet itemIds = Sets.newHashSetWithExpectedSize((int)10);
        for (DynamicObject recordDy : curItemDyByAsc) {
            recordDy.set("initstatus", (Object)"2");
            recordDy.set("status", (Object)"C");
            recordDy.set("enable", (Object)"1");
            recordDy.set("iscurrentversion", (Object)"1");
            recordDy.set("id", null);
            long standardItemId = recordDy.getLong("standarditem.id");
            long relpersonId = recordDy.getLong("relpersonid");
            DynamicObject relPersonDyObj = (DynamicObject)relPersonDyObjMap.get(relpersonId);
            if (null == relPersonDyObj) continue;
            String empNumber = relPersonDyObj.getString("empnumber");
            long orgId = relPersonDyObj.getLong("org.id");
            long countryId = relPersonDyObj.getLong("country.id");
            long stdScmVid = relPersonDyObj.getLong("stdscm.id");
            Long stdScmBOId = stdScmVidToBOMap.get(stdScmVid);
            empNumbers.add(empNumber);
            orgIds.add(orgId);
            countryIds.add(countryId);
            stdScmVids.add(stdScmVid);
            stdScmVids.add(stdScmBOId);
            itemIds.add(standardItemId);
            String keyField = this.adjFileDomainService.generateKey(empNumber, String.valueOf(orgId), String.valueOf(countryId), String.valueOf(stdScmBOId), String.valueOf(standardItemId));
            Map itemMap = keyFiledToItemMap.computeIfAbsent(keyField, val -> Maps.newHashMap());
            List recordList = itemMap.computeIfAbsent(standardItemId, val -> Lists.newArrayList());
            recordList.add(recordDy);
        }
        Map<String, List<DynamicObject>> oldDataMap = this.adjFileDomainService.getAllDecAdjSalaryEffectVersion(empNumbers, orgIds, countryIds, stdScmVids, itemIds, stdScmVidToBOMap);
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needNewHisList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newHisList = new ArrayList<DynamicObject>(10);
        for (Map.Entry entry : keyFiledToItemMap.entrySet()) {
            Map itemIdMap = (Map)entry.getValue();
            String key = (String)entry.getKey();
            List<DynamicObject> oldItemDys = oldDataMap.get(key);
            for (Map.Entry itemEntry : itemIdMap.entrySet()) {
                List curItemDyObjList = (List)itemEntry.getValue();
                if (oldItemDys != null && !oldItemDys.isEmpty()) {
                    List<Long> noLegalRecordIds = this.dealNeedAddVersionData(newHisList, curItemDyObjList, oldItemDys);
                    recordPkIdSet.removeAll(noLegalRecordIds);
                    continue;
                }
                this.dealNeedCreateBoData(needSaveList, needNewHisList, curItemDyObjList);
            }
        }
        ArrayList record = Lists.newArrayListWithExpectedSize((int)(needSaveList.size() + needNewHisList.size() + newHisList.size()));
        record.addAll(needSaveList);
        record.addAll(needNewHisList);
        record.addAll(newHisList);
        try (TXHandle required = TX.requiresNew();){
            OperationResult operationResult;
            if (CollectionUtils.isNotEmpty(needSaveList) && !(operationResult = this.adjFileDomainService.saveItemDataByOperate(needSaveList, eventPkId)).isSuccess()) {
                logger.error("save noadjfile op error is {}", (Object)operationResult.getMessage());
            }
            if (CollectionUtils.isNotEmpty(needNewHisList)) {
                BaseDataHisHelper.saveTimeVersion((DynamicObject[])needNewHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
            }
            if (CollectionUtils.isNotEmpty(newHisList)) {
                BaseDataHisHelper.saveTimeVersion((DynamicObject[])newHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
            }
            logger.info("begain deal noadjfile generateSyncDataFromRec");
            SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, record, Lists.newArrayList());
            QFilter idFilter = new QFilter("id", "in", recordPkIdSet);
            this.adjFileDomainService.deleteDecAdjInitDataByFilter(new QFilter[]{idFilter});
            required.commit();
        }
    }

    private void handleHasAdjFileBatchData(Long eventPkId, List<Long> recordIds, DynamicObject[] allFieldRecordDyObjsWithFileId) {
        List<DynamicObject> curItemDyByAsc = this.adjFileDomainService.getSortedBsedByAsc(allFieldRecordDyObjsWithFileId);
        HashMap<Long, Map> fileToItemMap = new HashMap<Long, Map>(16);
        HashMap<Long, Set<Long>> fileItemIdMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject recordDy : curItemDyByAsc) {
            recordDy.set("initstatus", (Object)"2");
            recordDy.set("status", (Object)"C");
            recordDy.set("enable", (Object)"1");
            recordDy.set("iscurrentversion", (Object)"1");
            recordDy.set("id", null);
            long fileId = recordDy.getLong("salaryadjfile.id");
            long standardItemId = recordDy.getLong("standarditem.id");
            Map itemMap = fileToItemMap.computeIfAbsent(fileId, val -> Maps.newHashMap());
            List recordList = itemMap.computeIfAbsent(standardItemId, val -> Lists.newArrayList());
            recordList.add(recordDy);
            Set itemIdSet = fileItemIdMap.computeIfAbsent(fileId, val -> Sets.newHashSet());
            itemIdSet.add(standardItemId);
        }
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needNewHisList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newHisList = new ArrayList<DynamicObject>(10);
        Table<Long, Long, List<DynamicObject>> oldDataTable = this.adjFileDomainService.getAllDecAdjSalaryEffectVersion(fileItemIdMap);
        for (Map.Entry entry : fileToItemMap.entrySet()) {
            Long fileBOId = (Long)entry.getKey();
            Map itemIdMap = (Map)entry.getValue();
            for (Map.Entry itemEntry : itemIdMap.entrySet()) {
                Long standardItemId = (Long)itemEntry.getKey();
                List curItemDyObjList = (List)itemEntry.getValue();
                List oldItemDys = (List)oldDataTable.get((Object)fileBOId, (Object)standardItemId);
                if (null != oldItemDys && oldItemDys.size() > 0) {
                    List<Long> noLegalRecordIds = this.dealNeedAddVersionData(newHisList, curItemDyObjList, oldItemDys);
                    recordIds.removeAll(noLegalRecordIds);
                    continue;
                }
                this.dealNeedCreateBoData(needSaveList, needNewHisList, curItemDyObjList);
            }
        }
        ArrayList record = Lists.newArrayListWithExpectedSize((int)(needSaveList.size() + needNewHisList.size() + newHisList.size()));
        record.addAll(needSaveList);
        record.addAll(needNewHisList);
        record.addAll(newHisList);
        try (TXHandle required = TX.requiresNew();){
            OperationResult operationResult;
            if (CollectionUtils.isNotEmpty(needSaveList) && !(operationResult = this.adjFileDomainService.saveItemDataByOperate(needSaveList, eventPkId)).isSuccess()) {
                logger.error("save op error is {}", (Object)operationResult.getMessage());
            }
            if (CollectionUtils.isNotEmpty(needNewHisList)) {
                BaseDataHisHelper.saveTimeVersion((DynamicObject[])needNewHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
            }
            if (CollectionUtils.isNotEmpty(newHisList)) {
                BaseDataHisHelper.saveTimeVersion((DynamicObject[])newHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
            }
            logger.info("begain generateSyncDataFromRec");
            SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, record, Lists.newArrayList());
            logger.info("end generateSyncDataFromRec");
            QFilter idFilter = new QFilter("id", "in", recordIds);
            this.adjFileDomainService.deleteDecAdjInitDataByFilter(new QFilter[]{idFilter});
            required.commit();
        }
    }

    private void dealNeedCreateBoData(List<DynamicObject> needSaveList, List<DynamicObject> needNewHisList, List<DynamicObject> curItemDyObjList) {
        if (curItemDyObjList.size() == 1) {
            Date defaultMaxDate = AdjFileApplicationService.getDefaultMaxDate();
            DynamicObject itemDyObj1 = curItemDyObjList.get(0);
            DynamicObject itemDyObj = this.genEnableVersion(itemDyObj1);
            Date bsed = itemDyObj.getDate("bsed");
            Date bsled = itemDyObj.getDate("bsled");
            long[] decAdjPkId = this.adjFileDomainService.getDecAdjPkId(1);
            itemDyObj.set("boid", (Object)decAdjPkId[0]);
            itemDyObj.set("id", (Object)decAdjPkId[0]);
            if (SWCDateTimeUtils.dayEquals((Date)bsled, (Date)defaultMaxDate)) {
                needSaveList.add(itemDyObj);
            } else {
                itemDyObj.set("bsled", (Object)defaultMaxDate);
                DynamicObject disableVersionObj = this.genDisableVersion(SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)bsled, (long)1L)), defaultMaxDate, itemDyObj);
                needSaveList.add(itemDyObj);
                needNewHisList.add(disableVersionObj);
            }
        } else {
            this.dealMoreThanOneItemDyns(needSaveList, needNewHisList, curItemDyObjList);
        }
    }

    private List<Long> dealNeedAddVersionData(List<DynamicObject> newHisList, List<DynamicObject> curItemDyObjList, List<DynamicObject> oldItemDys) {
        ArrayList<Long> noLegalRecordIds = new ArrayList<Long>(10);
        block0: for (DynamicObject curItemDy : curItemDyObjList) {
            DynamicObject itemDyObj = this.genEnableVersion(curItemDy);
            Date curBsed = itemDyObj.getDate("bsed");
            Date curBsled = itemDyObj.getDate("bsled");
            curBsed = SWCDateTimeUtils.getDayDate((Date)curBsed);
            curBsled = SWCDateTimeUtils.getDayDate((Date)curBsled);
            int oldItemDysSize = oldItemDys.size();
            for (int i = 0; i < oldItemDysSize; ++i) {
                DynamicObject oldItemDy = oldItemDys.get(i);
                Date oldBsed = oldItemDy.getDate("bsed");
                Date oldBsled = oldItemDy.getDate("bsled");
                long boId = oldItemDy.getLong("boid");
                itemDyObj.set("boid", (Object)boId);
                oldBsed = SWCDateTimeUtils.getDayDate((Date)oldBsed);
                oldBsled = SWCDateTimeUtils.getDayDate((Date)oldBsled);
                if (SWCDateTimeUtils.isDateRangeOverlap((Date)curBsed, (Date)curBsled, (Date)oldBsed, (Date)oldBsled)) {
                    noLegalRecordIds.add(curItemDy.getLong("id"));
                    logger.error("error in cut TimeVersion for: curData bsed {}, bsled {} ;oldData bsed {}, bsled {}", new Object[]{curBsed, curBsled, oldBsed, oldBsled});
                    continue block0;
                }
                if (curBsed.before(oldBsed)) {
                    DynamicObject preOldItemDy;
                    Date preBsed;
                    newHisList.add(itemDyObj);
                    Date nextBsled = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)oldBsed, (long)-1L));
                    if (curBsled.before(nextBsled)) {
                        Date nextBsed = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)curBsled, (long)1L));
                        DynamicObject disableVersion = this.genDisableVersion(nextBsed, nextBsled, itemDyObj);
                        newHisList.add(disableVersion);
                    }
                    if (i <= 0 || !curBsed.after(preBsed = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)(preOldItemDy = oldItemDys.get(i - 1)).getDate("bsled"), (long)1L)))) continue block0;
                    Date preBsled = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)curBsed, (long)-1L));
                    DynamicObject disableVersion = this.genDisableVersion(preBsed, preBsled, itemDyObj);
                    newHisList.add(disableVersion);
                    continue block0;
                }
                if (i != oldItemDysSize - 1) continue;
                newHisList.add(itemDyObj);
            }
        }
        return noLegalRecordIds;
    }

    private void dealMoreThanOneItemDyns(List<DynamicObject> needSaveList, List<DynamicObject> needNewHisList, List<DynamicObject> curItemDyObjList) {
        Date defaultMaxDate = AdjFileApplicationService.getDefaultMaxDate();
        Date tempBsled = null;
        long[] decAdjPkId = this.adjFileDomainService.getDecAdjPkId(1);
        long BOId = decAdjPkId[0];
        int itemVersionSize = curItemDyObjList.size();
        for (int i = 0; i < itemVersionSize; ++i) {
            int firstIndex = i;
            int secondIndex = i + 1;
            DynamicObject itemDyObj = curItemDyObjList.get(firstIndex);
            DynamicObject curDy = this.genEnableVersion(itemDyObj, itemDyObj);
            Date bsed = curDy.getDate("bsed");
            Date bsled = curDy.getDate("bsled");
            curDy.set("boid", (Object)BOId);
            if (i == 0) {
                tempBsled = bsled;
                curDy.set("bsled", (Object)defaultMaxDate);
                curDy.set("id", (Object)BOId);
                needSaveList.add(curDy);
                continue;
            }
            if (i == itemVersionSize - 1) {
                DynamicObject disableVersionObj;
                if (null == tempBsled) continue;
                if (SWCDateTimeUtils.dayEquals((Date)tempBsled, (Date)defaultMaxDate)) {
                    needNewHisList.add(curDy);
                    continue;
                }
                Date preBsledAddOne = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)tempBsled, (long)1L));
                if (!SWCDateTimeUtils.dayEquals((Date)preBsledAddOne, (Date)bsed)) {
                    disableVersionObj = this.genDisableVersion(preBsledAddOne, SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)bsed, (long)-1L)), curDy);
                    needNewHisList.add(disableVersionObj);
                }
                needNewHisList.add(curDy);
                if (SWCDateTimeUtils.dayEquals((Date)bsled, (Date)defaultMaxDate)) continue;
                disableVersionObj = this.genDisableVersion(SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)bsled, (long)1L)), defaultMaxDate, curDy);
                needNewHisList.add(disableVersionObj);
                continue;
            }
            if (null == tempBsled) continue;
            curDy.set("id", null);
            DynamicObject nextDy = curItemDyObjList.get(secondIndex);
            Date secondBsed = nextDy.getDate("bsed");
            if (SWCDateTimeUtils.dayEquals((Date)tempBsled, (Date)defaultMaxDate)) {
                tempBsled = bsled;
                curDy.set("bsled", (Object)SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)secondBsed, (long)-1L)));
                DynamicObject curDyObj = this.genEnableVersion(curDy, curDy);
                needNewHisList.add(curDyObj);
                continue;
            }
            Date preBsledAddOne = SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)tempBsled, (long)1L));
            if (!SWCDateTimeUtils.dayEquals((Date)preBsledAddOne, (Date)bsed)) {
                tempBsled = bsled;
                DynamicObject disableVersionObj = this.genDisableVersion(preBsledAddOne, SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)bsed, (long)-1L)), curDy);
                needNewHisList.add(disableVersionObj);
                if (SWCDateTimeUtils.dayEquals((Date)bsled, (Date)defaultMaxDate)) {
                    curDy.set("bsled", (Object)SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)secondBsed, (long)-1L)));
                }
                DynamicObject curDyObj = this.genEnableVersion(curDy, curDy);
                needNewHisList.add(curDyObj);
                continue;
            }
            tempBsled = bsled;
            if (SWCDateTimeUtils.dayEquals((Date)bsled, (Date)defaultMaxDate)) {
                curDy.set("bsled", (Object)SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)secondBsed, (long)-1L)));
            }
            DynamicObject curDyObj = this.genEnableVersion(curDy, curDy);
            needNewHisList.add(curDyObj);
        }
    }

    public Map<Long, DynamicObject> queryLatestEmpPosOrgRelByDepEmpId(Set<Long> depEmpIdSet) {
        return this.adjFileDomainService.queryLatestEmpPosOrgRelByDepEmpId(depEmpIdSet);
    }

    public Map<Long, DynamicObject> queryLatestFileByDepempId(String selectFields, Collection<Long> depempIds) {
        return this.adjFileDomainService.queryLatestAdjFileByDepempId(selectFields, depempIds);
    }

    @Deprecated
    public Map<Long, DynamicObject> queryAdjFileVersionsByWaiteffectAndDisable(Collection<Long> fileBoIds) {
        return this.adjFileDomainService.queryAdjFileVersionsByWaiteffectAndDisable(fileBoIds);
    }

    public Map<Long, Boolean> checkEmpposorgrelAvailable(Collection<Long> fileBoIds) {
        Map<Long, DynamicObject> objMap = this.adjFileDomainService.getEmpposorgrelObjByFileId(fileBoIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileBoIds.size());
        for (Long fileId : fileBoIds) {
            DynamicObject empposorgrelObj = objMap.get(fileId);
            if (empposorgrelObj != null) {
                resultMap.put(fileId, !StringUtils.equals((CharSequence)empposorgrelObj.getString("datastatus"), (CharSequence)"-1"));
                continue;
            }
            resultMap.put(fileId, Boolean.FALSE);
        }
        return resultMap;
    }

    public Map<Long, List<DynamicObject>> queryAdjFileDisableVersions(Collection<Long> fileBoIds) {
        return this.adjFileDomainService.queryAdjFileDisableVersions(fileBoIds);
    }

    private List<Set<Long>> getBatchLists(DynamicObject[] recordDys, String batchBasis) {
        ArrayList boBatchList = Lists.newArrayListWithExpectedSize((int)1000);
        Set boBatch = null;
        for (DynamicObject recordDy : recordDys) {
            long batchBasisId = recordDy.getLong(batchBasis);
            if (boBatch == null) {
                boBatch = Sets.newHashSetWithExpectedSize((int)1000);
            }
            boBatch.add(batchBasisId);
            if (boBatch.size() != 1000) continue;
            boBatchList.add(boBatch);
            boBatch = Sets.newHashSetWithExpectedSize((int)1000);
        }
        if (boBatch != null && boBatch.size() > 0) {
            boBatchList.add(boBatch);
        }
        return boBatchList;
    }

    private List<List<Long>> getBatchLists2(DynamicObject[] recordDys) {
        ArrayList idBatchList = Lists.newArrayListWithExpectedSize((int)100);
        List oneBatch = null;
        for (DynamicObject recordDy : recordDys) {
            long recordId = recordDy.getLong("id");
            if (oneBatch == null) {
                oneBatch = Lists.newArrayListWithExpectedSize((int)1000);
            }
            oneBatch.add(recordId);
            if (oneBatch.size() != 1000) continue;
            idBatchList.add(oneBatch);
            oneBatch = Lists.newArrayListWithExpectedSize((int)1000);
        }
        if (oneBatch != null && oneBatch.size() > 0) {
            idBatchList.add(oneBatch);
        }
        return idBatchList;
    }

    public void completeVersionWhenRevise(List<DynamicObject> updateRecordDataList) {
        if (CollectionUtils.isEmpty(updateRecordDataList)) {
            return;
        }
        HashSet salaryAdjFileBoidSet = Sets.newHashSetWithExpectedSize((int)updateRecordDataList.size());
        HashSet itemIdSet = Sets.newHashSetWithExpectedSize((int)updateRecordDataList.size());
        updateRecordDataList.forEach(data -> {
            salaryAdjFileBoidSet.add(data.getLong("salaryadjfile.id"));
            itemIdSet.add(data.getLong("standarditem.id"));
        });
        Map<Long, Map<Long, List<DynamicObject>>> decideAdjSalaryObjAfterSort = this.adjFileDomainService.getSortedAdjFileBoIdToItemIdToRecordList(salaryAdjFileBoidSet, itemIdSet);
        ArrayList needAddDyList = Lists.newArrayListWithExpectedSize((int)updateRecordDataList.size());
        for (DynamicObject curRecordDy : updateRecordDataList) {
            List<DynamicObject> existsRecordList;
            long salaryAdjFileId = curRecordDy.getLong("salaryadjfile.id");
            long itemId = curRecordDy.getLong("standarditem.id");
            Map<Long, List<DynamicObject>> itemToRecordsMap = decideAdjSalaryObjAfterSort.get(salaryAdjFileId);
            if (!MapUtils.isNotEmpty(itemToRecordsMap) || !CollectionUtils.isNotEmpty(existsRecordList = itemToRecordsMap.get(itemId))) continue;
            DynamicObject minBsedRecord = existsRecordList.get(0);
            Date currentBsled = curRecordDy.getDate("bsled");
            Date recordMinBsed = minBsedRecord.getDate("bsed");
            if (currentBsled == null || currentBsled.compareTo(SWCDateTimeUtils.addDay((Date)recordMinBsed, (long)-1L)) >= 0) continue;
            DynamicObject disableHisDyn = this.genDisableVersion(SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)currentBsled, (long)1L)), SWCDateTimeUtils.getDayDate((Date)SWCDateTimeUtils.addDay((Date)recordMinBsed, (long)-1L)), curRecordDy);
            needAddDyList.add(disableHisDyn);
        }
        updateRecordDataList.addAll(needAddDyList);
    }

    public Map<Long, Date> getMaxBsedOfRecordForDecType(Collection<Long> fileBoIds) {
        Map<Long, Date> maxBsedOfFileMap = this.adjFileDomainService.getMaxBsedOfFile(fileBoIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileBoIds.size());
        for (Long fileBoId : fileBoIds) {
            Date date = maxBsedOfFileMap.get(fileBoId);
            resultMap.put(fileBoId, date);
        }
        logger.info("getMaxBsedOfRecordForDecType resultMap is [{}]", (Object)resultMap);
        return resultMap;
    }

    public Map<Long, Map<Long, Date>> getMaxBsedOfRecordForAdjType(Map<Long, Set<Long>> fileItemIdMap) {
        Map<Long, Map<Long, DynamicObject>> latestDecAdjSalaryMap = this.adjFileDomainService.getLatestDecAdjSalary("id,standarditem.id,datastatus,enable,bsed,salaryadjfile.id", fileItemIdMap, true);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, Set<Long>> entry : fileItemIdMap.entrySet()) {
            Long fileBOId = entry.getKey();
            Map<Long, DynamicObject> itemDyObjMap = latestDecAdjSalaryMap.get(fileBOId);
            Map subMapOfCurMap = resultMap.computeIfAbsent(fileBOId, aLong -> Maps.newHashMap());
            if (null == itemDyObjMap) continue;
            Set<Long> itemIds = entry.getValue();
            for (Long itemId : itemIds) {
                DynamicObject itemDyn = itemDyObjMap.get(itemId);
                if (null == itemDyn) {
                    subMapOfCurMap.put(itemId, SWCBaseUtils.getMinEffectDate());
                    continue;
                }
                subMapOfCurMap.put(itemId, itemDyn.getDate("bsed"));
            }
        }
        return resultMap;
    }

    public Map<String, AdjfileMatchResult> batchMatchEffectiveAdjfileVersion(List<AdjFileMatchParam> params, String selectStringFields) {
        if (CollectionUtils.isEmpty(params = params.stream().filter(obj -> StringUtils.isNotBlank((CharSequence)obj.getUnionId()) && obj.getAdjFileBoId() != null && obj.getAdjFileBoId() > 0L && obj.getBsed() != null && obj.getBsled() != null).collect(Collectors.toList()))) {
            return Collections.emptyMap();
        }
        Set unionIds = params.stream().map(AdjFileMatchParam::getUnionId).collect(Collectors.toSet());
        if (unionIds.size() < params.size()) {
            throw new KDBizException("adjFileMatchParam unionid is duplicated");
        }
        HashSet adjFileBOId = Sets.newHashSetWithExpectedSize((int)params.size());
        for (AdjFileMatchParam adjFileMatchParam : params) {
            adjFileBOId.add(adjFileMatchParam.getAdjFileBoId());
        }
        Map<Long, List<DynamicObject>> boIdVersionsMap = this.adjFileDomainService.queryAllAdjFileVersions(selectStringFields, adjFileBOId);
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)params.size());
        block1: for (AdjFileMatchParam adjFileMatchParam : params) {
            Long adjFileBoId = adjFileMatchParam.getAdjFileBoId();
            Date bsed = adjFileMatchParam.getBsed();
            Date bsled = adjFileMatchParam.getBsled();
            boolean beforeAdjFileMinBsed = adjFileMatchParam.isBeforeAdjFileMinBsed();
            List<DynamicObject> adjFileVersions = boIdVersionsMap.get(adjFileBoId);
            AdjfileMatchResult adjfileMatchResult = new AdjfileMatchResult();
            adjfileMatchResult.setUnionId(adjFileMatchParam.getUnionId());
            if (CollectionUtils.isEmpty(adjFileVersions)) {
                adjfileMatchResult.setAdjfileNotFoundErrorEnum(AdjfileNotFoundErrorEnum.NOT_EXISIT_FILE);
                hashMap.put(adjFileMatchParam.getUnionId(), adjfileMatchResult);
                continue;
            }
            DynamicObject minEffectVersion = adjFileVersions.stream().filter(dy -> "1".equals(dy.getString("enable"))).findFirst().orElse(null);
            if (null == minEffectVersion) {
                adjfileMatchResult.setAdjfileNotFoundErrorEnum(AdjfileNotFoundErrorEnum.BSED_NOTMATCH_FILE);
                adjfileMatchResult.setUnableAdjfileVersions(adjFileVersions);
                hashMap.put(adjFileMatchParam.getUnionId(), adjfileMatchResult);
                continue;
            }
            if (!beforeAdjFileMinBsed && bsed.compareTo(minEffectVersion.getDate("bsed")) < 0) {
                adjfileMatchResult.setAdjfileNotFoundErrorEnum(AdjfileNotFoundErrorEnum.BSED_BEFORE_FILE);
                hashMap.put(adjFileMatchParam.getUnionId(), adjfileMatchResult);
                continue;
            }
            int size = adjFileVersions.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject adjfileVersion = adjFileVersions.get(i);
                String enable = adjfileVersion.getString("enable");
                Date dbBsed = adjfileVersion.getDate("bsed");
                Date dbBsled = adjfileVersion.getDate("bsled");
                if ((dbBsled.compareTo(bsed) < 0 || bsled.compareTo(dbBsed) < 0) && bsled.compareTo(minEffectVersion.getDate("bsed")) > 0) continue;
                if (SWCStringUtils.equals((String)enable, (String)"0")) {
                    if (bsed.compareTo(minEffectVersion.getDate("bsled")) <= 0) continue;
                    adjfileMatchResult.setAdjfileNotFoundErrorEnum(AdjfileNotFoundErrorEnum.BSED_NOTMATCH_FILE);
                    adjfileMatchResult.setUnableAdjfileVersions((List)Lists.newArrayList((Object[])new DynamicObject[]{adjfileVersion}));
                    hashMap.put(adjFileMatchParam.getUnionId(), adjfileMatchResult);
                    continue block1;
                }
                adjfileMatchResult.setAdjfileVersion(adjfileVersion);
                ArrayList<DynamicObject> unableVersions = new ArrayList<DynamicObject>();
                for (int j = i + 1; j < size; ++j) {
                    DynamicObject next = adjFileVersions.get(j);
                    Date dbNextBsed = next.getDate("bsed");
                    Date dbNextBsled = next.getDate("bsled");
                    String nextEnable = next.getString("enable");
                    if (dbNextBsled.compareTo(bsed) < 0 || bsled.compareTo(dbNextBsed) < 0 || !SWCStringUtils.equals((String)nextEnable, (String)"0")) continue;
                    unableVersions.add(next);
                }
                if (CollectionUtils.isNotEmpty(unableVersions)) {
                    adjfileMatchResult.setAdjfileVersion(null);
                    adjfileMatchResult.setUnableAdjfileVersions(unableVersions);
                    adjfileMatchResult.setAdjfileNotFoundErrorEnum(AdjfileNotFoundErrorEnum.COVER_UNABLE_FILE);
                }
                hashMap.put(adjFileMatchParam.getUnionId(), adjfileMatchResult);
                continue block1;
            }
        }
        return hashMap;
    }

    public Map<String, AdjfileMatchResult> batchMatchEffectiveAdjfileVersion(List<AdjFileMatchParam> params) {
        return this.batchMatchEffectiveAdjfileVersion(params, null);
    }

    public List<Long> queryExistBoOfVersionDisabledInBsed(Date bsed, Date bsled) {
        DynamicObject[] disableVersions = this.adjFileDomainService.queryUsableDataStatusVersionDisabledInBsed(bsed, bsled);
        return Arrays.stream(disableVersions).map(o1 -> o1.getLong("boid")).distinct().collect(Collectors.toList());
    }
}

