/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.metadata.form.control.LittleKAp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.entity.ExRateKey;
import kd.swc.hcdm.common.enums.AdjNineGridSourceEnum;
import kd.swc.hcdm.common.utils.AmountFormatUtils;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AdjApprovalGridHelper {
    private static Log logger = LogFactory.getLog(AdjApprovalGridHelper.class);

    public static String formatPercent(boolean condition, BigDecimal presalarypercent) {
        if (!condition) {
            return "";
        }
        if (presalarypercent == null) {
            return "";
        }
        return presalarypercent.setScale(2, 5).toPlainString() + "%";
    }

    public static String getFormatNumberStr(BigDecimal source, int scale, String suffix) {
        if (source == null) {
            return "";
        }
        source = source.setScale(scale, 5);
        return source.toString() + suffix;
    }

    public static String formatAmountValue(BigDecimal amount, DynamicObject currencyObj) {
        return AdjApprovalGridHelper.formatAmountValue(amount, currencyObj, null);
    }

    public static String formatAmountValue(BigDecimal amount, DynamicObject currencyObj, Integer scale) {
        if (null == amount) {
            return "";
        }
        if (null == currencyObj) {
            return amount.setScale(0, 5).toString();
        }
        int amtprecision = scale != null ? scale.intValue() : currencyObj.getInt("amtprecision");
        String sign = currencyObj.getString("sign");
        amount = amount.setScale(amtprecision, 5);
        return sign + AmountFormatUtils.fmtMicrometer((String)amount.toString());
    }

    public static Map<Long, DynamicObject> getJobData(Collection<Long> jobIds) {
        if (jobIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hbjm_jobhr");
        DynamicObject[] objects = service.query("id,name,jobscm,jobseq,jobfamily,jobclass", new QFilter[]{new QFilter("id", "in", jobIds)});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("id"), object);
        }
        return data;
    }

    public static Map<Long, DynamicObject> getDepempData(Collection<Long> depempIds) {
        if (depempIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_depemp");
        DynamicObject[] objects = service.query("id,adminorg.name,adminorg.number,employee.id,employee.name,employee.number", new QFilter[]{new QFilter("id", "in", depempIds)});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("id"), object);
        }
        return data;
    }

    public static Map<Long, DynamicObject> getEmpJobRel(Map<Long, Long> employeeIdMap) {
        if (employeeIdMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<Long> employeeIds = new HashSet<Long>(employeeIdMap.size());
        employeeIdMap.entrySet().forEach(entry -> employeeIds.add((Long)entry.getValue()));
        Map<Long, DynamicObject> empJobRelData = AdjApprovalGridHelper.queryEmpJobRel(employeeIds);
        HashMap data = Maps.newHashMapWithExpectedSize((int)empJobRelData.size());
        for (Map.Entry<Long, Long> employee : employeeIdMap.entrySet()) {
            DynamicObject dynamicObject = empJobRelData.get(employee.getValue());
            data.put(employee.getKey(), dynamicObject);
        }
        return data;
    }

    public static Map<Long, DynamicObject> queryEmpJobRel(Set<Long> employeeIds) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_empjobrel");
        DynamicObject[] objects = service.query("id,joblevel.id, joblevel.name, joblevel.joblevelseq, jobgrade.id, jobgrade.name, jobgrade.jobgradeseq,employee.id", new QFilter[]{new QFilter("employee", "in", employeeIds), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("businessstatus", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
        HashMap empJobRelData = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            empJobRelData.putIfAbsent(object.getLong("employee.id"), object);
        }
        if (empJobRelData.isEmpty()) {
            return Collections.emptyMap();
        }
        return empJobRelData;
    }

    public static void getLaborRelData(Set<Long> employeeIds, Map<Long, DynamicObject> laborRelTypeData, Map<Long, DynamicObject> laborRelStatusData) {
        DynamicObject[] objects;
        if (employeeIds.isEmpty()) {
            return;
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_empentrel");
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        QFilter qFilter1 = new QFilter("iscurrentversion", "=", (Object)"1");
        for (DynamicObject object : objects = service.query("employee,laborreltype,laborrelstatus", new QFilter[]{qFilter, qFilter1})) {
            Long employeeId = object.getLong("employee.id");
            DynamicObject laborRelType = object.getDynamicObject("laborreltype");
            DynamicObject laborRelStatus = object.getDynamicObject("laborrelstatus");
            laborRelTypeData.putIfAbsent(employeeId, laborRelType);
            laborRelStatusData.putIfAbsent(employeeId, laborRelStatus);
            logger.info("employeeId is {},laborRelType is {},laborRelStatus is {}", new Object[]{employeeId, laborRelType != null ? Long.valueOf(laborRelType.getLong("id")) : null, laborRelStatus != null ? Long.valueOf(laborRelStatus.getLong("id")) : null});
        }
    }

    public static FormShowParameter showNineGridChart(IFormView view, ShowType showType) {
        OpenStyle openStyle2 = new OpenStyle();
        openStyle2.setTargetKey("flexdecision");
        openStyle2.setShowType(showType);
        return AdjApprovalGridHelper.showNineGridChart(view, view.getPageId(), showType, AdjNineGridSourceEnum.ADJAPPROVEBILL.getCode(), Maps.newHashMap(), openStyle2);
    }

    public static FormShowParameter showNineGridChart(IFormView view, String parentPageId, ShowType showType, Object source, Map<String, Object> customParams, OpenStyle openStyle2) {
        FormShowParameter formShow = new FormShowParameter();
        formShow.setOpenStyle(openStyle2);
        formShow.setFormId("hcdm_adjninegrid");
        formShow.setParentPageId(parentPageId);
        customParams.put("source", source);
        formShow.setCustomParams(customParams);
        view.showForm(formShow);
        if (ShowType.InContainer.equals((Object)showType)) {
            view.getPageCache().put("ninegridpageid", formShow.getPageId());
        }
        return formShow;
    }

    public static void openLittleKAnalyze(IFormView billView, IFormView nineView, AdjNineGridSourceEnum sourceEnum) {
        DynamicObject adjAppScm;
        String littlekPages = billView.getPageCache().get("littlekPages");
        if (StringUtils.isNotEmpty((CharSequence)littlekPages)) {
            String[] pageLists;
            int sign = 0;
            for (String page : pageLists = littlekPages.split(",")) {
                IFormView view = billView.getView(page);
                if (view == null) continue;
                ++sign;
                view.updateView();
                if (AdjNineGridSourceEnum.ADJDECISIONCONFIG == sourceEnum) {
                    nineView.sendFormAction(view);
                    continue;
                }
                if (AdjNineGridSourceEnum.ADJAPPROVEBILL != sourceEnum) continue;
                billView.sendFormAction(view);
            }
            if (sign == pageLists.length) {
                return;
            }
        }
        if ((adjAppScm = billView.getModel().getDataEntity().getDynamicObject("salaryadjscm")) == null) {
            return;
        }
        DynamicObjectCollection littleKCols = adjAppScm.getDynamicObjectCollection("littlekentryentity");
        FlexPanelAp flexPanelAp = AdjApprovalGridHelper.buildParentPanelAp();
        boolean isUpdateCardContent = false;
        ArrayList pages = Lists.newArrayList();
        for (DynamicObject littleKCol : littleKCols) {
            isUpdateCardContent = true;
            String subKey = AdjApprovalGridHelper.buildSubLittlePanelAP(billView, flexPanelAp);
            FormShowParameter formShow = AdjApprovalGridHelper.showLittleKPage(billView, nineView, littleKCol, subKey, null);
            pages.add(formShow.getPageId());
        }
        billView.getPageCache().put("littlekPages", StringUtils.join((Iterable)pages, (String)","));
        if (isUpdateCardContent) {
            billView.updateControlMetadata("cardcontent", flexPanelAp.createControl());
        }
        if (AdjNineGridSourceEnum.ADJDECISIONCONFIG == sourceEnum && nineView != null) {
            nineView.sendFormAction(billView);
        }
    }

    public static DynamicObject[] queryCurrency(Set<Long> currencyIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_currency");
        QFilter qFilter = new QFilter("id", "in", currencyIdSet);
        return helper.query("id, name", new QFilter[]{qFilter});
    }

    public static void openLittleKFromApprovePage(IFormView parentView, IFormView billView, IFormView nineView, AdjNineGridSourceEnum sourceEnum) {
        DynamicObject adjAppScm = billView.getModel().getDataEntity().getDynamicObject("salaryadjscm");
        if (adjAppScm == null) {
            return;
        }
        DynamicObjectCollection littleKCols = adjAppScm.getDynamicObjectCollection("littlekentryentity");
        FlexPanelAp allPanelAp = AdjApprovalGridHelper.buildAllPanelAp();
        FlexPanelAp littleKAp = AdjApprovalGridHelper.buildLittleKAp();
        AdjApprovalGridHelper.drawLittleKApContent(parentView, littleKAp);
        FlexPanelAp cardPanelAp = AdjApprovalGridHelper.buildParentPanelAp();
        boolean isUpdateCardContent = false;
        for (DynamicObject littleKCol : littleKCols) {
            isUpdateCardContent = true;
            String subKey = AdjApprovalGridHelper.buildSubLittlePanelAP(parentView, cardPanelAp);
            AdjApprovalGridHelper.showLittleKPage(parentView, nineView, littleKCol, subKey, billView);
        }
        if (isUpdateCardContent) {
            allPanelAp.getItems().add(littleKAp);
            allPanelAp.getItems().add(cardPanelAp);
            parentView.updateControlMetadata("flexpanelap_bizpanel", allPanelAp.createControl());
        }
        if (AdjNineGridSourceEnum.ADJDECISIONCONFIG == sourceEnum && nineView != null) {
            nineView.sendFormAction(parentView);
        }
    }

    private static void drawLittleKApContent(IFormView billView, FlexPanelAp litteKAp) {
        LittleKAp littleKAp = new LittleKAp();
        littleKAp.setKey("litteKAp");
        littleKAp.setId("litteKAp");
        littleKAp.setWelcomeAnimation(true);
        littleKAp.setGrow(0);
        littleKAp.setShrink(0);
        littleKAp.setHeight(new LocaleString("70px"));
        littleKAp.setWidth(new LocaleString("70px"));
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("loadLabAp");
        labelAp.setId("loadLabAp");
        labelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u91cd\u65b0\u52a0\u8f7d", (String)"AdjApprovalGridHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0])));
        labelAp.setForeColor("#276ff5");
        labelAp.setControlLoading(true);
        labelAp.setClickable(true);
        labelAp.setFontSize(12);
        labelAp.setGrow(0);
        labelAp.setShrink(1);
        litteKAp.getItems().add(littleKAp);
        litteKAp.getItems().add(labelAp);
        billView.updateControlMetadata(litteKAp.getKey(), litteKAp.createControl());
    }

    private static FlexPanelAp buildParentPanelAp() {
        String parentKey = "parentPanelAp";
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(parentKey);
        flexPanelAp.setId(parentKey);
        flexPanelAp.setWrap(true);
        flexPanelAp.setDirection("row");
        flexPanelAp.setAlignContent("flex-start");
        flexPanelAp.setAlignItems("flex-start");
        flexPanelAp.setJustifyContent("center");
        flexPanelAp.setForeColor("#000000");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("16px");
        margin.setRight("16px");
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        return flexPanelAp;
    }

    private static FlexPanelAp buildAllPanelAp() {
        FlexPanelAp allPanelAp = new FlexPanelAp();
        allPanelAp.setKey("allPanelAp");
        allPanelAp.setId("allPanelAp");
        allPanelAp.setDirection("row");
        allPanelAp.setWrap(true);
        allPanelAp.setOverflow("auto");
        return allPanelAp;
    }

    private static FlexPanelAp buildLittleKAp() {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("takeLitteKAp");
        flexPanelAp.setId("takeLitteKAp");
        flexPanelAp.setDirection("column");
        flexPanelAp.setJustifyContent("flex-start");
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setHeight(new LocaleString("142px"));
        flexPanelAp.setGrow(1);
        flexPanelAp.setShrink(1);
        flexPanelAp.setWrap(false);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("20px");
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        return flexPanelAp;
    }

    private static String buildSubLittlePanelAP(IFormView billView, FlexPanelAp flexPanelAp) {
        String subKey = "subPanelAp" + System.currentTimeMillis();
        FlexPanelAp subFlexPanelAp = new FlexPanelAp();
        subFlexPanelAp.setKey(subKey);
        subFlexPanelAp.setId(subKey);
        subFlexPanelAp.setWrap(true);
        subFlexPanelAp.setAlignContent("flex-start");
        subFlexPanelAp.setAlignItems("flex-start");
        subFlexPanelAp.setJustifyContent("flex-start");
        Style substyle = new Style();
        Border border = new Border();
        border.setTop("1px solid #e2e7ef");
        substyle.setBorder(border);
        Padding padding = new Padding();
        padding.setTop("20px");
        padding.setBottom("20px");
        substyle.setPadding(padding);
        subFlexPanelAp.setStyle(substyle);
        subFlexPanelAp.setWidth(new LocaleString("100%"));
        billView.updateControlMetadata(subFlexPanelAp.getKey(), subFlexPanelAp.createControl());
        flexPanelAp.getItems().add(subFlexPanelAp);
        billView.updateControlMetadata(flexPanelAp.getKey(), flexPanelAp.createControl());
        return subKey;
    }

    private static FormShowParameter showLittleKPage(IFormView billView, IFormView nineView, DynamicObject littleKCol, String subKey, IFormView subBillView) {
        FormShowParameter formShow = new FormShowParameter();
        OpenStyle openStyle2 = new OpenStyle();
        openStyle2.setTargetKey(subKey);
        openStyle2.setShowType(ShowType.InContainer);
        formShow.setOpenStyle(openStyle2);
        formShow.setCustomParam("title", (Object)littleKCol.getString("title"));
        formShow.setCustomParam("content", (Object)littleKCol.getString("content"));
        formShow.setCustomParam("nineGridChartPageId", (Object)(nineView != null ? nineView.getPageId() : null));
        formShow.setCustomParam("approveBillPageId", (Object)(subBillView != null ? subBillView.getPageId() : null));
        formShow.setFormId("hcdm_littlkeanalyzecard");
        billView.showForm(formShow);
        return formShow;
    }

    public static ExchangeRateInfo getExchangeRate(BillExRateManager rateManager, long stdcurrency, long adjCurrency, long exctableId, Date rateDate) {
        if (adjCurrency == stdcurrency) {
            return null;
        }
        if (rateDate != null && exctableId != 0L) {
            return rateManager.getExRate(new ExRateKey(adjCurrency, stdcurrency, rateDate.getTime(), exctableId));
        }
        return null;
    }
}

