/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalGridHelper;
import kd.swc.hcdm.business.adjapprbill.AdjBillEntryImpHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.AxisDataConfigHelper;
import kd.swc.hcdm.business.adjapprbill.enums.AxisTypeEnum;
import kd.swc.hcdm.business.adjapprscm.AdjApprLittleKCfgTplHelper;
import kd.swc.hcdm.business.helper.DynamicObjectValueHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.control.SWCLabelAp;
import org.apache.commons.collections.MapUtils;

public class AdjApprovalLittleKHelper {
    private static Log logger = LogFactory.getLog(AdjApprovalLittleKHelper.class);
    private static final Pattern pattern = Pattern.compile("\\{(.*?)\\}");
    public static final String REGEX = "[^(0-9).]";
    private static final Pattern pattern2 = Pattern.compile("[^(0-9).]");
    static Set<String> ranKingParamKeys = Sets.newHashSetWithExpectedSize((int)10);
    static Set<String> detailEntParamKeys;
    static Set<String> nineGridEntParamKeys;
    private static String[] noDescartes;

    public static String transFieldKeyToCaption(String content, boolean reverse) {
        Map<String, String> varParam = AdjApprLittleKCfgTplHelper.createVarParamMap();
        logger.info("trans field key to caption varparam = {}", (Object)JSON.toJSONString(varParam));
        String fmt = "{%s}";
        String resultContent = content;
        for (Map.Entry<String, String> entry : varParam.entrySet()) {
            String propName = entry.getKey();
            String caption = entry.getValue();
            String captionParamStr = String.format(Locale.ROOT, fmt, caption);
            String propParamStr = String.format(Locale.ROOT, fmt, propName);
            if (!reverse) {
                resultContent = StringUtils.replace((String)resultContent, (String)propParamStr, (String)captionParamStr);
                continue;
            }
            resultContent = StringUtils.replace((String)resultContent, (String)captionParamStr, (String)propParamStr);
        }
        return resultContent;
    }

    public static FlexPanelAp createTplVarFlexPlanAp() {
        FlexPanelAp varPanelAp = new FlexPanelAp();
        varPanelAp.setKey("flexvar");
        Map<String, String> varParamMap = AdjApprLittleKCfgTplHelper.createVarParamMap();
        Set<Map.Entry<String, String>> entries = varParamMap.entrySet();
        String labelNameFmt = "\u3010%s\u3011";
        for (Map.Entry<String, String> entry : entries) {
            LabelAp varLabelAp = new SWCLabelAp.Builder(entry.getKey().toString()).setFontSize(12).setName(String.format(Locale.ROOT, labelNameFmt, entry.getValue())).setClickable(true).setForeColor("themeColor").build();
            varPanelAp.getItems().add(varLabelAp);
        }
        return varPanelAp;
    }

    public static List<String> collectLittleKTplParamNames(String content) {
        ArrayList paramNames = Lists.newArrayList();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (!AdjApprLittleKCfgTplHelper.varParamList.contains(key = AdjApprovalLittleKHelper.findLittleKTplParamName(key))) continue;
            paramNames.add(key);
        }
        return paramNames;
    }

    private static String findLittleKTplParamName(String key) {
        if (!key.contains("{") && !key.contains("}")) {
            return key;
        }
        key = key.replace("{", "");
        key = key.replace("}", "");
        return AdjApprovalLittleKHelper.findLittleKTplParamName(key);
    }

    public static Map<String, Map<String, List<String>>> queryLittleKTplParamValue(IFormView billView, IFormView gridView, Set<String> paramNames) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        if (billView == null) {
            return result;
        }
        DynamicObjectCollection adjApprDetailEntCols = new DynamicObjectCollection();
        DynamicObject[] entryEntities = AdjBillEntryImpHelper.getDynamicEntryData(billView);
        adjApprDetailEntCols.addAll(Arrays.asList(entryEntities));
        HashMap<String, List<DynamicObject>> bizitemAxis = new HashMap(2);
        DynamicObject salaryAdjScmDyObj = billView.getModel().getDataEntity().getDynamicObject("salaryadjscm");
        if (salaryAdjScmDyObj != null) {
            bizitemAxis = AdjApprovalLittleKHelper.getBizitemAxis(salaryAdjScmDyObj.getDynamicObjectCollection("ninegrid"));
            bizitemAxis = AdjApprovalLittleKHelper.getXyAxisComboData(gridView, bizitemAxis, salaryAdjScmDyObj);
        }
        DynamicObjectCollection gridObjCol = new DynamicObjectCollection();
        if (gridView != null) {
            gridObjCol = gridView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        }
        Map<Long, DynamicObject> empposorgrelDatas = DecAdjApprGridHelper.getEmpposorgrelData(adjApprDetailEntCols);
        Map<Long, DynamicObject> depempObjs = DecAdjApprGridHelper.queryDepempData(adjApprDetailEntCols);
        Map<Long, DynamicObject> empjobrelDatas = DecAdjApprGridHelper.queryEmpJobRel(adjApprDetailEntCols);
        Map<Long, DynamicObject> jobDatas = DecAdjApprGridHelper.getJobData(adjApprDetailEntCols);
        ArrayList empposorgrelDataLoops = Lists.newArrayListWithExpectedSize((int)empposorgrelDatas.size());
        empposorgrelDatas.values().forEach(object -> {
            if (object != null) {
                empposorgrelDataLoops.add(object);
            }
        });
        ArrayList empjobrelDataLoops = Lists.newArrayListWithExpectedSize((int)empposorgrelDatas.size());
        empjobrelDatas.values().forEach(object -> {
            if (object != null) {
                empjobrelDataLoops.add(object);
            }
        });
        ArrayList jobDataLoops = Lists.newArrayListWithExpectedSize((int)empposorgrelDatas.size());
        jobDatas.values().forEach(object -> {
            if (object != null) {
                jobDataLoops.add(object);
            }
        });
        Map<String, List<String>> loopResult = AdjApprovalLittleKHelper.queryLittleKTplParamValueMap(empposorgrelDataLoops, empjobrelDataLoops, bizitemAxis, billView, adjApprDetailEntCols, gridObjCol, jobDataLoops, paramNames);
        result.put("loopResult", loopResult);
        DynamicObject adjApprDetailEnt = null;
        if (CollectionUtil.isNotEmpty((Collection)adjApprDetailEntCols)) {
            adjApprDetailEnt = (DynamicObject)adjApprDetailEntCols.get(0);
        }
        ArrayList empposorgrelDataList = Lists.newArrayListWithExpectedSize((int)1);
        ArrayList empjobrelDataList = Lists.newArrayListWithExpectedSize((int)1);
        ArrayList jobDataList = Lists.newArrayListWithExpectedSize((int)1);
        if (adjApprDetailEnt != null) {
            DynamicObject depempObj;
            if (empposorgrelDatas.size() != 0) {
                empposorgrelDataList.add(empposorgrelDatas.get(adjApprDetailEnt.getLong("dy_adjfile.empposorgrel.id")));
            }
            if ((depempObj = depempObjs.get(adjApprDetailEnt.getLong("dy_adjfile.depemp.id"))) != null && empjobrelDatas.size() != 0) {
                empjobrelDataList.add(empjobrelDatas.get(depempObj.getLong("employee_id")));
            }
            if (jobDatas.size() != 0) {
                jobDataList.add(jobDatas.get(adjApprDetailEnt.getLong("dy_job.id")));
            }
        }
        DynamicObjectCollection adjApprDetailEntList = new DynamicObjectCollection();
        if (adjApprDetailEnt != null) {
            adjApprDetailEntList.add((Object)adjApprDetailEnt);
        }
        empposorgrelDataList.removeIf(Objects::isNull);
        empjobrelDataList.removeIf(Objects::isNull);
        jobDataList.removeIf(Objects::isNull);
        adjApprDetailEntList.removeIf(Objects::isNull);
        Map<String, List<String>> simpleResult = AdjApprovalLittleKHelper.queryLittleKTplParamValueMap(empposorgrelDataList, empjobrelDataList, bizitemAxis, billView, adjApprDetailEntList, gridObjCol, jobDataList, paramNames);
        result.put("simpleResult", simpleResult);
        return result;
    }

    private static Map<String, List<DynamicObject>> getXyAxisComboData(IFormView gridView, Map<String, List<DynamicObject>> bizitemAxis, DynamicObject salaryAdjScmDyObj) {
        if (salaryAdjScmDyObj.getBoolean("isadjdecision")) {
            HashMap<String, List<DynamicObject>> bizitemAxisMap = new HashMap<String, List<DynamicObject>>(2);
            if (gridView != null) {
                String xaxisBizitem = (String)gridView.getModel().getValue("xaxis_name");
                String yaxisBizitem = (String)gridView.getModel().getValue("yaxis_name");
                if (StringUtils.isNotEmpty((CharSequence)xaxisBizitem) && StringUtils.isNotEmpty((CharSequence)yaxisBizitem)) {
                    String[] splitX = xaxisBizitem.split("&");
                    String[] splitY = yaxisBizitem.split("&");
                    for (Map.Entry<String, List<DynamicObject>> listEntry : bizitemAxis.entrySet()) {
                        String key = listEntry.getKey();
                        for (DynamicObject bizItemAxisDy : listEntry.getValue()) {
                            List dynamicObjects = bizitemAxisMap.computeIfAbsent(key, key1 -> Lists.newArrayList());
                            long bizItemCategoryId = bizItemAxisDy.getLong("bizitemcategory.id");
                            long adjDecisionCfgId = bizItemAxisDy.getLong("adjsalauxdcsncfg.id");
                            if ((!String.valueOf(bizItemCategoryId).equals(splitX[1]) || !String.valueOf(adjDecisionCfgId).equals(splitX[0]) || !key.equals("1")) && (!String.valueOf(bizItemCategoryId).equals(splitY[1]) || !String.valueOf(adjDecisionCfgId).equals(splitY[0]) || !key.equals("2"))) continue;
                            dynamicObjects.add(bizItemAxisDy);
                            bizitemAxisMap.put(key, dynamicObjects);
                        }
                    }
                    bizitemAxis = bizitemAxisMap;
                }
            }
        }
        return bizitemAxis;
    }

    private static Map<String, List<String>> queryLittleKTplParamValueMap(List<DynamicObject> empposorgrelDatas, List<DynamicObject> empjobrelDataList, Map<String, List<DynamicObject>> bizitemAxis, IFormView billView, DynamicObjectCollection adjApprDetailEntCols, DynamicObjectCollection gridObjCol, List<DynamicObject> jobDatas, Set<String> paramNames) {
        DynamicObject panelCurrencyDyObj = billView.getModel().getDataEntity().getDynamicObject("currency");
        HashMap empposorgrelMap = Maps.newHashMapWithExpectedSize((int)empposorgrelDatas.size());
        for (DynamicObject object : empposorgrelDatas) {
            empposorgrelMap.putIfAbsent(object.getLong("id"), object);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)paramNames.size());
        for (String paramName : paramNames) {
            List<Object> paramValeu = Lists.newArrayListWithCapacity((int)10);
            switch (paramName) {
                case "totalamount": {
                    String totalAmount = AdjApprovalGridHelper.formatAmountValue(billView.getModel().getDataEntity().getBigDecimal("totalamount"), billView.getModel().getDataEntity().getDynamicObject("currency"));
                    for (Iterator adjapprdetail : adjApprDetailEntCols) {
                        HashMap totalAmountMap = Maps.newHashMapWithExpectedSize((int)adjApprDetailEntCols.size());
                        for (String paramKey : detailEntParamKeys) {
                            DynamicObject object = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)adjapprdetail, paramKey, null);
                            String adjApprDetailValue = object == null ? "" : object.getString("name");
                            totalAmountMap.put(paramKey, adjApprDetailValue);
                        }
                        long adjCurrency = adjapprdetail.getLong("dy_currency_id");
                        BigDecimal actualamount = adjapprdetail.getBigDecimal("dy_actualamount");
                        DynamicObject entryCurrencyDyObj = adjapprdetail.getDynamicObject("dy_currency");
                        DynamicObject entryFrequencyDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)adjapprdetail, "dy_frequency", null);
                        totalAmountMap.put("actualamount", actualamount == null ? "" : actualamount.toPlainString());
                        totalAmountMap.put("panelcurrencydyobj", null == panelCurrencyDyObj ? "" : DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)panelCurrencyDyObj));
                        totalAmountMap.put("entrycurrencydyobj", null == entryCurrencyDyObj ? "" : DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)entryCurrencyDyObj));
                        totalAmountMap.put("entryfrequencydyobj", null == entryFrequencyDyObj ? "" : DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)entryFrequencyDyObj));
                        totalAmountMap.put("bill.totalamount", totalAmount);
                        AdjApprovalLittleKHelper.getNineGridRankingData(bizitemAxis, gridObjCol, paramValeu, (DynamicObject)adjapprdetail, totalAmountMap);
                        paramValeu.add(JSONObject.toJSONString((Object)totalAmountMap));
                    }
                    break;
                }
                case "totalperson": {
                    Iterator adjapprdetail;
                    String totalPerson = String.valueOf(billView.getModel().getDataEntity().getInt("totalperson"));
                    adjapprdetail = adjApprDetailEntCols.iterator();
                    while (adjapprdetail.hasNext()) {
                        DynamicObject adjapprdetail2 = (DynamicObject)adjapprdetail.next();
                        HashMap totalPersonMap = Maps.newHashMapWithExpectedSize((int)adjApprDetailEntCols.size());
                        String adjApprDetailValue = "";
                        for (String paramKey : detailEntParamKeys) {
                            DynamicObject object = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(adjapprdetail2, paramKey, null);
                            adjApprDetailValue = object == null ? "" : object.getString("name");
                            totalPersonMap.put(paramKey, adjApprDetailValue);
                        }
                        AdjApprovalLittleKHelper.getNineGridRankingData(bizitemAxis, gridObjCol, (List<String>)paramValeu, adjapprdetail2, totalPersonMap);
                        totalPersonMap.put("adjfile.number", adjapprdetail2.getString("dy_adjfile.number"));
                        totalPersonMap.put("bill.totalperson", totalPerson);
                        paramValeu.add(JSONObject.toJSONString((Object)totalPersonMap));
                    }
                    break;
                }
                case "dy_company": {
                    if (!CollectionUtil.isNotEmpty(empposorgrelDatas)) break;
                    List companyNames = empposorgrelDatas.stream().map(obj -> {
                        DynamicObject company = obj.getDynamicObject("company");
                        if (company == null) {
                            return "";
                        }
                        return company.getString("name");
                    }).collect(Collectors.toList());
                    companyNames = companyNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = companyNames.stream().distinct().collect(Collectors.toList());
                    break;
                }
                case "dy_adminorg": {
                    if (!CollectionUtil.isNotEmpty(empposorgrelDatas)) break;
                    List adminorgNames = empposorgrelDatas.stream().map(obj -> {
                        DynamicObject adminorg = obj.getDynamicObject("adminorg");
                        if (adminorg == null) {
                            return "";
                        }
                        return adminorg.getString("name");
                    }).collect(Collectors.toList());
                    adminorgNames = adminorgNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = adminorgNames.stream().distinct().collect(Collectors.toList());
                    break;
                }
                case "dy_position": {
                    if (!CollectionUtil.isNotEmpty(empposorgrelDatas)) break;
                    List positionNames = empposorgrelDatas.stream().map(obj -> {
                        DynamicObject position = obj.getDynamicObject("position");
                        if (position == null) {
                            return "";
                        }
                        return position.getString("name");
                    }).collect(Collectors.toList());
                    positionNames = positionNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = positionNames.stream().distinct().collect(Collectors.toList());
                    break;
                }
                case "dy_job": {
                    if (!CollectionUtil.isNotEmpty(jobDatas)) break;
                    List jobNames = jobDatas.stream().map(obj -> obj.getString("name")).collect(Collectors.toList());
                    jobNames = jobNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = jobNames.stream().distinct().collect(Collectors.toList());
                    break;
                }
                case "dy_standarditem": {
                    if (!CollectionUtil.isNotEmpty((Collection)adjApprDetailEntCols)) break;
                    List standardItemNames = adjApprDetailEntCols.stream().map(obj -> {
                        DynamicObject standarditem = obj.getDynamicObject("dy_standarditem");
                        if (standarditem == null) {
                            return "";
                        }
                        return standarditem.getString("name");
                    }).collect(Collectors.toList());
                    standardItemNames = standardItemNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = standardItemNames.stream().distinct().collect(Collectors.toList());
                    break;
                }
                case "dy_joblevel": {
                    if (!CollectionUtil.isNotEmpty(empjobrelDataList)) break;
                    List joblevelNames = empjobrelDataList.stream().map(obj -> {
                        DynamicObject joblevel = obj.getDynamicObject("joblevel");
                        if (joblevel == null) {
                            return "";
                        }
                        return joblevel.getString("name");
                    }).collect(Collectors.toList());
                    joblevelNames = joblevelNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = joblevelNames.stream().distinct().collect(Collectors.toList());
                    break;
                }
                case "dy_jobgrade": {
                    if (!CollectionUtil.isNotEmpty(empjobrelDataList)) break;
                    List jobgradeNames = empjobrelDataList.stream().map(obj -> {
                        DynamicObject jobgrade = obj.getDynamicObject("jobgrade");
                        if (jobgrade == null) {
                            return "";
                        }
                        return jobgrade.getString("name");
                    }).collect(Collectors.toList());
                    jobgradeNames = jobgradeNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = jobgradeNames.stream().distinct().collect(Collectors.toList());
                    break;
                }
                case "xaxis_bizitem": {
                    paramValeu = AdjApprovalLittleKHelper.getXaxisBizItem(bizitemAxis, (List<String>)paramValeu);
                    break;
                }
                case "yaxis_bizitem": {
                    paramValeu = AdjApprovalLittleKHelper.getYaxisBizItem(bizitemAxis, (List<String>)paramValeu);
                    break;
                }
                case "avg_ratio": {
                    for (DynamicObject gridObj : gridObjCol) {
                        LinkedHashMap avgRatioMap = Maps.newLinkedHashMapWithExpectedSize((int)gridObjCol.size());
                        avgRatioMap.put("dy_adminorg", gridObj.getString("department"));
                        avgRatioMap.put("dy_job", gridObj.getString("job"));
                        avgRatioMap.put("dy_joblevel", gridObj.getString("joblevel"));
                        avgRatioMap.put("dy_jobgrade", gridObj.getString("jobgrade"));
                        avgRatioMap.put("position", gridObj.getString("position"));
                        avgRatioMap.put("avgRatio", gridObj.getString("avg_ratio"));
                        avgRatioMap.put("dy_standarditem", gridObj.getString("standard_item"));
                        paramValeu.add(JSONObject.toJSONString((Object)avgRatioMap));
                    }
                    break;
                }
                case "avg_amount": {
                    for (DynamicObject gridObj : gridObjCol) {
                        LinkedHashMap avgAmount = Maps.newLinkedHashMapWithExpectedSize((int)gridObjCol.size());
                        avgAmount.put("dy_adminorg", gridObj.getString("department"));
                        avgAmount.put("dy_job", gridObj.getString("job"));
                        avgAmount.put("dy_joblevel", gridObj.getString("joblevel"));
                        avgAmount.put("dy_jobgrade", gridObj.getString("jobgrade"));
                        avgAmount.put("position", gridObj.getString("position"));
                        avgAmount.put("avgAmount", gridObj.getString("avg_amount"));
                        avgAmount.put("dy_standarditem", gridObj.getString("standard_item"));
                        avgAmount.put("panelcurrencydyobj", panelCurrencyDyObj == null ? "" : DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)panelCurrencyDyObj));
                        paramValeu.add(JSONObject.toJSONString((Object)avgAmount));
                    }
                    break;
                }
                case "position": {
                    if (!CollectionUtil.isNotEmpty((Collection)gridObjCol)) break;
                    List positions = gridObjCol.stream().map(obj -> obj.getString("position")).collect(Collectors.toList());
                    positions = positions.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    paramValeu = positions.stream().distinct().collect(Collectors.toList());
                    break;
                }
            }
            result.put(paramName, paramValeu);
        }
        return result;
    }

    private static void getNineGridRankingData(Map<String, List<DynamicObject>> bizitemAxis, DynamicObjectCollection gridObjCol, List<String> paramValeu, DynamicObject adjapprdetail, Map<String, String> totalAmountMap) {
        for (String paramKey : nineGridEntParamKeys) {
            long personId = adjapprdetail.getLong("dy_adjfile.person.id");
            long standardItemId = adjapprdetail.getLong("dy_standarditem.id");
            for (DynamicObject gridObj : gridObjCol) {
                long gridPersonId = gridObj.getLong("person.id");
                long gridStdItemId = gridObj.getLong("stdItem.id");
                if (personId != gridPersonId || standardItemId != gridStdItemId) continue;
                if (paramKey.equals("position")) {
                    totalAmountMap.put(paramKey, gridObj.getString("position"));
                    continue;
                }
                if (paramKey.equals("xaxis_bizitem")) {
                    totalAmountMap.put(paramKey, AdjApprovalLittleKHelper.getXaxisBizItem(bizitemAxis, paramValeu).get(0));
                    continue;
                }
                if (!paramKey.equals("yaxis_bizitem")) continue;
                totalAmountMap.put(paramKey, AdjApprovalLittleKHelper.getYaxisBizItem(bizitemAxis, paramValeu).get(0));
            }
        }
    }

    private static List<String> getYaxisBizItem(Map<String, List<DynamicObject>> bizitemAxis, List<String> paramValeu) {
        List<DynamicObject> yaxisList = bizitemAxis.get(AxisTypeEnum.YAXIS.getCode());
        if (CollectionUtil.isNotEmpty(yaxisList)) {
            List yaxisNames = yaxisList.stream().map(obj -> {
                DynamicObject yaxisDyObj = obj.getDynamicObject("bizitem");
                if (yaxisDyObj == null) {
                    return "";
                }
                LocaleString yaxisName = LocaleString.fromMap((Map)yaxisDyObj.getLocaleString("name"));
                return yaxisName.getLocaleValue();
            }).collect(Collectors.toList());
            yaxisNames = yaxisNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
            paramValeu = yaxisNames.stream().distinct().collect(Collectors.toList());
        }
        return paramValeu;
    }

    private static List<String> getXaxisBizItem(Map<String, List<DynamicObject>> bizitemAxis, List<String> paramValeu) {
        List<DynamicObject> xaxisList = bizitemAxis.get(AxisTypeEnum.XAXIS.getCode());
        if (CollectionUtil.isNotEmpty(xaxisList)) {
            List xaxisNames = xaxisList.stream().map(obj -> {
                DynamicObject xaxisDyObj = obj.getDynamicObject("bizitem");
                if (xaxisDyObj == null) {
                    return "";
                }
                LocaleString xaxisName = LocaleString.fromMap((Map)xaxisDyObj.getLocaleString("name"));
                return xaxisName.getLocaleValue();
            }).collect(Collectors.toList());
            xaxisNames = xaxisNames.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
            paramValeu = xaxisNames.stream().distinct().collect(Collectors.toList());
        }
        return paramValeu;
    }

    public static String generateLittleKCardText(String totalAmount, String templateContent, Map<String, Map<String, List<String>>> params) {
        if (params.isEmpty()) {
            return templateContent;
        }
        Map<String, List<String>> loopResult = params.get("loopResult");
        logger.info(" loopResult :{} ", (Object)JSONObject.toJSONString(loopResult));
        Map<String, String> fparams = AdjApprovalLittleKHelper.splitLoopParam(templateContent, loopResult);
        for (Map.Entry<String, String> fparam : fparams.entrySet()) {
            String paramKey = fparam.getKey();
            String paramValue = fparam.getValue();
            templateContent = templateContent.replace("[" + paramKey + "]", paramValue);
        }
        Map<String, List<String>> simpleResult = params.get("simpleResult");
        logger.info(" simpleResult :{} ", (Object)JSONObject.toJSONString(simpleResult));
        Map<String, String> resultParams = AdjApprovalLittleKHelper.handleSimpleResult(totalAmount, simpleResult);
        for (Map.Entry<String, String> param : resultParams.entrySet()) {
            String paramKey = param.getKey();
            String paramValue = param.getValue();
            templateContent = StringUtils.replace((String)templateContent, (String)("{" + paramKey + "}"), (String)(StringUtils.isBlank((CharSequence)paramValue) ? "" : paramValue));
        }
        templateContent = StringUtils.replace((String)templateContent, (String)"[", (String)"");
        templateContent = StringUtils.replace((String)templateContent, (String)"]", (String)"");
        return templateContent;
    }

    private static Map<String, String> splitLoopParam(String templateContent, Map<String, List<String>> params) {
        HashMap templateValueList = Maps.newHashMapWithExpectedSize((int)16);
        while (templateContent.indexOf(91) >= 0) {
            if ((templateContent = templateContent.substring(templateContent.indexOf(91) + 1)).indexOf(93) <= 0) continue;
            String sx = templateContent.substring(0, templateContent.indexOf(93));
            StringBuilder temp = new StringBuilder();
            List<String> paramList = AdjApprovalLittleKHelper.collectLittleKTplParamNames(sx);
            Map<String, List<String>> extendParam = params.entrySet().stream().filter(dy -> paramList.contains(dy.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<Map<String, String>> composes = AdjApprovalLittleKHelper.getDescarteComposes(extendParam);
            for (Map<String, String> composemap : composes) {
                String wayTemp = sx;
                for (Map.Entry<String, String> compose : composemap.entrySet()) {
                    String paramKey = compose.getKey();
                    String paramValue = compose.getValue();
                    wayTemp = wayTemp.replace("{" + paramKey + "}", StringUtils.isBlank((CharSequence)paramValue) ? "" : paramValue);
                }
                temp.append(wayTemp).append("<br/>");
            }
            templateValueList.put(sx, StringUtils.isBlank((CharSequence)temp) ? sx : temp.toString());
        }
        return templateValueList;
    }

    public static List<Map<String, String>> getDescarteComposes(Map<String, List<String>> params) {
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)params.size());
        ArrayList keyList = Lists.newArrayListWithExpectedSize((int)params.size());
        LinkedHashMap avgRatioMap = Maps.newLinkedHashMapWithExpectedSize((int)params.size());
        LinkedHashMap avgAmountMap = Maps.newLinkedHashMapWithExpectedSize((int)params.size());
        LinkedHashMap totalAmountMap = Maps.newLinkedHashMapWithExpectedSize((int)params.size());
        LinkedHashMap totalPersonMap = Maps.newLinkedHashMapWithExpectedSize((int)params.size());
        for (Map.Entry<String, List<String>> param : params.entrySet()) {
            String key = param.getKey();
            List<String> paramValue = param.getValue();
            if ("avg_ratio".equals(key)) {
                avgRatioMap.put(key, paramValue);
                continue;
            }
            if ("avg_amount".equals(key)) {
                avgAmountMap.put(key, paramValue);
                continue;
            }
            if ("totalamount".equals(key)) {
                totalAmountMap.put(key, paramValue);
                continue;
            }
            if ("totalperson".equals(key)) {
                totalPersonMap.put(key, paramValue);
                continue;
            }
            if (paramValue.isEmpty()) {
                paramValue.add("");
            }
            keyList.add(key);
            valueList.add(paramValue);
        }
        List<String> descartes = AdjApprovalLittleKHelper.descartes(valueList);
        descartes = descartes.stream().distinct().collect(Collectors.toList());
        List<Object> result = Lists.newArrayListWithExpectedSize((int)descartes.size());
        for (String descarte : descartes) {
            if (!StringUtils.isNotBlank((CharSequence)descarte)) continue;
            String[] splits = descarte.split("&");
            LinkedHashMap descarteMap = Maps.newLinkedHashMapWithExpectedSize((int)1);
            for (int i = 0; i < splits.length; ++i) {
                descarteMap.put(keyList.get(i), splits[i]);
            }
            result.add(descarteMap);
        }
        logger.info(" \u7b1b\u5361\u5c14\u79ef \u5904\u7406\u3010\u5e73\u5747\u8c03\u85aa\u91d1\u989d/\u5e73\u5747\u8c03\u85aa\u6bd4\u4f8b\u3011\u4e4b\u524d = {}", (Object)JSONObject.toJSONString((Object)result));
        AdjApprovalLittleKHelper.handleAvgAmountAvgRatioCollection((List<Map<String, String>>)result, avgRatioMap, avgAmountMap);
        result = result.stream().distinct().collect(Collectors.toList());
        logger.info("  \u7b1b\u5361\u5c14\u79ef \u5904\u7406\u3010\u5e73\u5747\u8c03\u85aa\u91d1\u989d/\u5e73\u5747\u8c03\u85aa\u6bd4\u4f8b\u3011 \u548c \u3010\u53bb\u91cd\u3011 \u4e4b\u540e =  {}", (Object)JSONObject.toJSONString((Object)result));
        AdjApprovalLittleKHelper.handleTotalAmountTotalPersonCollection(result, totalAmountMap, totalPersonMap);
        return result;
    }

    private static Map<String, String> handleSimpleResult(String totalAmount, Map<String, List<String>> params) {
        Object avgRatioMap;
        String avgRatio2;
        String value;
        String key;
        LinkedHashMap resultParams = Maps.newLinkedHashMapWithExpectedSize((int)params.size());
        LinkedHashMap filterParamMap = Maps.newLinkedHashMapWithExpectedSize((int)ranKingParamKeys.size());
        for (Map.Entry<String, List<String>> param : params.entrySet()) {
            String paramKey = param.getKey();
            List<String> paramValues = param.getValue();
            if (ranKingParamKeys.contains(paramKey)) {
                filterParamMap.put(paramKey, paramValues.isEmpty() ? "" : paramValues.get(0));
            }
            String paramValue = paramValues.isEmpty() ? "" : paramValues.get(0);
            resultParams.put(paramKey, paramValue);
        }
        List<String> avgAmountList = params.get("avg_amount");
        List<String> avgRatioList = params.get("avg_ratio");
        List<String> totalAmountList = params.get("totalamount");
        List<String> totalPersonList = params.get("totalperson");
        Map avgAmountTemp = Maps.newHashMapWithExpectedSize((int)16);
        Map avgRatioTemp = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtil.isNotEmpty(avgAmountList)) {
            for (String avgAmount : avgAmountList) {
                boolean avgAmountFlag = false;
                if (!StringUtils.isNotBlank((CharSequence)avgAmount)) continue;
                Map avgAmountMap = (Map)JSON.parse((String)avgAmount);
                for (Map.Entry filterParam : filterParamMap.entrySet()) {
                    String avgAmountValue;
                    key = (String)filterParam.getKey();
                    value = (String)filterParam.getValue();
                    if (!value.equals(avgAmountValue = (String)avgAmountMap.get(key))) continue;
                    avgAmountFlag = true;
                    break;
                }
                if (!avgAmountFlag) continue;
                avgAmountTemp = avgAmountMap;
            }
        }
        if (CollectionUtil.isNotEmpty(avgRatioList)) {
            for (String avgRatio2 : avgRatioList) {
                boolean avgRatioFlag = false;
                if (!StringUtils.isNotBlank((CharSequence)avgRatio2)) continue;
                avgRatioMap = (Map)JSON.parse((String)avgRatio2);
                for (Map.Entry filterParam : filterParamMap.entrySet()) {
                    String avgRatioMapValue;
                    key = (String)filterParam.getKey();
                    value = (String)filterParam.getValue();
                    if (!value.equals(avgRatioMapValue = (String)avgRatioMap.get(key))) continue;
                    avgRatioFlag = true;
                    break;
                }
                if (!avgRatioFlag) continue;
                avgRatioTemp = avgRatioMap;
            }
        }
        String avgAmount = "";
        avgRatio2 = "";
        if (!MapUtils.isEmpty((Map)avgAmountTemp)) {
            avgAmount = (String)avgAmountTemp.get("avgAmount");
        }
        if (!MapUtils.isEmpty((Map)avgRatioTemp)) {
            avgRatio2 = (String)avgRatioTemp.get("avgRatio");
        }
        resultParams.put("avg_amount", avgAmount);
        resultParams.put("avg_ratio", avgRatio2);
        String totalamount = "";
        if (CollectionUtil.isNotEmpty(totalAmountList)) {
            avgRatioMap = totalAmountList.get(0);
        }
        resultParams.put("totalamount", totalAmount);
        String totalperson = "";
        if (CollectionUtil.isNotEmpty(totalPersonList)) {
            String totalPersonJSONString = totalPersonList.get(0);
            Map totalPerson = (Map)JSON.parse((String)totalPersonJSONString);
            totalperson = (String)totalPerson.get("bill.totalperson");
        }
        resultParams.put("totalperson", totalperson);
        return resultParams;
    }

    private static void handleTotalAmountTotalPersonCollection(List<Map<String, String>> results, Map<String, List<String>> totalAmountMap, Map<String, List<String>> totalPersonMap) {
        logger.info("AdjApprovalLittleKHelper.handleTotalAmountTotalPersonCollection \u53c2\u6570 results\uff1a{}", (Object)JSONObject.toJSONString(results));
        logger.info("AdjApprovalLittleKHelper.handleTotalAmountTotalPersonCollection \u53c2\u6570 totalAmountMap\uff1a{}", (Object)JSONObject.toJSONString(totalAmountMap));
        logger.info("AdjApprovalLittleKHelper.handleTotalAmountTotalPersonCollection \u53c2\u6570 totalPersonMap\uff1a{}", (Object)JSONObject.toJSONString(totalPersonMap));
        if (!totalAmountMap.isEmpty()) {
            List<String> totalAmountList = totalAmountMap.get("totalamount");
            HashMap<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(16);
            HashMap<Long, DynamicObject> frequencyMap = new HashMap<Long, DynamicObject>(16);
            for (int i = 0; i < results.size(); ++i) {
                DynamicObject frequencyDyObj;
                DynamicObject currencyDyObj;
                Map<String, String> result = results.get(i);
                int resultSize = result.size();
                for (String noDescartesKey : noDescartes) {
                    if (!result.containsKey(noDescartesKey)) continue;
                    --resultSize;
                }
                ArrayList<String> sumAmountStrList = new ArrayList<String>(10);
                HashMap<String, List> actualAmountMap = new HashMap<String, List>(16);
                for (String totalAmountJSONString : totalAmountList) {
                    String adjApprDetailValue;
                    String value;
                    Map totalAmount = (Map)JSON.parse((String)totalAmountJSONString);
                    String actualAmountStr = (String)totalAmount.get("actualamount");
                    int matchNum = 0;
                    for (String paramKey : detailEntParamKeys) {
                        value = (String)result.get(paramKey);
                        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)(adjApprDetailValue = (String)totalAmount.get(paramKey))) || !StringUtils.isNotBlank((CharSequence)value) || !adjApprDetailValue.equals(value)) continue;
                        ++matchNum;
                    }
                    for (String paramKey : nineGridEntParamKeys) {
                        value = (String)result.get(paramKey);
                        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)(adjApprDetailValue = (String)totalAmount.get(paramKey))) || !StringUtils.isNotBlank((CharSequence)value) || !adjApprDetailValue.equals(value)) continue;
                        ++matchNum;
                    }
                    if (matchNum != resultSize) continue;
                    currencyDyObj = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)((String)totalAmount.get("entrycurrencydyobj")), (String)"bd_currency");
                    frequencyDyObj = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)((String)totalAmount.get("entryfrequencydyobj")), (String)"hsbs_calfrequency");
                    if (currencyDyObj == null || currencyDyObj.getLong("id") == 0L || frequencyDyObj == null || frequencyDyObj.getLong("id") == 0L) continue;
                    Long currencyId = currencyDyObj.getLong("id");
                    currencyMap.put(currencyId, currencyDyObj);
                    Long frequencyId = frequencyDyObj.getLong("id");
                    frequencyMap.put(frequencyId, frequencyDyObj);
                    if (!StringUtils.isNotEmpty((CharSequence)actualAmountStr)) continue;
                    List actualAmountList = actualAmountMap.computeIfAbsent(currencyId + "_" + frequencyId, item -> Lists.newArrayList());
                    actualAmountList.add(new BigDecimal(actualAmountStr));
                }
                Iterator iterator = actualAmountMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    StringBuilder totalAmountSb = new StringBuilder();
                    Map.Entry next = iterator.next();
                    String actualAmountKey = (String)next.getKey();
                    String[] actualAmountKeyArray = actualAmountKey.split("_");
                    currencyDyObj = (DynamicObject)currencyMap.get(Long.valueOf(actualAmountKeyArray[0]));
                    frequencyDyObj = (DynamicObject)frequencyMap.get(Long.valueOf(actualAmountKeyArray[1]));
                    String sign = currencyDyObj.getString("sign");
                    String pricePrecision = currencyDyObj.getString("amtprecision");
                    String frequencyName = frequencyDyObj.getString("name");
                    BigDecimal sumAmount = AdjApprovalLittleKHelper.sum((List)next.getValue());
                    String formatAmount = AdjApprovalGridHelper.formatAmountValue(sumAmount, currencyDyObj, Integer.parseInt(pricePrecision));
                    totalAmountSb.append(formatAmount).append('/').append(frequencyName);
                    sumAmountStrList.add(totalAmountSb.toString());
                }
                if (sumAmountStrList.size() > 0) {
                    Collections.sort(sumAmountStrList);
                    result.put("totalamount", String.join((CharSequence)"+", sumAmountStrList));
                    continue;
                }
                result.put("totalamount", "0");
            }
        }
        if (!totalPersonMap.isEmpty()) {
            List<String> totalPersonList = totalPersonMap.get("totalperson");
            for (int i = 0; i < results.size(); ++i) {
                Map<String, String> result = results.get(i);
                int resultSize = result.size();
                for (String noDescartesKey : noDescartes) {
                    if (!result.containsKey(noDescartesKey)) continue;
                    --resultSize;
                }
                List<Object> adjFileNumberList = Lists.newArrayList();
                for (String totalPersonJSONString : totalPersonList) {
                    String adjApprDetailValue;
                    String value;
                    Map totalPerson = (Map)JSON.parse((String)totalPersonJSONString);
                    String adjfileNumberStr = MapUtils.isEmpty((Map)totalPerson) ? "" : (String)totalPerson.get("adjfile.number");
                    int matchNum = 0;
                    for (String paramKey : detailEntParamKeys) {
                        value = result.get(paramKey);
                        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)(adjApprDetailValue = (String)totalPerson.get(paramKey))) || !adjApprDetailValue.equals(value)) continue;
                        ++matchNum;
                    }
                    for (String paramKey : nineGridEntParamKeys) {
                        value = result.get(paramKey);
                        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)(adjApprDetailValue = (String)totalPerson.get(paramKey))) || !adjApprDetailValue.equals(value)) continue;
                        ++matchNum;
                    }
                    if (matchNum != resultSize) continue;
                    adjFileNumberList.add(adjfileNumberStr);
                }
                adjFileNumberList = adjFileNumberList.stream().distinct().collect(Collectors.toList());
                result.put("totalperson", String.valueOf(adjFileNumberList.size()));
            }
        }
    }

    private static void handleAvgAmountAvgRatioCollection(List<Map<String, String>> results, Map<String, List<String>> avgRatioMap, Map<String, List<String>> avgAmountMap) {
        ArrayList groups = Lists.newArrayListWithExpectedSize((int)results.size());
        List<String> avgRatioList = avgRatioMap.get("avg_ratio");
        List<String> avgAmountList = avgAmountMap.get("avg_amount");
        if (results.size() == 0) {
            return;
        }
        int size = results.get(0).size();
        if (CollectionUtil.isNotEmpty(avgRatioList)) {
            for (String avgRatioJSONString : avgRatioList) {
                Map avgRatio = (Map)JSON.parse((String)avgRatioJSONString);
                String avgRatioStr = MapUtils.isEmpty((Map)avgRatio) ? "" : (String)avgRatio.get("avgRatio");
                for (int i = 0; i < results.size(); ++i) {
                    Map<String, String> result = results.get(i);
                    String avgRatioStrTemp = avgRatioStr;
                    StringBuilder arGroupKey = new StringBuilder();
                    HashMap avgRatioMatchMap = Maps.newHashMapWithExpectedSize((int)3);
                    int matchNum = 0;
                    for (String paramKey : ranKingParamKeys) {
                        String avgRatioValue;
                        String string = avgRatioValue = MapUtils.isEmpty((Map)avgRatio) ? "" : (String)avgRatio.get(paramKey);
                        String value = result.get(paramKey);
                        if (value == null) continue;
                        if (!avgRatioValue.equals(value)) {
                            avgRatioStrTemp = "";
                            continue;
                        }
                        ++matchNum;
                        arGroupKey.append(avgRatioValue);
                    }
                    if (size == matchNum && StringUtils.isNotBlank((CharSequence)avgRatioStrTemp)) {
                        avgRatioMatchMap.put("index", i);
                        if (!arGroupKey.toString().contains("arGroupKey_")) {
                            arGroupKey.insert(0, "arGroupKey_");
                        }
                        avgRatioMatchMap.put("groupKey", arGroupKey.toString());
                        avgRatioMatchMap.put("avg", avgRatioStrTemp);
                    }
                    if (!avgRatioMatchMap.isEmpty()) {
                        groups.add(avgRatioMatchMap);
                    }
                    if (!StringUtils.isEmpty((CharSequence)result.get("avg_ratio"))) continue;
                    result.put("avg_ratio", avgRatioStrTemp);
                }
            }
        }
        DynamicObject currency = null;
        if (CollectionUtil.isNotEmpty(avgAmountList)) {
            String avgAmountFirstJSONStr = avgAmountList.get(0);
            Map avgAmountFirst = (Map)JSON.parse((String)avgAmountFirstJSONStr);
            currency = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)((String)avgAmountFirst.get("panelcurrencydyobj")), (String)"bd_currency");
            for (String avgAmountJSONString : avgAmountList) {
                Map avgAmount = (Map)JSON.parse((String)avgAmountJSONString);
                String avgAmountStr = MapUtils.isEmpty((Map)avgAmount) ? "" : (String)avgAmount.get("avgAmount");
                for (int i = 0; i < results.size(); ++i) {
                    Map<String, String> result = results.get(i);
                    String avgAmountStrTemp = avgAmountStr;
                    StringBuilder aaGroupKey = new StringBuilder();
                    HashMap avgAmountMatchMap = Maps.newHashMapWithExpectedSize((int)3);
                    int matchNum = 0;
                    for (String paramKey : ranKingParamKeys) {
                        String avgAmountValue;
                        String string = avgAmountValue = MapUtils.isEmpty((Map)avgAmount) ? "" : (String)avgAmount.get(paramKey);
                        String value = result.get(paramKey);
                        if (value == null) continue;
                        if (!avgAmountValue.equals(value)) {
                            avgAmountStrTemp = "";
                            continue;
                        }
                        ++matchNum;
                        aaGroupKey.append(avgAmountValue);
                    }
                    if (size == matchNum && StringUtils.isNotBlank((CharSequence)avgAmountStrTemp)) {
                        avgAmountMatchMap.put("index", i);
                        if (!aaGroupKey.toString().contains("aaGroupKey_")) {
                            aaGroupKey.insert(0, "aaGroupKey_");
                        }
                        avgAmountMatchMap.put("groupKey", aaGroupKey.toString());
                        avgAmountMatchMap.put("avg", avgAmountStrTemp);
                    }
                    if (!avgAmountMatchMap.isEmpty()) {
                        groups.add(avgAmountMatchMap);
                    }
                    if (!StringUtils.isEmpty((CharSequence)result.get("avg_amount"))) continue;
                    result.put("avg_amount", avgAmountStrTemp);
                }
            }
        }
        ArrayList groupResults = new ArrayList();
        NumberFormat num = NumberFormat.getPercentInstance();
        num.setMinimumFractionDigits(2);
        Map<String, List<Map>> glist = groups.stream().collect(Collectors.groupingBy(map -> map.get("groupKey").toString()));
        glist.forEach((key, slist) -> {
            Double avg = slist.stream().collect(Collectors.averagingDouble(objectMap -> {
                try {
                    if (key.startsWith("aaGroupKey_")) {
                        String avgValue = pattern2.matcher(objectMap.get("avg").toString()).replaceAll("").trim();
                        return Double.parseDouble(avgValue);
                    }
                    if (key.startsWith("arGroupKey_")) {
                        return num.parse(objectMap.get("avg").toString()).doubleValue();
                    }
                }
                catch (ParseException e1) {
                    logger.debug(e1.getMessage());
                }
                return Double.parseDouble("0");
            }));
            slist.forEach(objectMap -> {
                HashMap nmap = new HashMap();
                nmap.put("groupKey", objectMap.get("groupKey"));
                nmap.put("index", objectMap.get("index"));
                nmap.put("avg", avg);
                groupResults.add(nmap);
            });
        });
        if (CollectionUtil.isNotEmpty(groupResults)) {
            for (Map groupResult : groupResults) {
                Double avg;
                int index = (Integer)groupResult.get("index");
                String groupKey = (String)groupResult.get("groupKey");
                Map<String, String> resultMap = results.get(index);
                if (groupKey.startsWith("arGroupKey_")) {
                    avg = (Double)groupResult.get("avg");
                    resultMap.put("avg_ratio", num.format(avg));
                    continue;
                }
                if (!groupKey.startsWith("aaGroupKey_")) continue;
                avg = (Double)groupResult.get("avg");
                String avgAmount = AdjApprovalGridHelper.formatAmountValue(BigDecimal.valueOf(avg), currency);
                resultMap.put("avg_amount", avgAmount);
            }
        }
    }

    private static List<String> descartes(List<List<String>> lists) {
        int removeIndexFrom = lists.size() - 1;
        while (true) {
            int count = AdjApprovalLittleKHelper.preCalcDescartesCount(lists);
            logger.info("descartes count={}", (Object)count);
            if (count <= 1024 || removeIndexFrom < 0 || removeIndexFrom > lists.size() - 1) break;
            logger.info("remove index from.");
            AdjApprovalLittleKHelper.removeOneByRound(lists, removeIndexFrom--);
            if (removeIndexFrom >= 0) continue;
            removeIndexFrom = lists.size() - 1;
        }
        List<String> tempList = new ArrayList<String>();
        for (List<String> list : lists) {
            if (tempList.isEmpty()) {
                tempList = list;
                continue;
            }
            tempList = tempList.stream().flatMap(item -> list.stream().map(item2 -> {
                if (StringUtils.isBlank((CharSequence)item2)) {
                    item2 = " ";
                }
                return item + "&" + item2;
            })).collect(Collectors.toList());
        }
        return tempList;
    }

    private static int preCalcDescartesCount(List<List<String>> lists) {
        int sum = 1;
        for (List<String> list : lists) {
            sum *= list.size();
        }
        return sum;
    }

    private static void removeOneByRound(List<List<String>> lists, int index) {
        List<String> values = lists.get(index);
        if (values.size() > 1) {
            values.remove(values.size() - 1);
        }
    }

    private static Map<String, List<DynamicObject>> getBizitemAxis(DynamicObjectCollection nineGridCol) {
        if (CollectionUtil.isEmpty((Collection)nineGridCol)) {
            return Maps.newHashMap();
        }
        HashMap bizitemAxis = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList xAxis = Lists.newArrayListWithExpectedSize((int)nineGridCol.size());
        ArrayList yAxis = Lists.newArrayListWithExpectedSize((int)nineGridCol.size());
        Set decisionConfigIds = nineGridCol.stream().map(nineGrid -> nineGrid.getLong("adjdecisioncfg.id")).collect(Collectors.toCollection(() -> new HashSet(16)));
        DynamicObject[] axisDatas = AxisDataConfigHelper.queryAxisDataByCfgId(new ArrayList<Long>(decisionConfigIds));
        Map axisDataMap = Arrays.stream(axisDatas).collect(Collectors.groupingBy(axisData -> axisData.getLong("adjsalauxdcsncfg.id"), () -> new HashMap(decisionConfigIds.size()), Collectors.toCollection(() -> new ArrayList(10))));
        for (DynamicObject nineGrid2 : nineGridCol) {
            List axisData2 = (List)axisDataMap.get(nineGrid2.getLong("adjdecisioncfg.id"));
            if (axisData2 == null) continue;
            for (DynamicObject axisObj : axisData2) {
                String axis = axisObj.getString("axis");
                if (AxisTypeEnum.XAXIS.getCode().equals(axis)) {
                    xAxis.add(axisObj);
                    continue;
                }
                if (!AxisTypeEnum.YAXIS.getCode().equals(axis)) continue;
                yAxis.add(axisObj);
            }
        }
        bizitemAxis.put(AxisTypeEnum.XAXIS.getCode(), xAxis);
        bizitemAxis.put(AxisTypeEnum.YAXIS.getCode(), yAxis);
        return bizitemAxis;
    }

    private static List<DynamicObject> queryAdjFileInfoData(Set<Long> adjFileIds) {
        if (adjFileIds.isEmpty()) {
            return Lists.newArrayList();
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        DynamicObject[] objects = serviceHelper.query("id, org.name, country.name, depcytype.name", new QFilter[]{new QFilter("id", "in", adjFileIds)});
        return Arrays.asList(objects);
    }

    public static Map<Long, DynamicObject> queryEmpJobRel(Set<Long> employeeIds) {
        if (employeeIds.isEmpty()) {
            return Maps.newHashMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_empjobrel");
        DynamicObject[] objects = service.query("id,joblevel.id, joblevel.name, jobgrade.id, jobgrade.name, employee.id", new QFilter[]{new QFilter("employee", "in", employeeIds), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("businessstatus", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
        return Arrays.stream(objects).collect(Collectors.toMap(object -> object.getLong("employee.id"), Function.identity(), (key1, key2) -> key1));
    }

    public static BigDecimal ifNullSetZero(BigDecimal value) {
        if (value != null) {
            return value;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal sum(List<BigDecimal> value) {
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < value.size(); ++i) {
            result = result.add(AdjApprovalLittleKHelper.ifNullSetZero(value.get(i)));
        }
        return result;
    }

    static {
        ranKingParamKeys.add("dy_adminorg");
        ranKingParamKeys.add("dy_job");
        ranKingParamKeys.add("dy_joblevel");
        ranKingParamKeys.add("dy_jobgrade");
        ranKingParamKeys.add("position");
        ranKingParamKeys.add("dy_standarditem");
        detailEntParamKeys = Sets.newHashSetWithExpectedSize((int)10);
        detailEntParamKeys.add("dy_company");
        detailEntParamKeys.add("dy_adminorg");
        detailEntParamKeys.add("dy_position");
        detailEntParamKeys.add("dy_job");
        detailEntParamKeys.add("dy_joblevel");
        detailEntParamKeys.add("dy_jobgrade");
        detailEntParamKeys.add("dy_standarditem");
        nineGridEntParamKeys = Sets.newHashSetWithExpectedSize((int)10);
        nineGridEntParamKeys.add("position");
        nineGridEntParamKeys.add("xaxis_bizitem");
        nineGridEntParamKeys.add("yaxis_bizitem");
        noDescartes = new String[]{"avg_ratio", "avg_amount", "totalamount", "totalperson"};
    }
}

