/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.enums.AdjImportAnnotationType;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.formplugin.imports.DynamicEntryImportStartEdit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class AdjBillEntryImpHelper {
    private static Log logger = LogFactory.getLog(AdjBillEntryImpHelper.class);
    private static String preFix = "dy_";
    private static String showNameCol = "dy_standarditem,dy_grade,dy_rank";
    private static String changeToMustInputField = "dy_number";
    private static String noMustInputField = "dy_salbsed,dy_frequency";
    private static String annotationField = "dy_frequency,dy_grade,dy_rank,dy_calctype,dy_actualrange,dy_actualamount";
    private static SWCDataServiceHelper employeeService = new SWCDataServiceHelper("hrpi_employee");
    private static SWCDataServiceHelper structService = new SWCDataServiceHelper("hcdm_salaystructure");
    private static SWCDataServiceHelper stdTableService = new SWCDataServiceHelper("hcdm_salarystandard");
    private static SWCDataServiceHelper adjFileService = new SWCDataServiceHelper("hcdm_adjfileinfo");
    private static SWCDataServiceHelper frequencyService = new SWCDataServiceHelper("hsbs_calfrequency");
    private static String fixSalaryCol = "number,name,adjfile,standarditem,grade,rank,amount,issend,salbsed,remark,frequency,currency";
    private static String adjSalaryCol = "number,name,adjfile,standarditem,calctype,currency,suggestminrange,suggestmaxrange,suggestminamount,suggestmaxamount,actualrange,actualamount,amount,salbsed,reason,frequency";
    private static String adjfileInfoProp = "id,employee,employee.empnumber,employee.id,person,person.name,person.id,depemp,depemp.id,status,iscurrentversion,datastatus,number,empposorgrel,empposorgrel.company,empposorgrel.adminorg,boid,bsled,org,salaystructure,salaystructure.id,stdscm,stdscm.id,stdscm.name,stdscm.sourcevid,country,country.id,empgroup,depcytype,assoadminorg,sourcevid";

    @Deprecated
    public static void importTempleExcludeCol(String salaryadjrsnType, List<EntryColumnContainer> containers) {
    }

    public static String getSalaryadjrsnType(EventObject event) {
        String billPageId;
        IFormView view = ((DynamicEntryImportStartEdit)event.getSource()).getView();
        DynamicObject salaryAdjRsn = (DynamicObject)view.getViewNoPlugin(billPageId = (String)((DynamicEntryImportStartEdit)event.getSource()).getView().getFormShowParameter().getCustomParam("entryview")).getModel().getValue("salaryadjrsn");
        if (salaryAdjRsn == null) {
            return AdjAttributionType.DECATTRTYPE.getCode();
        }
        return salaryAdjRsn.getString("attributiontype");
    }

    public static DynamicObject[] getSalayStructure(Set<Long> structIds) {
        QFilter filter = new QFilter("id", "in", structIds);
        return structService.query("id,name,entryentity,entryentity.standarditem", new QFilter[]{filter});
    }

    public static Map<Long, String> getStdTableIdToNameMap(Set<Long> ids) {
        DynamicObject[] dyns = stdTableService.query("id,name", new QFilter[]{new QFilter("id", "in", ids)});
        Map<Long, String> resultMap = Arrays.stream(dyns).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getString("name"), (k1, k2) -> k1));
        return resultMap;
    }

    public static DynamicObject[] getFrequencyByName(Set<String> names) {
        QFilter filter = new QFilter("name", "in", names);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = frequencyService.query("name,type,coefficient,areatype,country,country.id", new QFilter[]{filter});
        return dynamicObjects;
    }

    public static Map<Long, Map<Long, Boolean>> getUseRankFlag(Map<Long, Map<Long, SalaryStdMatchResultNew>> resultMap) {
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)resultMap.size());
        for (Map.Entry<Long, Map<Long, SalaryStdMatchResultNew>> entry : resultMap.entrySet()) {
            Map<Long, SalaryStdMatchResultNew> subMap = entry.getValue();
            for (Map.Entry<Long, SalaryStdMatchResultNew> subEntry : subMap.entrySet()) {
                SalaryStdMatchResultNew ssr = subEntry.getValue();
                if (!ObjectUtils.isNotEmpty((Object)ssr) || !ObjectUtils.isNotEmpty((Object)ssr.getStdTableVid()) || ssr.getStdTableVid() <= 0L) continue;
                List list = stdItemMap.computeIfAbsent(ssr.getStdTableVid(), val -> Lists.newArrayListWithCapacity((int)8));
                list.add(subEntry.getKey());
            }
        }
        SalaryStdApplicationService saStdService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        Map<Long, Map<Long, Boolean>> isOpenRankMap = saStdService.getSalaryItemUseRankFlag(stdItemMap);
        return isOpenRankMap;
    }

    public static DynamicObject[] getEmployeeByEmpnumber(Set<String> employeeNumbers) {
        QFilter filter = new QFilter("empnumber", "in", employeeNumbers);
        DynamicObject[] dynamicObjects = employeeService.query("empnumber, person.id, person.name,iscurrentversion,datastatus", new QFilter[]{filter});
        return dynamicObjects;
    }

    public static DynamicObject[] getAdjFileList(Long orgId, Set<Long> employeeIds, QFilter[] adjFilePermFilter) {
        Object[] allFilter = new QFilter[]{};
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        qFilter.and("employee.id", "in", employeeIds);
        qFilter.and("status", "in", (Object)CommonHcdmBizHelper.VALIDATE_STATUS);
        logger.info("import adjFileNumber qFilter:{}", (Object)JSON.toJSONString((Object)qFilter));
        allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])adjFilePermFilter)) {
            logger.info("import adjFileNumber permissionFilter:{}", (Object)JSON.toJSONString((Object)adjFilePermFilter));
            allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])adjFilePermFilter);
        }
        logger.info("import adjFileNumber allFilter:{}", (Object)JSON.toJSONString((Object)allFilter));
        return adjFileService.query(adjfileInfoProp, (QFilter[])allFilter);
    }

    public static void reDrawColProperty(SXSSFWorkbook wb, String salaryadjrsnType) {
        Font redFont = wb.createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        Font blackFont = wb.createFont();
        blackFont.setColor(IndexedColors.BLACK.getIndex());
        blackFont.setBold(false);
        blackFont.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"AdjBillEntryImpHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]));
        SXSSFSheet sheet = wb.getSheetAt(wb.getActiveSheetIndex());
        SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
        SXSSFRow twoRow = sheet.getRow(1);
        AdjBillEntryImpHelper.setVerticalAndHorizonStyle(sheet);
        AdjBillEntryImpHelper.setColStyle(wb, sheet);
        SXSSFRow fieldNameRow = sheet.getRow(4);
        SXSSFRow fieldRow = sheet.getRow(2);
        int cellColNum = fieldRow.getPhysicalNumberOfCells();
        for (int i = 0; i < cellColNum; ++i) {
            CellStyle cellStyle;
            SXSSFCell cell = fieldNameRow.getCell(i);
            if (cell == null) continue;
            String colName = cell.getStringCellValue();
            String field = fieldRow.getCell(i).getStringCellValue();
            if (StringUtils.isNotBlank((CharSequence)colName) && StringUtils.isNotBlank((CharSequence)field) && annotationField.contains(field)) {
                String annotationKey = field;
                if ("dy_grade,dy_rank".contains(field) && AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType)) {
                    annotationKey = field + "_dec";
                }
                if ("dy_grade,dy_rank".contains(field) && AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType)) {
                    annotationKey = field + "_adj";
                }
                String comStr = AdjImportAnnotationType.getDisplayNameByCode(annotationKey);
                Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 3, cell.getRowIndex() + 6, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 3, cell.getRowIndex() + 6));
                comment.setString((RichTextString)new XSSFRichTextString(comStr));
                comment.setAuthor("kindee");
                cell.setCellComment(comment);
            }
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType)) {
                SXSSFCell twoCell;
                if (StringUtils.isNotBlank((CharSequence)field) && field.equals("dy_frequency")) {
                    twoCell = twoRow.getCell(i);
                    if (twoCell == null) {
                        twoCell = twoRow.createCell(i);
                    }
                    twoCell.setCellValue(ResManager.loadKDString((String)"\u9891\u5ea6\u3001\u85aa\u7b49\u3001\u85aa\u6863\u662f\u5426\u5fc5\u586b\u8bf7\u53c2\u8003\u6279\u6ce8\u4fe1\u606f\u3002", (String)"AdjBillEntryImpHelper_3", (String)"swc-hcdm-business", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)field) && field.equals("dy_standarditem")) {
                    twoCell = twoRow.getCell(i);
                    if (twoCell == null) {
                        twoCell = twoRow.createCell(i);
                    }
                    twoCell.setCellValue(ResManager.loadKDString((String)"\u8bf7\u5c06\u540c\u4e00\u4e2a\u4eba\u5458\u591a\u6761\u5b9a\u85aa\u4fe1\u606f\u653e\u5728\u4e00\u8d77\uff0c\u4e14\u53ea\u9700\u5728\u7b2c\u4e00\u6761\u8bb0\u5f55\u4e2d\u586b\u5199\u5de5\u53f7\u6216\u5b9a\u8c03\u85aa\u6863\u6848\u7f16\u53f7\u3002", (String)"AdjBillEntryImpHelper_4", (String)"swc-hcdm-business", (Object[])new Object[0]));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)colName) && changeToMustInputField.contains(field) && !colName.contains("*")) {
                cellStyle = cell.getCellStyle();
                cell.setCellValue("*" + colName);
                cellStyle.setFont(redFont);
            }
            if (StringUtils.isNotBlank((CharSequence)colName) && noMustInputField.contains(field) && colName.contains("*")) {
                cellStyle = cell.getCellStyle();
                cell.setCellValue(colName.substring(1));
                cellStyle.setFont(blackFont);
            }
            if (!AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType) || !StringUtils.isNotBlank((CharSequence)colName) || !"dy_amount".contains(field) || !colName.contains("*")) continue;
            cellStyle = cell.getCellStyle();
            cell.setCellValue(colName.substring(1));
            cellStyle.setFont(blackFont);
        }
    }

    private static void setVerticalAndHorizonStyle(SXSSFSheet sheet) {
        SXSSFRow megreRow = sheet.getRow(3);
        for (int i = 0; i < megreRow.getPhysicalNumberOfCells(); ++i) {
            SXSSFCell cell = megreRow.getCell(i);
            if (cell == null) continue;
            CellStyle style = cell.getCellStyle();
            style.setAlignment(HorizontalAlignment.CENTER);
        }
    }

    private static void setColStyle(SXSSFWorkbook wb, SXSSFSheet sheet) {
        DataFormat fmt = wb.createDataFormat();
        CellStyle colCellStyle = wb.createCellStyle();
        colCellStyle.setDataFormat(fmt.getFormat("@"));
        SXSSFRow fieldRow = sheet.getRow(2);
        int colIndexs = sheet.getRow(4).getPhysicalNumberOfCells();
        for (int i = 0; i < colIndexs; ++i) {
            String field = fieldRow.getCell(i).getStringCellValue();
            if (StringUtils.isNotBlank((CharSequence)field) && field.equals("dy_salbsed")) continue;
            sheet.setDefaultColumnStyle(i, colCellStyle);
        }
    }

    private static String getSplitName() {
        return ResManager.loadKDString((String)".\u540d\u79f0", (String)"AdjBillEntryImpHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
    }

    public static FormShowParameter showProgressForm(IFormView view, Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("hcdm_adjentryimporting");
        showParameter.setCustomParams(customParams);
        view.showForm(showParameter);
        return showParameter;
    }

    public static Map<String, Set<Long>> getStdSourceVids(Map<Long, Map<Long, SalaryStdMatchResultNew>> resultMap) {
        HashMap<String, Set<Long>> souceVidMap = new HashMap<String, Set<Long>>(16);
        if (MapUtils.isEmpty(resultMap)) {
            return souceVidMap;
        }
        HashSet stdTableVids = Sets.newHashSetWithExpectedSize((int)resultMap.size());
        HashSet stdCoeffVids = Sets.newHashSetWithExpectedSize((int)resultMap.size());
        for (Map.Entry<Long, Map<Long, SalaryStdMatchResultNew>> entry : resultMap.entrySet()) {
            Map<Long, SalaryStdMatchResultNew> subMap = entry.getValue();
            for (Map.Entry<Long, SalaryStdMatchResultNew> subEntry : subMap.entrySet()) {
                stdTableVids.add(subEntry.getValue().getStdTableVid());
                stdCoeffVids.add(subEntry.getValue().getCoefficientVid());
            }
        }
        souceVidMap.put("stdTableVid", stdTableVids);
        souceVidMap.put("coefficientVid", stdCoeffVids);
        return souceVidMap;
    }

    public static DynamicObject queryAdjBillById(Long fid) {
        SWCDataServiceHelper adjBillService = new SWCDataServiceHelper("hcdm_adjapprbill");
        return adjBillService.queryOne("id,billno,salaryadjrsn.attributiontype,country,country.id,effectivedate,currency,currency.id,exctable,exctable.id,exchangeratedate,stditem,stditem.id", new QFilter[]{new QFilter("id", "=", (Object)fid)});
    }

    public static DynamicObject[] queryAdjPersonByBillId(Long billId) {
        SWCDataServiceHelper adjBillService = new SWCDataServiceHelper("hcdm_adjapprperson");
        return adjBillService.loadDynamicObjectArray(new QFilter[]{new QFilter("adjapprbill", "=", (Object)billId)});
    }

    public static Map<Long, Map<Long, DynamicObject>> getLastAdjInfo(Map<Long, Set<Long>> fileItemSetMap) {
        AdjFileApplicationService service = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        Map<Long, Map<Long, DynamicObject>> latestDecAdjSalary = service.getLatestDecAdjSalary("id,standarditem.id,salaryadjfile.id,datastatus,enable,bsed,salarystd,grade,rank,currency,amount,frequency,salarypercent,salaryseeprate,amountstdrange", fileItemSetMap);
        logger.info("get last adj info, fileItemSetMap={}, latestDecAdjSalary size={}", (Object)JSON.toJSONString(fileItemSetMap), (Object)latestDecAdjSalary.size());
        return latestDecAdjSalary;
    }

    public static Map<Long, DynamicObject> getStdTableInfo(Set<Long> sourcevidList) {
        SWCDataServiceHelper stdTableService = new SWCDataServiceHelper("hcdm_salarystandard");
        DynamicObject[] tabelDynas = stdTableService.query("id,sourcevid,currency,currency.id,frequency,frequency.id", new QFilter[]{new QFilter("id", "in", sourcevidList)});
        return Arrays.stream(tabelDynas).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (dy1, dy2) -> dy1));
    }

    public static Map<Long, DynamicObject> getCoefficientInfo(Set<Long> sourcevidList) {
        SWCDataServiceHelper stdTableService = new SWCDataServiceHelper("hcdm_coefficient");
        DynamicObject[] tabelDynas = stdTableService.query("id,sourcevid,coefficientvalue", new QFilter[]{new QFilter("id", "in", sourcevidList)});
        return Arrays.stream(tabelDynas).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (dy1, dy2) -> dy1));
    }

    public static Map<Long, Map<Long, SalaryStdMatchResultNew>> getMatchStdResult(List<MatchStdTableWithAdjFileParam> paramList) {
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Long, Map<Long, SalaryStdMatchResultNew>> stdMatchResult = adjApprovalApplicationService.batchMatchStdTable(paramList);
        return stdMatchResult;
    }

    public static DynamicObject[] queryDynamicObjByFilter(String entity, String selectProperties, QFilter[] qFilters) {
        SWCDataServiceHelper stdTableService = new SWCDataServiceHelper(entity);
        return stdTableService.query(selectProperties, qFilters);
    }

    public static DynamicObject[] getDynamicEntryData(IFormView entryView) {
        DynamicObject[] rows = new DynamicObject[]{};
        try {
            EntryGrid grid = (EntryGrid)entryView.getControl("adjapprdetailentry");
            Method getRowCount = ReflectionUtils.findMethod(grid.getClass(), (String)"getRowCount");
            ReflectionUtils.makeAccessible((Method)getRowCount);
            int rowCount = (Integer)getRowCount.invoke((Object)grid, new Object[0]);
            logger.info(" getDynamicEntryData  getRowCount is:", (Object)rowCount);
            Method getEntryDataDbEntities = ReflectionUtils.findMethod(grid.getClass(), (String)"getEntryDataDbEntities", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
            ReflectionUtils.makeAccessible((Method)getEntryDataDbEntities);
            rows = (DynamicObject[])getEntryDataDbEntities.invoke((Object)grid, 0, rowCount);
        }
        catch (Exception exc) {
            logger.error(" getDynamicEntryData error: ", (Throwable)exc);
        }
        return rows;
    }

    public static String removeAster(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains("*")) {
            return fileName.substring(fileName.indexOf("*") + 1);
        }
        return fileName;
    }
}

