/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.adjfieldcfg.AdjDetailFieldMappingHelper;
import kd.swc.hcdm.business.adjapprbill.entity.ExRateKey;
import kd.swc.hcdm.business.adjapprbill.entity.FileBeanForAddPerson;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.salarystandard.ContrastConfigHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.entityservice.SalaryStdTabService;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryParam;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryResult;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.constants.DecAdjApprConstants;
import kd.swc.hcdm.common.entity.adjapprbill.AddFileReturnData;
import kd.swc.hcdm.common.enums.CalcSceneType;
import kd.swc.hcdm.common.enums.ConfirmStatusEnum;
import kd.swc.hcdm.common.enums.DecAdjSynStatusEnum;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class AdjPersonPackageHelper {
    private static Log logger = LogFactory.getLog(AdjPersonPackageHelper.class);
    private static SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
    private static final String adjApprPerSelectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjapprperson");
    public static final String adjFilePropType = "adjFilePropType";
    public static final String stdItemPropType = "stdItemPropType";
    public static final String coefficientPropType = "coefficientPropType";
    public static final String billEntryEntityType = "billEntryEntityType";
    public static final String CACHE_ADD_ADJ_PERSON_PARAM_KEY = "add_adj_person_param_%s";
    public static final String ADD_ADJ_PERSON_BEAN = "add_adj_person_bean";
    public static final String ADD_ADJ_PERSON_BIG_TASK_NUMBER = "swc_hcdm_adjaddperson";
    public static final long MAX_SAL_REL_SIZE = 40000000L;
    public static final int BATCH_SIZE = 500;
    public static final String CALLBACKID_CLOSE_ADJPRO = "callbackid_close_adjpro";
    public static final String salaryAdjRecordProps = "id,standarditem.id,salaryadjfile.id,datastatus,enable,bsed,salarystd,grade,rank,currency,amount,frequency,salarypercent,salaryseeprate,amountstdrange";

    public static List<DynamicObject> setDecAdjApprEntryInfo(List<Object> subPartPkIds, List<FileBeanForAddPerson> fileBeans, DynamicObject billDy, Map<String, Object> dynamicObjectTypeMap, Map<String, List<Long>> itemMap) {
        List<DynamicObject> adjPersonNoMatchStdItemList;
        DynamicObjectType adjFilePropType = (DynamicObjectType)dynamicObjectTypeMap.get(adjFilePropType);
        Map<Object, DynamicObject> fileObjMap = AdjPersonPackageHelper.loadReferenceDataBatch(adjFilePropType, subPartPkIds.toArray());
        fileObjMap.values().forEach(fileObj -> fileBeans.add(new FileBeanForAddPerson(fileObj.getString("number"))));
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap((EntityType)dynamicObjectTypeMap.get(billEntryEntityType));
        Set<String> entryPropertySet = apprBillEntryPropertyMap.keySet();
        String attributionType = DecAdjApprGridHelper.getAttributionType(billDy);
        List<AddFileReturnData> addFileReturnDataList = DecAdjApprGridHelper.getAddAdjFileReturnData(fileObjMap);
        HashSet<Object> adjFileIdSet = new HashSet<Object>(500);
        adjFileIdSet.addAll(fileObjMap.keySet());
        if (MapUtils.isNotEmpty(itemMap) && itemMap.containsKey("stdItemChange")) {
            List<Long> itemIdList = itemMap.get("stdItemChange");
            if (!CollectionUtils.isEmpty(itemIdList)) {
                addFileReturnDataList.removeIf(item -> !itemIdList.contains(item.getStandardItemId()));
            } else {
                DynamicObjectCollection stdItemList = billDy.getDynamicObjectCollection("stditem");
                List stdItemIdList = stdItemList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
                addFileReturnDataList.removeIf(item -> !stdItemIdList.contains(item.getStandardItemId()));
                if (CollectionUtils.isEmpty(addFileReturnDataList)) {
                    return new ArrayList<DynamicObject>(10);
                }
            }
        } else {
            DynamicObjectCollection stdItemList = billDy.getDynamicObjectCollection("stditem");
            List stdItemIdList = stdItemList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            addFileReturnDataList.removeIf(item -> !stdItemIdList.contains(item.getStandardItemId()));
            Set leftAdjFileIdSet = addFileReturnDataList.stream().map(item -> item.getAdjFileId()).collect(Collectors.toSet());
            adjFileIdSet.removeAll(leftAdjFileIdSet);
        }
        DynamicObject[] adjPersonDyObjs = AdjPersonPackageHelper.getAdjPersonDyObjs(billDy, subPartPkIds);
        Set<String> adjFileToItemDbMap = AdjPersonPackageHelper.getAdjFileToItemDbMap(adjPersonDyObjs);
        Map<Long, DynamicObject> adjPersonMap = Arrays.stream(adjPersonDyObjs).collect(Collectors.toMap(obj -> obj.getLong("adjfile.id"), Function.identity()));
        Date date = new Date();
        List<DynamicObject> adjApprPersonList = AdjPersonPackageHelper.packageAdjApprPersonList(fileObjMap, adjFileToItemDbMap, adjPersonMap, entryPropertySet, addFileReturnDataList, date, billDy, dynamicObjectTypeMap);
        if (MapUtils.isEmpty(itemMap) && !CollectionUtils.isEmpty(adjPersonNoMatchStdItemList = AdjPersonPackageHelper.packageAdjApprPersonNoMatchStdItemList(fileObjMap, adjPersonMap, adjFileIdSet, entryPropertySet, date, billDy))) {
            adjApprPersonList.addAll(adjPersonNoMatchStdItemList);
        }
        AdjPersonPackageHelper.setAdjApprPersonListOne(billDy, dynamicObjectTypeMap, attributionType, addFileReturnDataList, adjApprPersonList);
        return adjApprPersonList;
    }

    private static void setAdjApprPersonListOne(DynamicObject billDy, Map<String, Object> dynamicObjectTypeMap, String attributionType, List<AddFileReturnData> addFileReturnDataList, List<DynamicObject> adjApprPersonList) {
        long exctableId = billDy.getLong("exctable.id");
        Date rateDate = billDy.getDate("exchangeratedate");
        Date defaultBsedDate = billDy.getDate("effectivedate");
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap((EntityType)dynamicObjectTypeMap.get(billEntryEntityType));
        Set<String> entryPropertySet = apprBillEntryPropertyMap.keySet();
        Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = AdjPersonPackageHelper.getMatchStdResult(addFileReturnDataList, defaultBsedDate);
        AdjPersonPackageHelper.setStdRelationInfo(matchStdResult, adjApprPersonList, entryPropertySet, billDy, dynamicObjectTypeMap);
        AdjPersonPackageHelper.setMatchResultRangeData(matchStdResult, adjApprPersonList, entryPropertySet);
        AdjPersonPackageHelper.setGradeAndRankRelationInfo(matchStdResult, adjApprPersonList, entryPropertySet, attributionType, billDy, CalcSceneType.ADD_PERSON);
        AdjPersonPackageHelper.setLastAdjInfo(addFileReturnDataList, adjApprPersonList, entryPropertySet, attributionType);
        AdjPersonPackageHelper.setAdjApprPersonListTwo(attributionType, adjApprPersonList, exctableId, rateDate, apprBillEntryPropertyMap, entryPropertySet, matchStdResult);
    }

    private static void setAdjApprPersonListTwo(String attributionType, List<DynamicObject> adjApprPersonList, long exctableId, Date rateDate, Map<String, IDataEntityProperty> apprBillEntryPropertyMap, Set<String> entryPropertySet, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = AdjPersonPackageHelper.getStdAmountQueryResult(adjApprPersonList);
        AdjPersonPackageHelper.setStdAmountRelationInfo(adjApprPersonList, salaryStdAmountQueryResult, entryPropertySet, CalcSceneType.ADD_PERSON);
        AdjPersonPackageHelper.setFinalAmountRelationInfo(adjApprPersonList, entryPropertySet, exctableId, rateDate, CalcSceneType.ADD_PERSON);
        AdjPersonPackageHelper.setActualAmountOrRatioWithAmount(adjApprPersonList, entryPropertySet, attributionType, exctableId, rateDate);
        AdjPersonPackageHelper.setSalaryPercentAndSeepRateInfo(adjApprPersonList, salaryStdAmountQueryResult, entryPropertySet, exctableId, rateDate, CalcSceneType.ADD_PERSON);
        AdjPersonPackageHelper.setAdjApprPersonListThree(attributionType, adjApprPersonList, exctableId, rateDate, apprBillEntryPropertyMap, entryPropertySet, matchStdResult);
    }

    private static void setAdjApprPersonListThree(String attributionType, List<DynamicObject> adjApprPersonList, long exctableId, Date rateDate, Map<String, IDataEntityProperty> apprBillEntryPropertyMap, Set<String> entryPropertySet, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        AdjPersonPackageHelper.setOverStandardType(adjApprPersonList, entryPropertySet, attributionType, exctableId, rateDate);
        AdjPersonPackageHelper.setGradeAndRankByStdScmMatchStrategy(matchStdResult, adjApprPersonList, entryPropertySet, CalcSceneType.ADD_PERSON);
        Set<Long> personIdSet = adjApprPersonList.stream().map(item -> item.getLong("person.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> entryDateMap = DecAdjApprGridHelper.getEntryDate(personIdSet);
        Map<Long, DynamicObject> realRegularDateMap = DecAdjApprGridHelper.getRealRegularDate(personIdSet);
        Map<Long, DynamicObject> contrWorkLocMap = DecAdjApprGridHelper.getContrWorkLoc(personIdSet);
        Map<Long, DynamicObject> baseLocationcMap = DecAdjApprGridHelper.getBaseLocation(personIdSet);
        AdjPersonPackageHelper.setTrialPeriodInfo(entryDateMap, realRegularDateMap, adjApprPersonList, entryPropertySet);
        AdjPersonPackageHelper.setContrWorkLocInfo(contrWorkLocMap, baseLocationcMap, adjApprPersonList, entryPropertySet);
        Map<String, Long> adjDetailFieldToContrastCfg = AdjDetailFieldMappingHelper.getAdjDetailFieldToContrastCfg();
        Map<Long, List<Object>> contrastCfgIdToIdMap = AdjPersonPackageHelper.getMulBaseDataConstrastCfgIdToIdMap(matchStdResult);
        Map<String, Object> mulBaseDataPropertyToDynamicObjMap = AdjPersonPackageHelper.getMulBaseDataPropertyToDynamicObjMap(apprBillEntryPropertyMap, adjDetailFieldToContrastCfg, contrastCfgIdToIdMap);
        AdjPersonPackageHelper.setPersonRelationInfo(matchStdResult, adjApprPersonList, adjDetailFieldToContrastCfg, mulBaseDataPropertyToDynamicObjMap, apprBillEntryPropertyMap);
        AdjPersonPackageHelper.setPersonOtherInfo(adjDetailFieldToContrastCfg, adjApprPersonList, apprBillEntryPropertyMap);
        AdjPersonPackageHelper.setContrastCfgNotShowOnEntry(matchStdResult, adjDetailFieldToContrastCfg, adjApprPersonList, apprBillEntryPropertyMap);
        AdjPersonPackageHelper.convertAttrDataToAdjPerson(adjApprPersonList);
    }

    private static List<DynamicObject> packageAdjApprPersonNoMatchStdItemList(Map<Object, DynamicObject> fileObjMap, Map<Long, DynamicObject> adjPersonMap, Set<Object> adjFileIdSet, Set<String> entryPropertySet, Date date, DynamicObject billDy) {
        ArrayList<DynamicObject> adjApprPersonList = new ArrayList<DynamicObject>(fileObjMap.size());
        if (!CollectionUtils.isEmpty(adjFileIdSet)) {
            String attributionType = DecAdjApprGridHelper.getAttributionType(billDy);
            Object pkValue = billDy.getPkValue();
            DynamicObject adjApprPerson = null;
            for (Object adjFileId : adjFileIdSet) {
                DynamicObject adjPersonDyObj = adjPersonMap.get(adjFileId);
                if (Objects.isNull(adjPersonDyObj)) {
                    DynamicObject adjFileDynamicObj = fileObjMap.get(adjFileId);
                    adjApprPerson = serviceHelper.generateEmptyDynamicObject();
                    adjApprPerson.set("adjapprbill", pkValue);
                    AdjPersonPackageHelper.setFileRelationInfo(adjFileDynamicObj, adjApprPerson, entryPropertySet);
                    adjApprPerson.set("createtime", (Object)date);
                    adjApprPerson.set("updatetime", (Object)date);
                } else {
                    adjApprPerson = adjPersonDyObj;
                }
                DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
                DynamicObject adjApprPersonEntryDyObj = null;
                adjApprPersonEntryDyObj = Objects.isNull(adjPersonDyObj) ? serviceHelper.generateEmptyEntryDynamicObject("entryentity") : serviceHelper.generateEmptyEntryDynamicObject(adjApprPerson, "entryentity");
                if (entryPropertySet.contains("salbsed")) {
                    adjApprPersonEntryDyObj.set("salbsed", billDy.get("effectivedate"));
                }
                if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) && entryPropertySet.contains("calctype")) {
                    String calcType = billDy.getString("caltype");
                    adjApprPersonEntryDyObj.set("calctype", (Object)calcType);
                }
                adjApprPersonEntryList.add((Object)adjApprPersonEntryDyObj);
                adjApprPersonList.add(adjApprPerson);
            }
        }
        return adjApprPersonList;
    }

    public static void setGradeAndRankByStdScmMatchStrategy(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, CalcSceneType sceneType) {
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            if (MapUtils.isEmpty(matchStdResult.get(adjFileId))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long personEntryId = adjApprPersonEntry.getLong("id");
                if (CalcSceneType.ADD_PERSON.getCode().equals(sceneType.getCode()) && personEntryId > 0L) continue;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = matchStdResult.get(adjFileId).get(standardItemId);
                if (Objects.isNull(salaryStdMatchResult) || MapUtils.isEmpty((Map)salaryStdMatchResult.getRangeData())) continue;
                String isMatchGradeRank = salaryStdMatchResult.getIsMatchGradeRank();
                if (!SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) {
                    if (entryPropertySet.contains("grade")) {
                        adjApprPersonEntry.set("grade", null);
                    }
                    if (entryPropertySet.contains("rank")) {
                        adjApprPersonEntry.set("rank", null);
                    }
                }
                if (!Objects.isNull(salaryStdMatchResult.getGradeId()) && 0L != salaryStdMatchResult.getGradeId()) continue;
                if (entryPropertySet.contains("salarypercent")) {
                    adjApprPersonEntry.set("salarypercent", null);
                }
                if (!entryPropertySet.contains("salaryseeprate")) continue;
                adjApprPersonEntry.set("salaryseeprate", null);
            }
        }
    }

    private static DynamicObject[] getAdjPersonDyObjs(DynamicObject billModel) {
        QFilter[] qFilters = new QFilter[]{new QFilter("adjapprbill", "=", (Object)billModel.getLong("id"))};
        return serviceHelper.query(adjApprPerSelectProperties, qFilters);
    }

    private static DynamicObject[] getAdjPersonDyObjs(DynamicObject billModel, List<Object> subPartPkIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("adjapprbill", "=", (Object)billModel.getLong("id")), new QFilter("adjfile.id", "in", subPartPkIds)};
        return serviceHelper.query(adjApprPerSelectProperties, qFilters);
    }

    public static void setLastAdjInfo(List<AddFileReturnData> addFileReturnDataList, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, String attributionType) {
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
            return;
        }
        Map<Long, List<Long>> fileItemListMap = AdjPersonPackageHelper.getFileItemMap(addFileReturnDataList);
        HashMap fileItemSetMap = Maps.newHashMapWithExpectedSize((int)fileItemListMap.size());
        for (Map.Entry<Long, List<Long>> entry : fileItemListMap.entrySet()) {
            fileItemSetMap.put(entry.getKey(), Sets.newHashSet((Iterable)entry.getValue()));
        }
        AdjFileApplicationService service = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        Map<Long, Map<Long, DynamicObject>> latestDecAdjSalary = service.getLatestDecAdjSalary(salaryAdjRecordProps, fileItemSetMap);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                Map<Long, DynamicObject> itemLastSalaryObjs = latestDecAdjSalary.get(adjFileId);
                if (adjFileId <= 0L || itemLastSalaryObjs == null) continue;
                DynamicObject lastSalaryObj = itemLastSalaryObjs.get(standardItemId);
                if (standardItemId <= 0L || lastSalaryObj == null) continue;
                if (entryPropertySet.contains("presalarystd")) {
                    adjApprPersonEntry.set("presalarystd", (Object)lastSalaryObj.getDynamicObject("salarystd"));
                }
                if (entryPropertySet.contains("pregrade")) {
                    adjApprPersonEntry.set("pregrade", (Object)lastSalaryObj.getDynamicObject("grade"));
                }
                if (entryPropertySet.contains("prerank")) {
                    adjApprPersonEntry.set("prerank", (Object)lastSalaryObj.getDynamicObject("rank"));
                }
                if (entryPropertySet.contains("precurrency")) {
                    adjApprPersonEntry.set("precurrency", (Object)lastSalaryObj.getDynamicObject("currency"));
                }
                if (entryPropertySet.contains("presalary")) {
                    adjApprPersonEntry.set("presalary", (Object)lastSalaryObj.getBigDecimal("amount"));
                }
                if (entryPropertySet.contains("prefrequency")) {
                    adjApprPersonEntry.set("prefrequency", (Object)lastSalaryObj.getDynamicObject("frequency"));
                }
                if (entryPropertySet.contains("presalarypercent")) {
                    adjApprPersonEntry.set("presalarypercent", (Object)lastSalaryObj.getBigDecimal("salarypercent"));
                }
                if (entryPropertySet.contains("presalaryseeprate")) {
                    adjApprPersonEntry.set("presalaryseeprate", (Object)lastSalaryObj.getBigDecimal("salaryseeprate"));
                }
                if (!entryPropertySet.contains("preamountstdrange")) continue;
                adjApprPersonEntry.set("preamountstdrange", (Object)lastSalaryObj.getString("amountstdrange"));
            }
        }
    }

    private static Set<String> getAdjFileToItemDbMap(DynamicObject[] adjPersonDyObjs) {
        HashSet<String> adjFileToItemDbMap = new HashSet<String>(16);
        for (DynamicObject adjPersonDyObj : adjPersonDyObjs) {
            Long adjFileId = adjPersonDyObj.getLong("adjfile.id");
            DynamicObjectCollection adjPersonDyEntryList = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjPersonDyEntry : adjPersonDyEntryList) {
                Long standardItemId = adjPersonDyEntry.getLong("standarditem.id");
                adjFileToItemDbMap.add(String.format("%s_%s", adjFileId, standardItemId));
            }
        }
        return adjFileToItemDbMap;
    }

    public static void setOverStandardType(List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, String attributionType, long exctableId, Date rateDate) {
        BillExRateManager rateManager = new BillExRateManager();
        List<List<DynamicObject>> adjApprPersonLists = AdjPersonPackageHelper.intelligentBatchCalculator(adjApprPersonList);
        for (List<DynamicObject> apprPersonList : adjApprPersonLists) {
            List<StdOverStandardQueryParam> params = AdjPersonPackageHelper.setStdOverStandParam(apprPersonList, attributionType, exctableId, rateDate, rateManager);
            if (CollectionUtils.isEmpty(params)) continue;
            logger.info("getOverStandardType params size = {}", (Object)params.size());
            List<StdOverStandardQueryResult> overStandardQueryResults = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).getOverStandardType(params);
            Map<String, StdOverStandardQueryResult> stdOverStandardQueryResultMap = overStandardQueryResults.stream().collect(Collectors.toMap(StdOverStandardQueryResult::getUnionId, Function.identity()));
            if (MapUtils.isEmpty(stdOverStandardQueryResultMap)) continue;
            AdjPersonPackageHelper.setOverStandard(entryPropertySet, apprPersonList, stdOverStandardQueryResultMap);
        }
    }

    private static void setOverStandard(Set<String> entryPropertySet, List<DynamicObject> apprPersonList, Map<String, StdOverStandardQueryResult> queryResultMap) {
        for (DynamicObject adjApprPerson : apprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                String unionId = String.format("%s_%s", adjFileId, standardItemId);
                StdOverStandardQueryResult stdOverStandardQueryResult = queryResultMap.get(unionId);
                if (stdOverStandardQueryResult == null) continue;
                String overStandardType = stdOverStandardQueryResult.getOverStandardTypeEnum().getCode();
                if (!entryPropertySet.contains("overstandardtype")) continue;
                adjApprPersonEntry.set("overstandardtype", (Object)overStandardType);
            }
        }
    }

    private static List<StdOverStandardQueryParam> setStdOverStandParam(List<DynamicObject> adjApprPersonList, String attributionType, long exctableId, Date rateDate, BillExRateManager rateManager) {
        ArrayList<StdOverStandardQueryParam> params = new ArrayList<StdOverStandardQueryParam>(10);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long preCurrencyId;
                boolean isMatchSetOverStdTypeFlag = true;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                String excessControl = adjApprPersonEntry.getString("excesscontrol");
                if (StringUtils.isEmpty((String)excessControl)) continue;
                DynamicObject salaryStdDyObj = adjApprPersonEntry.getDynamicObject("salarystd");
                long coefficientVid = adjApprPersonEntry.getLong("coefficient.id");
                long adjCurrencyId = adjApprPersonEntry.getLong("currency.id");
                long stdCurrencyId = 0L;
                stdCurrencyId = AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) ? ((preCurrencyId = Long.valueOf(adjApprPersonEntry.getLong("precurrency.id"))) == null || preCurrencyId <= 0L ? adjApprPersonEntry.getLong("salarystd.currency.id") : preCurrencyId.longValue()) : adjApprPersonEntry.getLong("salarystd.currency.id");
                BigDecimal amount = adjApprPersonEntry.getBigDecimal("amount");
                String salaryToGradeAndRankRel = adjApprPersonEntry.getString("salargrel");
                if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                    if (Objects.isNull(salaryStdDyObj) || amount == null) {
                        isMatchSetOverStdTypeFlag = false;
                    }
                } else if (Objects.isNull(salaryStdDyObj) || amount == null || !Objects.isNull(salaryStdDyObj) && StringUtils.isEmpty((String)salaryToGradeAndRankRel)) {
                    isMatchSetOverStdTypeFlag = false;
                }
                if (!isMatchSetOverStdTypeFlag) continue;
                ExchangeRateInfo exchangeRate = DecAdjApprGridHelper.getExchangeRate(rateManager, adjCurrencyId, stdCurrencyId, exctableId, rateDate);
                BigDecimal finalAmountOfStdCurrency = DecAdjApprGridHelper.convertAmountByExrate(exchangeRate, amount, adjCurrencyId, stdCurrencyId);
                logger.info("set adj cal info adjFileId={}, standardItemId={}, excessControl={}, amount={}, adjCurrencyId={}, stdCurrencyId={}, exchangeRate={}, finalAmountOfStdCurrency={}, coefficientVid={}", new Object[]{adjFileId, standardItemId, excessControl, amount, adjCurrencyId, stdCurrencyId, exchangeRate, finalAmountOfStdCurrency, coefficientVid});
                if (finalAmountOfStdCurrency == null) continue;
                String unionId = String.format("%s_%s", adjFileId, standardItemId);
                StdOverStandardQueryParam stdOverStandardQueryParam = new StdOverStandardQueryParam();
                stdOverStandardQueryParam.setCoefficientId(coefficientVid);
                Map personRange = (Map)JSON.parseObject((String)salaryToGradeAndRankRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                stdOverStandardQueryParam.setPersonRange(personRange);
                stdOverStandardQueryParam.setTabId(salaryStdDyObj.getLong("id"));
                stdOverStandardQueryParam.setItemId(standardItemId);
                stdOverStandardQueryParam.setUnionId(unionId);
                stdOverStandardQueryParam.setAmount(finalAmountOfStdCurrency);
                params.add(stdOverStandardQueryParam);
            }
        }
        return params;
    }

    public static List<List<DynamicObject>> intelligentBatchCalculator(List<DynamicObject> adjApprPersonList) {
        if (adjApprPersonList == null || adjApprPersonList.isEmpty()) {
            return new ArrayList<List<DynamicObject>>(10);
        }
        ArrayList<List<DynamicObject>> result = new ArrayList<List<DynamicObject>>(10);
        ArrayList<DynamicObject> firstBatch = new ArrayList<DynamicObject>(500);
        long strSize = 0L;
        int size = 1;
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            firstBatch.add(adjApprPerson);
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                String str = adjApprPersonEntry.getString("salargrel");
                if (str == null) continue;
                strSize += (long)str.length();
            }
            if (strSize < 40000000L) continue;
            ++size;
            strSize = 0L;
            result.add(firstBatch);
            firstBatch = new ArrayList(100);
        }
        if (result.size() < size) {
            result.add(firstBatch);
        }
        logger.info("intelligentBatchCalculator cal person list size = {} ", (Object)result.size());
        return result;
    }

    private static void setPersonOtherInfo(Map<String, Long> adjDetailFieldToContrastCfg, List<DynamicObject> adjApprPersonList, Map<String, IDataEntityProperty> apprBillEntryPropertyMap) {
        Set<String> adjDetailFieldSet = adjDetailFieldToContrastCfg.keySet();
        apprBillEntryPropertyMap.keySet().removeIf(item -> !adjDetailFieldSet.contains(item));
        Set<String> personProperties = apprBillEntryPropertyMap.keySet();
        HashSet adjDetailFields = new HashSet(16);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Set nullValueProperties = personProperties.stream().filter(item -> Objects.isNull(adjApprPerson.get(item))).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(nullValueProperties)) continue;
            adjDetailFields.addAll(nullValueProperties);
        }
        Set adjFileIdSet = adjApprPersonList.stream().map(item -> item.getLong("adjfile.id")).collect(Collectors.toSet());
        Map<Long, ContrastPropConfigEntity> allContrastConfigMap = ContrastConfigHelper.getAllContrastConfigMap();
        List<ContrastPropConfigEntity> propConfigEntities = adjDetailFields.stream().map(item -> (ContrastPropConfigEntity)allContrastConfigMap.get(adjDetailFieldToContrastCfg.get(item))).collect(Collectors.toList());
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Long, Map<Long, Object>> contrastPropValueMap = adjApprovalApplicationService.getContrastPropValue(propConfigEntities, new ArrayList<Long>(adjFileIdSet), true);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            Map<Long, Object> contrastPropValue = contrastPropValueMap.get(adjFileId);
            for (String adjDetailField : adjDetailFields) {
                Object value;
                if (!MapUtils.isNotEmpty(contrastPropValue) || (value = contrastPropValue.get(adjDetailFieldToContrastCfg.get(adjDetailField))) == null || apprBillEntryPropertyMap.get(adjDetailField) == null) continue;
                adjApprPerson.set(adjDetailField, value);
            }
        }
    }

    private static List<DynamicObject> packageAdjApprPersonList(Map<Object, DynamicObject> fileObjMap, Set<String> adjFileToItemDbMap, Map<Long, DynamicObject> adjPersonMap, Set<String> entryPropertySet, List<AddFileReturnData> addFileReturnDataList, Date date, DynamicObject billDy, Map<String, Object> dynamicObjectTypeMap) {
        String attributionType = DecAdjApprGridHelper.getAttributionType(billDy);
        Map<Long, List<AddFileReturnData>> addFileReturnDataMap = addFileReturnDataList.stream().collect(Collectors.groupingBy(AddFileReturnData::getAdjFileId));
        List stdItemList = addFileReturnDataList.stream().distinct().map(AddFileReturnData::getStandardItemId).collect(Collectors.toList());
        DynamicObjectType stdItemPropType = (DynamicObjectType)dynamicObjectTypeMap.get(stdItemPropType);
        Map<Object, DynamicObject> stdItemObjMap = AdjPersonPackageHelper.loadReferenceDataBatch(stdItemPropType, stdItemList.toArray());
        Object pkValue = billDy.getPkValue();
        ArrayList<DynamicObject> adjApprPersonList = new ArrayList<DynamicObject>(fileObjMap.size());
        for (Map.Entry<Long, List<AddFileReturnData>> addFileReturnDataEntry : addFileReturnDataMap.entrySet()) {
            Long adjFileId = addFileReturnDataEntry.getKey();
            DynamicObject adjPersonDyObj = adjPersonMap.get(adjFileId);
            DynamicObject adjApprPerson = null;
            if (Objects.isNull(adjPersonDyObj)) {
                DynamicObject adjFileDynamicObj = fileObjMap.get(adjFileId);
                adjApprPerson = serviceHelper.generateEmptyDynamicObject();
                adjApprPerson.set("adjapprbill", pkValue);
                AdjPersonPackageHelper.setFileRelationInfo(adjFileDynamicObj, adjApprPerson, entryPropertySet);
                adjApprPerson.set("createtime", (Object)date);
            } else {
                adjApprPerson = adjPersonDyObj;
            }
            adjApprPerson.set("updatetime", (Object)date);
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            Date maxBsled = SWCDateTimeUtils.getMaxBsled();
            for (AddFileReturnData addFileReturnData : addFileReturnDataEntry.getValue()) {
                DynamicObject adjApprPersonEntry = null;
                adjApprPersonEntry = Objects.isNull(adjPersonDyObj) ? serviceHelper.generateEmptyEntryDynamicObject("entryentity") : serviceHelper.generateEmptyEntryDynamicObject(adjApprPerson, "entryentity");
                if (entryPropertySet.contains("standarditem")) {
                    String adjFileStdItemKey = String.format("%s_%s", addFileReturnData.getAdjFileId(), addFileReturnData.getStandardItemId());
                    if (adjFileToItemDbMap.contains(adjFileStdItemKey)) {
                        adjApprPersonEntry.set("standarditem", null);
                    } else {
                        adjApprPersonEntry.set("standarditem", (Object)stdItemObjMap.get(addFileReturnData.getStandardItemId()));
                    }
                }
                if (entryPropertySet.contains("excesscontrol")) {
                    adjApprPersonEntry.set("excesscontrol", (Object)addFileReturnData.getExcessControl());
                }
                if (entryPropertySet.contains("salbsed")) {
                    adjApprPersonEntry.set("salbsed", billDy.get("effectivedate"));
                }
                adjApprPersonEntry.set("salbsled", (Object)maxBsled);
                if (entryPropertySet.contains("ismatchgraderank")) {
                    adjApprPersonEntry.set("ismatchgraderank", (Object)addFileReturnData.getisMatchGradeRank());
                }
                if (entryPropertySet.contains("matchstrategy")) {
                    adjApprPersonEntry.set("matchstrategy", (Object)addFileReturnData.getMatchStrategy());
                }
                if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) && entryPropertySet.contains("calctype")) {
                    String calcType = billDy.getString("caltype");
                    adjApprPersonEntry.set("calctype", (Object)calcType);
                }
                adjApprPersonEntryList.add((Object)adjApprPersonEntry);
            }
            adjApprPersonList.add(adjApprPerson);
        }
        return adjApprPersonList;
    }

    public static void setSalaryPercentAndSeepRateInfo(List<DynamicObject> adjApprPersonList, List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult, Set<String> entryPropertySet, long exctableId, Date rateDate, CalcSceneType sceneType) {
        BillExRateManager rateManager = new BillExRateManager();
        Map<String, StdAmountAndSalaryCountQueryResult> salaryCountQueryResultMap = salaryStdAmountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity(), (key1, key2) -> key1));
        logger.info("setSalaryPercentAndSeepRateInfo salaryCountQueryResultMap result is={}", (Object)JSON.toJSONString(salaryCountQueryResultMap));
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long personEntryId = adjApprPersonEntry.getLong("id");
                if (CalcSceneType.ADD_PERSON.getCode().equals(sceneType.getCode()) && personEntryId > 0L) continue;
                AdjPersonPackageHelper.doSetSalaryPercentAndSeepRateInfo(entryPropertySet, exctableId, rateDate, rateManager, salaryCountQueryResultMap, adjFileId, adjApprPersonEntry);
            }
        }
    }

    public static void doSetSalaryPercentAndSeepRateInfo(Set<String> entryPropertySet, long exctableId, Date rateDate, BillExRateManager rateManager, Map<String, StdAmountAndSalaryCountQueryResult> salaryCountQueryResultMap, Long adjFileId, DynamicObject adjApprPersonEntry) {
        Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
        long currencyId = adjApprPersonEntry.getLong("currency.id");
        long stdCurrencyId = adjApprPersonEntry.getLong("salarystd.currency.id");
        long coefficientVid = adjApprPersonEntry.getLong("coefficient.id");
        Object gradeObj = adjApprPersonEntry.get("grade");
        Long gradeId = gradeObj instanceof Long ? (Long)gradeObj : (Objects.isNull(gradeObj) ? 0L : ((DynamicObject)gradeObj).getLong("id"));
        Object rankObj = adjApprPersonEntry.get("rank");
        Long rankId = rankObj instanceof Long ? (Long)rankObj : (Objects.isNull(rankObj) ? 0L : ((DynamicObject)rankObj).getLong("id"));
        Long salaryStdId = adjApprPersonEntry.getLong("salarystd.id");
        if (standardItemId == 0L || salaryStdId == 0L || gradeId == 0L) {
            return;
        }
        String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
        StdAmountAndSalaryCountQueryResult stdAmountQueryResult = salaryCountQueryResultMap.get(unionId);
        if (stdAmountQueryResult == null) {
            return;
        }
        BigDecimal intervalMin = stdAmountQueryResult.getGradeMinAmount();
        BigDecimal intervalMax = stdAmountQueryResult.getGradeMaxAmount();
        BigDecimal middleValue = stdAmountQueryResult.getGradeMiddleAmount();
        BigDecimal amount = adjApprPersonEntry.getBigDecimal("amount");
        BigDecimal coefficientValue = AdjPersonPackageHelper.getCoefficientValue(adjApprPersonEntry);
        BigDecimal stdIntervalMin = intervalMin == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate(rateManager, intervalMin, amount, stdCurrencyId, currencyId, exctableId, rateDate, true);
        BigDecimal stdIntervalMax = intervalMax == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate(rateManager, intervalMax, amount, stdCurrencyId, currencyId, exctableId, rateDate, true);
        BigDecimal stdMiddleValue = middleValue == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate(rateManager, middleValue, amount, stdCurrencyId, currencyId, exctableId, rateDate, true);
        BigDecimal salaryPercent = SalaryStdCalculateHelper.calcSalaryRatioNew(amount, stdMiddleValue, coefficientValue);
        BigDecimal salarySeeprate = SalaryStdCalculateHelper.calcSalaryPermeability(amount, stdIntervalMin, stdIntervalMax, coefficientValue);
        logger.info("setSalaryPercentAndSeepRateInfo adjFileId={}, standardItemId={}, currencyId={}, stdCurrencyId={}, gradeId={}, rankId={}, salaryStdId={}, intervalMin={}, intervalMax={}, middleValue={}, amount={}, stdIntervalMin={}, stdIntervalMax={}, stdMiddleValue={}, salaryPercent={}, salarySeeprate={}, coefficientVid={}, coefficientValue={}", new Object[]{adjFileId, standardItemId, currencyId, stdCurrencyId, gradeId, rankId, salaryStdId, intervalMin, intervalMax, middleValue, amount, stdIntervalMin, stdIntervalMax, stdMiddleValue, salaryPercent, salarySeeprate, coefficientVid, coefficientValue});
        if (entryPropertySet.contains("salarypercent")) {
            adjApprPersonEntry.set("salarypercent", (Object)salaryPercent);
        }
        if (entryPropertySet.contains("salaryseeprate")) {
            adjApprPersonEntry.set("salaryseeprate", (Object)salarySeeprate);
        }
        if (entryPropertySet.contains(DecAdjApprConstants.KEY_INTERVALMIN)) {
            adjApprPersonEntry.set(DecAdjApprConstants.KEY_INTERVALMIN, (Object)stdIntervalMin);
        }
        if (entryPropertySet.contains(DecAdjApprConstants.KEY_INTERVALMAX)) {
            adjApprPersonEntry.set(DecAdjApprConstants.KEY_INTERVALMAX, (Object)stdIntervalMax);
        }
        if (entryPropertySet.contains(DecAdjApprConstants.KEY_INTERVALMIDDLE)) {
            adjApprPersonEntry.set(DecAdjApprConstants.KEY_INTERVALMIDDLE, (Object)stdMiddleValue);
        }
    }

    public static void setStdAmountRelationInfo(List<DynamicObject> adjApprPersonList, List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult, Set<String> entryPropertySet, CalcSceneType sceneType) {
        Map<String, StdAmountAndSalaryCountQueryResult> salaryCountQueryResultMap = salaryStdAmountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity(), (key1, key2) -> key1));
        logger.info("setStdAmountRelationInfo salaryCountQueryResultMap result is={}", (Object)JSON.toJSONString(salaryCountQueryResultMap));
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long personEntryId = adjApprPersonEntry.getLong("id");
                if (CalcSceneType.ADD_PERSON.getCode().equals(sceneType.getCode()) && personEntryId > 0L) continue;
                AdjPersonPackageHelper.doSetStdAmountRelationInfo(entryPropertySet, salaryCountQueryResultMap, adjFileId, adjApprPersonEntry);
            }
        }
    }

    public static void doSetStdAmountRelationInfo(Set<String> entryPropertySet, Map<String, StdAmountAndSalaryCountQueryResult> salaryCountQueryResultMap, Long adjFileId, DynamicObject adjApprPersonEntry) {
        Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
        Object gradeObj = adjApprPersonEntry.get("grade");
        Long gradeId = gradeObj instanceof Long ? (Long)gradeObj : (Objects.isNull(gradeObj) ? 0L : ((DynamicObject)gradeObj).getLong("id"));
        Object rankObj = adjApprPersonEntry.get("rank");
        Long rankId = rankObj instanceof Long ? (Long)rankObj : (Objects.isNull(rankObj) ? 0L : ((DynamicObject)rankObj).getLong("id"));
        Long salaryStdId = adjApprPersonEntry.getLong("salarystd.id");
        String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
        String calType = adjApprPersonEntry.getString("calctype");
        if (standardItemId == 0L || salaryStdId == 0L || gradeId == 0L) {
            BigDecimal amount = adjApprPersonEntry.getBigDecimal("amount");
            if (!Objects.isNull(amount)) {
                adjApprPersonEntry.set(DecAdjApprConstants.KEY_AMOUNTLOGIC, (Object)amount);
            }
            return;
        }
        StdAmountAndSalaryCountQueryResult stdAmountQueryResult = salaryCountQueryResultMap.get(unionId);
        if (stdAmountQueryResult == null) {
            return;
        }
        BigDecimal standardAmountBD = stdAmountQueryResult.getAmount();
        if (entryPropertySet.contains(DecAdjApprConstants.KEY_STDAMOUNT)) {
            adjApprPersonEntry.set(DecAdjApprConstants.KEY_STDAMOUNT, (Object)standardAmountBD);
        }
        BigDecimal coefficientValue = AdjPersonPackageHelper.getCoefficientValue(adjApprPersonEntry);
        BigDecimal stdMulCoffAmount = null;
        if (standardAmountBD != null) {
            stdMulCoffAmount = coefficientValue.multiply(standardAmountBD);
        }
        logger.info("setStdAmountRelationInfo adjFileId={}, standardItemId={}, gradeId={}, rankId={}, salaryStdId={}, standardAmountBD={}, coefficientValue={}, stdMulCoffAmount={}", new Object[]{adjFileId, standardItemId, gradeId, rankId, salaryStdId, standardAmountBD, coefficientValue, stdMulCoffAmount});
        if (entryPropertySet.contains(DecAdjApprConstants.KEY_AMOUNTLOGIC)) {
            int currencyScale = adjApprPersonEntry.getInt("currency.amtprecision");
            if (stdMulCoffAmount != null) {
                stdMulCoffAmount = stdMulCoffAmount.setScale(currencyScale, 4);
            }
            BigDecimal amount = adjApprPersonEntry.getBigDecimal("amount");
            if (CalcType.RATIO.getCode().equals(calType) || CalcType.AMOUNT.getCode().equals(calType)) {
                if (!Objects.isNull(amount)) {
                    adjApprPersonEntry.set(DecAdjApprConstants.KEY_AMOUNTLOGIC, (Object)amount);
                } else {
                    adjApprPersonEntry.set(DecAdjApprConstants.KEY_AMOUNTLOGIC, (Object)stdMulCoffAmount);
                }
            } else {
                adjApprPersonEntry.set(DecAdjApprConstants.KEY_AMOUNTLOGIC, (Object)stdMulCoffAmount);
            }
        }
    }

    private static BigDecimal getCoefficientValue(DynamicObject adjApprPersonEntry) {
        DynamicObject coefficientDyobj = adjApprPersonEntry.getDynamicObject("coefficient");
        BigDecimal coefficientvalue = BigDecimal.ONE;
        if (!SWCBaseUtils.isEmpty((DynamicObject)coefficientDyobj)) {
            coefficientvalue = coefficientDyobj.getBigDecimal("coefficientvalue");
        }
        return coefficientvalue;
    }

    public static void setFinalAmountRelationInfo(List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, long exctableId, Date rateDate, CalcSceneType sceneType) {
        BillExRateManager rateManager = new BillExRateManager();
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long personEntryId = adjApprPersonEntry.getLong("id");
                if (CalcSceneType.ADD_PERSON.getCode().equals(sceneType.getCode()) && personEntryId > 0L) continue;
                AdjPersonPackageHelper.doSetFinalAmountRelationInfo(entryPropertySet, exctableId, rateDate, rateManager, adjApprPersonEntry);
            }
        }
    }

    public static void doSetFinalAmountRelationInfo(Set<String> entryPropertySet, long exctableId, Date rateDate, BillExRateManager rateManager, DynamicObject adjApprPersonEntry) {
        DynamicObject salaryStdDynamicObject = adjApprPersonEntry.getDynamicObject("salarystd");
        if (salaryStdDynamicObject == null) {
            return;
        }
        BigDecimal logicAmount = adjApprPersonEntry.getBigDecimal(DecAdjApprConstants.KEY_AMOUNTLOGIC);
        BigDecimal finalAmount = null;
        if (logicAmount != null) {
            long stdCurrency = salaryStdDynamicObject.getLong("currency.id");
            long decCurrency = adjApprPersonEntry.getLong("currency.id");
            int decCurrencyScale = adjApprPersonEntry.getInt("currency.amtprecision");
            if (stdCurrency == decCurrency) {
                finalAmount = logicAmount;
                adjApprPersonEntry.set(DecAdjApprConstants.KEY_EXRATEVALUE, null);
            } else if (stdCurrency > 0L && decCurrency > 0L) {
                if (exctableId > 0L && rateDate != null) {
                    ExchangeRateInfo exrateInfo = rateManager.getExRate(new ExRateKey(decCurrency, stdCurrency, rateDate.getTime(), exctableId));
                    if (exrateInfo != null) {
                        Boolean quoteType = exrateInfo.getQuoteType();
                        BigDecimal exchangeRate = exrateInfo.getExchangeRate();
                        if (exchangeRate != null) {
                            if (entryPropertySet.contains(DecAdjApprConstants.KEY_EXRATEVALUE)) {
                                adjApprPersonEntry.set(DecAdjApprConstants.KEY_EXRATEVALUE, (Object)exchangeRate);
                            }
                            if (entryPropertySet.contains(DecAdjApprConstants.KEY_QUOTETYPE)) {
                                adjApprPersonEntry.set(DecAdjApprConstants.KEY_QUOTETYPE, (Object)quoteType);
                            }
                        }
                    } else if (entryPropertySet.contains(DecAdjApprConstants.KEY_EXRATEVALUE)) {
                        adjApprPersonEntry.set(DecAdjApprConstants.KEY_EXRATEVALUE, null);
                    }
                }
                BigDecimal exrateValue = adjApprPersonEntry.getBigDecimal("exratevalue");
                boolean quoteType = adjApprPersonEntry.getBoolean("quotetype");
                if (exrateValue != null && exrateValue.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal exrateCurrent;
                    finalAmount = quoteType ? (exrateCurrent = logicAmount.divide(exrateValue, decCurrencyScale, 4)) : (exrateCurrent = logicAmount.multiply(exrateValue).setScale(decCurrencyScale, 4));
                }
            }
        }
        if (entryPropertySet.contains("amount")) {
            adjApprPersonEntry.set("amount", finalAmount);
        }
    }

    public static List<StdAmountAndSalaryCountQueryResult> getStdAmountQueryResult(List<DynamicObject> adjApprPersonList) {
        HashSet<StdAmountQueryParam> salaryStdAmountParams = new HashSet<StdAmountQueryParam>(10);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                Object gradeObj = adjApprPersonEntry.get("grade");
                Long gradeId = gradeObj instanceof Long ? (Long)gradeObj : (Objects.isNull(gradeObj) ? 0L : ((DynamicObject)gradeObj).getLong("id"));
                Object rankObj = adjApprPersonEntry.get("rank");
                Long rankId = rankObj instanceof Long ? (Long)rankObj : (Objects.isNull(rankObj) ? 0L : ((DynamicObject)rankObj).getLong("id"));
                Long salaryStdId = adjApprPersonEntry.getLong("salarystd.id");
                if (standardItemId == 0L || salaryStdId == 0L || gradeId == 0L) continue;
                String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
                StdAmountQueryParam stdAmountQueryParam = AdjPersonPackageHelper.buildStdAmountQueryParam(gradeId, rankId, salaryStdId, standardItemId, unionId);
                salaryStdAmountParams.add(stdAmountQueryParam);
            }
        }
        if (salaryStdAmountParams.isEmpty()) {
            return Collections.emptyList();
        }
        logger.info("getStdAmountQueryResult params is={}", (Object)JSON.toJSONString(salaryStdAmountParams));
        SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        List<StdAmountAndSalaryCountQueryResult> stdAmountAndSalaryCountQueryResults = salaryStdApplicationService.queryAmountAndSalaryCount(new ArrayList<StdAmountQueryParam>(salaryStdAmountParams));
        logger.info("getStdAmountQueryResult result is={}", (Object)JSON.toJSONString(stdAmountAndSalaryCountQueryResults));
        return stdAmountAndSalaryCountQueryResults;
    }

    public static StdAmountQueryParam buildStdAmountQueryParam(Long gradeId, Long rankId, Long salaryStdId, Long standardItemId, String unionId) {
        StdAmountQueryParam stdAmountQueryParam = new StdAmountQueryParam();
        stdAmountQueryParam.setGradeId(gradeId);
        stdAmountQueryParam.setRankId(rankId);
        stdAmountQueryParam.setStdTabId(salaryStdId);
        stdAmountQueryParam.setItemId(standardItemId);
        stdAmountQueryParam.setUnionId(unionId);
        return stdAmountQueryParam;
    }

    private static void setMatchResultRangeData(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet) {
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            if (MapUtils.isEmpty(matchStdResult.get(adjFileId))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Map rangeDataMap;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = matchStdResult.get(adjFileId).get(standardItemId);
                if (salaryStdMatchResult == null || !MapUtils.isNotEmpty((Map)(rangeDataMap = salaryStdMatchResult.getRangeData())) || !entryPropertySet.contains("salargrel")) continue;
                adjApprPersonEntry.set("salargrel", (Object)JSON.toJSONString((Object)rangeDataMap));
            }
        }
    }

    public static void setGradeAndRankRelationInfo(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, String attributionType, IDataModel billModel, CalcSceneType sceneType) {
        String calcType = billModel.getDataEntity().getString("caltype");
        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) && !CalcType.GRADE_RANK.getCode().equals(calcType)) {
            return;
        }
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            if (MapUtils.isEmpty(matchStdResult.get(adjFileId))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Map rangeDataMap;
                Long personEntryId = adjApprPersonEntry.getLong("id");
                if (CalcSceneType.ADD_PERSON.getCode().equals(sceneType.getCode()) && personEntryId > 0L) continue;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = matchStdResult.get(adjFileId).get(standardItemId);
                if (salaryStdMatchResult == null || MapUtils.isEmpty((Map)(rangeDataMap = salaryStdMatchResult.getRangeData()))) continue;
                Long gradeId = salaryStdMatchResult.getGradeId();
                if (entryPropertySet.contains("grade")) {
                    adjApprPersonEntry.set("grade", (Object)gradeId);
                }
                Long rankId = salaryStdMatchResult.getRankId();
                if (entryPropertySet.contains("rank")) {
                    adjApprPersonEntry.set("rank", (Object)rankId);
                }
                String isMatchGradeRank = salaryStdMatchResult.getIsMatchGradeRank();
                if (entryPropertySet.contains("ismatchgraderank")) {
                    adjApprPersonEntry.set("ismatchgraderank", (Object)isMatchGradeRank);
                }
                String matchStrategy = salaryStdMatchResult.getMatchStrategy();
                if (!entryPropertySet.contains("matchstrategy")) continue;
                adjApprPersonEntry.set("matchstrategy", (Object)matchStrategy);
            }
        }
    }

    public static void setGradeAndRankRelationInfo(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, String attributionType, DynamicObject billModel, CalcSceneType sceneType) {
        String calcType = billModel.getString("caltype");
        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) && !CalcType.GRADE_RANK.getCode().equals(calcType)) {
            return;
        }
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            if (MapUtils.isEmpty(matchStdResult.get(adjFileId))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Map rangeDataMap;
                Long personEntryId = adjApprPersonEntry.getLong("id");
                if (CalcSceneType.ADD_PERSON.getCode().equals(sceneType.getCode()) && personEntryId > 0L) continue;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = matchStdResult.get(adjFileId).get(standardItemId);
                if (salaryStdMatchResult == null || MapUtils.isEmpty((Map)(rangeDataMap = salaryStdMatchResult.getRangeData()))) continue;
                Long gradeId = salaryStdMatchResult.getGradeId();
                if (entryPropertySet.contains("grade")) {
                    adjApprPersonEntry.set("grade", (Object)gradeId);
                }
                Long rankId = salaryStdMatchResult.getRankId();
                if (entryPropertySet.contains("rank")) {
                    adjApprPersonEntry.set("rank", (Object)rankId);
                }
                String isMatchGradeRank = salaryStdMatchResult.getIsMatchGradeRank();
                if (entryPropertySet.contains("ismatchgraderank")) {
                    adjApprPersonEntry.set("ismatchgraderank", (Object)isMatchGradeRank);
                }
                String matchStrategy = salaryStdMatchResult.getMatchStrategy();
                if (!entryPropertySet.contains("matchstrategy")) continue;
                adjApprPersonEntry.set("matchstrategy", (Object)matchStrategy);
            }
        }
    }

    private static void setStdRelationInfo(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, DynamicObject billModel, Map<String, Object> dynamicObjectTypeMap) {
        HashSet<Long> stdTableVidSet = new HashSet<Long>(16);
        HashSet<Long> coefficientIdSet = new HashSet<Long>(16);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            Map<Long, SalaryStdMatchResultNew> salaryStdMatchResultMap = matchStdResult.get(adjFileId);
            if (MapUtils.isEmpty(matchStdResult.get(adjFileId))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = salaryStdMatchResultMap.get(standardItemId);
                if (Objects.isNull(salaryStdMatchResult)) continue;
                stdTableVidSet.add(salaryStdMatchResult.getStdTableVid());
                coefficientIdSet.add(salaryStdMatchResult.getCoefficientVid());
            }
        }
        DynamicObjectType coefficientPropType = (DynamicObjectType)dynamicObjectTypeMap.get(coefficientPropType);
        Map<Object, DynamicObject> coefficientObjMap = AdjPersonPackageHelper.loadReferenceDataBatch(coefficientPropType, coefficientIdSet.toArray());
        Map<Long, DynamicObject> stdMap = new SalaryStdTabService().queryStdObj(stdTableVidSet);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            if (MapUtils.isEmpty(matchStdResult.get(adjApprPerson.getLong("adjfile.id")))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long personEntryId = adjApprPersonEntry.getLong("id");
                if (personEntryId > 0L) continue;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = matchStdResult.get(adjApprPerson.getLong("adjfile.id")).get(standardItemId);
                if (Objects.isNull(salaryStdMatchResult)) continue;
                Long stdTableVid = salaryStdMatchResult.getStdTableVid();
                DynamicObject salaryStdDynamicObject = stdMap.get(stdTableVid);
                if (salaryStdDynamicObject != null) {
                    if (entryPropertySet.contains("salarystd")) {
                        adjApprPersonEntry.set("salarystd", (Object)salaryStdDynamicObject);
                    }
                    if (entryPropertySet.contains("frequency")) {
                        adjApprPersonEntry.set("frequency", (Object)salaryStdDynamicObject.getDynamicObject("frequency"));
                    }
                }
                if (salaryStdMatchResult.getCoefficientVid() != null && entryPropertySet.contains("coefficient")) {
                    adjApprPersonEntry.set("coefficient", (Object)coefficientObjMap.get(salaryStdMatchResult.getCoefficientVid()));
                }
                if (!entryPropertySet.contains("currency")) continue;
                adjApprPersonEntry.set("currency", billModel.get("currency"));
            }
        }
    }

    private static void setContrastCfgNotShowOnEntry(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, Map<String, Long> adjDetailFieldToContrastCfg, List<DynamicObject> adjApprPersonList, Map<String, IDataEntityProperty> apprBillEntryPropertyMap) {
        Set<String> billEntryPropertySet = apprBillEntryPropertyMap.keySet();
        adjDetailFieldToContrastCfg.keySet().removeIf(item -> billEntryPropertySet.contains(item));
        if (MapUtils.isEmpty(adjDetailFieldToContrastCfg)) {
            return;
        }
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            HashMap<String, List<Object>> personAttrValueMap = new HashMap<String, List<Object>>(16);
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            Map<Long, SalaryStdMatchResultNew> stdMatchResultMap = matchStdResult.get(adjFileId);
            if (MapUtils.isEmpty(stdMatchResultMap)) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Map personPropValueMap;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = stdMatchResultMap.get(standardItemId);
                if (Objects.isNull(salaryStdMatchResult) || MapUtils.isEmpty((Map)(personPropValueMap = salaryStdMatchResult.getPersonPropValue()))) continue;
                for (Map.Entry<String, Long> subEntry : adjDetailFieldToContrastCfg.entrySet()) {
                    String adjDetailFieldKey = subEntry.getKey();
                    Long contrastCfgSetId = subEntry.getValue();
                    Object personPropValueObj = personPropValueMap.get(contrastCfgSetId);
                    if (Objects.isNull(personPropValueObj)) continue;
                    if (apprBillEntryPropertyMap.get(adjDetailFieldKey) instanceof MulBasedataProp) {
                        List mulBaseDataIdList = (List)personPropValueObj;
                        personAttrValueMap.put(adjDetailFieldKey, mulBaseDataIdList);
                        continue;
                    }
                    personAttrValueMap.put(adjDetailFieldKey, (List<Object>)personPropValueObj);
                }
            }
            adjApprPerson.set("personattrdata", (Object)JSON.toJSONString(personAttrValueMap));
        }
    }

    private static void convertAttrDataToAdjPerson(List<DynamicObject> adjApprPersonList) {
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            String personAttrData = adjApprPerson.getString("personattrdata");
            if (!StringUtils.isNotEmpty((String)personAttrData)) continue;
            Map personAttrDataMap = (Map)JSON.parseObject((String)personAttrData, Map.class);
            AdjPersonPackageHelper.doConvertAttrDataToAdjPerson(adjApprPerson, personAttrDataMap);
        }
    }

    private static void doConvertAttrDataToAdjPerson(DynamicObject adjApprPerson, Map<String, Object> personAttrDyDataMap) {
        HashMap adjApprPropertyMap = new HashMap();
        adjApprPerson.getDynamicObjectType().getProperties().forEach(property -> adjApprPropertyMap.putIfAbsent(property.getName(), property));
        for (Map.Entry<String, Object> entry : personAttrDyDataMap.entrySet()) {
            Object personAttrObj;
            String personAttrKey = entry.getKey();
            Object object = personAttrDyDataMap.get(personAttrKey);
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)adjApprPropertyMap.get(personAttrKey);
            if (Objects.isNull(iDataEntityProperty)) continue;
            if (iDataEntityProperty instanceof BasedataProp) {
                personAttrObj = entry.getValue();
                if (object == null || personAttrObj == null) continue;
                Long personAttrObjId = Long.valueOf(String.valueOf(personAttrObj));
                adjApprPerson.set(personAttrKey, (Object)personAttrObjId);
                continue;
            }
            if (iDataEntityProperty instanceof MulBasedataProp) {
                personAttrObj = (List)entry.getValue();
                if (Objects.isNull(object) || personAttrObj.size() <= 0 || ((List)object).size() == 0) continue;
                List personAttrObjIdList = personAttrObj.stream().map(item -> Long.parseLong(String.valueOf(item))).collect(Collectors.toList());
                DynamicObjectType mulBaseDataPropertyType = ((MulBasedataProp)iDataEntityProperty).getDynamicCollectionItemPropertyType();
                DynamicObjectCollection multiBaseDataDyObjs = new DynamicObjectCollection(mulBaseDataPropertyType, null);
                for (Long multiBaseData : personAttrObjIdList) {
                    DynamicObject newMultiBaseData = new DynamicObject(multiBaseDataDyObjs.getDynamicObjectType());
                    newMultiBaseData.set("fbasedataid_id", (Object)multiBaseData);
                    multiBaseDataDyObjs.add((Object)newMultiBaseData);
                }
                adjApprPerson.set(personAttrKey, (Object)multiBaseDataDyObjs);
                continue;
            }
            adjApprPerson.set(personAttrKey, entry.getValue());
        }
    }

    private static void setTrialPeriodInfo(Map<Long, DynamicObject> entryDateMap, Map<Long, DynamicObject> realRegularDateMap, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet) {
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long personId = adjApprPerson.getLong("person.id");
            DynamicObject entryDateDynamicObj = entryDateMap.get(personId);
            if (entryPropertySet.contains("entrydate") && entryDateDynamicObj != null) {
                adjApprPerson.set("entrydate", (Object)entryDateDynamicObj.getDate("startdate"));
            }
            DynamicObject realRegularDateDynamicObj = realRegularDateMap.get(personId);
            if (!entryPropertySet.contains("realregulardate") || realRegularDateDynamicObj == null) continue;
            adjApprPerson.set("realregulardate", (Object)realRegularDateDynamicObj.getDate("realregulardate"));
        }
    }

    private static void setContrWorkLocInfo(Map<Long, DynamicObject> contrWorkLocMap, Map<Long, DynamicObject> baseLocationcMap, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet) {
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long personId = adjApprPerson.getLong("person.id");
            DynamicObject contrWorkLoc = contrWorkLocMap.get(personId);
            DynamicObject baseLocationc = baseLocationcMap.get(personId);
            if (entryPropertySet.contains("agreedlocation") && contrWorkLoc != null) {
                adjApprPerson.set("agreedlocation", (Object)contrWorkLoc.getDynamicObject("agreedlocation"));
            }
            if (!entryPropertySet.contains("baselocation") || baseLocationc == null) continue;
            adjApprPerson.set("baselocation", (Object)baseLocationc.getDynamicObject("location"));
        }
    }

    private static void setPersonRelationInfo(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, List<DynamicObject> adjApprPersonList, Map<String, Long> adjDetailFieldToContrastCfg, Map<String, Object> mulBaseDataPropertyToDynamicObjMap, Map<String, IDataEntityProperty> apprBillEntryPropertyMap) {
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            if (MapUtils.isEmpty(matchStdResult.get(adjFileId))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Map personPropValueMap;
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                if (matchStdResult.get(adjFileId).get(standardItemId) == null || MapUtils.isEmpty((Map)(personPropValueMap = matchStdResult.get(adjFileId).get(standardItemId).getPersonPropValue()))) continue;
                for (Map.Entry<String, IDataEntityProperty> apprBillEntryPropertyEntry : apprBillEntryPropertyMap.entrySet()) {
                    String apprBillEntryProperty = apprBillEntryPropertyEntry.getKey();
                    IDataEntityProperty apprBillEntryPropertyValue = apprBillEntryPropertyEntry.getValue();
                    if (!adjDetailFieldToContrastCfg.containsKey(apprBillEntryProperty)) continue;
                    Long contrastCfgSetId = adjDetailFieldToContrastCfg.get(apprBillEntryProperty);
                    Object personPropValue = personPropValueMap.get(contrastCfgSetId);
                    if (contrastCfgSetId == null || personPropValue == null) continue;
                    if (apprBillEntryPropertyValue instanceof MulBasedataProp) {
                        List mulBaseBataIdList = (List)personPropValue;
                        List mulBaseDataDynamicObjList = ((List)mulBaseDataPropertyToDynamicObjMap.get(apprBillEntryProperty)).stream().filter(item -> mulBaseBataIdList.contains(item.get("id"))).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty((Collection)mulBaseBataIdList)) continue;
                        DynamicObjectCollection mulBaseDataDynamicObj = adjApprPerson.getDynamicObjectCollection(apprBillEntryProperty);
                        for (DynamicObject multiBaseData : mulBaseDataDynamicObjList) {
                            DynamicObject newMultiBaseData = new DynamicObject(mulBaseDataDynamicObj.getDynamicObjectType());
                            newMultiBaseData.set("fbasedataid", (Object)multiBaseData);
                            mulBaseDataDynamicObj.add((Object)newMultiBaseData);
                        }
                        adjApprPerson.set(apprBillEntryProperty, (Object)mulBaseDataDynamicObj);
                        continue;
                    }
                    adjApprPerson.set(apprBillEntryProperty, personPropValue);
                }
            }
        }
    }

    private static Map<String, Object> getMulBaseDataPropertyToDynamicObjMap(Map<String, IDataEntityProperty> apprBillEntryPropertyMap, Map<String, Long> adjDetailFieldToContrastCfg, Map<Long, List<Object>> contrastCfgIdToIdMap) {
        HashMap<String, Object> mulBaseDataPropertyToDynamicObjMap = new HashMap<String, Object>(16);
        HashSet mulPropertySet = new HashSet(16);
        apprBillEntryPropertyMap.keySet().forEach(property -> {
            if (apprBillEntryPropertyMap.get(property) instanceof MulBasedataProp) {
                mulPropertySet.add(property);
            }
        });
        if (CollectionUtils.isEmpty(mulPropertySet)) {
            return new HashMap<String, Object>();
        }
        for (String property2 : mulPropertySet) {
            MulBasedataProp mulBasedataProp;
            String baseEntityId;
            Long adjDetailFieldToValue;
            List<Object> contrastCfgIdValueList;
            if (!adjDetailFieldToContrastCfg.containsKey(property2) || CollectionUtils.isEmpty(contrastCfgIdValueList = contrastCfgIdToIdMap.get(adjDetailFieldToValue = adjDetailFieldToContrastCfg.get(property2))) || (baseEntityId = (mulBasedataProp = (MulBasedataProp)apprBillEntryPropertyMap.get(property2)).getBaseEntityId()) == null || contrastCfgIdValueList == null) continue;
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
            DynamicObject[] attrDataObjs = serviceHelper.query(contrastCfgIdValueList.toArray());
            mulBaseDataPropertyToDynamicObjMap.put(property2, Arrays.asList(attrDataObjs));
        }
        return mulBaseDataPropertyToDynamicObjMap;
    }

    private static Map<Long, List<Object>> getMulBaseDataConstrastCfgIdToIdMap(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        HashMap personPropValueMap = new HashMap(16);
        for (Map.Entry<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResultEntrySet : matchStdResult.entrySet()) {
            Map<Long, SalaryStdMatchResultNew> stdMatchResultMap = matchStdResultEntrySet.getValue();
            for (SalaryStdMatchResultNew salaryStdMatchResultNew : stdMatchResultMap.values()) {
                Map personPropValue = salaryStdMatchResultNew.getPersonPropValue();
                if (!MapUtils.isNotEmpty((Map)personPropValue)) continue;
                personPropValueMap.putAll(personPropValue);
            }
        }
        HashMap<Long, List<Object>> contrastCfgIdToIdMap = new HashMap<Long, List<Object>>(16);
        for (Map.Entry personPropValueEntrySet : personPropValueMap.entrySet()) {
            ArrayList contrastCfgIdToIdList = new ArrayList(personPropValueMap.size());
            Long contrastCfgId = (Long)personPropValueEntrySet.getKey();
            Object personPropValueObj = personPropValueMap.get(contrastCfgId);
            if (Objects.isNull(personPropValueObj) || !(personPropValueObj instanceof List)) continue;
            List personAttrKeyObjList = (List)personPropValueObj;
            personAttrKeyObjList.forEach(item -> contrastCfgIdToIdList.add(item));
            contrastCfgIdToIdMap.put(contrastCfgId, contrastCfgIdToIdList);
        }
        return contrastCfgIdToIdMap;
    }

    private static void setFileRelationInfo(DynamicObject adjFileDynamicObj, DynamicObject adjApprPerson, Set<String> entryPropertySet) {
        adjApprPerson.set("confirmstatus", (Object)ConfirmStatusEnum.UN_CONFIRM.getCode());
        adjApprPerson.set("synstatus", (Object)DecAdjSynStatusEnum.TO_SYNC.getCode());
        if (entryPropertySet.contains("name")) {
            adjApprPerson.set("name", (Object)adjFileDynamicObj.getString("person.name"));
        }
        if (entryPropertySet.contains("number")) {
            adjApprPerson.set("number", (Object)adjFileDynamicObj.getString("employee.empnumber"));
        }
        if (entryPropertySet.contains("country")) {
            adjApprPerson.set("country", (Object)adjFileDynamicObj.getDynamicObject("country"));
        }
        if (entryPropertySet.contains("depcytype")) {
            adjApprPerson.set("depcytype", (Object)adjFileDynamicObj.getDynamicObject("depcytype"));
        }
        if (entryPropertySet.contains("empgroup")) {
            adjApprPerson.set("empgroup", (Object)adjFileDynamicObj.getDynamicObject("empgroup"));
        }
        if (entryPropertySet.contains("assoadminorg")) {
            adjApprPerson.set("assoadminorg", (Object)adjFileDynamicObj.getLong("assoadminorg.sourcevid"));
        }
        if (entryPropertySet.contains("org")) {
            adjApprPerson.set("org", (Object)adjFileDynamicObj.getDynamicObject("org"));
        }
        if (entryPropertySet.contains("company")) {
            adjApprPerson.set("company", (Object)adjFileDynamicObj.getDynamicObject("empposorgrel.company"));
        }
        if (entryPropertySet.contains("adjfilevid")) {
            adjApprPerson.set("adjfilevid", (Object)adjFileDynamicObj.getLong("sourcevid"));
        }
        if (entryPropertySet.contains("depemp")) {
            adjApprPerson.set("depemp", (Object)adjFileDynamicObj.getDynamicObject("depemp"));
        }
        if (entryPropertySet.contains("adminorg")) {
            adjApprPerson.set("adminorg", (Object)adjFileDynamicObj.getLong("adminorg.sourcevid"));
        }
        if (entryPropertySet.contains("person")) {
            adjApprPerson.set("person", (Object)adjFileDynamicObj.getDynamicObject("person"));
        }
        if (entryPropertySet.contains("employee")) {
            adjApprPerson.set("employee", (Object)adjFileDynamicObj.getDynamicObject("employee"));
        }
        if (entryPropertySet.contains("salarystructure")) {
            adjApprPerson.set("salarystructure", (Object)adjFileDynamicObj.getDynamicObject("salaystructure"));
        }
        if (entryPropertySet.contains("stdscm")) {
            adjApprPerson.set("stdscm", (Object)adjFileDynamicObj.getLong("stdscm.sourcevid"));
        }
        if (entryPropertySet.contains("adjfile")) {
            adjApprPerson.set("adjfile", (Object)adjFileDynamicObj);
        }
    }

    private static Map<Long, Map<Long, SalaryStdMatchResultNew>> getMatchStdResult(List<AddFileReturnData> addFileReturnDataList, Date defaultBsed) {
        List<MatchStdTableWithAdjFileParam> paramList = AdjPersonPackageHelper.getFileItemBsedMap(addFileReturnDataList, defaultBsed);
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Long, Map<Long, SalaryStdMatchResultNew>> stdMatchResult = adjApprovalApplicationService.batchMatchStdTable(paramList);
        return stdMatchResult;
    }

    private static Map<Long, List<Long>> getFileItemMap(List<AddFileReturnData> addFileReturnDataList) {
        HashMap<Long, List<Long>> fileToItemMap = new HashMap<Long, List<Long>>(16);
        for (AddFileReturnData addFileReturnData : addFileReturnDataList) {
            long fileId = addFileReturnData.getAdjFileId();
            long itemId = addFileReturnData.getStandardItemId();
            if (fileId <= 0L) continue;
            List itemIdList = fileToItemMap.computeIfAbsent(fileId, key -> Lists.newArrayList());
            if (itemId <= 0L) continue;
            itemIdList.add(itemId);
        }
        return fileToItemMap;
    }

    private static List<MatchStdTableWithAdjFileParam> getFileItemBsedMap(List<AddFileReturnData> addFileReturnDataList, Date defaultBsed) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)addFileReturnDataList.size());
        for (AddFileReturnData addFileReturnData : addFileReturnDataList) {
            MatchStdTableWithAdjFileParam param = new MatchStdTableWithAdjFileParam();
            long fileId = addFileReturnData.getAdjFileId();
            long itemId = addFileReturnData.getStandardItemId();
            if (fileId <= 0L || itemId <= 0L) continue;
            param.setAdjFileId(fileId);
            param.setStdItemId(itemId);
            param.setBsed(defaultBsed);
            paramList.add(param);
        }
        return paramList;
    }

    public static void setActualAmountOrRatioWithAmount(List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, String attributionType, long exctableId, Date rateDate) {
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
            return;
        }
        for (DynamicObject adjApprPersonDyObj : adjApprPersonList) {
            DynamicObjectCollection adjPersonEntryDyObjs = adjApprPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjPersonEntryDyObj : adjPersonEntryDyObjs) {
                AdjPersonPackageHelper.doSetActualAmountOrRatio(entryPropertySet, exctableId, rateDate, adjPersonEntryDyObj);
            }
        }
    }

    public static void doSetActualAmountOrRatio(Set<String> entryPropertySet, long exctableId, Date rateDate, DynamicObject adjPersonEntryDyObj) {
        BigDecimal actualAmount;
        BigDecimal preSalary = adjPersonEntryDyObj.getBigDecimal("presalary");
        BigDecimal amount = adjPersonEntryDyObj.getBigDecimal("amount");
        BigDecimal actualRange = adjPersonEntryDyObj.getBigDecimal("actualrange");
        if (preSalary != null && preSalary.compareTo(BigDecimal.ZERO) > 0) {
            if (amount != null) {
                preSalary = AdjPersonPackageHelper.getCalPresalary(adjPersonEntryDyObj, exctableId, rateDate, preSalary);
                actualAmount = amount.subtract(preSalary);
                actualRange = actualAmount.divide(preSalary, 10, 4).multiply(BigDecimal.valueOf(100L));
            } else {
                actualRange = null;
                actualAmount = amount;
            }
        } else {
            actualAmount = amount;
        }
        if (entryPropertySet.contains("actualrange")) {
            adjPersonEntryDyObj.set("actualrange", (Object)actualRange);
        }
        if (entryPropertySet.contains("actualamount")) {
            adjPersonEntryDyObj.set("actualamount", (Object)actualAmount);
        }
        if (entryPropertySet.contains("amount")) {
            adjPersonEntryDyObj.set("amount", (Object)amount);
        }
    }

    private static BigDecimal getCalPresalary(DynamicObject adjPersonEntryDyObj, long exctableId, Date rateDate, BigDecimal preSalary) {
        ExchangeRateInfo exrateInfo;
        DynamicObject salaryStdDyn;
        BillExRateManager rateManager = new BillExRateManager();
        Long preCurrency = adjPersonEntryDyObj.getLong("precurrency.id");
        long adjCurrency = adjPersonEntryDyObj.getLong("currency.id");
        if ((preCurrency == null || preCurrency <= 0L) && (salaryStdDyn = adjPersonEntryDyObj.getDynamicObject("salarystd")) != null) {
            preCurrency = salaryStdDyn.getLong("currency.id");
        }
        if (adjCurrency > 0L && preCurrency != adjCurrency && adjCurrency > 0L && preCurrency > 0L && exctableId > 0L && rateDate != null && (exrateInfo = rateManager.getExRate(new ExRateKey(adjCurrency, preCurrency, rateDate.getTime(), exctableId))) != null) {
            Boolean quoteType = exrateInfo.getQuoteType();
            BigDecimal exchangeRate = exrateInfo.getExchangeRate();
            if (exchangeRate != null) {
                adjPersonEntryDyObj.set("exratevalue", (Object)exchangeRate);
                adjPersonEntryDyObj.set("quotetype", (Object)quoteType);
                preSalary = quoteType != false ? preSalary.divide(exchangeRate, 2, 4) : preSalary.multiply(exchangeRate);
            }
        }
        return preSalary;
    }

    public static void setExchangeRateInfo(List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet, long exctableId, Date rateDate) {
        BillExRateManager rateManager = new BillExRateManager();
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                AdjPersonPackageHelper.doSetExchangeRateInfo(entryPropertySet, exctableId, rateDate, rateManager, adjApprPersonEntry);
            }
        }
    }

    public static void doSetExchangeRateInfo(Set<String> entryPropertySet, long exctableId, Date rateDate, BillExRateManager rateManager, DynamicObject adjApprPersonEntry) {
        DynamicObject salaryStdDynamicObject = adjApprPersonEntry.getDynamicObject("salarystd");
        if (salaryStdDynamicObject == null) {
            return;
        }
        long stdCurrency = salaryStdDynamicObject.getLong("currency.id");
        long decCurrency = adjApprPersonEntry.getLong("currency.id");
        if (decCurrency > 0L && stdCurrency > 0L && exctableId > 0L && rateDate != null) {
            ExchangeRateInfo exrateInfo = rateManager.getExRate(new ExRateKey(decCurrency, stdCurrency, rateDate.getTime(), exctableId));
            if (exrateInfo != null) {
                Boolean quoteType = exrateInfo.getQuoteType();
                BigDecimal exchangeRate = exrateInfo.getExchangeRate();
                if (exchangeRate != null) {
                    if (entryPropertySet.contains(DecAdjApprConstants.KEY_EXRATEVALUE)) {
                        adjApprPersonEntry.set(DecAdjApprConstants.KEY_EXRATEVALUE, (Object)exchangeRate);
                    }
                    if (entryPropertySet.contains(DecAdjApprConstants.KEY_QUOTETYPE)) {
                        adjApprPersonEntry.set(DecAdjApprConstants.KEY_QUOTETYPE, (Object)quoteType);
                    }
                }
            } else if (entryPropertySet.contains(DecAdjApprConstants.KEY_EXRATEVALUE)) {
                adjApprPersonEntry.set(DecAdjApprConstants.KEY_EXRATEVALUE, null);
            }
        }
    }

    public static Map<Object, DynamicObject> loadReferenceDataBatch(DynamicObjectType dt, Object[] pkValues) {
        return BusinessDataReader.loadFromCache((Object[])pkValues, (DynamicObjectType)dt);
    }

    public static Map<String, Object> getBillType(IDataModel billModel) {
        EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
        BasedataProp adjFileProp = (BasedataProp)billModel.getProperty("dy_adjfile");
        BasedataProp stdItemProp = (BasedataProp)billModel.getProperty("dy_standarditem");
        BasedataProp coefficientProp = (BasedataProp)billModel.getProperty("coefficient");
        HashMap<String, Object> dynamicObjectTypeMap = new HashMap<String, Object>(16);
        dynamicObjectTypeMap.put(adjFilePropType, (DynamicObjectType)adjFileProp.getComplexType());
        dynamicObjectTypeMap.put(stdItemPropType, (DynamicObjectType)stdItemProp.getComplexType());
        dynamicObjectTypeMap.put(coefficientPropType, (DynamicObjectType)coefficientProp.getComplexType());
        dynamicObjectTypeMap.put(billEntryEntityType, entityType);
        return dynamicObjectTypeMap;
    }

    public static FormShowParameter showProgressForm(IFormView view, Map<String, Object> customParams) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("hcdm_addadjprogress");
        fsp.setCustomParams(customParams);
        fsp.setCustomParam(ADD_ADJ_PERSON_BEAN, (Object)SerializationUtils.toJsonString((Object)customParams.get(ADD_ADJ_PERSON_BEAN)));
        fsp.setCloseCallBack(new CloseCallBack("kd.swc.hcdm.formplugin.adjapprbill.DecAdjApprovalDetailPlugin", CALLBACKID_CLOSE_ADJPRO));
        view.showForm(fsp);
        return fsp;
    }

    public static int calBatchSize(int itemCount) {
        if (itemCount <= 1) {
            return 1000;
        }
        if (itemCount <= 3) {
            return 500;
        }
        if (itemCount <= 10) {
            return 200;
        }
        if (itemCount <= 20) {
            return 100;
        }
        if (itemCount <= 30) {
            return 50;
        }
        if (itemCount <= 50) {
            return 20;
        }
        if (itemCount <= 100) {
            return 10;
        }
        return 1;
    }
}

