/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.entity.ExRateKey;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.enums.CalcSceneType;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CalculateUtils {
    private static Log logger = LogFactory.getLog(CalculateUtils.class);

    public static void calAdjAmount(long tableCurrency, long tableExctable, Date tableRateDate, DynamicObject calObj, BillExRateManager rateManager) {
        BigDecimal amount = calObj.getBigDecimal("amount");
        String calcType = calObj.getString("calctype");
        if (amount != null && amount.compareTo(BigDecimal.ZERO) > 0) {
            CalculateUtils.calcWithAmount(tableCurrency, tableExctable, tableRateDate, calObj, rateManager, CalcSceneType.EXCEL_IMPORT_ADD);
        } else if (CalcType.RATIO.getCode().equals(calcType)) {
            CalculateUtils.calcWithActualRange(tableCurrency, tableExctable, tableRateDate, calObj, rateManager, CalcSceneType.EXCEL_IMPORT_ADD);
        } else if (CalcType.AMOUNT.getCode().equals(calcType)) {
            CalculateUtils.calcWithActualAmount(tableCurrency, tableExctable, tableRateDate, calObj, rateManager, CalcSceneType.EXCEL_IMPORT_ADD);
        }
    }

    public static void calcWithAmount(long tableCurrency, long tableExctable, Date tableRateDate, DynamicObject calObj, BillExRateManager rateManager, CalcSceneType sceneType) {
        BigDecimal actualamount;
        String calcType = calObj.getString("calctype");
        BigDecimal presalary = calObj.getBigDecimal("presalary");
        BigDecimal amount = calObj.getBigDecimal("amount");
        BigDecimal actualrange = calObj.getBigDecimal("actualrange");
        if (presalary != null && presalary.compareTo(BigDecimal.ZERO) > 0) {
            if (amount != null) {
                presalary = CalculateUtils.getCalPresalary(tableCurrency, tableExctable, calObj, tableRateDate, rateManager, presalary);
                actualamount = amount.subtract(presalary);
                actualrange = actualamount.divide(presalary, 10, 4).multiply(BigDecimal.valueOf(100L));
            } else {
                actualrange = null;
                actualamount = amount;
            }
        } else {
            actualamount = amount;
        }
        if (!CalcSceneType.PAGE_CALC.getCode().equals(sceneType.getCode())) {
            if (CalcType.RATIO.getCode().equals(calcType)) {
                CalculateUtils.calcAmount(presalary, calObj);
            } else if (CalcType.AMOUNT.getCode().equals(calcType)) {
                CalculateUtils.calcRatio(presalary, calObj);
            }
        }
        calObj.set("actualrange", (Object)actualrange);
        calObj.set("actualamount", (Object)actualamount);
        calObj.set("amount", (Object)amount);
    }

    public static void calcWithActualRange(long tableCurrency, long tableExctable, Date tableRateDate, DynamicObject calObj, BillExRateManager rateManager, CalcSceneType sceneType) {
        String calcType = calObj.getString("calctype");
        if (CalcType.RATIO.getCode().equals(calcType)) {
            BigDecimal presalary = calObj.getBigDecimal("presalary");
            BigDecimal actualrange = calObj.getBigDecimal("actualrange");
            BigDecimal actualAmount = calObj.getBigDecimal("actualamount");
            BigDecimal amount = calObj.getBigDecimal("amount");
            if (presalary != null && presalary.compareTo(BigDecimal.ZERO) >= 0) {
                if (actualrange != null) {
                    presalary = CalculateUtils.getCalPresalary(tableCurrency, tableExctable, calObj, tableRateDate, rateManager, presalary);
                    actualAmount = presalary.multiply(actualrange.multiply(BigDecimal.valueOf(0.01)));
                    amount = presalary.add(actualAmount);
                } else {
                    amount = actualAmount = null;
                }
            }
            calObj.set("actualrange", (Object)actualrange);
            calObj.set("actualamount", (Object)actualAmount);
            calObj.set("amount", (Object)amount);
            if (!CalcSceneType.PAGE_CALC.getCode().equals(sceneType.getCode())) {
                CalculateUtils.calcAmount(presalary, calObj);
            }
        }
    }

    public static void calcWithActualAmount(long tableCurrency, long tableExctable, Date tableRateDate, DynamicObject calObj, BillExRateManager rateManager, CalcSceneType sceneType) {
        String calcType = calObj.getString("calctype");
        if (CalcType.AMOUNT.getCode().equals(calcType)) {
            BigDecimal presalary = calObj.getBigDecimal("presalary");
            BigDecimal actualamount = calObj.getBigDecimal("actualamount");
            BigDecimal actualrange = calObj.getBigDecimal("actualrange");
            BigDecimal amount = null;
            if (presalary != null && presalary.compareTo(BigDecimal.ZERO) > 0) {
                if (actualamount != null) {
                    presalary = CalculateUtils.getCalPresalary(tableCurrency, tableExctable, calObj, tableRateDate, rateManager, presalary);
                    actualrange = actualamount.divide(presalary, 10, 4).multiply(BigDecimal.valueOf(100L));
                    amount = presalary.add(actualamount);
                }
            } else {
                amount = actualamount;
            }
            calObj.set("actualrange", (Object)actualrange);
            calObj.set("amount", (Object)amount);
            calObj.set("actualamount", (Object)actualamount);
            if (!CalcSceneType.PAGE_CALC.getCode().equals(sceneType.getCode())) {
                CalculateUtils.calcRatio(presalary, calObj);
            }
        }
    }

    public static void calcWithCurExchange(long tableCurrency, long tableExctable, Date tableRateDate, DynamicObject calObj, BillExRateManager rateManager) {
        BigDecimal presalary = calObj.getBigDecimal("presalary");
        BigDecimal actualrange = calObj.getBigDecimal("actualrange");
        BigDecimal actualamount = calObj.getBigDecimal("actualamount");
        BigDecimal amount = calObj.getBigDecimal("amount");
        String calcType = calObj.getString("calctype");
        if (presalary != null && presalary.compareTo(BigDecimal.ZERO) > 0) {
            presalary = CalculateUtils.getCalPresalary(tableCurrency, tableExctable, calObj, tableRateDate, rateManager, presalary);
            if (CalcType.RATIO.getCode().equals(calcType)) {
                if (actualrange != null) {
                    actualamount = presalary.multiply(actualrange.multiply(BigDecimal.valueOf(0.01)));
                    amount = presalary.add(actualamount);
                }
                CalculateUtils.calcAmount(presalary, calObj);
            } else if (CalcType.AMOUNT.getCode().equals(calcType) || CalcType.GRADE_RANK.getCode().equals(calcType)) {
                if (actualamount != null) {
                    actualrange = actualamount.divide(presalary, 10, 4).multiply(BigDecimal.valueOf(100L));
                    amount = presalary.add(actualamount);
                }
                CalculateUtils.calcRatio(presalary, calObj);
            }
        } else if (presalary != null && presalary.compareTo(BigDecimal.ZERO) == 0) {
            if (CalcType.RATIO.getCode().equals(calcType)) {
                if (actualrange != null) {
                    actualamount = presalary;
                    amount = presalary;
                }
                CalculateUtils.calcAmount(presalary, calObj);
            } else if (CalcType.AMOUNT.getCode().equals(calcType) || CalcType.GRADE_RANK.getCode().equals(calcType)) {
                if (actualamount != null) {
                    amount = actualamount;
                }
                CalculateUtils.calcRatio(presalary, calObj);
            }
        }
        calObj.set("actualrange", (Object)actualrange);
        calObj.set("actualamount", (Object)actualamount);
        calObj.set("amount", (Object)amount);
    }

    public static void setAdjCalcFieldAfter(long exctableId, Date rateDate, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet) {
        if (CollectionUtils.isEmpty(adjApprPersonList)) {
            return;
        }
        BillExRateManager rateManager = new BillExRateManager();
        Map<String, SalaryCountAmountMatchResult> salaryCountAmountMatchResultMap = CalculateUtils.getSalaryCountAmountMatchResultMap(exctableId, rateDate, adjApprPersonList, rateManager);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            long fileId = adjApprPerson.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryDyObjs) {
                CalculateUtils.doSetAdjCalcFieldAfter(exctableId, rateDate, entryPropertySet, rateManager, salaryCountAmountMatchResultMap, fileId, adjApprPersonEntry);
            }
        }
    }

    public static void doSetAdjCalcFieldAfter(long exctableId, Date rateDate, Set<String> entryPropertySet, BillExRateManager rateManager, Map<String, SalaryCountAmountMatchResult> salaryCountAmountMatchResultMap, long fileId, DynamicObject adjApprPersonEntry) {
        String isMatchGradeRank;
        long itemId = adjApprPersonEntry.getLong("standarditem.id");
        String calcTypeCode = adjApprPersonEntry.getString("calctype");
        CalcType calcType = CalcType.getByCode(calcTypeCode);
        boolean needCalcGradeRankByAmount = calcType != null && (calcType == CalcType.AMOUNT || calcType == CalcType.RATIO);
        String unionKey = String.format("%s_%s", fileId, itemId);
        Long adjCurrencyId = adjApprPersonEntry.getLong("currency.id");
        long stdCurrencyId = adjApprPersonEntry.getLong("salarystd.currency.id");
        BigDecimal finalAmount = adjApprPersonEntry.getBigDecimal("amount");
        BigDecimal coefficientValue = CalculateUtils.getCoefficientValue(adjApprPersonEntry);
        SalaryCountAmountMatchResult salaryCountAmountMatchResult = salaryCountAmountMatchResultMap.get(unionKey);
        Long afterGradeId = null;
        Long afterRankId = null;
        BigDecimal afterStdIntervalMin = adjApprPersonEntry.getBigDecimal("intervalmin");
        BigDecimal afterStdIntervalMax = adjApprPersonEntry.getBigDecimal("intervalmax");
        BigDecimal afterStdMiddleValue = adjApprPersonEntry.getBigDecimal("stdmiddlevalue");
        String amountstdrange = null;
        if (needCalcGradeRankByAmount) {
            afterStdIntervalMin = null;
            afterStdIntervalMax = null;
            afterStdMiddleValue = null;
            if (salaryCountAmountMatchResult != null) {
                Map amountStdRangeMap = null;
                List<Pair<Long, Long>> amountStdNoUseRangeList = null;
                Map positionInfo = salaryCountAmountMatchResult.getPositionInfo();
                List positionInfoOfNotUseRank = salaryCountAmountMatchResult.getPositionInfoOfNotUseRank();
                afterGradeId = salaryCountAmountMatchResult.getGradeId();
                afterRankId = salaryCountAmountMatchResult.getRankId();
                if (salaryCountAmountMatchResult.isItemUseRank() && MapUtils.isNotEmpty((Map)positionInfo)) {
                    amountStdRangeMap = CalculateUtils.getAmountStdRange(positionInfo);
                    if (MapUtils.isNotEmpty(amountStdRangeMap)) {
                        amountStdRangeMap = amountStdRangeMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                    }
                } else if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRank)) {
                    amountStdNoUseRangeList = CalculateUtils.getAmountStdRange(positionInfoOfNotUseRank);
                }
                AmountStdRangeEntity amountStdRangeEntity = new AmountStdRangeEntity(amountStdRangeMap, amountStdNoUseRangeList);
                amountstdrange = JSON.toJSONString((Object)amountStdRangeEntity);
                Map gradeIntervalInfo = salaryCountAmountMatchResult.getGradeIntervalInfo();
                Map gradeIntervalInfoMap = (Map)gradeIntervalInfo.get(afterGradeId);
                ExchangeRateInfo rateInfo = DecAdjApprGridHelper.getExchangeRate(rateManager, stdCurrencyId, adjCurrencyId, exctableId, rateDate);
                if (MapUtils.isNotEmpty((Map)gradeIntervalInfoMap)) {
                    afterStdIntervalMin = DecAdjApprGridHelper.convertAmountByExrate(rateInfo, (BigDecimal)gradeIntervalInfoMap.get("gradeMin"), stdCurrencyId, adjCurrencyId);
                    afterStdIntervalMax = DecAdjApprGridHelper.convertAmountByExrate(rateInfo, (BigDecimal)gradeIntervalInfoMap.get("gradeMax"), stdCurrencyId, adjCurrencyId);
                    afterStdMiddleValue = DecAdjApprGridHelper.convertAmountByExrate(rateInfo, (BigDecimal)gradeIntervalInfoMap.get("gradeMiddle"), stdCurrencyId, adjCurrencyId);
                }
            }
            if (entryPropertySet.contains("grade")) {
                adjApprPersonEntry.set("grade", afterGradeId);
            }
            if (entryPropertySet.contains("rank")) {
                adjApprPersonEntry.set("rank", afterRankId);
            }
            if (entryPropertySet.contains("grade")) {
                adjApprPersonEntry.set("grade", (Object)afterGradeId);
            }
            if (entryPropertySet.contains("intervalmin")) {
                adjApprPersonEntry.set("intervalmin", (Object)afterStdIntervalMin);
            }
            if (entryPropertySet.contains("intervalmax")) {
                adjApprPersonEntry.set("intervalmax", (Object)afterStdIntervalMax);
            }
            if (entryPropertySet.contains("stdmiddlevalue")) {
                adjApprPersonEntry.set("stdmiddlevalue", (Object)afterStdMiddleValue);
            }
            if (entryPropertySet.contains("amountstdrange")) {
                adjApprPersonEntry.set("amountstdrange", (Object)amountstdrange);
            }
        }
        BigDecimal afterSalaryPercent = SalaryStdCalculateHelper.calcSalaryRatioNew(finalAmount, afterStdMiddleValue, coefficientValue);
        BigDecimal afterSalarySeeprate = SalaryStdCalculateHelper.calcSalaryPermeability(finalAmount, afterStdIntervalMin, afterStdIntervalMax, coefficientValue);
        if (entryPropertySet.contains("salarypercent")) {
            adjApprPersonEntry.set("salarypercent", (Object)afterSalaryPercent);
        }
        if (entryPropertySet.contains("salaryseeprate")) {
            adjApprPersonEntry.set("salaryseeprate", (Object)afterSalarySeeprate);
        }
        if (!SWCStringUtils.equals((String)"1", (String)(isMatchGradeRank = adjApprPersonEntry.getString("ismatchgraderank")))) {
            if (entryPropertySet.contains("grade")) {
                adjApprPersonEntry.set("grade", null);
            }
            if (entryPropertySet.contains("rank")) {
                adjApprPersonEntry.set("rank", null);
            }
        }
        if (Objects.isNull(afterGradeId) || 0L == afterGradeId) {
            if (entryPropertySet.contains("salarypercent")) {
                adjApprPersonEntry.set("salarypercent", null);
            }
            if (entryPropertySet.contains("salaryseeprate")) {
                adjApprPersonEntry.set("salaryseeprate", null);
            }
        }
    }

    public static Map<String, SalaryCountAmountMatchResult> getSalaryCountAmountMatchResultMap(long exctableId, Date rateDate, List<DynamicObject> adjApprPersonList, BillExRateManager rateManager) {
        ArrayList<SalaryCountAmountMatchParam> params = new ArrayList<SalaryCountAmountMatchParam>(10);
        SalaryCountAmountMatchParam salaryCountAmountMatchParam = null;
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            long fileId = adjApprPerson.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryDyObjs) {
                salaryCountAmountMatchParam = new SalaryCountAmountMatchParam();
                Long itemId = adjApprPersonEntry.getLong("standarditem.id");
                Long coefficientVid = adjApprPersonEntry.getLong("coefficient.id");
                Long stdTableId = adjApprPersonEntry.getLong("salarystd.id");
                Long adjCurrencyId = adjApprPersonEntry.getLong("currency.id");
                String matchStrategy = adjApprPersonEntry.getString("matchstrategy");
                String isMatchGradeRankVal = adjApprPersonEntry.getString("ismatchgraderank");
                long stdCurrencyId = adjApprPersonEntry.getLong("salarystd.currency.id");
                BigDecimal finalAmount = adjApprPersonEntry.getBigDecimal("amount");
                ExchangeRateInfo exchangeRate = DecAdjApprGridHelper.getExchangeRate(rateManager, adjCurrencyId, stdCurrencyId, exctableId, rateDate);
                BigDecimal finalAmountOfStdCurrency = DecAdjApprGridHelper.convertAmountByExrate(exchangeRate, finalAmount, adjCurrencyId, stdCurrencyId);
                if (finalAmountOfStdCurrency == null || stdTableId <= 0L || itemId <= 0L) continue;
                salaryCountAmountMatchParam.setStdTableId(stdTableId);
                salaryCountAmountMatchParam.setItemId(itemId);
                salaryCountAmountMatchParam.setCoeficientVid(coefficientVid);
                salaryCountAmountMatchParam.setAmount(finalAmountOfStdCurrency);
                salaryCountAmountMatchParam.setUnionId(String.format("%s_%s", fileId, itemId));
                salaryCountAmountMatchParam.setisMatchGradeRank(isMatchGradeRankVal);
                salaryCountAmountMatchParam.setMatchStrategy(matchStrategy);
                params.add(salaryCountAmountMatchParam);
            }
        }
        List<SalaryCountAmountMatchResult> salaryCountAmountMatchResults = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).matchTableRangeBySalaryCountOrAmount(params);
        logger.info("salary count amount match params={}, results={}", (Object)JSON.toJSONString(params), (Object)JSON.toJSONString(salaryCountAmountMatchResults));
        Map<String, SalaryCountAmountMatchResult> salaryCountAmountMatchResultMap = salaryCountAmountMatchResults.stream().collect(Collectors.toMap(SalaryCountAmountMatchResult::getUnionId, Function.identity()));
        HashMap amountStdRangeMatchMap = new HashMap(16);
        ArrayList positionInfoOfNotUseRankList = new ArrayList(16);
        salaryCountAmountMatchResultMap.values().stream().forEach(item -> {
            if (item.isItemUseRank()) {
                Map positionInfo = item.getPositionInfo();
                for (Map.Entry entry : positionInfo.entrySet()) {
                    Long key = (Long)entry.getKey();
                    List rankList = amountStdRangeMatchMap.computeIfAbsent(key, o1 -> Lists.newArrayList());
                    rankList.addAll((Collection)entry.getValue());
                }
            } else {
                positionInfoOfNotUseRankList.addAll(item.getPositionInfoOfNotUseRank());
            }
        });
        return salaryCountAmountMatchResultMap;
    }

    public static void setCalcFieldAfter(long excTableId, Date rateDate, Set<String> entryPropertySet, List<DynamicObject> adjApprPersonList, Long adjFieldCfgId) {
        DynamicObjectCollection adjApprPersonEntryDyObjs;
        BigDecimal salaryPercent = null;
        BigDecimal salarySeeprate = null;
        BigDecimal stdIntervalMin = null;
        BigDecimal stdIntervalMax = null;
        BigDecimal stdMiddleValue = null;
        BillExRateManager rateManager = new BillExRateManager();
        List<StdAmountAndSalaryCountQueryResult> stdAmountAndSalaryCountQueryResult = CalculateUtils.getStdAmountQueryResult(adjApprPersonList);
        Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = DecAdjApprGridHelper.getMatchStdResult(adjApprPersonList, adjFieldCfgId);
        HashSet<StdAmountQueryParam> salaryStdAmountParams = new HashSet<StdAmountQueryParam>(10);
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            adjApprPersonEntryDyObjs = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryDyObjs) {
                Object gradeObj = adjApprPersonEntry.get("grade");
                Long gradeId = gradeObj instanceof Long ? (Long)gradeObj : (Objects.isNull(gradeObj) ? 0L : ((DynamicObject)gradeObj).getLong("id"));
                Long salaryStdId = adjApprPersonEntry.getLong("salarystd.id");
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                if (standardItemId == 0L || salaryStdId == 0L || gradeId != 0L) continue;
                Map<Long, SalaryStdMatchResultNew> stdMatchResultMap = matchStdResult.get(adjFileId);
                SalaryStdMatchResultNew salaryStdMatchResultNew = stdMatchResultMap.get(standardItemId);
                gradeId = salaryStdMatchResultNew.getGradeId() == null ? Long.valueOf(0L) : salaryStdMatchResultNew.getGradeId();
                Long rankId = salaryStdMatchResultNew.getRankId() == null ? Long.valueOf(0L) : salaryStdMatchResultNew.getRankId();
                String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
                StdAmountQueryParam stdAmountQueryParam = CalculateUtils.buildStdAmountQueryParam(gradeId, rankId, salaryStdId, standardItemId, unionId);
                salaryStdAmountParams.add(stdAmountQueryParam);
            }
        }
        if (!salaryStdAmountParams.isEmpty()) {
            SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
            List<StdAmountAndSalaryCountQueryResult> stdAmountAndSalaryCountQueryResults = salaryStdApplicationService.queryAmountAndSalaryCount(new ArrayList<StdAmountQueryParam>(salaryStdAmountParams));
            logger.info("get stdamount Query Result={}", (Object)JSON.toJSONString(stdAmountAndSalaryCountQueryResults));
            if (!CollectionUtils.isEmpty(stdAmountAndSalaryCountQueryResults)) {
                if (CollectionUtils.isEmpty(stdAmountAndSalaryCountQueryResult)) {
                    stdAmountAndSalaryCountQueryResult = stdAmountAndSalaryCountQueryResults;
                } else {
                    stdAmountAndSalaryCountQueryResult.addAll(stdAmountAndSalaryCountQueryResults);
                }
            }
        }
        Map salaryCountQueryResultMap = stdAmountAndSalaryCountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity(), (key1, key2) -> key1));
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            adjApprPersonEntryDyObjs = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryDyObjs) {
                String unionId;
                StdAmountAndSalaryCountQueryResult stdAmountQueryResult;
                long currencyId = adjApprPersonEntry.getLong("currency.id");
                long stdCurrencyId = adjApprPersonEntry.getLong("salarystd.currency.id");
                Object gradeObj = adjApprPersonEntry.get("grade");
                Long gradeId = gradeObj instanceof Long ? (Long)gradeObj : (Objects.isNull(gradeObj) ? 0L : ((DynamicObject)gradeObj).getLong("id"));
                Object rankObj = adjApprPersonEntry.get("rank");
                Long rankId = rankObj instanceof Long ? (Long)rankObj : (Objects.isNull(rankObj) ? 0L : ((DynamicObject)rankObj).getLong("id"));
                Long salaryStdId = adjApprPersonEntry.getLong("salarystd.id");
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                if (standardItemId != 0L && salaryStdId != 0L && gradeId == 0L) {
                    Long adjFileId = adjApprPerson.getLong("adjfile.id");
                    Map<Long, SalaryStdMatchResultNew> stdMatchResultMap = matchStdResult.get(adjFileId);
                    SalaryStdMatchResultNew salaryStdMatchResultNew = stdMatchResultMap.get(standardItemId);
                    gradeId = salaryStdMatchResultNew.getGradeId() == null ? Long.valueOf(0L) : salaryStdMatchResultNew.getGradeId();
                    Long l = rankId = salaryStdMatchResultNew.getRankId() == null ? Long.valueOf(0L) : salaryStdMatchResultNew.getRankId();
                }
                if (standardItemId == 0L || salaryStdId == 0L || gradeId == 0L || (stdAmountQueryResult = (StdAmountAndSalaryCountQueryResult)salaryCountQueryResultMap.get(unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId))) == null) continue;
                BigDecimal intervalMin = stdAmountQueryResult.getGradeMinAmount();
                BigDecimal intervalMax = stdAmountQueryResult.getGradeMaxAmount();
                BigDecimal middleValue = stdAmountQueryResult.getGradeMiddleAmount();
                BigDecimal amount = adjApprPersonEntry.getBigDecimal("amount");
                BigDecimal coefficientValue = CalculateUtils.getCoefficientValue(adjApprPersonEntry);
                stdIntervalMin = intervalMin == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate(rateManager, intervalMin, amount, stdCurrencyId, currencyId, excTableId, rateDate, true);
                stdIntervalMax = intervalMax == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate(rateManager, intervalMax, amount, stdCurrencyId, currencyId, excTableId, rateDate, true);
                stdMiddleValue = middleValue == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate(rateManager, middleValue, amount, stdCurrencyId, currencyId, excTableId, rateDate, true);
                salaryPercent = SalaryStdCalculateHelper.calcSalaryRatioNew(amount, stdMiddleValue, coefficientValue);
                salarySeeprate = SalaryStdCalculateHelper.calcSalaryPermeability(amount, stdIntervalMin, stdIntervalMax, coefficientValue);
                if (entryPropertySet.contains("salarypercent")) {
                    adjApprPersonEntry.set("salarypercent", (Object)salaryPercent);
                }
                if (entryPropertySet.contains("salaryseeprate")) {
                    adjApprPersonEntry.set("salaryseeprate", (Object)salarySeeprate);
                }
                if (entryPropertySet.contains("intervalmin")) {
                    adjApprPersonEntry.set("intervalmin", (Object)stdIntervalMin);
                }
                if (!entryPropertySet.contains("intervalmax")) continue;
                adjApprPersonEntry.set("intervalmax", (Object)stdIntervalMax);
            }
        }
    }

    public static List<StdAmountAndSalaryCountQueryResult> getStdAmountQueryResult(List<DynamicObject> adjApprPersonList) {
        HashSet<StdAmountQueryParam> salaryStdAmountParams = new HashSet<StdAmountQueryParam>(10);
        for (DynamicObject adjPerson : adjApprPersonList) {
            DynamicObjectCollection entryCollection = adjPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryCollection) {
                Long gradeId = CalculateUtils.getGradeOrRankId(entryRow.get("grade"));
                Long rankId = CalculateUtils.getGradeOrRankId(entryRow.get("rank"));
                Long salaryStdId = entryRow.getLong("salarystd.id");
                Long standardItemId = entryRow.getLong("standarditem.id");
                if (standardItemId == 0L || salaryStdId == 0L || gradeId == 0L) continue;
                String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
                StdAmountQueryParam stdAmountQueryParam = CalculateUtils.buildStdAmountQueryParam(gradeId, rankId, salaryStdId, standardItemId, unionId);
                salaryStdAmountParams.add(stdAmountQueryParam);
            }
        }
        if (salaryStdAmountParams.isEmpty()) {
            return Collections.emptyList();
        }
        SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        List<StdAmountAndSalaryCountQueryResult> stdAmountAndSalaryCountQueryResults = salaryStdApplicationService.queryAmountAndSalaryCount(new ArrayList<StdAmountQueryParam>(salaryStdAmountParams));
        logger.info("get stdamount Query Result={}", (Object)JSON.toJSONString(stdAmountAndSalaryCountQueryResults));
        return stdAmountAndSalaryCountQueryResults;
    }

    private static Long getGradeOrRankId(Object obj) {
        Long resultId = 0L;
        if (ObjectUtils.isNotEmpty((Object)obj)) {
            if (obj instanceof Long) {
                resultId = (Long)obj;
            }
            if (obj instanceof DynamicObject) {
                resultId = ((DynamicObject)obj).getLong("id");
            }
            if (obj instanceof String) {
                resultId = Long.valueOf((String)obj);
            }
        }
        logger.info("getGradeOrRankId value is:{}", (Object)resultId);
        return resultId;
    }

    private static StdAmountQueryParam buildStdAmountQueryParam(Long gradeId, Long rankId, Long salaryStdId, Long standardItemId, String unionId) {
        StdAmountQueryParam stdAmountQueryParam = new StdAmountQueryParam();
        stdAmountQueryParam.setGradeId(gradeId);
        stdAmountQueryParam.setRankId(rankId);
        stdAmountQueryParam.setStdTabId(salaryStdId);
        stdAmountQueryParam.setItemId(standardItemId);
        stdAmountQueryParam.setUnionId(unionId);
        return stdAmountQueryParam;
    }

    private static Map<Long, List<Pair<Long, Long>>> getAmountStdRange(Map<Long, List<Pair<Long, Long>>> positionInfoMap) {
        ArrayList gradeIdList = new ArrayList(10);
        positionInfoMap.forEach((key, value) -> {
            List positionInfo = (List)positionInfoMap.get(key);
            positionInfo.forEach(item -> {
                Long minRankId = (Long)item.getValue();
                Long maxRankId = (Long)item.getKey();
                if (minRankId == 0L || maxRankId == 0L) {
                    gradeIdList.add(key);
                }
            });
        });
        positionInfoMap.keySet().removeIf(item -> gradeIdList.contains(item));
        return positionInfoMap;
    }

    private static List<Pair<Long, Long>> getAmountStdRange(List<Pair<Long, Long>> positionInfoOfNotUseRankList) {
        HashSet<Long> gradeIdSet = new HashSet<Long>(16);
        for (Pair<Long, Long> positionInfoOfNotUseRank : positionInfoOfNotUseRankList) {
            Long minGradeId = (Long)positionInfoOfNotUseRank.getKey();
            Long maxGradeId = (Long)positionInfoOfNotUseRank.getValue();
            if (minGradeId != 0L && maxGradeId != 0L) continue;
            gradeIdSet.add(minGradeId);
            gradeIdSet.add(maxGradeId);
        }
        positionInfoOfNotUseRankList.removeIf(item -> gradeIdSet.contains(item.getKey()) || gradeIdSet.contains(item.getValue()));
        return positionInfoOfNotUseRankList;
    }

    private static BigDecimal getCoefficientValue(DynamicObject row) {
        DynamicObject coefficientDyobj = row.getDynamicObject("coefficient");
        BigDecimal coefficientvalue = BigDecimal.ONE;
        if (!SWCBaseUtils.isEmpty((DynamicObject)coefficientDyobj)) {
            coefficientvalue = coefficientDyobj.getBigDecimal("coefficientvalue");
        }
        return coefficientvalue;
    }

    private static void calcAmount(BigDecimal presalary, DynamicObject calObj) {
        BigDecimal minrange = calObj.getBigDecimal("suggestminrange");
        BigDecimal maxrange = calObj.getBigDecimal("suggestmaxrange");
        BigDecimal minAmount = SalaryStdCalculateHelper.calcAmountWithRange(presalary, minrange);
        BigDecimal maxAmount = SalaryStdCalculateHelper.calcAmountWithRange(presalary, maxrange);
        calObj.set("suggestminamount", (Object)minAmount);
        calObj.set("suggestmaxamount", (Object)maxAmount);
    }

    private static void calcRatio(BigDecimal presalary, DynamicObject calObj) {
        BigDecimal minAmount = calObj.getBigDecimal("suggestminamount");
        BigDecimal maxAmount = calObj.getBigDecimal("suggestmaxamount");
        BigDecimal minRange = SalaryStdCalculateHelper.calcRangeWithAmount(presalary, minAmount);
        BigDecimal maxRange = SalaryStdCalculateHelper.calcRangeWithAmount(presalary, maxAmount);
        calObj.set("suggestminrange", (Object)minRange);
        calObj.set("suggestmaxrange", (Object)maxRange);
    }

    private static BigDecimal getCalPresalary(long tableCurrency, long tableExctable, DynamicObject calObj, Date tableRateDate, BillExRateManager rateManager, BigDecimal presalary) {
        ExchangeRateInfo exrateInfo;
        Long adjCurrency;
        Long preCurrency = calObj.getLong("precurrency.id");
        if (preCurrency == null || preCurrency <= 0L) {
            preCurrency = calObj.getLong("salarystd.currency.id");
            logger.info("CalculateUtils.getCalPresalary stdTabl preCurrency is:{}", (Object)preCurrency);
        }
        if ((adjCurrency = Long.valueOf(calObj.getLong("currency.id"))) == null || adjCurrency <= 0L) {
            adjCurrency = tableCurrency;
        }
        logger.info("CalculateUtils.getCalPresalary preCurrency is:{0},adjCurrency is:{1}", (Object)preCurrency, (Object)adjCurrency);
        if (tableRateDate != null && preCurrency != null && preCurrency > 0L && tableExctable > 0L && adjCurrency > 0L && !preCurrency.equals(adjCurrency) && (exrateInfo = rateManager.getExRate(new ExRateKey(adjCurrency, preCurrency, tableRateDate.getTime(), tableExctable))) != null) {
            Boolean quoteType = exrateInfo.getQuoteType();
            BigDecimal exchangeRate = exrateInfo.getExchangeRate();
            if (exchangeRate != null) {
                calObj.set("exratevalue", (Object)exchangeRate);
                calObj.set("quotetype", (Object)quoteType);
                presalary = quoteType != false ? presalary.divide(exchangeRate, 2, 4) : presalary.multiply(exchangeRate);
            }
        }
        return presalary;
    }

    public static void setGradeAndRankByStdScmMatchStrategy(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, List<DynamicObject> adjApprPersonList, Set<String> entryPropertySet) {
        for (DynamicObject adjApprPerson : adjApprPersonList) {
            Long adjFileId = adjApprPerson.getLong("adjfile.id");
            if (MapUtils.isEmpty(matchStdResult.get(adjFileId))) continue;
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                Long standardItemId = adjApprPersonEntry.getLong("standarditem.id");
                SalaryStdMatchResultNew salaryStdMatchResult = matchStdResult.get(adjFileId).get(standardItemId);
                if (Objects.isNull(salaryStdMatchResult) || MapUtils.isEmpty((Map)salaryStdMatchResult.getRangeData())) continue;
                String isMatchGradeRank = salaryStdMatchResult.getIsMatchGradeRank();
                String matchStrategy = salaryStdMatchResult.getMatchStrategy();
                if (SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) continue;
                if (entryPropertySet.contains("grade")) {
                    adjApprPersonEntry.set("grade", null);
                }
                if (entryPropertySet.contains("rank")) {
                    adjApprPersonEntry.set("rank", null);
                }
                if (!StringUtils.isEmpty((CharSequence)matchStrategy)) continue;
                if (entryPropertySet.contains("salarypercent")) {
                    adjApprPersonEntry.set("salarypercent", null);
                }
                if (!entryPropertySet.contains("salaryseeprate")) continue;
                adjApprPersonEntry.set("salaryseeprate", null);
            }
        }
    }
}

