/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.DefaultDecAdjApprSyncAdjFilePlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprSyncAdjFileExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.event.BeforeSynDecRecordEvent;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.DecAdjSalaryEntity;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.SalaryAdjRecordRelPersonDynEntity;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.adjfieldcfg.AdjDetailFieldMappingHelper;
import kd.swc.hcdm.business.adjapprbill.enums.YesOrNoEnum;
import kd.swc.hcdm.common.entity.adjfile.DecAdjSalaryEvent;
import kd.swc.hcdm.common.enums.ApplyBillTypeEnum;
import kd.swc.hcdm.common.enums.DecAdjSynStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class DecAdjApprBillSynServiceHelper {
    private static final Log logger = LogFactory.getLog(DecAdjApprBillSynServiceHelper.class);
    private static final AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final SWCDataServiceHelper adjApprPersonHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
    private static final int BATCH_SIZE = 500;

    @Deprecated
    public static void asynDataToRelPerson(String event, DynamicObject billEntity, String operationCode, DynamicObject[] adjApprPersonArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asynDataToRelPersonWithId(String event, DynamicObject billEntity, String operationCode, List<Long> adjApprPersonIdArray) {
        Long adjApprBillId = billEntity.getLong("id");
        String adjApprBillNumber = billEntity.getString("billno");
        String attributionType = billEntity.getString("salaryadjrsn.attributiontype");
        logger.info("apprbilltask syn data start, synToRelPerson adjApprBillId={}, attributionType={}", (Object)adjApprBillId, (Object)attributionType);
        Map<String, String> adjDetailFieldToRecordFieldMap = AdjDetailFieldMappingHelper.getAdjDetailFieldToRecordField();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hcdm_adjapprperson");
        Map<String, IDataEntityProperty> adjApprPersonPropertyMap = DecAdjApprCreateGridHelper.getAdjApprPersonPropertyMap((DynamicObjectType)entityType);
        Map<String, IDataEntityProperty> adjApprPersonEntryPropertyMap = DecAdjApprCreateGridHelper.getAdjApprPersonEntryPropertyMap();
        SWCDataServiceHelper relPersonHelper = new SWCDataServiceHelper("hcdm_decadjrelperson");
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        List partitionAdjApprPersonList = Lists.partition(adjApprPersonIdArray, (int)500);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        for (List subAdjApprPersonIdList : partitionAdjApprPersonList) {
            Object[] array = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)subAdjApprPersonIdList)});
            ArrayList subAdjApprPersonList = Lists.newArrayList((Object[])array);
            DecAdjSalaryEntity decAdjSalaryEntity = null;
            ArrayList<DecAdjSalaryEntity> decAdjSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(10);
            for (DynamicObject adjApprPerson : subAdjApprPersonList) {
                decAdjSalaryEntity = new DecAdjSalaryEntity();
                decAdjSalaryEntity.setSalaryadjfileId(Long.valueOf(adjApprPerson.getLong("adjfile.id")));
                DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
                DynamicObject salaryAdjRecordDyObj = null;
                ArrayList<SalaryAdjRecordRelPersonDynEntity> salaryAdjRecordRelPersonDynEntities = new ArrayList<SalaryAdjRecordRelPersonDynEntity>(adjApprPersonEntryList.size());
                for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                    SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity = new SalaryAdjRecordRelPersonDynEntity();
                    salaryAdjRecordDyObj = recordHelper.generateEmptyDynamicObject();
                    DecAdjApprCreateGridHelper.convertAdjPerToRecord(adjDetailFieldToRecordFieldMap, adjApprPersonEntryPropertyMap, adjApprPersonEntry, salaryAdjRecordDyObj);
                    DynamicObject decAdjLogDyObj = relPersonHelper.generateEmptyDynamicObject();
                    DecAdjApprCreateGridHelper.convertAdjPerToRecord(adjDetailFieldToRecordFieldMap, adjApprPersonPropertyMap, adjApprPerson, decAdjLogDyObj);
                    DecAdjApprBillSynServiceHelper.handleRelPersonData(adjApprPerson, decAdjLogDyObj);
                    DecAdjApprBillSynServiceHelper.handleRelRecordData(billEntity, adjDetailFieldToRecordFieldMap, adjApprPerson, salaryAdjRecordDyObj);
                    salaryAdjRecordRelPersonDynEntity.setSalaryAdjRecord(salaryAdjRecordDyObj);
                    salaryAdjRecordRelPersonDynEntity.setRelpersonDyn(decAdjLogDyObj);
                    salaryAdjRecordRelPersonDynEntities.add(salaryAdjRecordRelPersonDynEntity);
                }
                decAdjSalaryEntity.setBussinessId(adjApprBillId);
                decAdjSalaryEntity.setBillType(AdjAttributionType.getByCode((String)attributionType));
                decAdjSalaryEntity.setSalaryAdjRecordRelPersonDynEntities(salaryAdjRecordRelPersonDynEntities);
                decAdjSalaryEntityList.add(decAdjSalaryEntity);
            }
            boolean isSuccess = false;
            String errorMsg = "";
            try {
                TXHandle txHandle = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        DecAdjApprBillSynServiceHelper.beforeSynDecRecordExt(subAdjApprPersonList, decAdjSalaryEntityList);
                        adjFileApplicationService.saveTimeVersionForBill(decAdjSalaryEntityList, new DecAdjSalaryEvent(event));
                        DecAdjApprBillSynServiceHelper.updateAdjApprPersonSynStatus(subAdjApprPersonList, DecAdjSynStatusEnum.SUCCESS);
                        DecAdjApprBillSynServiceHelper.insertSyncAdjFileLog(adjApprBillId, adjApprBillNumber, decAdjSalaryEntityList, operationCode, attributionType, YesOrNoEnum.YES.getCode(), errorMsg);
                        isSuccess = true;
                    }
                    catch (Exception e) {
                        logger.error("apprbilltask syn data to relperson ", (Throwable)e);
                        errorMsg = e.toString();
                        txHandle.markRollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txHandle == null) continue;
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    txHandle.close();
                }
            }
            finally {
                if (isSuccess) continue;
                DecAdjApprBillSynServiceHelper.updateAdjApprPersonSynStatus(subAdjApprPersonList, DecAdjSynStatusEnum.FAILED);
                DecAdjApprBillSynServiceHelper.insertSyncAdjFileLog(adjApprBillId, adjApprBillNumber, decAdjSalaryEntityList, operationCode, attributionType, YesOrNoEnum.NO.getCode(), errorMsg);
            }
        }
    }

    private static void beforeSynDecRecordExt(List<DynamicObject> adjApprPersonList, List<DecAdjSalaryEntity> decAdjSalaryEntityList) {
        BeforeSynDecRecordEvent paramEvent = new BeforeSynDecRecordEvent(adjApprPersonList, decAdjSalaryEntityList);
        DefaultDecAdjApprSyncAdjFilePlugin extPlugin = new DefaultDecAdjApprSyncAdjFilePlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extPlugin, IDecAdjApprSyncAdjFileExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprSyncAdjFileExtPlugin#beforeSynDecRecord", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.beforeSynDecRecord(paramEvent);
            return null;
        });
    }

    private static void updateAdjApprPersonSynStatus(List<DynamicObject> subAdjApprPersonList, DecAdjSynStatusEnum decAdjSynStatusEnum) {
        for (DynamicObject subAdjApprPerson : subAdjApprPersonList) {
            subAdjApprPerson.set("synstatus", (Object)decAdjSynStatusEnum.getCode());
        }
        adjApprPersonHelper.update(subAdjApprPersonList.toArray(new DynamicObject[subAdjApprPersonList.size()]));
    }

    private static void insertSyncAdjFileLog(Long adjApprBillId, String adjApprBillNumber, List<DecAdjSalaryEntity> decAdjSalaryEntityList, String operation, String attributionType, String isSuccess, String errorMsg) {
        Map decAdjSalaryEntityMap = decAdjSalaryEntityList.stream().collect(Collectors.toMap(DecAdjSalaryEntity::getSalaryadjfileId, Function.identity(), (o1, o2) -> o2));
        SWCDataServiceHelper syncAdjFileLogHelper = new SWCDataServiceHelper("hcdm_syncadjfilelog");
        DynamicObjectCollection syncAdjFileLogDyObjColl = new DynamicObjectCollection();
        for (Long adjFileId : decAdjSalaryEntityMap.keySet()) {
            DynamicObject syncAdjFileLogDyObj = syncAdjFileLogHelper.generateEmptyDynamicObject();
            syncAdjFileLogDyObj.set("applybillid", (Object)adjApprBillId);
            syncAdjFileLogDyObj.set("applbillnum", (Object)adjApprBillNumber);
            syncAdjFileLogDyObj.set("adjfile", (Object)adjFileId);
            syncAdjFileLogDyObj.set("operation", (Object)operation);
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                syncAdjFileLogDyObj.set("applybilltype", (Object)ApplyBillTypeEnum.DEC.getCode());
            } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) {
                syncAdjFileLogDyObj.set("applybilltype", (Object)ApplyBillTypeEnum.ADJ.getCode());
            }
            syncAdjFileLogDyObj.set("issuccess", (Object)isSuccess);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg) && errorMsg.length() > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            syncAdjFileLogDyObj.set("errormsg", (Object)errorMsg);
            syncAdjFileLogDyObjColl.add((Object)syncAdjFileLogDyObj);
        }
        syncAdjFileLogHelper.save(syncAdjFileLogDyObjColl);
    }

    private static void handleRelPersonData(DynamicObject adjApprPerson, DynamicObject decAdjLogDyObj) {
        decAdjLogDyObj.set("country", (Object)adjApprPerson.getLong("adjfile.country.id"));
        decAdjLogDyObj.set("org", (Object)adjApprPerson.getLong("adjfile.org.id"));
        decAdjLogDyObj.set("depemp", (Object)adjApprPerson.getLong("adjfile.depemp.id"));
    }

    private static void handleRelRecordData(DynamicObject billEntity, Map<String, String> adjDetailFieldToRecordFieldMap, DynamicObject adjApprPerson, DynamicObject salaryAdjRecordDyObj) {
        DynamicObject salaryAdjRsnDyObj = billEntity.getDynamicObject("salaryadjrsn");
        salaryAdjRecordDyObj.set(adjDetailFieldToRecordFieldMap.get("adjfile"), (Object)adjApprPerson.getDynamicObject("adjfile"));
        salaryAdjRecordDyObj.set(adjDetailFieldToRecordFieldMap.get("adjfilevid"), (Object)adjApprPerson.getDynamicObject("adjfilevid"));
        salaryAdjRecordDyObj.set("salaryadjrsn", (Object)salaryAdjRsnDyObj);
        salaryAdjRecordDyObj.set("datasource", (Object)"3");
        salaryAdjRecordDyObj.set("creator", (Object)billEntity.getDynamicObject("creator"));
    }
}

