/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprBillSynServiceHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.entity.AdjApprPerQueryParam;
import kd.swc.hcdm.common.enums.ConfirmStatusEnum;
import kd.swc.hcdm.common.enums.DecAdjSynStatusEnum;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class DecAdjApprBillTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(DecAdjApprBillTask.class);
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final String adjApprPerSelectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjapprperson");
    private SWCDataServiceHelper adjApprPersonHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
    private RequestContext requestContext;
    private DynamicObject[] dataEntities;
    private String operationCode;

    public DecAdjApprBillTask(DynamicObject[] dataEntities, String operationCode, RequestContext requestContext) {
        this.dataEntities = dataEntities;
        this.requestContext = requestContext;
        this.operationCode = operationCode;
    }

    @Override
    public void run() {
        try {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            for (DynamicObject dataEntity : this.dataEntities) {
                logger.info("apprbilltask syn data start.");
                Long adjApprBillId = dataEntity.getLong("id");
                String event = this.adjFileApplicationService.beginEvent(EventTypeEnum.DECADJ.getCode());
                this.synToRelPerson(dataEntity, event);
                QFilter adjApprBillQFilter = new QFilter("adjapprbill", "in", (Object)adjApprBillId);
                QFilter statusQFilter = new QFilter("synstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{DecAdjSynStatusEnum.TO_SYNC.getCode(), DecAdjSynStatusEnum.FAILED.getCode()}));
                QFilter confirmStatusQFilter = new QFilter("confirmstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ConfirmStatusEnum.HAS_CONFIRM.getCode()}));
                Integer count = this.adjApprPersonHelper.count(new QFilter[]{adjApprBillQFilter, statusQFilter, confirmStatusQFilter});
                if (count == 0) {
                    this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
                    continue;
                }
                logger.error("apprbillid = {} apprbilltask asyn data finished, need timer task todo.", (Object)adjApprBillId);
            }
        }
        catch (Exception e) {
            logger.error("apprbilltask syn data error\uff1a", (Throwable)e);
        }
    }

    private void synToRelPerson(DynamicObject billEntity, String event) {
        Long adjApprBillId = billEntity.getLong("id");
        AdjApprPerQueryParam adjApprPerQueryParam = new AdjApprPerQueryParam();
        adjApprPerQueryParam.setAdjApprBillIds(Lists.newArrayList((Object[])new Long[]{adjApprBillId}));
        adjApprPerQueryParam.setSynStatusList(Lists.newArrayList((Object[])new String[]{DecAdjSynStatusEnum.TO_SYNC.getCode(), DecAdjSynStatusEnum.FAILED.getCode()}));
        adjApprPerQueryParam.setConfirmStatusList(Lists.newArrayList((Object[])new String[]{ConfirmStatusEnum.HAS_CONFIRM.getCode()}));
        DynamicObject[] adjApprPersonArray = DecAdjApprGridHelper.getAdjApprPersonData("id", adjApprPerQueryParam);
        if (adjApprPersonArray.length == 0) {
            return;
        }
        List<Long> idList = Arrays.stream(adjApprPersonArray).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        DecAdjApprBillSynServiceHelper.asynDataToRelPersonWithId(event, billEntity, this.operationCode, idList);
    }
}

