/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.Features;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.DefaultDecAdjApprSupportPlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.event.AfterBuildEntryGridEvent;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.common.constants.DecAdjApprConstants;
import kd.swc.hcdm.common.entity.adjapprbill.MulDynamicGridFieldIdGenerationParam;
import kd.swc.hcdm.common.enums.FieldGroupEnum;
import kd.swc.hsbp.common.dynamic.FieldIdGenerationParam;
import kd.swc.hsbp.common.dynamic.grid.AmountFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.BasedataFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.ComboFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.CurrencyFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.DateParamContainer;
import kd.swc.hsbp.common.dynamic.grid.DecimalFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.FieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.GroupParamContainer;
import kd.swc.hsbp.common.dynamic.grid.MulBasedataFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.TextFieldParamContainer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DecAdjApprCreateGridHelper {
    private static Log logger = LogFactory.getLog(DecAdjApprCreateGridHelper.class);
    private static AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);

    public static EntryAp createEntryAp(EntityMetadata entityMetadata, Long adjFieldCfgId, DynamicObjectType entityType) {
        List<EntryParamContainer> params = DecAdjApprCreateGridHelper.createEntryBuildParam(entityMetadata, adjFieldCfgId, entityType);
        EntryAp entryAp = EntryParamContainerBaseHelper.createEntryAp((String)"adjapprdetailentry");
        entryAp.setShowGridConfig(true);
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setShowSeq(true);
        entryAp.setShowGridConfig(false);
        entryAp.setOrderAndFilter(0);
        return EntryParamContainerBaseHelper.createControlAp((EntryAp)entryAp, params);
    }

    public static void registerProp(EntityType entryType, Long adjFieldCfgId, DynamicObjectType entityType) {
        List<EntryParamContainer> params = DecAdjApprCreateGridHelper.createEntryBuildParam(null, adjFieldCfgId, entityType);
        EntryParamContainerBaseHelper.registProp(params, (EntityType)entryType);
    }

    private static List<EntryParamContainer> createEntryBuildParam(EntityMetadata entityMetadata, Long adjFieldCfgId, DynamicObjectType entityType) {
        Map<String, ControlAp> controlMap = DecAdjApprCreateGridHelper.getControlApMap();
        EntityMetadata perEntityMetadata = DecAdjApprCreateGridHelper.getPersonMeta();
        Map<String, IDataEntityProperty> dataEntityPropertyMap = DecAdjApprCreateGridHelper.getDataEntityPropertyMap(entityType);
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(10);
        DynamicObject adjFieldCfgWithPerm = adjApprovalApplicationService.getAdjFieldCfgById(adjFieldCfgId);
        DecAdjApprCreateGridHelper.setCoreFieldWhenAbsent(adjFieldCfgWithPerm, Lists.newArrayList((Object[])new String[]{"stdscm"}));
        DynamicObjectCollection adjFieldCfgWithPermDetail = adjFieldCfgWithPerm.getDynamicObjectCollection("entryentity");
        MainEntityType adjDetailFieldMeta = EntityMetadataCache.getDataEntityType((String)"hcdm_adjdetailfield");
        ComboProp groupProp = (ComboProp)adjDetailFieldMeta.getProperty("group");
        Map<String, List<DynamicObject>> adjFieldCfgMap = adjFieldCfgWithPermDetail.stream().collect(Collectors.groupingBy(key -> key.getString("adjdetailfield.group")));
        for (Map.Entry<String, List<DynamicObject>> entry : adjFieldCfgMap.entrySet()) {
            GroupParamContainer groupParam = EntryParamContainerBaseHelper.createGroupParamContainer((String)entry.getKey(), (String)groupProp.getItemByName(entry.getKey()), (boolean)false);
            groupParam.setGroupCollapsible(true);
            List<DynamicObject> propertyNameDyList = entry.getValue();
            for (DynamicObject fieldCfg : propertyNameDyList) {
                FieldParamContainer fieldParamContainer;
                String propertyName = fieldCfg.getString("adjdetailfield.fieldnumber");
                int width = fieldCfg.getInt("adjdetailfield.width");
                String canImport = fieldCfg.getString("adjdetailfield.canimport");
                String canExport = fieldCfg.getString("adjdetailfield.canexport");
                boolean mustInput = StringUtils.equals((CharSequence)fieldCfg.getString("adjdetailfield.mustinput"), (CharSequence)"1");
                boolean designHidden = StringUtils.equals((CharSequence)fieldCfg.getString("adjdetailfield.designhidden"), (CharSequence)"1");
                if ("prerank".equals(propertyName) || "pregrade".equals(propertyName) || "rank".equals(propertyName) || "grade".equals(propertyName)) {
                    width = 120;
                }
                String widthStr = width == 0 ? "200px" : width + "px";
                ControlAp formMetaItem = controlMap.get(propertyName);
                Field field = perEntityMetadata.getFieldByKey(propertyName);
                IDataEntityProperty property = dataEntityPropertyMap.get(propertyName);
                if (property == null || formMetaItem == null || (fieldParamContainer = DecAdjApprCreateGridHelper.buildFieldParamContainer(property, field)) == null) continue;
                DecAdjApprCreateGridHelper.setBaseFieldValue(fieldParamContainer, entityMetadata, propertyName, formMetaItem, property);
                fieldParamContainer.getFeatures().setImportable(StringUtils.equals((CharSequence)canImport, (CharSequence)"1"));
                fieldParamContainer.getFeatures().setExportable(StringUtils.equals((CharSequence)canExport, (CharSequence)"1"));
                fieldParamContainer.setMustInput(mustInput);
                fieldParamContainer.setWidth(widthStr);
                fieldParamContainer.setHidden(designHidden);
                groupParam.addChild((EntryParamContainer)fieldParamContainer);
            }
            allContainer.add((EntryParamContainer)groupParam);
        }
        DecAdjApprCreateGridHelper.addHiddenColumn(allContainer, entityMetadata, dataEntityPropertyMap);
        DecAdjApprCreateGridHelper.dealSpecialColumn(allContainer, adjFieldCfgWithPerm, controlMap);
        DecAdjApprCreateGridHelper.setColumnHiddenStatusWithExt(allContainer);
        return allContainer;
    }

    private static void setCoreFieldWhenAbsent(DynamicObject adjFieldCfgWithPerm, List<String> coreFields) {
        List<DynamicObject> coreFieldObj;
        if (adjFieldCfgWithPerm == null) {
            return;
        }
        String attributionType = adjFieldCfgWithPerm.getString("attributiontype");
        DynamicObjectCollection adjFieldCfgWithPermDetail = adjFieldCfgWithPerm.getDynamicObjectCollection("entryentity");
        ArrayList coreFieldInCfg = Lists.newArrayListWithCapacity((int)coreFields.size());
        for (DynamicObject fieldCfg : adjFieldCfgWithPermDetail) {
            String propertyName = fieldCfg.getString("adjdetailfield.fieldnumber");
            if (!coreFields.contains(propertyName)) continue;
            coreFieldInCfg.add(propertyName);
        }
        coreFields.removeAll(coreFieldInCfg);
        if (!coreFields.isEmpty() && CollectionUtils.isNotEmpty(coreFieldObj = adjApprovalApplicationService.getAdjDetailField(coreFields, attributionType))) {
            for (DynamicObject dynamicObject : coreFieldObj) {
                DynamicObject appendField = adjFieldCfgWithPermDetail.addNew();
                appendField.set("adjdetailfield", (Object)dynamicObject);
            }
        }
    }

    private static void setColumnHiddenStatusWithExt(List<EntryParamContainer> allContainer) {
        AfterBuildEntryGridEvent afterBuildEntryGridEvent = new AfterBuildEntryGridEvent();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultDecAdjApprSupportPlugin(), IDecAdjApprExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprExtPlugin#setColumnHiddenStatus", null);
        proxy.callAfter(plugin -> {
            plugin.setColumnHiddenStatus(afterBuildEntryGridEvent);
            return null;
        });
        Map paramMap = afterBuildEntryGridEvent.getParamMap();
        if (MapUtils.isNotEmpty((Map)paramMap)) {
            for (EntryParamContainer entryParamContainer : allContainer) {
                if (!(entryParamContainer instanceof GroupParamContainer)) continue;
                GroupParamContainer groupParamContainer = (GroupParamContainer)entryParamContainer;
                List groupParamContainerChild = groupParamContainer.getChild();
                for (EntryParamContainer childParamContainer : groupParamContainerChild) {
                    String key = childParamContainer.getKey();
                    if (paramMap.get(key) == null || !(paramMap.get(key) instanceof Boolean)) continue;
                    childParamContainer.setHidden(((Boolean)paramMap.get(key)).booleanValue());
                }
            }
        }
    }

    private static Map<String, IDataEntityProperty> getDataEntityPropertyMap(DynamicObjectType entityType) {
        HashMap<String, IDataEntityProperty> dataEntityPropertyMap = new HashMap<String, IDataEntityProperty>(16);
        DataEntityPropertyCollection entityTypeProperties = entityType.getProperties();
        for (IDataEntityProperty dataEntityProperty : entityTypeProperties) {
            if ("entryentity".equals(dataEntityProperty.getName())) {
                DynamicObjectType entryEntityProperty = ((EntryProp)entityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryEntityDataEntityProperties = entryEntityProperty.getProperties();
                for (IDataEntityProperty entryEntityDataEntityProperty : entryEntityDataEntityProperties) {
                    dataEntityPropertyMap.put(entryEntityDataEntityProperty.getName(), entryEntityDataEntityProperty);
                }
                continue;
            }
            dataEntityPropertyMap.put(dataEntityProperty.getName(), dataEntityProperty);
        }
        return dataEntityPropertyMap;
    }

    private static Map<String, ControlAp> getControlApMap() {
        String adjApprPersonMetaId = MetadataDao.getIdByNumber((String)"hcdm_adjapprperson", (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)adjApprPersonMetaId, (MetaCategory)MetaCategory.Form);
        HashMap<String, ControlAp> controlMap = new HashMap<String, ControlAp>(16);
        for (ControlAp controlAp : formMeta.getItems()) {
            if (controlAp instanceof EntryAp) {
                EntryAp entryAp = (EntryAp)controlAp;
                List entryApItems = entryAp.getItems();
                for (ControlAp entryItemAp : entryApItems) {
                    controlMap.put(entryItemAp.getKey(), entryItemAp);
                }
                continue;
            }
            controlMap.put(controlAp.getKey(), controlAp);
        }
        return controlMap;
    }

    private static EntityMetadata getPersonMeta() {
        String adjApprPersonMetaId = MetadataDao.getIdByNumber((String)"hcdm_adjapprperson", (MetaCategory)MetaCategory.Form);
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)adjApprPersonMetaId, (MetaCategory)MetaCategory.Entity);
    }

    private static void addHiddenColumn(List<EntryParamContainer> allContainer, EntityMetadata entityMetadata, Map<String, IDataEntityProperty> dataEntityPropertyMap) {
        for (EntryParamContainer entryParamContainer : allContainer) {
            if (!(entryParamContainer instanceof GroupParamContainer)) continue;
            GroupParamContainer groupParamContainer = (GroupParamContainer)entryParamContainer;
            if (FieldGroupEnum.STRUCT_INFO.getCode().equals(groupParamContainer.getKey())) {
                groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addBaseDataFieldColumn(entityMetadata, "hcdm_salarystandard", "salarystd", ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u8868", (String)"DecAdjApprCreateGridHelper_5", (String)"swc-hcdm-business", (Object[])new Object[0])));
                groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addBaseDataFieldColumn(entityMetadata, "hcdm_salarystandard", "presalarystd", ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u8868", (String)"DecAdjApprCreateGridHelper_5", (String)"swc-hcdm-business", (Object[])new Object[0])));
                groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addBaseDataFieldColumn(entityMetadata, "hcdm_coefficient", "coefficient", ResManager.loadKDString((String)"\u7cfb\u6570", (String)"DecAdjApprCreateGridHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0])));
                groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addComboFieldColumn(entityMetadata, "ismatchgraderank", ResManager.loadKDString((String)"\u662f\u5426\u663e\u793a\u85aa\u7b49\u85aa\u6863", (String)"DecAdjApprCreateGridHelper_30", (String)"swc-hcdm-business", (Object[])new Object[0])));
                groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addComboFieldColumn(entityMetadata, "matchstrategy", ResManager.loadKDString((String)"\u5339\u914d\u7b56\u7565", (String)"DecAdjApprCreateGridHelper_31", (String)"swc-hcdm-business", (Object[])new Object[0])));
                continue;
            }
            if (FieldGroupEnum.DEC_INFO.getCode().equals(groupParamContainer.getKey())) {
                DecAdjApprCreateGridHelper.addCommonParamContainer(entityMetadata, groupParamContainer);
                continue;
            }
            if (FieldGroupEnum.PERSON_INFO.getCode().equals(groupParamContainer.getKey())) {
                BasedataFieldParamContainer employeeBasedataFieldParamContainer = DecAdjApprCreateGridHelper.addBaseDataFieldColumn(entityMetadata, "hrpi_employee", "employee", ResManager.loadKDString((String)"\u4f01\u4e1a\u4eba", (String)"DecAdjApprCreateGridHelper_9", (String)"swc-hcdm-business", (Object[])new Object[0]));
                employeeBasedataFieldParamContainer.setFeatures(DecAdjApprCreateGridHelper.getCopyFeatures("employee", dataEntityPropertyMap));
                groupParamContainer.getChild().add(employeeBasedataFieldParamContainer);
                BasedataFieldParamContainer personBasedataFieldParamContainer = DecAdjApprCreateGridHelper.addBaseDataFieldColumn(entityMetadata, "hrpi_person", "person", ResManager.loadKDString((String)"\u81ea\u7136\u4eba", (String)"DecAdjApprCreateGridHelper_10", (String)"swc-hcdm-business", (Object[])new Object[0]));
                personBasedataFieldParamContainer.setFeatures(DecAdjApprCreateGridHelper.getCopyFeatures("person", dataEntityPropertyMap));
                groupParamContainer.getChild().add(personBasedataFieldParamContainer);
                TextFieldParamContainer personAttrTextFieldParamContainer = DecAdjApprCreateGridHelper.addTextFieldColumn(entityMetadata, "personattrdata", ResManager.loadKDString((String)"\u4eba\u5458\u5c5e\u6027\u5217(\u5b58JSON\u5b57\u7b26\u4e32)", (String)"DecAdjApprCreateGridHelper_15", (String)"swc-hcdm-business", (Object[])new Object[0]), true);
                personAttrTextFieldParamContainer.setFeatures(DecAdjApprCreateGridHelper.getCopyFeatures("personattrdata", dataEntityPropertyMap));
                groupParamContainer.getChild().add(personAttrTextFieldParamContainer);
                BasedataFieldParamContainer adjFileVidBasedataFieldParamContainer = DecAdjApprCreateGridHelper.addBaseDataFieldColumn(entityMetadata, "hcdm_adjfileinfo", "adjfilevid", ResManager.loadKDString((String)"\u6863\u6848\u7248\u672c", (String)"DecAdjApprCreateGridHelper_21", (String)"swc-hcdm-business", (Object[])new Object[0]));
                groupParamContainer.getChild().add(adjFileVidBasedataFieldParamContainer);
                BasedataFieldParamContainer depEmpBasedataFieldParamContainer = DecAdjApprCreateGridHelper.addBaseDataFieldColumn(entityMetadata, "hrpi_depemp", "depemp", ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba", (String)"DecAdjApprCreateGridHelper_22", (String)"swc-hcdm-business", (Object[])new Object[0]));
                groupParamContainer.getChild().add(depEmpBasedataFieldParamContainer);
                continue;
            }
            if (!FieldGroupEnum.CURR_INFO.getCode().equals(groupParamContainer.getKey())) continue;
            DecAdjApprCreateGridHelper.addCommonParamContainer(entityMetadata, groupParamContainer);
            TextFieldParamContainer amountStdRangeText = DecAdjApprCreateGridHelper.addTextFieldColumn(entityMetadata, "amountstdrangedisplay", ResManager.loadKDString((String)"\u85aa\u7b49\u85aa\u6863\u533a\u95f4", (String)"DecAdjApprCreateGridHelper_19", (String)"swc-hcdm-business", (Object[])new Object[0]), false);
            Features copyAndExport = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
            copyAndExport.setExportable(true);
            amountStdRangeText.setFeatures(copyAndExport);
            groupParamContainer.getChild().add(amountStdRangeText);
        }
    }

    private static void addCommonParamContainer(EntityMetadata entityMetadata, GroupParamContainer groupParamContainer) {
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addComboFieldColumn(entityMetadata, "excesscontrol", ResManager.loadKDString((String)"\u8d85\u6807\u51c6\u63a7\u5236", (String)"DecAdjApprCreateGridHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0])));
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addTextFieldColumn(entityMetadata, "salargrel", ResManager.loadKDString((String)"\u6807\u51c6\u8868\u4e0e\u85aa\u7b49\u85aa\u6863\u5173\u7cfb", (String)"DecAdjApprCreateGridHelper_11", (String)"swc-hcdm-business", (Object[])new Object[0]), true));
        AmountFieldParamContainer stdAmountFieldParamContainer = DecAdjApprCreateGridHelper.addAmountFieldColumn(entityMetadata, DecAdjApprConstants.KEY_STDAMOUNT, ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u91d1\u989d", (String)"DecAdjApprCreateGridHelper_12", (String)"swc-hcdm-business", (Object[])new Object[0]));
        stdAmountFieldParamContainer.setEnableNull(true);
        groupParamContainer.getChild().add(stdAmountFieldParamContainer);
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addAmountFieldColumn(entityMetadata, DecAdjApprConstants.KEY_INTERVALMIN, ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u91d1\u989dMin", (String)"DecAdjApprCreateGridHelper_13", (String)"swc-hcdm-business", (Object[])new Object[0])));
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addAmountFieldColumn(entityMetadata, DecAdjApprConstants.KEY_INTERVALMIDDLE, ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u4e2d\u4f4d\u503c\u91d1\u989d", (String)"DecAdjApprCreateGridHelper_25", (String)"swc-hcdm-business", (Object[])new Object[0])));
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addAmountFieldColumn(entityMetadata, DecAdjApprConstants.KEY_INTERVALMAX, ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u91d1\u989dMax", (String)"DecAdjApprCreateGridHelper_14", (String)"swc-hcdm-business", (Object[])new Object[0])));
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addDecimalFieldColumn(entityMetadata, DecAdjApprConstants.KEY_EXRATEVALUE, ResManager.loadKDString((String)"\u6c47\u7387\u503c", (String)"DecAdjApprCreateGridHelper_27", (String)"swc-hcdm-business", (Object[])new Object[0])));
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addTextFieldColumn(entityMetadata, DecAdjApprConstants.KEY_QUOTETYPE, ResManager.loadKDString((String)"\u6362\u7b97\u65b9\u5f0f", (String)"DecAdjApprCreateGridHelper_28", (String)"swc-hcdm-business", (Object[])new Object[0]), true));
        AmountFieldParamContainer amountLogicFieldParamContainer = DecAdjApprCreateGridHelper.addAmountFieldColumn(entityMetadata, DecAdjApprConstants.KEY_AMOUNTLOGIC, ResManager.loadKDString((String)"\u91d1\u989d\u903b\u8f91\u5b57\u6bb5", (String)"DecAdjApprCreateGridHelper_29", (String)"swc-hcdm-business", (Object[])new Object[0]));
        amountLogicFieldParamContainer.setEnableNull(true);
        groupParamContainer.getChild().add(amountLogicFieldParamContainer);
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addTextFieldColumn(entityMetadata, "isuserank", ResManager.loadKDString((String)"\u662f\u5426\u542f\u7528\u85aa\u6863(\u903b\u8f91\u5b57\u6bb5)", (String)"DecAdjApprCreateGridHelper_23", (String)"swc-hcdm-business", (Object[])new Object[0]), true));
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addTextFieldColumn(entityMetadata, "preisuserank", ResManager.loadKDString((String)"\u662f\u5426\u542f\u7528\u85aa\u6863(\u8c03\u524d\u903b\u8f91\u5b57\u6bb5)", (String)"DecAdjApprCreateGridHelper_24", (String)"swc-hcdm-business", (Object[])new Object[0]), true));
        groupParamContainer.getChild().add(DecAdjApprCreateGridHelper.addTextFieldColumn(entityMetadata, "afterjsondata", ResManager.loadKDString((String)"\u8c03\u85aa\u540e\u4eba\u5458\u4fe1\u606fJSON\u5b57\u6bb5", (String)"DecAdjApprCreateGridHelper_26", (String)"swc-hcdm-business", (Object[])new Object[0]), true));
    }

    private static Features getCopyFeatures(String property, Map<String, IDataEntityProperty> dataEntityPropertyMap) {
        IFieldHandle iDataEntityProperty = (IFieldHandle)dataEntityPropertyMap.get(property);
        Features copyAndExport = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        copyAndExport.setCopyable(iDataEntityProperty.isCopyable());
        return copyAndExport;
    }

    private static BasedataFieldParamContainer addBaseDataFieldColumn(EntityMetadata entityMetadata, String baseEntityId, String key, String name) {
        BasedataFieldParamContainer baseDataFieldParamContainer = new BasedataFieldParamContainer();
        baseDataFieldParamContainer.setBaseEntityId(baseEntityId);
        baseDataFieldParamContainer.setKey(DecAdjApprCreateGridHelper.buildKey(key));
        baseDataFieldParamContainer.setName(name);
        baseDataFieldParamContainer.setHidden(true);
        baseDataFieldParamContainer.setEntityMetadata(entityMetadata);
        return baseDataFieldParamContainer;
    }

    private static TextFieldParamContainer addTextFieldColumn(EntityMetadata entityMetadata, String key, String name, boolean hidden) {
        TextFieldParamContainer textFieldParamContainer = new TextFieldParamContainer();
        textFieldParamContainer.setKey(DecAdjApprCreateGridHelper.buildKey(key));
        textFieldParamContainer.setName(name);
        textFieldParamContainer.setHidden(hidden);
        textFieldParamContainer.setEntityMetadata(entityMetadata);
        textFieldParamContainer.setMaxLength(Integer.MAX_VALUE);
        return textFieldParamContainer;
    }

    private static AmountFieldParamContainer addAmountFieldColumn(EntityMetadata entityMetadata, String key, String name) {
        AmountFieldParamContainer amountFieldParamContainer = new AmountFieldParamContainer();
        amountFieldParamContainer.setKey(DecAdjApprCreateGridHelper.buildKey(key));
        amountFieldParamContainer.setName(name);
        amountFieldParamContainer.setHidden(true);
        amountFieldParamContainer.setEntityMetadata(entityMetadata);
        return amountFieldParamContainer;
    }

    private static ComboFieldParamContainer addComboFieldColumn(EntityMetadata entityMetadata, String key, String name) {
        ComboFieldParamContainer comboFieldParamContainer = new ComboFieldParamContainer();
        comboFieldParamContainer.setKey(DecAdjApprCreateGridHelper.buildKey(key));
        comboFieldParamContainer.setName(name);
        comboFieldParamContainer.setHidden(true);
        comboFieldParamContainer.setEntityMetadata(entityMetadata);
        return comboFieldParamContainer;
    }

    private static DecimalFieldParamContainer addDecimalFieldColumn(EntityMetadata entityMetadata, String key, String name) {
        DecimalFieldParamContainer decimalFieldParamContainer = new DecimalFieldParamContainer();
        decimalFieldParamContainer.setKey(DecAdjApprCreateGridHelper.buildKey(key));
        decimalFieldParamContainer.setName(name);
        decimalFieldParamContainer.setHidden(true);
        decimalFieldParamContainer.setEntityMetadata(entityMetadata);
        return decimalFieldParamContainer;
    }

    private static void dealSpecialColumn(List<EntryParamContainer> allContainer, DynamicObject adjFieldCfgWithPerm, Map<String, ControlAp> controlMap) {
        for (EntryParamContainer entryParamContainer : allContainer) {
            if (!(entryParamContainer instanceof GroupParamContainer)) continue;
            GroupParamContainer groupParamContainer = (GroupParamContainer)entryParamContainer;
            List groupParamContainerChild = groupParamContainer.getChild();
            for (EntryParamContainer childParamContainer : groupParamContainerChild) {
                String attributionType;
                if (childParamContainer instanceof BasedataFieldParamContainer) {
                    BasedataFieldParamContainer basedataFieldParamContainer = (BasedataFieldParamContainer)childParamContainer;
                    if (DecAdjApprCreateGridHelper.buildKey("adjfile").equals(basedataFieldParamContainer.getKey())) {
                        basedataFieldParamContainer.setDisplayProp("number");
                        basedataFieldParamContainer.setHyperlink(true);
                        basedataFieldParamContainer.setViewDetail(false);
                        continue;
                    }
                    if (DecAdjApprCreateGridHelper.buildKey("grade").equals(basedataFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("rank").equals(basedataFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("pregrade").equals(basedataFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("prerank").equals(basedataFieldParamContainer.getKey())) {
                        basedataFieldParamContainer.setDisplayStyle(1);
                        basedataFieldParamContainer.setViewDetail(false);
                        Set containerKeys = groupParamContainerChild.stream().map(item -> item.getKey()).collect(Collectors.toSet());
                        if (!containerKeys.contains(DecAdjApprCreateGridHelper.buildKey("calctype"))) continue;
                        basedataFieldParamContainer.setLock("audit");
                        continue;
                    }
                    if (!DecAdjApprCreateGridHelper.buildKey("currency").equals(basedataFieldParamContainer.getKey())) continue;
                    basedataFieldParamContainer.setBasedataEditStyle(1);
                    continue;
                }
                if (childParamContainer instanceof DecimalFieldParamContainer) {
                    DecimalFieldParamContainer decimalFieldParamContainer = (DecimalFieldParamContainer)childParamContainer;
                    if (DecAdjApprCreateGridHelper.buildKey("salarypercent").equals(decimalFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("salaryseeprate").equals(decimalFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("presalarypercent").equals(decimalFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("presalaryseeprate").equals(decimalFieldParamContainer.getKey())) {
                        decimalFieldParamContainer.setMask("#,###");
                        decimalFieldParamContainer.setDisplayFormatString("##.00%");
                        decimalFieldParamContainer.setScale(4);
                    }
                    if (DecAdjApprCreateGridHelper.buildKey("salarypercent").equals(decimalFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("presalarypercent").equals(decimalFieldParamContainer.getKey())) {
                        Tips percentTip = new Tips();
                        percentTip.setType("text");
                        attributionType = adjFieldCfgWithPerm.getString("attributiontype");
                        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                            percentTip.setContent(new LocaleString(ResManager.loadKDString((String)"\u85aa\u916c\u6bd4\u7387=\u5b9a\u85aa\u91d1\u989d/(\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u4e2d\u4f4d\u503c*\u7cfb\u6570)*100", (String)"DecAdjApprCreateGridHelper_6", (String)"swc-hcdm-business", (Object[])new Object[0])));
                        } else {
                            percentTip.setContent(new LocaleString(ResManager.loadKDString((String)"\u85aa\u916c\u6bd4\u7387=\u91d1\u989d/(\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u4e2d\u4f4d\u503cx\u7cfb\u6570)x100\u3002", (String)"DecAdjApprCreateGridHelper_16", (String)"swc-hcdm-business", (Object[])new Object[0])));
                        }
                        decimalFieldParamContainer.setTips(percentTip);
                        continue;
                    }
                    if (DecAdjApprCreateGridHelper.buildKey("salaryseeprate").equals(decimalFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey("presalaryseeprate").equals(decimalFieldParamContainer.getKey())) {
                        Tips rateTip = new Tips();
                        rateTip.setType("text");
                        attributionType = adjFieldCfgWithPerm.getString("attributiontype");
                        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                            rateTip.setContent(new LocaleString(ResManager.loadKDString((String)"\u85aa\u916c\u6e17\u900f\u7387=(\u5b9a\u85aa\u91d1\u989d-(\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u533a\u95f4\u6700\u5c0f\u503c*\u7cfb\u6570))/(\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u533a\u95f4\u6700\u5927\u503c*\u7cfb\u6570-\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u533a\u95f4\u6700\u5c0f\u503c*\u7cfb\u6570)*100", (String)"DecAdjApprCreateGridHelper_7", (String)"swc-hcdm-business", (Object[])new Object[0])));
                        } else {
                            rateTip.setContent(new LocaleString(ResManager.loadKDString((String)"\u85aa\u916c\u6e17\u900f\u7387=(\u91d1\u989d-(\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u533a\u95f4\u6700\u5c0f\u503cx\u7cfb\u6570))/(\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u533a\u95f4\u6700\u5927\u503cx\u7cfb\u6570-\u85aa\u916c\u6807\u51c6\u8868\u76f8\u5e94\u85aa\u7b49\u533a\u95f4\u6700\u5c0f\u503cx\u7cfb\u6570)x100\u3002", (String)"DecAdjApprCreateGridHelper_17", (String)"swc-hcdm-business", (Object[])new Object[0])));
                        }
                        decimalFieldParamContainer.setTips(rateTip);
                        continue;
                    }
                    if (!DecAdjApprCreateGridHelper.buildKey(DecAdjApprConstants.KEY_EXRATEVALUE).equals(decimalFieldParamContainer.getKey())) continue;
                    decimalFieldParamContainer.setScale(10);
                    continue;
                }
                if (childParamContainer instanceof DateParamContainer) {
                    DateParamContainer dateParamContainer = (DateParamContainer)childParamContainer;
                    if (!DecAdjApprCreateGridHelper.buildKey("salbsed").equals(dateParamContainer.getKey())) continue;
                    Tips salBsedTip = new Tips();
                    salBsedTip.setType("text");
                    attributionType = adjFieldCfgWithPerm.getString("attributiontype");
                    if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                        salBsedTip.setContent(new LocaleString(ResManager.loadKDString((String)"\u5b9a\u85aa\u751f\u6548\u65e5\u671f\uff1a\u662f\u6307\u5b9a\u85aa\u65f6\u6240\u6d89\u53ca\u6bcf\u4e2a\u5b9a\u8c03\u85aa\u9879\u76ee\u7684\u751f\u6548\u65e5\u671f\uff1b{0}\u6bd4\u5982\uff1a\u672c\u6b21\u5b9a\u85aa\u6d89\u53ca\u5b9a\u8c03\u85aa\u9879\u76ee\u4e3a\u7ea7\u522b\u5de5\u8d44\u3001\u7ee9\u6548\u5de5\u8d44\uff0c\u4f46\u7ea7\u522b\u5de5\u8d44\u751f\u6548\u65e5\u671f\u4e3a2022\u5e7401\u670801\u65e5\uff0c\u7ee9\u6548\u5de5\u8d44\u751f\u6548\u65e5\u671f\u4e3a2022\u5e7406\u670801\u65e5", (String)"DecAdjApprCreateGridHelper_8", (String)"swc-hcdm-business", (Object[])new Object[]{"\\r\\n"})));
                    } else {
                        salBsedTip.setContent(new LocaleString(ResManager.loadKDString((String)"\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff1a\u662f\u6307\u8c03\u85aa\u65f6\u6240\u6d89\u53ca\u6bcf\u4e2a\u5b9a\u8c03\u85aa\u9879\u76ee\u7684\u751f\u6548\u65e5\u671f\uff1b{0}\u6bd4\u5982\uff1a\u672c\u6b21\u8c03\u85aa\u6d89\u53ca\u5b9a\u8c03\u85aa\u9879\u76ee\u4e3a\u7ea7\u522b\u5de5\u8d44\u3001\u7ee9\u6548\u5de5\u8d44\uff0c\u4f46\u7ea7\u522b\u5de5\u8d44\u751f\u6548\u65e5\u671f\u4e3a2022\u5e7401\u670801\u65e5\uff0c\u7ee9\u6548\u5de5\u8d44\u751f\u6548\u65e5\u671f\u4e3a2022\u5e7406\u670801\u65e5", (String)"DecAdjApprCreateGridHelper_18", (String)"swc-hcdm-business", (Object[])new Object[]{"\\r\\n"})));
                    }
                    dateParamContainer.setTips(salBsedTip);
                    continue;
                }
                if (childParamContainer instanceof MulBasedataFieldParamContainer) {
                    MulBasedataFieldParamContainer mulBasedataFieldParamContainer = (MulBasedataFieldParamContainer)childParamContainer;
                    mulBasedataFieldParamContainer.setFieldIdGenerationParam((FieldIdGenerationParam)new MulDynamicGridFieldIdGenerationParam(mulBasedataFieldParamContainer.getKey()));
                    continue;
                }
                if (!(childParamContainer instanceof TextFieldParamContainer)) continue;
                TextFieldParamContainer textFieldParamContainer = (TextFieldParamContainer)childParamContainer;
                if (DecAdjApprCreateGridHelper.buildKey(DecAdjApprConstants.KEY_REASON).equals(textFieldParamContainer.getKey()) || DecAdjApprCreateGridHelper.buildKey(DecAdjApprConstants.KEY_REMARK).equals(textFieldParamContainer.getKey())) {
                    textFieldParamContainer.setMaxLength(255);
                    continue;
                }
                if (DecAdjApprCreateGridHelper.buildKey("amountstdrangedisplay").equals(textFieldParamContainer.getKey())) {
                    textFieldParamContainer.setLock("new,edit,view,submit,audit");
                    continue;
                }
                if (!DecAdjApprCreateGridHelper.buildKey("amountstdrange").equals(textFieldParamContainer.getKey()) && !DecAdjApprCreateGridHelper.buildKey("preamountstdrange").equals(textFieldParamContainer.getKey())) continue;
                textFieldParamContainer.setHidden(true);
                textFieldParamContainer.setMaxLength(Integer.MAX_VALUE);
            }
        }
    }

    private static FieldParamContainer buildFieldParamContainer(IDataEntityProperty dataEntityProperty, Field<?> field) {
        CurrencyFieldParamContainer fieldParamContainer = null;
        if (dataEntityProperty instanceof CurrencyProp) {
            fieldParamContainer = new CurrencyFieldParamContainer();
        } else if (dataEntityProperty instanceof AmountProp) {
            AmountFieldParamContainer amountFieldParamContainer = new AmountFieldParamContainer();
            amountFieldParamContainer.setEnableNull(dataEntityProperty.isEnableNull());
            amountFieldParamContainer.setPrecision(((AmountProp)dataEntityProperty).getPrecision());
            amountFieldParamContainer.setScale(((AmountProp)dataEntityProperty).getScale());
            String currencyFieldId = ((AmountProp)dataEntityProperty).getControlPropName();
            if (StringUtils.isNotBlank((CharSequence)currencyFieldId)) {
                amountFieldParamContainer.setControlPropName(DecAdjApprCreateGridHelper.buildKey(currencyFieldId));
                amountFieldParamContainer.setCurrencyFieldId(DecAdjApprCreateGridHelper.buildKey(currencyFieldId));
            }
            fieldParamContainer = amountFieldParamContainer;
        } else if (dataEntityProperty instanceof DecimalProp) {
            DecimalFieldParamContainer decimalFieldParamContainer = new DecimalFieldParamContainer();
            decimalFieldParamContainer.setEnableNull(dataEntityProperty.isEnableNull());
            fieldParamContainer = decimalFieldParamContainer;
        } else if (dataEntityProperty instanceof BasedataProp) {
            BasedataFieldParamContainer basedataFieldParamContainer = new BasedataFieldParamContainer();
            basedataFieldParamContainer.setBaseEntityId(((BasedataProp)dataEntityProperty).getBaseEntityId());
            fieldParamContainer = basedataFieldParamContainer;
        } else if (dataEntityProperty instanceof ComboProp) {
            ComboFieldParamContainer comboFieldParamContainer = new ComboFieldParamContainer();
            comboFieldParamContainer.setItems(((ComboField)field).getItems());
            fieldParamContainer = comboFieldParamContainer;
        } else if (dataEntityProperty instanceof DateProp) {
            fieldParamContainer = new DateParamContainer();
        } else if (dataEntityProperty instanceof FieldProp) {
            fieldParamContainer = new TextFieldParamContainer();
        } else if (dataEntityProperty instanceof MulBasedataProp) {
            MulBasedataProp property = (MulBasedataProp)dataEntityProperty;
            MulBasedataFieldParamContainer mulBasedataFieldParamContainer = new MulBasedataFieldParamContainer();
            mulBasedataFieldParamContainer.setBaseEntityId(property.getBaseEntityId());
            fieldParamContainer = mulBasedataFieldParamContainer;
        }
        return fieldParamContainer;
    }

    private static void setBaseFieldValue(FieldParamContainer fieldParamContainer, EntityMetadata entityMetadata, String propertyName, ControlAp<?> formMetaItem, IDataEntityProperty property) {
        fieldParamContainer.setKey(DecAdjApprCreateGridHelper.buildKey(propertyName));
        fieldParamContainer.setName(formMetaItem.getName().getLocaleValue());
        fieldParamContainer.setEntityMetadata(entityMetadata);
        fieldParamContainer.setLock(formMetaItem.getLock());
        if (property instanceof IFieldHandle) {
            IFieldHandle fieldHandle = (IFieldHandle)property;
            Features copyAndExport = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
            copyAndExport.setCopyable(fieldHandle.isCopyable());
            copyAndExport.setExportable(fieldHandle.isExportable());
            copyAndExport.setImportable(fieldHandle.isImportable());
            fieldParamContainer.setFeatures(copyAndExport);
        }
        if (property instanceof FieldProp) {
            FieldProp dynamicProperty = (FieldProp)property;
            fieldParamContainer.setDefValue(dynamicProperty.getDefValue());
        }
    }

    public static String buildKey(String propertyName) {
        return "dy_" + propertyName;
    }

    public static String getKey(String propertyName, boolean isList, boolean isEntity) {
        return isList ? (isEntity ? "entryentity." + propertyName : propertyName) : propertyName;
    }

    public static String replace(String propertyName) {
        return propertyName.replace("dy_", "");
    }

    public static Map<String, IDataEntityProperty> getAdjApprPersonPropertyMap(DynamicObjectType entityType) {
        DataEntityPropertyCollection entityTypeProperties = entityType.getProperties();
        Map<String, IDataEntityProperty> adjApprPersonPropertyMap = entityTypeProperties.stream().filter(dataEntityProperty -> !"entryentity".equals(dataEntityProperty.getName())).collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        return adjApprPersonPropertyMap;
    }

    public static Map<String, IDataEntityProperty> getAdjApprPersonEntryPropertyMap() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hcdm_adjapprperson");
        DynamicObjectType entryEntityProperty = ((EntryProp)entityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType();
        Map<String, IDataEntityProperty> adjApprPersonEntryPropertyMap = entryEntityProperty.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        return adjApprPersonEntryPropertyMap;
    }

    public static Map<String, IDataEntityProperty> getApprBillEntryPropertyMap(EntityType entityType) {
        DataEntityPropertyCollection entityTypeProperties = entityType.getProperties();
        Map<String, IDataEntityProperty> adjApprBillEntryPropertyMap = entityTypeProperties.stream().collect(Collectors.toMap(dataEntityProperty -> dataEntityProperty.getName().replace("dy_", ""), Function.identity(), (k1, k2) -> k1));
        return adjApprBillEntryPropertyMap;
    }

    public static void setAdjApprPersonData(Map<String, IDataEntityProperty> dataEntityPropertyMap, String propertyKey, DynamicObject adjApprPerson, DynamicObject entryValue) {
        IDataEntityProperty iDataEntityProperty = dataEntityPropertyMap.get(propertyKey);
        if (iDataEntityProperty instanceof BasedataProp) {
            DynamicObject baseDataData = entryValue.getDynamicObject(DecAdjApprCreateGridHelper.buildKey(propertyKey));
            adjApprPerson.set(propertyKey, (Object)baseDataData);
        } else if (iDataEntityProperty instanceof DateProp) {
            Date dateData = entryValue.getDate(DecAdjApprCreateGridHelper.buildKey(propertyKey));
            adjApprPerson.set(propertyKey, (Object)dateData);
        } else if (iDataEntityProperty instanceof ComboProp || iDataEntityProperty instanceof TextProp) {
            String stringData = entryValue.getString(DecAdjApprCreateGridHelper.buildKey(propertyKey));
            adjApprPerson.set(propertyKey, (Object)stringData);
        } else if (iDataEntityProperty instanceof IntegerProp) {
            if (iDataEntityProperty.getName().equals("seq")) {
                Integer seqData = entryValue.getInt(propertyKey);
                if (seqData != null) {
                    adjApprPerson.set(propertyKey, (Object)seqData);
                }
            } else {
                Integer intData = entryValue.getInt(DecAdjApprCreateGridHelper.buildKey(propertyKey));
                if (intData != null) {
                    adjApprPerson.set(propertyKey, (Object)intData);
                }
            }
        } else if (iDataEntityProperty instanceof LongProp) {
            if (iDataEntityProperty.getName().equals("id")) {
                Long longData = entryValue.getLong(propertyKey);
                if (longData != null) {
                    adjApprPerson.set(propertyKey, (Object)longData);
                }
            } else {
                Long longData = entryValue.getLong(DecAdjApprCreateGridHelper.buildKey(propertyKey));
                if (longData != null) {
                    adjApprPerson.set(propertyKey, (Object)longData);
                }
            }
        } else if (iDataEntityProperty instanceof DecimalProp || iDataEntityProperty instanceof AmountProp) {
            BigDecimal bigDecimalData = entryValue.getBigDecimal(DecAdjApprCreateGridHelper.buildKey(propertyKey));
            adjApprPerson.set(propertyKey, (Object)bigDecimalData);
        } else if (iDataEntityProperty instanceof MulBasedataProp) {
            DynamicObjectCollection entryMulData = entryValue.getDynamicObjectCollection(DecAdjApprCreateGridHelper.buildKey(propertyKey));
            DynamicObjectCollection adjApprPersonMulData = adjApprPerson.getDynamicObjectCollection(propertyKey);
            if (CollectionUtils.isEmpty((Collection)adjApprPersonMulData)) {
                for (DynamicObject mulBasedata : entryMulData) {
                    DynamicObject dynamicObject = mulBasedata.getDynamicObject("fbasedataid");
                    DynamicObject newMultiBaseData = new DynamicObject(adjApprPersonMulData.getDynamicObjectType());
                    newMultiBaseData.set("fbasedataid", (Object)dynamicObject);
                    adjApprPersonMulData.add((Object)newMultiBaseData);
                }
                adjApprPerson.set(propertyKey, (Object)adjApprPersonMulData);
            }
        }
    }

    public static void convertAdjPerToRecord(Map<String, String> adjDetailFieldToRecordFieldMap, Map<String, IDataEntityProperty> adjApprPropertyMap, DynamicObject adjApprPerson, DynamicObject decAdjLogDyObj) {
        DataEntityPropertyCollection recordPersonProps = decAdjLogDyObj.getDataEntityType().getProperties();
        for (Map.Entry<String, IDataEntityProperty> subEntry : adjApprPropertyMap.entrySet()) {
            IDataEntityProperty property;
            String decAdjLogProKey;
            String propertyKey = subEntry.getKey();
            if ("adjfile".equals(propertyKey) || "salaryadjrsn".equals(propertyKey) || (decAdjLogProKey = adjDetailFieldToRecordFieldMap.get(propertyKey)) == null || decAdjLogProKey == null || (property = (IDataEntityProperty)recordPersonProps.get((Object)decAdjLogProKey)) == null) continue;
            IDataEntityProperty iDataEntityProperty = subEntry.getValue();
            if (iDataEntityProperty instanceof MulBasedataProp) {
                DynamicObjectCollection multiBaseDataDyColl = new DynamicObjectCollection(((MulBasedataProp)property).getDynamicCollectionItemPropertyType(), null);
                DynamicObjectCollection mulBaseData = adjApprPerson.getDynamicObjectCollection(propertyKey);
                for (DynamicObject baseDatum : mulBaseData) {
                    DynamicObject value = new DynamicObject(multiBaseDataDyColl.getDynamicObjectType());
                    value.set("fbasedataid", baseDatum.get("fbasedataid"));
                    value.set("fbasedataid_id", baseDatum.get("fbasedataid_id"));
                    multiBaseDataDyColl.add((Object)value);
                }
                decAdjLogDyObj.set(decAdjLogProKey, (Object)multiBaseDataDyColl);
                continue;
            }
            if (iDataEntityProperty instanceof BasedataProp) {
                DynamicObject baseData = adjApprPerson.getDynamicObject(propertyKey);
                decAdjLogDyObj.set(decAdjLogProKey, (Object)baseData);
                continue;
            }
            if (iDataEntityProperty instanceof DateProp) {
                Date date = adjApprPerson.getDate(propertyKey);
                decAdjLogDyObj.set(decAdjLogProKey, (Object)date);
                continue;
            }
            if (iDataEntityProperty instanceof ComboProp || iDataEntityProperty instanceof TextProp) {
                String stringData = adjApprPerson.getString(propertyKey);
                decAdjLogDyObj.set(decAdjLogProKey, (Object)stringData);
                continue;
            }
            if (iDataEntityProperty instanceof LongProp) {
                Long longData = adjApprPerson.getLong(propertyKey);
                decAdjLogDyObj.set(decAdjLogProKey, (Object)longData);
                continue;
            }
            if (!(iDataEntityProperty instanceof DecimalProp) && !(iDataEntityProperty instanceof AmountProp) && !(iDataEntityProperty instanceof IntegerProp)) continue;
            BigDecimal numData = adjApprPerson.getBigDecimal(propertyKey);
            decAdjLogDyObj.set(decAdjLogProKey, (Object)numData);
        }
    }

    public static void setAdjApprBillEntryData(Map<String, IDataEntityProperty> dataEntityPropertyMap, String propertyKey, DynamicObject fromEntryValue, DynamicObject toEntryValue) {
        IDataEntityProperty iDataEntityProperty = dataEntityPropertyMap.get(propertyKey);
        DataEntityPropertyCollection properties = fromEntryValue.getDynamicObjectType().getProperties();
        if (!properties.containsKey((Object)propertyKey)) {
            return;
        }
        if (iDataEntityProperty instanceof BasedataProp) {
            DynamicObject baseDataData = fromEntryValue.getDynamicObject(propertyKey);
            if (baseDataData != null) {
                toEntryValue.set(DecAdjApprCreateGridHelper.buildKey(propertyKey), (Object)baseDataData);
            }
        } else if (iDataEntityProperty instanceof DateProp) {
            Date dateData = fromEntryValue.getDate(propertyKey);
            if (dateData != null) {
                toEntryValue.set(DecAdjApprCreateGridHelper.buildKey(propertyKey), (Object)dateData);
            }
        } else if (iDataEntityProperty instanceof ComboProp || iDataEntityProperty instanceof TextProp) {
            String stringData = fromEntryValue.getString(propertyKey);
            if (stringData != null) {
                toEntryValue.set(DecAdjApprCreateGridHelper.buildKey(propertyKey), (Object)stringData);
            }
        } else if (iDataEntityProperty instanceof IntegerProp) {
            if (iDataEntityProperty.getName().equals("seq")) {
                Integer seqData = fromEntryValue.getInt(propertyKey);
                if (seqData != null) {
                    toEntryValue.set(propertyKey, (Object)seqData);
                }
            } else {
                Integer intData = fromEntryValue.getInt(propertyKey);
                if (intData != null) {
                    toEntryValue.set(DecAdjApprCreateGridHelper.buildKey(propertyKey), (Object)intData);
                }
            }
        } else if (iDataEntityProperty instanceof LongProp) {
            Long longData = fromEntryValue.getLong(propertyKey);
            if (iDataEntityProperty.getName().equals("id")) {
                if (longData != null) {
                    toEntryValue.set(propertyKey, (Object)longData);
                }
            } else {
                toEntryValue.set(DecAdjApprCreateGridHelper.buildKey(propertyKey), (Object)longData);
            }
        } else if (iDataEntityProperty instanceof DecimalProp || iDataEntityProperty instanceof AmountProp) {
            BigDecimal bigDecimalData = fromEntryValue.getBigDecimal(propertyKey);
            if (bigDecimalData != null) {
                toEntryValue.set(DecAdjApprCreateGridHelper.buildKey(propertyKey), (Object)bigDecimalData);
            }
        } else if (iDataEntityProperty instanceof MulBasedataProp) {
            DynamicObjectCollection adjApprPersonMulData = fromEntryValue.getDynamicObjectCollection(propertyKey);
            toEntryValue.set(DecAdjApprCreateGridHelper.buildKey(propertyKey), (Object)adjApprPersonMulData);
        }
    }

    public static String combineStrings(String ... fields) {
        StringJoiner sj = new StringJoiner("&");
        for (String field : fields) {
            sj.add(field);
        }
        return sj.toString();
    }
}

