/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalGridHelper;
import kd.swc.hcdm.business.adjapprbill.AdjPersonPackageHelper;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.CalculateUtils;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.GradeAndRankNameHelper;
import kd.swc.hcdm.business.adjapprbill.adjfieldcfg.AdjDetailFieldMappingHelper;
import kd.swc.hcdm.business.adjapprbill.entity.AdjApprPerQueryParam;
import kd.swc.hcdm.business.adjapprbill.entity.ExRateKey;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.adjapprbill.enums.YesOrNoEnum;
import kd.swc.hcdm.business.helper.DynamicObjectValueHelper;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.salarystandardscm.SalaryStandardScmHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjapprbill.AddFileReturnData;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.entity.adjapprbill.GradeAndRankNameEntity;
import kd.swc.hcdm.common.enums.CalcSceneType;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DecAdjApprGridHelper {
    private static final Log logger = LogFactory.getLog(DecAdjApprGridHelper.class);
    public static final int BATCH_SIZE = 500;
    private static SWCDataServiceHelper adjPersonServiceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
    private static SWCDataServiceHelper adjBillServiceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
    private static final String adjApprPerSelectProperties;
    public static final String selectProperties;

    public static List<AddFileReturnData> getAddAdjFileReturnData(Map<Object, DynamicObject> fileObjMap) {
        Map<Long, Map<Long, Set<Long>>> adjFileMap = DecAdjApprGridHelper.getStdScmDataGroupByAdjFile(fileObjMap);
        return DecAdjApprGridHelper.getStdScmEntryDataByAdjFileData(adjFileMap);
    }

    public static List<AddFileReturnData> getStdScmEntryDataByAdjFileData(Map<Long, Map<Long, Set<Long>>> adjFileMap) {
        HashMap<Long, Set<Long>> newStcToStrucMap = new HashMap<Long, Set<Long>>(16);
        adjFileMap.values().stream().forEach(item -> item.keySet().stream().forEach(key -> {
            Set salayStrucIdSet = newStcToStrucMap.computeIfAbsent((Long)key, o1 -> Sets.newHashSet());
            salayStrucIdSet.addAll((Collection)item.get(key));
            newStcToStrucMap.put((Long)key, salayStrucIdSet);
        }));
        Map<Long, List<DynamicObject>> stdScmMap = SalaryStandardScmHelper.queryStdScmByIds(newStcToStrucMap);
        ArrayList<AddFileReturnData> addFileReturnDataList = new ArrayList<AddFileReturnData>(10);
        AddFileReturnData addFileReturnData = null;
        for (Map.Entry<Long, Map<Long, Set<Long>>> adjFileIteratorEntry : adjFileMap.entrySet()) {
            Long adjFileId = adjFileIteratorEntry.getKey();
            Map<Long, Set<Long>> adjFileIteratorEntryValue = adjFileIteratorEntry.getValue();
            for (Map.Entry<Long, Set<Long>> entry : adjFileIteratorEntryValue.entrySet()) {
                Long stdScmId = entry.getKey();
                Set<Long> salStructureIdSet = adjFileIteratorEntryValue.get(stdScmId);
                List<DynamicObject> stdScmDyObjList = stdScmMap.get(stdScmId);
                if (CollectionUtils.isEmpty(stdScmDyObjList)) {
                    addFileReturnData = new AddFileReturnData();
                    addFileReturnData.setAdjFileId(adjFileId);
                    addFileReturnData.setStdScmVersionId(stdScmId);
                    if (CollectionUtils.isEmpty(salStructureIdSet)) {
                        addFileReturnData.setSalayStructureId(null);
                    } else {
                        addFileReturnData.setSalayStructureId((Long)salStructureIdSet.stream().findFirst().get());
                    }
                    addFileReturnDataList.add(addFileReturnData);
                    continue;
                }
                for (DynamicObject stdScmEntry : stdScmDyObjList) {
                    addFileReturnData = new AddFileReturnData();
                    addFileReturnData.setAdjFileId(adjFileId);
                    addFileReturnData.setStdScmVersionId(stdScmId);
                    addFileReturnData.setisMatchGradeRank(stdScmEntry.getString("ismatchgraderank"));
                    addFileReturnData.setMatchStrategy(stdScmEntry.getString("matchstrategy"));
                    long salStructurEntId = stdScmEntry.getLong("salstructurent.id");
                    addFileReturnData.setSalayStructureId(Long.valueOf(salStructurEntId));
                    addFileReturnData.setStandardItemId(Long.valueOf(stdScmEntry.getLong("standarditem.id")));
                    if (stdScmEntry.getString("excesscontrol") != null) {
                        addFileReturnData.setExcessControl(stdScmEntry.getString("excesscontrol"));
                    }
                    if (!salStructureIdSet.contains(salStructurEntId)) continue;
                    addFileReturnDataList.add(addFileReturnData);
                }
            }
        }
        return addFileReturnDataList;
    }

    private static Map<Long, Map<Long, Set<Long>>> getStdScmDataGroupByAdjFile(Map<Object, DynamicObject> fileObj) {
        HashMap<Long, Map<Long, Set<Long>>> adjFileMap = new HashMap<Long, Map<Long, Set<Long>>>(16);
        for (Map.Entry<Object, DynamicObject> fileObjEntry : fileObj.entrySet()) {
            DynamicObject fileObjEntryValue = fileObjEntry.getValue();
            Long adjFileId = fileObjEntryValue.getLong("id");
            Long stdScmVId = fileObjEntryValue.getLong("stdscm.sourcevid");
            Long salayStrucId = fileObjEntryValue.getLong("salaystructure.id");
            adjFileMap.computeIfAbsent(adjFileId, o1 -> Maps.newHashMap());
            HashMap<Long, Set> idStcIdMap = new HashMap<Long, Set>(16);
            Set salayStrucIdSet = idStcIdMap.computeIfAbsent(stdScmVId, o1 -> Sets.newHashSet());
            salayStrucIdSet.add(salayStrucId);
            idStcIdMap.put(stdScmVId, salayStrucIdSet);
            adjFileMap.put(adjFileId, idStcIdMap);
        }
        return adjFileMap;
    }

    public static DynamicObject[] getAdjApprPersonData(String properties, AdjApprPerQueryParam adjApprPerQueryParam) {
        QFilter permissionQFilter;
        List<String> confirmStatusList;
        List<String> synStatusList;
        Set<Long> personIds;
        List<Long> adjPersonIdList;
        Set<Long> adjFileIds;
        Long adjApprBillId;
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        List<Long> adjApprBillIds = adjApprPerQueryParam.getAdjApprBillIds();
        if (CollectionUtils.isNotEmpty(adjApprBillIds)) {
            qFilter.and(new QFilter("adjapprbill", "in", adjApprBillIds));
        }
        if (!Objects.isNull(adjApprBillId = adjApprPerQueryParam.getAdjApprBillId())) {
            qFilter.and(new QFilter("adjapprbill", "=", (Object)adjApprBillId));
        }
        if (CollectionUtils.isNotEmpty(adjFileIds = adjApprPerQueryParam.getAdjFileIds())) {
            qFilter.and(new QFilter("adjfile", "in", adjFileIds));
        }
        if (CollectionUtils.isNotEmpty(adjPersonIdList = adjApprPerQueryParam.getAdjPersonIdList())) {
            qFilter.and(new QFilter("id", "in", adjPersonIdList));
        }
        if (CollectionUtils.isNotEmpty(personIds = adjApprPerQueryParam.getPersonIds())) {
            qFilter.and(new QFilter("person", "in", personIds));
        }
        if (CollectionUtils.isNotEmpty(synStatusList = adjApprPerQueryParam.getSynStatusList())) {
            qFilter.and(new QFilter("synstatus", "in", synStatusList));
        }
        if (CollectionUtils.isNotEmpty(confirmStatusList = adjApprPerQueryParam.getConfirmStatusList())) {
            qFilter.and(new QFilter("confirmstatus", "in", confirmStatusList));
        }
        if (!Objects.isNull(permissionQFilter = adjApprPerQueryParam.getPermissionQFilter())) {
            qFilter.and(permissionQFilter);
        }
        String orderBy = StringUtils.isNotBlank((String)adjApprPerQueryParam.getDefaultOrderBy()) ? adjApprPerQueryParam.getDefaultOrderBy() : "entryentity.seq asc";
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        return serviceHelper.query(properties, new QFilter[]{qFilter}, orderBy);
    }

    public static List<Long> queryAllAdjPersonId(Long billId) {
        String sql = "select fid from t_hcdm_adjapprper where fadjapprbillid = ? order by fupdatetime desc, fadjfileid asc";
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        try (DataSet dataSet = HCDMDbHelper.queryDataSet(sql, new Object[]{billId});){
            while (dataSet.hasNext()) {
                result.add(dataSet.next().getLong("fid"));
            }
        }
        return result;
    }

    public static Map<Long, DynamicObject> getEntryDate(Set<Long> personIds) {
        if (personIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_empentrel");
        DynamicObject[] objects = service.query("person, startdate", new QFilter[]{new QFilter("person.id", "in", personIds), new QFilter("iscurrentversion", "=", (Object)"1")});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("person.id"), object);
            logger.info("person is {} startdate is {}", (Object)object.getLong("person.id"), (Object)object.getDate("startdate"));
        }
        return data;
    }

    public static Map<Long, DynamicObject> getRealRegularDate(Set<Long> personIds) {
        if (personIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_trialperiod");
        DynamicObject[] objects = service.query("person,realregulardate,probation,probationunit", new QFilter[]{new QFilter("person.id", "in", personIds), new QFilter("iscurrentversion", "=", (Object)"1")});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("person.id"), object);
            logger.info("person is {} realregulardate is {}", (Object)object.getLong("person.id"), (Object)object.getDate("realregulardate"));
        }
        return data;
    }

    public static Map<Long, DynamicObject> getContrWorkLoc(Set<Long> personIds) {
        if (personIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_contrworkloc");
        DynamicObject[] objects = service.query("person, agreedlocation", new QFilter[]{new QFilter("person.id", "in", personIds), new QFilter("iscurrentversion", "=", (Object)"1")});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("person.id"), object);
        }
        return data;
    }

    public static Map<Long, DynamicObject> getBaseLocation(Set<Long> personIds) {
        if (personIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_baselocation");
        DynamicObject[] objects = service.query("person, location", new QFilter[]{new QFilter("person.id", "in", personIds), new QFilter("iscurrentversion", "=", (Object)"1")});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("person.id"), object);
        }
        return data;
    }

    public static Map<Long, DynamicObject> getContractWorkPlace(List<Long> employeeIds) {
        SWCDataServiceHelper workPlaceService = new SWCDataServiceHelper("hrpi_contrworkloc");
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] dyObjs = workPlaceService.query("id,employee,agreedlocation", new QFilter[]{qFilter});
        HashMap data = Maps.newHashMapWithExpectedSize((int)dyObjs.length);
        for (DynamicObject object : dyObjs) {
            data.putIfAbsent(object.getLong("employee.id"), object);
        }
        return data;
    }

    public static Map<Long, DynamicObject> getPermanentWorkPlace(List<Long> employeeIds) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_baselocation");
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] objects = service.query("id,employee,employee.id,location", new QFilter[]{qFilter});
        HashMap data = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            data.putIfAbsent(object.getLong("employee.id"), object);
        }
        return data;
    }

    public static BigDecimal convertAmountByExrate(ExchangeRateInfo exrate, BigDecimal currentSalary, long stdcurrency, long adjCurrency) {
        BigDecimal convertAmount = null;
        BigDecimal originalAmount = currentSalary;
        if (adjCurrency == stdcurrency) {
            return originalAmount;
        }
        if (exrate != null && currentSalary != null) {
            Boolean quoteType = exrate.getQuoteType();
            BigDecimal exchangeRate = exrate.getExchangeRate();
            convertAmount = quoteType != false ? originalAmount.divide(exchangeRate, 2, 4) : originalAmount.multiply(exchangeRate);
        }
        return convertAmount;
    }

    public static ExchangeRateInfo getExchangeRate(BillExRateManager rateManager, long stdcurrency, long adjCurrency, long exctableId, Date rateDate) {
        if (adjCurrency == stdcurrency) {
            return null;
        }
        if (rateDate != null && exctableId != 0L) {
            return rateManager.getExRate(new ExRateKey(adjCurrency, stdcurrency, rateDate.getTime(), exctableId));
        }
        return null;
    }

    public static BigDecimal convertAmountByExrate(BillExRateManager rateManager, BigDecimal currentSalary, BigDecimal finalAmount, long stdcurrency, long adjCurrency, long exctableId, Date rateDate, boolean isToFinalAmount) {
        BigDecimal convertAmount = null;
        ExchangeRateInfo exrate = null;
        BigDecimal originalAmount = null;
        if (adjCurrency == stdcurrency) {
            return isToFinalAmount ? currentSalary : finalAmount;
        }
        if (rateDate != null && exctableId != 0L) {
            if (isToFinalAmount) {
                exrate = rateManager.getExRate(new ExRateKey(adjCurrency, stdcurrency, rateDate.getTime(), exctableId));
                originalAmount = currentSalary;
            } else {
                exrate = rateManager.getExRate(new ExRateKey(stdcurrency, adjCurrency, rateDate.getTime(), exctableId));
                originalAmount = finalAmount;
            }
        }
        if (exrate != null) {
            Boolean quoteType = exrate.getQuoteType();
            BigDecimal exchangeRate = exrate.getExchangeRate();
            convertAmount = quoteType != false ? originalAmount.divide(exchangeRate, 2, 4) : originalAmount.multiply(exchangeRate);
        }
        return convertAmount;
    }

    public static Map<Long, DynamicObject> getEmpposorgrelData(DynamicObjectCollection billEntryRows) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_empposorgrel");
        HashMap empPosOrgRelMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject billEntryRow : billEntryRows) {
            DynamicObject adjFileDyObj = billEntryRow.getDynamicObject(DecAdjApprCreateGridHelper.buildKey("adjfile"));
            Long empPosOrgRelId = adjFileDyObj.getLong("empposorgrel.id");
            DynamicObject companyDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("company"), null);
            DynamicObject positionDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("position"), null);
            DynamicObject adminOrgDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("adminorg"), null);
            DynamicObject jobDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("job"), null);
            DynamicObject empPosOrgRelObj = service.generateEmptyDynamicObject();
            empPosOrgRelObj.set("company", (Object)companyDyObj);
            empPosOrgRelObj.set("position", (Object)positionDyObj);
            empPosOrgRelObj.set("adminorg", (Object)adminOrgDyObj);
            empPosOrgRelObj.set("job", (Object)jobDyObj);
            empPosOrgRelObj.set("id", (Object)empPosOrgRelId);
            empPosOrgRelMap.putIfAbsent(empPosOrgRelId, empPosOrgRelObj);
        }
        return empPosOrgRelMap;
    }

    public static Map<Long, DynamicObject> queryDepempData(DynamicObjectCollection billEntryRows) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_depemp");
        HashMap depEmpMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject billEntryRow : billEntryRows) {
            DynamicObject adjFileDyObj = billEntryRow.getDynamicObject(DecAdjApprCreateGridHelper.buildKey("adjfile"));
            Long depEmpId = adjFileDyObj.getLong("depemp.id");
            DynamicObject employeeDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("employee"), null);
            DynamicObject adminOrgDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("adminorg"), null);
            DynamicObject empPosOrgRelObj = service.generateEmptyDynamicObject();
            empPosOrgRelObj.set("adminorg", (Object)adminOrgDyObj);
            empPosOrgRelObj.set("employee", (Object)employeeDyObj);
            empPosOrgRelObj.set("id", (Object)depEmpId);
            depEmpMap.putIfAbsent(depEmpId, empPosOrgRelObj);
        }
        return depEmpMap;
    }

    public static Map<Long, DynamicObject> queryEmpJobRel(DynamicObjectCollection billEntryRows) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_empjobrel");
        HashMap empJobRelMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject billEntryRow : billEntryRows) {
            DynamicObject employeeDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("employee"), null);
            DynamicObject jobLevelDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("joblevel"), null);
            DynamicObject jobGradeDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("jobgrade"), null);
            DynamicObject empJobRelObj = service.generateEmptyDynamicObject();
            empJobRelObj.set("joblevel", (Object)jobLevelDyObj);
            empJobRelObj.set("jobgrade", (Object)jobGradeDyObj);
            empJobRelObj.set("employee", (Object)employeeDyObj);
            empJobRelMap.putIfAbsent(employeeDyObj.getLong("id"), empJobRelObj);
        }
        return empJobRelMap;
    }

    public static Map<Long, DynamicObject> getJobData(DynamicObjectCollection billEntryRows) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hbjm_jobhr");
        HashMap jobHrMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject billEntryRow : billEntryRows) {
            DynamicObject jobDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, DecAdjApprCreateGridHelper.buildKey("job"), null);
            DynamicObject jobHrObj = service.generateEmptyDynamicObject();
            if (jobDyObj == null) continue;
            jobHrObj.set("name", (Object)jobDyObj.getString("name"));
            jobHrObj.set("jobscm", (Object)jobDyObj.getDynamicObject("jobscm"));
            jobHrObj.set("jobseq", (Object)jobDyObj.getDynamicObject("jobseq"));
            jobHrObj.set("jobfamily", (Object)jobDyObj.getDynamicObject("jobfamily"));
            jobHrObj.set("jobclass", (Object)jobDyObj.getDynamicObject("jobclass"));
            jobHrObj.set("id", (Object)jobDyObj.getLong("id"));
            jobHrMap.putIfAbsent(jobDyObj.getLong("id"), jobHrObj);
        }
        return jobHrMap;
    }

    public static String buildMatchGradeAndRankRangeDisplayName(Map<Long, List<Pair<Long, Long>>> amountStdRangeMap, GradeAndRankNameEntity gradeAndRankNameEntity) {
        ArrayList gradeIds = Lists.newArrayList(gradeAndRankNameEntity.getSalaryGradeIdToNameMap().keySet());
        logger.info("sorted gradeIds is {}", (Object)JSON.toJSONString((Object)gradeIds));
        logger.info("amountStdRangeMap is {}", (Object)JSON.toJSONString(amountStdRangeMap));
        ArrayList amountStdRangeNameList = new ArrayList(10);
        for (Long gradeId : gradeIds) {
            String gradeName = (String)gradeAndRankNameEntity.getSalaryGradeIdToNameMap().get(gradeId);
            List<Pair<Long, Long>> amountStdRangeList = amountStdRangeMap.get(gradeId);
            if (CollectionUtils.isEmpty(amountStdRangeList)) continue;
            amountStdRangeList.forEach(amountStdRange -> {
                Long minRankId = (Long)amountStdRange.getKey();
                Long maxRankId = (Long)amountStdRange.getValue();
                Pair minRankPair = (Pair)gradeAndRankNameEntity.getSalaryRankIdToNameMap().get(minRankId);
                String minRankName = "";
                if (minRankPair != null) {
                    minRankName = minRankPair.getValue() != null ? (String)minRankPair.getValue() : minRankName;
                }
                Pair maxRankPair = (Pair)gradeAndRankNameEntity.getSalaryRankIdToNameMap().get(maxRankId);
                String maxRankName = "";
                if (maxRankPair != null) {
                    String string = maxRankName = maxRankPair.getValue() != null ? (String)maxRankPair.getValue() : maxRankName;
                }
                if (minRankId.equals(maxRankId)) {
                    amountStdRangeNameList.add(gradeName + minRankName);
                } else {
                    String displayName = String.join((CharSequence)"-", gradeName + minRankName, gradeName + maxRankName);
                    amountStdRangeNameList.add(displayName);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(amountStdRangeNameList)) {
            List finalAmountStdRangeNameList = amountStdRangeNameList.stream().distinct().collect(Collectors.toList());
            logger.info("amountStdRangeNameList is {}", (Object)StringUtils.join((Object[])finalAmountStdRangeNameList.toArray(), (String)";"));
            return StringUtils.join((Object[])finalAmountStdRangeNameList.toArray(), (String)";");
        }
        return null;
    }

    public static GradeAndRankNameEntity getMatchGradeAndRankNameEntity(Map<Long, List<Pair<Long, Long>>> amountStdRangeMatchMap, List<Pair<Long, Long>> positionInfoOfNotUseRankList) {
        HashSet<Long> gradeIdSet = new HashSet<Long>(16);
        HashSet<Long> rankIdSet = new HashSet<Long>(16);
        if (MapUtils.isNotEmpty(amountStdRangeMatchMap)) {
            amountStdRangeMatchMap.keySet().forEach(item -> gradeIdSet.add((Long)item));
            amountStdRangeMatchMap.forEach((key, value) -> {
                List amountStdRangeList = (List)amountStdRangeMatchMap.get(key);
                amountStdRangeList.forEach(amountStdRange -> {
                    rankIdSet.add((Long)amountStdRange.getKey());
                    rankIdSet.add((Long)amountStdRange.getValue());
                });
            });
        }
        if (CollectionUtils.isNotEmpty(positionInfoOfNotUseRankList)) {
            for (Pair<Long, Long> amountStdRange : positionInfoOfNotUseRankList) {
                gradeIdSet.add((Long)amountStdRange.getKey());
                gradeIdSet.add((Long)amountStdRange.getValue());
            }
        }
        logger.info("gradeIdSet is ={}", (Object)JSON.toJSONString(gradeIdSet));
        Map<Long, String> salaryGradeIdToNameMap = DecAdjApprGridHelper.getGradeIdToNameMap(gradeIdSet);
        logger.info("salaryGradeIdToNameMap is ={}", (Object)JSON.toJSONString(salaryGradeIdToNameMap));
        logger.info("rankIdSet is ={}", (Object)JSON.toJSONString(rankIdSet));
        Map<Long, Pair<Integer, String>> salaryRankIdToNameMap = DecAdjApprGridHelper.getRankIdToNameMap(rankIdSet);
        logger.info("salaryRankIdToNameMap is ={}", (Object)JSON.toJSONString(salaryRankIdToNameMap));
        GradeAndRankNameEntity gradeAndRankNameEntity = new GradeAndRankNameEntity(salaryGradeIdToNameMap, salaryRankIdToNameMap);
        logger.info("gradeAndRankNameEntity is {}", (Object)JSON.toJSONString((Object)gradeAndRankNameEntity));
        return gradeAndRankNameEntity;
    }

    public static Map<Long, Pair<Integer, String>> getRankIdToNameMap(Set<Long> rankIdSet) {
        HashMap<Long, Pair<Integer, String>> salaryRankIdToNameMap = new HashMap<Long, Pair<Integer, String>>(16);
        try {
            SWCMultithreadedQueryService service = SWCMultithreadedQueryService.getInstance();
            QFilter qFilter = new QFilter("id", "in", rankIdSet);
            DynamicObject[] salaryRankDyObjs = service.getData("hcdm_rankgradeentrytodb", "id, name, entryseq", new QFilter[]{qFilter}, "", 500);
            return Arrays.stream(salaryRankDyObjs).collect(Collectors.toMap(key -> key.getLong("id"), value -> new Pair((Object)value.getInt("entryseq"), (Object)value.getString("name"))));
        }
        catch (Exception e) {
            logger.error("get rankid to name failed.", (Throwable)e);
            return salaryRankIdToNameMap;
        }
    }

    public static Map<Long, String> getGradeIdToNameMap(Set<Long> gradeIdSet) {
        LinkedHashMap<Long, String> salaryGradeIdToNameMap = new LinkedHashMap<Long, String>(16);
        try {
            SWCMultithreadedQueryService service = SWCMultithreadedQueryService.getInstance();
            QFilter qFilter = new QFilter("id", "in", gradeIdSet);
            DynamicObject[] salaryGradeDyObjs = service.getData("hcdm_salarygradeentrytodb", "id, name", new QFilter[]{qFilter}, " gradeindex asc ", 500);
            Arrays.stream(salaryGradeDyObjs).forEach(obj -> salaryGradeIdToNameMap.put(obj.getLong("id"), obj.getString("name")));
        }
        catch (Exception e) {
            logger.error("get grade to name failed.", (Throwable)e);
        }
        return salaryGradeIdToNameMap;
    }

    public static String buildAllMatchGradeRangeName(List<Pair<Long, Long>> positionInfoOfNotUseRankList, GradeAndRankNameEntity gradeNameEntity) {
        ArrayList<String> amountStdRangeNameList = new ArrayList<String>(10);
        for (Pair<Long, Long> positionInfoOfNotUseRank : positionInfoOfNotUseRankList) {
            Long minGradeId = (Long)positionInfoOfNotUseRank.getKey();
            Long maxGradeId = (Long)positionInfoOfNotUseRank.getValue();
            String minGradeName = (String)gradeNameEntity.getSalaryGradeIdToNameMap().get(minGradeId);
            minGradeName = minGradeName != null ? minGradeName : "";
            String maxGradeName = (String)gradeNameEntity.getSalaryGradeIdToNameMap().get(maxGradeId);
            String string = maxGradeName = maxGradeName != null ? maxGradeName : "";
            if (minGradeId.equals(maxGradeId)) {
                amountStdRangeNameList.add(minGradeName);
                continue;
            }
            String displayName = String.join((CharSequence)"-", minGradeName, maxGradeName);
            amountStdRangeNameList.add(displayName);
        }
        if (CollectionUtils.isNotEmpty(amountStdRangeNameList)) {
            List finalAmountStdRangeNameList = amountStdRangeNameList.stream().distinct().collect(Collectors.toList());
            return StringUtils.join((Object[])finalAmountStdRangeNameList.toArray(), (String)";");
        }
        return null;
    }

    public static boolean checkItemUseRank(DynamicObject adjApprDetailEnt, Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag) {
        Map<Long, Boolean> flagMap;
        long stdId = adjApprDetailEnt.getLong("dy_salarystd.id");
        long itemId = adjApprDetailEnt.getLong("dy_standarditem.id");
        boolean userRank = false;
        if (stdId > 0L && itemId > 0L && (flagMap = salaryItemUseRankFlag.get(stdId)) != null && flagMap.get(itemId).booleanValue()) {
            userRank = true;
        }
        return userRank;
    }

    public static Map<Long, Map<Long, Boolean>> getItemUseRankFlag(List<DynamicObject> list) {
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (DynamicObject adjApprDetailEnt : list) {
            long stdId = adjApprDetailEnt.getLong("dy_salarystd.id");
            long itemId = adjApprDetailEnt.getLong("dy_standarditem.id");
            if (stdId <= 0L || itemId <= 0L) continue;
            List itemIds = stdItemMap.computeIfAbsent(stdId, v1 -> Lists.newArrayList());
            itemIds.add(itemId);
        }
        return service.getSalaryItemUseRankFlag(stdItemMap);
    }

    public static Map<Long, Map<Long, Boolean>> getItemUseRankFlagDb(List<DynamicObject> list) {
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (DynamicObject adjApprPersonDyObj : list) {
            DynamicObjectCollection adjApprDetailEntObjs = adjApprPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprDetailEnt : adjApprDetailEntObjs) {
                long stdId = adjApprDetailEnt.getLong("salarystd.id");
                long itemId = adjApprDetailEnt.getLong("standarditem.id");
                if (stdId <= 0L || itemId <= 0L) continue;
                List itemIds = stdItemMap.computeIfAbsent(stdId, v1 -> Lists.newArrayList());
                itemIds.add(itemId);
            }
        }
        return service.getSalaryItemUseRankFlag(stdItemMap);
    }

    public static boolean checkItemUseRankDb(DynamicObject adjApprDetailEnt, Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag) {
        Map<Long, Boolean> flagMap;
        long stdId = adjApprDetailEnt.getLong("salarystd.id");
        long itemId = adjApprDetailEnt.getLong("standarditem.id");
        boolean userRank = false;
        if (stdId > 0L && itemId > 0L && (flagMap = salaryItemUseRankFlag.get(stdId)) != null && flagMap.get(itemId).booleanValue()) {
            userRank = true;
        }
        return userRank;
    }

    public static List<DynamicObject> getAdjApprPersonList(DynamicObject[] adjApprPersonObjs, String attriButionType) {
        SWCDataServiceHelper adjApprBillService = new SWCDataServiceHelper("hcdm_adjapprbill");
        Set adjApprBillIdSet = Arrays.stream(adjApprPersonObjs).map(dynamicObject -> dynamicObject.getLong("adjapprbill")).collect(Collectors.toSet());
        DynamicObject[] adjApprBillObjs = adjApprBillService.query(adjApprBillIdSet.toArray());
        List adjApprBillList = Arrays.stream(adjApprBillObjs).filter(item -> attriButionType.equals(item.getString("salaryadjrsn.attributiontype"))).collect(Collectors.toList());
        Set adjApprBillDecIdSet = adjApprBillList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        ArrayList<DynamicObject> adjApprPersonList = new ArrayList<DynamicObject>();
        Arrays.asList(adjApprPersonObjs).forEach(item -> {
            if (adjApprBillDecIdSet.contains(item.getLong("adjapprbill"))) {
                adjApprPersonList.add((DynamicObject)item);
            }
        });
        return adjApprPersonList;
    }

    public static void queryBillEntryDataFromDb(AdjApprPerQueryParam adjApprPerQueryParam, DynamicObjectCollection entryEntityDyObjs) {
        IDataModel billModel = adjApprPerQueryParam.getBillModel();
        EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
        int offSet = adjApprPerQueryParam.getOffSet();
        int pageSize = adjApprPerQueryParam.getPageSize();
        long adjApprBillId = adjApprPerQueryParam.getAdjApprBillId();
        String defaultOrderBy = adjApprPerQueryParam.getDefaultOrderBy();
        String sqlPermQueryCondition = adjApprPerQueryParam.getSqlPermQueryCondition();
        DynamicObjectType adjPersonEntityType = adjApprPerQueryParam.getApprPersonEntityType();
        Map<String, List> adjPersonDyObjDbResult = DecAdjApprGridHelper.getAdjPersonDyObjDbResult(offSet, pageSize, adjApprBillId, sqlPermQueryCondition, defaultOrderBy);
        List adjPersonIdList = adjPersonDyObjDbResult.get("adjPersonIdList");
        DynamicObject[] adjPersonDyObjs = DecAdjApprGridHelper.getAdjPersonDyObjs(adjApprBillId, adjPersonIdList);
        if (adjPersonDyObjs.length > 0) {
            List adjPersonEntryIdList = adjPersonDyObjDbResult.get("adjPersonEntryIdList");
            DecAdjApprGridHelper.convertAdjPersonToBillEntryData(entryEntityDyObjs, adjPersonEntryIdList, entityType, adjPersonEntityType, adjPersonDyObjs);
            List orderList = adjPersonDyObjDbResult.get("orderList");
            List<DynamicObject> entityDyObjsOrder = DecAdjApprGridHelper.setEntryEntityDyObjsOrder(orderList, entryEntityDyObjs);
            entryEntityDyObjs.clear();
            entryEntityDyObjs.addAll(entityDyObjsOrder);
            DecAdjApprGridHelper.setEntryEntityDyObjsSeq(entryEntityDyObjs);
            DecAdjApprGridHelper.handleSpecialFieldColumns(entryEntityDyObjs, adjPersonEntityType, billModel);
        }
    }

    private static Map<String, List> getAdjPersonDyObjDbResult(int offSet, int pageSize, long adjApprBillId, String sqlPermQueryCondition, String orderBy) {
        String selectSql = DecAdjApprGridHelper.buildDecAdjApprEntryQuerySql(offSet, pageSize, adjApprBillId, sqlPermQueryCondition, orderBy);
        HashMap<String, List> result = new HashMap<String, List>(3);
        ArrayList<String> orderList = new ArrayList<String>(10);
        ArrayList<Long> adjPersonIdList = new ArrayList<Long>(10);
        ArrayList<Long> adjPersonEntryIdList = new ArrayList<Long>(10);
        try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryDecAdjApprEntryData", (DBRoute)new DBRoute("hcdm"), (String)selectSql, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adjPersonId = (Long)row.get("fid");
                Long adjPersonEntryId = (Long)row.get("fentryid");
                adjPersonIdList.add(adjPersonId);
                adjPersonEntryIdList.add(adjPersonEntryId);
                orderList.add(adjPersonId + "_" + adjPersonEntryId);
            }
        }
        result.put("adjPersonIdList", adjPersonIdList);
        result.put("adjPersonEntryIdList", adjPersonEntryIdList);
        result.put("orderList", orderList);
        return result;
    }

    private static void setEntryEntityDyObjsSeq(DynamicObjectCollection entryEntityDyObjs) {
        for (int index = 0; index < entryEntityDyObjs.size(); ++index) {
            DynamicObject entryEntityDyObj = (DynamicObject)entryEntityDyObjs.get(index);
            entryEntityDyObj.set("seq", (Object)(index + 1));
        }
    }

    private static List<DynamicObject> setEntryEntityDyObjsOrder(List<String> sortOrderList, DynamicObjectCollection entryEntityDyObjs) {
        HashMap<String, Integer> sortIndexMap = new HashMap<String, Integer>(16);
        for (int index = 0; index < sortOrderList.size(); ++index) {
            sortIndexMap.put(sortOrderList.get(index), index);
        }
        TreeMap<Integer, DynamicObject> resultMap = new TreeMap<Integer, DynamicObject>();
        for (DynamicObject entryEntityDyObj : entryEntityDyObjs) {
            String compareValue = entryEntityDyObj.getLong("id") + "_" + entryEntityDyObj.getLong("adjperentryid");
            Integer sortIndex = (Integer)sortIndexMap.get(compareValue);
            resultMap.put(sortIndex, entryEntityDyObj);
        }
        return resultMap.values().stream().collect(Collectors.toList());
    }

    private static void convertAdjPersonToBillEntryData(DynamicObjectCollection entryEntityDyObjs, List<Long> adjPersonEntryIdList, EntityType entityType, DynamicObjectType adjPersonEntityType, DynamicObject[] adjPersonDyObjs) {
        Map<String, IDataEntityProperty> adjPersonPropertyMap = adjPersonEntityType.getProperties().stream().filter(property -> !"entryentity".equals(property)).collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        DataEntityPropertyCollection properties = ((EntryProp)adjPersonEntityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType().getProperties();
        Map<String, IDataEntityProperty> adjApprPersonEntryPropertyMap = properties.stream().collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap(entityType);
        Set<String> adjApprPersonPropKeySet = adjPersonPropertyMap.keySet();
        Set<String> adjApprPersonEntryPropKeySet = adjApprPersonEntryPropertyMap.keySet();
        Set<String> apprBillEntryPropKeySet = apprBillEntryPropertyMap.keySet();
        adjApprPersonPropKeySet.retainAll(apprBillEntryPropKeySet);
        adjApprPersonEntryPropKeySet.retainAll(apprBillEntryPropKeySet);
        adjApprPersonEntryPropKeySet.remove("id");
        for (int index = 0; index < adjPersonDyObjs.length; ++index) {
            DynamicObject adjApprPerson = adjPersonDyObjs[index];
            DynamicObjectCollection adjApprPersonEntryList = adjPersonDyObjs[index].getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                if (!adjPersonEntryIdList.contains(adjApprPersonEntry.getLong("id"))) continue;
                DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
                for (String propertyKey : adjApprPersonPropKeySet) {
                    DecAdjApprCreateGridHelper.setAdjApprBillEntryData(adjPersonPropertyMap, propertyKey, adjApprPerson, rowObj);
                }
                for (String entryPropertyKey : adjApprPersonEntryPropKeySet) {
                    rowObj.set("adjperentryid", (Object)adjApprPersonEntry.getLong("id"));
                    DecAdjApprCreateGridHelper.setAdjApprBillEntryData(adjApprPersonEntryPropertyMap, entryPropertyKey, adjApprPersonEntry, rowObj);
                }
                entryEntityDyObjs.add((Object)rowObj);
            }
        }
    }

    private static DynamicObject[] getAdjPersonDyObjs(long adjApprBillId, List<Long> adjPersonIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        List subAdjPersonIdList = Lists.partition(adjPersonIdList, (int)500);
        ArrayList<DynamicObject> adjPersonDyObjList = new ArrayList<DynamicObject>();
        for (List subAdjPersonIds : subAdjPersonIdList) {
            QFilter adjPersonQFilter = new QFilter("id", "in", (Object)subAdjPersonIds);
            QFilter adjBillQFilter = new QFilter("adjapprbill", "=", (Object)adjApprBillId);
            DynamicObject[] adjPersonDyObjArray = serviceHelper.query(adjApprPerSelectProperties, new QFilter[]{adjPersonQFilter, adjBillQFilter});
            List<DynamicObject> adjApprPersonList = Arrays.asList(adjPersonDyObjArray);
            adjPersonDyObjList.addAll(adjApprPersonList);
        }
        return adjPersonDyObjList.toArray(new DynamicObject[0]);
    }

    public static void handleSpecialFieldColumns(DynamicObjectCollection entryEntityDyObjs, DynamicObjectType adjPersonEntityType, IDataModel billModel) {
        String countryKey = DecAdjApprCreateGridHelper.buildKey("country");
        String orgKey = DecAdjApprCreateGridHelper.buildKey("org");
        DynamicObject entryEntity = null;
        for (int rowIndex = 0; rowIndex < entryEntityDyObjs.size(); ++rowIndex) {
            entryEntity = (DynamicObject)entryEntityDyObjs.get(rowIndex);
            DataEntityPropertyCollection properties = entryEntity.getDataEntityType().getProperties();
            if (properties.containsKey((Object)countryKey)) {
                DynamicObject country = entryEntity.getDynamicObject("dy_adjfile.country");
                entryEntity.set(countryKey, (Object)country);
            }
            if (!properties.containsKey((Object)orgKey)) continue;
            DynamicObject org = entryEntity.getDynamicObject("dy_adjfile.org");
            entryEntity.set(orgKey, (Object)org);
        }
        DecAdjApprGridHelper.setGradeAndRankDisplayName(entryEntityDyObjs, billModel);
        DecAdjApprGridHelper.setLogicAmount(entryEntityDyObjs, billModel);
    }

    public static String buildSqlPermQueryCondition(QFilter qFilter, boolean recursive, DynamicObjectType adjPersonEntityType) {
        StringBuilder conditionSql = new StringBuilder();
        String property = qFilter.getProperty();
        String cp = qFilter.getCP();
        Object value = qFilter.getValue();
        Map adjPersonPropertyMap = ((BasedataEntityType)adjPersonEntityType).getAllFields();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)adjPersonPropertyMap.get(property);
        if (!Objects.isNull(iDataEntityProperty)) {
            property = iDataEntityProperty.getAlias();
        }
        List qFilterNest = qFilter.getNests(false);
        if (cp.equalsIgnoreCase("is null") || cp.equalsIgnoreCase("is not null")) {
            conditionSql.append(property).append(' ').append(cp);
        } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
            conditionSql.append(property).append(' ').append(cp);
            conditionSql.append(" (").append(QFilterUtilHR.parametertoString((Object)value)).append(')');
        } else {
            conditionSql.append(property).append(' ').append(cp);
            conditionSql.append(' ').append(QFilterUtilHR.parametertoString((Object)value));
        }
        if (recursive) {
            for (QFilter.QFilterNest nest : qFilterNest) {
                conditionSql.insert(0, '(');
                if (nest.isAnd()) {
                    conditionSql.append(' ').append("and").append(' ');
                } else {
                    conditionSql.append(' ').append("or").append(' ');
                }
                conditionSql.append(DecAdjApprGridHelper.buildSqlPermQueryCondition(nest.getFilter(), true, adjPersonEntityType));
                conditionSql.append(')');
            }
        }
        logger.info("permission condition sql ={}", (Object)conditionSql.toString());
        return conditionSql.toString();
    }

    private static String buildDecAdjApprEntryQuerySql(int offSet, int pageSize, long adjApprBillId, String sqlPermQueryCondition, String orderBy) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select").append(" ");
        if (offSet >= 0 && pageSize > 0) {
            querySql.append("top ").append(pageSize).append(", ").append(offSet).append(" ");
        }
        querySql.append("t1.fid, t1.fentryid from t_hcdm_adjapprperent t1").append(" ");
        querySql.append("left join t_hcdm_adjapprper t2 on t1.fid = t2.fid").append(" ");
        querySql.append("left join t_hcdm_adjapprperent_a t3 on t1.fentryid = t3.fentryid").append(" ");
        querySql.append("left join t_hcdm_slystructureent t4 on t2.fsalarystructureid = t4.fid and t1.fstandarditemid = t4.fstandarditemid").append(" ");
        querySql.append("where 1 = 1").append(" ");
        if (adjApprBillId >= 0L) {
            querySql.append("and t2.fadjapprbillid = ").append(adjApprBillId).append(" ");
        }
        if (StringUtils.isNotEmpty((String)sqlPermQueryCondition)) {
            querySql.append("and").append(" ").append(sqlPermQueryCondition).append(" ");
        }
        if (StringUtils.isNotEmpty((String)orderBy)) {
            querySql.append(orderBy);
        }
        logger.info("adj entry query sql ={}", (Object)querySql.toString());
        return querySql.toString();
    }

    public static void setGradeAndRankDisplayName(DynamicObjectCollection entryEntities, IDataModel billModel) {
        String attributionType = DecAdjApprGridHelper.getAttributionType(billModel);
        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) {
            HashMap<Long, List<Pair<Long, Long>>> preAmountStdRangeMatchMap = new HashMap<Long, List<Pair<Long, Long>>>(16);
            ArrayList<Pair<Long, Long>> preAmountStdRangeMatchList = new ArrayList<Pair<Long, Long>>(10);
            HashMap<Long, List<Pair<Long, Long>>> amountStdRangeMatchMap = new HashMap<Long, List<Pair<Long, Long>>>(16);
            ArrayList<Pair<Long, Long>> amountStdRangeMatchList = new ArrayList<Pair<Long, Long>>(10);
            Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjApprGridHelper.getItemUseRankFlag((List<DynamicObject>)entryEntities);
            ArrayList<String> personRangeList = new ArrayList<String>(10);
            for (int rowIndex = 0; rowIndex < entryEntities.size(); ++rowIndex) {
                DynamicObject billEntryRow = (DynamicObject)entryEntities.get(rowIndex);
                String personRange = (String)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, "dy_salargrel", null);
                personRangeList.add(personRange);
            }
            GradeAndRankNameEntity personRangeToGradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromMatchGradeRankRel(personRangeList);
            for (int rowIndex = 0; rowIndex < entryEntities.size(); ++rowIndex) {
                String amountStdRange;
                DynamicObject billEntryRow = (DynamicObject)entryEntities.get(rowIndex);
                String preAmountStdRange = (String)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, "dy_preamountstdrange", null);
                if (StringUtils.isNotEmpty((String)preAmountStdRange)) {
                    DecAdjApprGridHelper.getAmountStdRangeData(preAmountStdRangeMatchMap, preAmountStdRangeMatchList, preAmountStdRange);
                }
                if (!StringUtils.isNotEmpty((String)(amountStdRange = (String)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, "dy_amountstdrange", null)))) continue;
                DecAdjApprGridHelper.getAmountStdRangeData(amountStdRangeMatchMap, amountStdRangeMatchList, amountStdRange);
            }
            GradeAndRankNameEntity preGradeAndRankNameEntity = DecAdjApprGridHelper.getMatchGradeAndRankNameEntity(preAmountStdRangeMatchMap, preAmountStdRangeMatchList);
            GradeAndRankNameEntity gradeAndRankNameEntity = DecAdjApprGridHelper.getMatchGradeAndRankNameEntity(amountStdRangeMatchMap, amountStdRangeMatchList);
            for (int rowIndex = 0; rowIndex < entryEntities.size(); ++rowIndex) {
                DynamicObject billEntryRow = (DynamicObject)entryEntities.get(rowIndex);
                String calcType = billEntryRow.getString("dy_calctype");
                DecAdjApprGridHelper.setAmountStdRangeDisplayName(preGradeAndRankNameEntity, billModel, billEntryRow, "dy_preamountstdrange", "dy_preamountstdrangedisplay");
                if (!CalcType.GRADE_RANK.getCode().equals(calcType)) {
                    DecAdjApprGridHelper.setAmountStdRangeDisplayName(gradeAndRankNameEntity, billModel, billEntryRow, "dy_amountstdrange", "dy_amountstdrangedisplay");
                    continue;
                }
                String personRange = (String)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, "dy_salargrel", null);
                Boolean isUseRank = DecAdjApprGridHelper.checkItemUseRank(billEntryRow, itemUseRankFlag);
                AmountStdRangeEntity amountStdRangeEntity = GradeAndRankNameHelper.convertMatchGradeRankRelToAmountStdRange(personRange, isUseRank, personRangeToGradeAndRankNameEntity);
                String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName(JSON.toJSONString((Object)amountStdRangeEntity), personRangeToGradeAndRankNameEntity);
                if (billModel.getProperty("dy_amountstdrangedisplay") == null) continue;
                billEntryRow.set("dy_amountstdrangedisplay", (Object)amountStdRangeName);
            }
        }
    }

    private static void getAmountStdRangeData(Map<Long, List<Pair<Long, Long>>> amountStdRangeMatchMap, List<Pair<Long, Long>> amountStdRangeMatchList, String amountStdRange) {
        AmountStdRangeEntity amountStdRangeEntity = (AmountStdRangeEntity)JSON.parseObject((String)amountStdRange, AmountStdRangeEntity.class, (Feature[])new Feature[]{Feature.OrderedField});
        if (amountStdRangeEntity != null) {
            Map positionInfo = amountStdRangeEntity.getPositionInfo();
            List positionInfoOfNotUseRank = amountStdRangeEntity.getPositionInfoOfNotUseRank();
            if (MapUtils.isNotEmpty((Map)positionInfo)) {
                positionInfo.forEach((key, value) -> {
                    List amountStdRangeRankList = amountStdRangeMatchMap.computeIfAbsent((Long)key, o -> Lists.newArrayList());
                    amountStdRangeRankList.addAll(value);
                });
            }
            if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRank)) {
                amountStdRangeMatchList.addAll(positionInfoOfNotUseRank);
            }
        }
    }

    private static void setAmountStdRangeDisplayName(GradeAndRankNameEntity gradeAndRankNameEntity, IDataModel billModel, DynamicObject billEntryRow, String keyColumn, String displayColumn) {
        String amountStdRange = (String)DynamicObjectValueHelper.dyObjGetValueIfExist(billEntryRow, keyColumn, null);
        if (StringUtils.isNotEmpty((String)amountStdRange)) {
            AmountStdRangeEntity amountStdRangeEntity = (AmountStdRangeEntity)JSON.parseObject((String)amountStdRange, AmountStdRangeEntity.class, (Feature[])new Feature[]{Feature.OrderedField});
            Map amountStdRangeMap = amountStdRangeEntity.getPositionInfo();
            List positionInfoOfNotUseRank = amountStdRangeEntity.getPositionInfoOfNotUseRank();
            String amountStdRangeName = null;
            if (MapUtils.isNotEmpty((Map)amountStdRangeMap)) {
                amountStdRangeName = DecAdjApprGridHelper.buildMatchGradeAndRankRangeDisplayName(amountStdRangeMap, gradeAndRankNameEntity);
            } else if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRank)) {
                amountStdRangeName = DecAdjApprGridHelper.buildAllMatchGradeRangeName(positionInfoOfNotUseRank, gradeAndRankNameEntity);
            }
            if (billModel.getProperty(displayColumn) != null) {
                billEntryRow.set(displayColumn, (Object)amountStdRangeName);
            }
        }
    }

    public static void setLogicAmount(DynamicObjectCollection entryEntities, IDataModel billModel) {
        String attributionType = DecAdjApprGridHelper.getAttributionType(billModel);
        for (int rowIndex = 0; rowIndex < entryEntities.size(); ++rowIndex) {
            BigDecimal logicAmount;
            DynamicObject billEntryRow = (DynamicObject)entryEntities.get(rowIndex);
            BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
            BigDecimal exrateValue = billEntryRow.getBigDecimal("dy_exratevalue");
            Boolean quoteType = billEntryRow.getBoolean("dy_quotetype");
            DynamicObject salaryStdDyObj = billEntryRow.getDynamicObject("dy_salarystd");
            DynamicObject preSalaryStdDyObj = billEntryRow.getDynamicObject("dy_presalarystd");
            if (salaryStdDyObj == null || amount == null) continue;
            long stdCurrency = AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType) ? salaryStdDyObj.getLong("currency.id") : (preSalaryStdDyObj != null ? preSalaryStdDyObj.getLong("currency.id") : salaryStdDyObj.getLong("currency.id"));
            long decCurrency = billEntryRow.getLong("dy_currency.id");
            if (billModel == null) continue;
            if (stdCurrency == decCurrency) {
                if (billModel.getProperty("dy_amountlogic") == null) continue;
                billEntryRow.set("dy_amountlogic", (Object)amount);
                continue;
            }
            if (exrateValue == null || exrateValue.compareTo(BigDecimal.ZERO) == 0) continue;
            if (quoteType.booleanValue()) {
                logicAmount = amount.multiply(exrateValue);
                if (billModel.getProperty("dy_amountlogic") == null) continue;
                billEntryRow.set("dy_amountlogic", (Object)logicAmount);
                continue;
            }
            logicAmount = amount.divide(exrateValue, 2, 4);
            if (billModel.getProperty("dy_amountlogic") == null) continue;
            billEntryRow.set("dy_amountlogic", (Object)logicAmount);
        }
    }

    public static void saveAdjApprPerson(List<DynamicObject> adjApprPersonList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        List<DynamicObject> updateAdjPersonList = adjApprPersonList.stream().filter(item -> item.getLong("id") != 0L).collect(Collectors.toList());
        List<DynamicObject> addAdjPersonList = adjApprPersonList.stream().filter(item -> item.getLong("id") == 0L).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(addAdjPersonList)) {
            serviceHelper.save(addAdjPersonList.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(updateAdjPersonList)) {
            serviceHelper.save(updateAdjPersonList.toArray(new DynamicObject[0]));
        }
    }

    public static Set<Long> deleteAdjApprPerson(String selectRowIds) {
        HashMap<Long, List<Long>> waitDeleteEntryIdMap = new HashMap<Long, List<Long>>(16);
        if (StringUtils.isNotEmpty((String)selectRowIds)) {
            String[] deleteEntryIds;
            for (String deleteEntryId : deleteEntryIds = selectRowIds.split(",")) {
                String[] deleteEntryIdArray = deleteEntryId.split("_");
                Long adjApprPerId = Long.parseLong(deleteEntryIdArray[0]);
                Long adjApprPerEntryId = Long.parseLong(deleteEntryIdArray[1]);
                List entryIdList = waitDeleteEntryIdMap.computeIfAbsent(adjApprPerId, o -> Lists.newArrayList());
                entryIdList.add(adjApprPerEntryId);
                waitDeleteEntryIdMap.put(adjApprPerId, entryIdList);
            }
        }
        return DecAdjApprGridHelper.deleteAdjPersonEnt(waitDeleteEntryIdMap);
    }

    /*
     * Exception decompiling
     */
    private static Set<Long> deleteAdjPersonEnt(Map<Long, List<Long>> waitDeleteEntryIdMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntryRows(List<DynamicObject> beCopyRowDyObjList, DynamicObject dataEntity, DynamicObjectType adjPersonEntityType, EntityType entityType) {
        Set<Long> adjApprPerIdSet = beCopyRowDyObjList.stream().map(selectRowDynamicObj -> selectRowDynamicObj.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] adjApprPersonDyObjs = adjPersonServiceHelper.loadDynamicObjectArray((Object[])adjApprPerIdSet.toArray(new Long[0]));
        Map<Long, DynamicObject> dbEntryMap = Arrays.asList(adjApprPersonDyObjs).stream().collect(Collectors.toMap(entry -> entry.getLong("id"), entry -> entry, (k1, k2) -> k2));
        Map<String, IDataEntityProperty> adjPersonEntryPropMap = ((EntryProp)adjPersonEntityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType().getProperties().stream().collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap(entityType);
        Set<String> adjApprPersonEntryPropKeySet = adjPersonEntryPropMap.keySet();
        Set<String> apprBillEntryPropKeySet = apprBillEntryPropertyMap.keySet();
        adjApprPersonEntryPropKeySet.retainAll(apprBillEntryPropKeySet);
        adjApprPersonEntryPropKeySet.remove("id");
        Date maxBsled = SWCDateTimeUtils.getMaxBsled();
        for (DynamicObject selectRowDyObj : beCopyRowDyObjList) {
            Long adjApprPerId = selectRowDyObj.getLong("id");
            DynamicObject adjApprPerDynamicObj = dbEntryMap.get(adjApprPerId);
            DynamicObjectCollection dbEntry = adjApprPerDynamicObj.getDynamicObjectCollection("entryentity");
            DynamicObject adjApprPersonEntry = adjPersonServiceHelper.generateEmptyEntryDynamicObject("entryentity");
            for (String entryPropertyKey : adjApprPersonEntryPropKeySet) {
                IFieldHandle prop = (IFieldHandle)adjPersonEntryPropMap.get(entryPropertyKey);
                if (!prop.isCopyable()) continue;
                DecAdjApprCreateGridHelper.setAdjApprPersonData(adjPersonEntryPropMap, entryPropertyKey, adjApprPersonEntry, selectRowDyObj);
            }
            if (adjApprPersonEntry.getDate("salbsled") == null) {
                adjApprPersonEntry.set("salbsled", (Object)maxBsled);
            }
            dbEntry.add((Object)adjApprPersonEntry);
        }
        try (TXHandle txHandle = TX.required();){
            adjPersonServiceHelper.save(adjApprPersonDyObjs);
            dataEntity.set("isdraft", (Object)YesOrNoEnum.YES.getCode());
            adjBillServiceHelper.saveOne(dataEntity);
        }
    }

    public static void saveAdjApprChangedEntryRows(List<DynamicObject> entryRows, DynamicObjectType adjPersonEntityType, EntityType billEntryEntityType) {
        Set<Long> adjApprPerIdSet = entryRows.stream().map(selectRowDynamicObj -> selectRowDynamicObj.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] adjApprPersonDyObjs = adjPersonServiceHelper.loadDynamicObjectArray((Object[])adjApprPerIdSet.toArray(new Long[0]));
        Map<Long, DynamicObject> dbEntryMap = Arrays.asList(adjApprPersonDyObjs).stream().collect(Collectors.toMap(entry -> entry.getLong("id"), entry -> entry, (k1, k2) -> k2));
        Map<String, IDataEntityProperty> adjPersonPropertyMap = adjPersonEntityType.getProperties().stream().filter(property -> !"entryentity".equals(property)).collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        Map<String, IDataEntityProperty> adjApprPersonEntryPropertyMap = ((EntryProp)adjPersonEntityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType().getProperties().stream().collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap(billEntryEntityType);
        Set<String> adjApprPersonPropKeySet = adjPersonPropertyMap.keySet();
        Set<String> adjApprPersonEntryPropKeySet = adjApprPersonEntryPropertyMap.keySet();
        Set<String> apprBillEntryPropKeySet = apprBillEntryPropertyMap.keySet();
        adjApprPersonPropKeySet.retainAll(apprBillEntryPropKeySet);
        adjApprPersonEntryPropKeySet.retainAll(apprBillEntryPropKeySet);
        adjApprPersonEntryPropKeySet.remove("id");
        for (DynamicObject entryRow : entryRows) {
            Long adjApprPerId = entryRow.getLong("id");
            DynamicObject dbEntry = dbEntryMap.get(adjApprPerId);
            if (dbEntry == null) continue;
            for (String propertyKey : adjApprPersonPropKeySet) {
                DecAdjApprCreateGridHelper.setAdjApprPersonData(adjPersonPropertyMap, propertyKey, dbEntry, entryRow);
            }
            for (String entryPropertyKey : adjApprPersonEntryPropKeySet) {
                DynamicObjectCollection dbColl = dbEntry.getDynamicObjectCollection("entryentity");
                for (DynamicObject dbAdjApprPersonEntry : dbColl) {
                    if (entryRow.getLong("adjperentryid") != dbAdjApprPersonEntry.getLong("id")) continue;
                    DecAdjApprCreateGridHelper.setAdjApprPersonData(adjApprPersonEntryPropertyMap, entryPropertyKey, dbAdjApprPersonEntry, entryRow);
                }
            }
        }
        adjPersonServiceHelper.save(adjApprPersonDyObjs);
    }

    public static int getAdjApprPersonCount(Long adjApprBillId) {
        String sql = "SELECT COUNT(1) FCOUNTA FROM T_HCDM_ADJAPPRPER WHERE FADJAPPRBILLID = ?";
        int countOut = (Integer)SWCDbUtil.query((DBRoute)new DBRoute("hcdm"), (String)sql, (Object[])new Object[]{adjApprBillId}, rs -> {
            int countInner = 0;
            while (rs.next()) {
                countInner = rs.getInt("FCOUNTA");
            }
            return countInner;
        });
        return countOut;
    }

    public static QFilter getEntryFilterQFilter(Long adjApprBillId) {
        QFilter adjApprBillIdQFilter = new QFilter("adjapprbill", "=", (Object)adjApprBillId);
        List dataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)"hcdm_adjapprperson", (String)"47150e89000000ac");
        if (dataRuleQFilter != null && dataRuleQFilter.size() > 0) {
            for (QFilter authFilter : dataRuleQFilter) {
                adjApprBillIdQFilter.and(authFilter);
            }
        }
        logger.info("adj entry permission qfilter ={}", (Object)adjApprBillIdQFilter.toString());
        return adjApprBillIdQFilter;
    }

    public static Map<String, BigDecimal> getAmountResultList(IDataModel billModel) {
        Object pkValue = billModel.getDataEntity().getPkValue();
        QFilter qFilter = DecAdjApprGridHelper.getEntryFilterQFilter((Long)pkValue);
        String attributionType = DecAdjApprGridHelper.getAttributionType(billModel);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        DynamicObject[] adjApprPersonObjs = serviceHelper.query("id, entryentity, entryentity.currency, entryentity.frequency, entryentity.amount, entryentity.actualamount", new QFilter[]{qFilter});
        DynamicObjectCollection adjApprPersonEntryObjs = new DynamicObjectCollection();
        Arrays.stream(adjApprPersonObjs).forEach(obj -> adjApprPersonEntryObjs.addAll((Collection)obj.getDynamicObjectCollection("entryentity")));
        Map<String, BigDecimal> amountResultMap = null;
        amountResultMap = AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType) ? DecAdjApprGridHelper.getAmountResultMap(adjApprPersonEntryObjs, "amount") : DecAdjApprGridHelper.getAmountResultMap(adjApprPersonEntryObjs, "actualamount");
        return amountResultMap;
    }

    private static Map<String, BigDecimal> getAmountResultMap(DynamicObjectCollection adjApprPersonEntryObjs, String columnKey) {
        return adjApprPersonEntryObjs.stream().filter(entryRow -> entryRow.getBigDecimal(columnKey) != null).collect(Collectors.groupingBy(key -> String.format("%s_%s", key.getLong("currency.id"), key.getLong("frequency.id")), Collectors.mapping(value -> value.getBigDecimal(columnKey), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
    }

    public static List<String> getFormatAmountResult(Map<String, BigDecimal> amountMap, IDataModel billModel) {
        Iterator<Map.Entry<String, BigDecimal>> iterator = amountMap.entrySet().iterator();
        BasedataProp currencyProp = (BasedataProp)billModel.getProperty("dy_currency");
        BasedataProp frequencyProp = (BasedataProp)billModel.getProperty("dy_frequency");
        ArrayList<String> formatAmountList = new ArrayList<String>(amountMap.size());
        while (iterator.hasNext()) {
            Map.Entry<String, BigDecimal> entry = iterator.next();
            String currFreqGroupKey = entry.getKey();
            BigDecimal amount = entry.getValue();
            Long[] currFreqGroupKeyArr = (Long[])ConvertUtils.convert((String[])currFreqGroupKey.split("_"), Long.class);
            DynamicObject currencyDynamicObj = billModel.loadReferenceData((DynamicObjectType)currencyProp.getComplexType(), (Object)currFreqGroupKeyArr[0]);
            DynamicObject frequencyDynamicObj = billModel.loadReferenceData((DynamicObjectType)frequencyProp.getComplexType(), (Object)currFreqGroupKeyArr[1]);
            if (amount == null || currencyDynamicObj == null || frequencyDynamicObj == null) continue;
            String pricePrecision = currencyDynamicObj.getString("amtprecision");
            String frequencyName = frequencyDynamicObj.getString("name");
            String formatAmount = AdjApprovalGridHelper.formatAmountValue(amount, currencyDynamicObj, Integer.parseInt(pricePrecision));
            StringBuilder formatAmountResult = new StringBuilder();
            formatAmountResult.append(formatAmount).append('/').append(frequencyName);
            formatAmountList.add(formatAmountResult.toString());
        }
        return formatAmountList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntryIfDeleteStdItem(DynamicObject dataEntity, List<Long> stdItemOldIdList, DynamicObject[] adjPersonDyObjs) {
        Long pkValue = (Long)dataEntity.getPkValue();
        for (DynamicObject adjPersonDyObj : adjPersonDyObjs) {
            DynamicObjectCollection adjPersonEntryDyObjs = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            adjPersonEntryDyObjs.removeIf(item -> stdItemOldIdList.contains(item.getLong("standarditem.id")));
        }
        ArrayList<DynamicObject> waitDeleteAdjApprPerList = new ArrayList<DynamicObject>(10);
        for (DynamicObject adjPersonDyObj : adjPersonDyObjs) {
            DynamicObjectCollection dbAdjPersonEntryList = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)dbAdjPersonEntryList)) continue;
            waitDeleteAdjApprPerList.add(adjPersonDyObj);
        }
        Set waitDeleteAdjApprPerIdSet = waitDeleteAdjApprPerList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        try (TXHandle txHandle = TX.required();){
            adjPersonServiceHelper.update(adjPersonDyObjs);
            if (CollectionUtils.isNotEmpty(waitDeleteAdjApprPerIdSet)) {
                adjPersonServiceHelper.delete(waitDeleteAdjApprPerIdSet.toArray());
            }
            adjBillServiceHelper.saveOne(dataEntity);
            int personCount = dataEntity.getInt("totalperson");
            if (CollectionUtils.isNotEmpty(waitDeleteAdjApprPerIdSet)) {
                int size = waitDeleteAdjApprPerIdSet.size();
                DecAdjApprGridHelper.updateTotalPerson(personCount - size, pkValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntryRows(DynamicObject dataEntity, String selectRowIds) {
        try (TXHandle txHandle = TX.required();){
            Set<Long> waitDeleteAdjApprPerIdSet = DecAdjApprGridHelper.deleteAdjApprPerson(selectRowIds);
            DecAdjApprGridHelper.afterDeleteEntryByAdjPerId(dataEntity, waitDeleteAdjApprPerIdSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntryRowsByAdjApprPerId(DynamicObject dataEntity, Collection<Long> waitDeleteAdjApprPerIdSet) {
        if (CollectionUtils.isNotEmpty(waitDeleteAdjApprPerIdSet)) {
            try (TXHandle txHandle = TX.required();){
                adjPersonServiceHelper.delete(waitDeleteAdjApprPerIdSet.toArray());
                DecAdjApprGridHelper.afterDeleteEntryByAdjPerId(dataEntity, waitDeleteAdjApprPerIdSet);
            }
        }
    }

    private static void afterDeleteEntryByAdjPerId(DynamicObject dataEntity, Collection<Long> waitDeleteAdjApprPerIdSet) {
        int personCount = dataEntity.getInt("totalperson");
        if (CollectionUtils.isNotEmpty(waitDeleteAdjApprPerIdSet)) {
            int size = waitDeleteAdjApprPerIdSet.size();
            dataEntity.set("totalperson", (Object)(personCount - size));
        }
        dataEntity.set("isdraft", (Object)YesOrNoEnum.YES.getCode());
        DecAdjApprGridHelper.updateAdjBill(dataEntity.getLong("id"), personCount, YesOrNoEnum.YES.getCode());
    }

    public static void updateAdjBill(Long id, int totalPerson, String isDraft) {
        String updateSql = "UPDATE T_HCDM_ADJAPPRBILL SET FISDRAFT = ?,FTOTALPERSON = ? WHERE FID = ?";
        Object[] param = new Object[]{isDraft, totalPerson, id};
        SWCDbUtil.execute((DBRoute)HCDMDbHelper.route, (String)updateSql, (Object[])param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllEntryRows(Long pkValue, DynamicObject dataEntity) {
        QFilter permissionQFilter = DecAdjApprGridHelper.getEntryFilterQFilter(pkValue);
        QFilter[] qFilters = new QFilter[]{new QFilter("adjapprbill", "=", (Object)pkValue), permissionQFilter};
        DynamicObject[] adjPersonDyObjs = adjPersonServiceHelper.query(qFilters);
        Set adjPersonIdSet = Arrays.stream(adjPersonDyObjs).map(dyObj -> dyObj.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(adjPersonIdSet)) {
            int personCount = dataEntity.getInt("totalperson");
            int size = adjPersonIdSet.size();
            dataEntity.set("totalperson", (Object)(personCount - size));
        }
        try (TXHandle txHandle = TX.required();){
            adjPersonServiceHelper.deleteByFilter(qFilters);
            adjBillServiceHelper.saveOne(dataEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEntryRowSalBsed(DynamicObject dataEntity, Object effectiveDate) {
        DynamicObject[] adjApprPersonObjs;
        Object pkValue = dataEntity.getPkValue();
        QFilter permissionQFilter = DecAdjApprGridHelper.getEntryFilterQFilter((Long)pkValue);
        QFilter[] qFilters = new QFilter[]{new QFilter("adjapprbill", "=", pkValue), permissionQFilter};
        for (DynamicObject adjApprPerson : adjApprPersonObjs = adjPersonServiceHelper.query("id, entryentity.salbsed", qFilters)) {
            DynamicObjectCollection entryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : entryList) {
                adjApprPersonEntry.set("salbsed", effectiveDate);
            }
        }
        try (TXHandle txHandle = TX.required();){
            adjBillServiceHelper.saveOne(dataEntity);
            adjPersonServiceHelper.save(adjApprPersonObjs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEntryRowData(DynamicObject dataEntity, EntityType entityType, Object currency) {
        DynamicObject[] adjApprPersonList;
        String selectProperties = "id, adjfile, entryentity, entryentity.currency, entryentity.salarystd,entryentity.exratevalue, entryentity.overstandardtype, entryentity.standarditem, entryentity.excesscontrol,entryentity.quotetype, entryentity.exratevalue, entryentity.amount, entryentity.stdamount, entryentity.amountlogic,entryentity.coefficient, entryentity.precurrency, entryentity.salargrel, entryentity.grade, entryentity.rank,entryentity.salarypercent, entryentity.salaryseeprate, entryentity.intervalmin, entryentity.intervalmax, entryentity.salbsed";
        Object pkValue = dataEntity.getPkValue();
        BillExRateManager rateManager = new BillExRateManager();
        String attributionType = dataEntity.getString("salaryadjrsn.attributiontype");
        long excTableId = dataEntity.getLong("exctable.id");
        Date rateDate = dataEntity.getDate("exchangeratedate");
        QFilter permissionQFilter = DecAdjApprGridHelper.getEntryFilterQFilter((Long)pkValue);
        QFilter[] qFilters = new QFilter[]{new QFilter("adjapprbill", "=", pkValue), permissionQFilter};
        for (DynamicObject adjApprPerson : adjApprPersonList = adjPersonServiceHelper.query(selectProperties, qFilters)) {
            DynamicObjectCollection adjApprPersonEntryList = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryList) {
                boolean calculateFlag;
                if (currency != null) {
                    adjApprPersonEntry.set("currency", currency);
                }
                BigDecimal amount = adjApprPersonEntry.getBigDecimal("amount");
                int decCurrencyScale = adjApprPersonEntry.getInt("currency.amtprecision");
                if (!Objects.isNull(amount)) {
                    BigDecimal exrateValue = adjApprPersonEntry.getBigDecimal("exratevalue");
                    boolean quoteType = adjApprPersonEntry.getBoolean("quotetype");
                    if (exrateValue != null && exrateValue.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal logicAmount;
                        if (quoteType) {
                            logicAmount = amount.multiply(exrateValue).setScale(decCurrencyScale, 4);
                            adjApprPersonEntry.set("amountlogic", (Object)logicAmount);
                        } else {
                            logicAmount = amount.divide(exrateValue, decCurrencyScale, 4);
                            adjApprPersonEntry.set("amountlogic", (Object)logicAmount);
                        }
                    } else {
                        adjApprPersonEntry.set("amountlogic", (Object)amount);
                    }
                } else {
                    DynamicObject coefficientDyObj = adjApprPersonEntry.getDynamicObject("coefficient");
                    BigDecimal stdAmount = adjApprPersonEntry.getBigDecimal("stdamount");
                    if (!Objects.isNull(stdAmount)) {
                        BigDecimal coefficientValue = BigDecimal.ONE;
                        if (!SWCBaseUtils.isEmpty((DynamicObject)coefficientDyObj)) {
                            coefficientValue = coefficientDyObj.getBigDecimal("coefficientvalue");
                        }
                        BigDecimal stdMulCoffAmount = coefficientValue.multiply(stdAmount);
                        adjApprPersonEntry.set("amountlogic", (Object)stdMulCoffAmount);
                    }
                }
                if (calculateFlag = DecAdjApprGridHelper.isNeedCalculate(rateManager, excTableId, rateDate, adjApprPersonEntry)) continue;
                adjApprPersonEntry.set("amountlogic", null);
                adjApprPersonEntry.set("overstandardtype", null);
                adjApprPersonEntry.set("salarypercent", null);
                adjApprPersonEntry.set("salaryseeprate", null);
                adjApprPersonEntry.set("intervalmin", null);
                adjApprPersonEntry.set("intervalmax", null);
            }
        }
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap(entityType);
        Set<String> entryPropertySet = apprBillEntryPropertyMap.keySet();
        List<DynamicObject> adjApprPersonDyObjList = Arrays.asList(adjApprPersonList);
        AdjPersonPackageHelper.setFinalAmountRelationInfo(adjApprPersonDyObjList, entryPropertySet, excTableId, rateDate, CalcSceneType.DEC_CHANGE_RATIO_OR_CURRENCY);
        CalculateUtils.setCalcFieldAfter(excTableId, rateDate, entryPropertySet, adjApprPersonDyObjList, dataEntity.getLong("adjfieldcfg.id"));
        AdjPersonPackageHelper.setOverStandardType(adjApprPersonDyObjList, entryPropertySet, attributionType, excTableId, rateDate);
        try (TXHandle txHandle = TX.required();){
            adjBillServiceHelper.saveOne(dataEntity);
            List subPartPersonList = Lists.partition(adjApprPersonDyObjList, (int)500);
            for (List personList : subPartPersonList) {
                adjPersonServiceHelper.save(personList.toArray(new DynamicObject[0]));
            }
        }
    }

    private static boolean isNeedCalculate(BillExRateManager rateManager, long excTableId, Date rateDate, DynamicObject adjApprPersonEntry) {
        ExchangeRateInfo exrateInfo;
        long adjCurrency = adjApprPersonEntry.getLong("currency.id");
        long salaryCurrency = adjApprPersonEntry.getLong("salarystd.currency.id");
        boolean calculateFlag = true;
        if (adjCurrency > 0L && salaryCurrency > 0L && adjCurrency != salaryCurrency && (excTableId <= 0L || ObjectUtils.isEmpty((Object)rateDate))) {
            calculateFlag = false;
        }
        if (adjCurrency > 0L && salaryCurrency > 0L && adjCurrency != salaryCurrency && excTableId > 0L && rateDate != null && (exrateInfo = rateManager.getExRate(new ExRateKey(adjCurrency, salaryCurrency, rateDate.getTime(), excTableId))) == null) {
            calculateFlag = false;
        }
        return calculateFlag;
    }

    public static void updateTotalPerson(int adjApprPersonCount, Object pkValue) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] paramObj = new Object[]{adjApprPersonCount, pkValue};
        paramList.add(paramObj);
        String updateSql = "update t_hcdm_adjapprbill set ftotalperson = ? where fid = ?";
        SWCDbUtil.executeBatch((DBRoute)new DBRoute("hcdm"), (String)updateSql, paramList);
    }

    private static boolean isNeedCalculate(long excTableId, Date tableRateDate, BillExRateManager rateManager, DynamicObject adjPersonEntry) {
        ExchangeRateInfo exrateInfo;
        DynamicObject salaryStdDyObj;
        long adjCurrency = adjPersonEntry.getLong("currency.id");
        long preCurrency = adjPersonEntry.getLong("precurrency.id");
        if (preCurrency <= 0L && (salaryStdDyObj = adjPersonEntry.getDynamicObject("salarystd")) != null) {
            preCurrency = salaryStdDyObj.getLong("currency.id");
        }
        boolean calculateFlag = true;
        if (preCurrency > 0L && adjCurrency != preCurrency && (excTableId <= 0L || ObjectUtils.isEmpty((Object)tableRateDate))) {
            calculateFlag = false;
        }
        if (adjCurrency > 0L && preCurrency > 0L && adjCurrency != preCurrency && excTableId > 0L && tableRateDate != null && (exrateInfo = rateManager.getExRate(new ExRateKey(adjCurrency, preCurrency, tableRateDate.getTime(), excTableId))) == null) {
            calculateFlag = false;
        }
        return calculateFlag;
    }

    public static String getAttributionType(IDataModel billModel) {
        return DecAdjApprGridHelper.getAttributionType(billModel.getDataEntity());
    }

    public static String getAttributionType(DynamicObject billModel) {
        DynamicObject salaryAdjRsn = billModel.getDynamicObject("salaryadjrsn");
        String attributionType = null;
        attributionType = salaryAdjRsn == null ? AdjAttributionType.DECATTRTYPE.getCode() : salaryAdjRsn.getString("attributiontype");
        return attributionType;
    }

    public static DynamicObjectCollection getAdjPersonDbData(IDataModel billModel, DynamicObjectType adjPersonEntityType) {
        String defaultOrderBy = "order by t2.fupdatetime desc, t2.fadjfileid asc, t4.fseq asc";
        Long pkValue = (Long)billModel.getDataEntity().getPkValue();
        AdjApprPerQueryParam adjApprPerQueryParam = new AdjApprPerQueryParam();
        adjApprPerQueryParam.setAdjApprBillId(pkValue);
        adjApprPerQueryParam.setDefaultOrderBy(defaultOrderBy);
        DynamicObjectCollection entryEntities = new DynamicObjectCollection();
        adjApprPerQueryParam.setBillModel(billModel);
        adjApprPerQueryParam.setApprPersonEntityType(adjPersonEntityType);
        DecAdjApprGridHelper.queryBillEntryDataFromDb(adjApprPerQueryParam, entryEntities);
        return entryEntities;
    }

    public static void setAdjBillTotalPersonNum(Long pkValue) {
        int adjPersonCount = DecAdjApprGridHelper.getAdjApprPersonCount(pkValue);
        DecAdjApprGridHelper.updateTotalPerson(adjPersonCount, pkValue);
    }

    public static void deleteAdjApprPerson(List<Long> adjApprBillIds) {
        QFilter delFilter = new QFilter("adjapprbill", "in", adjApprBillIds);
        adjPersonServiceHelper.deleteByFilter(new QFilter[]{delFilter});
    }

    public static List<String> collectMustInputFieldList(Map<String, IDataEntityProperty> propertyMap) {
        ArrayList<String> mustInputFieldList = new ArrayList<String>(10);
        for (Map.Entry<String, IDataEntityProperty> entry : propertyMap.entrySet()) {
            MulBasedataProp mulBasedataProp;
            IDataEntityProperty iDataEntityProperty = entry.getValue();
            if (iDataEntityProperty instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)iDataEntityProperty;
                if (!fieldProp.isMustInput()) continue;
                mustInputFieldList.add(fieldProp.getName());
                continue;
            }
            if (iDataEntityProperty instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)iDataEntityProperty;
                if (!basedataProp.isMustInput()) continue;
                mustInputFieldList.add(basedataProp.getName());
                continue;
            }
            if (!(iDataEntityProperty instanceof MulBasedataProp) || !(mulBasedataProp = (MulBasedataProp)iDataEntityProperty).isMustInput()) continue;
            mustInputFieldList.add(mulBasedataProp.getName());
        }
        return mustInputFieldList;
    }

    public static void calcWithLatestRate(DynamicObject billEntity) {
        EntityType entityType = (EntityType)billEntity.getDynamicObjectCollection("adjapprdetailentry").getDynamicObjectType();
        String attributionType = billEntity.getString("salaryadjrsn.attributiontype");
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
            DecAdjApprGridHelper.updateEntryRowData(billEntity, entityType, null);
        } else {
            DecAdjApprGridHelper.calcAdjRangeAndAmount(billEntity, entityType, null);
        }
    }

    private static List<MatchStdTableWithAdjFileParam> getFileItemBsedMap(List<DynamicObject> adjApprPersonList, Long adjFieldCfgId) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, Long> visibleContrastAdjFields = DecAdjApprGridHelper.getVisibleContrastAdjFields(adjFieldCfgId);
        for (DynamicObject adjApprPersonDyObj : adjApprPersonList) {
            long fileId = adjApprPersonDyObj.getLong("adjfile.id");
            Map<Long, List<Long>> customContrastPropValue = DecAdjApprGridHelper.getContrastPropValueFromPersonObj(adjApprPersonDyObj, visibleContrastAdjFields);
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjApprPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntry : adjApprPersonEntryDyObjs) {
                long itemId = adjApprPersonEntry.getLong("standarditem.id");
                Date salbsed = adjApprPersonEntry.getDate("salbsed");
                if (fileId <= 0L || itemId <= 0L) continue;
                MatchStdTableWithAdjFileParam param = new MatchStdTableWithAdjFileParam();
                resultList.add(param);
                param.setAdjFileId(fileId);
                param.setStdItemId(itemId);
                param.setBsed(salbsed);
                param.setPersonPropValue(customContrastPropValue);
            }
        }
        return resultList;
    }

    public static Map<Long, Map<Long, SalaryStdMatchResultNew>> getMatchStdResult(List<DynamicObject> adjApprPersonList, Long adjFieldCfgId) {
        List<MatchStdTableWithAdjFileParam> matchParams = DecAdjApprGridHelper.getFileItemBsedMap(adjApprPersonList, adjFieldCfgId);
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Long, Map<Long, SalaryStdMatchResultNew>> stdMatchResult = adjApprovalApplicationService.batchMatchStdTable(matchParams);
        return stdMatchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEntryRowIfCalTypeChange(DynamicObject dataEntity, EntityType entityType, String attributionType, IDataModel billModel) {
        QFilter permissionQFilter = DecAdjApprGridHelper.getEntryFilterQFilter((Long)dataEntity.getPkValue());
        QFilter[] qFilters = new QFilter[]{new QFilter("adjapprbill", "=", dataEntity.getPkValue()), permissionQFilter};
        DynamicObject[] adjApprPersonObjs = adjPersonServiceHelper.query(selectProperties, qFilters);
        long tableCurrency = dataEntity.getLong("currency.id");
        long excTableId = dataEntity.getLong("exctable.id");
        Date tableRateDate = dataEntity.getDate("exchangeratedate");
        BillExRateManager rateManager = new BillExRateManager();
        String calType = dataEntity.getString("caltype");
        Arrays.asList(adjApprPersonObjs).forEach(personObj -> personObj.getDynamicObjectCollection("entryentity").forEach(entryObj -> entryObj.set("calctype", (Object)calType)));
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap(entityType);
        Set<String> entryPropertySet = apprBillEntryPropertyMap.keySet();
        List<DynamicObject> adjApprPersonObjList = Arrays.asList(adjApprPersonObjs);
        if (CalcType.RATIO.getCode().equals(calType) || CalcType.AMOUNT.getCode().equals(calType)) {
            for (DynamicObject personObj2 : adjApprPersonObjs) {
                DynamicObjectCollection adjPersonEntryList = personObj2.getDynamicObjectCollection("entryentity");
                for (DynamicObject adjPersonEntryDyObj : adjPersonEntryList) {
                    CalculateUtils.calcWithCurExchange(tableCurrency, excTableId, tableRateDate, adjPersonEntryDyObj, rateManager);
                }
            }
            CalculateUtils.setAdjCalcFieldAfter(excTableId, tableRateDate, adjApprPersonObjList, entryPropertySet);
            AdjPersonPackageHelper.setOverStandardType(adjApprPersonObjList, entryPropertySet, attributionType, excTableId, tableRateDate);
        } else {
            Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = DecAdjApprGridHelper.getMatchStdResult(adjApprPersonObjList, dataEntity.getLong("adjfieldcfg.id"));
            AdjPersonPackageHelper.setGradeAndRankRelationInfo(matchStdResult, adjApprPersonObjList, entryPropertySet, attributionType, billModel, CalcSceneType.CHANGE_CALTYPE);
            List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = AdjPersonPackageHelper.getStdAmountQueryResult(adjApprPersonObjList);
            AdjPersonPackageHelper.setStdAmountRelationInfo(adjApprPersonObjList, salaryStdAmountQueryResult, entryPropertySet, CalcSceneType.CHANGE_CALTYPE);
            AdjPersonPackageHelper.setFinalAmountRelationInfo(adjApprPersonObjList, entryPropertySet, excTableId, tableRateDate, CalcSceneType.CHANGE_CALTYPE);
            AdjPersonPackageHelper.setActualAmountOrRatioWithAmount(adjApprPersonObjList, entryPropertySet, attributionType, excTableId, tableRateDate);
            AdjPersonPackageHelper.setSalaryPercentAndSeepRateInfo(adjApprPersonObjList, salaryStdAmountQueryResult, entryPropertySet, excTableId, tableRateDate, CalcSceneType.CHANGE_CALTYPE);
            AdjPersonPackageHelper.setOverStandardType(adjApprPersonObjList, entryPropertySet, attributionType, excTableId, tableRateDate);
            AdjPersonPackageHelper.setGradeAndRankByStdScmMatchStrategy(matchStdResult, adjApprPersonObjList, entryPropertySet, CalcSceneType.CHANGE_CALTYPE);
        }
        try (TXHandle txHandle = TX.required();){
            adjBillServiceHelper.saveOne(dataEntity);
            adjPersonServiceHelper.save(adjApprPersonObjs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calcAdjRangeAndAmount(DynamicObject dataEntity, EntityType entityType, Object currency) {
        String attributionType = dataEntity.getString("salaryadjrsn.attributiontype");
        QFilter permissionQFilter = DecAdjApprGridHelper.getEntryFilterQFilter((Long)dataEntity.getPkValue());
        QFilter[] qFilters = new QFilter[]{new QFilter("adjapprbill", "=", dataEntity.getPkValue()), permissionQFilter};
        DynamicObject[] adjApprPersonObjs = adjPersonServiceHelper.query(selectProperties, qFilters);
        long tableCurrency = dataEntity.getLong("currency.id");
        long excTableId = dataEntity.getLong("exctable.id");
        Date tableRateDate = dataEntity.getDate("exchangeratedate");
        BillExRateManager rateManager = new BillExRateManager();
        Map<String, IDataEntityProperty> apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap(entityType);
        Set<String> entryPropertySet = apprBillEntryPropertyMap.keySet();
        Arrays.asList(adjApprPersonObjs).forEach(personObj -> personObj.getDynamicObjectCollection("entryentity").forEach(entryObj -> {
            if (currency != null) {
                entryObj.set("currency", currency);
            }
        }));
        List<DynamicObject> adjApprPersonObjList = Arrays.asList(adjApprPersonObjs);
        List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = AdjPersonPackageHelper.getStdAmountQueryResult(adjApprPersonObjList);
        Map<String, StdAmountAndSalaryCountQueryResult> salaryCountQueryResultMap = salaryStdAmountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity(), (key1, key2) -> key1));
        for (DynamicObject personObj2 : adjApprPersonObjs) {
            DynamicObjectCollection adjPersonEntryList = personObj2.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)adjPersonEntryList)) continue;
            for (DynamicObject adjPersonEntryObj : adjPersonEntryList) {
                boolean calculateFlag = DecAdjApprGridHelper.isNeedCalculate(excTableId, tableRateDate, rateManager, adjPersonEntryObj);
                if (!calculateFlag) continue;
                String calcType = adjPersonEntryObj.getString("calctype");
                if (CalcType.GRADE_RANK.getCode().equals(calcType)) continue;
                CalculateUtils.calcWithCurExchange(tableCurrency, excTableId, tableRateDate, adjPersonEntryObj, rateManager);
            }
        }
        Map<String, SalaryCountAmountMatchResult> salaryCountAmountMatchResultMap = CalculateUtils.getSalaryCountAmountMatchResultMap(excTableId, tableRateDate, adjApprPersonObjList, rateManager);
        for (DynamicObject personObj3 : adjApprPersonObjs) {
            Long adjFileId = personObj3.getLong("adjfile.id");
            DynamicObjectCollection adjPersonEntryList = personObj3.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)adjPersonEntryList)) continue;
            for (DynamicObject adjPersonEntryObj : adjPersonEntryList) {
                boolean calculateFlag = DecAdjApprGridHelper.isNeedCalculate(excTableId, tableRateDate, rateManager, adjPersonEntryObj);
                if (calculateFlag) {
                    String calcType = adjPersonEntryObj.getString("calctype");
                    if (!CalcType.GRADE_RANK.getCode().equals(calcType)) {
                        CalculateUtils.doSetAdjCalcFieldAfter(excTableId, tableRateDate, entryPropertySet, rateManager, salaryCountAmountMatchResultMap, adjFileId, adjPersonEntryObj);
                        continue;
                    }
                    if (Objects.isNull(currency)) {
                        AdjPersonPackageHelper.doSetStdAmountRelationInfo(entryPropertySet, salaryCountQueryResultMap, adjFileId, adjPersonEntryObj);
                        AdjPersonPackageHelper.doSetFinalAmountRelationInfo(entryPropertySet, excTableId, tableRateDate, rateManager, adjPersonEntryObj);
                        AdjPersonPackageHelper.doSetActualAmountOrRatio(entryPropertySet, excTableId, tableRateDate, adjPersonEntryObj);
                        AdjPersonPackageHelper.doSetSalaryPercentAndSeepRateInfo(entryPropertySet, excTableId, tableRateDate, rateManager, salaryCountQueryResultMap, adjFileId, adjPersonEntryObj);
                        continue;
                    }
                    BigDecimal amount = adjPersonEntryObj.getBigDecimal("amount");
                    int currencyScale = adjPersonEntryObj.getInt("currency.amtprecision");
                    if (!Objects.isNull(amount)) {
                        BigDecimal exrateValue = adjPersonEntryObj.getBigDecimal("exratevalue");
                        boolean quoteType = adjPersonEntryObj.getBoolean("quotetype");
                        if (exrateValue != null && exrateValue.compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal logicAmount;
                            if (quoteType) {
                                logicAmount = amount.multiply(exrateValue).setScale(currencyScale, 4);
                                adjPersonEntryObj.set("amountlogic", (Object)logicAmount);
                            } else {
                                logicAmount = amount.divide(exrateValue, currencyScale, 4);
                                adjPersonEntryObj.set("amountlogic", (Object)logicAmount);
                            }
                        } else {
                            adjPersonEntryObj.set("amountlogic", (Object)amount);
                        }
                    } else {
                        DynamicObject coefficientDyObj = adjPersonEntryObj.getDynamicObject("coefficient");
                        BigDecimal stdAmount = adjPersonEntryObj.getBigDecimal("stdamount");
                        if (!Objects.isNull(stdAmount)) {
                            BigDecimal coefficientValue = BigDecimal.ONE;
                            if (!SWCBaseUtils.isEmpty((DynamicObject)coefficientDyObj)) {
                                coefficientValue = coefficientDyObj.getBigDecimal("coefficientvalue");
                            }
                            BigDecimal stdMulCoffAmount = coefficientValue.multiply(stdAmount);
                            adjPersonEntryObj.set("amountlogic", (Object)stdMulCoffAmount);
                        }
                    }
                    AdjPersonPackageHelper.doSetFinalAmountRelationInfo(entryPropertySet, excTableId, tableRateDate, rateManager, adjPersonEntryObj);
                    AdjPersonPackageHelper.doSetActualAmountOrRatio(entryPropertySet, excTableId, tableRateDate, adjPersonEntryObj);
                    AdjPersonPackageHelper.doSetSalaryPercentAndSeepRateInfo(entryPropertySet, excTableId, tableRateDate, rateManager, salaryCountQueryResultMap, adjFileId, adjPersonEntryObj);
                    continue;
                }
                adjPersonEntryObj.set("suggestminamount", null);
                adjPersonEntryObj.set("suggestmaxamount", null);
                adjPersonEntryObj.set("actualamount", null);
                adjPersonEntryObj.set("amount", null);
                adjPersonEntryObj.set("overstandardtype", null);
                adjPersonEntryObj.set("salarypercent", null);
                adjPersonEntryObj.set("salaryseeprate", null);
                adjPersonEntryObj.set("intervalmin", null);
                adjPersonEntryObj.set("intervalmax", null);
                adjPersonEntryObj.set("amountstdrange", null);
                adjPersonEntryObj.set("grade", null);
                adjPersonEntryObj.set("rank", null);
            }
        }
        AdjPersonPackageHelper.setOverStandardType(adjApprPersonObjList, entryPropertySet, attributionType, excTableId, tableRateDate);
        try (TXHandle txHandle = TX.required();){
            adjBillServiceHelper.saveOne(dataEntity);
            adjPersonServiceHelper.save(adjApprPersonObjs);
        }
    }

    public static Map<String, Long> getVisibleContrastAdjFields(Long adjFieldCfgId) {
        if (adjFieldCfgId == null || adjFieldCfgId == 0L) {
            return Collections.emptyMap();
        }
        DynamicObject adjFieldCfgWithPerm = ((AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class)).getAdjFieldCfgById(adjFieldCfgId);
        if (adjFieldCfgWithPerm == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection adjFieldCfgWithPermDetail = adjFieldCfgWithPerm.getDynamicObjectCollection("entryentity");
        Map<String, Long> adjDetailFieldToContrastCfg = AdjDetailFieldMappingHelper.getAdjDetailFieldToContrastCfg();
        HashMap contrastAdjFields = Maps.newHashMapWithExpectedSize((int)adjDetailFieldToContrastCfg.size());
        for (DynamicObject entry : adjFieldCfgWithPermDetail) {
            String propertyName = entry.getString("adjdetailfield.fieldnumber");
            boolean designHidden = StringUtils.equals((String)entry.getString("adjdetailfield.designhidden"), (String)"1");
            Long contrastPropConfId = adjDetailFieldToContrastCfg.get(propertyName);
            if (contrastPropConfId == null || designHidden) continue;
            contrastAdjFields.put(propertyName, contrastPropConfId);
        }
        return contrastAdjFields;
    }

    public static Map<Long, List<Long>> getContrastPropValueFromPage(DynamicObject pageEntryObj, Map<String, Long> contrastAdjFields) {
        if (pageEntryObj == null || MapUtils.isEmpty(contrastAdjFields)) {
            return Collections.emptyMap();
        }
        String prefix = "dy_";
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)contrastAdjFields.size());
        DataEntityPropertyCollection properties = pageEntryObj.getDataEntityType().getProperties();
        for (Map.Entry<String, Long> entry : contrastAdjFields.entrySet()) {
            Object val;
            List<Long> contrastPropVal;
            String fieldKey = prefix + entry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldKey);
            if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp) || (contrastPropVal = DecAdjApprGridHelper.convertToContrastPropValue(val = pageEntryObj.get(fieldKey))) == null) continue;
            resultMap.put(entry.getValue(), contrastPropVal);
        }
        return resultMap;
    }

    private static List<Long> convertToContrastPropValue(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof DynamicObject) {
            return Collections.singletonList(((DynamicObject)val).getLong("id"));
        }
        if (val instanceof DynamicObjectCollection) {
            return ((DynamicObjectCollection)val).stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        return null;
    }

    public static Map<Long, List<Long>> getContrastPropValueFromPersonObj(DynamicObject adjPersonObj, Map<String, Long> contrastAdjFields) {
        if (adjPersonObj == null || MapUtils.isEmpty(contrastAdjFields)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)contrastAdjFields.size());
        DataEntityPropertyCollection properties = adjPersonObj.getDataEntityType().getProperties();
        for (Map.Entry<String, Long> entry : contrastAdjFields.entrySet()) {
            Object val;
            List<Long> contrastPropVal;
            String fieldKey = entry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldKey);
            if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp) || (contrastPropVal = DecAdjApprGridHelper.convertToContrastPropValue(val = adjPersonObj.get(fieldKey))) == null) continue;
            resultMap.put(entry.getValue(), contrastPropVal);
        }
        return resultMap;
    }

    private static /* synthetic */ Set lambda$deleteAdjPersonEnt$25(ResultSet resultSet) throws Exception {
        HashSet<Long> result = new HashSet<Long>(16);
        while (resultSet.next()) {
            result.add(resultSet.getLong("FID"));
        }
        return result;
    }

    static {
        selectProperties = adjApprPerSelectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjapprperson");
    }
}

