/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.entity.ExRateKey;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.common.constants.DecAdjApprConstants;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;

public class DecAdjApprOpHelper {
    private static Log logger = LogFactory.getLog(DecAdjApprOpHelper.class);

    public static DynamicObjectCollection getExRateChangedRowFromDb(DynamicObject billEntity, AdjAttributionType adjAttributionType, DynamicObject[] adjApprPersonData) {
        DynamicObject[] rows = adjApprPersonData;
        BillExRateManager rateManager = new BillExRateManager();
        Date rateDate = billEntity.getDate("exchangeratedate");
        long excTableId = billEntity.getLong("exctable.id");
        DynamicObjectCollection result = new DynamicObjectCollection();
        long preCurrency = 0L;
        long currency = 0L;
        for (DynamicObject personRow : rows) {
            boolean exRateChangedOfPerson = false;
            DynamicObjectCollection adjApprEntList = personRow.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : adjApprEntList) {
                ExchangeRateInfo exrateBd;
                DynamicObject salaryStdDyObj = row.getDynamicObject("salarystd");
                if (salaryStdDyObj == null) continue;
                if (AdjAttributionType.DECATTRTYPE == adjAttributionType) {
                    preCurrency = salaryStdDyObj.getLong("currency.id");
                    currency = row.getLong("currency.id");
                } else {
                    DynamicObject preCurrencyDyObj = row.getDynamicObject("precurrency");
                    preCurrency = preCurrencyDyObj != null ? preCurrencyDyObj.getLong("id") : salaryStdDyObj.getLong("currency.id");
                    currency = row.getLong("currency.id");
                }
                if (preCurrency == currency) continue;
                BigDecimal exrateVal = row.getBigDecimal(DecAdjApprConstants.KEY_EXRATEVALUE);
                logger.info("currency is {}, preCurrency is {}, exrateVal is {}", new Object[]{currency, preCurrency, exrateVal});
                if (rateDate == null || excTableId == 0L || (exrateBd = rateManager.getExRate(new ExRateKey(currency, preCurrency, rateDate.getTime(), excTableId))) == null || exrateVal == null) continue;
                BigDecimal exchangeRate = exrateBd.getExchangeRate();
                logger.info("exrateVal is {}, quoteType is {}, exchangeRate is {}", new Object[]{exrateVal, exrateBd.getQuoteType(), exchangeRate});
                boolean diff = SalaryStdCalculateHelper.checkDifferOverCertainValue(exrateVal, exchangeRate);
                if (!diff) continue;
                exRateChangedOfPerson = true;
            }
            if (!exRateChangedOfPerson) continue;
            result.add((Object)personRow);
        }
        return result;
    }
}

