/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.Pair;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.entity.adjapprbill.GradeAndRankNameEntity;
import org.apache.commons.collections4.MapUtils;

public class GradeAndRankNameHelper {
    private static final Log logger = LogFactory.getLog(GradeAndRankNameHelper.class);

    public static GradeAndRankNameEntity getGradeAndRankNameFromAmountStdRange(List<String> amountStdRangeList) {
        HashMap<Long, List<Pair<Long, Long>>> amountStdRangeMatchMap = new HashMap<Long, List<Pair<Long, Long>>>(16);
        ArrayList<Pair<Long, Long>> amountStdRangeMatchList = new ArrayList<Pair<Long, Long>>(10);
        amountStdRangeList.forEach(amountStdRange -> {
            AmountStdRangeEntity amountStdRangeEntity = (AmountStdRangeEntity)JSON.parseObject((String)amountStdRange, AmountStdRangeEntity.class, (Feature[])new Feature[]{Feature.OrderedField});
            if (amountStdRangeEntity != null) {
                Map positionInfo = amountStdRangeEntity.getPositionInfo();
                List positionInfoOfNotUseRank = amountStdRangeEntity.getPositionInfoOfNotUseRank();
                if (MapUtils.isNotEmpty((Map)positionInfo)) {
                    positionInfo.forEach((key, value) -> {
                        List amountStdRangeRankList = amountStdRangeMatchMap.computeIfAbsent((Long)key, o1 -> Lists.newArrayList());
                        amountStdRangeRankList.addAll(value);
                    });
                }
                if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRank)) {
                    amountStdRangeMatchList.addAll(positionInfoOfNotUseRank);
                }
            }
        });
        GradeAndRankNameEntity gradeAndRankNameEntity = DecAdjApprGridHelper.getMatchGradeAndRankNameEntity(amountStdRangeMatchMap, amountStdRangeMatchList);
        return gradeAndRankNameEntity;
    }

    public static String formatGradeAndRankRangeName(String gradeAndRankRangeJsonStr, GradeAndRankNameEntity gradeAndRankNameEntity) {
        AmountStdRangeEntity amountStdRangeEntity = (AmountStdRangeEntity)JSON.parseObject((String)gradeAndRankRangeJsonStr, AmountStdRangeEntity.class, (Feature[])new Feature[]{Feature.OrderedField});
        Map amountStdRangeMap = amountStdRangeEntity.getPositionInfo();
        List positionInfoOfNotUseRank = amountStdRangeEntity.getPositionInfoOfNotUseRank();
        String amountStdRangeName = null;
        if (MapUtils.isNotEmpty((Map)amountStdRangeMap)) {
            amountStdRangeName = DecAdjApprGridHelper.buildMatchGradeAndRankRangeDisplayName(amountStdRangeMap, gradeAndRankNameEntity);
        } else if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRank)) {
            amountStdRangeName = DecAdjApprGridHelper.buildAllMatchGradeRangeName(positionInfoOfNotUseRank, gradeAndRankNameEntity);
        }
        return amountStdRangeName;
    }

    public static AmountStdRangeEntity convertMatchGradeRankRelToAmountStdRange(String matchGradeRankRel, Boolean isUseRank, GradeAndRankNameEntity gradeAndRankNameEntity) {
        AmountStdRangeEntity amountStdRangeEntity = null;
        Map<Long, List> matchRangeMap = new HashMap(16);
        try {
            matchRangeMap = (Map)JSON.parseObject((String)matchGradeRankRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            logger.error("match grade rank rel parse fail", (Throwable)e);
        }
        LinkedHashMap positionInfo = new LinkedHashMap();
        ArrayList positionInfoOfNotUseRank = new ArrayList();
        if (MapUtils.isNotEmpty(matchRangeMap)) {
            Map<Long, List> finalMatchRangeMap = matchRangeMap;
            if (isUseRank != null && isUseRank.booleanValue()) {
                matchRangeMap.forEach((key, value) -> {
                    ArrayList<Pair> rangeList = new ArrayList<Pair>();
                    List rangeDataList = (List)finalMatchRangeMap.get(key);
                    Map salaryRankIdToNameMap = gradeAndRankNameEntity.getSalaryRankIdToNameMap();
                    logger.info("swb salaryRankIdToNameMap is {}", (Object)salaryRankIdToNameMap);
                    logger.info("swb rangeDataList is {}", (Object)rangeDataList);
                    ArrayList<Pair> sortedRankIdList = new ArrayList<Pair>(10);
                    for (Long id : rangeDataList) {
                        if (salaryRankIdToNameMap.get(id) == null) continue;
                        Pair longIntegerPair = new Pair((Object)id, ((Pair)salaryRankIdToNameMap.get(id)).getKey());
                        sortedRankIdList.add(longIntegerPair);
                    }
                    sortedRankIdList.sort(Comparator.comparing(Pair::getValue));
                    for (int i = 0; i < sortedRankIdList.size(); ++i) {
                        if (i + 1 == sortedRankIdList.size()) {
                            rangeList.add(new Pair(((Pair)sortedRankIdList.get(i)).getKey(), ((Pair)sortedRankIdList.get(i)).getKey()));
                            continue;
                        }
                        if ((Integer)((Pair)sortedRankIdList.get(i)).getValue() + 1 != (Integer)((Pair)sortedRankIdList.get(i + 1)).getValue()) continue;
                        Long start = (Long)((Pair)sortedRankIdList.get(i)).getKey();
                        while (i < sortedRankIdList.size() - 1 && (Integer)((Pair)sortedRankIdList.get(i)).getValue() + 1 == (Integer)((Pair)sortedRankIdList.get(i + 1)).getValue()) {
                            ++i;
                        }
                        Long end = (Long)((Pair)sortedRankIdList.get(i)).getKey();
                        rangeList.add(new Pair((Object)start, (Object)end));
                    }
                    positionInfo.put(key, rangeList);
                });
            } else {
                matchRangeMap.forEach((key, value) -> {
                    Pair amountStdRange = new Pair(key, key);
                    positionInfoOfNotUseRank.add(amountStdRange);
                });
            }
        }
        amountStdRangeEntity = MapUtils.isNotEmpty(positionInfo) ? new AmountStdRangeEntity(positionInfo, new ArrayList()) : new AmountStdRangeEntity(new HashMap(), positionInfoOfNotUseRank);
        return amountStdRangeEntity;
    }

    public static GradeAndRankNameEntity getGradeAndRankNameFromMatchGradeRankRel(List<String> matchGradeRankRelList) {
        HashSet<Long> gradeIdSet = new HashSet<Long>(16);
        HashSet<Long> rankIdSet = new HashSet<Long>(16);
        for (String matchGradeRankRel : matchGradeRankRelList) {
            Map<Long, List<Object>> matchRangeMap = new HashMap<Long, List>(16);
            try {
                matchRangeMap = (Map)JSON.parseObject((String)matchGradeRankRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            }
            catch (Exception e) {
                logger.error("parse match rel failed", (Throwable)e);
            }
            if (!MapUtils.isNotEmpty(matchRangeMap)) continue;
            matchRangeMap.forEach((key, value) -> {
                gradeIdSet.add((Long)key);
                rankIdSet.addAll((Collection<Long>)value);
            });
        }
        Map<Object, Object> salaryGradeIdToNameMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(gradeIdSet)) {
            salaryGradeIdToNameMap = DecAdjApprGridHelper.getGradeIdToNameMap(gradeIdSet);
        }
        Map<Object, Object> salaryRankIdToNameMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(rankIdSet)) {
            salaryRankIdToNameMap = DecAdjApprGridHelper.getRankIdToNameMap(rankIdSet);
        }
        GradeAndRankNameEntity gradeAndRankNameEntity = new GradeAndRankNameEntity(salaryGradeIdToNameMap, salaryRankIdToNameMap);
        return gradeAndRankNameEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Map<Long, List<Long>>> getGradeAndRankRangeData(Map<Integer, String> personRangeMap) {
        HashMap<Integer, Map<Long, List<Long>>> matchRangeMaps = new HashMap<Integer, Map<Long, List<Long>>>(10);
        for (Map.Entry<Integer, String> matchGradeRankRelEntry : personRangeMap.entrySet()) {
            Map matchRangeMap = new HashMap(16);
            try {
                matchRangeMap = (Map)JSON.parseObject((String)matchGradeRankRelEntry.getValue(), (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            }
            catch (Exception e) {
                logger.error("parse match rel failed", (Throwable)e);
            }
            finally {
                matchRangeMaps.put(matchGradeRankRelEntry.getKey(), matchRangeMap);
            }
        }
        return matchRangeMaps;
    }
}

