/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill.adjconfirm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hsbp.common.cache.SWCPageCache;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class AdjConfirmHelper {
    private static Log log = LogFactory.getLog(AdjConfirmHelper.class);
    private static AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    private static final String APP_CACHE_KEY = "ADJCONFIRM_TOKEN";
    private static final String REGEX = "^(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_]+$)(?![a-z0-9]+$)(?![a-z\\W_]+$)(?![0-9\\W_]+$)[a-zA-Z0-9\\W_]{8,20}$";
    private static final String PRINT_FORM = "hcdm_adjconfirmperson";

    public static String formShowFormIdBySource(String modelType, String pcFormId, String mobileFromId) {
        if (AdjConfirmHelper.isPcSource(modelType)) {
            return pcFormId;
        }
        return mobileFromId;
    }

    public static boolean isPcSource(String modelType) {
        return !StringUtils.equalsIgnoreCase((String)modelType, (String)"mobile");
    }

    public static boolean checkAdjConfirmTplContent(String str) {
        HashMap<Character, Character> bracket = new HashMap<Character, Character>();
        bracket.put(Character.valueOf(']'), Character.valueOf('['));
        bracket.put(Character.valueOf('}'), Character.valueOf('{'));
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < str.length(); ++i) {
            Character temp = Character.valueOf(str.charAt(i));
            Character value = (Character)bracket.get(temp);
            if (bracket.containsValue(temp)) {
                stack.push(temp);
                continue;
            }
            if (value == null) continue;
            if (stack.isEmpty()) {
                return false;
            }
            if (stack.peek().equals(value)) {
                stack.pop();
                continue;
            }
            return false;
        }
        return stack.isEmpty();
    }

    public static void setArgToContent(IFormView formView, String variateName, String key) {
        String newContent = String.format(Locale.ROOT, "{%s}", variateName);
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(key, "insertText", new Object[]{newContent});
    }

    public static boolean checkPassword(String password) {
        Pattern pat = Pattern.compile(REGEX);
        Matcher mat = pat.matcher(password);
        return mat.matches();
    }

    public static Map<String, Object> queryBossUserInfo(IFormView formView, Long adjConfirmPersonId) {
        SWCPageCache swcPageCache = new SWCPageCache(formView);
        Map<String, Object> userInfoMap = (Map<String, Object>)swcPageCache.get(String.valueOf(adjConfirmPersonId), Map.class);
        if (MapUtils.isEmpty((Map)userInfoMap)) {
            userInfoMap = adjApprovalApplicationService.queryLogUserInfo(adjConfirmPersonId);
            swcPageCache.put(String.valueOf(adjConfirmPersonId), userInfoMap);
        }
        return userInfoMap;
    }

    private static Map<String, Object> getPrintSetting() {
        String configKey = "hcdm_adjconfirmperson_printsetting";
        long userId = RequestContext.get().getCurrUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)configKey);
        if (StringUtils.isNotBlank((String)settingData)) {
            return (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return Collections.emptyMap();
    }

    public static Long getDefaultPrinter() {
        Map<String, Object> printSetting = AdjConfirmHelper.getPrintSetting();
        if (!printSetting.isEmpty()) {
            Object printerId = printSetting.get("printerid");
            return printerId == null ? null : (Long)printerId;
        }
        return null;
    }
}

