/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill.adjconfirm;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hcdm.business.adjapplication.interfaces.dto.VerifyCodeDto;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class LoginVerifyCodeProcessor {
    private static Log LOGGER = LogFactory.getLog(LoginVerifyCodeProcessor.class);
    private static final String RANDOM_CHAR = "0123456789abcdefghjkmnopqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
    private static final String RANDOM_NUMBER = "0123456789";
    private static final String KEY_RANDOM_CHAR = "randomChar";
    private static final String KEY_RANDOM_NUMBER = "randomNumber";
    private static final String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final Random random = new SecureRandom();
    private static final String appCacheKey = "HcdmLoginVerifyCode";
    private static ISWCAppCache appCache = SWCAppCache.get((String)"HcdmLoginVerifyCode");
    private static final String ADJCONFIRM_RESETCODE_CACHE_KEY = "hcdm_resetcode_appcache";

    private static ISWCAppCache getCache() {
        return SWCAppCache.get((String)ADJCONFIRM_RESETCODE_CACHE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerifyCodeDto creatVerifyRandcode(boolean outputImage) {
        String url = "";
        VerifyCodeDto dto = new VerifyCodeDto();
        StringBuilder randomCode = new StringBuilder();
        int timeout = 60;
        if (outputImage) {
            int i1;
            BufferedImage image = new BufferedImage(100, 40, 4);
            Graphics graphics = image.getGraphics();
            graphics.fillRect(0, 0, 100, 40);
            for (i1 = 0; i1 <= 20; ++i1) {
                LoginVerifyCodeProcessor.drowLines(graphics);
            }
            for (i1 = 1; i1 <= 4; ++i1) {
                randomCode.append(LoginVerifyCodeProcessor.drowString(graphics, i1));
            }
            graphics.dispose();
            InputStream inputStream = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)image, "JPEG", os);
                inputStream = new ByteArrayInputStream(os.toByteArray());
                url = LoginVerifyCodeProcessor.uploadTempPicUrl(inputStream);
                dto.setUrl(url);
            }
            catch (Exception exc) {
                LOGGER.error("error in stream \uff1a", (Throwable)exc);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exc2) {
                        LOGGER.error("error in stream \uff1a", (Throwable)exc2);
                    }
                }
            }
        } else {
            for (int i = 1; i <= 4; ++i) {
                randomCode.append(LoginVerifyCodeProcessor.getRandCode(KEY_RANDOM_NUMBER));
            }
        }
        dto.setCode(randomCode.toString());
        dto.setCodeValidTime(TimeServiceHelper.getTimeStamp());
        LoginVerifyCodeProcessor.setCacheRandCode(dto, outputImage, timeout);
        return dto;
    }

    private static String getRandCodeName() {
        long pkId = TimeServiceHelper.getTimeStamp();
        String fullName = String.format("randcode_%s%s", pkId, ".JPEG");
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return FileNameUtils.getImageFileName((String)tenantId, (String)accountId, (String)"hcdm", (String)"LoginVerifyCodeProcessor", (Object)pkId, (String)fullName);
    }

    private static String getRandCode(String type) {
        if (type.equals(KEY_RANDOM_CHAR)) {
            return String.valueOf(RANDOM_CHAR.charAt(random.nextInt(RANDOM_CHAR.length())));
        }
        if (type.equals(KEY_RANDOM_NUMBER)) {
            return String.valueOf(RANDOM_CHAR.charAt(random.nextInt(RANDOM_NUMBER.length())));
        }
        return null;
    }

    private static void drowLines(Graphics graphics) {
        int rgb = 110 + random.nextInt(9);
        graphics.setColor(new Color(rgb, rgb, rgb));
        graphics.setFont(LoginVerifyCodeProcessor.randomFont());
        int x1 = random.nextInt(100);
        int y1 = random.nextInt(40);
        int xl = random.nextInt(30);
        int yl = random.nextInt(30);
        graphics.drawLine(x1, y1, x1 + xl, y1 + yl);
        int[] xPoints = new int[]{100, 100, 250, 250};
        int[] yPoints = new int[]{180, 150, 150, 180};
        graphics.drawPolyline(xPoints, yPoints, 4);
    }

    private static String drowString(Graphics graphics, int strIndex) {
        graphics.setFont(LoginVerifyCodeProcessor.randomFont());
        graphics.setColor(new Color(random.nextInt(101), random.nextInt(111), random.nextInt(121)));
        String rand = LoginVerifyCodeProcessor.getRandCode(KEY_RANDOM_CHAR);
        graphics.translate(random.nextInt(3), random.nextInt(3));
        graphics.drawString(rand, (18 + random.nextInt(3)) * strIndex, 18 + random.nextInt(9));
        return rand;
    }

    private static Font randomFont() {
        int index = random.nextInt(fontNames.length);
        int style = random.nextInt(4);
        int size = random.nextInt(10) + 29;
        return new Font("Arial", 3, 25);
    }

    public static String uploadTempPicUrl(InputStream inputStream) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String randCodeName = LoginVerifyCodeProcessor.getRandCodeName();
        String path = String.format("/%s/%s/%s/%s/%s", "LoginVerifyCode", dateStr, "hcdm", "adjconfirm", randCodeName);
        String uploadUrl = service.upload(new FileItem(randCodeName, path, inputStream));
        return UrlService.getAttachmentFullUrl((String)uploadUrl);
    }

    private static String getRandCodeCacheKey(boolean outputImage) {
        String cacheKey = "randcode_%s";
        if (outputImage) {
            cacheKey = "randcode_image_%s";
        }
        return String.format(Locale.ROOT, cacheKey, RequestContext.get().getGlobalSessionId());
    }

    public static VerifyCodeDto getCacheRandCode(boolean outputImage) {
        return (VerifyCodeDto)appCache.get(LoginVerifyCodeProcessor.getRandCodeCacheKey(outputImage), VerifyCodeDto.class);
    }

    private static void setCacheRandCode(VerifyCodeDto dto, boolean outputImage, int timeout) {
        appCache.put(LoginVerifyCodeProcessor.getRandCodeCacheKey(outputImage), (Object)dto, timeout);
    }

    public static void putSendSmsNum(String personId, Date date, int sendnum, int timeout) {
        String key = LoginVerifyCodeProcessor.generateKey("sendsms_num", personId, date);
        LoginVerifyCodeProcessor.getCache().put(key, (Object)sendnum, timeout);
    }

    public static int getSendSmsNum(String personId, Date date) {
        String key = LoginVerifyCodeProcessor.generateKey("sendsms_num", personId, date);
        return LoginVerifyCodeProcessor.getCache().get(key, Integer.class) == null ? 0 : (Integer)LoginVerifyCodeProcessor.getCache().get(key, Integer.class);
    }

    private static String generateKey(String prefix, String personId, Date date) {
        return String.format("%s&%s&%s", prefix, personId, date);
    }

    public static long saveVerifyCode(VerifyCodeDto dto) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjcfmverify");
        DynamicObject object = helper.generateEmptyDynamicObject();
        Date date = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        object.set("creator", (Object)currUserId);
        object.set("modifier", (Object)currUserId);
        object.set("createtime", (Object)date);
        object.set("modifytime", (Object)date);
        object.set("code", (Object)dto.getCode());
        object.set("person", (Object)dto.getPersonId());
        object.set("phone", (Object)dto.getPhone());
        object.set("businesstype", (Object)dto.getBusinessType());
        object.set("message", (Object)dto.getMessage());
        long id = DB.genLongId((String)"t_hcdm_adjcfmverify");
        object.set("id", (Object)id);
        helper.saveOne(object);
        return id;
    }

    public static void deleteVerifyCodeImage() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        VerifyCodeDto verifyCodeDto = LoginVerifyCodeProcessor.getCacheRandCode(true);
        if (verifyCodeDto != null) {
            Map map = UrlUtil.urlSplit((String)verifyCodeDto.getUrl());
            String path = (String)map.get("path");
            service.delete(path);
            appCache.remove(LoginVerifyCodeProcessor.getRandCodeCacheKey(true));
        }
    }

    public static void deleteVerifyCodeSms() {
        appCache.remove(LoginVerifyCodeProcessor.getRandCodeCacheKey(false));
    }
}

