/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill.analysis;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class AxisDataConfigHelper {
    public static DynamicObject[] queryAxisDataByCfgId(Long cfgId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_axisdataconfig");
        QFilter qFilter = new QFilter("adjsalauxdcsncfg.id", "=", (Object)cfgId);
        return helper.query("id,axis,bizitemcategory,bizitem.name,entryentity.seq,entryentity.index,entryentity.value,adjsalauxdcsncfg,name", new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryAxisDataByCfgId(List<Long> cfgIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_axisdataconfig");
        QFilter qFilter = new QFilter("adjsalauxdcsncfg.id", "in", cfgIds);
        return helper.query("id,axis,bizitemcategory,bizitem.name,entryentity.seq,entryentity.index,entryentity.value,adjsalauxdcsncfg,name", new QFilter[]{qFilter});
    }

    public static Map<Long, Map<String, DynamicObject>> queryAxisDataByCfgIds(List<Long> cfgIds) {
        DynamicObject[] query = AxisDataConfigHelper.queryAxisDataByCfgId(cfgIds);
        Map<Long, List<DynamicObject>> cfgMap = Arrays.stream(query).collect(Collectors.groupingBy(o1 -> o1.getLong("adjsalauxdcsncfg.id")));
        HashMap axisDatas = Maps.newHashMapWithExpectedSize((int)cfgMap.size());
        for (Map.Entry<Long, List<DynamicObject>> cfg : cfgMap.entrySet()) {
            List<DynamicObject> value = cfg.getValue();
            Map axis = value.stream().collect(Collectors.toMap(o1 -> o1.getString("axis"), Function.identity()));
            axisDatas.put(cfg.getKey(), axis);
        }
        return axisDatas;
    }

    public static DynamicObject queryNineGridAdjDecisionCfg(QFilter orgFilter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjdecisioncfg");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("charttype", "=", (Object)"1"));
        if (orgFilter != null) {
            qFilter.and(orgFilter);
        }
        return helper.queryOne("id,number,name", new QFilter[]{qFilter}, "createtime desc");
    }

    public static Map<String, String> getAxisBizitemCategoryMap(DynamicObject[] axisData) {
        return Arrays.stream(axisData).collect(Collectors.toMap(o1 -> o1.getString("axis"), o1 -> o1.getString("bizitemcategory.id")));
    }
}

