/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill.analysis;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemEntryHelper;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dynamic.grid.DateParamContainer;
import kd.swc.hsbp.common.dynamic.grid.DecimalFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.TextFieldParamContainer;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.collections.CollectionUtils;

public class BizDataEntryHelper {
    public static String MIN_VALUE_KEY = "minValue";
    public static String MAX_VALUE_KEY = "maxValue";
    public static final int INIT_DECIMAL_SCALE = 10;

    public static FlexPanelAp createFlexPanelAp(EntityMetadata entityMetadata, int scale) {
        List<EntryParamContainer> params = BizDataEntryHelper.createFlexBuildParam(entityMetadata, scale);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("valuepanelap");
        return EntryParamContainerBaseHelper.createControlAp((FlexPanelAp)flexPanelAp, params);
    }

    public static List<EntryParamContainer> createFlexBuildParam(EntityMetadata entityMetadata, int scale) {
        String lockState = "submit,audit";
        ArrayList allContainer = Lists.newArrayListWithCapacity((int)4);
        String valueCaption = BizItemEntryHelper.VALUE_CAPTION();
        DateParamContainer dateParamContainer = new DateParamContainer();
        dateParamContainer.setKey("bizitementdate");
        dateParamContainer.setName(valueCaption);
        dateParamContainer.setLock(lockState);
        dateParamContainer.setEntityMetadata(entityMetadata);
        allContainer.add(dateParamContainer);
        DecimalFieldParamContainer decimalParam = new DecimalFieldParamContainer();
        decimalParam.setKey("bizitementdecimal");
        decimalParam.setName(valueCaption);
        decimalParam.setEntityMetadata(entityMetadata);
        decimalParam.setLock(lockState);
        decimalParam.setScale(scale);
        decimalParam.setZeroShow(true);
        decimalParam.setPrecision(23);
        decimalParam.setEnableNull(true);
        allContainer.add(decimalParam);
        TextFieldParamContainer textParam = new TextFieldParamContainer();
        textParam.setKey("bizitementtext");
        textParam.setName(valueCaption);
        textParam.setLock(lockState);
        textParam.setEntityMetadata(entityMetadata);
        allContainer.add(textParam);
        return allContainer;
    }

    public static DynamicObject queryBizDataSource(String dataSourceNumber) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_bizdatasource");
        QFilter filter = new QFilter("number", "=", (Object)dataSourceNumber);
        return serviceHelper.queryOne(new QFilter[]{filter});
    }

    public static DynamicObject queryBizData(QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_bizdata");
        String properties = "bizitement.name";
        return helper.queryOne(properties, new QFilter[]{filter});
    }

    public static DynamicObject queryBizItemByName(String name) {
        QFilter filter = new QFilter("name", "=", (Object)name);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_bizitem");
        String properties = "isinterval, datatype, value";
        return helper.queryOne(properties, new QFilter[]{filter});
    }

    public static DynamicObject queryBizItemEntToBDById(Long id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_bizitementtobd");
        String properties = "name";
        QFilter filter = new QFilter("id", "=", (Object)id);
        return helper.queryOne(properties, new QFilter[]{filter});
    }

    public static DynamicObject queryAdjFilePerson(QFilter filter) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileperson");
        String selectProperties = "id, person";
        return serviceHelper.queryOne(selectProperties, new QFilter[]{filter});
    }

    public static DynamicObject[] queryBizdatas(Collection<Long> personIds, Collection<Long> bizitemIds, Date beginDate, Date endDate) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_bizdata");
        QFilter qFilter = new QFilter("person.id", "in", personIds);
        qFilter.and("bizitem.id", "in", bizitemIds);
        qFilter.and("status", "=", (Object)"C");
        if (null != beginDate && null != endDate) {
            qFilter.and("bizdatatime", "<=", (Object)endDate);
            qFilter.and("bizdatatime", ">=", (Object)beginDate);
        }
        return helper.query("id,person,employee,bizitemcategory,bizitem,bizitement,value,bizdatatime,createtime", new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryBizdatasByEmployee(Collection<Long> employeeIds, Collection<Long> bizitemIds, Date beginDate, Date endDate) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_bizdata");
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        qFilter.and("bizitem.id", "in", bizitemIds);
        qFilter.and("status", "=", (Object)"C");
        if (null != beginDate && null != endDate) {
            qFilter.and("bizdatatime", "<=", (Object)endDate);
            qFilter.and("bizdatatime", ">=", (Object)beginDate);
        }
        return helper.query("id,person,employee,bizitemcategory,bizitem,bizitement,value,bizdatatime,createtime", new QFilter[]{qFilter});
    }

    private static List<Map<String, BigDecimal>> convertBizItemEntryValueToBigDecimal(DataTypeEnum datatype, DynamicObject bizItemDyObj) {
        DynamicObjectCollection bizItemEntColl = bizItemDyObj.getDynamicObjectCollection("entryentity");
        ArrayList<Map<String, BigDecimal>> valueList = new ArrayList<Map<String, BigDecimal>>(bizItemEntColl.size());
        for (DynamicObject bizItemEnt : bizItemEntColl) {
            HashMap<String, BigDecimal> minMax = new HashMap<String, BigDecimal>(2);
            String valueStr = bizItemEnt.getString("value");
            switch (datatype) {
                case NUMBER: 
                case PERCENT: {
                    BigDecimal startBD = BizItemEntryHelper.stringToDecimalRange(valueStr, true);
                    BigDecimal endBD = BizItemEntryHelper.stringToDecimalRange(valueStr, false);
                    minMax.put(MIN_VALUE_KEY, startBD);
                    minMax.put(MAX_VALUE_KEY, endBD);
                    break;
                }
                case DATE: {
                    Date startDate = BizItemEntryHelper.stringToDateRange(valueStr, true);
                    Date endDate = BizItemEntryHelper.stringToDateRange(valueStr, false);
                    minMax.put(MIN_VALUE_KEY, startDate == null ? null : BigDecimal.valueOf(startDate.getTime()));
                    minMax.put(MAX_VALUE_KEY, endDate == null ? null : BigDecimal.valueOf(endDate.getTime()));
                    break;
                }
            }
            valueList.add(minMax);
        }
        return valueList;
    }

    public static boolean isBizItemMinMaxValueRange(boolean isInterval, DataTypeEnum datatype, DynamicObject bizItemDyObj, String value) {
        if (value == null) {
            return false;
        }
        List<Boolean> resultList = BizDataEntryHelper.isBizItemMinMaxValueRangeBatch(isInterval, datatype, bizItemDyObj, Collections.singletonList(value));
        return resultList.isEmpty() ? false : resultList.get(0);
    }

    public static List<Boolean> isBizItemMinMaxValueRangeBatch(boolean isInterval, DataTypeEnum datatype, DynamicObject bizItemDyObj, List<String> valueArr) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)valueArr.size());
        if (CollectionUtils.isEmpty(valueArr)) {
            return resultList;
        }
        if (isInterval) {
            List<Map<String, BigDecimal>> entryValueList = BizDataEntryHelper.convertBizItemEntryValueToBigDecimal(datatype, bizItemDyObj);
            ArrayList entryConverterList = Lists.newArrayListWithExpectedSize((int)entryValueList.size());
            for (Map<String, BigDecimal> entryValue : entryValueList) {
                BigDecimal minValue = entryValue.get(MIN_VALUE_KEY);
                BigDecimal maxValue = entryValue.get(MAX_VALUE_KEY);
                String minValueStr = minValue == null ? "" : minValue.toString();
                String maxValueStr = maxValue == null ? "" : maxValue.toString();
                String dataScope = "[" + minValueStr + "," + maxValueStr + "]";
                String scale = bizItemDyObj.getString("scale");
                entryConverterList.add(new DecimalConverter(dataScope, 23, Integer.parseInt(scale)));
            }
            for (String value : valueArr) {
                Boolean checkResult = Boolean.FALSE;
                for (DecimalConverter entryConverter : entryConverterList) {
                    ValidateResults validateResults = entryConverter.checkVal(value);
                    if (!validateResults.isSuccess()) continue;
                    checkResult = Boolean.TRUE;
                    break;
                }
                resultList.add(checkResult);
            }
        }
        return resultList;
    }

    public static String getDisplayValueOfBizDataList(DynamicObject queryValue) {
        String dbValue;
        DynamicObject bizItemDyObj = queryValue.getDynamicObject("bizitem");
        if (bizItemDyObj == null) {
            return null;
        }
        int dataType = bizItemDyObj.getInt("datatype");
        boolean isInterval = bizItemDyObj.getBoolean("isinterval");
        DataTypeEnum dataTypeEnum = DataTypeEnum.getByCode((int)dataType);
        if (dataTypeEnum == null) {
            return null;
        }
        if (isInterval) {
            dbValue = queryValue.getString("value");
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)queryValue.getLong("id"));
            DynamicObject bizDataDyObj = BizDataEntryHelper.queryBizData(qFilter);
            dbValue = bizDataDyObj.getString("bizitement.name");
        }
        return BizDataEntryHelper.dbValueToDisplaySingleValue(dataTypeEnum, dbValue);
    }

    public static String dbValueToDisplaySingleValue(DataTypeEnum dataTypeEnum, String dbValue) {
        String displayValue = dbValue;
        switch (dataTypeEnum) {
            case DATE: {
                Date date = BizItemEntryHelper.stringToDate(dbValue);
                displayValue = SWCDateTimeUtils.formatDate((Date)date);
                break;
            }
            case TEXT: {
                break;
            }
            case NUMBER: 
            case PERCENT: {
                break;
            }
        }
        return displayValue;
    }
}

