/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill.analysis;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.dynamic.grid.DateParamContainer;
import kd.swc.hsbp.common.dynamic.grid.DateRangeParamContainer;
import kd.swc.hsbp.common.dynamic.grid.DecimalFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.TextAreaFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.TextFieldParamContainer;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class BizItemEntryHelper {
    public static final List<String> ALL_ENTRY_FIELDS = Lists.newArrayList((Object[])new String[]{"decimal_min", "decimal_max", "percent_min", "percent_max", "daterange", "date", "value", "valuedescription"});
    public static final int DECIMAL_PRECISION = 23;
    public static final int DECIMAL_SCALE = 2;
    public static final String INTERVAL_SEPARATOR = "-";
    public static final BigDecimal NUMBER_INFINITY = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal NUMBER_INFINITESIMAL = BigDecimal.valueOf(Long.MIN_VALUE);

    public static String MIN_CAPTION() {
        return ResManager.loadKDString((String)"\u6700\u5c0f\u503c", (String)"BizItemEntryHelper_01", (String)"swc-hcdm-business", (Object[])new Object[0]);
    }

    public static String MAX_CAPTION() {
        return ResManager.loadKDString((String)"\u6700\u5927\u503c", (String)"BizItemEntryHelper_02", (String)"swc-hcdm-business", (Object[])new Object[0]);
    }

    public static String VALUE_CAPTION() {
        return ResManager.loadKDString((String)"\u503c", (String)"BizItemEntryHelper_03", (String)"swc-hcdm-business", (Object[])new Object[0]);
    }

    public static String[] getEntryFieldNotIn(String ... target) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ALL_ENTRY_FIELDS.size());
        for (String entryField : ALL_ENTRY_FIELDS) {
            if (ArrayUtils.contains((Object[])target, (Object)entryField)) continue;
            result.add(entryField);
        }
        return result.toArray(new String[0]);
    }

    public static EntryAp createEntryAp(EntityMetadata entityMetadata, DataTypeEnum dataTypeEnum, boolean isInterval, int scale) {
        List<EntryParamContainer> params = BizItemEntryHelper.createEntryBuildParam(entityMetadata, dataTypeEnum, isInterval, scale);
        EntryAp entryAp = EntryParamContainerBaseHelper.createEntryAp((String)"entryentity");
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setShowSeq(true);
        return EntryParamContainerBaseHelper.createControlAp((EntryAp)entryAp, params);
    }

    public static List<EntryParamContainer> createEntryBuildParam(EntityMetadata entityMetadata, DataTypeEnum dataTypeEnum, boolean isInterval, int scale) {
        String lockState = "submit,audit";
        String captionName = BizItemEntryHelper.VALUE_CAPTION();
        ArrayList allContainer = Lists.newArrayListWithCapacity((int)4);
        DateRangeParamContainer dateRangeParamContainer = new DateRangeParamContainer();
        dateRangeParamContainer.setKey("daterange");
        dateRangeParamContainer.setName(captionName);
        dateRangeParamContainer.setWidth("120px");
        dateRangeParamContainer.setStartDateFieldKey("daterange_startdate");
        dateRangeParamContainer.setEndDateFieldKey("daterange_enddate");
        dateRangeParamContainer.setLock(lockState);
        allContainer.add(dateRangeParamContainer);
        DateParamContainer dateParamContainer = new DateParamContainer();
        dateParamContainer.setKey("date");
        dateParamContainer.setName(captionName);
        dateParamContainer.setWidth("120px");
        dateParamContainer.setLock(lockState);
        allContainer.add(dateParamContainer);
        DecimalFieldParamContainer decimalMinParam = new DecimalFieldParamContainer();
        decimalMinParam.setKey("decimal_min");
        String name = BizItemEntryHelper.MIN_CAPTION();
        if (!isInterval) {
            name = captionName;
        }
        decimalMinParam.setName(name);
        decimalMinParam.setEntityMetadata(entityMetadata);
        decimalMinParam.setWidth("120px");
        decimalMinParam.setEnableNull(true);
        decimalMinParam.setZeroShow(true);
        decimalMinParam.setLock(lockState);
        decimalMinParam.setScale(scale);
        decimalMinParam.setPrecision(23);
        decimalMinParam.setTextAlign("left");
        allContainer.add(decimalMinParam);
        DecimalFieldParamContainer decimalMaxParam = new DecimalFieldParamContainer();
        decimalMaxParam.setKey("decimal_max");
        decimalMaxParam.setName(BizItemEntryHelper.MAX_CAPTION());
        decimalMaxParam.setEntityMetadata(entityMetadata);
        decimalMaxParam.setWidth("120px");
        decimalMaxParam.setZeroShow(true);
        decimalMaxParam.setEnableNull(true);
        decimalMaxParam.setLock(lockState);
        decimalMaxParam.setScale(scale);
        decimalMaxParam.setPrecision(23);
        decimalMaxParam.setTextAlign("left");
        allContainer.add(decimalMaxParam);
        DecimalFieldParamContainer percentMinParam = new DecimalFieldParamContainer();
        percentMinParam.setKey("percent_min");
        String percentName = BizItemEntryHelper.MIN_CAPTION();
        if (!isInterval) {
            percentName = captionName;
        }
        percentMinParam.setName(percentName + "(%)");
        percentMinParam.setEntityMetadata(entityMetadata);
        percentMinParam.setWidth("120px");
        percentMinParam.setEnableNull(true);
        percentMinParam.setZeroShow(true);
        percentMinParam.setLock(lockState);
        percentMinParam.setScale(scale);
        percentMinParam.setPrecision(23);
        percentMinParam.setTextAlign("left");
        allContainer.add(percentMinParam);
        DecimalFieldParamContainer percentMaxParam = new DecimalFieldParamContainer();
        percentMaxParam.setKey("percent_max");
        percentMaxParam.setName(BizItemEntryHelper.MAX_CAPTION() + "(%)");
        percentMaxParam.setEntityMetadata(entityMetadata);
        percentMaxParam.setWidth("120px");
        percentMaxParam.setZeroShow(true);
        percentMaxParam.setEnableNull(true);
        percentMaxParam.setLock(lockState);
        percentMaxParam.setScale(scale);
        percentMaxParam.setPrecision(23);
        percentMaxParam.setTextAlign("left");
        allContainer.add(percentMaxParam);
        TextAreaFieldParamContainer value = BizItemEntryHelper.createValueFieldParam(0, captionName, entityMetadata);
        allContainer.add(value);
        TextFieldParamContainer description = new TextFieldParamContainer();
        description.setDbIgnore(false);
        description.setFieldName("fdescription");
        description.setKey("valuedescription");
        description.setName(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BizItemEntryHelper_04", (String)"swc-hcdm-business", (Object[])new Object[0]));
        description.setLock("submit,audit");
        description.setEntityMetadata(entityMetadata);
        description.setWidth("120px");
        description.setLock(lockState);
        allContainer.add(description);
        return allContainer;
    }

    public static TextAreaFieldParamContainer createValueFieldParam(int dataLength, String name, EntityMetadata entityMetadata) {
        TextAreaFieldParamContainer value = new TextAreaFieldParamContainer();
        value.setDbIgnore(false);
        value.setKey("value");
        value.setFieldName("fvalue");
        value.setName(name);
        value.setFieldName("fvalue");
        value.setLock("submit,audit");
        value.setEntityMetadata(entityMetadata);
        value.setWidth("120px");
        value.setEditStyle(0);
        value.setMaxLength(dataLength == 0 ? 2000 : dataLength);
        return value;
    }

    public static String getPartOfIntervalName(String onePartFieldName, boolean start) {
        String suffix = start ? "min" : "max";
        return onePartFieldName.substring(0, onePartFieldName.lastIndexOf(95) + 1) + suffix;
    }

    public static String dateRangeToString(Date start, Date end) {
        if (start == null || end == null) {
            return "";
        }
        return String.format("%d%s%d", start.getTime(), INTERVAL_SEPARATOR, end.getTime());
    }

    public static String dateToString(Date target) {
        if (target == null) {
            return "";
        }
        return target.getTime() + "";
    }

    public static Date stringToDateRange(String value, boolean start) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return new Date(Long.parseLong(value.split(INTERVAL_SEPARATOR)[start ? 0 : 1]));
    }

    public static Date stringToDate(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return new Date(Long.parseLong(value));
    }

    public static BigDecimal stringToDecimal(String value) {
        if (StringUtils.isNotEmpty((String)value) && NumberUtils.isNumber((String)value)) {
            return new BigDecimal(value);
        }
        return null;
    }

    public static String decimalRangeToString(BigDecimal start, BigDecimal end) {
        if (start == null && end == null) {
            return "";
        }
        return String.format("%s%s%s", start == null ? "" : BizItemEntryHelper.decimalToString(start), INTERVAL_SEPARATOR, end == null ? "" : BizItemEntryHelper.decimalToString(end));
    }

    public static String decimalToString(BigDecimal target) {
        if (target == null) {
            return "";
        }
        return target.toPlainString();
    }

    public static BigDecimal stringToDecimalRange(String value, boolean start) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        String[] split = value.split(INTERVAL_SEPARATOR);
        if (value.endsWith(INTERVAL_SEPARATOR)) {
            return start ? new BigDecimal(split[0]) : null;
        }
        if (value.startsWith(INTERVAL_SEPARATOR)) {
            return start ? null : new BigDecimal(split[1]);
        }
        return start ? new BigDecimal(split[0]) : new BigDecimal(split[1]);
    }

    public static String dbValueToDisplayValue(DataTypeEnum dataTypeEnum, boolean isInterval, String dbValue) {
        String displayValue = dbValue;
        switch (dataTypeEnum) {
            case DATE: {
                if (isInterval) {
                    Date start = BizItemEntryHelper.stringToDateRange(dbValue, true);
                    Date end = BizItemEntryHelper.stringToDateRange(dbValue, false);
                    displayValue = SWCDateTimeUtils.formatDate((Date)start) + " ~ " + SWCDateTimeUtils.formatDate((Date)end);
                    break;
                }
                Date date = BizItemEntryHelper.stringToDate(dbValue);
                displayValue = SWCDateTimeUtils.formatDate((Date)date);
                break;
            }
            case TEXT: {
                break;
            }
            case NUMBER: 
            case PERCENT: {
                String suffix;
                String string = suffix = dataTypeEnum == DataTypeEnum.NUMBER ? "" : "%";
                if (!isInterval) break;
                BigDecimal start = BizItemEntryHelper.stringToDecimalRange(dbValue, true);
                BigDecimal end = BizItemEntryHelper.stringToDecimalRange(dbValue, false);
                if (start != null && end != null) {
                    displayValue = MessageFormat.format("{0}-{1}", start.toPlainString(), end.toPlainString());
                    break;
                }
                if (start != null) {
                    displayValue = MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u4ee5\u4e0a", (String)"BizItemEntryHelper_05", (String)"swc-hcdm-business", (Object[])new Object[0]), start.toPlainString(), suffix);
                    break;
                }
                if (end == null) break;
                displayValue = MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u4ee5\u4e0b", (String)"BizItemEntryHelper_06", (String)"swc-hcdm-business", (Object[])new Object[0]), end.toPlainString(), suffix);
                break;
            }
        }
        return displayValue;
    }

    public static boolean checkIntervalOverlap(String source, String target, DataTypeEnum dataType) {
        boolean isOverlap = false;
        switch (dataType) {
            case NUMBER: 
            case PERCENT: {
                BigDecimal sourceMin = BizItemEntryHelper.stringToDecimalRange(source, true);
                sourceMin = sourceMin == null ? NUMBER_INFINITESIMAL : sourceMin;
                BigDecimal sourceMax = BizItemEntryHelper.stringToDecimalRange(source, false);
                sourceMax = sourceMax == null ? NUMBER_INFINITY : sourceMax;
                BigDecimal targetMin = BizItemEntryHelper.stringToDecimalRange(target, true);
                targetMin = targetMin == null ? NUMBER_INFINITESIMAL : targetMin;
                BigDecimal targetMax = BizItemEntryHelper.stringToDecimalRange(target, false);
                targetMax = targetMax == null ? NUMBER_INFINITY : targetMax;
                isOverlap = sourceMax.compareTo(targetMin) >= 0 && sourceMin.compareTo(targetMax) <= 0 || targetMax.compareTo(sourceMin) >= 0 && targetMin.compareTo(sourceMax) <= 0;
                break;
            }
            case DATE: {
                Date sourceStart = BizItemEntryHelper.stringToDateRange(source, true);
                Date sourceEnd = BizItemEntryHelper.stringToDateRange(source, false);
                Date targetStart = BizItemEntryHelper.stringToDateRange(target, true);
                Date targetEnd = BizItemEntryHelper.stringToDateRange(target, false);
                if (sourceStart == null || sourceEnd == null || targetStart == null || targetEnd == null) break;
                isOverlap = sourceEnd.compareTo(targetStart) >= 0 && sourceStart.compareTo(targetEnd) <= 0 || targetEnd.compareTo(sourceStart) >= 0 && targetStart.compareTo(sourceEnd) <= 0;
                break;
            }
        }
        return isOverlap;
    }
}

