/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.adjapprbill.analysis;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemEntryHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.NineGridCacheHelper;
import kd.swc.hcdm.business.adjapprbill.entity.NineGridCompareEntity;
import kd.swc.hcdm.business.helper.DynamicObjectValueHelper;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.control.SWCFlexPanelAp;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class NineGridHelper {
    private static Log log = LogFactory.getLog(NineGridHelper.class);
    private static final String DELIMITER = "&";
    public static final String X_TYPE = "xtype";
    public static final String Y_TYPE = "ytype";
    private static final String FMT = "%d&%d";

    public static Map<Long, List<DynamicObject>> groupByEmployeeId(DynamicObjectCollection adjApprDetailEnt, Long standardItemId) {
        if (adjApprDetailEnt == null || adjApprDetailEnt.size() == 0 || standardItemId == null) {
            return Maps.newHashMap();
        }
        return adjApprDetailEnt.stream().filter(dy -> standardItemId.equals(dy.getLong(DecAdjApprCreateGridHelper.buildKey("standarditem.id")))).collect(Collectors.groupingBy(object -> object.getLong(DecAdjApprCreateGridHelper.buildKey("employee") + "." + "id")));
    }

    public static Map<String, String> createAxisNames(List<String> yaxis, List<String> xaxis) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < yaxis.size(); ++i) {
            for (int j = 0; j < xaxis.size(); ++j) {
                stringBuilder.append(yaxis.get(i)).append(' ').append(xaxis.get(j));
                result.put(String.valueOf(i) + String.valueOf(j), stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        return result;
    }

    public static Set<Long> collectEmployeeIds(DynamicObjectCollection adjApprDetailEnt) {
        return adjApprDetailEnt.stream().map(object -> object.getLong(DecAdjApprCreateGridHelper.buildKey("employee") + "." + "id")).collect(Collectors.toSet());
    }

    public static Map<Long, String> collectStandardItemData(DynamicObjectCollection adjApprDetailEnt) {
        LinkedHashMap itemMap = Maps.newLinkedHashMapWithExpectedSize((int)adjApprDetailEnt.size());
        for (DynamicObject dynamicObject : adjApprDetailEnt) {
            String itemName = dynamicObject.getString(DecAdjApprCreateGridHelper.buildKey("standarditem.name"));
            Long itemId = dynamicObject.getLong(DecAdjApprCreateGridHelper.buildKey("standarditem.id"));
            if (itemId <= 0L) continue;
            itemMap.putIfAbsent(itemId, itemName);
        }
        return itemMap;
    }

    public static Map<String, Map<String, String>> collectAxisTypeData(DynamicObject salaryadjscm) {
        String salaryadjscmJson = DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)salaryadjscm);
        log.info("\u8c03\u85aa\u65b9\u6848\uff1a{}", (Object)salaryadjscmJson);
        DynamicObjectCollection ninegrCol = salaryadjscm.getDynamicObjectCollection("ninegrid");
        HashMap typeMap = Maps.newHashMapWithExpectedSize((int)ninegrCol.size());
        HashMap xtypeMap = Maps.newHashMapWithExpectedSize((int)ninegrCol.size());
        HashMap ytypeMap = Maps.newHashMapWithExpectedSize((int)ninegrCol.size());
        for (DynamicObject ninegr : ninegrCol) {
            Long adjdecisioncfgId = ninegr.getLong("adjdecisioncfg.id");
            DynamicObject xtypeDyobj = ninegr.getDynamicObject("xtypeid");
            DynamicObject ytypeDyobj = ninegr.getDynamicObject("ytypeid");
            xtypeMap.put(String.format(FMT, adjdecisioncfgId, xtypeDyobj.getLong("id")), xtypeDyobj.getString("name"));
            ytypeMap.put(String.format(FMT, adjdecisioncfgId, ytypeDyobj.getLong("id")), ytypeDyobj.getString("name"));
        }
        typeMap.put(X_TYPE, xtypeMap);
        typeMap.put(Y_TYPE, ytypeMap);
        return typeMap;
    }

    public static Map<String, Multimap<String, String>> getAxisTypeMapping(DynamicObject salaryadjscm) {
        DynamicObjectCollection ninegrCol = salaryadjscm.getDynamicObjectCollection("ninegrid");
        HashMap typMultiMap = Maps.newHashMapWithExpectedSize((int)ninegrCol.size());
        ArrayListMultimap xtypeMultiMap = ArrayListMultimap.create();
        ArrayListMultimap ytypeMultiMap = ArrayListMultimap.create();
        for (DynamicObject ninegr : ninegrCol) {
            Long adjdecisioncfgId = ninegr.getLong("adjdecisioncfg.id");
            DynamicObject xtypeDyobj = ninegr.getDynamicObject("xtypeid");
            DynamicObject ytypeDyobj = ninegr.getDynamicObject("ytypeid");
            xtypeMultiMap.put((Object)String.format(FMT, adjdecisioncfgId, ytypeDyobj.getLong("id")), (Object)String.format(FMT, adjdecisioncfgId, xtypeDyobj.getLong("id")));
            ytypeMultiMap.put((Object)String.format(FMT, adjdecisioncfgId, xtypeDyobj.getLong("id")), (Object)String.format(FMT, adjdecisioncfgId, ytypeDyobj.getLong("id")));
        }
        typMultiMap.put(X_TYPE, xtypeMultiMap);
        typMultiMap.put(Y_TYPE, ytypeMultiMap);
        return typMultiMap;
    }

    public static Multimap<String, Long> getDecisionCfgIdAxisTypeMapping(DynamicObject salaryadjscm) {
        DynamicObjectCollection ninegrCol = salaryadjscm.getDynamicObjectCollection("ninegrid");
        ArrayListMultimap decisionCfgIdAxisTypeMultiMap = ArrayListMultimap.create();
        for (DynamicObject ninegr : ninegrCol) {
            Long adjdecisioncfgId = ninegr.getLong("adjdecisioncfg.id");
            long xtypeid = ninegr.getLong("xtypeid.id");
            long ytypeid = ninegr.getLong("ytypeid.id");
            Long adjdecisioncfgid = ninegr.getLong("adjdecisioncfg.id");
            decisionCfgIdAxisTypeMultiMap.put((Object)(String.format(FMT, adjdecisioncfgId, xtypeid) + "_" + String.format(FMT, adjdecisioncfgId, ytypeid)), (Object)adjdecisioncfgid);
        }
        return decisionCfgIdAxisTypeMultiMap;
    }

    public static FlexPanelAp createDynamicRankingListRangePanel(List<String> rangeData) {
        FlexPanelAp headPanelAp = new SWCFlexPanelAp.Builder("rankinglistrangepanel").build();
        for (int i = 0; i < rangeData.size(); ++i) {
            LabelAp label = ((SWCLabelAp.Builder)new SWCLabelAp.Builder("rangeLabel" + i).setName(rangeData.get(i)).setHeight(new LocaleString("18px")).setMarginRight("12px")).setLabelStyle("2").setRadius("9px").setFontSize(12).build();
            headPanelAp.getItems().add(label);
        }
        return headPanelAp;
    }

    public static Map<String, NineGridCompareEntity> getNineGridCompareEntityMap(DynamicObjectCollection detailEnt, Set<Long> bizDataEmployeeIds) {
        HashMap beComparedMap = Maps.newHashMapWithExpectedSize((int)bizDataEmployeeIds.size());
        for (DynamicObject dynamicObject : detailEnt) {
            long employeeId = dynamicObject.getLong(DecAdjApprCreateGridHelper.buildKey("employee") + "." + "id");
            long adjfileId = dynamicObject.getLong(DecAdjApprCreateGridHelper.buildKey("adjfile") + "." + "id");
            long standarditemId = dynamicObject.getLong(DecAdjApprCreateGridHelper.buildKey("standarditem.id"));
            BigDecimal currentsalary = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("presalary"), null);
            String preSalaryPercent = "";
            Object preSalaryPercentObj = DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("presalarypercent"), null);
            if (preSalaryPercentObj != null) {
                preSalaryPercent = String.valueOf(preSalaryPercentObj);
            }
            String preSalarySeePrate = "";
            Object preSalarySeePrateObj = DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("presalaryseeprate"), null);
            if (preSalarySeePrateObj != null) {
                preSalarySeePrate = String.valueOf(preSalarySeePrateObj);
            }
            String calcType = dynamicObject.getString(DecAdjApprCreateGridHelper.buildKey("calctype"));
            long adjCurrencyId = dynamicObject.getLong(DecAdjApprCreateGridHelper.buildKey("currency") + "." + "id");
            BigDecimal suggestMinrange = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("suggestminrange"), null);
            BigDecimal suggestMaxrange = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("suggestmaxrange"), null);
            BigDecimal suggestMinamount = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("suggestminamount"), null);
            BigDecimal suggestMaxamount = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("suggestmaxamount"), null);
            BigDecimal actualRange = dynamicObject.getBigDecimal(DecAdjApprCreateGridHelper.buildKey("actualrange"));
            BigDecimal actualAmount = dynamicObject.getBigDecimal(DecAdjApprCreateGridHelper.buildKey("actualamount"));
            String finalAmount = dynamicObject.getString(DecAdjApprCreateGridHelper.buildKey("amount"));
            String afterSalaryPercent = "";
            Object afterSalaryPercentObj = DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("salarypercent"), null);
            if (afterSalaryPercentObj != null) {
                afterSalaryPercent = String.valueOf(afterSalaryPercentObj);
            }
            String afterSalarySeePrate = "";
            Object afterSalarySeePrateObj = DynamicObjectValueHelper.dyObjGetValueIfExist(dynamicObject, DecAdjApprCreateGridHelper.buildKey("salaryseeprate"), null);
            if (afterSalarySeePrateObj != null) {
                afterSalarySeePrate = String.valueOf(afterSalarySeePrateObj);
            }
            String generateKey = NineGridCacheHelper.generateKey(String.valueOf(employeeId), String.valueOf(adjfileId), String.valueOf(standarditemId));
            if (!bizDataEmployeeIds.contains(employeeId)) continue;
            NineGridCompareEntity compareEntity = new NineGridCompareEntity(employeeId, adjfileId, standarditemId, currentsalary, preSalaryPercent, preSalarySeePrate, calcType, adjCurrencyId, suggestMinrange, suggestMaxrange, suggestMinamount, suggestMaxamount, actualRange, actualAmount, finalAmount, afterSalaryPercent, afterSalarySeePrate);
            beComparedMap.put(generateKey, compareEntity);
        }
        return beComparedMap;
    }

    public static int findIndex(String intervalValue, List<List<DynamicObject>> axisValues, DataTypeEnum dataTypeEnum) {
        List<DynamicObject> list;
        int i;
        if (DataTypeEnum.DATE == dataTypeEnum) {
            Date targetDate = BizItemEntryHelper.stringToDate(intervalValue);
            for (i = 0; i < axisValues.size(); ++i) {
                list = axisValues.get(i);
                for (DynamicObject dynamicObject : list) {
                    String stringDate = dynamicObject.getString("name");
                    Date startDate = BizItemEntryHelper.stringToDateRange(stringDate, true);
                    Date endDate = BizItemEntryHelper.stringToDateRange(stringDate, false);
                    if (null == startDate || null == endDate || !SWCDateTimeUtils.dayEquals((Date)startDate, (Date)targetDate) && !SWCDateTimeUtils.dayBefore((Date)startDate, (Date)targetDate) || !SWCDateTimeUtils.dayEquals((Date)endDate, (Date)targetDate) && !SWCDateTimeUtils.dayAfter((Date)endDate, (Date)targetDate)) continue;
                    return i;
                }
            }
        }
        if (DataTypeEnum.PERCENT == dataTypeEnum || DataTypeEnum.NUMBER == dataTypeEnum) {
            BigDecimal intervalVal = new BigDecimal(intervalValue);
            for (i = 0; i < axisValues.size(); ++i) {
                list = axisValues.get(i);
                for (DynamicObject dynamicObject : list) {
                    String stringVal = dynamicObject.getString("name");
                    BigDecimal startBigDecimal = BizItemEntryHelper.stringToDecimalRange(stringVal, true);
                    BigDecimal endBigDecimal = BizItemEntryHelper.stringToDecimalRange(stringVal, false);
                    if (null == startBigDecimal || null == endBigDecimal || startBigDecimal.compareTo(intervalVal) > 0 || endBigDecimal.compareTo(intervalVal) < 0) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static List<DynamicObject> removeRepeatDynamicObject(DynamicObject[] bizdatas) {
        HashMap result = Maps.newHashMap();
        for (DynamicObject bizdata : bizdatas) {
            String employeeId = bizdata.getString("employee.id");
            String bizitemId = bizdata.getString("bizitem.id");
            Date bizdatatime = bizdata.getDate("bizdatatime");
            Date createtime = bizdata.getDate("createtime");
            String key = employeeId + DELIMITER + bizitemId;
            DynamicObject dynamicObject = (DynamicObject)result.get(key);
            if (null != dynamicObject) {
                Date oldbizdatatime = dynamicObject.getDate("bizdatatime");
                Date oldcreatetime = dynamicObject.getDate("createtime");
                if (!SWCDateTimeUtils.dayBefore((Date)oldbizdatatime, (Date)bizdatatime) && (!SWCDateTimeUtils.dayEquals((Date)bizdatatime, (Date)oldbizdatatime) || !SWCDateTimeUtils.dayBefore((Date)oldcreatetime, (Date)createtime))) continue;
                result.put(key, bizdata);
                continue;
            }
            result.put(key, bizdata);
        }
        return new ArrayList<DynamicObject>(result.values());
    }

    public static Map<Long, DynamicObject> queryAdjCurrency(List<Long> currencyIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_currency");
        QFilter qFilter = new QFilter("id", "in", currencyIds);
        DynamicObject[] query = helper.query("id, name, number, amtprecision, priceprecision, sign", new QFilter[]{qFilter});
        return Arrays.stream(query).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
    }
}

