/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.calculate;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.sdk.swc.hcdm.common.stdtab.CalculationMethodEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.calculate.AbstractCalculateProcessor;
import kd.swc.hcdm.business.calculate.SalaryStdCalcContext;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.constraint.EntryFieldConstraintMapping;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import org.apache.commons.collections.CollectionUtils;

public class BroadBandCalcProcessor
extends AbstractCalculateProcessor {
    private static final BigDecimal hundred = SalaryStdCalculateHelper.HUNDRED;
    private static final BigDecimal half = SalaryStdCalculateHelper.HALF;
    private static final BigDecimal onePercent = SalaryStdCalculateHelper.ONE_PERCENT;
    private static final int round = 4;
    private static final int CALCSCALE = 10;
    private static final int SAVESCALE = 2;
    private EntryFieldConstraintMapping entryFieldConstraintMapping = new EntryFieldConstraintMapping();
    private SalaryStandardBaseEntity baseEntity;
    private Map<Long, SalaryStdItemEntity> itemEntityMap = Maps.newHashMap();
    private Map<Long, SalaryRankEntity> rankEntityMap = Maps.newHashMap();

    @Override
    protected void prevCalculate(SalaryStdCalcContext calcContext) {
        SalaryStandardEntryData allData = calcContext.getCurrentData();
        this.baseEntity = allData.getStdBaseEntity();
        this.itemEntityMap = SalaryStdItemHelper.groupById(allData.getItemEntities());
        this.rankEntityMap = GradeRankHelper.groupByRankIdentity(allData.getRankEntities());
        List<SalaryStdDataEntity> entryData = allData.getStdDataEntities();
        entryData = entryData.stream().distinct().collect(Collectors.toList());
        List usedRanks = allData.getRankEntities();
        List<Long> varItemIdentityList = SalaryStdItemHelper.fetchItemIdByVarPredictType(allData.getItemEntities(), VarPredictItemType.variable);
        List<SalaryStdDataEntity> stdDataOfVarItems = SalaryStdDataHelper.completeStdData(varItemIdentityList, allData.getGradeEntities(), usedRanks, entryData);
        entryData.addAll(stdDataOfVarItems);
        SalaryStdDataHelper.copyVarItemDataToOtherRank(entryData, varItemIdentityList, allData.getGradeEntities(), usedRanks);
        List<SalaryStdDataEntity> oldUnfixedData = SalaryStdDataHelper.getByItemIds(Collections.singleton(SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL), entryData);
        entryData.removeAll(oldUnfixedData);
        List<SalaryStdDataEntity> stdDataOfUnfixTotal = SalaryStdDataHelper.createInitStdData(Collections.singletonList(SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL), allData.getGradeEntities(), usedRanks);
        List<SalaryStdDataEntity> stdDataOfFixedTotal = SalaryStdDataHelper.completeStdData(Collections.singletonList(SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL), allData.getGradeEntities(), usedRanks, entryData);
        List<SalaryStdDataEntity> stdDataOfTotal = SalaryStdDataHelper.completeStdData(Collections.singletonList(SalaryStandardConstants.S_ITEM_TOTAL), allData.getGradeEntities(), usedRanks, entryData);
        List<Long> itemIds = SalaryStdItemHelper.fetchStandardItemIdentity(allData.getItemEntities());
        List<SalaryStdDataEntity> stdDataOfStandardItem = SalaryStdDataHelper.completeStdData(itemIds, allData.getGradeEntities(), allData.getRankEntities(), entryData);
        entryData.addAll(stdDataOfUnfixTotal);
        entryData.addAll(stdDataOfFixedTotal);
        entryData.addAll(stdDataOfTotal);
        entryData.addAll(stdDataOfStandardItem);
        allData.buildStdData(entryData);
    }

    @Override
    public void calculate(SalaryStdCalcContext calcContext) {
        SalaryStandardEntryData stdData = calcContext.getCurrentData();
        List stdDataEntities = stdData.getStdDataEntities();
        List rankList = stdData.getRankEntities();
        List gradeList = stdData.getGradeEntities();
        List<SalaryStdItemEntity> stdItems = SalaryStdItemHelper.fetchStandardItem(stdData.getItemEntities());
        Map<Long, SalaryRankEntity> rankMap = GradeRankHelper.groupByRankIdentity(rankList);
        Map<Long, SalaryGradeEntity> gradeMap = GradeRankHelper.groupByGradeIdentity(gradeList);
        List<SalaryRankEntity> sRanks = GradeRankHelper.fetchStandardRank(rankList);
        List<SalaryStdDataEntity> stdItemData = SalaryStdDataHelper.getByItemIds(stdItems.stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toSet()), stdDataEntities);
        SalaryStdDataHelper.sortByGradeIndex(stdItemData, gradeMap);
        int rankNum = sRanks.size();
        if (rankNum <= 0) {
            return;
        }
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> dataMap = SalaryStdDataHelper.groupByGradeItem(stdItemData);
        for (Map.Entry<Long, Map<Long, List<SalaryStdDataEntity>>> item : dataMap.entrySet()) {
            Long gradeId = item.getKey();
            SalaryGradeEntity salaryGradeEntity = gradeMap.get(gradeId);
            if (salaryGradeEntity == null) continue;
            int gradeIndex = salaryGradeEntity.getGradeIndex();
            SalaryGradeEntity downGrade = GradeRankHelper.getGradeByIndex(gradeIndex - 1, gradeList);
            for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : item.getValue().entrySet()) {
                Long itemId = entry.getKey();
                List<SalaryStdDataEntity> dataList = entry.getValue();
                SalaryStdDataHelper.sortByRankIndex(dataList, rankMap);
                List<SalaryStdDataEntity> downGradeItemData = downGrade != null ? dataMap.get(downGrade.getGradeIdentity()).get(itemId) : null;
                SalaryStdDataHelper.sortByRankIndex(downGradeItemData, rankMap);
                this.dispatchCalcByMethod(stdData.getStdBaseEntity().getCalcMethod(), rankNum, dataList, downGradeItemData);
            }
        }
    }

    private void dispatchCalcByMethod(CalculationMethodEnum calcMethod, int rankNum, List<SalaryStdDataEntity> dataList, List<SalaryStdDataEntity> downGradeItemData) {
        if (calcMethod == CalculationMethodEnum.GRADE_RANK) {
            this.calcWithMethod_1(rankNum, dataList, downGradeItemData);
        } else if (calcMethod == CalculationMethodEnum.MEDIAN_WIDTH) {
            this.calcWithMethod_2(rankNum, dataList, downGradeItemData);
        } else if (calcMethod == CalculationMethodEnum.MEDIAN_GEAR) {
            this.calcWithMethod_3(rankNum, dataList, downGradeItemData);
        }
    }

    private void calcWithMethod_3(int rankNum, List<SalaryStdDataEntity> dataList, List<SalaryStdDataEntity> downGradeItemData) {
        SalaryStdDataEntity middleEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), dataList).get(0);
        SalaryStdDataEntity gearDiffEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_GEARDIFFERENCE), dataList).get(0);
        List<Long> specialIds = GradeRankHelper.loadSpRankIdentityByType(SalaryStandardTypeEnum.BROADBAND);
        for (int i = 0; i < dataList.size(); ++i) {
            SalaryStdDataEntity tempData = dataList.get(i);
            if (specialIds.contains(tempData.getRankIdentity())) continue;
            tempData.setMin(BroadBandCalcProcessor.calcStdRankWithMidAndGearDiff(i, middleEnt.getMin(), gearDiffEnt.getMin(), rankNum, this.getScale(tempData, 1)));
        }
        SalaryStdDataEntity gradeWidth = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_WIDTH), dataList).get(0);
        gradeWidth.setMin(BroadBandCalcProcessor.calcWidthWithMidAndGearDiff(middleEnt.getMin(), gearDiffEnt.getMin(), rankNum, this.getScale(gradeWidth, 1)));
        SalaryStdDataEntity gradeIncr = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT), dataList).get(0);
        SalaryStdDataEntity gradeOver = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_OVERLAP), dataList).get(0);
        SalaryStdDataEntity gradeIsometric = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_ISOMETRIC), dataList).get(0);
        gradeIncr.setMin(null);
        gradeOver.setMin(null);
        gradeIsometric.setMin(null);
        if (CollectionUtils.isEmpty(downGradeItemData)) {
            return;
        }
        SalaryStdDataEntity downGradeMin = downGradeItemData.get(0);
        SalaryStdDataEntity downGradeMax = downGradeItemData.get(rankNum - 1);
        SalaryStdDataEntity downGradeMiddle = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), downGradeItemData).get(0);
        SalaryStdDataEntity downGradeIncr = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT), downGradeItemData).get(0);
        SalaryStdDataEntity downGradeOver = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_OVERLAP), downGradeItemData).get(0);
        SalaryStdDataEntity downGradeIsometric = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_ISOMETRIC), downGradeItemData).get(0);
        SalaryStdDataEntity minEnt = dataList.get(0);
        downGradeIncr.setMin(BroadBandCalcProcessor.calcIncrCoef(minEnt.getMin(), downGradeMin.getMin(), this.getScale(downGradeIncr, 1)));
        downGradeOver.setMin(this.calcOverlap(minEnt.getMin(), downGradeMin.getMin(), downGradeMax.getMin(), this.getScale(downGradeOver, 1)));
        downGradeIsometric.setMin(this.calcIsometric(middleEnt.getMin(), downGradeMiddle.getMin(), this.getScale(downGradeIsometric, 1)));
    }

    private void calcWithMethod_2(int rankNum, List<SalaryStdDataEntity> dataList, List<SalaryStdDataEntity> downGradeItemData) {
        SalaryStdDataEntity middleEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), dataList).get(0);
        SalaryStdDataEntity widthEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_WIDTH), dataList).get(0);
        SalaryStdDataEntity gearDiffEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_GEARDIFFERENCE), dataList).get(0);
        List<Long> specialIds = GradeRankHelper.loadSpRankIdentityByType(SalaryStandardTypeEnum.BROADBAND);
        gearDiffEnt.setMin(this.calcGearDiffWithMidAndWidth(middleEnt.getMin(), widthEnt.getMin(), rankNum, this.getScale(gearDiffEnt, 1)));
        for (int i = 0; i < dataList.size(); ++i) {
            SalaryStdDataEntity tempData = dataList.get(i);
            if (specialIds.contains(tempData.getRankIdentity())) continue;
            tempData.setMin(BroadBandCalcProcessor.calcStdRankWithMidAndGearDiff(i, middleEnt.getMin(), gearDiffEnt.getMin(), rankNum, this.getScale(tempData, 1)));
        }
        SalaryStdDataEntity incrEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT), dataList).get(0);
        SalaryStdDataEntity overlapEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_OVERLAP), dataList).get(0);
        SalaryStdDataEntity isometricEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_ISOMETRIC), dataList).get(0);
        incrEnt.setMin(null);
        overlapEnt.setMin(null);
        isometricEnt.setMin(null);
        if (CollectionUtils.isEmpty(downGradeItemData)) {
            return;
        }
        SalaryStdDataEntity downGradeMin = downGradeItemData.get(0);
        SalaryStdDataEntity downGradeMax = downGradeItemData.get(rankNum - 1);
        SalaryStdDataEntity minEnt = dataList.get(0);
        SalaryStdDataEntity downGradeIncrEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT), downGradeItemData).get(0);
        downGradeIncrEnt.setMin(BroadBandCalcProcessor.calcIncrCoef(minEnt.getMin(), downGradeMin.getMin(), this.getScale(downGradeIncrEnt, 1)));
        SalaryStdDataEntity downGradeOverlapEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_OVERLAP), downGradeItemData).get(0);
        downGradeOverlapEnt.setMin(this.calcOverlap(minEnt.getMin(), downGradeMin.getMin(), downGradeMax.getMin(), this.getScale(downGradeOverlapEnt, 1)));
        SalaryStdDataEntity downGradeIsometricEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_ISOMETRIC), downGradeItemData).get(0);
        SalaryStdDataEntity downGradeMiddle = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), downGradeItemData).get(0);
        downGradeIsometricEnt.setMin(this.calcIsometric(middleEnt.getMin(), downGradeMiddle.getMin(), this.getScale(downGradeIsometricEnt, 1)));
    }

    private void calcWithMethod_1(int rankNum, List<SalaryStdDataEntity> dataList, List<SalaryStdDataEntity> downGradeItemData) {
        SalaryStdDataEntity minEntity = dataList.get(0);
        SalaryStdDataEntity maxEntity = dataList.get(rankNum - 1);
        SalaryStdDataEntity midEntity = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), dataList).get(0);
        SalaryStdDataEntity gearDiffEntity = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_GEARDIFFERENCE), dataList).get(0);
        midEntity.setMin(SalaryStdDataHelper.getMiddleValueByStandardRankData(dataList.subList(0, rankNum), true));
        if (null == minEntity.getMin() || null == maxEntity.getMin()) {
            gearDiffEntity.setMin(null);
        } else {
            gearDiffEntity.setMin(this.calcGearDiffWithMaxAndMin(maxEntity.getMin(), minEntity.getMin(), rankNum, this.getScale(gearDiffEntity, 1)));
        }
        SalaryStdDataEntity widthEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_WIDTH), dataList).get(0);
        widthEnt.setMin(BroadBandCalcProcessor.calcWidthWithMidAndGearDiff(midEntity.getMin(), gearDiffEntity.getMin(), rankNum, this.getScale(widthEnt, 1)));
        SalaryStdDataEntity incrEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT), dataList).get(0);
        SalaryStdDataEntity overlapEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_OVERLAP), dataList).get(0);
        SalaryStdDataEntity isometricEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_ISOMETRIC), dataList).get(0);
        incrEnt.setMin(null);
        overlapEnt.setMin(null);
        isometricEnt.setMin(null);
        if (CollectionUtils.isEmpty(downGradeItemData)) {
            return;
        }
        SalaryStdDataEntity downGradeMin = downGradeItemData.get(0);
        SalaryStdDataEntity downGradeMax = downGradeItemData.get(rankNum - 1);
        SalaryStdDataEntity downGradeMiddle = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), downGradeItemData).get(0);
        SalaryStdDataEntity downGradeIncrEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_INCREASINGCOEFFICIENT), downGradeItemData).get(0);
        SalaryStdDataEntity downGradeOverlapEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_OVERLAP), downGradeItemData).get(0);
        SalaryStdDataEntity downGradeIsometricEnt = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_ISOMETRIC), downGradeItemData).get(0);
        downGradeIncrEnt.setMin(BroadBandCalcProcessor.calcIncrCoef(minEntity.getMin(), downGradeMin.getMin(), this.getScale(downGradeIncrEnt, 1)));
        downGradeOverlapEnt.setMin(this.calcOverlap(minEntity.getMin(), downGradeMin.getMin(), downGradeMax.getMin(), this.getScale(downGradeOverlapEnt, 1)));
        downGradeIsometricEnt.setMin(this.calcIsometric(midEntity.getMin(), downGradeMiddle.getMin(), this.getScale(downGradeIsometricEnt, 1)));
    }

    private int getScale(SalaryStdDataEntity entity, int seq) {
        DecimalConverter constraint = this.entryFieldConstraintMapping.getConstraintWithCache(this.baseEntity, this.itemEntityMap.get(entity.getItemIdentity()), this.rankEntityMap.get(entity.getRankIdentity()), seq);
        return constraint == null ? 0 : constraint.getScale();
    }

    private BigDecimal calcGearDiffWithMaxAndMin(BigDecimal max, BigDecimal min, int rankNum, int scale) {
        if (rankNum <= 1) {
            return BigDecimal.ZERO;
        }
        return max.subtract(min).divide(BigDecimal.valueOf(rankNum - 1), 10, 4).setScale(scale, 4);
    }

    private BigDecimal calcGearDiffWithMidAndWidth(BigDecimal midVal, BigDecimal widthVal, int rankNum, int scale) {
        if (null == midVal || null == widthVal) {
            return null;
        }
        if (rankNum <= 1) {
            return BigDecimal.ZERO;
        }
        widthVal = widthVal.divide(hundred, 10, 4);
        return midVal.multiply(widthVal).divide(BigDecimal.valueOf(rankNum - 1).multiply(BigDecimal.ONE.add(widthVal.divide(half, 10, 4))), 10, 4).setScale(scale, 4);
    }

    private BigDecimal calcIsometric(BigDecimal uGradeMidVal, BigDecimal midVal, int scale) {
        if (null == uGradeMidVal || null == midVal) {
            return null;
        }
        if (midVal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return uGradeMidVal.multiply(hundred).divide(midVal, 10, 4).subtract(hundred).setScale(scale, 4);
    }

    private BigDecimal calcOverlap(BigDecimal uGradeMinVal, BigDecimal minVal, BigDecimal maxVal, int scale) {
        if (null == uGradeMinVal || null == minVal || null == maxVal) {
            return null;
        }
        if (maxVal.subtract(minVal).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return maxVal.subtract(uGradeMinVal).divide(maxVal.subtract(minVal), 10, 4).multiply(hundred).setScale(scale, 4);
    }

    private static BigDecimal calcIncrCoef(BigDecimal uGradeMinVal, BigDecimal minVal, int scale) {
        if (null == uGradeMinVal || null == minVal) {
            return null;
        }
        if (minVal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return uGradeMinVal.subtract(minVal).divide(minVal, 10, 4).multiply(hundred).setScale(scale, 4);
    }

    private static BigDecimal calcWidthWithMidAndGearDiff(BigDecimal midVal, BigDecimal gearDiffVal, int rankNum, int scale) {
        if (null == midVal || null == gearDiffVal) {
            return null;
        }
        if (midVal.compareTo(BigDecimal.ZERO) == 0 || gearDiffVal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal rNum = BigDecimal.valueOf(rankNum);
        if (midVal.multiply(half).subtract(rNum.subtract(BigDecimal.ONE).multiply(gearDiffVal)).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return rNum.subtract(BigDecimal.ONE).multiply(gearDiffVal).multiply(half).divide(midVal.multiply(half).subtract(rNum.subtract(BigDecimal.ONE).multiply(gearDiffVal)), 10, 4).multiply(hundred).setScale(scale, 4);
    }

    private static BigDecimal calcStdRankWithMidAndGearDiff(int index, BigDecimal midVal, BigDecimal gearDiffVal, int rankNum, int scale) {
        if (null == midVal || null == gearDiffVal) {
            return null;
        }
        if (midVal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal rNum = BigDecimal.valueOf(rankNum);
        return midVal.subtract(rNum.subtract(BigDecimal.ONE).multiply(gearDiffVal).divide(half, 10, 4)).add(BigDecimal.valueOf(index).multiply(gearDiffVal)).setScale(scale, 4);
    }
}

