/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.calculate;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetDefaultDisplayParamEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetFieldLockStatusEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetFieldParamEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetIntervalPropEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetItemRankEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetItemTipsEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetNumberConstraintEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetOnlySalaryCountEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetPreviewStyleEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetSpecialRankEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetVarPredictItemEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.StdTableCalculateEvent;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.IntervalPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.PreviewStyleEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.swc.hcdm.business.calculate.BroadBandCalcProcessor;
import kd.swc.hcdm.business.calculate.SalaryCountCalcProcessor;
import kd.swc.hcdm.business.calculate.SalaryStdCalcContext;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.FieldLockStatusMapping;
import kd.swc.hcdm.business.salarystandard.FieldTypeHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.IntervalPropOperationFunction;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.constraint.EntryFieldConstraintMapping;
import kd.swc.hcdm.business.vo.salarystandard.FieldColumnWidthMapping;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.IntervalPropOperationKey;
import org.apache.commons.lang3.StringUtils;

public class DefaultStdTableExtPlugin
implements IStdTableExtPlugin {
    public void doCalculate(StdTableCalculateEvent evt) {
        SalaryStdCalcContext calcContext = new SalaryStdCalcContext(evt.getCurrentData(), evt.getLastData());
        SalaryStandardEntryData stdTable = evt.getCurrentData();
        SalaryStandardTypeEnum type = stdTable.getStdBaseEntity().getType();
        if (SalaryStandardTypeEnum.BROADBAND.equals((Object)type)) {
            new BroadBandCalcProcessor().doCalc(calcContext);
        } else if (SalaryStandardTypeEnum.SALARYCOUNT.equals((Object)type)) {
            new SalaryCountCalcProcessor().doCalc(calcContext);
        }
    }

    public void onGetSpecialRankList(OnGetSpecialRankEvent evt) {
        DynamicObject[] specialRank = GradeRankHelper.getDefaultSpecialRank(evt.getOriginalSpecialRankList(), evt.getType(), evt.getUseScene());
        evt.setSpecialRankList(specialRank);
    }

    public void onGetVarPredictItemList(OnGetVarPredictItemEvent evt) {
        DynamicObject[] varPredictItem = SalaryStdItemHelper.getDefaultVarPredictItem(evt.getType(), evt.getUseScene());
        evt.setVarPredictItemList(varPredictItem);
    }

    public void afterCalculate(StdTableCalculateEvent evt) {
    }

    public void onGetSalaryStdItemTips(OnGetItemTipsEvent evt) {
        if (evt.getItemEntity().getItemIdentity().equals(SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE)) {
            evt.setTips(ResManager.loadKDString((String)"\u6839\u636e\u201c\u56fa\u85aa\u5408\u8ba1/\u56fa\u85aa\u5360\u6bd4\u201d\u5f97\u51fa\u7684\u5408\u8ba1\u503c", (String)"SalaryStdGridTips_0", (String)"swc-hcdm-common", (Object[])new Object[0]));
        }
    }

    public void onGetRankListOfItem(OnGetItemRankEvent evt) {
        List<SalaryRankEntity> rankEntities;
        if (StringUtils.equals((CharSequence)evt.getUseType(), (CharSequence)"1")) {
            rankEntities = GradeRankHelper.getDefaultRanksOfItemForDisplay(evt.getStdBaseEntity(), evt.getItemEntity(), evt.getRankEntities());
            evt.setReturnDisplayRankList(rankEntities);
        }
        if (StringUtils.equals((CharSequence)evt.getUseType(), (CharSequence)"2")) {
            rankEntities = GradeRankHelper.getDefaultRanksOfItemForCalc(evt.getStdBaseEntity(), evt.getItemEntity(), evt.getRankEntities());
            evt.setReturnDisplayRankList(rankEntities);
        }
    }

    public void onGetIntervalProp(OnGetIntervalPropEvent evt) {
        if (evt.getSpecialRank() == null) {
            List<IntervalPropEntity> list = IntervalPropOperationFunction.getDefaultIntervalPropEntities(evt.getStdBaseEntity(), evt.getItemEntity(), evt.getDisplayOnlySalaryCount(), evt.getOriginalIntervalPropList());
            evt.setIntervalPropList(list);
        } else {
            evt.setIntervalPropList(IntervalPropOperationFunction.invokeFunction(evt.getOriginalIntervalPropList(), IntervalPropOperationKey.CREATESMALLESTTONEWLIST));
        }
    }

    public void onGetFieldTypeForGroupItem(OnGetFieldParamEvent evt) {
        String fieldType = FieldTypeHelper.getDefaultFieldTypeForGroupItem(evt.getType(), evt.getItemEntity(), evt.getRankEntity(), evt.getSeq());
        evt.setFieldType(fieldType);
    }

    public void onGetFieldTypeForTabular(OnGetFieldParamEvent evt) {
        String fieldType = FieldTypeHelper.getDefaultFieldTypeForTabular(evt.getType(), evt.getItemEntity(), evt.getSeq());
        evt.setFieldType(fieldType);
    }

    public void onGetFieldLockStatus(OnGetFieldLockStatusEvent evt) {
        if (evt.getGridType().equals((Object)SalaryStdGridDisplayTypeEnum.TABULAR)) {
            evt.setLockStatus(Boolean.TRUE);
        }
        if (evt.getGridType().equals((Object)SalaryStdGridDisplayTypeEnum.GROUPITEMS)) {
            Boolean status = FieldLockStatusMapping.getDefaultLockStatusOfGroup(evt.getItemEntity(), evt.getRankEntity(), evt.getSeq(), evt.getCalculationMethod());
            evt.setLockStatus(status);
        }
    }

    public void onGetFieldColumnWidth(OnGetFieldParamEvent evt) {
        String width = FieldColumnWidthMapping.getDefaultFieldColWidthForGroupItem(evt.getType(), evt.getItemEntity(), evt.getRankEntity(), evt.getSeq());
        evt.setFieldWidth(width);
    }

    public void onGetNumberConstraint(OnGetNumberConstraintEvent evt) {
        DecimalConverter converter = (DecimalConverter)EntryFieldConstraintMapping.getDefaultConverter(evt.getStdBaseEntity(), evt.getItemEntity(), evt.getRankEntity(), evt.getSeq());
        if (converter != null) {
            evt.setDataScope(converter.getDataScope());
            evt.setPrecision(converter.getPrecision());
            evt.setScale(converter.getScale());
        }
    }

    public void onGetOnlySalaryCount(OnGetOnlySalaryCountEvent evt) {
        SalaryStandardTypeEnum type = evt.getType();
        if (null == type || !SalaryStandardTypeEnum.SALARYCOUNT.equals((Object)type)) {
            evt.setDisplayOnlySalaryCount(-1);
            return;
        }
        if (evt.getIsUseSalaryCount() > 0) {
            evt.setDisplayOnlySalaryCount(2);
        } else {
            evt.setDisplayOnlySalaryCount(-1);
        }
    }

    public void onGetPreviewStyle(OnGetPreviewStyleEvent evt) {
        evt.setDefaultPrivewStyle(PreviewStyleEnum.LIST);
        evt.setNeedHiddenPrivewStyleSet((Set)Sets.newHashSet());
    }

    public void onGetDisplayParam(OnGetDefaultDisplayParamEvent evt) {
        SalaryStandardBaseEntity standardBaseEntity = evt.getStandardBaseEntity();
        SalaryStandardTypeEnum type = evt.getStandardBaseEntity().getType();
        DisplayParamNew param = new DisplayParamNew();
        if (SalaryStandardTypeEnum.SALARYCOUNT == type) {
            param = DisplayParamHelper.getDefaultParamForSalaryCount(standardBaseEntity);
        } else if (SalaryStandardTypeEnum.BROADBAND == type) {
            param = DisplayParamHelper.getDefaultParamForBroadband(standardBaseEntity);
        }
        evt.setDisplayParam(param);
    }
}

