/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.calculate;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.VarPredictItemType;
import kd.swc.hcdm.business.calculate.AbstractCalculateProcessor;
import kd.swc.hcdm.business.calculate.SalaryStdCalcContext;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;

public class SalaryCountCalcProcessor
extends AbstractCalculateProcessor {
    @Override
    protected void prevCalculate(SalaryStdCalcContext calcContext) {
        SalaryStandardEntryData allData = calcContext.getCurrentData();
        List<SalaryStdDataEntity> stdDataEntities = allData.getStdDataEntities();
        stdDataEntities = stdDataEntities.stream().distinct().collect(Collectors.toList());
        List<Long> standardItemIds = SalaryStdItemHelper.fetchStandardItemIdentity(allData.getItemEntities());
        List<SalaryStdDataEntity> stdDataOfStandard = SalaryStdDataHelper.completeStdData(standardItemIds, allData.getGradeEntities(), allData.getRankEntities(), stdDataEntities);
        stdDataEntities.addAll(stdDataOfStandard);
        List<Long> varItemIdentityList = SalaryStdItemHelper.fetchItemIdByVarPredictType(allData.getItemEntities(), VarPredictItemType.variable);
        List<SalaryStdDataEntity> stdDataOfVarItems = SalaryStdDataHelper.completeStdData(varItemIdentityList, allData.getGradeEntities(), allData.getRankEntities(), stdDataEntities);
        stdDataEntities.addAll(stdDataOfVarItems);
        SalaryStdDataHelper.copyVarItemDataToOtherRank(stdDataEntities, varItemIdentityList, allData.getGradeEntities(), allData.getRankEntities());
        List<SalaryStdDataEntity> notUseRankItemDataOfOtherRank = SalaryStdDataHelper.copyNotUseRankItemDataToOtherRank(stdDataEntities, allData.getGradeEntities(), allData.getRankEntities(), allData.getItemEntities());
        if (!CollectionUtils.isEmpty(notUseRankItemDataOfOtherRank)) {
            Set<Long> itemIds = SalaryStdItemHelper.getNotUseRankSalaryItemIds(allData.getItemEntities());
            List<SalaryStdDataEntity> oldNotUseRankItemList = SalaryStdDataHelper.getByItemIds(itemIds, stdDataEntities);
            stdDataEntities.removeAll(oldNotUseRankItemList);
        }
        List<SalaryStdDataEntity> oldUnfixedData = SalaryStdDataHelper.getByItemIds(Collections.singleton(SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL), stdDataEntities);
        stdDataEntities.removeAll(oldUnfixedData);
        List<SalaryStdDataEntity> stdDataOfUnfixTotal = SalaryStdDataHelper.createInitStdData(Collections.singletonList(SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL), allData.getGradeEntities(), allData.getRankEntities());
        List<SalaryStdDataEntity> stdDataOfTotal = SalaryStdDataHelper.completeStdData(Collections.singletonList(SalaryStandardConstants.S_ITEM_TOTAL), allData.getGradeEntities(), allData.getRankEntities(), stdDataEntities);
        List<SalaryStdDataEntity> stdDataOfFixedTotal = SalaryStdDataHelper.completeStdData(Collections.singletonList(SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL), allData.getGradeEntities(), allData.getRankEntities(), stdDataEntities);
        stdDataEntities.addAll(stdDataOfVarItems);
        stdDataEntities.addAll(notUseRankItemDataOfOtherRank);
        stdDataEntities.addAll(stdDataOfUnfixTotal);
        stdDataEntities.addAll(stdDataOfTotal);
        stdDataEntities.addAll(stdDataOfFixedTotal);
        allData.buildStdData(stdDataEntities);
    }

    @Override
    public void calculate(SalaryStdCalcContext calcContext) {
        int amountScale;
        SalaryStandardEntryData stdData = calcContext.getCurrentData();
        int n = amountScale = stdData.getStdBaseEntity().getCurrencyEntity() == null ? 2 : stdData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
        if (CollectionUtils.isEmpty((Collection)stdData.getStdDataEntities()) || CollectionUtils.isEmpty((Collection)stdData.getItemEntities())) {
            return;
        }
        Map<Long, List<SalaryStdDataEntity>> itemDataMap = SalaryStdDataHelper.groupByItem(stdData.getStdDataEntities());
        List<SalaryStdItemEntity> salaryStdItemEntities = SalaryStdItemHelper.fetchStandardItem(stdData.getItemEntities());
        Map<Long, SalaryStdItemEntity> itemEntityMap = SalaryStdItemHelper.groupById(salaryStdItemEntities);
        for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : itemDataMap.entrySet()) {
            Long itemIdentity = entry.getKey();
            List<SalaryStdDataEntity> itemDatas = entry.getValue();
            SalaryStdItemEntity salaryStdItemEntity = itemEntityMap.get(itemIdentity);
            boolean isUseSalaryCount = salaryStdItemEntity != null && salaryStdItemEntity.getItemIsUseSalaryCount() > 0;
            SalaryStdCalculateHelper.calcValueBySalaryCount(itemDatas, stdData.getStdBaseEntity().getSalaryCountAmount(), amountScale, isUseSalaryCount);
        }
    }
}

