/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.calculate;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.StdTableCalculateEvent;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.IntervalPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.calculate.DefaultStdTableExtPlugin;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.IntervalPropOperationFunction;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.constraint.EntryFieldConstraintMapping;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SalaryStdCalculateHelper {
    public static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    public static final BigDecimal HALF = BigDecimal.valueOf(2L);
    public static final int ROUND = 4;
    public static final BigDecimal ONE_PERCENT = BigDecimal.valueOf(0.01);
    public static final int CALC_SCALE = 10;
    public static final int SAVE_SCALE = 2;
    public static final int SAVE_SCALE_1 = 4;

    public static BigDecimal doCalcValueBySalaryCount(BigDecimal salaryCount, BigDecimal salaryCountUnitAmount, int amountScale) {
        if (null == salaryCount || null == salaryCountUnitAmount) {
            return null;
        }
        return salaryCount.multiply(salaryCountUnitAmount).setScale(amountScale, 4);
    }

    public static void calcValueBySalaryCount(List<SalaryStdDataEntity> stdDataEntities, BigDecimal salaryCountUnitAmount, int amountScale, boolean useSalaryCount) {
        for (SalaryStdDataEntity stdDataEntity : stdDataEntities) {
            BigDecimal salaryCount = stdDataEntity.getSalaryCount();
            if (!useSalaryCount) continue;
            if (salaryCount == null) {
                stdDataEntity.setMin(null);
                continue;
            }
            stdDataEntity.setMin(SalaryStdCalculateHelper.doCalcValueBySalaryCount(salaryCount, salaryCountUnitAmount, amountScale));
        }
    }

    public static void calcSalaryItemTotal(SalaryStandardEntryData allData, Long specialItemIdentity) {
        List stdDataEntities = allData.getStdDataEntities();
        SalaryStandardBaseEntity baseEntity = allData.getStdBaseEntity();
        List itemEntities = allData.getItemEntities();
        List rankEntities = allData.getRankEntities();
        List gradeEntities = allData.getGradeEntities();
        DisplayParamNew displayParam = allData.getDisplayParam();
        List intervalPropEntities = allData.getPropEntities();
        List<Long> itemIdentitys = Collections.singletonList(specialItemIdentity);
        List<SalaryStdItemEntity> itemBySpecialIdentity = SalaryStdItemHelper.getItemBySpecialIdentity(itemEntities, false, itemIdentitys);
        SalaryStdItemEntity labelItem = null;
        if (CollectionUtils.isNotEmpty(itemBySpecialIdentity)) {
            labelItem = itemBySpecialIdentity.get(0);
        }
        if (labelItem == null) {
            labelItem = SalaryStdItemHelper.generateVirtualItem(baseEntity.getType(), specialItemIdentity);
        }
        List<SalaryStdItemEntity> calcItems = SalaryStdItemHelper.getCalcStdItemBySpecialIdentity(itemEntities, specialItemIdentity);
        List<SalaryStdDataEntity> labelItemStdData = SalaryStdDataHelper.getByItemIds(Collections.singleton(labelItem.getItemIdentity()), stdDataEntities);
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> labelItemStdDataMap = SalaryStdDataHelper.groupByGradeAndRank(labelItemStdData);
        Set<Long> calcItemIds = calcItems.stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toSet());
        List<SalaryStdDataEntity> calcItemStdData = SalaryStdDataHelper.getByItemIds(calcItemIds, stdDataEntities);
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> calcItemDataMap = SalaryStdDataHelper.groupByGradeAndRank(calcItemStdData);
        List<SalaryRankEntity> rankListOfCurItem = GradeRankHelper.getInstance().getCalcRankOfItemWithExt(baseEntity, labelItem, rankEntities);
        List<IntervalPropEntity> intervalProps = IntervalPropOperationFunction.getInstance().getIntervalPropWithExtForStdRank(baseEntity, labelItem, displayParam.getDisplayOnlySalaryCount(), intervalPropEntities);
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            for (SalaryRankEntity rankEntity : rankListOfCurItem) {
                Map<Long, List<SalaryStdDataEntity>> oneGradeLabelItemData = labelItemStdDataMap.get(gradeEntity.getGradeIdentity());
                if (MapUtils.isEmpty(oneGradeLabelItemData) || CollectionUtils.isEmpty((Collection)oneGradeLabelItemData.get(rankEntity.getRankIdentity()))) continue;
                if (MapUtils.isEmpty(calcItemDataMap)) {
                    SalaryStdDataEntity tempLabelItemData = oneGradeLabelItemData.get(rankEntity.getRankIdentity()).get(0);
                    for (IntervalPropEntity intervalProp : intervalProps) {
                        tempLabelItemData.setValueBySeq(BigDecimal.ZERO, intervalProp.getIntervalPropIndex());
                    }
                    continue;
                }
                List<SalaryStdDataEntity> tempCalcItemData = calcItemDataMap.get(gradeEntity.getGradeIdentity()).get(rankEntity.getRankIdentity());
                List<SalaryStdDataEntity> list = tempCalcItemData = CollectionUtils.isEmpty(tempCalcItemData) ? calcItemDataMap.get(gradeEntity.getGradeIdentity()).get(rankListOfCurItem.get(0)) : tempCalcItemData;
                if (CollectionUtils.isEmpty(tempCalcItemData)) continue;
                SalaryStdDataEntity tempLabelItemData = oneGradeLabelItemData.get(rankEntity.getRankIdentity()).get(0);
                for (IntervalPropEntity intervalProp : intervalProps) {
                    BigDecimal sum = SalaryStdCalculateHelper.sum(tempCalcItemData, intervalProp);
                    tempLabelItemData.setValueBySeq(sum, intervalProp.getIntervalPropIndex());
                }
            }
        }
    }

    private static BigDecimal sum(List<SalaryStdDataEntity> tempCalcItemData, IntervalPropEntity intervalProp) {
        BigDecimal sum = BigDecimal.ZERO;
        for (SalaryStdDataEntity salaryStdDataEntity : tempCalcItemData) {
            BigDecimal valueBySeq = salaryStdDataEntity.getValueBySeq(intervalProp.getIntervalPropIndex());
            if (null == valueBySeq) {
                return null;
            }
            sum = sum.add(valueBySeq);
        }
        return sum;
    }

    public static void calcTotalOrFixRatio(SalaryStandardEntryData allData, SalaryStandardEntryData lastCalcResultData) {
        List stdDataEntities = allData.getStdDataEntities();
        SalaryStandardBaseEntity baseEntity = allData.getStdBaseEntity();
        List itemEntities = allData.getItemEntities();
        boolean existFixScale = false;
        boolean existTotal = false;
        SalaryStdItemEntity fixScaleItem = null;
        for (SalaryStdItemEntity itemEntity : itemEntities) {
            if (itemEntity.getItemIdentity().equals(SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE)) {
                existFixScale = true;
                fixScaleItem = itemEntity;
            }
            if (!itemEntity.getItemIdentity().equals(SalaryStandardConstants.S_ITEM_TOTAL)) continue;
            existTotal = true;
        }
        if (!existFixScale || !existTotal) {
            return;
        }
        List rankEntities = allData.getRankEntities();
        List gradeEntities = allData.getGradeEntities();
        List<SalaryStdDataEntity> totalItemStdData = SalaryStdDataHelper.getByItemIds(Collections.singleton(SalaryStandardConstants.S_ITEM_TOTAL), stdDataEntities);
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> totalItemDataMap = SalaryStdDataHelper.groupByGradeAndRank(totalItemStdData);
        List<SalaryStdDataEntity> fixedSsData = SalaryStdDataHelper.getByItemIds(Collections.singleton(SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE), stdDataEntities);
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> fixedSsDataMap = SalaryStdDataHelper.groupByGradeAndRank(fixedSsData);
        List<SalaryStdDataEntity> fixedTotalItemStdData = SalaryStdDataHelper.getByItemIds(Collections.singleton(SalaryStandardConstants.S_ITEM_FIXEDSALARYTOTAL), stdDataEntities);
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> fixedTotalMap = SalaryStdDataHelper.groupByGradeAndRank(fixedTotalItemStdData);
        List<SalaryStdDataEntity> unfixedTotalItemStdData = SalaryStdDataHelper.getByItemIds(Collections.singleton(SalaryStandardConstants.S_ITEM_UNFIXEDSALARYTOTAL), stdDataEntities);
        Map<Long, Map<Long, List<SalaryStdDataEntity>>> unfixedTotalMap = SalaryStdDataHelper.groupByGradeAndRank(unfixedTotalItemStdData);
        SalaryStdItemEntity totalItem = SalaryStdItemHelper.getItemBySpecialIdentity(itemEntities, false, Collections.singletonList(SalaryStandardConstants.S_ITEM_TOTAL)).get(0);
        List<SalaryStdItemEntity> unfixedTotalItems = SalaryStdItemHelper.getItemByFixedState(itemEntities, 0);
        List<SalaryRankEntity> rankOfTotalItem = GradeRankHelper.getInstance().getCalcRankOfItemWithExt(baseEntity, totalItem, rankEntities);
        SalaryRankEntity minStandardRank = GradeRankHelper.getMinStandardRank(rankEntities);
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardAndSpecialRank(rankEntities, Collections.emptyList());
        Map<Long, Boolean> dataChangedFlagsByStandard = SalaryStdCalculateHelper.isStdItemDataChanged(allData, lastCalcResultData, SalaryItemLabelEnum.STANDARD, Collections.emptyList());
        Map<Long, Boolean> dataChangedFlagsByFs = SalaryStdCalculateHelper.isStdItemDataChanged(allData, lastCalcResultData, SalaryItemLabelEnum.SPECIAL, Collections.singletonList(SalaryStandardConstants.S_ITEM_FIXEDSALARYSCALE));
        int amountScale = baseEntity.getCurrencyEntity() == null ? 2 : baseEntity.getCurrencyEntity().getAmtPrecision();
        EntryFieldConstraintMapping constraintMapping = new EntryFieldConstraintMapping();
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            Long currentGradeIdentity = gradeEntity.getGradeIdentity();
            Map<Long, List<SalaryStdDataEntity>> tempGradeFixedTotal = fixedTotalMap.get(currentGradeIdentity);
            Map<Long, List<SalaryStdDataEntity>> tempGradeFixedScale = fixedSsDataMap.get(currentGradeIdentity);
            Map<Long, List<SalaryStdDataEntity>> tempGradeUnFixedTotal = unfixedTotalMap.get(currentGradeIdentity);
            Map<Long, List<SalaryStdDataEntity>> tempGradeTotal = totalItemDataMap.get(currentGradeIdentity);
            if (MapUtils.isEmpty(tempGradeFixedTotal) || MapUtils.isEmpty(tempGradeFixedScale) || MapUtils.isEmpty(tempGradeUnFixedTotal) || MapUtils.isEmpty(tempGradeTotal)) continue;
            Boolean dataChanged = dataChangedFlagsByStandard.getOrDefault(currentGradeIdentity, Boolean.FALSE);
            Boolean dataChangedByFs = dataChangedFlagsByFs.getOrDefault(currentGradeIdentity, Boolean.FALSE);
            if (!dataChanged.booleanValue() && !dataChangedByFs.booleanValue()) continue;
            for (SalaryRankEntity rankEntity : rankOfTotalItem) {
                Long currentRankIdentity = rankEntity.getRankIdentity();
                SalaryStdDataEntity curTotal = tempGradeTotal.get(currentRankIdentity).get(0);
                List<SalaryStdDataEntity> curFixedScaleEntities = tempGradeFixedScale.get(currentRankIdentity);
                List<SalaryStdDataEntity> curFixedTotalEntities = tempGradeFixedTotal.get(currentRankIdentity);
                List<SalaryStdDataEntity> curUnFixedTotalEntities = tempGradeUnFixedTotal.get(currentRankIdentity);
                if (CollectionUtils.isEmpty(curFixedScaleEntities) || CollectionUtils.isEmpty(curFixedTotalEntities) || CollectionUtils.isEmpty(curUnFixedTotalEntities)) {
                    curTotal.setMin(null);
                    continue;
                }
                SalaryStdDataEntity curFixedScale = curFixedScaleEntities.get(0);
                SalaryStdDataEntity curFixedTotal = curFixedTotalEntities.get(0);
                SalaryStdDataEntity curUnFixedTotal = curUnFixedTotalEntities.get(0);
                if (null == curFixedTotal.getMin()) {
                    curTotal.setMin(null);
                    continue;
                }
                if (curFixedScale.getMin() != null && !dataChanged.booleanValue()) {
                    if (curFixedScale.getMin().compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal scale = curFixedScale.getMin().multiply(ONE_PERCENT);
                        curTotal.setMin(curFixedTotal.getMin().divide(scale, amountScale, 4));
                        continue;
                    }
                    curTotal.setMin(BigDecimal.ZERO);
                    continue;
                }
                if (null != curUnFixedTotal.getMin()) {
                    curTotal.setMin(curFixedTotal.getMin().add(curUnFixedTotal.getMin()));
                    continue;
                }
                if (CollectionUtils.isEmpty(unfixedTotalItems)) {
                    curTotal.setMin(curFixedTotal.getMin());
                    continue;
                }
                curTotal.setMin(null);
            }
            BigDecimal allRankSumOfTotal = SalaryStdCalculateHelper.calcSum(tempGradeTotal, standardRanks);
            BigDecimal allRankSumOfFixedTotal = SalaryStdCalculateHelper.calcSum(tempGradeFixedTotal, standardRanks);
            for (SalaryRankEntity tempRank : rankOfTotalItem) {
                SalaryStdDataEntity tempRankFixedScale;
                List<SalaryStdDataEntity> tempRankFixedScaleEntities = tempGradeFixedScale.get(tempRank.getRankIdentity());
                if (null == allRankSumOfTotal || null == allRankSumOfFixedTotal || CollectionUtils.isEmpty(tempRankFixedScaleEntities) || null != (tempRankFixedScale = tempGradeFixedScale.get(tempRank.getRankIdentity()).get(0)).getMin() && !dataChanged.booleanValue()) continue;
                if (allRankSumOfTotal.compareTo(BigDecimal.ZERO) == 0) {
                    tempRankFixedScale.setMin(BigDecimal.ZERO);
                    continue;
                }
                DecimalConverter constraint = constraintMapping.getConstraintWithCache(baseEntity, fixScaleItem, tempRank, 1);
                tempRankFixedScale.setMin(allRankSumOfFixedTotal.divide(allRankSumOfTotal, 10, 4).multiply(BigDecimal.valueOf(100L)).setScale(constraint.getScale(), 4));
            }
        }
    }

    @Deprecated
    public static BigDecimal calcSalaryRatio(BigDecimal amount, BigDecimal min, BigDecimal max, BigDecimal coefficientValue) {
        if (amount == null || min == null || max == null) {
            return null;
        }
        BigDecimal mid = max.add(min).divide(HALF, 4);
        if (mid.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return amount.divide(mid.multiply(coefficientValue), 10, 4).setScale(4, 4);
    }

    public static BigDecimal calcSalaryRatioNew(BigDecimal amount, BigDecimal middleVal, BigDecimal coefficientValue) {
        if (amount == null || middleVal == null) {
            return null;
        }
        if (middleVal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return amount.divide(middleVal.multiply(coefficientValue), 10, 4).setScale(4, 4);
    }

    public static BigDecimal calcSalaryPermeability(BigDecimal amount, BigDecimal min, BigDecimal max, BigDecimal coefficientValue) {
        if (amount == null || min == null || max == null) {
            return null;
        }
        BigDecimal interval = max.multiply(coefficientValue).subtract(min.multiply(coefficientValue));
        if (interval.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return amount.subtract(min.multiply(coefficientValue)).divide(interval, 10, 4).setScale(4, 4);
    }

    @Deprecated
    public static BigDecimal calcSalaryPermeability(BigDecimal amount, BigDecimal min, BigDecimal max) {
        if (amount == null || min == null || max == null) {
            return null;
        }
        BigDecimal interval = max.subtract(min);
        if (interval.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        return amount.subtract(min).divide(interval, 10, 4).multiply(HUNDRED).setScale(2, 4);
    }

    public static BigDecimal calcSalaryActualRange(BigDecimal actualAmount, BigDecimal finalAmount) {
        if (actualAmount == null || finalAmount == null) {
            return null;
        }
        BigDecimal interval = finalAmount.subtract(actualAmount);
        if (interval.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return actualAmount.multiply(HUNDRED).divide(interval, 10, 4).setScale(2, 4);
    }

    public static BigDecimal calcAmountWithRange(BigDecimal source, BigDecimal range) {
        if (null == range || source == null) {
            return null;
        }
        if (range.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return source.multiply(range.multiply(ONE_PERCENT));
    }

    public static boolean checkDifferOverCertainValue(BigDecimal source, BigDecimal target) {
        source = source == null ? BigDecimal.ZERO : source;
        target = target == null ? BigDecimal.ZERO : target;
        return source.compareTo(target) != 0;
    }

    public static BigDecimal calcRangeWithAmount(BigDecimal source, BigDecimal result) {
        if (null == result || source == null) {
            return null;
        }
        if (source.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return result.divide(source, 10, 4).multiply(HUNDRED).setScale(2, 4);
    }

    private static BigDecimal calcSum(Map<Long, List<SalaryStdDataEntity>> rankToDataMap, List<SalaryRankEntity> standardRanks) {
        BigDecimal sum = BigDecimal.ZERO;
        for (SalaryRankEntity rank : standardRanks) {
            List<SalaryStdDataEntity> entities = rankToDataMap.get(rank.getRankIdentity());
            SalaryStdDataEntity entity = entities.get(0);
            if (null == entity.getMin()) {
                return null;
            }
            sum = sum.add(entity.getMin());
        }
        return sum;
    }

    public static Map<Long, Boolean> isStdItemDataChanged(SalaryStandardEntryData currentData, SalaryStandardEntryData lastCalcResultData, SalaryItemLabelEnum salaryItemLabelEnum, List<Long> specialItemIdentitys) {
        List gradeEntities = currentData.getGradeEntities();
        HashMap result = Maps.newHashMapWithExpectedSize((int)gradeEntities.size());
        for (SalaryGradeEntity grade : gradeEntities) {
            result.put(grade.getGradeIdentity(), Boolean.FALSE);
        }
        if (null == lastCalcResultData) {
            SalaryStdCalculateHelper.reverseTo(result, Boolean.TRUE);
            return result;
        }
        if (currentData.getGradeEntities().size() != lastCalcResultData.getGradeEntities().size() || currentData.getRankEntities().size() != lastCalcResultData.getRankEntities().size()) {
            SalaryStdCalculateHelper.reverseTo(result, Boolean.TRUE);
            return result;
        }
        boolean itemChanged = SalaryStdItemHelper.isChanged(currentData.getItemEntities(), lastCalcResultData.getItemEntities());
        if (itemChanged) {
            SalaryStdCalculateHelper.reverseTo(result, Boolean.TRUE);
            return result;
        }
        Map<Long, Map<Long, Map<Long, SalaryStdDataEntity>>> currDataMap = SalaryStdDataHelper.groupByGradeItemRank(currentData.getStdDataEntities());
        Map<Long, Map<Long, Map<Long, SalaryStdDataEntity>>> lastCalcDataMap = SalaryStdDataHelper.groupByGradeItemRank(lastCalcResultData.getStdDataEntities());
        List<SalaryStdItemEntity> items = null;
        items = salaryItemLabelEnum.equals((Object)SalaryItemLabelEnum.STANDARD) ? SalaryStdItemHelper.getItemBySpecialIdentity(currentData.getItemEntities(), true, Collections.emptyList()) : SalaryStdItemHelper.getItemBySpecialIdentity(currentData.getItemEntities(), false, specialItemIdentitys);
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardAndSpecialRank(currentData.getRankEntities(), Collections.emptyList());
        block1: for (SalaryGradeEntity gradeEntity : currentData.getGradeEntities()) {
            Boolean isChanged;
            Long gradeId = gradeEntity.getGradeIdentity();
            Map<Long, Map<Long, SalaryStdDataEntity>> itemMap = currDataMap.get(gradeId);
            Map<Long, Map<Long, SalaryStdDataEntity>> lastItemMap = lastCalcDataMap.get(gradeId);
            if (lastItemMap == null) {
                isChanged = Boolean.TRUE;
                result.put(gradeId, isChanged);
                continue;
            }
            for (SalaryStdItemEntity itemEntity : items) {
                Map<Long, SalaryStdDataEntity> rankMap = itemMap.get(itemEntity.getItemIdentity());
                Map<Long, SalaryStdDataEntity> lastRankMap = lastItemMap.get(itemEntity.getItemIdentity());
                if (lastRankMap == null) {
                    isChanged = Boolean.TRUE;
                    result.put(gradeId, isChanged);
                    continue block1;
                }
                for (SalaryRankEntity rankEntity : standardRanks) {
                    SalaryStdDataEntity curData = rankMap.get(rankEntity.getRankIdentity());
                    SalaryStdDataEntity lastData = lastRankMap.get(rankEntity.getRankIdentity());
                    BigDecimal curDataMin = null;
                    if (curData != null) {
                        curDataMin = curData.getMin();
                    }
                    if (!(lastData == null || ObjectUtils.notEqual((Object)curData, (Object)lastData) || null == curDataMin && null != lastData.getMin() || null != curDataMin && null == lastData.getMin()) && (null == curDataMin || null == lastData.getMin() || curDataMin.compareTo(lastData.getMin()) == 0)) continue;
                    isChanged = Boolean.TRUE;
                    result.put(gradeId, isChanged);
                    continue block1;
                }
            }
        }
        return result;
    }

    private static void reverseTo(Map<Long, Boolean> result, Boolean flag) {
        for (Map.Entry<Long, Boolean> entry : result.entrySet()) {
            entry.setValue(flag);
        }
    }

    public static void calculate(IFormView form, SalaryStandardEntryData current, SalaryStandardEntryData last) {
        StdTableCalculateEvent evt = new StdTableCalculateEvent((Object)form);
        evt.setCurrentData(current);
        evt.setLastData(last);
        DefaultStdTableExtPlugin defaultPlugin = new DefaultStdTableExtPlugin();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)defaultPlugin, IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#doCalculate", null);
        proxy.callReplaceIfPresent(plugin -> {
            plugin.doCalculate(evt);
            return null;
        });
        HRPluginProxy proxyAfter = HRPlugInProxyFactory.create((Object)defaultPlugin, IStdTableExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IStdTableExtPlugin#afterCalculate", null);
        proxyAfter.callAfter(plugin -> {
            plugin.afterCalculate(evt);
            return null;
        });
    }

    @Deprecated
    public static BigDecimal calcSalaryRatio(BigDecimal amount, BigDecimal min, BigDecimal max) {
        if (amount == null || min == null || max == null) {
            return null;
        }
        BigDecimal mid = max.add(min).divide(HALF, 4);
        if (mid.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return amount.divide(mid, 10, 4).multiply(HUNDRED);
    }

    public static void resetPrecision(SalaryStandardEntryData entryData) {
        EntryFieldConstraintMapping mapping = new EntryFieldConstraintMapping();
        if (CollectionUtils.isNotEmpty((Collection)entryData.getStdDataEntities()) && CollectionUtils.isNotEmpty((Collection)entryData.getItemEntities()) && CollectionUtils.isNotEmpty((Collection)entryData.getRankEntities())) {
            SalaryStandardBaseEntity baseEntity = entryData.getStdBaseEntity();
            Map<Long, SalaryStdItemEntity> itemMap = SalaryStdItemHelper.groupById(entryData.getItemEntities());
            Map<Long, SalaryRankEntity> rankMap = GradeRankHelper.groupByRankIdentity(entryData.getRankEntities());
            for (SalaryStdDataEntity data : entryData.getStdDataEntities()) {
                DecimalConverter constraint;
                if (data.getSalaryCount() != null && data.getSalaryCount().compareTo(BigDecimal.ZERO) != 0 && (constraint = mapping.getConstraintWithCache(baseEntity, itemMap.get(data.getItemIdentity()), rankMap.get(data.getRankIdentity()), 0)) != null) {
                    data.setSalaryCount(data.getSalaryCount().setScale(constraint.getScale(), 4));
                }
                if (data.getMin() != null && data.getMin().compareTo(BigDecimal.ZERO) != 0 && (constraint = mapping.getConstraintWithCache(baseEntity, itemMap.get(data.getItemIdentity()), rankMap.get(data.getRankIdentity()), 1)) != null) {
                    data.setMin(data.getMin().setScale(constraint.getScale(), 4));
                }
                if (data.getMiddle() != null && data.getMiddle().compareTo(BigDecimal.ZERO) != 0 && (constraint = mapping.getConstraintWithCache(baseEntity, itemMap.get(data.getItemIdentity()), rankMap.get(data.getRankIdentity()), 2)) != null) {
                    data.setMiddle(data.getMiddle().setScale(constraint.getScale(), 4));
                }
                if (data.getMax() == null || data.getMax().compareTo(BigDecimal.ZERO) == 0 || (constraint = mapping.getConstraintWithCache(baseEntity, itemMap.get(data.getItemIdentity()), rankMap.get(data.getRankIdentity()), 3)) == null) continue;
                data.setMax(data.getMax().setScale(constraint.getScale(), 4));
            }
        }
    }
}

