/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableForCandidateParam;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryParam;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryResult;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CandSetSalApplyMatchGradeHelper {
    private static final Log LOGGER = LogFactory.getLog(CandSetSalApplyMatchGradeHelper.class);
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("");

    public static DynamicObject buildDynWithId(String entityCode, Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject(entityCode);
        dynamicObject.set("id", (Object)id);
        return dynamicObject;
    }

    public static void matchStdTable(Collection<DynamicObject> applyDyns, Set<Long> hasOfferCandidateIds) {
        LOGGER.info("[candbotp] matchStdTable start ...");
        if (CollectionUtils.isEmpty(applyDyns)) {
            return;
        }
        ArrayList matchStdParams = Lists.newArrayListWithExpectedSize((int)applyDyns.size());
        HashMap personAndItemsMap = Maps.newHashMapWithExpectedSize((int)applyDyns.size());
        for (DynamicObject applyDyn : applyDyns) {
            DynamicObjectCollection personDyns = applyDyn.getDynamicObjectCollection("candsetsalperson");
            if (CollectionUtils.isEmpty((Collection)personDyns)) continue;
            DynamicObject personDyn = (DynamicObject)personDyns.get(0);
            DynamicObjectCollection itemDyns = personDyn.getDynamicObjectCollection("persetsalrec");
            if (CollectionUtils.isEmpty((Collection)itemDyns)) {
                LOGGER.info("[candbotp] CollectionUtils.isEmpty(itemDyns)...");
                continue;
            }
            Long orgId = applyDyn.getLong("org.id");
            Long countryId = applyDyn.getLong("country.id");
            Date setSalaryEff = personDyn.getDate("setsalaryeffdt");
            Long salStructId = personDyn.getLong("salarystructure.id");
            Long stdScmVid = personDyn.getLong("stdscmvid.id");
            Long candidateId = personDyn.getLong("candidate.id");
            if (salStructId == 0L || stdScmVid == 0L) {
                LOGGER.info("[candbotp] salStructId == 0L || stdScmVid == 0L ");
                continue;
            }
            if (!(hasOfferCandidateIds.contains(candidateId) || orgId != 0L && countryId != 0L && setSalaryEff != null)) {
                LOGGER.info("[candbotp] !hasOfferCandidateIds.contains(candidateId) && (orgId == 0L || countryId == 0L || setSalaryEff == null)");
                continue;
            }
            personAndItemsMap.put(personDyn, itemDyns);
            for (DynamicObject itemDyn : itemDyns) {
                MatchStdTableForCandidateParam matchParam = new MatchStdTableForCandidateParam(candidateId, applyDyn, salStructId, stdScmVid, itemDyn.getLong("standarditem.id"), itemDyn.getDate("itembsed"));
                matchStdParams.add(matchParam);
            }
        }
        if (CollectionUtils.isEmpty((Collection)matchStdParams)) {
            return;
        }
        CandSetSalApplyMatchGradeHelper.doMatchStdTable(personAndItemsMap, matchStdParams);
        LOGGER.info("[candbotp] matchStdTable end ...");
    }

    private static void doMatchStdTable(Map<DynamicObject, DynamicObjectCollection> personAndItemsMap, ArrayList<MatchStdTableForCandidateParam> matchStdParams) {
        LOGGER.info("[candbotp] doMatchStdTable start...");
        Map<Long, Map<Long, SalaryStdMatchResultNew>> matchResultMap = ((AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class)).batchMatchStdTableForCandidate(matchStdParams);
        LOGGER.info("[candbotp] matchResultMap is [{}]", (Object)JSON.toJSONString(matchResultMap));
        Set<Long> salaryStdIds = matchResultMap.values().stream().flatMap(map -> map.values().stream()).map(SalaryStdMatchResultNew::getStdTableVid).collect(Collectors.toSet());
        Map<Long, DynamicObject> salaryStdIdToDyMap = CandidateSetSalApplyHelper.getSalaryStdMap(salaryStdIds);
        ArrayList stdAmountQueryParams = Lists.newArrayListWithExpectedSize((int)matchStdParams.size());
        HashMap stdOverStandardQueryParamMap = Maps.newHashMapWithExpectedSize((int)matchStdParams.size());
        ArrayList calAmountItemDyns = Lists.newArrayListWithCapacity((int)matchStdParams.size());
        ArrayList matchOverStandardItemDyns = Lists.newArrayListWithCapacity((int)matchStdParams.size());
        for (Map.Entry<DynamicObject, DynamicObjectCollection> entry : personAndItemsMap.entrySet()) {
            DynamicObject personDyn = entry.getKey();
            DynamicObjectCollection itemDyns = entry.getValue();
            long candidateId = personDyn.getLong("candidate.id");
            Map<Long, SalaryStdMatchResultNew> salStdMatchResultMap = matchResultMap.get(candidateId);
            if (CollectionUtils.isEmpty(salStdMatchResultMap) || CollectionUtils.isEmpty((Collection)itemDyns)) continue;
            for (DynamicObject itemDyn : itemDyns) {
                String excessControl;
                Long standardItemId = itemDyn.getLong("standarditem.id");
                SalaryStdMatchResultNew salStdMatchResult = salStdMatchResultMap.get(standardItemId);
                if (Objects.isNull(salStdMatchResult)) continue;
                Long stdTableVid = salStdMatchResult.getStdTableVid();
                CandSetSalApplyMatchGradeHelper.fillStdTableVid(itemDyn, stdTableVid, salaryStdIdToDyMap);
                Long coefficientVid = salStdMatchResult.getCoefficientVid();
                CandSetSalApplyMatchGradeHelper.fillCoefficientVid(itemDyn, coefficientVid);
                Map rangeData = salStdMatchResult.getRangeData();
                CandSetSalApplyMatchGradeHelper.fillRangeData(itemDyn, rangeData);
                String isMatchGradeRankStr = salStdMatchResult.getIsMatchGradeRank();
                Long gradeId = salStdMatchResult.getGradeId();
                Long rankId = salStdMatchResult.getRankId();
                if (SWCStringUtils.equals((String)"1", (String)isMatchGradeRankStr)) {
                    itemDyn.set("grade", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("hcdm_salarygradeentrytodb", gradeId));
                    itemDyn.set("rank", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("hcdm_rankgradeentrytodb", rankId));
                } else {
                    itemDyn.set("grade", null);
                    itemDyn.set("rank", null);
                }
                String unionId = CandSetSalApplyMatchGradeHelper.getUnionId(itemDyn);
                if (gradeId != null && gradeId != 0L) {
                    stdAmountQueryParams.add(CandSetSalApplyMatchGradeHelper.buildStdAmountQueryParam(unionId, standardItemId, stdTableVid, coefficientVid, gradeId, rankId));
                    calAmountItemDyns.add(itemDyn);
                }
                if (!StringUtils.isEmpty((CharSequence)(excessControl = salStdMatchResult.getExcessControl()))) {
                    stdOverStandardQueryParamMap.put(unionId, CandSetSalApplyMatchGradeHelper.buildStdOverStandardQueryParam(unionId, standardItemId, stdTableVid, coefficientVid, rangeData, itemDyn.getBigDecimal("amount")));
                    matchOverStandardItemDyns.add(itemDyn);
                    continue;
                }
                itemDyn.set("overstandardtype", null);
            }
        }
        CandSetSalApplyMatchGradeHelper.doMatchStdAmount(calAmountItemDyns, stdAmountQueryParams);
        CandSetSalApplyMatchGradeHelper.calOverStandardResult(matchOverStandardItemDyns, stdOverStandardQueryParamMap);
    }

    private static void calOverStandardResult(List<DynamicObject> matchOverStandardItemDyns, Map<String, StdOverStandardQueryParam> stdOverStandardQueryParamMap) {
        LOGGER.info("[candbotp] stdOverStandardQueryParamMap is [{}]", (Object)JSON.toJSONString(stdOverStandardQueryParamMap));
        if (CollectionUtils.isEmpty(matchOverStandardItemDyns)) {
            return;
        }
        ArrayList stdOverStandardQueryParams = Lists.newArrayListWithCapacity((int)matchOverStandardItemDyns.size());
        for (DynamicObject obj : matchOverStandardItemDyns) {
            StdOverStandardQueryParam standardQueryParam = stdOverStandardQueryParamMap.get(CandSetSalApplyMatchGradeHelper.getUnionId(obj));
            standardQueryParam.setAmount(obj.getBigDecimal("amount"));
            stdOverStandardQueryParams.add(standardQueryParam);
        }
        Map<String, StdOverStandardQueryResult> stdOverStandardQueryResultMap = CandSetSalApplyMatchGradeHelper.getStdOverStandardQueryResultMap(stdOverStandardQueryParams);
        LOGGER.info("[candbotp] stdOverStandardQueryResultMap is [{}]", (Object)JSON.toJSONString(stdOverStandardQueryResultMap));
        for (DynamicObject overStandardItemDyn : matchOverStandardItemDyns) {
            String unionId = CandSetSalApplyMatchGradeHelper.getUnionId(overStandardItemDyn);
            StdOverStandardQueryResult overStandardQueryResult = stdOverStandardQueryResultMap.get(unionId);
            if (overStandardQueryResult == null) {
                overStandardItemDyn.set("overstandardtype", null);
                LOGGER.info("[candbotp] unionId[{}] overStandardQueryResult is null", (Object)unionId);
                continue;
            }
            overStandardItemDyn.set("overstandardtype", (Object)overStandardQueryResult.getOverStandardTypeEnum().getCode());
        }
    }

    private static void doMatchStdAmount(List<DynamicObject> calAmountItemDyns, List<StdAmountQueryParam> stdAmountQueryParams) {
        LOGGER.info("[candbotp] stdAmountQueryParams is [{}]", (Object)JSON.toJSONString(stdAmountQueryParams));
        List<StdAmountAndSalaryCountQueryResult> stdAmountResults = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).queryAmountAndSalaryCount(stdAmountQueryParams);
        LOGGER.info("[candbotp] stdAmountResults is [{}]", (Object)JSON.toJSONString(stdAmountResults));
        if (CollectionUtils.isEmpty(stdAmountResults)) {
            return;
        }
        Map<Long, DynamicObject> currencyMap = CandSetSalApplyMatchGradeHelper.getCurrencyMap(calAmountItemDyns.stream().map(obj -> obj.getLong("currency.id")).collect(Collectors.toList()));
        Map<String, StdAmountAndSalaryCountQueryResult> stdAmountResultMap = stdAmountResults.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, o1 -> o1, (o1, o2) -> o2));
        for (DynamicObject calAmountItemDyn : calAmountItemDyns) {
            String unionId = CandSetSalApplyMatchGradeHelper.getUnionId(calAmountItemDyn);
            StdAmountAndSalaryCountQueryResult stdAmountResult = stdAmountResultMap.get(unionId);
            boolean isKeepAmount = calAmountItemDyn.getBoolean("iskeepamount");
            LOGGER.info("salaryStdAmount is [{}]", (Object)SerializationUtils.toJsonString((Object)stdAmountResult));
            if (null == stdAmountResult) {
                if (!isKeepAmount) {
                    calAmountItemDyn.set("amount", null);
                }
                calAmountItemDyn.set("salarypercent", null);
                calAmountItemDyn.set("salaryseeprate", null);
                LOGGER.info("[candbotp] unionId[{}] stdAmountResult is null", (Object)unionId);
                continue;
            }
            BigDecimal intervalMin = stdAmountResult.getGradeMinAmount();
            BigDecimal intervalMax = stdAmountResult.getGradeMaxAmount();
            BigDecimal intervalMiddle = stdAmountResult.getGradeMiddleAmount();
            BigDecimal amount = isKeepAmount ? calAmountItemDyn.getBigDecimal("amount") : stdAmountResult.getAmount();
            BigDecimal bigDecimal = amount = amount == null ? BigDecimal.ZERO : amount;
            if (!isKeepAmount) {
                DynamicObject currency = currencyMap.get(calAmountItemDyn.getLong("currency.id"));
                int amtPrecision = currency != null ? currency.getInt("amtprecision") : 2;
                amount = amount.setScale(amtPrecision, 4);
            }
            BigDecimal coefficientValue = BigDecimal.ONE;
            BigDecimal salaryRatio = SalaryStdCalculateHelper.calcSalaryRatioNew(amount, intervalMiddle, coefficientValue);
            BigDecimal salaryPermeability = SalaryStdCalculateHelper.calcSalaryPermeability(amount, intervalMin, intervalMax, coefficientValue);
            calAmountItemDyn.set("amount", (Object)amount);
            calAmountItemDyn.set("salarypercent", (Object)salaryRatio);
            calAmountItemDyn.set("salaryseeprate", (Object)salaryPermeability);
        }
    }

    private static String getUnionId(DynamicObject itemDyn) {
        DynamicObject personDyn = (DynamicObject)itemDyn.getParent();
        return personDyn.getString("candidate.id") + "_" + itemDyn.getString("standarditem.Id");
    }

    private static StdOverStandardQueryParam buildStdOverStandardQueryParam(String unionId, Long standardItemId, Long stdTableVid, Long coefficientVid, Map<Long, List<Long>> rangeData, BigDecimal amount) {
        StdOverStandardQueryParam stdOverStandardQueryParam = new StdOverStandardQueryParam();
        stdOverStandardQueryParam.setUnionId(unionId);
        stdOverStandardQueryParam.setItemId(standardItemId);
        stdOverStandardQueryParam.setTabId(null == stdTableVid ? Long.valueOf(0L) : stdTableVid);
        stdOverStandardQueryParam.setCoefficientId(null == coefficientVid ? Long.valueOf(0L) : coefficientVid);
        stdOverStandardQueryParam.setPersonRange(rangeData);
        stdOverStandardQueryParam.setAmount(amount);
        return stdOverStandardQueryParam;
    }

    private static void fillRangeData(DynamicObject itemDyn, Map<Long, List<Long>> rangeData) {
        if (!CollectionUtils.isEmpty(rangeData)) {
            itemDyn.set("salarel", (Object)JSON.toJSONString(rangeData));
        } else {
            itemDyn.set("salarel", null);
        }
    }

    private static void fillCoefficientVid(DynamicObject itemDyn, Long coefficientVid) {
        itemDyn.set("coefficient", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("hcdm_coefficient", coefficientVid));
    }

    private static void fillStdTableVid(DynamicObject itemDyn, Long stdTableVid, Map<Long, DynamicObject> salaryStdIdToDyMap) {
        DynamicObject salaryStdDy = salaryStdIdToDyMap.get(stdTableVid);
        itemDyn.set("salarystd", (Object)salaryStdDy);
        boolean isKeepAmount = itemDyn.getBoolean("iskeepamount");
        if (!isKeepAmount) {
            if (salaryStdDy != null) {
                itemDyn.set("currency", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("bd_currency", salaryStdDy.getLong("currency.id")));
                itemDyn.set("frequency", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("hsbs_calfrequency", salaryStdDy.getLong("frequency.id")));
            } else {
                itemDyn.set("currency", null);
                itemDyn.set("frequency", null);
            }
        }
    }

    private static Map<Long, DynamicObject> getCurrencyMap(List<Long> currencyIds) {
        if (CollectionUtils.isEmpty(currencyIds)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        DynamicObject[] currencyDyns = CandidateSetSalApplyHelper.getCurrency(currencyIds);
        if (null == currencyDyns || currencyDyns.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(currencyDyns).collect(Collectors.toMap(obj -> obj.getLong("id"), o1 -> o1, (o1, o2) -> o2));
    }

    private static Map<String, StdOverStandardQueryResult> getStdOverStandardQueryResultMap(List<StdOverStandardQueryParam> stdOverStandardQueryParams) {
        List<StdOverStandardQueryResult> overStandardQueryResults = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).getOverStandardType(stdOverStandardQueryParams);
        if (overStandardQueryResults == null) {
            return new HashMap<String, StdOverStandardQueryResult>(0);
        }
        return overStandardQueryResults.stream().collect(Collectors.toMap(StdOverStandardQueryResult::getUnionId, Function.identity(), (o1, o2) -> o2));
    }

    private static StdAmountQueryParam buildStdAmountQueryParam(String unionId, Long standardItemId, Long stdTableVid, Long coefficientVid, Long gradeId, Long rankId) {
        StdAmountQueryParam stdAmountQueryParam = new StdAmountQueryParam();
        stdAmountQueryParam.setUnionId(unionId);
        stdAmountQueryParam.setItemId(standardItemId);
        stdAmountQueryParam.setStdTabId(null == stdTableVid ? Long.valueOf(0L) : stdTableVid);
        stdAmountQueryParam.setCoefficientVid(null == coefficientVid ? Long.valueOf(0L) : coefficientVid);
        stdAmountQueryParam.setGradeId(gradeId);
        stdAmountQueryParam.setRankId(rankId == null ? Long.valueOf(0L) : rankId);
        return stdAmountQueryParam;
    }

    public static void fillSalStructAndScm(DynamicObject personEntry, Map<Long, Set<DynamicObject>> structAndBoidScmMap, Map<Long, Map<Long, DynamicObject>> scmBoidToVersionDynMap) {
        DynamicObjectCollection salaryStructDyns;
        if (CandSetSalApplyMatchGradeHelper.validateForbid(personEntry)) {
            LOGGER.info("[candbotp] validateForbid = true...");
            return;
        }
        DynamicObject salStructureDyn = personEntry.getDynamicObject("salarystructure");
        DynamicObject stdScmBoidDyn = personEntry.getDynamicObject("stdscmvid");
        DynamicObject scmVidDyn = null;
        if (salStructureDyn == null && stdScmBoidDyn == null) {
            LOGGER.info("[candbotp] salStructureDyn == null && stdScmVidDyn == null...");
            return;
        }
        Date setSalDate = personEntry.getDate("setsalaryeffdt");
        if (stdScmBoidDyn != null && (scmVidDyn = CandSetSalApplyMatchGradeHelper.findStdScmVidDyn(stdScmBoidDyn, setSalDate, scmBoidToVersionDynMap)) != null && salStructureDyn == null && (salaryStructDyns = scmVidDyn.getDynamicObjectCollection("salaystructure")).size() == 1) {
            personEntry.set("salarystructure", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("hcdm_salaystructure", ((DynamicObject)salaryStructDyns.get(0)).getLong("fbasedataid_id")));
        }
        if (salStructureDyn != null && stdScmBoidDyn == null) {
            Set<DynamicObject> sameStructBoidScmDyns;
            long structId = salStructureDyn.getLong("id");
            if (structAndBoidScmMap == null) {
                LOGGER.info("[candbotp] structAndBoidScmMap == null ...");
                structAndBoidScmMap = Maps.newHashMapWithExpectedSize((int)0);
            }
            if ((sameStructBoidScmDyns = structAndBoidScmMap.get(structId)) != null && sameStructBoidScmDyns.size() == 1) {
                stdScmBoidDyn = sameStructBoidScmDyns.iterator().next();
            }
            scmVidDyn = CandSetSalApplyMatchGradeHelper.findStdScmVidDyn(stdScmBoidDyn, setSalDate, scmBoidToVersionDynMap);
        }
        personEntry.set("stdscmvid", (Object)scmVidDyn);
    }

    public static DynamicObject findStdScmVidDyn(DynamicObject stdScmBoidDyn, Date setSalDate, Map<Long, Map<Long, DynamicObject>> scmBoidToVersionDynMap) {
        if (scmBoidToVersionDynMap == null || stdScmBoidDyn == null) {
            return null;
        }
        HashMap scmVidDynMap = scmBoidToVersionDynMap.get(stdScmBoidDyn.getLong("boid"));
        if (scmVidDynMap == null) {
            scmVidDynMap = Maps.newHashMapWithExpectedSize((int)0);
        }
        if (setSalDate == null) {
            return (DynamicObject)scmVidDynMap.get(stdScmBoidDyn.getLong("sourcevid"));
        }
        for (DynamicObject scmDyn : scmVidDynMap.values()) {
            Date bsled;
            Date bsed = scmDyn.getDate("bsed");
            if (!SWCDateTimeUtils.isCover((Date)setSalDate, (Date)bsed, (Date)(bsled = scmDyn.getDate("bsled")))) continue;
            return scmDyn;
        }
        return (DynamicObject)scmVidDynMap.get(stdScmBoidDyn.getLong("sourcevid"));
    }

    public static boolean validateForbid(DynamicObject personEntry) {
        DynamicObject salStructureDyn = personEntry.getDynamicObject("salarystructure");
        DynamicObject stdScmVidDyn = personEntry.getDynamicObject("stdscmvid");
        boolean isForbid = false;
        if (salStructureDyn != null && !salStructureDyn.getBoolean("enable")) {
            personEntry.set("salarystructure", null);
            isForbid = true;
        }
        if (stdScmVidDyn != null && !stdScmVidDyn.getBoolean("enable")) {
            personEntry.set("stdscmvid", null);
            isForbid = true;
        }
        return isForbid;
    }

    public static void queryAndTransToStdScmMap(Set<Long> salStructIdSet, Set<Long> stdScmIdSet, Map<Long, Set<DynamicObject>> structAndBoidScmMap, Map<Long, Map<Long, DynamicObject>> scmBoidToVersionDynMap) {
        DynamicObject[] stdScmDyns = CandSetSalApplyMatchGradeHelper.queryStdScmVDyns(salStructIdSet, stdScmIdSet);
        if (stdScmDyns != null) {
            for (DynamicObject stdScmDyn : stdScmDyns) {
                boolean isBoidDyn = stdScmDyn.getBoolean("iscurrentversion");
                if (isBoidDyn) {
                    DynamicObjectCollection structDyns = stdScmDyn.getDynamicObjectCollection("salaystructure");
                    for (DynamicObject structDyn : structDyns) {
                        long structId = structDyn.getLong("fbasedataid_id");
                        Set scmBoidDyns = structAndBoidScmMap.computeIfAbsent(structId, k -> Sets.newHashSetWithExpectedSize((int)10));
                        scmBoidDyns.add(stdScmDyn);
                    }
                    continue;
                }
                long boid = stdScmDyn.getLong("boid");
                Map scmVerDyns = scmBoidToVersionDynMap.computeIfAbsent(boid, k -> Maps.newHashMapWithExpectedSize((int)10));
                scmVerDyns.put(stdScmDyn.getLong("id"), stdScmDyn);
            }
        }
    }

    private static DynamicObject[] queryStdScmVDyns(Set<Long> salStructIdSet, Set<Long> stdScmIdSet) {
        QFilter idFilter = null;
        if (!CollectionUtils.isEmpty(stdScmIdSet)) {
            idFilter = new QFilter("id", "in", stdScmIdSet);
            idFilter.or("boid", "in", stdScmIdSet);
        }
        if (!CollectionUtils.isEmpty(salStructIdSet)) {
            QFilter structFilter = new QFilter("entryentity.salstructurent.id", "in", salStructIdSet);
            if (idFilter == null) {
                idFilter = structFilter;
            } else {
                idFilter.or(structFilter);
            }
        }
        if (idFilter == null) {
            return null;
        }
        QFilter defaultFilter = new QFilter("enable", "=", (Object)"1");
        defaultFilter.and("status", "=", (Object)"C");
        defaultFilter.and("datastatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"0", "1", "2"}));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_stdscm");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{defaultFilter, idFilter});
    }
}

