/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.model.ValidateResult;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class CandidateSetSalApplyHelper {
    private static final Log LOGGER = LogFactory.getLog(CandidateSetSalApplyHelper.class);
    public static Set<String> getByStdScmFields = Sets.newHashSet((Object[])new String[]{"frequency", "currency", "grade", "rank", "amount", "overstandardtype", "salarypercent", "salaryseeprate", "salarel", "salarystd", "coefficient"});

    private CandidateSetSalApplyHelper() {
    }

    public static DynamicObject[] getOnBrdBillByCandidateId(Set<Long> candidateIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_onbrdinfo");
        QFilter qFilter = new QFilter("candidate", "in", candidateIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public static Map<Long, DynamicObject> getOnBrdBillSelectPropsById(String properties, Set<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_onbrdinfo");
        QFilter qFilter = new QFilter("id", "in", ids);
        Object[] result = serviceHelper.query(properties, new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])result)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(result).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static DynamicObject[] getTheHighestEduExp(String properties, Set<Long> candidateIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcf_caneduexp");
        QFilter candidateFilter = new QFilter("candidate", "in", candidateIds);
        QFilter degreeFilter = new QFilter("ishighestdegree", "=", (Object)"1");
        return serviceHelper.query(properties, new QFilter[]{candidateFilter, degreeFilter});
    }

    public static DynamicObject[] getMainCandOcpQual(String properties, Set<Long> candidateIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcf_canocpqual");
        QFilter candidateFilter = new QFilter("candidate", "in", candidateIds);
        QFilter majorFilter = new QFilter("ismajor", "=", (Object)"1");
        return serviceHelper.query(properties, new QFilter[]{candidateFilter, majorFilter});
    }

    public static Map<Long, DynamicObject> getAdminOrgDepartmentType(DynamicObject[] onBrdBillDys) {
        if (ArrayUtils.isEmpty((Object[])onBrdBillDys)) {
            return null;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onBrdBillDys.length);
        Map<Long, Long> candidateIdToAdminOrgBoIdMap = Arrays.stream(onBrdBillDys).collect(Collectors.toMap(dy -> dy.getLong("candidate.id"), dy -> dy.getLong("aadminorg.boid"), (o1, o2) -> o2));
        ArrayList orgIdList = Lists.newArrayList(candidateIdToAdminOrgBoIdMap.values());
        Map result = (Map)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{orgIdList, new Date()});
        LOGGER.info("getAdminOrgDepartmentType, result is [{}]", (Object)result);
        Set orgIdStrSet = orgIdList.stream().map(value -> Long.toString(value)).collect(Collectors.toSet());
        HRBaseServiceHelper departmentTypeHelper = new HRBaseServiceHelper("haos_departmenttype");
        if (!CollectionUtils.isEmpty((Map)result)) {
            HashMap adminOrgIdToDepTypeMap = Maps.newHashMapWithExpectedSize((int)result.size());
            for (String string : orgIdStrSet) {
                Long departmentTypeId;
                Map objectMap = (Map)result.get(string);
                if (CollectionUtils.isEmpty((Map)objectMap) || !Objects.nonNull(departmentTypeId = (Long)objectMap.get("departmenttype")) || departmentTypeId == 0L) continue;
                DynamicObject departmentTypeDy = departmentTypeHelper.generateEmptyDynamicObject();
                departmentTypeDy.set("id", (Object)departmentTypeId);
                adminOrgIdToDepTypeMap.put(Long.valueOf(string), departmentTypeDy);
            }
            for (Map.Entry entry : candidateIdToAdminOrgBoIdMap.entrySet()) {
                resultMap.put(entry.getKey(), adminOrgIdToDepTypeMap.get(entry.getValue()));
            }
        }
        return resultMap;
    }

    public static Map<Long, DynamicObject> getAdminOrgIndustryType(DynamicObject[] onBrdBillDys) {
        if (ArrayUtils.isEmpty((Object[])onBrdBillDys)) {
            return null;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onBrdBillDys.length);
        Map<Long, Long> candidateIdToAdminOrgBoIdMap = Arrays.stream(onBrdBillDys).collect(Collectors.toMap(dy -> dy.getLong("candidate.id"), dy -> dy.getLong("acompany.boid"), (o1, o2) -> o2));
        ArrayList orgIdList = Lists.newArrayList(candidateIdToAdminOrgBoIdMap.values());
        Map result = (Map)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{orgIdList, new Date()});
        LOGGER.info("getAdminOrgIndustryType, result is [{}]", (Object)result);
        Set orgIdStrSet = orgIdList.stream().map(value -> Long.toString(value)).collect(Collectors.toSet());
        HRBaseServiceHelper industryTypeHelper = new HRBaseServiceHelper("hbss_industrytype");
        if (!CollectionUtils.isEmpty((Map)result)) {
            HashMap adminOrgIdToIndusTypeMap = Maps.newHashMapWithExpectedSize((int)result.size());
            for (String string : orgIdStrSet) {
                Long industryTypeId;
                Map objectMap = (Map)result.get(string);
                if (CollectionUtils.isEmpty((Map)objectMap) || !Objects.nonNull(industryTypeId = (Long)objectMap.get("industrytype")) || industryTypeId == 0L) continue;
                DynamicObject industryTypeDy = industryTypeHelper.generateEmptyDynamicObject();
                industryTypeDy.set("id", (Object)industryTypeId);
                adminOrgIdToIndusTypeMap.put(Long.valueOf(string), industryTypeDy);
            }
            for (Map.Entry entry : candidateIdToAdminOrgBoIdMap.entrySet()) {
                resultMap.put(entry.getKey(), adminOrgIdToIndusTypeMap.get(entry.getValue()));
            }
        }
        return resultMap;
    }

    public static Map<Long, DynamicObject> getCandidateSetSalaryInfoMapByOnBrdInfos(List<DynamicObject> onBrdInfoList) {
        if (CollectionUtils.isEmpty(onBrdInfoList)) {
            return ImmutableMap.of();
        }
        Map<Long, Long> candidateIdToOfferNumberMap = onBrdInfoList.stream().filter(dy -> 0L != dy.getLong("offerid")).collect(Collectors.toMap(dy -> dy.getLong("candidate.id"), dy -> dy.getLong("offerid"), (o1, o2) -> o2));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candidatebill");
        QFilter offerFilter = new QFilter("offerid", "in", candidateIdToOfferNumberMap.values());
        Object[] dys = serviceHelper.query("id,offercode,offerid,stdscm,stdscm.bsled,salarystructure,salarytype,salaryadjorg,salarystructure.createorg,salarystructure.country,entryentity.seq,entryentity.standarditem,entryentity.currencyent,entryentity.frequency,entryentity.confirmedamount,entryentity.issend,entryentity.remark", new QFilter[]{offerFilter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return ImmutableMap.of();
        }
        Map<Long, DynamicObject> tempMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("offerid"), dy -> dy, (o1, o2) -> o2));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onBrdInfoList.size());
        for (Map.Entry<Long, Long> entry : candidateIdToOfferNumberMap.entrySet()) {
            Long candidateId = entry.getKey();
            Long offerId = entry.getValue();
            DynamicObject dy2 = tempMap.get(offerId);
            if (!Objects.nonNull(dy2)) continue;
            resultMap.put(candidateId, dy2);
        }
        return resultMap;
    }

    public static boolean checkExistedOffer(Long offerId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candidatebill");
        QFilter offerFilter = new QFilter("offerid", "=", (Object)offerId);
        return serviceHelper.isExists(offerFilter);
    }

    public static boolean checkCountryAndSalaryStructureKeepSame(DynamicObject country, DynamicObject salaryStructure) {
        long salaryStructureCountryId;
        if (Objects.isNull(country) || Objects.isNull(salaryStructure)) {
            return false;
        }
        long countryId = country.getLong("id");
        return countryId == (salaryStructureCountryId = salaryStructure.getLong("country.id"));
    }

    public static QFilter getSalaryStructureFilterByCountryIdAndOrgId(long countryId, long orgId) {
        QFilter salaryStructureQFilter = CandidateSetSalApplyHelper.getSalaryStructureFilterByOrgId(orgId);
        salaryStructureQFilter.and(new QFilter("country.id", "=", (Object)countryId));
        salaryStructureQFilter.and(new QFilter("status", "=", (Object)"C"));
        salaryStructureQFilter.and(new QFilter("enable", "=", (Object)"1"));
        return salaryStructureQFilter;
    }

    public static QFilter getSalaryStructureFilterByOrgId(long orgId) {
        QFilter dataRuleForBdProp;
        QFilter salaryStructureQFilter = new QFilter("1", "=", (Object)1);
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salaystructure", (Long)orgId);
        if (useOrgFilter != null) {
            salaryStructureQFilter.and(useOrgFilter);
        }
        if ((dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"salarystructure", (String)"47150e89000000ac")) != null) {
            salaryStructureQFilter.and(dataRuleForBdProp);
        }
        return salaryStructureQFilter;
    }

    public static boolean CheckExistedCandSetSalaryAppl(long candidateId) {
        if (candidateId == 0L) {
            return false;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter idFilter = new QFilter("candsetsalperson.candidate.id", "=", (Object)candidateId);
        QFilter statusFilter = new QFilter("billstatus", "not in", (Object)new String[]{"F", "E"});
        return serviceHelper.isExists(new QFilter[]{idFilter, statusFilter});
    }

    public static DynamicObject getRelateActivityByCandidateId(long candidateId) {
        if (candidateId == 0L) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candsetsalact");
        QFilter idFilter = new QFilter("entryentity.candidate.id", "=", (Object)candidateId);
        return serviceHelper.queryOne("id,activitybase.activitystatus", new QFilter[]{idFilter});
    }

    public static Map<Long, Long> getDepEmpIdByOnBrdBillId(Set<Long> onBrdBillIdSet) {
        if (CollectionUtils.isEmpty(onBrdBillIdSet)) {
            return ImmutableMap.of();
        }
        HRBaseServiceHelper chgRecordHelper = new HRBaseServiceHelper("hpfs_chgrecord");
        QFilter onBrdBillNoFilter = new QFilter("bill", "in", onBrdBillIdSet);
        Object[] chgRecordDys = chgRecordHelper.query("id,bill,entryentity.chgentity,entryentity.idafter", new QFilter[]{onBrdBillNoFilter});
        if (ArrayUtils.isEmpty((Object[])chgRecordDys)) {
            return ImmutableMap.of();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)chgRecordDys.length);
        for (Object chgRecordDy : chgRecordDys) {
            DynamicObjectCollection entryEntity = chgRecordDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryEntity) {
                if (!"hrpi_depemp".equals(entity.getString("chgentity.number"))) continue;
                result.put(chgRecordDy.getLong("bill"), entity.getLong("idafter"));
            }
        }
        return result;
    }

    public static DynamicObject[] getSingleCandSetSalAppls(String properties, Set<Long> candidateIds) {
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter candidateIdFilter = new QFilter("candsetsalperson.candidate.id", "in", candidateIds);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        return helper.query(properties, new QFilter[]{billStatusFilter, candidateIdFilter});
    }

    public static ValidateResult<String> checkStdScmEffectTimeAndEffectTime(DynamicObject dynamicObject) {
        DynamicObjectCollection personDys = dynamicObject.getDynamicObjectCollection("candsetsalperson");
        if (!CollectionUtils.isEmpty((Collection)personDys)) {
            DynamicObject personDy = (DynamicObject)personDys.iterator().next();
            Date stdScmBsled = personDy.getDate("stdscmvid.bsled");
            Date setSalaryEffDt = personDy.getDate("setsalaryeffdt");
            if (Objects.nonNull(setSalaryEffDt) && setSalaryEffDt.after(stdScmBsled)) {
                String msg = ResManager.loadKDString((String)"\u9ed8\u8ba4\u5b9a\u85aa\u751f\u6548\u65f6\u95f4\u6bb5\u5e94\u4e0e\u5df2\u9009\u85aa\u916c\u4f53\u7cfb\u7248\u672c\u7684\u6709\u6548\u65f6\u95f4\u6bb5\u91cd\u53e0\u3002", (String)"CandidateSetSalApplyHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
                return new ValidateResult(false, (Object)msg, msg);
            }
        }
        return new ValidateResult(true, (Object)"", "");
    }

    public static ValidateResult<String> checkItemBsedAndEffectTime(DynamicObject dynamicObject) {
        DynamicObjectCollection personDys = dynamicObject.getDynamicObjectCollection("candsetsalperson");
        if (!CollectionUtils.isEmpty((Collection)personDys)) {
            DynamicObject personDy = (DynamicObject)personDys.iterator().next();
            Date setSalaryEffDt = personDy.getDate("setsalaryeffdt");
            DynamicObjectCollection itemDys = personDy.getDynamicObjectCollection("persetsalrec");
            if (!CollectionUtils.isEmpty((Collection)itemDys)) {
                for (DynamicObject itemDy : itemDys) {
                    Date itemBsed = itemDy.getDate("itembsed");
                    if (!Objects.nonNull(setSalaryEffDt) || !Objects.nonNull(itemBsed) || !setSalaryEffDt.after(itemBsed)) continue;
                    String msg = ResManager.loadKDString((String)"\u9ed8\u8ba4\u5b9a\u85aa\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5b9a\u8c03\u85aa\u9879\u76ee\u660e\u7ec6\u5206\u5f55\u4e2d\u7684\u5b9a\u85aa\u751f\u6548\u65e5\u671f\u3002", (String)"CandidateSetSalApplyHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
                    return new ValidateResult(false, (Object)msg, msg);
                }
            }
        }
        return new ValidateResult(true, (Object)"", "");
    }

    public static ValidateResult<String> checkItemBsedAndBsled(DynamicObject dynamicObject) {
        DynamicObject personDy;
        DynamicObjectCollection itemDys;
        DynamicObjectCollection personDys = dynamicObject.getDynamicObjectCollection("candsetsalperson");
        if (!CollectionUtils.isEmpty((Collection)personDys) && !CollectionUtils.isEmpty((Collection)(itemDys = (personDy = (DynamicObject)personDys.iterator().next()).getDynamicObjectCollection("persetsalrec")))) {
            for (DynamicObject itemDy : itemDys) {
                Date itemBsed = itemDy.getDate("itembsed");
                Date itemBsled = itemDy.getDate("itembsled");
                if (!Objects.nonNull(itemBsled) || !Objects.nonNull(itemBsed) || !itemBsed.after(itemBsled)) continue;
                String msg = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\u660e\u7ec6\u5206\u5f55\u4e2d\u7684\u5b9a\u85aa\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"CandidateSetSalApplyHelper_5", (String)"swc-hcdm-business", (Object[])new Object[0]);
                return new ValidateResult(false, (Object)msg, msg);
            }
        }
        return new ValidateResult(true, (Object)"", "");
    }

    public static DynamicObject querySalaryStructureDy(long salaryStructureId) {
        QFilter idFilter = new QFilter("id", "=", (Object)salaryStructureId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_salaystructure");
        return serviceHelper.queryOne("id,entryentity.standarditem", new QFilter[]{idFilter});
    }

    public static Map<Long, DynamicObject> getSalaryStdMap(Set<Long> salaryStdIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_salarystandard");
        QFilter qFilter = new QFilter("id", "in", salaryStdIds);
        Object[] results = serviceHelper.query("id,frequency,currency,boid", new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])results)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(results).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static Date getMaxBsled() {
        LocalDate localDate = LocalDate.of(2999, 12, 31);
        return Date.from(localDate.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    public static String fmtMicrometer(String text) {
        DecimalFormat df = null;
        if (text.indexOf(46) > 0) {
            int scale = text.length() - text.indexOf(46) - 1;
            if (scale == 0) {
                df = new DecimalFormat("###,##0");
            } else if (scale == 1) {
                df = new DecimalFormat("###,##0.0");
            } else {
                StringBuilder format = new StringBuilder("#,##0.");
                for (int i = 0; i < scale; ++i) {
                    format.append('0');
                }
                df = new DecimalFormat(format.toString());
            }
        } else {
            df = new DecimalFormat("###,##0");
        }
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    public static List<String> getDifferentTotalAmountStrList(DynamicObjectCollection entryEntities) {
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return ImmutableList.of();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)entryEntities.size());
        HashMap currencyMap = Maps.newHashMapWithExpectedSize((int)entryEntities.size());
        HashMap frequencyMap = Maps.newHashMapWithExpectedSize((int)entryEntities.size());
        HashMap currencyGroupMap = Maps.newHashMapWithExpectedSize((int)entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObject frequencyDy = entryEntity.getDynamicObject("frequency");
            DynamicObject currencyDy = entryEntity.getDynamicObject("currency");
            BigDecimal amount = entryEntity.getBigDecimal("amount");
            if (Objects.isNull(frequencyDy) || Objects.isNull(currencyDy) || Objects.isNull(amount)) continue;
            currencyMap.put(currencyDy.getLong("id"), currencyDy);
            frequencyMap.put(frequencyDy.getLong("id"), frequencyDy);
            Map frequencyGroupMap = currencyGroupMap.computeIfAbsent(currencyDy.getLong("id"), o1 -> Maps.newHashMap());
            List dataList = frequencyGroupMap.computeIfAbsent(frequencyDy.getLong("id"), o1 -> Lists.newArrayList());
            dataList.add(entryEntity);
            frequencyGroupMap.put(frequencyDy.getLong("id"), dataList);
            currencyGroupMap.put(currencyDy.getLong("id"), frequencyGroupMap);
        }
        for (Map.Entry currencyEntry : currencyGroupMap.entrySet()) {
            Map currencyEntryValue = (Map)currencyEntry.getValue();
            for (Map.Entry frequencyEntry : currencyEntryValue.entrySet()) {
                StringBuilder temp = new StringBuilder();
                List frequencyEntryValue = (List)frequencyEntry.getValue();
                BigDecimal confirmAmount = frequencyEntryValue.stream().map(o1 -> o1.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                String sign = ((DynamicObject)currencyMap.get(currencyEntry.getKey())).getString("sign");
                String pricePrecision = ((DynamicObject)currencyMap.get(currencyEntry.getKey())).getString("amtprecision");
                String frequencyName = ((DynamicObject)frequencyMap.get(frequencyEntry.getKey())).getString("name");
                temp.append(sign).append(CandidateSetSalApplyHelper.fmtMicrometer(confirmAmount.setScale(Integer.parseInt(pricePrecision), 5).toString())).append('/').append(frequencyName);
                result.add(temp.toString());
            }
        }
        return result;
    }

    public static Map<Long, DynamicObject> getValidateRepeatAdjFileMap(DynamicObject[] candidateSetSalaryApplDys) {
        if (Objects.isNull(candidateSetSalaryApplDys)) {
            return ImmutableMap.of();
        }
        Set<Long> onBrdInfoIds = Arrays.stream(candidateSetSalaryApplDys).map(dy -> (DynamicObject)dy.getDynamicObjectCollection("candsetsalperson").get(0)).map(dy -> dy.getLong("onbrdinfo")).collect(Collectors.toSet());
        LOGGER.info("getValidatePersonAndBsedMap candidateIds from onBrdInfoIds is [{}]", onBrdInfoIds);
        Map<Long, Long> onBrdInfoIdToDepempIdMap = CandidateSetSalApplyHelper.getDepEmpIdByOnBrdBillId(onBrdInfoIds);
        LOGGER.info("getValidatePersonAndBsedMap onBrdInfoIdToDepempIdMap is [{}]", onBrdInfoIdToDepempIdMap);
        HRBaseServiceHelper adjFileInfoHelper = new HRBaseServiceHelper("hcdm_adjfileinfo");
        QFilter personFilter = new QFilter("depemp.id", "in", onBrdInfoIdToDepempIdMap.values());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{personFilter, enableFilter};
        Object[] queryResult = adjFileInfoHelper.query("boid,person.name,depemp,employee.empnumber,number,bsed,bsled,org,country,stdscm,iscurrentversion,datastatus,status", qFilters);
        if (ArrayUtils.isEmpty((Object[])queryResult)) {
            return ImmutableMap.of();
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(queryResult).collect(Collectors.groupingBy(e1 -> e1.getLong("boid")));
        Set boidSet = Arrays.stream(queryResult).filter(object -> object.getBoolean("iscurrentversion") && object.getString("status").equals("E")).map(object -> object.getLong("boid")).collect(Collectors.toSet());
        ArrayList tempResult = Lists.newArrayListWithExpectedSize((int)queryResult.length);
        map.forEach((key, list) -> {
            if (!boidSet.contains(key)) {
                for (DynamicObject dynamicObject : list) {
                    if (dynamicObject.getString("datastatus").equals("-2") || dynamicObject.getString("datastatus").equals("-1") || dynamicObject.getString("status").equals("C") && dynamicObject.getBoolean("iscurrentversion")) continue;
                    tempResult.add(dynamicObject);
                }
            }
        });
        List<DynamicObject> adjFileDys = tempResult.stream().sorted((dy1, dy2) -> dy2.getDate("bsled").compareTo(dy1.getDate("bsled"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(adjFileDys)) {
            return ImmutableMap.of();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)candidateSetSalaryApplDys.length);
        HashMap depEmpIdToAdjFileDyMap = Maps.newHashMapWithExpectedSize((int)adjFileDys.size());
        adjFileDys.forEach(dy -> depEmpIdToAdjFileDyMap.putIfAbsent(dy.getLong("depemp.id"), dy));
        LOGGER.info("getValidatePersonAndBsedMap depEmpIdToAdjFileDyMap keyset is [{}]", depEmpIdToAdjFileDyMap.keySet());
        LOGGER.info("getValidatePersonAndBsedMap depEmpIdToAdjFileDyMap valueIds is [{}]", depEmpIdToAdjFileDyMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        for (DynamicObject candidateSetSalaryApplDy : candidateSetSalaryApplDys) {
            DynamicObject adjFileDy;
            DynamicObject personEntry = (DynamicObject)candidateSetSalaryApplDy.getDynamicObjectCollection("candsetsalperson").get(0);
            long onBrdInfoId = personEntry.getLong("onbrdinfo");
            Long depEmpId = onBrdInfoIdToDepempIdMap.get(onBrdInfoId);
            if (!Objects.nonNull(depEmpId) || !Objects.nonNull(adjFileDy = (DynamicObject)depEmpIdToAdjFileDyMap.get(depEmpId))) continue;
            result.put(candidateSetSalaryApplDy.getLong("id"), adjFileDy);
        }
        return result;
    }

    public static ValidateResult<String> checkCandidateEnrollStatus(DynamicObject candSetSalApplDy, DynamicObject onBrdInfoDy) {
        DynamicObjectCollection personDys = candSetSalApplDy.getDynamicObjectCollection("candsetsalperson");
        DynamicObject personDy = (DynamicObject)personDys.get(0);
        if (onBrdInfoDy == null) {
            String msg = ResManager.loadKDString((String)"\u7533\u8bf7\u5355{0}\u4e2d\u7684\u5019\u9009\u4eba{1}\u672a\u53d1\u73b0\u5bf9\u5e94\u7684\u5165\u804c\u5355\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CandidateSetSalApplyHelper_2", (String)"swc-hcdm-business", (Object[])new Object[]{candSetSalApplDy.getString("billno"), personDy.getString("name")});
            return new ValidateResult(false, (Object)msg, msg);
        }
        if ("1".equals(onBrdInfoDy.getString("enrollstatus"))) {
            String msg = ResManager.loadKDString((String)"\u7533\u8bf7\u5355{0}\u4e2d\u7684\u5019\u9009\u4eba{1}\u7684\u5165\u804c\u5355\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8\u5165\u804c\u201d\uff0c\u65e0\u6cd5\u751f\u6210\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateSetSalApplyHelper_3", (String)"swc-hcdm-business", (Object[])new Object[]{candSetSalApplDy.getString("billno"), personDy.getString("name")});
            return new ValidateResult(false, (Object)msg, msg);
        }
        if ("4".equals(onBrdInfoDy.getString("enrollstatus"))) {
            String msg = ResManager.loadKDString((String)"\u7533\u8bf7\u5355{0}\u4e2d\u7684\u5019\u9009\u4eba{1}\u7684\u5165\u804c\u5355\u72b6\u6001\u4e3a\u201c\u7ec8\u6b62\u5165\u804c\u201d\uff0c\u65e0\u6cd5\u751f\u6210\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateSetSalApplyHelper_4", (String)"swc-hcdm-business", (Object[])new Object[]{candSetSalApplDy.getString("billno"), personDy.getString("name")});
            return new ValidateResult(false, (Object)msg, msg);
        }
        return new ValidateResult(true, (Object)"", "");
    }

    public static DynamicObject[] getCandidateSetSalApplByCandidateIds(Set<Long> candidateIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter candidateFilter = new QFilter("candsetsalperson.candidate.id", "in", candidateIds);
        QFilter billStatusFilter = new QFilter("billstatus", "not in", (Object)new String[]{"F", "E"});
        DynamicObject[] applDys = serviceHelper.query("id,billno,candsetsalperson.candidate", new QFilter[]{candidateFilter, billStatusFilter});
        return applDys;
    }

    public static DynamicObject[] getExistCandidateSetSalApplByOnBrdInfoId(Set<Long> onBrdInfoIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter candidateFilter = new QFilter("candsetsalperson.onbrdinfo", "in", onBrdInfoIds);
        QFilter billStatusFilter = new QFilter("billstatus", "not in", (Object)new String[]{"F", "E"});
        DynamicObject[] applDys = serviceHelper.query("id,billno,candsetsalact,candsetsalperson.onbrdinfo,billstatus", new QFilter[]{candidateFilter, billStatusFilter});
        return applDys;
    }

    public static Map<Long, DynamicObject> getOnBrdInfoIdToCandidateSetSalApplMapByApplId(Set<Object> candSetSalApplIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter idFilter = new QFilter("id", "in", candSetSalApplIds);
        Object[] applDys = serviceHelper.query("id,billno,candsetsalperson.onbrdinfo,billstatus", new QFilter[]{idFilter});
        if (ArrayUtils.isEmpty((Object[])applDys)) {
            return ImmutableMap.of();
        }
        Map<Long, DynamicObject> onBrdInfoIdToCandidateSetSalApplMap = Arrays.stream(applDys).collect(Collectors.toMap(dy -> ((DynamicObject)dy.getDynamicObjectCollection("candsetsalperson").get(0)).getLong("onbrdinfo"), dy -> dy, (o1, o2) -> o2));
        return onBrdInfoIdToCandidateSetSalApplMap;
    }

    public static Map<Long, DynamicObject> getActIdToCandidateSetSalApplMapByActId(Set<Long> actIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter actIdFilter = new QFilter("candsetsalact.id", "in", actIds);
        QFilter billStatusFilter = new QFilter("billstatus", "not in", (Object)new String[]{"F", "E"});
        Object[] applDys = serviceHelper.query("id,candsetsalact.id", new QFilter[]{actIdFilter, billStatusFilter});
        if (ArrayUtils.isEmpty((Object[])applDys)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(applDys).collect(Collectors.toMap(dy -> dy.getLong("candsetsalact.id"), dy -> dy, (o1, o2) -> o2));
    }

    public static Map<Long, DynamicObject> getStdScmMapByVid(Set<Long> vids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_stdscm");
        QFilter idFilter = new QFilter("id", "in", vids);
        Object[] stdScmDys = serviceHelper.query("id,entryentity.salstructurent,entryentity.standarditem,entryentity.excesscontrol,entryentity.ismatchgraderank,entryentity.matchstrategy", new QFilter[]{idFilter});
        if (ArrayUtils.isEmpty((Object[])stdScmDys)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(stdScmDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static DynamicObject getCandSetSalApplById(Long candPkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter idFilter = new QFilter("id", "=", (Object)candPkId);
        return serviceHelper.queryOne("id,isdraft,country,candsetsalperson.salaryadjfile,candsetsalperson.department,candsetsalperson.empgroup,candsetsalperson.salarystructure,candsetsalperson.stdscmvid", new QFilter[]{idFilter});
    }

    public static Map<Long, DynamicObject> getNoStartActDysByOnBrdInfoId(Set<Long> onBrdInfoIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candsetsalact");
        QFilter onBrdInfoIdFilter = new QFilter("onbrdinfoid", "in", onBrdInfoIds);
        QFilter statusFilter = new QFilter("activitybase.activitystatus", "=", (Object)"0");
        Object[] actDys = serviceHelper.query("id,candsetsalapplid,onbrdinfoid,candsetsalapplnum,activitybase", new QFilter[]{onBrdInfoIdFilter, statusFilter});
        if (ArrayUtils.isEmpty((Object[])actDys)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(actDys).collect(Collectors.toMap(dy -> dy.getLong("onbrdinfoid"), dy -> dy, (o1, o2) -> o2));
    }

    public static Map<Long, DynamicObject> getActBaseDysById(Set<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_activitybase");
        QFilter idFilter = new QFilter("id", "in", ids);
        Object[] actBaseDys = serviceHelper.query("id,activitystatus", new QFilter[]{idFilter});
        if (ArrayUtils.isEmpty((Object[])actBaseDys)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(actBaseDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static Map<Long, DynamicObject> getCandSetSalApplDysById(Set<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter idFilter = new QFilter("id", "in", ids);
        Object[] result = serviceHelper.query("id,billstatus", new QFilter[]{idFilter});
        if (ArrayUtils.isEmpty((Object[])result)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(result).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static Set<Long> getSalaryStructureByOrgId(long orgId) {
        QFilter salaryStructureQFilter = CandidateSetSalApplyHelper.getSalaryStructureFilterByOrgId(orgId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_salaystructure");
        Object[] result = serviceHelper.query("id,name", new QFilter[]{salaryStructureQFilter});
        if (ArrayUtils.isEmpty((Object[])result)) {
            LOGGER.info("orgId is {}, and salaryStructureIdSet is {}", (Object)orgId, (Object)ImmutableSet.of());
            return ImmutableSet.of();
        }
        Set<Long> salaryStructureIdSet = Arrays.stream(result).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        LOGGER.info("orgId is {}, and salaryStructureIdSet is {}", (Object)orgId, salaryStructureIdSet);
        return salaryStructureIdSet;
    }

    public static Set<Long> getGlobalShareSalaryStructureIdSet() {
        Object[] result;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_salaystructure");
        QFilter ctrlStrategyFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
        QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"salarystructure");
        if (dataRuleForBdProp != null) {
            ctrlStrategyFilter.and(dataRuleForBdProp);
        }
        if (ArrayUtils.isEmpty((Object[])(result = serviceHelper.query("id,name", new QFilter[]{ctrlStrategyFilter})))) {
            LOGGER.info("globalShareSalaryStructureIdSet is {}", (Object)ImmutableSet.of());
            return ImmutableSet.of();
        }
        Set<Long> salaryStructureIdSet = Arrays.stream(result).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        LOGGER.info("globalShareSalaryStructureIdSet is {}", salaryStructureIdSet);
        return salaryStructureIdSet;
    }

    public static Map<Long, DynamicObject> getAdjFileBODyMap(Set<Long> boidSet) {
        HRBaseServiceHelper adjFileInfoHelper = new HRBaseServiceHelper("hcdm_adjfileinfo");
        Object[] adjFileDys = adjFileInfoHelper.query("id,number,org,country,stdscm,bsed,bsled,depemp,boid", new QFilter[]{new QFilter("id", "in", boidSet)});
        if (ArrayUtils.isEmpty((Object[])adjFileDys)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(adjFileDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (o1, o2) -> o2));
    }

    public static boolean isDraftAndSomeValueIsNull(long candSetSalApplId) {
        DynamicObject candSetSalAppl = CandidateSetSalApplyHelper.getCandSetSalApplById(candSetSalApplId);
        boolean isDraft = candSetSalAppl.getBoolean("isdraft");
        if (isDraft) {
            DynamicObjectCollection personEntries = candSetSalAppl.getDynamicObjectCollection("candsetsalperson");
            DynamicObject personEntry = (DynamicObject)personEntries.get(0);
            long countryId = candSetSalAppl.getLong("country.id");
            long departmentId = personEntry.getLong("department.id");
            long empGroupId = personEntry.getLong("empgroup.id");
            long salaryStructureId = personEntry.getLong("salarystructure.id");
            long stdScmVidId = personEntry.getLong("stdscmvid.id");
            return countryId == 0L || departmentId == 0L || empGroupId == 0L || salaryStructureId == 0L || stdScmVidId == 0L;
        }
        return false;
    }

    public static DynamicObject getCurrency(Long currencyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bd_currency");
        DynamicObject dynamicObject = serviceHelper.queryOne("id,amtprecision", (Object)currencyId);
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject;
        }
        return null;
    }

    public static DynamicObject[] getCurrency(List<Long> currencyIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bd_currency");
        QFilter filter = new QFilter("id", "in", currencyIds);
        Object[] dynamicObjects = serviceHelper.query("id,amtprecision", new QFilter[]{filter});
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            return dynamicObjects;
        }
        return null;
    }

    public static DynamicObject[] getCoefficient(List<Long> coefficientVid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_coefficient");
        QFilter filter = new QFilter("id", "in", coefficientVid);
        Object[] dynamicObjects = serviceHelper.query("id,coefficientvalue", new QFilter[]{filter});
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            return dynamicObjects;
        }
        return null;
    }

    public static Map<String, String> getExcessControlMap(List<Long> stdScmVid) {
        Map<Long, DynamicObject> stdScmMap = CandidateSetSalApplyHelper.getStdScmMapByVid(Sets.newHashSet(stdScmVid));
        HashMap excessControlMap = Maps.newHashMapWithExpectedSize((int)stdScmMap.size());
        for (Map.Entry<Long, DynamicObject> entry : stdScmMap.entrySet()) {
            DynamicObject stdScmDy = entry.getValue();
            long stdScmId = entry.getKey();
            DynamicObjectCollection entryEntity = stdScmDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDy : entryEntity) {
                long salStructureId = entryDy.getLong("salstructurent.id");
                long standardItemId = entryDy.getLong("standarditem.id");
                String excessControl = entryDy.getString("excesscontrol");
                String stdScmIdStr = String.valueOf(stdScmId);
                String salStructureIdStr = String.valueOf(salStructureId);
                String standardItemIdStr = String.valueOf(standardItemId);
                String key = String.join((CharSequence)"-", stdScmIdStr, salStructureIdStr, standardItemIdStr);
                excessControlMap.put(key, excessControl);
            }
        }
        return excessControlMap;
    }

    public static Set<Long> getSalStructureIdsFromStdScmDy(DynamicObject stdScmDy) {
        if (stdScmDy == null) {
            return null;
        }
        Set salaryStructureIds = null;
        DynamicObjectCollection itemDyns = stdScmDy.getDynamicObjectCollection("entryentity");
        if (itemDyns != null) {
            salaryStructureIds = itemDyns.stream().map(obj -> obj.getLong("salstructurent.id")).collect(Collectors.toSet());
        }
        return salaryStructureIds;
    }

    public static boolean isHasPerSetSalRec(DynamicObject applyDy, boolean needCheckInfoOfStdScm) {
        if (applyDy == null) {
            return false;
        }
        DynamicObjectCollection personDyns = applyDy.getDynamicObjectCollection("candsetsalperson");
        if (personDyns == null || personDyns.size() == 0) {
            return false;
        }
        boolean isHasPerSetSalRec = false;
        DynamicObject personDyn = (DynamicObject)personDyns.get(0);
        DynamicObjectCollection perSetSalRec = personDyn.getDynamicObjectCollection("persetsalrec");
        if (perSetSalRec.size() > 0) {
            isHasPerSetSalRec = true;
        }
        if (!isHasPerSetSalRec || !needCheckInfoOfStdScm) {
            return isHasPerSetSalRec;
        }
        for (DynamicObject itemDyn : perSetSalRec) {
            for (String getByStdScmField : getByStdScmFields) {
                if (StringUtils.isEmpty((CharSequence)itemDyn.getString(getByStdScmField))) continue;
                return true;
            }
        }
        return false;
    }

    public static void fillEscrowStaff(DynamicObject personEntry) {
        long adminorgBoId;
        long departmentBoId = personEntry.getLong("department.boid");
        if (departmentBoId != (adminorgBoId = personEntry.getLong("adminorg.boid")) || departmentBoId == 0L) {
            personEntry.set("escrowstaff", (Object)Boolean.TRUE);
        } else {
            personEntry.set("escrowstaff", (Object)Boolean.FALSE);
        }
    }

    public static boolean isCanAddItem(DynamicObject personEntry) {
        if (Objects.isNull(personEntry)) {
            return false;
        }
        DynamicObject applyDyn = (DynamicObject)personEntry.getParent();
        DynamicObject org = applyDyn.getDynamicObject("org");
        DynamicObject country = applyDyn.getDynamicObject("country");
        DynamicObject applySalStructDyn = personEntry.getDynamicObject("salarystructure");
        DynamicObject stdScmVidDyn = personEntry.getDynamicObject("stdscmvid");
        Date setSalDate = personEntry.getDate("setsalaryeffdt");
        return org != null && country != null && applySalStructDyn != null && stdScmVidDyn != null && setSalDate != null;
    }

    public static String validSalStructAndStdScm(DynamicObject personDy) {
        if (personDy == null) {
            return "";
        }
        DynamicObject stdScmDy = personDy.getDynamicObject("stdscmvid");
        DynamicObject salaryStructureDyn = personDy.getDynamicObject("salarystructure");
        if (stdScmDy == null || salaryStructureDyn == null) {
            return "";
        }
        long salaryStructureId = salaryStructureDyn.getLong("id");
        Set<Long> salStructureIdsOfStdScm = CandidateSetSalApplyHelper.getSalStructureIdsFromStdScmDy(stdScmDy);
        if (salStructureIdsOfStdScm == null || salStructureIdsOfStdScm.size() == 0 || !salStructureIdsOfStdScm.contains(salaryStructureId)) {
            return ResManager.loadKDString((String)"\u201c{0}\u201d\u85aa\u916c\u4f53\u7cfb\u672a\u5305\u542b\u201c{1}\u201d\u85aa\u916c\u7ed3\u6784\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CandidateSetSalApplyHelper_6", (String)"swc-hcdm-business", (Object[])new Object[]{stdScmDy.getString("name"), salaryStructureDyn.getString("name")});
        }
        return "";
    }
}

