/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFileInfoServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class CandidateSetSalApplyService {
    private static final Log LOGGER = LogFactory.getLog(CandidateSetSalApplyService.class);

    public static DynamicObject[] queryApplById(Set<Long> applyIds) {
        if (CollectionUtils.isEmpty(applyIds)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candsetsalappl");
        QFilter filter = new QFilter("id", "in", applyIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static QFilter getSyncFileFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("candsetsalperson.synchstatus", "=", (Object)"30");
        filter.and("candsetsalperson.syncfilestatus", "!=", (Object)"1");
        return filter;
    }

    public static boolean isSyncFile(DynamicObject applyDyn, DynamicObject personDyn) {
        String billNo = applyDyn.getString("billstatus");
        String synchStatus = personDyn.getString("synchstatus");
        return StringUtils.equals((CharSequence)synchStatus, (CharSequence)"30") && StringUtils.equals((CharSequence)billNo, (CharSequence)"C");
    }

    public static DynamicObject[] queryNotConfirmEntryAppl(String fields, Set<Long> onbrdBillIds) {
        if (CollectionUtils.isEmpty(onbrdBillIds)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candsetsalappl");
        QFilter filter = new QFilter("candsetsalperson.onbrdinfo", "in", onbrdBillIds);
        HashSet billStatusSet = Sets.newHashSet((Object[])new String[]{"F", "E"});
        QFilter defaultFilter = new QFilter("billstatus", "not in", (Object)billStatusSet);
        if (StringUtils.isEmpty((CharSequence)fields)) {
            return serviceHelper.loadDynamicObjectArray(new QFilter[]{filter, defaultFilter});
        }
        return serviceHelper.query(fields, new QFilter[]{filter, defaultFilter});
    }

    public static Set<Long> confirmEntryToAppl(DynamicObject[] appls, Map<Long, Long> onbrdBillAndDepIdMap) {
        if (appls == null || appls.length == 0) {
            return null;
        }
        HashSet applyDynSet = Sets.newHashSetWithExpectedSize((int)appls.length);
        HashSet syncFileApplyIds = Sets.newHashSetWithExpectedSize((int)appls.length);
        for (DynamicObject apply : appls) {
            long applyId = apply.getLong("id");
            DynamicObjectCollection personDyns = apply.getDynamicObjectCollection("candsetsalperson");
            for (DynamicObject personDyn : personDyns) {
                long onbrdInfoId = personDyn.getLong("onbrdinfo");
                String synchStatus = personDyn.getString("synchstatus");
                Long oldDepEmpId = personDyn.getLong("depemp.id");
                if (!onbrdBillAndDepIdMap.containsKey(onbrdInfoId) || StringUtils.equals((CharSequence)synchStatus, (CharSequence)"30") && oldDepEmpId != 0L) continue;
                Long depEmpId = onbrdBillAndDepIdMap.get(onbrdInfoId);
                if (depEmpId == null || depEmpId == 0L) {
                    throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u5355\u201c%s\u201d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4eba\u4e0d\u5b58\u5728\u3002", (String)"CandidateSetSalApplyService_4", (String)"swc-hcdm-business", (Object[])new Object[0]), onbrdInfoId));
                }
                personDyn.set("synchstatus", (Object)"30");
                if (CandidateSetSalApplyService.isSyncFile(apply, personDyn)) {
                    syncFileApplyIds.add(applyId);
                }
                applyDynSet.add(apply);
                personDyn.set("depemp", (Object)depEmpId);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)applyDynSet)) {
            new HRBaseServiceHelper("hcdm_candsetsalappl").update(applyDynSet.toArray(new DynamicObject[applyDynSet.size()]));
        }
        return syncFileApplyIds;
    }

    public static String isNeedShowEntryConfirm(String operateKey, DynamicObjectCollection personDyns) {
        if (personDyns == null || personDyns.size() == 0) {
            return null;
        }
        for (DynamicObject personDyn : personDyns) {
            String synchStatus = personDyn.getString("synchstatus");
            if (StringUtil.equals((String)"30", (String)synchStatus)) continue;
            return String.format(Locale.ROOT, CandidateSetSalApplyService.getEntryConfirmMsg(operateKey), personDyn.getString("name"));
        }
        return null;
    }

    public static String getEntryConfirmMsg(String operateKey) {
        String msg = null;
        switch (operateKey) {
            case "submit": {
                msg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u201c%s\u201d\u8fd8\u672a\u786e\u8ba4\u5165\u804c\u662f\u5426\u63d0\u4ea4\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CandidateSetSalApplyService_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
                break;
            }
            case "submiteffect": {
                msg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u201c%s\u201d\u8fd8\u672a\u786e\u8ba4\u5165\u804c\u662f\u5426\u63d0\u4ea4\u5e76\u751f\u6548\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CandidateSetSalApplyService_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    public static int queryNotEntryNumByIds(Set<Long> applyIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        QFilter filter = new QFilter("id", "in", applyIds);
        filter.and("candsetsalperson.synchstatus", "!=", (Object)"30");
        return serviceHelper.count("hcdm_singlecandsetsalappl", new QFilter[]{filter});
    }

    public static String getEntryConfirmMsg(String operateKey, int count) {
        String msg = null;
        switch (operateKey) {
            case "submit": {
                msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u8bb0\u5f55\u5bf9\u5e94\u7684\u5019\u9009\u4eba\u8fd8\u672a\u786e\u8ba4\u5165\u804c\uff0c\u662f\u5426\u63d0\u4ea4\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CandidateSetSalApplyService_2", (String)"swc-hcdm-business", (Object[])new Object[0]), count);
                break;
            }
            case "submiteffect": {
                msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u8bb0\u5f55\u5bf9\u5e94\u7684\u5019\u9009\u4eba\u8fd8\u672a\u786e\u8ba4\u5165\u804c\uff0c\u662f\u5426\u63d0\u4ea4\u5e76\u751f\u6548\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CandidateSetSalApplyService_3", (String)"swc-hcdm-business", (Object[])new Object[0]), count);
                break;
            }
        }
        return msg;
    }

    public static String matchAndSetExistFile(DynamicObject apply, boolean onlyMatchNoSet) {
        if (apply == null) {
            return null;
        }
        DynamicObjectCollection personDyns = apply.getDynamicObjectCollection("candsetsalperson");
        if (CollectionUtils.isEmpty((Collection)personDyns)) {
            return null;
        }
        Map<DynamicObject, String> personDynMsgMap = CandidateSetSalApplyService.matchAndSetExistFile(Lists.newArrayList((Object[])new DynamicObject[]{apply}), onlyMatchNoSet);
        if (CollectionUtils.isEmpty(personDynMsgMap)) {
            return null;
        }
        return personDynMsgMap.get(personDyns.get(0));
    }

    public static Map<DynamicObject, String> matchAndSetExistFile(List<DynamicObject> applyDyns, boolean onlyMatchNoSet) {
        if (CollectionUtils.isEmpty(applyDyns)) {
            return new HashMap<DynamicObject, String>(0);
        }
        HashMap keyPersonDynMap = Maps.newHashMapWithExpectedSize((int)applyDyns.size());
        Map<String, List<DynamicObject>> adjFileInfoGroupByKeyword = CandidateSetSalApplyService.clearFileAndQueryFilesByKey(applyDyns, keyPersonDynMap);
        if (CollectionUtils.isEmpty(adjFileInfoGroupByKeyword)) {
            adjFileInfoGroupByKeyword = new HashMap<String, List<DynamicObject>>(0);
        }
        HashMap candidateMsgMap = Maps.newHashMapWithExpectedSize((int)applyDyns.size());
        for (Map.Entry entry : keyPersonDynMap.entrySet()) {
            String applyFileNum;
            String key = (String)entry.getKey();
            DynamicObject personDyn = (DynamicObject)entry.getValue();
            List<DynamicObject> files = adjFileInfoGroupByKeyword.get(key);
            if (personDyn == null) continue;
            if (CollectionUtils.isEmpty(files)) {
                personDyn.set("salaryadjfile", null);
                continue;
            }
            Date setSalaryEffDt = personDyn.getDate("setsalaryeffdt");
            List<DynamicObject> matchFiles = CandidateSetSalApplyService.matchFile(files, setSalaryEffDt);
            if (matchFiles == null || matchFiles.size() == 0) continue;
            if (matchFiles.size() != 1) {
                LOGGER.info("\u5173\u952e\u5b57\u6bb5{0}\u5728\u751f\u6548\u65e5\u671f{1}\u5b58\u5728\u76f8\u540c\u7684\u6863\u6848", (Object)key, (Object)HRInteDateTimeUtil.formatDate((String)"hcdm_singlecandsetsalappl", (String)"setsalaryeffdt", (Date)setSalaryEffDt));
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5728\u751f\u6548\u65e5\u671f{0}\u5339\u914d\u5230\u591a\u4efd\u76f8\u540c\u4e1a\u52a1\u4e3b\u952e\u7684\u5b9a\u8c03\u85aa\u6863\u6848,\u65e0\u6cd5\u5173\u8054\u6863\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CandidateSetSalApplyService_5", (String)"swc-hcdm-business", (Object[])new Object[0]), HRInteDateTimeUtil.formatDate((String)"hcdm_singlecandsetsalappl", (String)"setsalaryeffdt", (Date)setSalaryEffDt));
                candidateMsgMap.put(personDyn, errorMsg);
                continue;
            }
            DynamicObject matchFile = matchFiles.get(0);
            String matchFileNum = matchFile.getString("number");
            if (StringUtils.equals((CharSequence)matchFileNum, (CharSequence)(applyFileNum = personDyn.getString("salaryadjfile.number")))) continue;
            if (onlyMatchNoSet) {
                String tip = ResManager.loadKDString((String)"{0}\u5df2\u5b58\u5728\u5b9a\u8c03\u85aa\u6863\u6848\uff08{1}\uff09\uff0c\u7533\u8bf7\u5355\u5c06\u4f1a\u4e0e\u4e4b\u5173\u8054\u5e76\u5728\u5ba1\u6279\u901a\u8fc7\u540e\u66f4\u65b0\u6863\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CandidateSetSalApplyService_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
                String conformMsg = MessageFormat.format(tip, personDyn.getString("candidate.name"), matchFileNum);
                candidateMsgMap.put(personDyn, conformMsg);
                continue;
            }
            personDyn.set("salaryadjfile", (Object)CandSetSalApplyRefreshHelper.transToDynmicObj(matchFile.getLong("boid"), matchFileNum, "hcdm_adjfileinfo"));
        }
        return candidateMsgMap;
    }

    public static List<DynamicObject> matchFile(List<DynamicObject> files, Date bsed) {
        if (CollectionUtils.isEmpty(files) || bsed == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        Iterator<DynamicObject> iterator = files.iterator();
        while (iterator.hasNext()) {
            DynamicObject file = iterator.next();
            Date adjFileBsed = file.getDate("bsed");
            Date adjFileBsled = file.getDate("bsled");
            if (bsed.compareTo(adjFileBsed) >= 0 && bsed.compareTo(adjFileBsled) <= 0) continue;
            iterator.remove();
        }
        return files;
    }

    private static Map<String, List<DynamicObject>> clearFileAndQueryFilesByKey(List<DynamicObject> applyDyns, Map<String, DynamicObject> keyPersonDynMap) {
        HashSet<Long> depempIdSet = new HashSet<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashSet<Long> countryIdSet = new HashSet<Long>(16);
        HashSet<Long> stdScmIdSet = new HashSet<Long>(16);
        for (DynamicObject applyDyn : applyDyns) {
            DynamicObjectCollection personDyns = applyDyn.getDynamicObjectCollection("candsetsalperson");
            if (personDyns == null) continue;
            long orgId = applyDyn.getLong("org.id");
            long countryId = applyDyn.getLong("country.id");
            for (DynamicObject personDyn : personDyns) {
                long depempId = personDyn.getLong("depemp.id");
                long stdScmId = personDyn.getLong("stdscmvid.boid");
                if (orgId == 0L || countryId == 0L || depempId == 0L || stdScmId == 0L) continue;
                depempIdSet.add(depempId);
                orgIdSet.add(orgId);
                countryIdSet.add(countryId);
                stdScmIdSet.add(stdScmId);
                keyPersonDynMap.put(AdjFileInfoServiceHelper.buildKey(depempId, orgId, countryId, stdScmId), personDyn);
            }
        }
        if (CollectionUtils.isEmpty(keyPersonDynMap)) {
            return new HashMap<String, List<DynamicObject>>(0);
        }
        return AdjFileInfoServiceHelper.getAdjFileInfoGroupByKeyword(depempIdSet, orgIdSet, countryIdSet, stdScmIdSet);
    }
}

