/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import org.apache.commons.lang.ArrayUtils;

public class CandidateSetSalaryApplInfoGatherService {
    public static final Map<String, String> ONBRDINFO_PERSONENTRY_MAP = Maps.newHashMapWithExpectedSize((int)64);
    public static final Map<String, String> CANDIDATE_SET_SALARY_SHOW_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final Map<String, String> CANDIDATE_SET_SALARY_PERSON_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final Map<String, String> CANDIDATE_SET_SALARY_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final Map<String, String> SHOW_BILL_FIELD_PERSONENTRY_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final Map<String, String> CANEDUEXP_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final Map<String, String> CANOCPQUAL_MAP = Maps.newHashMapWithExpectedSize((int)16);
    public static final List<String> PERSETSALREC_LIST = Lists.newArrayList((Object[])new String[]{"frequency", "grade", "rank", "currency", "amount", "overstandardtype", "salarypercent", "salaryseeprate", "issend", "remark", "salarystd", "coefficient", "salarel"});
    public static final List<String> PERSETSALREC_LIST_STDTABLE_REL = Lists.newArrayList((Object[])new String[]{"frequency", "currency", "grade", "rank", "amount", "overstandardtype", "salarypercent", "salaryseeprate", "salarel"});
    public static final List<String> PERSETSALREC_LIST_COEFFICIENT_REL = Lists.newArrayList((Object[])new String[]{"amount", "overstandardtype", "salarypercent", "salaryseeprate", "coefficient"});

    public static Map<Long, Map<String, DynamicObject>> gatherOnBrdBillInfo(Set<Long> candidateIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)candidateIds.size());
        candidateIds.forEach(aLong -> resultMap.computeIfAbsent(aLong, v1 -> Maps.newHashMapWithExpectedSize((int)64)));
        Object[] onBrdBillDys = CandidateSetSalApplyHelper.getOnBrdBillByCandidateId(candidateIds);
        if (ArrayUtils.isEmpty((Object[])onBrdBillDys)) {
            return resultMap;
        }
        Map<Long, DynamicObject> onBrdBillDysMap = Arrays.stream(onBrdBillDys).collect(Collectors.toMap(dy -> dy.getLong("candidate.id"), dy -> dy, (o1, o2) -> o2));
        DynamicObject[] eduExpDys = CandidateSetSalApplyHelper.getTheHighestEduExp(String.join((CharSequence)",", CANEDUEXP_MAP.keySet()) + ",candidate.id", candidateIds);
        Map<Long, DynamicObject> eduExpDysMap = Arrays.stream(eduExpDys).collect(Collectors.toMap(dy -> dy.getLong("candidate.id"), dy -> dy, (o1, o2) -> o2));
        DynamicObject[] candOcpQualDys = CandidateSetSalApplyHelper.getMainCandOcpQual(String.join((CharSequence)",", CANOCPQUAL_MAP.keySet()) + ",candidate.id", candidateIds);
        Map<Long, DynamicObject> candOcpQualDysMap = Arrays.stream(candOcpQualDys).collect(Collectors.toMap(dy -> dy.getLong("candidate.id"), dy -> dy, (o1, o2) -> o2));
        Map<Long, DynamicObject> candidateIdToDepTypeMap = CandidateSetSalApplyHelper.getAdminOrgDepartmentType((DynamicObject[])onBrdBillDys);
        Map<Long, DynamicObject> candidateIdToIndustryTypeMap = CandidateSetSalApplyHelper.getAdminOrgIndustryType((DynamicObject[])onBrdBillDys);
        for (Map.Entry entry : resultMap.entrySet()) {
            DynamicObject industryTypeDy;
            DynamicObject depTypeDy;
            DynamicObject candOcpQualDy;
            DynamicObject eduExpDy;
            Long candidateId = (Long)entry.getKey();
            DynamicObject onBrdBillDy = onBrdBillDysMap.get(candidateId);
            if (Objects.nonNull(onBrdBillDy)) {
                ((Map)entry.getValue()).put("hom_onbrdinfo", onBrdBillDy);
            }
            if (Objects.nonNull(eduExpDy = eduExpDysMap.get(candidateId))) {
                ((Map)entry.getValue()).put("hcf_caneduexp", eduExpDy);
            }
            if (Objects.nonNull(candOcpQualDy = candOcpQualDysMap.get(candidateId))) {
                ((Map)entry.getValue()).put("hcf_canocpqual", candOcpQualDy);
            }
            if (Objects.nonNull(depTypeDy = candidateIdToDepTypeMap.get(candidateId))) {
                ((Map)entry.getValue()).put("haos_departmenttype", depTypeDy);
            }
            if (!Objects.nonNull(industryTypeDy = candidateIdToIndustryTypeMap.get(candidateId))) continue;
            ((Map)entry.getValue()).put("hbss_industrytype", industryTypeDy);
        }
        return resultMap;
    }

    static {
        ONBRDINFO_PERSONENTRY_MAP.put("candidate", "candidate");
        ONBRDINFO_PERSONENTRY_MAP.put("id", "onbrdinfo");
        ONBRDINFO_PERSONENTRY_MAP.put("picturefield", "avatar");
        ONBRDINFO_PERSONENTRY_MAP.put("dependencytype", "depcytype");
        ONBRDINFO_PERSONENTRY_MAP.put("affiliateadminorg", "adminorg");
        ONBRDINFO_PERSONENTRY_MAP.put("offernumber", "offercode");
        ONBRDINFO_PERSONENTRY_MAP.put("offerid", "offerid");
        ONBRDINFO_PERSONENTRY_MAP.put("recruittype", "recruittype");
        ONBRDINFO_PERSONENTRY_MAP.put("synchstatus", "synchstatus");
        ONBRDINFO_PERSONENTRY_MAP.put("apositiontype", "apositiontype");
        ONBRDINFO_PERSONENTRY_MAP.put("ajoblevel", "joblevel");
        ONBRDINFO_PERSONENTRY_MAP.put("ajobgrade", "jobgrade");
        ONBRDINFO_PERSONENTRY_MAP.put("stdposition", "stdposition");
        ONBRDINFO_PERSONENTRY_MAP.put("ajob", "job");
        ONBRDINFO_PERSONENTRY_MAP.put("ajobscm", "jobscm");
        ONBRDINFO_PERSONENTRY_MAP.put("jobseq", "jobseq");
        ONBRDINFO_PERSONENTRY_MAP.put("jobfamily", "jobfamily");
        ONBRDINFO_PERSONENTRY_MAP.put("postype", "postype");
        ONBRDINFO_PERSONENTRY_MAP.put("laborreltype.laborreltypecls", "laborreltypecls");
        ONBRDINFO_PERSONENTRY_MAP.put("laborreltype", "laborreltype");
        ONBRDINFO_PERSONENTRY_MAP.put("laborrelstatus", "laborrelstatus");
        ONBRDINFO_PERSONENTRY_MAP.put("probationtime", "probationtime");
        ONBRDINFO_PERSONENTRY_MAP.put("perprobationtime", "perprobationtime");
        ONBRDINFO_PERSONENTRY_MAP.put("nationality", "nationality");
        ONBRDINFO_PERSONENTRY_MAP.put("name", "name");
        ONBRDINFO_PERSONENTRY_MAP.put("employeeno", "employeeno");
        ONBRDINFO_PERSONENTRY_MAP.put("aadminorg", "department");
        ONBRDINFO_PERSONENTRY_MAP.put("acompany", "company");
        ONBRDINFO_PERSONENTRY_MAP.put("acompany.industrytype", "industrytype");
        ONBRDINFO_PERSONENTRY_MAP.put("aposition", "position");
        ONBRDINFO_PERSONENTRY_MAP.put("contractlocation", "agreedlocation");
        ONBRDINFO_PERSONENTRY_MAP.put("baselocation", "baselocation");
        ONBRDINFO_PERSONENTRY_MAP.put("isprobation", "isprobation");
        ONBRDINFO_PERSONENTRY_MAP.put("effectdate", "entrydate");
        ONBRDINFO_PERSONENTRY_MAP.put("transdate", "realregulardate");
        ONBRDINFO_PERSONENTRY_MAP.put("dependency", "percountry");
        ONBRDINFO_PERSONENTRY_MAP.put("jobclass", "jobclass");
        ONBRDINFO_PERSONENTRY_MAP.put("aadminorg.city", "departmentcity");
        ONBRDINFO_PERSONENTRY_MAP.put("aadminorg.workplace", "depworkplace");
        ONBRDINFO_PERSONENTRY_MAP.put("aadminorg.departmenttype", "departmenttype");
        CANEDUEXP_MAP.put("graduateschool", "graduateschool");
        CANEDUEXP_MAP.put("graduateschool.collegecharact", "schooltype");
        CANEDUEXP_MAP.put("major", "major");
        CANEDUEXP_MAP.put("educationid", "education");
        CANOCPQUAL_MAP.put("qualificationid", "ocpqual");
        CANOCPQUAL_MAP.put("qualevelid", "pocpquallevel");
        CANDIDATE_SET_SALARY_SHOW_MAP.put("salarystructure", "showsalarystructure");
        CANDIDATE_SET_SALARY_SHOW_MAP.put("salaryadjorg", "org");
        CANDIDATE_SET_SALARY_SHOW_MAP.put("stdscm", "showstdscmvid");
        CANDIDATE_SET_SALARY_PERSON_MAP.put("salarystructure", "salarystructure");
        CANDIDATE_SET_SALARY_PERSON_MAP.put("stdscm", "stdscmvid");
        CANDIDATE_SET_SALARY_PERSON_MAP.put("offerid", "offerid");
        CANDIDATE_SET_SALARY_MAP.put("standarditem", "standarditem");
        CANDIDATE_SET_SALARY_MAP.put("currencyent", "currency");
        CANDIDATE_SET_SALARY_MAP.put("frequency", "frequency");
        CANDIDATE_SET_SALARY_MAP.put("confirmedamount", "amount");
        CANDIDATE_SET_SALARY_MAP.put("issend", "issend");
        CANDIDATE_SET_SALARY_MAP.put("remark", "remark");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("empgroup", "showempgroup");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("escrowstaff", "showescrowstaff");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("depcytype", "showdepcytype");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("adminorg", "showadminorg");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("salarystructure", "showsalarystructure");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("stdscmvid", "showstdscmvid");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("setsalaryeffdt", "showsetsalaryeffdt");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("department", "showdepartment");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("company", "showcompany");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("apositiontype", "showapositiontype");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("job", "showjob");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("joblevel", "showjoblevel");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("jobgrade", "showjobgrade");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("position", "showposition");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("stdposition", "showstdposition");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("jobscm", "showjobscm");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("jobseq", "showjobseq");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("jobfamily", "showjobfamily");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("laborreltype", "showlaborreltype");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("laborrelstatus", "showlaborrelstatus");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("baselocation", "showbaselocation");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("probationtime", "showprobationtime");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("perprobationtime", "showperprobationtime");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("realregulardate", "showrealregulardate");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("entrydate", "showentrydate");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("graduateschool", "showgraduateschool");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("major", "showmajor");
        SHOW_BILL_FIELD_PERSONENTRY_MAP.put("education", "showeducation");
    }
}

