/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandSetSalApplyMatchGradeHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalaryApplInfoGatherService;
import kd.swc.hcdm.common.utils.DateUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class OnBrdInfoPushToCandSetSalApplService {
    private static final Log LOGGER = LogFactory.getLog(OnBrdInfoPushToCandSetSalApplService.class);
    private static final String HOM_ONBRDINFO_KEY = "hom_onbrdinfo";
    private static final String HCDM_SINGLECANDSETSALAPPL_KEY = "hcdm_singlecandsetsalappl";
    private static final String TRANS_DATE = "transdate";
    private static final String DEPARTMENTTYPE = "departmenttype";

    public static List<ListSelectedRow> getListSelectedRowList(List<Long> onBrdInfoIds) {
        if (CollectionUtils.isEmpty(onBrdInfoIds)) {
            return ImmutableList.of();
        }
        ArrayList selectedRows = Lists.newArrayListWithCapacity((int)onBrdInfoIds.size());
        for (Long id : onBrdInfoIds) {
            selectedRows.add(new ListSelectedRow((Object)id));
        }
        return selectedRows;
    }

    public static PushArgs getPushArgs(Map<Long, Long> onBrdInfoIdToActIdMap) {
        if (CollectionUtils.isEmpty(onBrdInfoIdToActIdMap)) {
            return null;
        }
        List<ListSelectedRow> selectedRows = OnBrdInfoPushToCandSetSalApplService.getListSelectedRowList(Lists.newArrayList(onBrdInfoIdToActIdMap.keySet()));
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(HOM_ONBRDINFO_KEY);
        pushArgs.setTargetEntityNumber(HCDM_SINGLECANDSETSALAPPL_KEY);
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.getCustomParams().put("onBrdInfoIdToActIdMap", SerializationUtils.serializeToBase64(onBrdInfoIdToActIdMap));
        return pushArgs;
    }

    public static List<Map<String, Object>> pushToCandSetSalAppl(Map<Long, Long> onBrdInfoIdToActIdMap) {
        if (CollectionUtils.isEmpty(onBrdInfoIdToActIdMap)) {
            return null;
        }
        DynamicObject[] result = CandidateSetSalApplyHelper.getExistCandidateSetSalApplByOnBrdInfoId(onBrdInfoIdToActIdMap.keySet());
        Map<Long, DynamicObject> onBrdInfoIdToCandApplMap = Arrays.stream(result).collect(Collectors.toMap(dy -> ((DynamicObject)dy.getDynamicObjectCollection("candsetsalperson").get(0)).getLong("onbrdinfo"), dy -> dy, (o1, o2) -> o2));
        ArrayList updateResult = Lists.newArrayList();
        boolean saveSuccess = true;
        if (!CollectionUtils.isEmpty(onBrdInfoIdToCandApplMap)) {
            HRBaseServiceHelper CANDSETSALACT_HELPER = new HRBaseServiceHelper("hcdm_candsetsalact");
            HRBaseServiceHelper SINGLECANDSETSALAPPL_HELPER = new HRBaseServiceHelper(HCDM_SINGLECANDSETSALAPPL_KEY);
            for (Map.Entry<Long, DynamicObject> entry : onBrdInfoIdToCandApplMap.entrySet()) {
                Long l = entry.getKey();
                Long actId = onBrdInfoIdToActIdMap.get(l);
                DynamicObject candSetSalActDy = ((DynamicObject)entry.getValue()).getDynamicObject("candsetsalact");
                if (!Objects.isNull(candSetSalActDy)) continue;
                DynamicObject emptyAct = CANDSETSALACT_HELPER.generateEmptyDynamicObject();
                emptyAct.set("id", (Object)actId);
                entry.getValue().set("candsetsalact", (Object)emptyAct);
            }
            try {
                SINGLECANDSETSALAPPL_HELPER.save(onBrdInfoIdToCandApplMap.values().toArray(new DynamicObject[0]));
            }
            catch (Exception exception) {
                LOGGER.error("pushToCandSetSalAppl, update candsetsalact fail and exception is", (Throwable)exception);
                saveSuccess = false;
                for (Map.Entry entry : onBrdInfoIdToCandApplMap.entrySet()) {
                    HashMap dataRes = Maps.newHashMapWithExpectedSize((int)4);
                    dataRes.put("onbrdinfoid", entry.getKey());
                    dataRes.put("success", Boolean.FALSE);
                    dataRes.put("message", exception.getMessage());
                    dataRes.put("candsetsalapplid", null);
                    dataRes.put("candsetsalapplnum", null);
                    updateResult.add(dataRes);
                }
            }
            if (saveSuccess) {
                for (Map.Entry<Long, DynamicObject> entry : onBrdInfoIdToCandApplMap.entrySet()) {
                    HashMap hashMap = Maps.newHashMapWithExpectedSize((int)4);
                    hashMap.put("onbrdinfoid", entry.getKey());
                    hashMap.put("success", Boolean.TRUE);
                    hashMap.put("message", null);
                    hashMap.put("candsetsalapplid", entry.getValue().getLong("id"));
                    hashMap.put("candsetsalapplnum", entry.getValue().getString("billno"));
                    hashMap.put("billstatus", entry.getValue().getString("billstatus"));
                    updateResult.add(hashMap);
                }
            }
        }
        Map<Object, Object> newOnBrdInfoIdToActIdMap = Maps.newHashMapWithExpectedSize((int)onBrdInfoIdToActIdMap.size());
        if (CollectionUtils.isEmpty(onBrdInfoIdToCandApplMap)) {
            newOnBrdInfoIdToActIdMap = onBrdInfoIdToActIdMap;
        } else {
            for (Map.Entry entry : onBrdInfoIdToActIdMap.entrySet()) {
                Long onBrdInfoId = (Long)entry.getKey();
                if (onBrdInfoIdToCandApplMap.containsKey(onBrdInfoId)) continue;
                newOnBrdInfoIdToActIdMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (CollectionUtils.isEmpty((Map)newOnBrdInfoIdToActIdMap)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)updateResult.size());
            resultList.addAll(updateResult);
            return resultList;
        }
        PushArgs pushArgs = OnBrdInfoPushToCandSetSalApplService.getPushArgs((Map<Long, Long>)newOnBrdInfoIdToActIdMap);
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)newOnBrdInfoIdToActIdMap.size());
        try {
            ConvertOperationResult convertOperationResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            boolean bl = convertOperationResult.isSuccess();
            if (bl) {
                Set targetBillIds = convertOperationResult.getTargetBillIds();
                Map<Long, DynamicObject> onBrdInfoIdToCandidateSetSalApplMap = CandidateSetSalApplyHelper.getOnBrdInfoIdToCandidateSetSalApplMapByApplId(targetBillIds);
                for (Map.Entry<Object, Object> entry : newOnBrdInfoIdToActIdMap.entrySet()) {
                    HashMap dataRes = Maps.newHashMapWithExpectedSize((int)4);
                    dataRes.put("onbrdinfoid", entry.getKey());
                    dataRes.put("success", Boolean.TRUE);
                    dataRes.put("message", null);
                    dataRes.put("candsetsalapplid", onBrdInfoIdToCandidateSetSalApplMap.get(entry.getKey()).getLong("id"));
                    dataRes.put("candsetsalapplnum", onBrdInfoIdToCandidateSetSalApplMap.get(entry.getKey()).getString("billno"));
                    dataRes.put("billstatus", onBrdInfoIdToCandidateSetSalApplMap.get(entry.getKey()).getString("billstatus"));
                    arrayList.add(dataRes);
                }
            } else {
                List billReports = convertOperationResult.getBillReports();
                Map<Long, SourceBillReport> map = billReports.stream().collect(Collectors.toMap(billReport -> Long.valueOf(String.valueOf(billReport.getBillId())), billReport -> billReport, (o1, o2) -> o2));
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    HashMap dataRes = Maps.newHashMapWithExpectedSize((int)4);
                    dataRes.put("onbrdinfoid", entry.getKey());
                    dataRes.put("success", ((SourceBillReport)entry.getValue()).isSuccess());
                    dataRes.put("message", String.join((CharSequence)",", ((SourceBillReport)entry.getValue()).getFailMessages()));
                    dataRes.put("candsetsalapplid", null);
                    dataRes.put("candsetsalapplnum", null);
                    dataRes.put("billstatus", null);
                    arrayList.add(dataRes);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("pushToCandSetSalAppl, pushAndSave fail and exception is", (Throwable)exception);
            for (Map.Entry<Object, Object> entry : newOnBrdInfoIdToActIdMap.entrySet()) {
                HashMap dataRes = Maps.newHashMapWithExpectedSize((int)4);
                dataRes.put("onbrdinfoid", entry.getKey());
                dataRes.put("success", Boolean.FALSE);
                dataRes.put("message", ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"OnBrdInfoPushToCandSetSalApplService_1", (String)"swc-hcdm-business", (Object[])new Object[0]));
                dataRes.put("candsetsalapplid", null);
                dataRes.put("candsetsalapplnum", null);
                dataRes.put("billstatus", null);
                arrayList.add(dataRes);
            }
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)(updateResult.size() + arrayList.size()));
        resultList.addAll(updateResult);
        resultList.addAll(arrayList);
        return resultList;
    }

    public static Map<Long, DynamicObject> generateFullCandSetSalAppl(Map<Long, DynamicObject> candSetSalApplyMap) {
        LOGGER.info("[candbotp] originDynamicObjectMap id is [{}], generateFullCandSetSalAppl begin", candSetSalApplyMap.keySet());
        HashSet candidateIds = Sets.newHashSetWithExpectedSize((int)candSetSalApplyMap.size());
        HashSet onBrdInfoIdSet = Sets.newHashSetWithExpectedSize((int)candSetSalApplyMap.size());
        HashSet salStructIdSet = Sets.newHashSetWithExpectedSize((int)candSetSalApplyMap.size());
        HashSet stdScmIdSet = Sets.newHashSetWithExpectedSize((int)candSetSalApplyMap.size());
        OnBrdInfoPushToCandSetSalApplService.colletIds(candSetSalApplyMap, candidateIds, onBrdInfoIdSet, salStructIdSet, stdScmIdSet);
        HashMap structAndBoidScmMap = Maps.newHashMapWithExpectedSize((int)salStructIdSet.size());
        HashMap scmBoidToVersionDynMap = Maps.newHashMapWithExpectedSize((int)salStructIdSet.size());
        CandSetSalApplyMatchGradeHelper.queryAndTransToStdScmMap(salStructIdSet, stdScmIdSet, structAndBoidScmMap, scmBoidToVersionDynMap);
        Map<Long, Map<String, DynamicObject>> candIdRelEntityMap = CandidateSetSalaryApplInfoGatherService.gatherOnBrdBillInfo(candidateIds);
        List<DynamicObject> onBrdInfoDyList = candIdRelEntityMap.values().stream().map(map -> (DynamicObject)map.get(HOM_ONBRDINFO_KEY)).collect(Collectors.toList());
        Map<Long, DynamicObject> candidateSetSalaryInfoMap = CandidateSetSalApplyHelper.getCandidateSetSalaryInfoMapByOnBrdInfos(onBrdInfoDyList);
        Map<Long, Long> adminAndStrategyOrgIdMap = OnBrdInfoPushToCandSetSalApplService.getAdminOrgByCSStrategy(onBrdInfoDyList);
        LOGGER.info("[candbotp] OnBrdInfoPushToCandSetSalApplService buMap = {}", adminAndStrategyOrgIdMap);
        Map<Long, Long> onBrdInfoIdToDepEmpIdMap = CandidateSetSalApplyHelper.getDepEmpIdByOnBrdBillId(onBrdInfoIdSet);
        HashSet hasOfferCandidateIds = Sets.newHashSetWithExpectedSize((int)candSetSalApplyMap.size());
        for (Map.Entry<Long, DynamicObject> entry : candSetSalApplyMap.entrySet()) {
            DynamicObject applyDyn = entry.getValue();
            DynamicObjectCollection personEnties = applyDyn.getDynamicObjectCollection("candsetsalperson");
            if (CollectionUtils.isEmpty((Collection)personEnties)) continue;
            DynamicObject personEntry = (DynamicObject)personEnties.get(0);
            long candidateId = personEntry.getLong("candidate.id");
            Map<String, DynamicObject> entityDynamicObjectMap = candIdRelEntityMap.get(candidateId);
            DynamicObject onBrdBill = entityDynamicObjectMap.get(HOM_ONBRDINFO_KEY);
            DynamicObject eduExpDy = entityDynamicObjectMap.get("hcf_caneduexp");
            DynamicObject candOcpQualDy = entityDynamicObjectMap.get("hcf_canocpqual");
            DynamicObject departmentTypeDy = entityDynamicObjectMap.get("haos_departmenttype");
            DynamicObject industryTypeDy = entityDynamicObjectMap.get("hbss_industrytype");
            personEntry.set(DEPARTMENTTYPE, (Object)departmentTypeDy);
            personEntry.set("industrytype", (Object)industryTypeDy);
            personEntry.set("realregulardate", (Object)DateUtils.setTransDate((DynamicObject)onBrdBill));
            OnBrdInfoPushToCandSetSalApplService.fillDepEmpId(onBrdBill, onBrdInfoIdToDepEmpIdMap, personEntry);
            OnBrdInfoPushToCandSetSalApplService.fillEduExpInfo(eduExpDy, personEntry);
            OnBrdInfoPushToCandSetSalApplService.fillCandOcpQualInfo(candOcpQualDy, personEntry);
            CandidateSetSalApplyHelper.fillEscrowStaff(personEntry);
            DynamicObject candidateSetSalaryInfoDy = candidateSetSalaryInfoMap.get(candidateId);
            if (Objects.nonNull(candidateSetSalaryInfoDy)) {
                LOGGER.info("[candbotp] candidateSetSalaryInfoDy is not null...");
                OnBrdInfoPushToCandSetSalApplService.fillOrgByOffer(candidateSetSalaryInfoDy, applyDyn);
                OnBrdInfoPushToCandSetSalApplService.fillSalaryAdjRsnByOffer(candidateSetSalaryInfoDy, applyDyn);
                OnBrdInfoPushToCandSetSalApplService.fillSalStructAndScmByOffer(candidateSetSalaryInfoDy, personEntry);
                OnBrdInfoPushToCandSetSalApplService.fillCountryByOfferStruct(candidateSetSalaryInfoDy, applyDyn);
                OnBrdInfoPushToCandSetSalApplService.fillItemInfoByOffer(candidateSetSalaryInfoDy, personEntry);
                hasOfferCandidateIds.add(candidateId);
                continue;
            }
            LOGGER.info("[candbotp] candidateSetSalaryInfoDy is null...");
            OnBrdInfoPushToCandSetSalApplService.fillOrgByCSStrategy(adminAndStrategyOrgIdMap, onBrdBill, applyDyn);
            CandSetSalApplyMatchGradeHelper.fillSalStructAndScm(personEntry, structAndBoidScmMap, scmBoidToVersionDynMap);
            OnBrdInfoPushToCandSetSalApplService.fillItemInfo(personEntry);
        }
        CandSetSalApplyMatchGradeHelper.matchStdTable(candSetSalApplyMap.values(), hasOfferCandidateIds);
        return candSetSalApplyMap;
    }

    private static void colletIds(Map<Long, DynamicObject> candSetSalApplyMap, Set<Long> candidateIds, Set<Long> onBrdInfoIdSet, Set<Long> salStructIdSet, Set<Long> stdScmIdSet) {
        for (Map.Entry<Long, DynamicObject> entry : candSetSalApplyMap.entrySet()) {
            Long stcScmId;
            DynamicObject applyDyn = entry.getValue();
            DynamicObjectCollection personDyns = applyDyn.getDynamicObjectCollection("candsetsalperson");
            DynamicObject personDyn = (DynamicObject)personDyns.get(0);
            candidateIds.add(personDyn.getLong("candidate.id"));
            onBrdInfoIdSet.add(personDyn.getLong("onbrdinfo"));
            Long structId = personDyn.getLong("salarystructure.id");
            if (structId != null && structId != 0L) {
                salStructIdSet.add(structId);
            }
            if ((stcScmId = Long.valueOf(personDyn.getLong("stdscmvid.id"))) == null || stcScmId == 0L) continue;
            stdScmIdSet.add(stcScmId);
        }
    }

    private static void fillItemInfo(DynamicObject personEntry) {
        if (!CandidateSetSalApplyHelper.isCanAddItem(personEntry)) {
            return;
        }
        DynamicObject applySalStructDyn = personEntry.getDynamicObject("salarystructure");
        DynamicObject stdScmVidDyn = personEntry.getDynamicObject("stdscmvid");
        Date setSalDate = personEntry.getDate("setsalaryeffdt");
        Long applySalStructId = applySalStructDyn.getLong("id");
        DynamicObjectCollection personRecordDys = personEntry.getDynamicObjectCollection("persetsalrec");
        personRecordDys.clear();
        DynamicObjectCollection scmItemEntry = stdScmVidDyn.getDynamicObjectCollection("entryentity");
        int index = 0;
        for (DynamicObject itemDyn : scmItemEntry) {
            Long structId = itemDyn.getLong("salstructurent.id");
            if (!applySalStructId.equals(structId)) continue;
            DynamicObject emptyRecord = personRecordDys.addNew();
            emptyRecord.set("seq", (Object)(++index));
            emptyRecord.set("itembsled", (Object)CandidateSetSalApplyHelper.getMaxBsled());
            emptyRecord.set("itembsed", (Object)setSalDate);
            emptyRecord.set("standarditem", (Object)itemDyn.getDynamicObject("standarditem"));
        }
    }

    private static void fillSalStructAndScmByOffer(DynamicObject candidateSetSalaryInfoDy, DynamicObject personEntry) {
        for (Map.Entry<String, String> entry1 : CandidateSetSalaryApplInfoGatherService.CANDIDATE_SET_SALARY_PERSON_MAP.entrySet()) {
            personEntry.set(entry1.getValue(), candidateSetSalaryInfoDy.get(entry1.getKey()));
        }
    }

    private static Map<Long, Long> getAdminOrgByCSStrategy(List<DynamicObject> onBrdInfoDyList) {
        HashMap adminAndStrategyOrgIdMap = null;
        Set aAdminOrgIdSet = onBrdInfoDyList.stream().map(dy -> dy.getLong("aadminorg.boid")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(aAdminOrgIdSet)) {
            HashMap orgId2BusinessType = Maps.newHashMapWithExpectedSize((int)aAdminOrgIdSet.size());
            for (Long aAdminOrgId : aAdminOrgIdSet) {
                orgId2BusinessType.put(aAdminOrgId, Sets.newHashSet((Object[])new Long[]{107020L}));
            }
            LOGGER.info("OnBrdInfoPushToCandSetSalApplService getHrBuByBusinessType pram= {}", (Object)orgId2BusinessType);
            List result = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, 1010L});
            LOGGER.info("OnBrdInfoPushToCandSetSalApplService getHrBuByBusinessType result= {}", (Object)result);
            if (!CollectionUtils.isEmpty((Collection)result)) {
                adminAndStrategyOrgIdMap = Maps.newHashMapWithExpectedSize((int)result.size());
                for (Map map : result) {
                    adminAndStrategyOrgIdMap.put(map.get("adminOrgId"), map.get("hrBuId"));
                }
            }
        }
        return adminAndStrategyOrgIdMap;
    }

    private static void fillItemInfoByOffer(DynamicObject candidateSetSalaryInfoDy, DynamicObject personEntry) {
        DynamicObjectCollection candidateRecords = candidateSetSalaryInfoDy.getDynamicObjectCollection("entryentity");
        List sortCandidateRecords = candidateRecords.stream().sorted(Comparator.comparing(dy -> dy.getInt("seq")).thenComparing(dy -> dy.getLong("id"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sortCandidateRecords)) {
            DynamicObjectCollection personRecordDys = personEntry.getDynamicObjectCollection("persetsalrec");
            for (int i = 0; i < sortCandidateRecords.size(); ++i) {
                DynamicObject candidateRecord = (DynamicObject)sortCandidateRecords.get(i);
                DynamicObject emptyRecord = personRecordDys.addNew();
                emptyRecord.set("seq", (Object)(i + 1));
                for (Map.Entry<String, String> mapEntry : CandidateSetSalaryApplInfoGatherService.CANDIDATE_SET_SALARY_MAP.entrySet()) {
                    emptyRecord.set(mapEntry.getValue(), candidateRecord.get(mapEntry.getKey()));
                }
                emptyRecord.set("itembsled", (Object)CandidateSetSalApplyHelper.getMaxBsled());
                emptyRecord.set("itembsed", (Object)personEntry.getDate("setsalaryeffdt"));
                emptyRecord.set("iskeepamount", (Object)true);
            }
        }
    }

    private static void fillCountryByOfferStruct(DynamicObject candidateSetSalaryInfoDy, DynamicObject applyDyn) {
        DynamicObject salaryStructureDy = candidateSetSalaryInfoDy.getDynamicObject("salarystructure");
        DynamicObject countryDyFromSalaryStructure = salaryStructureDy.getDynamicObject("country");
        applyDyn.set("country", (Object)countryDyFromSalaryStructure);
    }

    private static void fillSalaryAdjRsnByOffer(DynamicObject candidateSetSalaryInfoDy, DynamicObject applyDyn) {
        LOGGER.info("kd/swc/hcdm/business/candidatesetsalaryappl/OnBrdInfoPushToCandSetSalApplService.salarytype{}", (Object)candidateSetSalaryInfoDy.getString("salarytype"));
        if (StringUtils.isNotEmpty((String)candidateSetSalaryInfoDy.getString("salarytype"))) {
            HRBaseServiceHelper salaryAdjustrsnServiceHelper = new HRBaseServiceHelper("hsbs_salaryadjustrsn");
            DynamicObject salaryadjustrsnDy = salaryAdjustrsnServiceHelper.generateEmptyDynamicObject();
            salaryadjustrsnDy.set("id", (Object)Long.valueOf(candidateSetSalaryInfoDy.getString("salarytype")));
            applyDyn.set("salaryadjrsn", (Object)salaryadjustrsnDy);
        }
    }

    private static void fillOrgByOffer(DynamicObject candidateSetSalaryInfoDy, DynamicObject applyDyn) {
        DynamicObject salaryAdjOrg = candidateSetSalaryInfoDy.getDynamicObject("salaryadjorg");
        if (Objects.nonNull(salaryAdjOrg)) {
            applyDyn.set("org", (Object)salaryAdjOrg);
        }
    }

    private static void fillOrgByCSStrategy(Map<Long, Long> adminAndStrategyOrgIdMap, DynamicObject onBrdBill, DynamicObject applyDyn) {
        if (adminAndStrategyOrgIdMap != null && !adminAndStrategyOrgIdMap.isEmpty()) {
            long aadminOrgId = onBrdBill.getLong("aadminorg.boid");
            Long buId = adminAndStrategyOrgIdMap.get(aadminOrgId);
            applyDyn.set("org", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("bos_org", buId));
        }
    }

    private static void fillCandOcpQualInfo(DynamicObject candOcpQualDy, DynamicObject personEntry) {
        if (Objects.nonNull(candOcpQualDy)) {
            for (Map.Entry<String, String> ocpQualMapEntry : CandidateSetSalaryApplInfoGatherService.CANOCPQUAL_MAP.entrySet()) {
                DynamicProperty property = personEntry.getDynamicObjectType().getProperty(ocpQualMapEntry.getValue());
                if (property instanceof BasedataProp) {
                    personEntry.set(ocpQualMapEntry.getValue(), (Object)candOcpQualDy.getDynamicObject(ocpQualMapEntry.getKey()));
                    continue;
                }
                personEntry.set(ocpQualMapEntry.getValue(), candOcpQualDy.get(ocpQualMapEntry.getKey()));
            }
        }
    }

    private static void fillEduExpInfo(DynamicObject eduExpDy, DynamicObject personEntry) {
        if (Objects.nonNull(eduExpDy)) {
            for (Map.Entry<String, String> eduExpMapEntry : CandidateSetSalaryApplInfoGatherService.CANEDUEXP_MAP.entrySet()) {
                DynamicProperty property = personEntry.getDynamicObjectType().getProperty(eduExpMapEntry.getValue());
                if (property instanceof BasedataProp) {
                    personEntry.set(eduExpMapEntry.getValue(), (Object)eduExpDy.getDynamicObject(eduExpMapEntry.getKey()));
                    continue;
                }
                if (property instanceof MulBasedataProp) {
                    DynamicObjectCollection tempSchoolCharacters = eduExpDy.getDynamicObjectCollection(eduExpMapEntry.getKey());
                    DynamicObjectCollection schoolTypeDys = personEntry.getDynamicObjectCollection(eduExpMapEntry.getValue());
                    if (!CollectionUtils.isEmpty((Collection)tempSchoolCharacters)) {
                        for (DynamicObject tempSchoolCharacter : tempSchoolCharacters) {
                            DynamicObject schoolTypeDy = schoolTypeDys.addNew();
                            schoolTypeDy.set("fbasedataid_id", (Object)tempSchoolCharacter.getLong("fbasedataid_id"));
                        }
                        personEntry.set(eduExpMapEntry.getValue(), (Object)schoolTypeDys);
                        continue;
                    }
                    personEntry.set(eduExpMapEntry.getValue(), (Object)schoolTypeDys);
                    continue;
                }
                personEntry.set(eduExpMapEntry.getValue(), eduExpDy.get(eduExpMapEntry.getKey()));
            }
        }
    }

    private static void fillDepEmpId(DynamicObject onBrdBill, Map<Long, Long> onBrdInfoIdToDepEmpIdMap, DynamicObject personEntry) {
        Long depEmpId;
        String enrollStatus = onBrdBill.getString("enrollstatus");
        if ("3".equals(enrollStatus) && Objects.nonNull(depEmpId = onBrdInfoIdToDepEmpIdMap.get(personEntry.getLong("onbrdinfo"))) && depEmpId != 0L) {
            personEntry.set("depemp", (Object)CandSetSalApplyMatchGradeHelper.buildDynWithId("hrpi_depemp", depEmpId));
        }
    }
}

