/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.export;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.export.ChangeInfoExportConfig;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshService;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.export.ExportHelper;
import kd.swc.hcdm.business.export.HeaderInfo;
import kd.swc.hsbp.common.cache.SWCPageCache;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ChangeInfoExportTask
implements Runnable {
    protected static final Log logger = LogFactory.getLog(ChangeInfoExportTask.class);
    public static final String ACTION_PREPAREDATA = "prepareData";
    public static final String ACTION_EXPORTDATA = "exportdata";
    private final RequestContext reqContext;
    private final ChangeInfoExportConfig conf;
    private final String action;

    public ChangeInfoExportTask(RequestContext reqContext, ChangeInfoExportConfig conf, String action) {
        this.reqContext = reqContext;
        this.conf = conf;
        this.action = action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            RequestContext.copyAndSet((RequestContext)this.reqContext);
            switch (this.action) {
                case "prepareData": {
                    logger.info("ChangeInfoExportTask run prepareData start...");
                    this.prepareData();
                    logger.info("ChangeInfoExportTask run prepareData end...");
                    return;
                }
                case "exportdata": {
                    logger.info("ChangeInfoExportTask run exportData start...");
                    this.exportData();
                    logger.info("ChangeInfoExportTask run exportData end...");
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            logger.error("ChangeInfoExportTask run error + {} ; msg: {}", (Object)this.action, (Object)e);
            this.closeProgress("", "ChangeInfoExportTask run error: " + e.getMessage());
            return;
        }
        finally {
            RequestContext.set(null);
        }
    }

    protected void prepareData() {
        List<Long> applyIds = this.conf.getIds();
        if (CollectionUtils.isEmpty(applyIds)) {
            return;
        }
        this.feedbackProgress(0);
        List partition = Lists.partition(applyIds, (int)this.conf.getPageSize());
        for (List ids : partition) {
            Map<Long, DynamicObject> applyMap = this.queryData(ids);
            Map<Long, RefreshResult> resultMap = CandSetSalApplyRefreshService.validateAndRefreshPersonByApplies(Lists.newArrayList(applyMap.values()));
            this.packageData(ids, applyMap, resultMap);
        }
        this.conf.setPrepareComplete(true);
    }

    protected void exportData() throws InterruptedException {
        String fileName = this.conf.getFileName();
        SXSSFWorkbook wb = new SXSSFWorkbook(this.conf.getPageSize());
        SXSSFSheet sheet = wb.createSheet();
        sheet.setRandomAccessWindowSize(-1);
        wb.setSheetName(0, fileName);
        List<HeaderInfo> headList = this.conf.getHeader();
        int headIndex = ExportHelper.writeHeader(wb, sheet, headList);
        int startIndex = headIndex + 1;
        int timeout = 0;
        LinkedBlockingQueue<Map<String, Object>> dataQueue = this.conf.getDataQueue();
        while (!this.conf.isPrepareComplete() || !dataQueue.isEmpty()) {
            if (timeout > 5) {
                logger.info("ChangeInfoExportTask exportData time out");
                break;
            }
            ArrayList dataList = Lists.newArrayListWithExpectedSize((int)this.conf.getPageSize());
            Map<String, Object> data = dataQueue.poll(5L, TimeUnit.SECONDS);
            if (null == data || data.isEmpty()) {
                logger.info("ChangeInfoExportTask exportData ...read...null");
                ++timeout;
                continue;
            }
            dataList.add(data);
            dataQueue.drainTo(dataList, this.conf.getPageSize());
            timeout = 0;
            ExportHelper.writeData(wb, sheet, startIndex, dataList, headList);
            this.feedbackProgress((startIndex += dataList.size()) - headIndex - 1);
        }
        this.flushAll(sheet, fileName);
    }

    protected void packageData(List<Long> ids, Map<Long, DynamicObject> applyDynMap, Map<Long, RefreshResult> resultMap) {
        if (CollectionUtils.isEmpty(applyDynMap)) {
            return;
        }
        if (CollectionUtils.isEmpty(resultMap)) {
            resultMap = new HashMap<Long, RefreshResult>(0);
        }
        LinkedBlockingQueue<Map<String, Object>> dataQueues = this.conf.getDataQueue();
        for (Long applyId : ids) {
            DynamicObjectCollection personDyns;
            DynamicObject applyDyn = applyDynMap.get(applyId);
            if (applyDyn == null || CollectionUtils.isEmpty((Collection)(personDyns = applyDyn.getDynamicObjectCollection("candsetsalperson")))) continue;
            for (DynamicObject personDyn : personDyns) {
                LinkedHashMap dataMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
                long personDynId = personDyn.getLong("id");
                RefreshResult result = resultMap.get(personDynId);
                dataMap.put("billNum", applyDyn.getString("billno"));
                dataMap.put("candNum", personDyn.getString("candidate.number"));
                dataMap.put("name", personDyn.getString("candidate.name"));
                dataMap.put("isChange", result != null && result.isChange());
                dataMap.put("changeMsg", CandSetSalApplyRefreshHelper.getMsgFromRefreshResult(result));
                dataQueues.add(dataMap);
            }
        }
    }

    protected Map<Long, DynamicObject> queryData(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
        DynamicObject[] applyDyns = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)});
        if (applyDyns == null) {
            return Maps.newHashMapWithExpectedSize((int)ids.size());
        }
        HashMap applyMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        for (DynamicObject applyDyn : applyDyns) {
            applyMap.put(applyDyn.getLong("id"), applyDyn);
        }
        return applyMap;
    }

    private void feedbackProgress(int complete) {
        SWCPageCache pageCache = new SWCPageCache(this.conf.getProgressView());
        long total = this.conf.getIds().size();
        double percent = (double)complete * 100.0 / (double)total;
        if (percent >= 100.0) {
            percent = 99.0;
        }
        pageCache.put("total", (Object)this.conf.getIds().size());
        pageCache.put("complete", (Object)complete);
        pageCache.put("progress", (Object)((int)percent));
        pageCache.saveChanges();
    }

    private void flushAll(SXSSFSheet sheet, String fileName) {
        String url = ExportHelper.storeFile((Workbook)sheet.getWorkbook(), fileName, "changeInfo");
        this.closeProgress(url, "");
    }

    private void closeProgress(String url, String errorMsg) {
        SWCPageCache paCache = new SWCPageCache(this.conf.getProgressView());
        paCache.put("url", (Object)url);
        paCache.put("progress", (Object)100);
        if (!StringUtils.isEmpty((Object)errorMsg)) {
            paCache.put("errorMsg", (Object)errorMsg);
        }
        paCache.saveChanges();
    }
}

