/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.ItemEntryClearRefresher;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.ItemEntrySetSalRefresher;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.ItemEntryStdTableInfoRefresher;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.PersonEntryAdminOrgRefresher;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.PersonEntryEduExpRefresher;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.PersonEntryOnbrdRefresher;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.api.ICandSetSalApplyRefresher;

public class CandSetSalApplyRefreshService {
    private static final Log LOGGER = LogFactory.getLog(CandSetSalApplyRefreshService.class);

    public static RefreshResult validateAndRefreshPersonByApply(DynamicObject applyDyn) {
        if (applyDyn == null) {
            return null;
        }
        Map<Long, RefreshResult> resultMap = CandSetSalApplyRefreshService.validateAndRefreshPersonByApplies(Lists.newArrayList((Object[])new DynamicObject[]{applyDyn}));
        if (resultMap == null || resultMap.size() == 0) {
            return null;
        }
        DynamicObjectCollection personDyns = applyDyn.getDynamicObjectCollection("candsetsalperson");
        if (personDyns == null || personDyns.size() == 0) {
            return null;
        }
        return resultMap.get(((DynamicObject)personDyns.get(0)).getLong("id"));
    }

    public static Map<Long, RefreshResult> validateAndRefreshPersonByApplies(List<DynamicObject> applyDyns) {
        if (CollectionUtils.isEmpty(applyDyns)) {
            return null;
        }
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)applyDyns.size());
        List<DynamicObject> canRefreshApplys = CandSetSalApplyRefreshHelper.filterCanRefreshApplies(applyDyns, resultMap);
        if (CollectionUtils.isEmpty(canRefreshApplys)) {
            return resultMap;
        }
        Map<Long, RefreshResult> refreshResultMap = CandSetSalApplyRefreshService.refreshPersonByPersons(CandSetSalApplyRefreshService.getPointEntry(canRefreshApplys, "candsetsalperson"));
        if (!CollectionUtils.isEmpty(refreshResultMap)) {
            resultMap.putAll(refreshResultMap);
        }
        return resultMap;
    }

    public static Map<Long, RefreshResult> refreshPersonAndItemByApplies(List<DynamicObject> applyDyns) {
        List<DynamicObject> personDyns = CandSetSalApplyRefreshService.getPointEntry(applyDyns, "candsetsalperson");
        if (personDyns == null || personDyns.size() == 0) {
            return null;
        }
        Map<Long, RefreshResult> resultMap = CandSetSalApplyRefreshService.refreshPersonByPersons(personDyns);
        if (resultMap == null || resultMap.size() == 0) {
            return null;
        }
        CandSetSalApplyRefreshService.refreshItemByPersons(CandSetSalApplyRefreshService.getChangedDyns(personDyns, resultMap));
        return resultMap;
    }

    public static Map<Long, RefreshResult> refreshPersonByPersons(List<DynamicObject> personDyns) {
        return CandSetSalApplyRefreshService.doRefresh(personDyns, CandSetSalApplyRefreshService.getPersonInfoRefresherList());
    }

    private static Map<Long, RefreshResult> refreshItemByPersons(List<DynamicObject> personDys) {
        return CandSetSalApplyRefreshService.refreshItemByItems(CandSetSalApplyRefreshService.getPointEntry(personDys, "persetsalrec"));
    }

    private static Map<Long, RefreshResult> refreshItemByItems(List<DynamicObject> itemDys) {
        return CandSetSalApplyRefreshService.doRefresh(itemDys, CandSetSalApplyRefreshService.getItemSetSalRefresherList());
    }

    private static Map<Long, RefreshResult> doRefresh(List<DynamicObject> targetDyns, List<ICandSetSalApplyRefresher> refresherList) {
        if (targetDyns == null || refresherList == null) {
            LOGGER.info("CandSetSalApplyRefreshService doRefresh targetDyns or refresherList is null...");
            return null;
        }
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<Long, RefreshResult> lastResultMap = null;
        for (int i = 0; i < refresherList.size(); ++i) {
            ICandSetSalApplyRefresher refresher = refresherList.get(i);
            if (i != 0 && refresher.isOnlyRefreshLastChangedData()) {
                List<DynamicObject> newTargetDyns = CandSetSalApplyRefreshService.getChangedDyns(targetDyns, lastResultMap);
                if (newTargetDyns == null || newTargetDyns.size() == 0) break;
                targetDyns = newTargetDyns;
            }
            lastResultMap = refresher.refresh(targetDyns);
            resultMap = CandSetSalApplyRefreshService.poolResult(resultMap, lastResultMap);
        }
        return resultMap;
    }

    private static List<DynamicObject> getChangedDyns(List<DynamicObject> targetDyns, Map<Long, RefreshResult> resultMap) {
        if (CollectionUtils.isEmpty(targetDyns) || CollectionUtils.isEmpty(resultMap)) {
            return null;
        }
        ArrayList newTargetDyns = Lists.newArrayListWithExpectedSize((int)targetDyns.size());
        for (DynamicObject targetDyn : targetDyns) {
            long id = targetDyn.getLong("id");
            RefreshResult result = resultMap.get(id);
            if (result == null || !result.isChange()) continue;
            newTargetDyns.add(targetDyn);
        }
        return newTargetDyns;
    }

    private static List<DynamicObject> getPointEntry(List<DynamicObject> dyns, String entryKey) {
        if (CollectionUtils.isEmpty(dyns)) {
            return null;
        }
        ArrayList entities = Lists.newArrayListWithExpectedSize((int)dyns.size());
        for (DynamicObject dyn : dyns) {
            DynamicObjectCollection entryColl = dyn.getDynamicObjectCollection(entryKey);
            if (entryColl == null || entryColl.size() == 0) continue;
            entities.addAll(entryColl);
        }
        return entities;
    }

    private static List<ICandSetSalApplyRefresher> getItemSetSalRefresherList() {
        ArrayList refresherList = Lists.newArrayListWithExpectedSize((int)10);
        refresherList.add(new ItemEntrySetSalRefresher());
        refresherList.add(new ItemEntryStdTableInfoRefresher());
        refresherList.add(new ItemEntryClearRefresher());
        return refresherList;
    }

    private static List<ICandSetSalApplyRefresher> getPersonInfoRefresherList() {
        ArrayList refresherList = Lists.newArrayListWithExpectedSize((int)10);
        refresherList.add(new PersonEntryOnbrdRefresher());
        refresherList.add(new PersonEntryAdminOrgRefresher());
        refresherList.add(new PersonEntryEduExpRefresher());
        return refresherList;
    }

    private static Map<Long, RefreshResult> poolResult(Map<Long, RefreshResult> oldResultMap, Map<Long, RefreshResult> newResultMap) {
        if (CollectionUtils.isEmpty(oldResultMap)) {
            return newResultMap;
        }
        if (CollectionUtils.isEmpty(newResultMap)) {
            return oldResultMap;
        }
        for (Map.Entry<Long, RefreshResult> resultEntry : newResultMap.entrySet()) {
            Long key = resultEntry.getKey();
            RefreshResult newResult = resultEntry.getValue();
            RefreshResult oldResult = oldResultMap.get(key);
            oldResult.add(newResult);
        }
        return oldResultMap;
    }
}

