/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.candidatesetsalaryappl.export.ChangeInfoExportTask;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.FieldChangeInfo;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDateUtils;
import org.apache.commons.lang3.StringUtils;

public class FieldCompareHelper {
    protected static final Log logger = LogFactory.getLog(ChangeInfoExportTask.class);

    public static void compareIntegerProp(Object oldVal, Object newVal, FieldChangeInfo changeInfo) {
        Integer newShowValue;
        Integer oldShowValue = oldVal == null ? Integer.valueOf(0) : (Integer)oldVal;
        Integer n = newShowValue = newVal == null ? Integer.valueOf(0) : (Integer)newVal;
        if (oldShowValue.compareTo(newShowValue) != 0) {
            changeInfo.setChange(true);
            changeInfo.setOldValue(oldShowValue.toString());
            changeInfo.setNewValue(newShowValue.toString());
        }
    }

    public static void compareDecimalProp(Object oldVal, Object newVal, FieldChangeInfo changeInfo) {
        BigDecimal newShowValue;
        BigDecimal oldShowValue = oldVal == null ? BigDecimal.ZERO : (BigDecimal)oldVal;
        BigDecimal bigDecimal = newShowValue = newVal == null ? BigDecimal.ZERO : (BigDecimal)newVal;
        if (oldShowValue.compareTo(newShowValue) != 0) {
            changeInfo.setChange(true);
            changeInfo.setOldValue(oldShowValue.toString());
            changeInfo.setNewValue(newShowValue.toString());
        }
    }

    public static void compareCommon(Object oldVal, Object newVal, FieldChangeInfo changeInfo) {
        String newShowValue;
        String oldShowValue = oldVal == null ? "" : oldVal.toString();
        String string = newShowValue = newVal == null ? "" : newVal.toString();
        if (!StringUtils.equals((CharSequence)oldShowValue, (CharSequence)newShowValue)) {
            changeInfo.setChange(true);
            changeInfo.setOldValue(oldShowValue);
            changeInfo.setNewValue(newShowValue);
        }
    }

    public static void compareMulBasedataProp(Object oldVal, Object newVal, FieldChangeInfo changeInfo) {
        HashSet oldIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet newIds = Sets.newHashSetWithExpectedSize((int)16);
        StringBuilder oldShowValueStr = new StringBuilder();
        StringBuilder newShowValueStr = new StringBuilder();
        if (oldVal != null) {
            for (DynamicObject dyn : (DynamicObjectCollection)oldVal) {
                oldIds.add(dyn.getLong("id"));
                oldShowValueStr = oldShowValueStr.append(dyn.getString("name"));
            }
        }
        if (newVal != null) {
            for (DynamicObject dyn : (DynamicObjectCollection)newVal) {
                newIds.add(dyn.getLong("id"));
                newShowValueStr = newShowValueStr.append(dyn.getString("name"));
            }
        }
        if (oldIds.size() != newIds.size() || !oldIds.containsAll(newIds)) {
            changeInfo.setChange(true);
            changeInfo.setOldValue(oldShowValueStr.toString());
            changeInfo.setNewValue(newShowValueStr.toString());
        }
    }

    public static void compareTimeProp(Object oldVal, Object newVal, FieldChangeInfo changeInfo) {
        try {
            Date newDate;
            Date oldDate = oldVal == null ? SWCDateTimeUtils.parseDate((String)"1900-01-01") : (Date)oldVal;
            Date date = newDate = newVal == null ? SWCDateTimeUtils.parseDate((String)"1900-01-01") : (Date)newVal;
            if (!SWCDateUtils.isEqual((Date)oldDate, (Date)newDate)) {
                changeInfo.setChange(true);
            }
        }
        catch (ParseException e) {
            logger.error("compareTimeProp error:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", "compareTimeProp error:" + e.getMessage()), new Object[0]);
        }
    }

    public static void compareBasedataProp(Object oldVal, Object newVal, FieldChangeInfo changeInfo) {
        long newId;
        long oldId = oldVal == null ? 0L : ((DynamicObject)oldVal).getLong("id");
        long l = newId = newVal == null ? 0L : ((DynamicObject)newVal).getLong("id");
        if (oldId != newId) {
            changeInfo.setChange(true);
            changeInfo.setOldValue(oldVal == null ? "" : ((DynamicObject)oldVal).getString("name"));
            changeInfo.setNewValue(newVal == null ? "" : ((DynamicObject)newVal).getString("name"));
        }
    }
}

