/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity;

import java.util.List;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.FieldChangeInfo;

public class RefreshResult {
    private Long id;
    private boolean isSuccess = true;
    private String errorMsg;
    private List<FieldChangeInfo> changeInfos;

    public RefreshResult(Long id) {
        this.id = id;
    }

    public RefreshResult(Long id, boolean isSuccess, String errorMsg) {
        this.id = id;
        this.isSuccess = isSuccess;
        this.errorMsg = errorMsg;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isChange() {
        return this.isSuccess && !CollectionUtils.isEmpty(this.changeInfos);
    }

    public List<FieldChangeInfo> getChangeInfos() {
        return this.changeInfos;
    }

    public void setChangeInfos(List<FieldChangeInfo> changeInfos) {
        this.changeInfos = changeInfos;
    }

    public void addChangeInfos(List<FieldChangeInfo> newChangeInfos) {
        if (CollectionUtils.isEmpty(newChangeInfos)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.changeInfos)) {
            this.changeInfos = newChangeInfos;
        } else {
            this.changeInfos.addAll(newChangeInfos);
        }
    }

    public void add(RefreshResult result) {
        if (result == null) {
            return;
        }
        boolean success = result.isSuccess();
        if (success) {
            this.addChangeInfos(result.getChangeInfos());
        } else {
            this.isSuccess = success;
            this.setErrorMsg(this.errorMsg + result.errorMsg);
        }
    }

    public String getChangedMsg() {
        List<FieldChangeInfo> changeInfos = this.getChangeInfos();
        if (CollectionUtils.isEmpty(changeInfos)) {
            return "";
        }
        StringBuilder msgBuilder = new StringBuilder();
        char split = '\u3001';
        for (int i = 0; i < changeInfos.size(); ++i) {
            FieldChangeInfo changeInfo = changeInfos.get(i);
            msgBuilder = msgBuilder.append(changeInfo.getFieldName());
            if (i == changeInfos.size() - 1) continue;
            msgBuilder = msgBuilder.append(split);
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return "RefreshResult{id=" + this.id + ", isSuccess=" + this.isSuccess + ", errorMsg='" + this.errorMsg + '\'' + ", changeInfos=" + this.changeInfos + '}';
    }
}

