/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.api.CandSetSalApplyBaseRefresher;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableForCandidateParam;

public class ItemEntrySetSalRefresher
extends CandSetSalApplyBaseRefresher<SalaryStdMatchResultNew> {
    private static final Log LOGGER = LogFactory.getLog(ItemEntrySetSalRefresher.class);
    public static final Map<String, String> SETSAL_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private Set<Long> canMatchItemDyIds;

    @Override
    public boolean isOnlyRefreshLastChangedData() {
        return true;
    }

    @Override
    protected Long getRelId(DynamicObject targetDyn) {
        return targetDyn.getLong("id");
    }

    @Override
    protected Map<String, String> getFieldRelMap() {
        return SETSAL_MAP;
    }

    @Override
    protected Map<Long, SalaryStdMatchResultNew> querySourceData(List<DynamicObject> targetDyns) {
        this.canMatchItemDyIds = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)targetDyns.size());
        HashMap candidateToItemMap = Maps.newHashMapWithExpectedSize((int)targetDyns.size());
        HashSet notMatchPersonDyIds = Sets.newHashSetWithExpectedSize((int)targetDyns.size());
        HashMap candidateToItemToItemEntryIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject itemDyn : targetDyns) {
            DynamicObject personDyn = (DynamicObject)itemDyn.getParent();
            long personDynId = personDyn.getLong("id");
            if (notMatchPersonDyIds.contains(personDynId)) continue;
            long candidateId = personDyn.getLong("candidate.id");
            long salaryStructureId = personDyn.getLong("salarystructure.id");
            long stdScmId = personDyn.getLong("stdscmvid.id");
            if (salaryStructureId <= 0L || stdScmId <= 0L) {
                notMatchPersonDyIds.add(personDynId);
                continue;
            }
            MatchStdTableForCandidateParam matchParam = new MatchStdTableForCandidateParam();
            paramList.add(matchParam);
            matchParam.setCandidateId(candidateId);
            matchParam.setCandidateBillObj((DynamicObject)personDyn.getParent());
            matchParam.setSalaryStructureId(salaryStructureId);
            matchParam.setStdScmId(stdScmId);
            matchParam.setStdItemId(itemDyn.getLong("standarditem.id"));
            matchParam.setBsed(itemDyn.getDate("itembsed"));
            long itemId = itemDyn.getLong("standarditem.id");
            List itemIds = candidateToItemMap.computeIfAbsent(candidateId, k1 -> Lists.newArrayListWithCapacity((int)10));
            itemIds.add(itemId);
            long id = itemDyn.getLong("id");
            Map itemToItemEntryIdMap = candidateToItemToItemEntryIdMap.computeIfAbsent(candidateId, k1 -> Maps.newLinkedHashMapWithExpectedSize((int)16));
            itemToItemEntryIdMap.put(itemId, id);
            this.canMatchItemDyIds.add(id);
        }
        if (CollectionUtils.isEmpty(this.canMatchItemDyIds)) {
            return null;
        }
        Map<Object, Object> matchResultMap = new HashMap(0);
        try {
            AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
            matchResultMap = adjApprovalApplicationService.batchMatchStdTableForCandidate(paramList);
        }
        catch (Exception e) {
            LOGGER.error("CandSetSalApplyRefreshService reMatchStdTable batchMatchStdTableForCandidate error:", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(matchResultMap)) {
            return null;
        }
        HashMap sourceDataMap = Maps.newHashMapWithExpectedSize((int)targetDyns.size());
        for (Map.Entry<Object, Object> candidateEntry : matchResultMap.entrySet()) {
            Long candidateId = (Long)candidateEntry.getKey();
            Map resultMap = (Map)candidateEntry.getValue();
            if (CollectionUtils.isEmpty((Map)resultMap)) continue;
            Map itemToItemEntryIdMap = (Map)candidateToItemToItemEntryIdMap.get(candidateId);
            if (CollectionUtils.isEmpty((Map)itemToItemEntryIdMap)) {
                LOGGER.info("itemToItemEntryIdMap is null");
                continue;
            }
            for (Map.Entry resultEntry : resultMap.entrySet()) {
                Long itemId = (Long)resultEntry.getKey();
                sourceDataMap.put(itemToItemEntryIdMap.get(itemId), resultEntry.getValue());
            }
        }
        return sourceDataMap;
    }

    @Override
    protected Object getFromSourceData(SalaryStdMatchResultNew sourceData, String sourceFieldCode, DynamicProperty property) {
        Object value = null;
        switch (sourceFieldCode) {
            case "salarystd": {
                Long stdTableVid = sourceData.getStdTableVid();
                value = CandSetSalApplyRefreshHelper.transToDynmicObj(stdTableVid, ((BasedataProp)property).getBaseEntityId());
                break;
            }
            case "coefficient": {
                Long coefficientVid = sourceData.getCoefficientVid();
                value = CandSetSalApplyRefreshHelper.transToDynmicObj(coefficientVid, ((BasedataProp)property).getBaseEntityId());
                break;
            }
            case "salarel": {
                Map rangeData = sourceData.getRangeData();
                if (CollectionUtils.isEmpty((Map)rangeData)) break;
                value = JSON.toJSONString((Object)rangeData);
                break;
            }
        }
        return value;
    }

    @Override
    protected boolean sourceDataIsNull(DynamicObject targetDyn, RefreshResult result) {
        return this.canMatchItemDyIds.contains(targetDyn.getLong("id"));
    }

    static {
        SETSAL_MAP.put("salarystd", "salarystd");
        SETSAL_MAP.put("coefficient", "coefficient");
        SETSAL_MAP.put("salarel", "salarel");
    }
}

