/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.api.DynamicObjectBaseRefresher;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import org.apache.commons.collections4.MapUtils;

public class PersonEntryAdminOrgRefresher
extends DynamicObjectBaseRefresher {
    private static final Log LOGGER = LogFactory.getLog(PersonEntryAdminOrgRefresher.class);

    @Override
    protected Long getRelId(DynamicObject targetDyn) {
        return targetDyn.getLong("department.boid");
    }

    @Override
    protected Map<String, String> getFieldRelMap() {
        HashMap relMap = Maps.newHashMapWithExpectedSize((int)2);
        relMap.put("departmenttype", "id");
        return relMap;
    }

    @Override
    protected Map<Long, DynamicObject> doQuerySourceData(Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            LOGGER.info("CandSetSalApplyOnbrdRefresher querySourceData orgIds is null");
            return null;
        }
        Map result = (Map)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{Lists.newArrayList(orgIds), new Date()});
        if (CollectionUtils.isEmpty((Map)result)) {
            return null;
        }
        HashMap sourceDataMap = Maps.newHashMapWithExpectedSize((int)orgIds.size());
        for (Long orgId : orgIds) {
            Long departmentTypeId;
            Map objectMap = (Map)result.get(Long.toString(orgId));
            if (CollectionUtils.isEmpty((Map)objectMap) || (departmentTypeId = MapUtils.getLong((Map)objectMap, (Object)"departmenttype")) == null || departmentTypeId == 0L) continue;
            DynamicObject departmentTypeDyn = CandSetSalApplyRefreshHelper.transToDynmicObj(departmentTypeId, "haos_departmenttype");
            sourceDataMap.put(orgId, departmentTypeDyn);
        }
        return sourceDataMap;
    }

    @Override
    protected boolean sourceDataIsNull(DynamicObject targetDyn, RefreshResult result) {
        return true;
    }
}

