/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.api.DynamicObjectBaseRefresher;

public class PersonEntryEduExpRefresher
extends DynamicObjectBaseRefresher {
    private static final Log LOGGER = LogFactory.getLog(PersonEntryEduExpRefresher.class);
    public static final Map<String, String> CANEDUEXP_MAP = Maps.newHashMapWithExpectedSize((int)16);

    @Override
    protected Long getRelId(DynamicObject targetDyn) {
        return targetDyn.getLong("candidate.id");
    }

    @Override
    protected Map<String, String> getFieldRelMap() {
        return CANEDUEXP_MAP;
    }

    @Override
    protected Map<Long, DynamicObject> doQuerySourceData(Set<Long> relIds) {
        DynamicObject[] eduExpDys = CandidateSetSalApplyHelper.getTheHighestEduExp(String.join((CharSequence)",", CANEDUEXP_MAP.values()) + ",candidate.id", relIds);
        if (eduExpDys == null || eduExpDys.length == 0) {
            LOGGER.info("CandSetSalApplyEduExpRefresher querySourceData eduExpDys is null");
            return null;
        }
        HashMap sourceDataMap = Maps.newHashMapWithExpectedSize((int)eduExpDys.length);
        for (DynamicObject eduExpDyn : eduExpDys) {
            sourceDataMap.put(eduExpDyn.getLong("candidate.id"), eduExpDyn);
        }
        return sourceDataMap;
    }

    @Override
    protected boolean sourceDataIsNull(DynamicObject targetDyn, RefreshResult result) {
        return true;
    }

    static {
        CANEDUEXP_MAP.put("education", "educationid");
        CANEDUEXP_MAP.put("graduateschool", "graduateschool");
        CANEDUEXP_MAP.put("major", "major");
    }
}

