/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.candidatesetsalaryappl.OnbrdBillHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.api.DynamicObjectBaseRefresher;

public class PersonEntryOnbrdRefresher
extends DynamicObjectBaseRefresher {
    private static final Log LOGGER = LogFactory.getLog(PersonEntryOnbrdRefresher.class);

    @Override
    protected Long getRelId(DynamicObject targetDyn) {
        return targetDyn.getLong("onbrdinfo");
    }

    @Override
    protected Map<String, String> getFieldRelMap() {
        HashMap relMap = Maps.newHashMapWithExpectedSize((int)256);
        relMap.put("recruittype", "recruittype");
        relMap.put("name", "name");
        relMap.put("company", "acompany");
        relMap.put("department", "aadminorg");
        relMap.put("job", "ajob");
        relMap.put("joblevel", "ajoblevel");
        relMap.put("jobgrade", "ajobgrade");
        relMap.put("position", "aposition");
        relMap.put("stdposition", "stdposition");
        relMap.put("jobscm", "ajobscm");
        relMap.put("jobseq", "jobseq");
        relMap.put("jobfamily", "jobfamily");
        relMap.put("laborrelstatus", "laborrelstatus");
        relMap.put("laborreltype", "laborreltype");
        relMap.put("baselocation", "baselocation");
        relMap.put("perprobationtime", "perprobationtime");
        relMap.put("probationtime", "probationtime");
        relMap.put("entrydate", "effectdate");
        relMap.put("employeeno", "employeeno");
        relMap.put("avatar", "picturefield");
        relMap.put("agreedlocation", "contractlocation");
        relMap.put("isprobation", "isprobation");
        relMap.put("realregulardate", "transdate");
        relMap.put("jobclass", "jobclass");
        relMap.put("postype", "postype");
        relMap.put("departmentcity", "aadminorg.city");
        relMap.put("nationality", "nationality");
        relMap.put("offercode", "offernumber");
        relMap.put("depworkplace", "aadminorg.workplace");
        relMap.put("laborreltypecls", "laborreltype.laborreltypecls");
        relMap.put("apositiontype", "apositiontype");
        return relMap;
    }

    @Override
    protected Map<Long, DynamicObject> doQuerySourceData(Set<Long> onbrdIds) {
        DynamicObject[] onbrdDyns = OnbrdBillHelper.getOnbrdBillByIds(onbrdIds);
        if (onbrdDyns == null || onbrdDyns.length == 0) {
            LOGGER.info("CandSetSalApplyOnbrdRefresher querySourceData onbrdDyns is null");
            return null;
        }
        HashMap sourceDataMap = Maps.newHashMapWithExpectedSize((int)onbrdDyns.length);
        for (DynamicObject onbrdDyn : onbrdDyns) {
            sourceDataMap.put(onbrdDyn.getLong("id"), onbrdDyn);
        }
        return sourceDataMap;
    }

    @Override
    protected boolean sourceDataIsNull(DynamicObject targetDyn, RefreshResult result) {
        result.setSuccess(false);
        result.setErrorMsg(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5165\u804c\u5355\uff0c\u65e0\u6cd5\u66f4\u65b0\u4fe1\u606f\u3002", (String)"PersonEntryOnbrdRefresher_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        return false;
    }
}

