/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.FieldCompareHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.FieldChangeInfo;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.refresher.api.ICandSetSalApplyRefresher;
import org.apache.commons.lang3.StringUtils;

public abstract class CandSetSalApplyBaseRefresher<T>
implements ICandSetSalApplyRefresher {
    private static final Log LOGGER = LogFactory.getLog(CandSetSalApplyBaseRefresher.class);

    @Override
    public boolean isOnlyRefreshLastChangedData() {
        return false;
    }

    @Override
    public Map<Long, RefreshResult> refresh(List<DynamicObject> targetDyns) {
        LOGGER.info("CandSetSalApplyBaseRefresher refresh start...{}", (Object)this.getClass().getName());
        if (CollectionUtils.isEmpty(targetDyns)) {
            return null;
        }
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)targetDyns.size());
        try {
            HashMap sourceDataMap;
            HashMap fieldRelMap = this.getFieldRelMap();
            if (CollectionUtils.isEmpty(fieldRelMap)) {
                fieldRelMap = Maps.newHashMapWithExpectedSize((int)0);
                LOGGER.info("CandSetSalApplyBaseRefresher refresh fieldRelMap is null...");
            }
            if ((sourceDataMap = this.querySourceData(targetDyns)) == null) {
                LOGGER.info("CandSetSalApplyBaseRefresher refresh sourceDataMap is null...");
                sourceDataMap = Maps.newHashMapWithExpectedSize((int)0);
            }
            for (DynamicObject targetDyn : targetDyns) {
                RefreshResult result = this.refreshFields(targetDyn, this.getSourceData(sourceDataMap, targetDyn), fieldRelMap);
                this.afterRefreshFields(targetDyn, result);
                resultMap.put(targetDyn.getLong("id"), result);
            }
        }
        catch (Exception e) {
            LOGGER.error("CandSetSalApplyBaseRefresher refresh error:", (Throwable)e);
            throw new KDBizException("refresh error:" + e);
        }
        LOGGER.info("CandSetSalApplyBaseRefresher refresh end...{}", (Object)this.getClass().getName());
        return resultMap;
    }

    protected void afterRefreshFields(DynamicObject targetDyn, RefreshResult result) {
        if (StringUtils.equals((CharSequence)targetDyn.getDataEntityType().getName(), (CharSequence)"candsetsalperson") && result != null && result.isChange()) {
            DynamicObject apply = (DynamicObject)targetDyn.getParent();
            apply.set("isdraft", (Object)Boolean.TRUE);
        }
    }

    protected abstract Map<String, String> getFieldRelMap();

    protected abstract Map<Long, T> querySourceData(List<DynamicObject> var1);

    protected T getSourceData(Map<Long, T> sourceDataMap, DynamicObject targetDyn) {
        return sourceDataMap.get(this.getRelId(targetDyn));
    }

    protected abstract Long getRelId(DynamicObject var1);

    protected RefreshResult refreshFields(DynamicObject targetDyn, T sourceData, Map<String, String> fieldRelMap) {
        long targetId = targetDyn.getLong("id");
        RefreshResult result = new RefreshResult(targetId);
        boolean isClear = false;
        if (sourceData == null) {
            LOGGER.info("CandSetSalApplyBaseRefresher refresh sourceData is null, targetId=", (Object)targetId);
            isClear = this.sourceDataIsNull(targetDyn, result);
            if (!isClear || !result.isSuccess()) {
                return result;
            }
        }
        ArrayList changeInfos = Lists.newArrayListWithCapacity((int)10);
        result.setChangeInfos(changeInfos);
        for (Map.Entry<String, String> relEntry : fieldRelMap.entrySet()) {
            Object newVal;
            String targetFieldCode = relEntry.getKey();
            String sourceFieldCode = relEntry.getValue();
            DynamicObjectType dynamicObjectType = targetDyn.getDynamicObjectType();
            DynamicProperty property = dynamicObjectType.getProperty(targetFieldCode);
            Object oldVal = targetDyn.get(targetFieldCode);
            FieldChangeInfo changeInfo = this.compare(oldVal, newVal = isClear ? this.getClearDefaultVal(sourceFieldCode, property) : this.getFromSourceData(sourceData, sourceFieldCode, property), property);
            if (changeInfo == null || !changeInfo.isChange()) continue;
            targetDyn.set(targetFieldCode, newVal);
            changeInfos.add(changeInfo);
        }
        return result;
    }

    protected Object getClearDefaultVal(String sourceFieldCode, DynamicProperty property) {
        return null;
    }

    protected FieldChangeInfo compare(Object oldVal, Object newVal, DynamicProperty property) {
        if (oldVal == null && newVal == null) {
            return null;
        }
        String fieldCode = property.getAlias();
        String fieldName = property.getDisplayName().getLocaleValue();
        FieldChangeInfo changeInfo = new FieldChangeInfo(fieldCode, fieldName);
        if (property instanceof BasedataProp) {
            FieldCompareHelper.compareBasedataProp(oldVal, newVal, changeInfo);
        } else if (property instanceof DateTimeProp || property instanceof TimeProp) {
            FieldCompareHelper.compareTimeProp(oldVal, newVal, changeInfo);
        } else if (property instanceof MulBasedataProp) {
            FieldCompareHelper.compareMulBasedataProp(oldVal, newVal, changeInfo);
        } else if (property instanceof IntegerProp) {
            FieldCompareHelper.compareIntegerProp(oldVal, newVal, changeInfo);
        } else if (property instanceof DecimalProp) {
            FieldCompareHelper.compareDecimalProp(oldVal, newVal, changeInfo);
        } else {
            FieldCompareHelper.compareCommon(oldVal, newVal, changeInfo);
        }
        return changeInfo;
    }

    protected abstract Object getFromSourceData(T var1, String var2, DynamicProperty var3);

    protected abstract boolean sourceDataIsNull(DynamicObject var1, RefreshResult var2);
}

