/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.candidatesetsalaryappl.syncfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.swc.hcdm.business.extpoint.candsetsalapply.ICandSetSalApplySyncFileExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.candsetsalapply.event.AddSyncFieldsEvent;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyService;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.CandSetSalApplySyncConfig;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.CandSetSalApplySyncParaMapper;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.extimp.CandSetSalApplySyncFileExtPlugin;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.log.SyncAdjFileLogInfo;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.log.SyncAdjFileLogService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileInfoServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class CandSetSalApplySyncFileTask
implements Runnable {
    private static final Log log = LogFactory.getLog(CandSetSalApplySyncFileTask.class);
    public static final String ACTION_PREPAREDATA = "prepareData";
    public static final String ACTION_SYNCDATA = "syncData";
    private RequestContext reqContext;
    private CandSetSalApplySyncConfig conf;
    private String action;

    public CandSetSalApplySyncFileTask(RequestContext reqContext, CandSetSalApplySyncConfig conf, String action) {
        this.reqContext = reqContext;
        this.conf = conf;
        this.action = action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            RequestContext.copyAndSet((RequestContext)this.reqContext);
            switch (this.action) {
                case "prepareData": {
                    log.info("CandSetSalApplySyncFileTask run prepareData start...");
                    this.prepareData();
                    log.info("CandSetSalApplySyncFileTask run prepareData end...");
                    return;
                }
                case "syncData": {
                    log.info("CandSetSalApplySyncFileTask run syncData start...");
                    this.syncData();
                    log.info("CandSetSalApplySyncFileTask run syncData end...");
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            log.error("CandSetSalApplySyncFileTask run error + {} ; msg: {}", (Object)this.action, (Object)e);
            return;
        }
        finally {
            RequestContext.set(null);
        }
    }

    protected void prepareData() {
        List<Long> applyIds = this.conf.getApplyIds();
        if (CollectionUtils.isEmpty(applyIds)) {
            return;
        }
        List partition = Lists.partition(applyIds, (int)this.conf.getPageSize());
        for (List ids : partition) {
            DynamicObject[] applyDyns = this.queryData(ids);
            this.packageData(applyDyns);
        }
        this.conf.setQueryComplete(true);
    }

    protected void syncData() throws InterruptedException {
        LinkedBlockingQueue<Map<String, Object>> dataQueue = this.conf.getDataQueue();
        int timeout = 0;
        while (!this.conf.isQueryComplete() || !dataQueue.isEmpty()) {
            if (timeout > 5) {
                log.info("time out");
                break;
            }
            ArrayList dataList = Lists.newArrayListWithExpectedSize((int)this.conf.getPageSize());
            Map<String, Object> data = dataQueue.poll(1L, TimeUnit.MINUTES);
            if (null == data || data.isEmpty()) {
                log.info("...read...null");
                ++timeout;
                continue;
            }
            dataList.add(data);
            dataQueue.drainTo(dataList, this.conf.getPageSize());
            timeout = 0;
            this.doSyncData(dataList);
        }
    }

    protected DynamicObject[] queryData(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter syncFileFilter = CandidateSetSalApplyService.getSyncFileFilter();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candsetsalappl");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, syncFileFilter});
    }

    protected void packageData(DynamicObject[] applyDyns) {
        if (applyDyns == null || applyDyns.length == 0) {
            return;
        }
        LinkedBlockingQueue<Map<String, Object>> dataQueues = this.conf.getDataQueue();
        for (DynamicObject applyDyn : applyDyns) {
            String msg;
            DynamicObjectCollection personDyns = applyDyn.getDynamicObjectCollection("candsetsalperson");
            if (CollectionUtils.isEmpty((Collection)personDyns) || !StringUtils.isEmpty((CharSequence)(msg = this.validateApply(applyDyn)))) continue;
            for (DynamicObject personDyn : personDyns) {
                msg = this.validatePerson(personDyn);
                if (!StringUtils.isEmpty((CharSequence)msg)) continue;
                Map<String, Object> paraMap = CandSetSalApplySyncParaMapper.transformToMap(applyDyn, personDyn);
                if (StringUtils.equals((CharSequence)this.conf.getSyncOperation(), (CharSequence)"4")) {
                    paraMap.put("needrepush", "1");
                }
                this.addSyncFieldsExtPoint(paraMap, applyDyn, personDyn);
                dataQueues.add(paraMap);
            }
        }
    }

    protected String validateApply(DynamicObject applyDyn) {
        String billStatus = applyDyn.getString("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)"C")) {
            return ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u80fd\u4e0b\u63a8\u6863\u6848\u3002", (String)"CandSetSalApplySyncFileTask_4", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return null;
    }

    protected String validatePerson(DynamicObject personDyn) {
        String synchStatus = personDyn.getString("synchstatus");
        if (!StringUtils.equals((CharSequence)synchStatus, (CharSequence)"30")) {
            return ResManager.loadKDString((String)"\u5019\u9009\u4eba\u672a\u786e\u8ba4\u5165\u804c\uff0c\u4e0d\u80fd\u4e0b\u63a8\u6863\u6848\u3002", (String)"CandSetSalApplySyncFileTask_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        String syncFileStatus = personDyn.getString("syncfilestatus");
        if (StringUtils.equals((CharSequence)syncFileStatus, (CharSequence)"1")) {
            return ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u5df2\u4e0b\u63a8\u81f3\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u4e0d\u53ef\u91cd\u590d\u4e0b\u63a8\u3002", (String)"CandSetSalApplySyncFileTask_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return null;
    }

    protected void doSyncData(List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        LinkedHashMap result = null;
        try {
            AdjFileInfoServiceHelper helper = new AdjFileInfoServiceHelper();
            result = helper.saveAdjFile(dataList);
            log.info("[SyncFileTask] doSyncData result{}", (Object)result);
        }
        catch (Exception e) {
            log.error("CandSetSalApplySyncFileTask doSyncData error : ", (Throwable)e);
            result = Maps.newLinkedHashMapWithExpectedSize((int)2);
            result.put("success", Boolean.FALSE);
            result.put("message", e.toString());
        }
        List<SyncAdjFileLogInfo> logInfos = this.parseResult(dataList, result);
        this.saveLog(logInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveLog(List<SyncAdjFileLogInfo> logInfos) {
        if (CollectionUtils.isEmpty(logInfos)) {
            return;
        }
        try (TXHandle txHandle = TX.required();){
            HashMap applyAndCandMap = Maps.newHashMapWithExpectedSize((int)logInfos.size());
            this.doSaveLog(logInfos, applyAndCandMap);
            this.updateApplySyncInfo(applyAndCandMap);
        }
    }

    private void doSaveLog(List<SyncAdjFileLogInfo> logInfos, Map<Long, Map<String, SyncAdjFileLogInfo>> applyAndCandMap) {
        DynamicObject[] logDynArray = new DynamicObject[logInfos.size()];
        HRBaseServiceHelper logService = new HRBaseServiceHelper("hcdm_syncadjfilelog");
        for (int i = 0; i < logInfos.size(); ++i) {
            DynamicObject logInfoDyn;
            SyncAdjFileLogInfo logInfo = logInfos.get(i);
            logDynArray[i] = logInfoDyn = SyncAdjFileLogService.toDynamic(logInfo, logService);
            Map candLogMap = applyAndCandMap.computeIfAbsent(logInfo.getApplyBillId(), k1 -> Maps.newLinkedHashMapWithExpectedSize((int)16));
            candLogMap.put(logInfo.getUniqueCode(), logInfo);
        }
        logService.save(logDynArray);
    }

    private void updateApplySyncInfo(Map<Long, Map<String, SyncAdjFileLogInfo>> applyAndCandMap) {
        HRBaseServiceHelper applyService = new HRBaseServiceHelper("hcdm_candsetsalappl");
        DynamicObject[] applyDyns = applyService.query("id,candsetsalperson.candidate,candsetsalperson.syncfilestatus,candsetsalperson.salaryadjfile,modifier,modifytime", new QFilter[]{new QFilter("id", "in", applyAndCandMap.keySet())});
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        for (DynamicObject applyDyn : applyDyns) {
            long applyId = applyDyn.getLong("id");
            DynamicObjectCollection personList = applyDyn.getDynamicObjectCollection("candsetsalperson");
            if (CollectionUtils.isEmpty((Collection)personList)) continue;
            boolean isModify = false;
            Map<String, SyncAdjFileLogInfo> candLogMap = applyAndCandMap.get(applyId);
            for (DynamicObject personDyn : personList) {
                String personDynId = personDyn.getString("id");
                SyncAdjFileLogInfo logInfo = candLogMap.get(personDynId);
                if (logInfo == null) continue;
                if (logInfo.isSuccess()) {
                    personDyn.set("syncfilestatus", (Object)"1");
                    personDyn.set("salaryadjfile", (Object)logInfo.getAdjFileId());
                } else {
                    personDyn.set("syncfilestatus", (Object)"2");
                }
                isModify = true;
            }
            if (!isModify) continue;
            applyDyn.set("modifier", (Object)currUserId);
            applyDyn.set("modifytime", (Object)currDate);
        }
        applyService.update(applyDyns);
    }

    protected List<SyncAdjFileLogInfo> parseResult(List<Map<String, Object>> dataList, Map<String, Object> result) {
        String errorMsg;
        ArrayList logInfos = Lists.newArrayListWithExpectedSize((int)dataList.size());
        if (CollectionUtils.isEmpty(dataList)) {
            return null;
        }
        Map<Object, Object> fileResultMap = new HashMap(0);
        if (CollectionUtils.isEmpty(result)) {
            errorMsg = ResManager.loadKDString((String)"\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"CandSetSalApplySyncFileTask_2", (String)"swc-hcdm-business", (Object[])new Object[0]);
        } else {
            errorMsg = (String)result.get("message");
            List fileMsgMap = (List)result.get("data");
            if (!CollectionUtils.isEmpty((Collection)fileMsgMap)) {
                fileResultMap = fileMsgMap.stream().collect(Collectors.toMap(obj -> (String)obj.get("uniquecode"), obj -> obj, (k1, k2) -> k1));
            }
        }
        for (Map<String, Object> data : dataList) {
            String fileErrorMsg;
            String uniqueCode = (String)data.get("uniquecode");
            SyncAdjFileLogInfo logInfo = new SyncAdjFileLogInfo();
            logInfos.add(logInfo);
            logInfo.setApplyBillId((Long)data.get("bussinessid"));
            logInfo.setApplBillNum((String)data.get("billno"));
            Object depEmp = data.get("depemp");
            if (depEmp != null) {
                logInfo.setDepEmpId((Long)depEmp);
            }
            logInfo.setUniqueCode(uniqueCode);
            logInfo.setApplyBillType("candsetsalappl");
            logInfo.setOperation(this.conf.getSyncOperation());
            Map fileMsg = (Map)fileResultMap.get(String.valueOf(uniqueCode));
            if (CollectionUtils.isEmpty((Map)fileMsg)) {
                logInfo.log(false, "500", errorMsg);
                continue;
            }
            boolean fileIsSuccess = (Boolean)fileMsg.get("success");
            if (!fileIsSuccess) {
                fileErrorMsg = (String)fileMsg.get("errormsg");
                fileErrorMsg = StringUtils.isEmpty((CharSequence)fileErrorMsg) ? errorMsg : fileErrorMsg;
                logInfo.log(false, "401", fileErrorMsg);
                continue;
            }
            List itemMsgList = (List)fileMsg.get("decadj_data");
            if (!CollectionUtils.isEmpty((Collection)itemMsgList)) {
                for (Map itemMsg : itemMsgList) {
                    fileIsSuccess = (Boolean)itemMsg.get("success");
                    if (fileIsSuccess) continue;
                    fileErrorMsg = (String)itemMsg.get("message");
                    fileErrorMsg = StringUtils.isEmpty((CharSequence)fileErrorMsg) ? errorMsg : fileErrorMsg;
                    logInfo.log(false, "402", fileErrorMsg);
                }
            }
            if (!logInfo.isSuccess()) continue;
            Long fileId = (Long)fileMsg.get("salaryfileid");
            if (fileId == null || fileId == 0L) {
                fileErrorMsg = ResManager.loadKDString((String)"\u6863\u6848id\u672a\u8fd4\u56de\u3002", (String)"CandSetSalApplySyncFileTask_3", (String)"swc-hcdm-business", (Object[])new Object[0]);
                logInfo.log(false, "401", fileErrorMsg);
                continue;
            }
            logInfo.setAdjFileId(fileId);
        }
        return logInfos;
    }

    private void addSyncFieldsExtPoint(Map<String, Object> paraMap, DynamicObject applyDyn, DynamicObject personDyn) {
        AddSyncFieldsEvent paramEvent = new AddSyncFieldsEvent(paraMap, applyDyn, personDyn);
        CandSetSalApplySyncFileExtPlugin extPlugin = new CandSetSalApplySyncFileExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extPlugin, ICandSetSalApplySyncFileExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.candsetsalapply.ICandSetSalApplySyncFileExtPlugin#addSyncFields", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addSyncFields(paramEvent);
            return null;
        });
    }
}

