/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.check;

import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.check.ICheckService;
import kd.swc.hsbp.common.util.BaseResult;

public class CheckDataHelper {
    private static Log logger = LogFactory.getLog(CheckDataHelper.class);

    public static String checkPoint(ICheckService checkService, String checkRequire, DBRoute dbRoute, String checkSql) {
        if (checkService == null) {
            logger.error("no ICheckService impl found.");
            return CheckDataHelper.assembleFailImpl(checkRequire);
        }
        BaseResult<Set<Object>> setBaseResult = checkService.doCheck(dbRoute, checkSql);
        if (setBaseResult == null) {
            return CheckDataHelper.assembleFailDesc(checkRequire);
        }
        if (setBaseResult.isSuccess()) {
            return CheckDataHelper.assembleSuccessDesc(checkRequire);
        }
        StringBuilder sbMsg = new StringBuilder();
        sbMsg.append(CheckDataHelper.assembleFailDesc(checkRequire));
        sbMsg.append(ResManager.loadKDString((String)"{0}\u6570\u636e\u5217\u8868\uff1a{1}\u3002", (String)"CheckDataHelper_0", (String)"swc-hcdm-business", (Object[])new Object[]{"    ", "\n"})).append("    ");
        Set data = (Set)setBaseResult.getData();
        if (data != null && !data.isEmpty()) {
            for (Object datum : data) {
                if (datum == null) continue;
                sbMsg.append(datum).append(',');
            }
        }
        return sbMsg.append("\n").toString();
    }

    public static String assembleSuccessDesc(String checkRequire) {
        return String.format(checkRequire + " %1$s%2$s", ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"CheckDataHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]), "\n");
    }

    public static String assembleFailDesc(String checkRequire) {
        return String.format(checkRequire + " %1$s%2$s", ResManager.loadKDString((String)"\u5931\u8d25\u3002", (String)"CheckDataHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]), "\n");
    }

    public static String assembleFailImpl(String checkRequire) {
        return String.format(checkRequire + "  %1$s%2$s", ResManager.loadKDString((String)"\u5931\u8d25\u3002\u6ca1\u6709\u5b9e\u73b0\u8be5\u573a\u666f\u7684\u68c0\u67e5\u65b9\u6cd5\u3002", (String)"CheckDataHelper_3", (String)"swc-hcdm-business", (Object[])new Object[0]), "\n");
    }
}

