/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.cloudcolla.adjsalfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.handler.CollaAdjSalFileFlowOutHandler;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hsbp.business.cloudcolla.CloudCollaContextHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjSalFileCollaHelper {
    private static final Log log = LogFactory.getLog(CollaAdjSalFileFlowOutHandler.class);

    public static DynamicObject[] queryAdjSalFile(Long depEmpId) {
        if (depEmpId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4ebaID\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjSalFileCollaHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        return AdjSalFileCollaHelper.queryAdjSalFile(depEmpId, null, null, null, null, null);
    }

    public static DynamicObject[] queryAdjSalFile(Long depEmpId, Long employeeId, Long orgId, Long countryId, Long stdscmId, String type) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and("status", "in", (Object)CommonHcdmBizHelper.VALIDATE_STATUS);
        if (depEmpId != null && depEmpId != 0L) {
            filter.and("depemp", "=", (Object)depEmpId);
        }
        if (employeeId != null && employeeId != 0L) {
            filter.and("employee", "=", (Object)employeeId);
        }
        if (orgId != null && orgId != 0L) {
            filter.and("org", "=", (Object)orgId);
        }
        if (countryId != null && countryId != 0L) {
            filter.and("country", "=", (Object)countryId);
        }
        if (stdscmId != null && stdscmId != 0L) {
            filter.and("stdscm", "=", (Object)stdscmId);
        }
        if (!StringUtils.isEmpty((CharSequence)type)) {
            filter.and("type", "=", (Object)type);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_adjfileinfo");
        return serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjfileinfo"), new QFilter[]{filter}, "bsed desc");
    }

    public static Long getChgEvent(Map<String, Object> commonParams) {
        try {
            CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
            DynamicObject chgCategory = (DynamicObject)executeInfo.getMsgEntity().get("chgCategory");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hpfs_chgcategory");
            chgCategory = serviceHelper.loadSingle((Object)chgCategory.getLong("id"));
            return chgCategory.getLong("chgevent.id");
        }
        catch (Exception e) {
            log.info("[colla]AdjSalFileCollaHelper getChgEvent error:", (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53d8\u52a8\u5927\u7c7b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458: {0}\u3002", (String)"AdjSalFileCollaHelper_6", (String)"swc-hcdm-business", (Object[])new Object[]{e}));
        }
    }

    public static DynamicObject queryTaskCenterDyn(String taskCenterClass, Long taskCenterId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(taskCenterClass);
        return serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)taskCenterId));
    }

    public static DynamicObject getTaskCenterDyn(Map<String, Object> commonParams) {
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (executeInfo == null) {
            return null;
        }
        String taskCenterClass = executeInfo.getTaskCenterClass();
        Long taskCenterId = executeInfo.getTaskCenterId();
        return AdjSalFileCollaHelper.queryTaskCenterDyn(taskCenterClass, taskCenterId);
    }

    public static Map<String, Object> getTaskCenterMap(Map<String, Object> commonParams, String flowType, String collaApp, Long orgMsgRecvCenterId) {
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (executeInfo == null) {
            return null;
        }
        Long taskCenterId = executeInfo.getTaskCenterId();
        boolean isCurrentTask = SWCStringUtils.isEmpty((String)flowType);
        flowType = isCurrentTask ? executeInfo.getFlowType() : flowType;
        List specTasks = (List)executeInfo.getBatchTaskCenterData().get(flowType);
        if (CollectionUtils.isEmpty((Collection)specTasks)) {
            return null;
        }
        for (Map task : specTasks) {
            Set collaAppSet = (Set)task.get("collaApp");
            if (CollectionUtils.isEmpty((Collection)collaAppSet) || !collaAppSet.contains(collaApp) || (isCurrentTask ? !MapUtils.getLong((Map)task, (Object)"taskCenterId").equals(taskCenterId) : null != orgMsgRecvCenterId && !orgMsgRecvCenterId.equals(MapUtils.getLong((Map)task, (Object)"msgSubId")))) continue;
            return task;
        }
        return null;
    }

    public static DynamicObject getDynamicObjectById(Map<String, Object> commonParams, String apiNumber, Long entityId) {
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (executeInfo == null) {
            return null;
        }
        Map apiData = executeInfo.getConvertedApiDatas();
        if (CollectionUtils.isEmpty((Map)apiData)) {
            return null;
        }
        List specObjects = (List)apiData.get(apiNumber);
        if (CollectionUtils.isEmpty((Collection)specObjects)) {
            return null;
        }
        for (Object obj : specObjects) {
            DynamicObject dy;
            if (!(obj instanceof DynamicObject) || (dy = (DynamicObject)obj).getLong("id") != entityId.longValue()) continue;
            return dy;
        }
        return null;
    }

    public static DynamicObject getDepEmpById(Map<String, Object> commonParams, Long entityId) {
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (executeInfo == null) {
            return null;
        }
        Map apiIdNumMap = executeInfo.getApiIdNumberMap();
        if (CollectionUtils.isEmpty((Map)apiIdNumMap)) {
            return null;
        }
        return AdjSalFileCollaHelper.getDynamicObjectById(commonParams, (String)apiIdNumMap.get(1355810811012109312L), entityId);
    }

    public static DynamicObject getPersonById(Map<String, Object> commonParams, Long entityId) {
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (executeInfo == null) {
            return null;
        }
        Map apiIdNumMap = executeInfo.getApiIdNumberMap();
        if (CollectionUtils.isEmpty((Map)apiIdNumMap)) {
            return null;
        }
        return AdjSalFileCollaHelper.getDynamicObjectById(commonParams, (String)apiIdNumMap.get(1355771386509054976L), entityId);
    }

    public static Long getTaskCenterId(Map<String, Object> commonParams) {
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (executeInfo == null) {
            return null;
        }
        return executeInfo.getTaskCenterId();
    }

    public static DynamicObject[] queryOutTaskCenterDyn(DynamicObject inputTaskCenterDyn) {
        long orgMsgRecvCenterId = inputTaskCenterDyn.getLong("orgmsgrecvcenter.id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hpdi_taskcenter");
        QFilter filter = new QFilter("orgmsgrecvcenter", "=", (Object)orgMsgRecvCenterId);
        filter.and("flowtype", "=", (Object)"2");
        filter.and("enable", "!=", (Object)"0");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static void fillAdjSalFile(DynamicObject adjSalFile, Map<String, Object> taskCenterMap) {
        adjSalFile.set("depemp", (Object)AdjSalFileCollaHelper.generateEmptyDynamicObject("hrpi_depemp", MapUtils.getLong(taskCenterMap, (Object)"depEmpId")));
        adjSalFile.set("employee", (Object)AdjSalFileCollaHelper.generateEmptyDynamicObject("hrpi_employee", MapUtils.getLong(taskCenterMap, (Object)"employeeId")));
        adjSalFile.set("position", (Object)AdjSalFileCollaHelper.generateEmptyDynamicObject("hbpm_positionhr", MapUtils.getLong(taskCenterMap, (Object)"dutyWorkRoleId")));
        adjSalFile.set("adminorg", (Object)AdjSalFileCollaHelper.generateEmptyDynamicObject("haos_adminorghr", MapUtils.getLong(taskCenterMap, (Object)"orgTeamId")));
        log.info("[colla]AdjSalFileCollaHelper fillAdjSalFile depemp is{}", (Object)MapUtils.getLong(taskCenterMap, (Object)"depEmpId"));
        log.info("[colla]AdjSalFileCollaHelper fillAdjSalFile adminorg is{}", (Object)MapUtils.getLong(taskCenterMap, (Object)"orgTeamId"));
    }

    public static DynamicObject generateEmptyDynamicObject(String entityCode, Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityCode);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)id);
        return dynamicObject;
    }

    public static List<Map<String, Object>> transToSaveParaMap(List<DynamicObject> files, Map<String, Object> ruleEngineData, Long taskCenterId, DynamicObject trigger, Map<String, DynamicObject> uniqueCodeObjectMap) {
        if (CollectionUtils.isEmpty(files)) {
            return null;
        }
        ArrayList fileList = Lists.newArrayListWithCapacity((int)files.size());
        for (DynamicObject file : files) {
            long depempId = file.getLong("depemp.id");
            Map<String, Object> fileFieldMap = AdjSalFileCollaHelper.dynamicObjectToMap(file, ruleEngineData, trigger);
            fileFieldMap.put("uuid", "8&" + taskCenterId);
            fileFieldMap.put("endOperate", Boolean.TRUE);
            String uniqueCode = UUID.randomUUID().toString();
            uniqueCodeObjectMap.put(uniqueCode, file);
            fileFieldMap.put("uniquecode", uniqueCode);
            fileFieldMap.put("operationcode", "C");
            fileFieldMap.put("datasource", "8");
            fileFieldMap.put("depemp", depempId);
            fileFieldMap.put("employee", file.getLong("employee.id"));
            fileFieldMap.put("position", file.getLong("position.id"));
            fileFieldMap.put("adminorg", file.getLong("adminorg.id"));
            long fileId = file.getLong("id");
            if (fileId != 0L) {
                fileFieldMap.put("adjfileinfo", fileId);
            }
            fileList.add(fileFieldMap);
        }
        log.info("[colla]AdjSalFileCollaHelper transToSaveParaMap fileList is {}", (Object)fileList);
        return fileList;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dyn, Map<String, Object> ruleEngineData, DynamicObject trigger) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (dyn == null || CollectionUtils.isEmpty(ruleEngineData)) {
            return map;
        }
        DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
        if (trigger == null) {
            return map;
        }
        DynamicObjectCollection entry = trigger.getDynamicObjectCollection("paramentryentity");
        if (CollectionUtils.isEmpty((Collection)entry)) {
            return map;
        }
        for (DynamicObject dynamicObject : entry) {
            String fieldCode = dynamicObject.getString("fieldkey");
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldCode);
            if (property == null) continue;
            Object value = dyn.get(fieldCode);
            if (value instanceof DynamicObject) {
                map.put(fieldCode, ((DynamicObject)value).getLong("id"));
                continue;
            }
            if (value instanceof DynamicObjectCollection) {
                List ids = ((DynamicObjectCollection)value).stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
                map.put(fieldCode, ids);
                continue;
            }
            map.put(fieldCode, value);
        }
        return map;
    }

    public static List<Map<String, Object>> transToLoseEffectParaMap(List<DynamicObject> files, Map<String, DynamicObject> uniqueCodeObjectMap) {
        if (CollectionUtils.isEmpty(files)) {
            return null;
        }
        ArrayList fileList = Lists.newArrayListWithCapacity((int)files.size());
        for (DynamicObject file : files) {
            HashMap para = Maps.newHashMapWithExpectedSize((int)16);
            para.put("adjfileinfo", file.getLong("id"));
            para.put("bsled", file.getDate("bsled"));
            fileList.add(para);
            String uuid = UUID.randomUUID().toString();
            para.put("uniquecode", uuid);
            uniqueCodeObjectMap.put(uuid, file);
        }
        return fileList;
    }

    public static DynamicObject getOutTaskFileByInputTask(Map<String, Object> taskCenterMap, Map<String, Object> commonParams) {
        Long orgMsgRecvCenterId = MapUtils.getLong(taskCenterMap, (Object)"msgSubId");
        Map<String, Object> outTaskCenterMap = AdjSalFileCollaHelper.getTaskCenterMap(commonParams, "2", "hcdm", orgMsgRecvCenterId);
        if (CollectionUtils.isEmpty(outTaskCenterMap)) {
            log.info("[colla]CollaAdjSalFileFlowInHandler getOutTaskFileByInputTask outTaskCenterMap == null.");
            return null;
        }
        return AdjSalFileCollaHelper.getFileByTask(outTaskCenterMap, commonParams, false);
    }

    public static DynamicObject getFileByTask(Map<String, Object> taskCenterMap, Map<String, Object> commonParams, boolean isFlowOut) {
        log.info("[colla]AdjSalFileCollaHelper getFileByOutTask start...");
        Long depEmpId = MapUtils.getLong(taskCenterMap, (Object)"depEmpId");
        DynamicObject person = AdjSalFileCollaHelper.getPersonById(commonParams, MapUtils.getLong(taskCenterMap, (Object)"personId"));
        DynamicObject depEmp = AdjSalFileCollaHelper.getDepEmpById(commonParams, depEmpId);
        String personName = null;
        String personNumber = null;
        if (null != person && !SWCObjectUtils.isEmpty((Object)person)) {
            personName = person.getString("name");
            personNumber = person.getString("number");
        }
        String depEmpNum = null == depEmp || SWCObjectUtils.isEmpty((Object)depEmp) ? null : depEmp.getString("number");
        log.info("[colla]AdjSalFileCollaHelper getFileByOutTask depEmpId{}", (Object)depEmpId);
        DynamicObject[] existAdjSalFiles = AdjSalFileCollaHelper.queryAdjSalFile(depEmpId);
        if (existAdjSalFiles == null || existAdjSalFiles.length == 0) {
            if (isFlowOut) {
                throw new KDBizException(ResManager.loadKDString((String)"{0}({1})\u7684\u5c97\u4f4d({2})\u4e0d\u5b58\u5728\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"AdjSalFileCollaHelper_2", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, depEmpNum}));
            }
            return null;
        }
        if (existAdjSalFiles.length > 1) {
            existAdjSalFiles = AdjSalFileCollaHelper.filterLoseEffectFile(existAdjSalFiles, taskCenterMap);
        }
        return existAdjSalFiles[0];
    }

    public static DynamicObject[] filterLoseEffectFile(DynamicObject[] existAdjSalFiles, Map<String, Object> taskCenterMap) {
        if (existAdjSalFiles == null || existAdjSalFiles.length == 0) {
            return existAdjSalFiles;
        }
        List<DynamicObject> collect = Arrays.stream(existAdjSalFiles).filter(obj -> !StringUtils.equals((CharSequence)obj.getString("status"), (CharSequence)"D")).collect(Collectors.toList());
        if (collect == null || collect.size() == 0) {
            return new DynamicObject[]{existAdjSalFiles[0]};
        }
        if (collect.size() == 1) {
            return collect.toArray(new DynamicObject[0]);
        }
        String typeName = AdjSalFileCollaHelper.getTypeName(taskCenterMap);
        List numberList = Arrays.stream(existAdjSalFiles).map(obj -> obj.getString("number")).collect(Collectors.toList());
        String numberMsg = StringUtils.join(numberList, (String)",");
        throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u591a\u4efd\u6863\u6848\u7c7b\u578b\u4e3a{0}\u7684\u5b9a\u8c03\u85aa\u6863\u6848\uff08{1}\uff09\uff0c\u8bf7\u624b\u5de5\u8c03\u6574\u5b9a\u8c03\u85aa\u6863\u6848\u3002", (String)"CollaAdjSalFileFlowInHandler_3", (String)"swc-hcdm-business", (Object[])new Object[]{typeName, numberMsg}));
    }

    private static String getTypeName(Map<String, Object> taskCenterMap) {
        String type = AdjSalFileCollaHelper.getFileType(taskCenterMap);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return "";
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hcdm_adjfileinfo");
        ComboProp property = (ComboProp)mainEntityType.getProperties().get((Object)"type");
        return property.getItemByName(type);
    }

    public static String getFileType(Map<String, Object> taskCenterMap) {
        if (taskCenterMap == null) {
            return null;
        }
        Boolean isPrimary = MapUtils.getBoolean(taskCenterMap, (Object)"isPrimary");
        log.info("[colla] AdjSalFileCollaHelper getFileType isPrimary{}", (Object)isPrimary);
        return isPrimary != false ? "0" : "1";
    }

    public static DynamicObject[] getSameEmployeeFiles(DynamicObject adjSalFile, Map<String, Object> taskCenterMap) {
        Long employeeId = adjSalFile.getLong("employee.id");
        Long orgId = adjSalFile.getLong("org.id");
        Long countryId = adjSalFile.getLong("country.id");
        Long stdscmId = adjSalFile.getLong("stdscm.id");
        String type = AdjSalFileCollaHelper.getFileType(taskCenterMap);
        if (employeeId == 0L || orgId == 0L || countryId == 0L || stdscmId == 0L || StringUtils.isEmpty((CharSequence)type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u4f01\u4e1a\u4eba({0})\u3001\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7({1})\u3001\u85aa\u916c\u7ba1\u7406\u5c5e\u5730({2})\u3001\u85aa\u916c\u4f53\u7cfb({3})\u3001\u6863\u6848\u7c7b\u578b({4})\u201d\u5b58\u5728\u4e3a\u7a7a\u7684\u503c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollaAdjSalFileFlowInHandler_2", (String)"swc-hcdm-business", (Object[])new Object[]{employeeId, orgId, countryId, stdscmId, type}));
        }
        DynamicObject[] sameEmpFiles = AdjSalFileCollaHelper.queryAdjSalFile(null, employeeId, orgId, countryId, stdscmId, type);
        return sameEmpFiles;
    }

    public static void dealWithSameEmpFile(DynamicObject sameEmpFile, DynamicObject adjSalFile, Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, List<DynamicObject>> result) {
        DynamicObject person = AdjSalFileCollaHelper.getPersonById(commonParams, MapUtils.getLong(taskCenterMap, (Object)"personId"));
        String personName = null;
        String personNumber = null;
        if (null != person && !SWCObjectUtils.isEmpty((Object)person)) {
            personName = person.getString("name");
            personNumber = person.getString("number");
        }
        String status = sameEmpFile.getString("status");
        log.info("[colla]CollaAdjSalFileFlowInHandler dealWithUpdateFile, AdjSalFile status is {}", (Object)status);
        if (StringUtils.equals((CharSequence)status, (CharSequence)"A") || StringUtils.equals((CharSequence)status, (CharSequence)"B")) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}({1})\u7684\u5b9a\u8c03\u85aa\u6863\u6848({2})\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"AdjSalFileCollaHelper_4", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, sameEmpFile.getString("number")}));
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"D")) {
            sameEmpFile.set("status", (Object)"C");
        }
        adjSalFile.set("id", (Object)sameEmpFile.getLong("id"));
        CloudCollaContextHelper contextHelper = CloudCollaContextHelper.getInstance();
        contextHelper.parseAndSetCustomizeResultOnlyExistData(adjSalFile, commonParams, sameEmpFile);
        List dynamicObjects = result.computeIfAbsent("CHANGE", item -> new ArrayList(10));
        dynamicObjects.add(adjSalFile);
    }

    public static void createAdjSalFile(DynamicObject adjSalFile, Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, List<DynamicObject>> result) {
        DynamicObject existsAdjSalFile = AdjSalFileCollaHelper.getFileByTask(taskCenterMap, commonParams, false);
        if (null == existsAdjSalFile || SWCObjectUtils.isEmpty((Object)existsAdjSalFile)) {
            List dynamicObjects = result.computeIfAbsent("NEW", item -> new ArrayList(10));
            dynamicObjects.add(adjSalFile);
            return;
        }
        DynamicObject person = AdjSalFileCollaHelper.getPersonById(commonParams, MapUtils.getLong(taskCenterMap, (Object)"personId"));
        String personName = null;
        String personNumber = null;
        if (null != person && !SWCObjectUtils.isEmpty((Object)person)) {
            personName = person.getString("name");
            personNumber = person.getString("number");
        }
        String status = existsAdjSalFile.getString("status");
        log.info("[colla]CollaAdjSalFileFlowInHandler createAdjSalFile, AdjSalFile status is {}", (Object)status);
        if (StringUtils.equals((CharSequence)status, (CharSequence)"A") || StringUtils.equals((CharSequence)status, (CharSequence)"B")) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}({1})\u7684\u5b9a\u8c03\u85aa\u6863\u6848({2})\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"AdjSalFileCollaHelper_4", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, existsAdjSalFile.getString("number")}));
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}({1})\u7684\u5b9a\u8c03\u85aa\u6863\u6848\uff08{2}\uff09\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u65b0\u589e\u3002", (String)"CollaAdjSalFileFlowInHandler_7", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, existsAdjSalFile.getString("number")}));
        }
        adjSalFile.set("status", (Object)"C");
        adjSalFile.set("id", (Object)existsAdjSalFile.getLong("id"));
        CloudCollaContextHelper contextHelper = CloudCollaContextHelper.getInstance();
        contextHelper.parseAndSetCustomizeResultOnlyExistData(adjSalFile, commonParams, existsAdjSalFile);
        List dynamicObjects = result.computeIfAbsent("CHANGE", item -> new ArrayList(10));
        dynamicObjects.add(adjSalFile);
    }
}

