/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.cloudcolla.adjsalfile.handler;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.AdjSalFileCollaHelper;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.handler.ICollaAdjSalFileHandler;
import kd.swc.hsbp.business.cloudcolla.CloudCollaContextHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CollaAdjSalFileDefaultHandler
implements ICollaAdjSalFileHandler {
    private static final Log log = LogFactory.getLog(CollaAdjSalFileDefaultHandler.class);

    public static CollaAdjSalFileDefaultHandler getInstance() {
        return Load.INSTANCE;
    }

    @Override
    public Map<String, List<DynamicObject>> assembleData(DynamicObject adjSalFile, Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData) {
        log.info("[colla]CollaAdjSalFileDefaultHandler assembleData start...");
        Map<String, Object> taskCenterMap = AdjSalFileCollaHelper.getTaskCenterMap(commonParams, null, "hcdm", null);
        if (taskCenterMap == null || taskCenterMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollaAdjSalFileFlowOutHandler_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        AdjSalFileCollaHelper.fillAdjSalFile(adjSalFile, taskCenterMap);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        Boolean isAddFile = MapUtils.getBoolean(ruleEngineData, (Object)"hcdm_adjfileinfo_isinputnewfile", (Boolean)Boolean.FALSE);
        if (isAddFile.booleanValue()) {
            this.dealWithAddFile(adjSalFile, taskCenterMap, commonParams, ruleEngineData, result);
        } else {
            this.dealWithUpdateFile(adjSalFile, taskCenterMap, commonParams, ruleEngineData, result);
        }
        return result;
    }

    private void dealWithAddFile(DynamicObject adjSalFile, Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, Map<String, List<DynamicObject>> result) {
        this.dealWithSameDepEmpFile(adjSalFile, taskCenterMap, commonParams, ruleEngineData, result);
    }

    private void dealWithUpdateFile(DynamicObject adjSalFile, Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, Map<String, List<DynamicObject>> result) {
        Object[] sameEmpFileArr = AdjSalFileCollaHelper.getSameEmployeeFiles(adjSalFile, taskCenterMap);
        if (SWCArrayUtils.isEmpty((Object[])sameEmpFileArr)) {
            this.dealWithSameDepEmpFile(adjSalFile, taskCenterMap, commonParams, ruleEngineData, result);
        } else {
            if (sameEmpFileArr.length > 1) {
                sameEmpFileArr = AdjSalFileCollaHelper.filterLoseEffectFile((DynamicObject[])sameEmpFileArr, taskCenterMap);
            }
            Object sameEmpFile = sameEmpFileArr[0];
            AdjSalFileCollaHelper.dealWithSameEmpFile((DynamicObject)sameEmpFile, adjSalFile, taskCenterMap, commonParams, result);
        }
    }

    private void dealWithSameDepEmpFile(DynamicObject adjSalFile, Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, Map<String, List<DynamicObject>> result) {
        DynamicObject existsAdjSalFile = AdjSalFileCollaHelper.getFileByTask(taskCenterMap, commonParams, false);
        if (!SWCObjectUtils.isEmpty((Object)existsAdjSalFile)) {
            DynamicObject person = AdjSalFileCollaHelper.getPersonById(commonParams, MapUtils.getLong(taskCenterMap, (Object)"personId"));
            String personName = null;
            String personNumber = null;
            if (!SWCObjectUtils.isEmpty((Object)person)) {
                personName = person.getString("name");
                personNumber = person.getString("number");
            }
            String status = existsAdjSalFile.getString("status");
            log.info("[colla]CollaAdjSalFileFlowInHandler dealWithSameDepEmpFile, AdjSalFile status is {}", (Object)status);
            if (StringUtils.equals((CharSequence)status, (CharSequence)"A") || StringUtils.equals((CharSequence)status, (CharSequence)"B")) {
                throw new KDBizException(ResManager.loadKDString((String)"{0}({1})\u7684\u5b9a\u8c03\u85aa\u6863\u6848({2})\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"AdjSalFileCollaHelper_4", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, existsAdjSalFile.getString("number")}));
            }
            if (StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
                DynamicObject depEmp = AdjSalFileCollaHelper.getDepEmpById(commonParams, MapUtils.getLong(taskCenterMap, (Object)"depEmpId"));
                String depEmpNum = SWCObjectUtils.isEmpty((Object)depEmp) ? null : depEmp.getString("number");
                String flowOutBsledString = MapUtils.getString(ruleEngineData, (Object)"hcdm_adjfileinfo_flowoutbsled");
                Date flowOutBsled = null;
                if (!SWCStringUtils.isEmpty((String)flowOutBsledString)) {
                    try {
                        flowOutBsled = SWCDateTimeUtils.parseDate((String)flowOutBsledString);
                    }
                    catch (ParseException ex) {
                        log.info("[colla] parse date error, date = {}", (Object)flowOutBsledString);
                        throw new KDBizException((Throwable)ex, new ErrorCode("dealSameEmployeeFile", ex.getMessage()), new Object[0]);
                    }
                }
                if (null == flowOutBsled) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u53d8\u52a8\u524d\u6863\u6848\u5931\u6548\u65e5\u671f\u201d\u4e3a\u7a7a\uff0c{0}({1})\u7684\u5c97\u4f4d({2}\uff09\u7684\u6863\u6848{3}\u5931\u6548\u5931\u8d25\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"CollaAdjSalFileFlowOutHandler_2", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, depEmpNum, existsAdjSalFile.getString("number")}));
                }
                existsAdjSalFile.set("bsled", (Object)flowOutBsled);
                List dynamicObjects = result.computeIfAbsent("DISABLE", item -> new ArrayList(10));
                dynamicObjects.add(existsAdjSalFile);
            }
        }
        CloudCollaContextHelper contextHelper = CloudCollaContextHelper.getInstance();
        contextHelper.parseAndSetCustomizeResultOnlyExistData(adjSalFile, commonParams, existsAdjSalFile);
        List dynamicObjects = result.computeIfAbsent("NEW", item -> new ArrayList(10));
        dynamicObjects.add(adjSalFile);
    }

    private static class Load {
        private static final CollaAdjSalFileDefaultHandler INSTANCE = new CollaAdjSalFileDefaultHandler();

        private Load() {
        }
    }
}

